/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.flame;

import com.badlogic.gdx.graphics.g3d.particles.batches.BillboardParticleBatch;
import com.badlogic.gdx.tools.flame.AlignModeWrapper;
import com.badlogic.gdx.tools.flame.BlendFunction;
import com.badlogic.gdx.tools.flame.EditorPanel;
import com.badlogic.gdx.tools.flame.FlameMain;
import com.badlogic.gdx.tools.flame.SortMode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BillboardBatchPanel
extends EditorPanel<BillboardParticleBatch> {
    JComboBox alignCombo;
    JCheckBox useGPUBox;
    JComboBox sortCombo;
    JComboBox srcBlendFunction;
    JComboBox destBlendFunction;

    public BillboardBatchPanel(FlameMain particleEditor3D, BillboardParticleBatch renderer) {
        super(particleEditor3D, "Billboard Batch", "Renderer used to draw billboards particles.");
        this.initializeComponents(renderer);
        this.setValue(renderer);
    }

    private void initializeComponents(BillboardParticleBatch renderer) {
        this.alignCombo = new JComboBox();
        this.alignCombo.setModel(new DefaultComboBoxModel<AlignModeWrapper>(AlignModeWrapper.values()));
        this.alignCombo.setSelectedItem((Object)AlignModeWrapper.find(renderer.getAlignMode()));
        this.alignCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AlignModeWrapper align2 = (AlignModeWrapper)((Object)BillboardBatchPanel.this.alignCombo.getSelectedItem());
                BillboardBatchPanel.this.editor.getBillboardBatch().setAlignMode(align2.mode);
            }
        });
        this.useGPUBox = new JCheckBox();
        this.useGPUBox.setSelected(renderer.isUseGPU());
        this.useGPUBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                BillboardBatchPanel.this.editor.getBillboardBatch().setUseGpu(BillboardBatchPanel.this.useGPUBox.isSelected());
            }
        });
        this.sortCombo = new JComboBox();
        this.sortCombo.setModel(new DefaultComboBoxModel<SortMode>(SortMode.values()));
        this.sortCombo.setSelectedItem((Object)SortMode.find(renderer.getSorter()));
        this.sortCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SortMode mode = (SortMode)((Object)BillboardBatchPanel.this.sortCombo.getSelectedItem());
                BillboardBatchPanel.this.editor.getBillboardBatch().setSorter(mode.sorter);
            }
        });
        this.srcBlendFunction = new JComboBox();
        this.srcBlendFunction.setModel(new DefaultComboBoxModel<BlendFunction>(BlendFunction.values()));
        this.srcBlendFunction.setSelectedItem((Object)BlendFunction.find(renderer.getBlendingAttribute().sourceFunction));
        this.srcBlendFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                BlendFunction blend = (BlendFunction)((Object)BillboardBatchPanel.this.srcBlendFunction.getSelectedItem());
                BillboardBatchPanel.this.editor.getBillboardBatch().getBlendingAttribute().sourceFunction = blend.blend;
            }
        });
        this.destBlendFunction = new JComboBox();
        this.destBlendFunction.setModel(new DefaultComboBoxModel<BlendFunction>(BlendFunction.values()));
        this.destBlendFunction.setSelectedItem((Object)BlendFunction.find(renderer.getBlendingAttribute().destFunction));
        this.destBlendFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                BlendFunction blend = (BlendFunction)((Object)BillboardBatchPanel.this.destBlendFunction.getSelectedItem());
                BillboardBatchPanel.this.editor.getBillboardBatch().getBlendingAttribute().destFunction = blend.blend;
            }
        });
        int i = 0;
        Insets insets = new Insets(6, 0, 0, 0);
        this.contentPanel.add((Component)new JLabel("Align"), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.contentPanel.add((Component)this.alignCombo, new GridBagConstraints(1, i++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.contentPanel.add((Component)new JLabel("Use GPU"), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.contentPanel.add((Component)this.useGPUBox, new GridBagConstraints(1, i++, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.contentPanel.add((Component)new JLabel("Sort"), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.contentPanel.add((Component)this.sortCombo, new GridBagConstraints(1, i++, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.contentPanel.add((Component)new JLabel("Blending Src"), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.contentPanel.add((Component)this.srcBlendFunction, new GridBagConstraints(1, i++, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.contentPanel.add((Component)new JLabel("Blending Dest"), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.contentPanel.add((Component)this.destBlendFunction, new GridBagConstraints(1, i++, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
    }
}

