/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.StringBuilder;

public class Align {
    public static final int center = 1;
    public static final int top = 2;
    public static final int bottom = 4;
    public static final int left = 8;
    public static final int right = 16;
    public static final int topLeft = 10;
    public static final int topRight = 18;
    public static final int bottomLeft = 12;
    public static final int bottomRight = 20;

    public static final boolean isLeft(int align2) {
        return (align2 & 8) != 0;
    }

    public static final boolean isRight(int align2) {
        return (align2 & 0x10) != 0;
    }

    public static final boolean isTop(int align2) {
        return (align2 & 2) != 0;
    }

    public static final boolean isBottom(int align2) {
        return (align2 & 4) != 0;
    }

    public static final boolean isCenterVertical(int align2) {
        return (align2 & 2) == 0 && (align2 & 4) == 0;
    }

    public static final boolean isCenterHorizontal(int align2) {
        return (align2 & 8) == 0 && (align2 & 0x10) == 0;
    }

    public static String toString(int align2) {
        StringBuilder buffer = new StringBuilder(13);
        if ((align2 & 2) != 0) {
            buffer.append("top,");
        } else if ((align2 & 4) != 0) {
            buffer.append("bottom,");
        } else {
            buffer.append("center,");
        }
        if ((align2 & 8) != 0) {
            buffer.append("left");
        } else if ((align2 & 0x10) != 0) {
            buffer.append("right");
        } else {
            buffer.append("center");
        }
        return buffer.toString();
    }
}

