/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.StringBuilder;
import java.util.NoSuchElementException;

public class LongQueue {
    protected long[] values;
    protected int head = 0;
    protected int tail = 0;
    public int size = 0;

    public LongQueue() {
        this(16);
    }

    public LongQueue(int initialSize) {
        this.values = new long[initialSize];
    }

    public void addLast(long value) {
        long[] values2 = this.values;
        if (this.size == values2.length) {
            this.resize(values2.length << 1);
            values2 = this.values;
        }
        values2[this.tail++] = value;
        if (this.tail == values2.length) {
            this.tail = 0;
        }
        ++this.size;
    }

    public void addFirst(long value) {
        long[] values2 = this.values;
        if (this.size == values2.length) {
            this.resize(values2.length << 1);
            values2 = this.values;
        }
        int head2 = this.head;
        if (--head2 == -1) {
            head2 = values2.length - 1;
        }
        values2[head2] = value;
        this.head = head2;
        ++this.size;
    }

    public void ensureCapacity(int additional) {
        int needed = this.size + additional;
        if (this.values.length < needed) {
            this.resize(needed);
        }
    }

    protected void resize(int newSize) {
        long[] values2 = this.values;
        int head2 = this.head;
        int tail = this.tail;
        long[] newArray = new long[newSize];
        if (head2 < tail) {
            System.arraycopy(values2, head2, newArray, 0, tail - head2);
        } else if (this.size > 0) {
            int rest = values2.length - head2;
            System.arraycopy(values2, head2, newArray, 0, rest);
            System.arraycopy(values2, 0, newArray, rest, tail);
        }
        this.values = newArray;
        this.head = 0;
        this.tail = this.size;
    }

    public long removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        long[] values2 = this.values;
        long result2 = values2[this.head];
        ++this.head;
        if (this.head == values2.length) {
            this.head = 0;
        }
        --this.size;
        return result2;
    }

    public long removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        long[] values2 = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values2.length - 1;
        }
        long result2 = values2[tail];
        this.tail = tail;
        --this.size;
        return result2;
    }

    public int indexOf(long value) {
        if (this.size == 0) {
            return -1;
        }
        long[] values2 = this.values;
        int head2 = this.head;
        int tail = this.tail;
        if (head2 < tail) {
            for (int i = head2; i < tail; ++i) {
                if (values2[i] != value) continue;
                return i - head2;
            }
        } else {
            int i;
            int n = values2.length;
            for (i = head2; i < n; ++i) {
                if (values2[i] != value) continue;
                return i - head2;
            }
            for (i = 0; i < tail; ++i) {
                if (values2[i] != value) continue;
                return i + values2.length - head2;
            }
        }
        return -1;
    }

    public boolean removeValue(long value) {
        int index = this.indexOf(value);
        if (index == -1) {
            return false;
        }
        this.removeIndex(index);
        return true;
    }

    public long removeIndex(int index) {
        long value;
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        long[] values2 = this.values;
        int head2 = this.head++;
        int tail = this.tail--;
        index += head2;
        if (head2 < tail) {
            value = values2[index];
            System.arraycopy(values2, index + 1, values2, index, tail - index);
        } else if (index >= values2.length) {
            value = values2[index -= values2.length];
            System.arraycopy(values2, index + 1, values2, index, tail - index);
            --this.tail;
        } else {
            value = values2[index];
            System.arraycopy(values2, head2, values2, head2 + 1, index - head2);
            if (this.head == values2.length) {
                this.head = 0;
            }
        }
        --this.size;
        return value;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public long first() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        return this.values[this.head];
    }

    public long last() {
        if (this.size == 0) {
            throw new NoSuchElementException("Queue is empty.");
        }
        long[] values2 = this.values;
        int tail = this.tail;
        if (--tail == -1) {
            tail = values2.length - 1;
        }
        return values2[tail];
    }

    public long get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index can't be < 0: " + index);
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int i = this.head + index;
        long[] values2 = this.values;
        if (i >= values2.length) {
            i -= values2.length;
        }
        return values2[i];
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.head = 0;
        this.tail = 0;
        this.size = 0;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        long[] values2 = this.values;
        int head2 = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append('[');
        sb.append(values2[head2]);
        int i = (head2 + 1) % values2.length;
        while (i != tail) {
            sb.append(", ").append(values2[i]);
            i = (i + 1) % values2.length;
        }
        sb.append(']');
        return sb.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        long[] values2 = this.values;
        int head2 = this.head;
        int tail = this.tail;
        StringBuilder sb = new StringBuilder(64);
        sb.append(values2[head2]);
        int i = (head2 + 1) % values2.length;
        while (i != tail) {
            sb.append(separator).append(values2[i]);
            i = (i + 1) % values2.length;
        }
        return sb.toString();
    }

    public int hashCode() {
        int size2 = this.size;
        long[] values2 = this.values;
        int backingLength = values2.length;
        int index = this.head;
        int hash = size2 + 1;
        for (int s = 0; s < size2; ++s) {
            long value = values2[index];
            hash += (int)(value ^ value >>> 32) * 31;
            if (++index != backingLength) continue;
            index = 0;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof LongQueue)) {
            return false;
        }
        LongQueue q = (LongQueue)o;
        int size2 = this.size;
        if (q.size != size2) {
            return false;
        }
        long[] myValues = this.values;
        int myBackingLength = myValues.length;
        long[] itsValues = q.values;
        int itsBackingLength = itsValues.length;
        int myIndex = this.head;
        int itsIndex = q.head;
        for (int s = 0; s < size2; ++s) {
            if (myValues[myIndex] != itsValues[itsIndex]) {
                return false;
            }
            ++itsIndex;
            if (++myIndex == myBackingLength) {
                myIndex = 0;
            }
            if (itsIndex != itsBackingLength) continue;
            itsIndex = 0;
        }
        return true;
    }
}

