/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.QuickSelect;
import java.util.Comparator;

public class Select {
    private static Select instance;
    private QuickSelect quickSelect;

    public static Select instance() {
        if (instance == null) {
            instance = new Select();
        }
        return instance;
    }

    public <T> T select(T[] items2, Comparator<T> comp, int kthLowest, int size2) {
        int idx = this.selectIndex(items2, comp, kthLowest, size2);
        return items2[idx];
    }

    public <T> int selectIndex(T[] items2, Comparator<T> comp, int kthLowest, int size2) {
        int idx;
        if (size2 < 1) {
            throw new GdxRuntimeException("cannot select from empty array (size < 1)");
        }
        if (kthLowest > size2) {
            throw new GdxRuntimeException("Kth rank is larger than size. k: " + kthLowest + ", size: " + size2);
        }
        if (kthLowest == 1) {
            idx = this.fastMin(items2, comp, size2);
        } else if (kthLowest == size2) {
            idx = this.fastMax(items2, comp, size2);
        } else {
            if (this.quickSelect == null) {
                this.quickSelect = new QuickSelect();
            }
            idx = this.quickSelect.select(items2, comp, kthLowest, size2);
        }
        return idx;
    }

    private <T> int fastMin(T[] items2, Comparator<T> comp, int size2) {
        int lowestIdx = 0;
        for (int i = 1; i < size2; ++i) {
            int comparison = comp.compare(items2[i], items2[lowestIdx]);
            if (comparison >= 0) continue;
            lowestIdx = i;
        }
        return lowestIdx;
    }

    private <T> int fastMax(T[] items2, Comparator<T> comp, int size2) {
        int highestIdx = 0;
        for (int i = 1; i < size2; ++i) {
            int comparison = comp.compare(items2[i], items2[highestIdx]);
            if (comparison <= 0) continue;
            highestIdx = i;
        }
        return highestIdx;
    }
}

