/*
 * Decompiled with CFR 0.152.
 */
package com.unciv;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Screen;
import com.unciv.GameStartScreen;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.files.Autosaves;
import com.unciv.logic.files.UncivFiles;
import com.unciv.logic.multiplayer.OnlineMultiplayer;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.skins.SkinCache;
import com.unciv.models.tilesets.TileSetCache;
import com.unciv.models.translations.Translations;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.crashhandling.CrashHandlingExtensionsKt;
import com.unciv.ui.crashhandling.CrashScreen;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.LanguagePickerScreen;
import com.unciv.ui.screens.LoadingScreen;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.mainmenuscreen.MainMenuScreen;
import com.unciv.ui.screens.savescreens.LoadGameScreen;
import com.unciv.ui.screens.worldscreen.PlayerReadyScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.AutoPlay;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.DebugUtils;
import com.unciv.utils.Display;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import com.unciv.utils.PlatformSpecific;
import java.io.Closeable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 j2\u00020\u00012\u00020\u0002:\u0002jkB\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010=\u001a\u00020<H\u0016J\b\u0010>\u001a\u00020<H\u0016J\n\u0010?\u001a\u0004\u0018\u00010+H\u0016J\u001c\u0010@\u001a\b\u0012\u0004\u0012\u00020+0A2\u000e\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0CJ\b\u0010D\u001a\u0004\u0018\u000106J\u0006\u0010E\u001a\u00020FJ\u000e\u0010G\u001a\u00020<2\u0006\u0010H\u001a\u00020IJ#\u0010J\u001a\u00020<2\b\u0010K\u001a\u0004\u0018\u00010\u00132\u0006\u0010L\u001a\u00020\u0013H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010MJ-\u0010N\u001a\u0002062\u0006\u0010L\u001a\u00020\u00132\b\b\u0002\u0010O\u001a\u00020P2\b\b\u0002\u0010Q\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010RJ\b\u0010S\u001a\u00020<H\u0002J\b\u0010T\u001a\u00020<H\u0016J\b\u0010U\u001a\u0004\u0018\u00010+J\u000e\u0010V\u001a\u00020<2\u0006\u0010W\u001a\u00020+J\u0011\u0010X\u001a\u00020<H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010YJ\u0016\u0010Z\u001a\u00020<2\u000e\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0CJ\b\u0010[\u001a\u00020<H\u0016J\u000e\u0010\\\u001a\u00020<2\u0006\u0010W\u001a\u00020+J\u0006\u0010]\u001a\u000206J\u0018\u0010^\u001a\u00020<2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020`H\u0016J\b\u0010b\u001a\u00020<H\u0016J\u0010\u0010c\u001a\u00020<2\u0006\u0010d\u001a\u00020+H\u0002J\u0010\u0010e\u001a\u00020<2\u0006\u0010f\u001a\u00020gH\u0017J\u0010\u0010e\u001a\u00020<2\u0006\u0010W\u001a\u00020+H\u0002J\b\u0010h\u001a\u00020iH\u0002R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0018R\u001e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u001a\u0010\u001b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u0005R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u00020-X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\"\u00107\u001a\u0004\u0018\u0001062\b\u0010\u0019\u001a\u0004\u0018\u000106@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006l"}, d2={"Lcom/unciv/UncivGame;", "Lcom/badlogic/gdx/Game;", "Lcom/unciv/utils/PlatformSpecific;", "isConsoleMode", "", "(Z)V", "deepLinkedMultiplayerGame", "", "getDeepLinkedMultiplayerGame", "()Ljava/lang/String;", "setDeepLinkedMultiplayerGame", "(Ljava/lang/String;)V", "files", "Lcom/unciv/logic/files/UncivFiles;", "getFiles", "()Lcom/unciv/logic/files/UncivFiles;", "setFiles", "(Lcom/unciv/logic/files/UncivFiles;)V", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "setGameInfo", "(Lcom/unciv/logic/GameInfo;)V", "()Z", "<set-?>", "isInitialized", "isTutorialTaskCollapsed", "setTutorialTaskCollapsed", "musicController", "Lcom/unciv/ui/audio/MusicController;", "getMusicController", "()Lcom/unciv/ui/audio/MusicController;", "setMusicController", "(Lcom/unciv/ui/audio/MusicController;)V", "onlineMultiplayer", "Lcom/unciv/logic/multiplayer/OnlineMultiplayer;", "getOnlineMultiplayer", "()Lcom/unciv/logic/multiplayer/OnlineMultiplayer;", "setOnlineMultiplayer", "(Lcom/unciv/logic/multiplayer/OnlineMultiplayer;)V", "screenStack", "Lkotlin/collections/ArrayDeque;", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "settings", "Lcom/unciv/models/metadata/GameSettings;", "getSettings", "()Lcom/unciv/models/metadata/GameSettings;", "setSettings", "(Lcom/unciv/models/metadata/GameSettings;)V", "translations", "Lcom/unciv/models/translations/Translations;", "getTranslations", "()Lcom/unciv/models/translations/Translations;", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "worldScreen", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "wrappedCrashHandlingRender", "Lkotlin/Function0;", "", "create", "dispose", "getScreen", "getScreensOfType", "Lkotlin/sequences/Sequence;", "clazz", "Lkotlin/reflect/KClass;", "getWorldScreenIfActive", "goToMainMenu", "Lcom/unciv/ui/screens/mainmenuscreen/MainMenuScreen;", "handleUncaughtThrowable", "ex", "", "initializeResources", "prevGameInfo", "newGameInfo", "(Lcom/unciv/logic/GameInfo;Lcom/unciv/logic/GameInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadGame", "autoPlay", "Lcom/unciv/ui/screens/worldscreen/unit/AutoPlay;", "callFromLoadScreen", "(Lcom/unciv/logic/GameInfo;Lcom/unciv/ui/screens/worldscreen/unit/AutoPlay;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logRunningThreads", "pause", "popScreen", "pushScreen", "newScreen", "reloadWorldscreen", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeScreensOfType", "render", "replaceCurrentScreen", "resetToWorldScreen", "resize", "width", "", "height", "resume", "setAsRootScreen", "root", "setScreen", "screen", "Lcom/badlogic/gdx/Screen;", "tryLoadDeepLinkedGame", "Lkotlinx/coroutines/Job;", "Companion", "Version", "core"})
@SourceDebugExtension(value={"SMAP\nUncivGame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncivGame.kt\ncom/unciv/UncivGame\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,515:1\n766#2:516\n857#2,2:517\n1855#2,2:522\n3792#3:519\n4307#3,2:520\n*S KotlinDebug\n*F\n+ 1 UncivGame.kt\ncom/unciv/UncivGame\n*L\n329#1:516\n329#1:517,2\n442#1:522,2\n442#1:519\n442#1:520,2\n*E\n"})
public class UncivGame
extends Game
implements PlatformSpecific {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isConsoleMode;
    @Nullable
    private String deepLinkedMultiplayerGame;
    @Nullable
    private GameInfo gameInfo;
    public GameSettings settings;
    public MusicController musicController;
    public OnlineMultiplayer onlineMultiplayer;
    public UncivFiles files;
    private boolean isTutorialTaskCollapsed;
    @Nullable
    private WorldScreen worldScreen;
    private boolean isInitialized;
    @NotNull
    private final Function0<Unit> wrappedCrashHandlingRender;
    @NotNull
    private final Translations translations;
    @NotNull
    private final ArrayDeque<BaseScreen> screenStack;
    @NotNull
    private static final Version VERSION = new Version("4.12.4", 1013);
    public static UncivGame Current;

    public UncivGame(boolean isConsoleMode) {
        this.isConsoleMode = isConsoleMode;
        this.wrappedCrashHandlingRender = CrashHandlingExtensionsKt.wrapCrashHandlingUnit(new Function0<Unit>(this){
            final /* synthetic */ UncivGame this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                UncivGame.access$render$s2211858(this.this$0);
            }
        });
        this.translations = new Translations();
        this.screenStack = new ArrayDeque();
    }

    public /* synthetic */ UncivGame(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean isConsoleMode() {
        return this.isConsoleMode;
    }

    @Nullable
    public final String getDeepLinkedMultiplayerGame() {
        return this.deepLinkedMultiplayerGame;
    }

    public final void setDeepLinkedMultiplayerGame(@Nullable String string) {
        this.deepLinkedMultiplayerGame = string;
    }

    @Nullable
    public final GameInfo getGameInfo() {
        return this.gameInfo;
    }

    public final void setGameInfo(@Nullable GameInfo gameInfo2) {
        this.gameInfo = gameInfo2;
    }

    @NotNull
    public final GameSettings getSettings() {
        GameSettings gameSettings = this.settings;
        if (gameSettings != null) {
            return gameSettings;
        }
        Intrinsics.throwUninitializedPropertyAccessException("settings");
        return null;
    }

    public final void setSettings(@NotNull GameSettings gameSettings) {
        Intrinsics.checkNotNullParameter(gameSettings, "<set-?>");
        this.settings = gameSettings;
    }

    @NotNull
    public final MusicController getMusicController() {
        MusicController musicController = this.musicController;
        if (musicController != null) {
            return musicController;
        }
        Intrinsics.throwUninitializedPropertyAccessException("musicController");
        return null;
    }

    public final void setMusicController(@NotNull MusicController musicController) {
        Intrinsics.checkNotNullParameter(musicController, "<set-?>");
        this.musicController = musicController;
    }

    @NotNull
    public final OnlineMultiplayer getOnlineMultiplayer() {
        OnlineMultiplayer onlineMultiplayer = this.onlineMultiplayer;
        if (onlineMultiplayer != null) {
            return onlineMultiplayer;
        }
        Intrinsics.throwUninitializedPropertyAccessException("onlineMultiplayer");
        return null;
    }

    public final void setOnlineMultiplayer(@NotNull OnlineMultiplayer onlineMultiplayer) {
        Intrinsics.checkNotNullParameter(onlineMultiplayer, "<set-?>");
        this.onlineMultiplayer = onlineMultiplayer;
    }

    @NotNull
    public final UncivFiles getFiles() {
        UncivFiles uncivFiles = this.files;
        if (uncivFiles != null) {
            return uncivFiles;
        }
        Intrinsics.throwUninitializedPropertyAccessException("files");
        return null;
    }

    public final void setFiles(@NotNull UncivFiles uncivFiles) {
        Intrinsics.checkNotNullParameter(uncivFiles, "<set-?>");
        this.files = uncivFiles;
    }

    public final boolean isTutorialTaskCollapsed() {
        return this.isTutorialTaskCollapsed;
    }

    public final void setTutorialTaskCollapsed(boolean bl) {
        this.isTutorialTaskCollapsed = bl;
    }

    @Nullable
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    protected final boolean isInitialized() {
        return this.isInitialized;
    }

    @NotNull
    public final Translations getTranslations() {
        return this.translations;
    }

    @Override
    public void create() {
        this.isInitialized = false;
        Gdx.input.setCatchKey(4, true);
        if (Gdx.app.getType() != Application.ApplicationType.Desktop) {
            DebugUtils.INSTANCE.setVISIBLE_MAP(false);
        }
        Companion.setCurrent(this);
        Files files2 = Gdx.files;
        Intrinsics.checkNotNullExpressionValue(files2, "files");
        this.setFiles(new UncivFiles(files2));
        this.setSettings(this.getFiles().getGeneralSettings());
        Display.INSTANCE.setScreenMode(this.getSettings().getScreenMode(), this.getSettings());
        this.setAsRootScreen(new GameStartScreen());
        this.setMusicController(new MusicController());
        this.installAudioHooks();
        this.setOnlineMultiplayer(new OnlineMultiplayer());
        Concurrency.run$default(Concurrency.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ UncivGame this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        try {
                            this.this$0.getOnlineMultiplayer().getMultiplayerServer().checkServerStatus();
                        }
                        catch (Exception ex) {
                            LogKt.debug("Couldn't connect to server: " + ex.getMessage(), new Object[0]);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        ImageGetter.INSTANCE.resetAtlases();
        ImageGetter.INSTANCE.reloadImages();
        Sequence<String> imageGetterTilesets = ImageGetter.INSTANCE.getAvailableTilesets();
        Set<String> availableTileSets = TileSetCache.INSTANCE.getAvailableTilesets(imageGetterTilesets);
        if (!availableTileSets.contains(this.getSettings().getTileSet())) {
            this.getSettings().setTileSet("HexaRealm");
        }
        Gdx.graphics.setContinuousRendering(this.getSettings().getContinuousRendering());
        Concurrency.run$default(Concurrency.INSTANCE, "LoadJSON", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ UncivGame this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        RulesetCache.loadRulesets$default(RulesetCache.INSTANCE, false, false, 3, null);
                        this.this$0.getTranslations().tryReadTranslationForCurrentLanguage();
                        this.this$0.getTranslations().loadPercentageCompleteOfLanguages();
                        TileSetCache.loadTileSetConfigs$default(TileSetCache.INSTANCE, false, 1, null);
                        SkinCache.loadSkinConfigs$default(SkinCache.INSTANCE, false, 1, null);
                        Ruleset vanillaRuleset2 = RulesetCache.INSTANCE.getVanillaRuleset();
                        if (((CharSequence)this.this$0.getSettings().getMultiplayer().getUserId()).length() == 0) {
                            GameSettings.GameSettingsMultiplayer gameSettingsMultiplayer = this.this$0.getSettings().getMultiplayer();
                            String string = UUID.randomUUID().toString();
                            Intrinsics.checkNotNullExpressionValue(string, "randomUUID().toString()");
                            gameSettingsMultiplayer.setUserId(string);
                            this.this$0.getSettings().save();
                        }
                        Fonts.INSTANCE.getFontImplementation().setFontFamily(this.this$0.getSettings().getFontFamilyData(), this.this$0.getSettings().getFontSize());
                        ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, vanillaRuleset2, null){
                            int label;
                            final /* synthetic */ UncivGame this$0;
                            final /* synthetic */ Ruleset $vanillaRuleset;
                            {
                                this.this$0 = $receiver;
                                this.$vanillaRuleset = $vanillaRuleset;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(object);
                                        BaseScreen.Companion.setSkin();
                                        MusicController musicController = this.this$0.getMusicController();
                                        String[] stringArray = new String[]{"Menu", "Ambient"};
                                        List<String> list2 = CollectionsKt.listOf(stringArray);
                                        EnumSet<Enum> enumSet = EnumSet.of((Enum)MusicTrackChooserFlags.SuffixMustMatch);
                                        Intrinsics.checkNotNullExpressionValue(enumSet, "of(MusicTrackChooserFlags.SuffixMustMatch)");
                                        MusicController.chooseTrack$default(musicController, null, list2, enumSet, 1, null);
                                        ImageGetter.INSTANCE.setRuleset(this.$vanillaRuleset);
                                        if (this.this$0.getSettings().isFreshlyCreated()) {
                                            UncivGame.access$setAsRootScreen(this.this$0, new LanguagePickerScreen());
                                        } else if (this.this$0.getDeepLinkedMultiplayerGame() == null) {
                                            UncivGame.access$setAsRootScreen(this.this$0, new MainMenuScreen());
                                        } else {
                                            UncivGame.access$tryLoadDeepLinkedGame(this.this$0);
                                        }
                                        UncivGame.access$setInitialized$p(this.this$0, true);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    @Nullable
    public final Object loadGame(@NotNull GameInfo newGameInfo, @NotNull AutoPlay autoPlay, boolean callFromLoadScreen, @NotNull Continuation<? super WorldScreen> $completion) {
        return ConcurrencyKt.withThreadPoolContext((Function2)new Function2<CoroutineScope, Continuation<? super WorldScreen>, Object>(this, newGameInfo, callFromLoadScreen, autoPlay, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ UncivGame this$0;
            final /* synthetic */ GameInfo $newGameInfo;
            final /* synthetic */ boolean $callFromLoadScreen;
            final /* synthetic */ AutoPlay $autoPlay;
            {
                this.this$0 = $receiver;
                this.$newGameInfo = $newGameInfo;
                this.$callFromLoadScreen = $callFromLoadScreen;
                this.$autoPlay = $autoPlay;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        prevGameInfo = this.this$0.getGameInfo();
                        this.this$0.setGameInfo(this.$newGameInfo);
                        v0 = this.this$0.getGameInfo();
                        v1 = v0 != null && (v0 = v0.getGameParameters()) != null ? v0.isOnlineMultiplayer() : false;
                        if (!v1) ** GOTO lbl30
                        v2 = this.this$0.getGameInfo();
                        v3 = v2 != null && (v2 = v2.getGameParameters()) != null ? !v2.getAnyoneCanSpectate() : false;
                        if (!v3) ** GOTO lbl30
                        v4 = this.this$0.getGameInfo();
                        Intrinsics.checkNotNull(v4);
                        var3_4 = v4.getCivilizations();
                        var4_6 = this.this$0;
                        $i$f$none = false;
                        if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl21
                        v5 = true;
                        ** GOTO lbl28
lbl21:
                        // 2 sources

                        for (T element$iv : $this$none$iv) {
                            it = (Civilization)element$iv;
                            $i$a$-none-UncivGame$loadGame$2$1 = false;
                            if (!Intrinsics.areEqual(it.getPlayerId(), var4_6.getSettings().getMultiplayer().getUserId())) continue;
                            v5 = false;
                            ** GOTO lbl28
                        }
                        v5 = true;
lbl28:
                        // 3 sources

                        if (v5) {
                            throw new UncivShowableException("You are not allowed to spectate!", null, 2, null);
                        }
lbl30:
                        // 4 sources

                        this.L$0 = prevGameInfo;
                        this.label = 1;
                        v6 = UncivGame.access$initializeResources(this.this$0, prevGameInfo, this.$newGameInfo, this);
                        if (v6 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl40
                    }
                    case 1: {
                        prevGameInfo = (GameInfo)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v6 = $result;
lbl40:
                        // 2 sources

                        v7 = isLoadingSameGame = this.this$0.getWorldScreen() != null && prevGameInfo != null && Intrinsics.areEqual(prevGameInfo.getGameId(), this.$newGameInfo.getGameId()) != false;
                        if (!this.$callFromLoadScreen && isLoadingSameGame) {
                            v8 = this.this$0.getWorldScreen();
                            Intrinsics.checkNotNull(v8);
                            v9 = v8.getRestoreState();
                        } else {
                            v9 = null;
                        }
                        worldScreenRestoreState = v9;
                        loadingScreen = new Ref.ObjectRef<LoadingScreen>();
                        this.L$0 = worldScreenRestoreState;
                        this.L$1 = loadingScreen;
                        this.label = 2;
                        v10 = ConcurrencyKt.withGLContext((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(loadingScreen, this.this$0, null){
                            int label;
                            final /* synthetic */ Ref.ObjectRef<LoadingScreen> $loadingScreen;
                            final /* synthetic */ UncivGame this$0;
                            {
                                this.$loadingScreen = $loadingScreen;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        LoadingScreen loadingScreen;
                                        ResultKt.throwOnFailure(object);
                                        this.$loadingScreen.element = new LoadingScreen(this.this$0.getScreen());
                                        if (this.$loadingScreen.element == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("loadingScreen");
                                            loadingScreen = null;
                                        } else {
                                            loadingScreen = (LoadingScreen)this.$loadingScreen.element;
                                        }
                                        UncivGame.access$setScreen(this.this$0, loadingScreen);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, this);
                        if (v10 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl61
                    }
                    case 2: {
                        loadingScreen = (Ref.ObjectRef<LoadingScreen>)this.L$1;
                        worldScreenRestoreState = (WorldScreen.RestoreState)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v10 = $result;
lbl61:
                        // 2 sources

                        this.L$0 = null;
                        this.L$1 = null;
                        this.label = 3;
                        v11 = ConcurrencyKt.withGLContext((Function2)new Function2<CoroutineScope, Continuation<? super WorldScreen>, Object>(this.this$0, this.$newGameInfo, this.$autoPlay, worldScreenRestoreState, loadingScreen, null){
                            int label;
                            final /* synthetic */ UncivGame this$0;
                            final /* synthetic */ GameInfo $newGameInfo;
                            final /* synthetic */ AutoPlay $autoPlay;
                            final /* synthetic */ WorldScreen.RestoreState $worldScreenRestoreState;
                            final /* synthetic */ Ref.ObjectRef<LoadingScreen> $loadingScreen;
                            {
                                this.this$0 = $receiver;
                                this.$newGameInfo = $newGameInfo;
                                this.$autoPlay = $autoPlay;
                                this.$worldScreenRestoreState = $worldScreenRestoreState;
                                this.$loadingScreen = $loadingScreen;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        LoadingScreen loadingScreen;
                                        int n;
                                        ResultKt.throwOnFailure(object);
                                        for (BaseScreen screen : UncivGame.access$getScreenStack$p(this.this$0)) {
                                            screen.dispose();
                                        }
                                        UncivGame.access$getScreenStack$p(this.this$0).clear();
                                        UncivGame.access$setWorldScreen$p(this.this$0, null);
                                        WorldScreen newWorldScreen2 = new WorldScreen(this.$newGameInfo, this.$autoPlay, this.$newGameInfo.getPlayerToViewAs(), this.$worldScreenRestoreState);
                                        UncivGame.access$setWorldScreen$p(this.this$0, newWorldScreen2);
                                        Iterable $this$count$iv = this.$newGameInfo.getCivilizations();
                                        boolean $i$f$count = false;
                                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                            n = 0;
                                        } else {
                                            int count$iv = 0;
                                            for (T element$iv : $this$count$iv) {
                                                Civilization it = (Civilization)element$iv;
                                                boolean bl = false;
                                                if (!(it.getPlayerType() == PlayerType.Human) || ++count$iv >= 0) continue;
                                                CollectionsKt.throwCountOverflow();
                                            }
                                            n = count$iv;
                                        }
                                        boolean moreThanOnePlayer = n > 1;
                                        boolean isSingleplayer = !this.$newGameInfo.getGameParameters().isOnlineMultiplayer();
                                        BaseScreen screenToShow = moreThanOnePlayer && isSingleplayer ? (BaseScreen)new PlayerReadyScreen(newWorldScreen2) : (BaseScreen)newWorldScreen2;
                                        UncivGame.access$getScreenStack$p(this.this$0).addLast(screenToShow);
                                        UncivGame.access$setScreen(this.this$0, screenToShow);
                                        if (this.$loadingScreen.element == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("loadingScreen");
                                            loadingScreen = null;
                                        } else {
                                            loadingScreen = (LoadingScreen)this.$loadingScreen.element;
                                        }
                                        loadingScreen.dispose();
                                        return newWorldScreen2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super WorldScreen> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, this);
                        if (v11 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl71
                    }
                    case 3: {
                        ResultKt.throwOnFailure($result);
                        v11 = $result;
lbl71:
                        // 2 sources

                        return v11;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super WorldScreen> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    public static /* synthetic */ Object loadGame$default(UncivGame uncivGame, GameInfo gameInfo2, AutoPlay autoPlay, boolean bl, Continuation continuation2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadGame");
        }
        if ((n & 2) != 0) {
            autoPlay = new AutoPlay(uncivGame.getSettings().getAutoPlay());
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return uncivGame.loadGame(gameInfo2, autoPlay, bl, continuation2);
    }

    /*
     * Unable to fully structure code
     */
    private final Object initializeResources(GameInfo var1_1, GameInfo var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof initializeResources.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ UncivGame this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UncivGame.access$initializeResources(this.this$0, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                if (prevGameInfo != null && Intrinsics.areEqual(prevGameInfo.getGameParameters().getBaseRuleset(), newGameInfo.getGameParameters().getBaseRuleset()) && Intrinsics.areEqual(prevGameInfo.getGameParameters().getMods(), newGameInfo.getGameParameters().getMods())) ** GOTO lbl27
                $continuation.L$0 = this;
                $continuation.L$1 = newGameInfo;
                $continuation.label = 1;
                v0 = ConcurrencyKt.withGLContext((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(newGameInfo, null){
                    int label;
                    final /* synthetic */ GameInfo $newGameInfo;
                    {
                        this.$newGameInfo = $newGameInfo;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                ImageGetter.INSTANCE.setNewRuleset(this.$newGameInfo.getRuleset());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                newGameInfo = (GameInfo)$continuation.L$1;
                this = (UncivGame)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl25:
                // 2 sources

                fullModList = newGameInfo.getGameParameters().getModsAndBaseRuleset();
                this.getMusicController().setModList((HashSet<String>)fullModList);
lbl27:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object reloadWorldscreen(@NotNull Continuation<? super Unit> $completion) {
        WorldScreen curWorldScreen = this.worldScreen;
        GameInfo curGameInfo = this.gameInfo;
        if (curWorldScreen == null || curGameInfo == null) {
            return Unit.INSTANCE;
        }
        Object object = UncivGame.loadGame$default(this, curGameInfo, null, false, $completion, 6, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Deprecated(message="Never use this, it's only here because it's part of the gdx.Game interface.", replaceWith=@ReplaceWith(expression="pushScreen", imports={}))
    public void setScreen(@NotNull Screen screen) {
        Intrinsics.checkNotNullParameter(screen, "screen");
        throw new UnsupportedOperationException("Use pushScreen or replaceCurrentScreen instead");
    }

    @Override
    @Nullable
    public BaseScreen getScreen() {
        Screen screen = super.getScreen();
        return screen instanceof BaseScreen ? (BaseScreen)screen : null;
    }

    private final void setScreen(BaseScreen newScreen) {
        Object[] objectArray = new Object[]{newScreen, this.screenStack};
        LogKt.debug("Setting new screen: %s, screenStack: %s", objectArray);
        Gdx.input.setInputProcessor(newScreen.getStage());
        super.setScreen(newScreen);
        if (newScreen instanceof WorldScreen) {
            ((WorldScreen)newScreen).setShouldUpdate(true);
        }
        Gdx.graphics.requestRendering();
    }

    private final void setAsRootScreen(BaseScreen root) {
        for (BaseScreen screen : this.screenStack) {
            screen.dispose();
        }
        this.screenStack.clear();
        this.screenStack.addLast(root);
        this.setScreen(root);
    }

    public final void pushScreen(@NotNull BaseScreen newScreen) {
        Intrinsics.checkNotNullParameter(newScreen, "newScreen");
        this.screenStack.addLast(newScreen);
        this.setScreen(newScreen);
    }

    @Nullable
    public final BaseScreen popScreen() {
        if (this.screenStack.size() == 1) {
            MusicController.pause$default(this.getMusicController(), 0.0f, 1, null);
            Object object = this.worldScreen;
            if (object != null && (object = ((WorldScreen)object).getAutoPlay()) != null) {
                ((AutoPlay)object).stopAutoPlay();
            }
            new ConfirmPopup(this.screenStack.last(), "Do you want to exit the game?", "Exit", false, (Function0)new Function0<Unit>(this){
                final /* synthetic */ UncivGame this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    MusicController.resume$default(this.this$0.getMusicController(), 0.0f, 1, null);
                }
            }, (Function0)popScreen.2.INSTANCE, 8, null).open(true);
            return null;
        }
        BaseScreen oldScreen = this.screenStack.removeLast();
        BaseScreen newScreen = this.screenStack.last();
        this.setScreen(newScreen);
        newScreen.resume();
        oldScreen.dispose();
        return newScreen;
    }

    public final void replaceCurrentScreen(@NotNull BaseScreen newScreen) {
        Intrinsics.checkNotNullParameter(newScreen, "newScreen");
        BaseScreen oldScreen = this.screenStack.removeLast();
        this.screenStack.addLast(newScreen);
        this.setScreen(newScreen);
        oldScreen.dispose();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WorldScreen resetToWorldScreen() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.screenStack;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BaseScreen it = (BaseScreen)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof WorldScreen))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (BaseScreen screen : (List)destination$iv$iv) {
            screen.dispose();
        }
        CollectionsKt.removeAll((List)this.screenStack, (Function1)resetToWorldScreen.2.INSTANCE);
        BaseScreen baseScreen = this.screenStack.last();
        Intrinsics.checkNotNull(baseScreen, "null cannot be cast to non-null type com.unciv.ui.screens.worldscreen.WorldScreen");
        WorldScreen worldScreen = (WorldScreen)baseScreen;
        Ruleset ruleset2 = worldScreen.getGameInfo().getRuleset();
        this.translations.setTranslationActiveMods(ruleset2.getMods());
        ImageGetter.INSTANCE.setNewRuleset(ruleset2);
        this.setScreen(worldScreen);
        return worldScreen;
    }

    @NotNull
    public final Sequence<BaseScreen> getScreensOfType(@NotNull KClass<? extends BaseScreen> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.screenStack), (Function1)new Function1<BaseScreen, Boolean>(clazz){
            final /* synthetic */ KClass<? extends BaseScreen> $clazz;
            {
                this.$clazz = $clazz;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull BaseScreen it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(Reflection.getOrCreateKotlinClass(it.getClass()), this.$clazz);
            }
        });
    }

    public final void removeScreensOfType(@NotNull KClass<? extends BaseScreen> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        List<BaseScreen> toRemove = SequencesKt.toList(this.getScreensOfType(clazz));
        for (BaseScreen screen : toRemove) {
            screen.dispose();
        }
        this.screenStack.removeAll((Collection<Object>)toRemove);
    }

    private final Job tryLoadDeepLinkedGame() {
        return Concurrency.run$default(Concurrency.INSTANCE, "LoadDeepLinkedGame", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ UncivGame this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$run = (CoroutineScope)this.L$0;
                        if (this.this$0.getDeepLinkedMultiplayerGame() == null) {
                            return Unit.INSTANCE;
                        }
                        ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ UncivGame this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(object);
                                        if (UncivGame.access$getScreenStack$p(this.this$0).isEmpty() || !(UncivGame.access$getScreenStack$p(this.this$0).get(0) instanceof GameStartScreen)) {
                                            BaseScreen baseScreen = this.this$0.getScreen();
                                            Intrinsics.checkNotNull(baseScreen);
                                            UncivGame.access$setAsRootScreen(this.this$0, new LoadingScreen(baseScreen));
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        v0 = this.this$0.getOnlineMultiplayer();
                        v1 = this.this$0.getDeepLinkedMultiplayerGame();
                        Intrinsics.checkNotNull(v1);
                        this.L$0 = $this$run;
                        this.label = 1;
                        v2 = v0.loadGame(v1, (Continuation<? super WorldScreen>)this);
                        ** if (v2 != var4_2) goto lbl20
lbl19:
                        // 1 sources

                        return var4_2;
lbl20:
                        // 1 sources

                        ** GOTO lbl27
                    }
                    case 1: {
                        $this$run = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure($result);
                            v2 = $result;
lbl27:
                            // 2 sources

                            this.this$0.setDeepLinkedMultiplayerGame(null);
                        }
                        catch (Exception ex) {
                            ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, ex, null){
                                int label;
                                final /* synthetic */ UncivGame this$0;
                                final /* synthetic */ Exception $ex;
                                {
                                    this.this$0 = $receiver;
                                    this.$ex = $ex;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            MainMenuScreen mainMenu = new MainMenuScreen();
                                            this.this$0.replaceCurrentScreen(mainMenu);
                                            Popup popup2 = new Popup(mainMenu, null, 0.0f, 6, null);
                                            String message2 = (String)LoadGameScreen.Companion.getLoadExceptionMessage$default(LoadGameScreen.Companion, this.$ex, null, 2, null).component1();
                                            Popup.addGoodSizedLabel$default(popup2, message2, 0, false, 6, null);
                                            popup2.row();
                                            Popup.addCloseButton$default(popup2, null, null, null, null, 15, null);
                                            Popup.open$default(popup2, false, 1, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                    }
                    {
                        finally {
                            this.this$0.setDeepLinkedMultiplayerGame(null);
                        }
                    }
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    @Override
    public void resume() {
        super.resume();
        if (!this.isInitialized) {
            return;
        }
        MusicController.resume$default(this.getMusicController(), 0.0f, 1, null);
        this.tryLoadDeepLinkedGame();
    }

    @Override
    public void pause() {
        GameInfo curGameInfo;
        if (this.musicController != null) {
            MusicController.pause$default(this.getMusicController(), 0.0f, 1, null);
        }
        if ((curGameInfo = this.gameInfo) != null) {
            Autosaves.requestAutoSave$default(this.getFiles().getAutosaves(), curGameInfo, false, 2, null);
        }
        super.pause();
    }

    @Override
    public void resize(int width, int height) {
        this.screen.resize(width, height);
    }

    @Override
    public void render() {
        this.wrappedCrashHandlingRender.invoke();
    }

    @Override
    public void dispose() {
        GameInfo curGameInfo;
        Gdx.input.setInputProcessor(null);
        SoundPlayer.INSTANCE.clearCache();
        if (this.musicController != null) {
            this.getMusicController().gracefulShutdown();
        }
        if (this.onlineMultiplayer != null) {
            Job.DefaultImpls.cancel$default(this.getOnlineMultiplayer().getMultiplayerGameUpdater(), null, 1, null);
        }
        if ((curGameInfo = this.gameInfo) != null) {
            Job autoSaveJob = this.getFiles().getAutosaves().getAutoSaveJob();
            if (autoSaveJob != null && autoSaveJob.isActive()) {
                Concurrency.runBlocking$default(Concurrency.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(autoSaveJob, null){
                    int label;
                    final /* synthetic */ Job $autoSaveJob;
                    {
                        this.$autoSaveJob = $autoSaveJob;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                this.label = 1;
                                Object object3 = this.$autoSaveJob.join(this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure($result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 3, null);
            } else {
                Autosaves.autoSave$default(this.getFiles().getAutosaves(), curGameInfo, false, 2, null);
            }
        }
        this.getSettings().save();
        Concurrency.INSTANCE.stopThreadPools();
        this.logRunningThreads();
    }

    /*
     * WARNING - void declaration
     */
    private final void logRunningThreads() {
        void $this$filterTo$iv$iv;
        int numThreads = Thread.activeCount();
        int n = 0;
        Thread[] threadArray = new Thread[numThreads];
        while (n < numThreads) {
            int n2 = n++;
            threadArray[n2] = new Thread();
        }
        Thread[] threadList = threadArray;
        Thread.enumerate(threadList);
        Thread[] $this$filter$iv = threadList;
        boolean $i$f$filter = false;
        Thread[] threadArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n3 = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n3; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(it != Thread.currentThread() && !Intrinsics.areEqual(it.getName(), "DestroyJavaVM"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Thread it = (Thread)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getName()};
            LogKt.debug("Thread %s still running in UncivGame.dispose().", objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleUncaughtThrowable(@NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter(ex, "ex");
        if (ex instanceof CancellationException) {
            return;
        }
        Log.INSTANCE.error("Uncaught throwable", ex);
        try {
            Closeable closeable = new PrintWriter(UncivFiles.fileWriter$default(this.getFiles(), "lasterror.txt", false, 2, null));
            Throwable throwable = null;
            try {
                PrintWriter it = (PrintWriter)closeable;
                boolean bl = false;
                ex.printStackTrace(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        Gdx.app.postRunnable(() -> UncivGame.handleUncaughtThrowable$lambda$4(this, ex));
    }

    @Nullable
    public final WorldScreen getWorldScreenIfActive() {
        return Intrinsics.areEqual(this.screen, this.worldScreen) ? this.worldScreen : null;
    }

    @NotNull
    public final MainMenuScreen goToMainMenu() {
        GameInfo curGameInfo = this.gameInfo;
        if (curGameInfo != null) {
            Autosaves.requestAutoSaveUnCloned$default(this.getFiles().getAutosaves(), curGameInfo, false, 2, null);
        }
        MainMenuScreen mainMenuScreen = new MainMenuScreen();
        this.pushScreen(mainMenuScreen);
        return mainMenuScreen;
    }

    @Override
    public void notifyTurnStarted() {
        PlatformSpecific.DefaultImpls.notifyTurnStarted(this);
    }

    @Override
    public void installAudioHooks() {
        PlatformSpecific.DefaultImpls.installAudioHooks(this);
    }

    private static final void handleUncaughtThrowable$lambda$4(UncivGame this$0, Throwable $ex) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($ex, "$ex");
        this$0.setAsRootScreen(new CrashScreen($ex));
    }

    public UncivGame() {
        this(false, 1, null);
    }

    public static final /* synthetic */ void access$setAsRootScreen(UncivGame $this, BaseScreen root) {
        $this.setAsRootScreen(root);
    }

    public static final /* synthetic */ Job access$tryLoadDeepLinkedGame(UncivGame $this) {
        return $this.tryLoadDeepLinkedGame();
    }

    public static final /* synthetic */ void access$setInitialized$p(UncivGame $this, boolean bl) {
        $this.isInitialized = bl;
    }

    public static final /* synthetic */ Object access$initializeResources(UncivGame $this, GameInfo prevGameInfo, GameInfo newGameInfo, Continuation $completion) {
        return $this.initializeResources(prevGameInfo, newGameInfo, $completion);
    }

    public static final /* synthetic */ void access$setScreen(UncivGame $this, BaseScreen newScreen) {
        $this.setScreen(newScreen);
    }

    public static final /* synthetic */ ArrayDeque access$getScreenStack$p(UncivGame $this) {
        return $this.screenStack;
    }

    public static final /* synthetic */ void access$setWorldScreen$p(UncivGame $this, WorldScreen worldScreen) {
        $this.worldScreen = worldScreen;
    }

    public static final /* synthetic */ void access$render$s2211858(UncivGame $this) {
        super.render();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/unciv/UncivGame$Companion;", "", "()V", "Current", "Lcom/unciv/UncivGame;", "getCurrent", "()Lcom/unciv/UncivGame;", "setCurrent", "(Lcom/unciv/UncivGame;)V", "VERSION", "Lcom/unciv/UncivGame$Version;", "getVERSION", "()Lcom/unciv/UncivGame$Version;", "getGameInfoOrNull", "Lcom/unciv/logic/GameInfo;", "isCurrentGame", "", "gameId", "", "isCurrentInitialized", "isDeepLinkedGameLoading", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Version getVERSION() {
            return VERSION;
        }

        @NotNull
        public final UncivGame getCurrent() {
            UncivGame uncivGame = Current;
            if (uncivGame != null) {
                return uncivGame;
            }
            Intrinsics.throwUninitializedPropertyAccessException("Current");
            return null;
        }

        public final void setCurrent(@NotNull UncivGame uncivGame) {
            Intrinsics.checkNotNullParameter(uncivGame, "<set-?>");
            Current = uncivGame;
        }

        public final boolean isCurrentInitialized() {
            return Current != null;
        }

        @Nullable
        public final GameInfo getGameInfoOrNull() {
            return this.isCurrentInitialized() ? this.getCurrent().getGameInfo() : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isCurrentGame(@NotNull String gameId) {
            Intrinsics.checkNotNullParameter(gameId, "gameId");
            if (!this.isCurrentInitialized()) return false;
            if (this.getCurrent().getGameInfo() == null) return false;
            GameInfo gameInfo2 = this.getCurrent().getGameInfo();
            Intrinsics.checkNotNull(gameInfo2);
            if (!Intrinsics.areEqual(gameInfo2.getGameId(), gameId)) return false;
            return true;
        }

        public final boolean isDeepLinkedGameLoading() {
            return this.isCurrentInitialized() && this.getCurrent().getDeepLinkedMultiplayerGame() != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00d6\u0001J\u0006\u0010\u0014\u001a\u00020\u0004J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/unciv/UncivGame$Version;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "()V", "text", "", "number", "", "(Ljava/lang/String;I)V", "getNumber", "()I", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toNiceString", "toString", "core"})
    public static final class Version
    implements IsPartOfGameInfoSerialization {
        @NotNull
        private final String text;
        private final int number;

        public Version(@NotNull String text2, int number) {
            Intrinsics.checkNotNullParameter(text2, "text");
            this.text = text2;
            this.number = number;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final int getNumber() {
            return this.number;
        }

        public Version() {
            this("", -1);
        }

        @NotNull
        public final String toNiceString() {
            return this.text + " (Build " + this.number + ')';
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        public final int component2() {
            return this.number;
        }

        @NotNull
        public final Version copy(@NotNull String text2, int number) {
            Intrinsics.checkNotNullParameter(text2, "text");
            return new Version(text2, number);
        }

        public static /* synthetic */ Version copy$default(Version version2, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = version2.text;
            }
            if ((n2 & 2) != 0) {
                n = version2.number;
            }
            return version2.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "Version(text=" + this.text + ", number=" + this.number + ')';
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.number);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Version)) {
                return false;
            }
            Version version2 = (Version)other;
            if (!Intrinsics.areEqual(this.text, version2.text)) {
                return false;
            }
            return this.number == version2.number;
        }
    }
}

