/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.unciv.app.desktop.DesktopDisplay;
import com.unciv.app.desktop.DesktopFont;
import com.unciv.app.desktop.DesktopGame;
import com.unciv.app.desktop.DesktopLogBackend;
import com.unciv.app.desktop.DesktopSaverLoader;
import com.unciv.app.desktop.DesktopScreenMode;
import com.unciv.app.desktop.HardenGdxAudio;
import com.unciv.app.desktop.ImagePacker;
import com.unciv.app.desktop.UiElementDocsWriter;
import com.unciv.app.desktop.UniqueDocsWriter;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.files.UncivFiles;
import com.unciv.models.metadata.GameSettings;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.utils.Display;
import com.unciv.utils.Log;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/unciv/app/desktop/DesktopLauncher;", "", "()V", "main", "", "arg", "", "", "([Ljava/lang/String;)V", "desktop"})
public final class DesktopLauncher {
    @NotNull
    public static final DesktopLauncher INSTANCE = new DesktopLauncher();

    private DesktopLauncher() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] arg) {
        Intrinsics.checkNotNullParameter(arg, "arg");
        Log.INSTANCE.setBackend(new DesktopLogBackend());
        Display.INSTANCE.setPlatform(new DesktopDisplay());
        Fonts.INSTANCE.setFontImplementation(new DesktopFont());
        UncivFiles.Companion.setSaverLoader(new DesktopSaverLoader());
        UncivFiles.Companion.setPreferExternalStorage(false);
        System.setProperty("org.lwjgl.opengl.Display.allowSoftwareOpenGL", "true");
        System.setProperty("org.lwjgl.system.stackSize", "384");
        boolean isRunFromJAR = INSTANCE.getClass().getPackage().getSpecificationVersion() != null;
        ImagePacker.INSTANCE.packImages(isRunFromJAR);
        Lwjgl3ApplicationConfiguration config2 = new Lwjgl3ApplicationConfiguration();
        String[] stringArray = new String[]{"ExtraImages/Icon.png"};
        config2.setWindowIcon(stringArray);
        config2.setTitle("Unciv");
        config2.setHdpiMode(HdpiMode.Logical);
        config2.setWindowSizeLimits(120, 80, -1, -1);
        Rectangle maximumWindowBounds = DesktopScreenMode.Companion.getMaximumWindowBounds$desktop$default(DesktopScreenMode.Companion, null, 1, null);
        GameSettings settings = UncivFiles.Companion.getSettingsForPlatformLaunchers$default(UncivFiles.Companion, null, 1, null);
        if (settings.isFreshlyCreated()) {
            settings.setScreenSize(GameSettings.ScreenSize.Large);
            settings.setWindowState(new GameSettings.WindowState(maximumWindowBounds));
            new FileHandle("GameSettings.json").writeString(UncivJsonKt.json().toJson(settings), false, Charsets.UTF_8.name());
        }
        GameSettings.WindowState windowState = settings.getWindowState().coerceIn(maximumWindowBounds);
        int width = windowState.component1();
        int height = windowState.component2();
        config2.setWindowedMode(width, height);
        config2.setInitialBackgroundColor(BaseScreen.Companion.getClearColor());
        if (!isRunFromJAR) {
            new UniqueDocsWriter().write();
            new UiElementDocsWriter().write();
        }
        new HardenGdxAudio(new DesktopGame(config2), config2);
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }
}

