/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.utils.ScreenMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0001\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\b\u0010\f\u001a\u00020\rH\u0016j\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0012"}, d2={"Lcom/unciv/app/desktop/DesktopScreenMode;", "", "Lcom/unciv/utils/ScreenMode;", "(Ljava/lang/String;I)V", "activate", "", "settings", "Lcom/unciv/models/metadata/GameSettings;", "getId", "", "setWindowedMode", "", "toString", "", "Windowed", "Fullscreen", "Borderless", "Companion", "desktop"})
public abstract class DesktopScreenMode
extends Enum<DesktopScreenMode>
implements ScreenMode {
    @NotNull
    public static final Companion Companion;
    public static final /* enum */ DesktopScreenMode Windowed;
    public static final /* enum */ DesktopScreenMode Fullscreen;
    public static final /* enum */ DesktopScreenMode Borderless;
    private static final /* synthetic */ DesktopScreenMode[] $VALUES;

    private DesktopScreenMode() {
    }

    @Override
    public int getId() {
        return this.ordinal();
    }

    @NotNull
    public String toString() {
        return TranslationsKt.tr$default(this.name(), false, 1, null);
    }

    public abstract void activate(@NotNull GameSettings var1);

    protected final boolean setWindowedMode(@NotNull GameSettings settings) {
        Intrinsics.checkNotNullParameter(settings, "settings");
        Rectangle maximumWindowBounds = com.unciv.app.desktop.DesktopScreenMode$Companion.getMaximumWindowBounds$desktop$default(Companion, null, 1, null);
        GameSettings.WindowState windowState = settings.getWindowState().coerceIn(maximumWindowBounds);
        int width = windowState.component1();
        int height = windowState.component2();
        Field $this$setWindowedMode_u24lambda_u240 = Lwjgl3Application.class.getDeclaredField("config");
        boolean bl = false;
        $this$setWindowedMode_u24lambda_u240.setAccessible(true);
        Object object = $this$setWindowedMode_u24lambda_u240.get(Gdx.app);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration");
        ((Lwjgl3ApplicationConfiguration)object).setWindowedMode(width, height);
        Gdx.graphics.setWindowedMode(width, height);
        return width == maximumWindowBounds.width && height == maximumWindowBounds.height;
    }

    @Override
    public boolean hasUserSelectableSize() {
        return ScreenMode.DefaultImpls.hasUserSelectableSize(this);
    }

    public static DesktopScreenMode[] values() {
        return (DesktopScreenMode[])$VALUES.clone();
    }

    public static DesktopScreenMode valueOf(String value) {
        return Enum.valueOf(DesktopScreenMode.class, value);
    }

    public /* synthetic */ DesktopScreenMode(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Windowed = new Windowed("Windowed", 0);
        Fullscreen = new Fullscreen("Fullscreen", 1);
        Borderless = new Borderless("Borderless", 2);
        $VALUES = desktopScreenModeArray = new DesktopScreenMode[]{DesktopScreenMode.Windowed, DesktopScreenMode.Fullscreen, DesktopScreenMode.Borderless};
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/app/desktop/DesktopScreenMode$Borderless;", "Lcom/unciv/app/desktop/DesktopScreenMode;", "activate", "", "settings", "Lcom/unciv/models/metadata/GameSettings;", "hasUserSelectableSize", "", "desktop"})
    static final class Borderless
    extends DesktopScreenMode {
        /*
         * WARNING - void declaration
         */
        Borderless() {
            void var1_1;
        }

        @Override
        public void activate(@NotNull GameSettings settings) {
            Intrinsics.checkNotNullParameter(settings, "settings");
            Lwjgl3Window lwjgl3Window = Companion.getWindow();
            if (lwjgl3Window != null) {
                lwjgl3Window.restoreWindow();
            }
            Gdx.graphics.setUndecorated(true);
            this.setWindowedMode(settings);
        }

        @Override
        public boolean hasUserSelectableSize() {
            return true;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\u0002J\u0017\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ \u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/unciv/app/desktop/DesktopScreenMode$Companion;", "", "()V", "get", "Lcom/unciv/app/desktop/DesktopScreenMode;", "id", "", "getMaximumWindowBounds", "Ljava/awt/Rectangle;", "monitor", "Lcom/badlogic/gdx/Graphics$Monitor;", "getMaximumWindowBounds$desktop", "device", "Ljava/awt/GraphicsDevice;", "config", "Ljava/awt/GraphicsConfiguration;", "bounds", "getWindow", "Lcom/badlogic/gdx/backends/lwjgl3/Lwjgl3Window;", "desktop"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DesktopScreenMode get(int id) {
            return DesktopScreenMode.values()[id];
        }

        private final Lwjgl3Window getWindow() {
            Graphics graphics = Gdx.graphics;
            Lwjgl3Graphics lwjgl3Graphics = graphics instanceof Lwjgl3Graphics ? (Lwjgl3Graphics)graphics : null;
            return lwjgl3Graphics != null ? lwjgl3Graphics.getWindow() : null;
        }

        @NotNull
        public final Rectangle getMaximumWindowBounds$desktop(@NotNull Graphics.Monitor monitor) {
            Intrinsics.checkNotNullParameter(monitor, "monitor");
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            Intrinsics.checkNotNullExpressionValue(graphicsDeviceArray, "graphicsEnvironment.screenDevices");
            for (GraphicsDevice device : graphicsDeviceArray) {
                GraphicsConfiguration[] graphicsConfigurationArray;
                Intrinsics.checkNotNullExpressionValue(device.getConfigurations(), "device.configurations");
                for (GraphicsConfiguration config2 : graphicsConfigurationArray) {
                    Rectangle bounds = config2.getBounds();
                    if (bounds.x != monitor.virtualX || bounds.y != monitor.virtualY) continue;
                    Intrinsics.checkNotNullExpressionValue(device, "device");
                    Intrinsics.checkNotNullExpressionValue(config2, "config");
                    Intrinsics.checkNotNullExpressionValue(bounds, "bounds");
                    return this.getMaximumWindowBounds(device, config2, bounds);
                }
            }
            Graphics.DisplayMode mode = Lwjgl3ApplicationConfiguration.getDisplayMode(monitor);
            return new Rectangle(monitor.virtualX, monitor.virtualY, mode.width, mode.height);
        }

        public static /* synthetic */ Rectangle getMaximumWindowBounds$desktop$default(Companion companion, Graphics.Monitor monitor, int n, Object object) {
            if ((n & 1) != 0) {
                Graphics.Monitor monitor2 = Lwjgl3ApplicationConfiguration.getPrimaryMonitor();
                Intrinsics.checkNotNullExpressionValue(monitor2, "getPrimaryMonitor()");
                monitor = monitor2;
            }
            return companion.getMaximumWindowBounds$desktop(monitor);
        }

        private final Rectangle getMaximumWindowBounds(GraphicsDevice device, GraphicsConfiguration config2, Rectangle bounds) {
            int displayWidth = device.getDisplayMode().getWidth();
            int displayHeight = device.getDisplayMode().getHeight();
            double scalePercent = (double)MathKt.roundToInt((double)displayWidth / (double)bounds.width * (double)100) * 0.01;
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(config2);
            int unscaledInsetLeft = MathKt.roundToInt((double)insets.left * scalePercent);
            int unscaledInsetRight = MathKt.roundToInt((double)insets.right * scalePercent);
            int unscaledInsetTop = MathKt.roundToInt((double)insets.top * scalePercent);
            int unscaledInsetBottom = MathKt.roundToInt((double)insets.bottom * scalePercent);
            return new Rectangle(bounds.x + unscaledInsetLeft, bounds.y + unscaledInsetTop, displayWidth - unscaledInsetLeft - unscaledInsetRight, displayHeight - unscaledInsetTop - unscaledInsetBottom);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/app/desktop/DesktopScreenMode$Fullscreen;", "Lcom/unciv/app/desktop/DesktopScreenMode;", "activate", "", "settings", "Lcom/unciv/models/metadata/GameSettings;", "hasUserSelectableSize", "", "desktop"})
    static final class Fullscreen
    extends DesktopScreenMode {
        /*
         * WARNING - void declaration
         */
        Fullscreen() {
            void var1_1;
        }

        @Override
        public void activate(@NotNull GameSettings settings) {
            Intrinsics.checkNotNullParameter(settings, "settings");
            Gdx.graphics.setFullscreenMode(Gdx.graphics.getDisplayMode());
        }

        @Override
        public boolean hasUserSelectableSize() {
            return false;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/unciv/app/desktop/DesktopScreenMode$Windowed;", "Lcom/unciv/app/desktop/DesktopScreenMode;", "activate", "", "settings", "Lcom/unciv/models/metadata/GameSettings;", "hasUserSelectableSize", "", "desktop"})
    static final class Windowed
    extends DesktopScreenMode {
        /*
         * WARNING - void declaration
         */
        Windowed() {
            void var1_1;
        }

        @Override
        public void activate(@NotNull GameSettings settings) {
            block1: {
                Intrinsics.checkNotNullParameter(settings, "settings");
                Gdx.graphics.setUndecorated(false);
                boolean isFillingDesktop = this.setWindowedMode(settings);
                if (!isFillingDesktop) break block1;
                Lwjgl3Window lwjgl3Window = Companion.getWindow();
                if (lwjgl3Window != null) {
                    lwjgl3Window.maximizeWindow();
                }
            }
        }

        @Override
        public boolean hasUserSelectableSize() {
            return true;
        }
    }
}

