/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.tools.texturepacker.TexturePacker;
import com.badlogic.gdx.utils.Json;
import com.unciv.app.desktop.ImagePacker;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J(\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J \u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/unciv/app/desktop/ImagePacker;", "", "()V", "atlasListFileName", "", "builtinAtlasDestinationPath", "builtinImageSourcePath", "existCheck2", "imageExtensions", "", "imagesPathBase", "modsBasePath", "settingsFileName", "suffixUsingLinear", "getDefaultSettings", "Lcom/badlogic/gdx/tools/texturepacker/TexturePacker$Settings;", "imageFolders", "Lkotlin/sequences/Sequence;", "Lcom/unciv/app/desktop/ImagePacker$ImageFolderResult;", "parent", "Ljava/io/File;", "packImages", "", "isRunFromJAR", "", "packImagesIfOutdated", "defaultSettings", "input", "output", "packFileName", "packImagesPerMod", "ImageFolderResult", "desktop"})
@SourceDebugExtension(value={"SMAP\nImagePacker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImagePacker.kt\ncom/unciv/app/desktop/ImagePacker\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,163:1\n2141#2,2:164\n*S KotlinDebug\n*F\n+ 1 ImagePacker.kt\ncom/unciv/app/desktop/ImagePacker\n*L\n135#1:164,2\n*E\n"})
public final class ImagePacker {
    @NotNull
    public static final ImagePacker INSTANCE = new ImagePacker();
    @NotNull
    private static final String builtinImageSourcePath = "..";
    @NotNull
    private static final String builtinAtlasDestinationPath = ".";
    @NotNull
    private static final String modsBasePath = "mods";
    @NotNull
    private static final String imagesPathBase = "Images";
    @NotNull
    private static final String existCheck2 = "Images.Icons";
    @NotNull
    private static final String settingsFileName = "TexturePacker.settings";
    @NotNull
    private static final String suffixUsingLinear = "Icons";
    @NotNull
    private static final String atlasListFileName = "Atlases.json";
    @NotNull
    private static final List<String> imageExtensions;

    private ImagePacker() {
    }

    private final TexturePacker.Settings getDefaultSettings() {
        TexturePacker.Settings settings;
        TexturePacker.Settings $this$getDefaultSettings_u24lambda_u240 = settings = new TexturePacker.Settings();
        boolean bl = false;
        $this$getDefaultSettings_u24lambda_u240.maxWidth = 2048;
        $this$getDefaultSettings_u24lambda_u240.maxHeight = 2048;
        $this$getDefaultSettings_u24lambda_u240.combineSubdirectories = true;
        $this$getDefaultSettings_u24lambda_u240.pot = true;
        $this$getDefaultSettings_u24lambda_u240.fast = true;
        $this$getDefaultSettings_u24lambda_u240.paddingX = 8;
        $this$getDefaultSettings_u24lambda_u240.paddingY = 8;
        $this$getDefaultSettings_u24lambda_u240.duplicatePadding = true;
        $this$getDefaultSettings_u24lambda_u240.filterMin = Texture.TextureFilter.MipMapLinearLinear;
        $this$getDefaultSettings_u24lambda_u240.filterMag = Texture.TextureFilter.MipMapLinearLinear;
        return settings;
    }

    public final void packImages(boolean isRunFromJAR) {
        File modDirectory;
        long startTime = System.currentTimeMillis();
        TexturePacker.Settings defaultSettings = this.getDefaultSettings();
        if (!isRunFromJAR) {
            this.packImagesPerMod(builtinImageSourcePath, builtinAtlasDestinationPath, defaultSettings);
        }
        if ((modDirectory = new File(modsBasePath)).exists()) {
            File[] fileArray = modDirectory.listFiles();
            Intrinsics.checkNotNull(fileArray);
            for (File mod : fileArray) {
                if (mod.isHidden()) continue;
                try {
                    String string = mod.getPath();
                    Intrinsics.checkNotNullExpressionValue(string, "mod.path");
                    String string2 = mod.getPath();
                    Intrinsics.checkNotNullExpressionValue(string2, "mod.path");
                    this.packImagesPerMod(string, string2, defaultSettings);
                }
                catch (Throwable ex) {
                    Object[] objectArray;
                    Throwable innerException = ex;
                    while (innerException.getCause() != null && innerException.getCause() != innerException) {
                        Intrinsics.checkNotNull(innerException.getCause());
                    }
                    if (innerException == ex) {
                        objectArray = new Object[]{ex.getMessage()};
                        Log.INSTANCE.error("Exception in ImagePacker: %s", objectArray);
                        continue;
                    }
                    objectArray = new Object[]{ex.getMessage(), innerException.getMessage()};
                    Log.INSTANCE.error("Exception in ImagePacker: %s (%s)", objectArray);
                }
            }
        }
        long texturePackingTime = System.currentTimeMillis() - startTime;
        Object[] objectArray = new Object[]{texturePackingTime};
        LogKt.debug("Packing textures - %sms", objectArray);
    }

    private final void packImagesPerMod(String input2, String output2, TexturePacker.Settings defaultSettings) {
        File baseDir = new File(input2);
        if (!new File(baseDir, imagesPathBase).exists() && !new File(baseDir, existCheck2).exists()) {
            return;
        }
        List atlasList = new ArrayList();
        Iterator<ImageFolderResult> iterator2 = this.imageFolders(baseDir).iterator();
        while (iterator2.hasNext()) {
            ImageFolderResult imageFolderResult = iterator2.next();
            String file = imageFolderResult.component1();
            String packFileName = imageFolderResult.component2();
            ((Collection)atlasList).add(packFileName);
            defaultSettings.filterMag = StringsKt.endsWith$default(file, suffixUsingLinear, false, 2, null) ? Texture.TextureFilter.Linear : Texture.TextureFilter.MipMapLinearLinear;
            this.packImagesIfOutdated(defaultSettings, file, output2, packFileName);
        }
        File listFile = new File(output2, atlasListFileName);
        if (atlasList.isEmpty()) {
            listFile.delete();
        } else {
            FilesKt.writeText$default(listFile, CollectionsKt.joinToString$default(CollectionsKt.sorted(atlasList), ",", "[", "]", 0, null, null, 56, null), null, 2, null);
        }
    }

    private final void packImagesIfOutdated(TexturePacker.Settings defaultSettings, String input2, String output2, String packFileName) {
        TexturePacker.Settings settings;
        File settingsFile;
        File atlasFile = new File(output2, packFileName + ".atlas");
        if (atlasFile.exists() && new File(output2, packFileName + ".png").exists()) {
            boolean bl;
            block5: {
                long atlasModTime = atlasFile.lastModified();
                Sequence<File> $this$none$iv = ImagePacker.packImagesIfOutdated$listTree(new File(input2));
                boolean $i$f$none = false;
                Iterator<File> iterator2 = $this$none$iv.iterator();
                while (iterator2.hasNext()) {
                    BasicFileAttributes attr;
                    File element$iv;
                    File it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(Files.readAttributes(it.toPath(), BasicFileAttributes.class, new LinkOption[0]), "readAttributes(it.toPath\u2026leAttributes::class.java)");
                    long createdAt = attr.creationTime().toMillis();
                    boolean bl3 = (imageExtensions.contains(FilesKt.getExtension(it)) || Intrinsics.areEqual(it.getName(), settingsFileName)) && (it.lastModified() > atlasModTime || createdAt > atlasModTime);
                    if (!bl3) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
            if (bl) {
                return;
            }
        }
        if ((settingsFile = new File(input2, settingsFileName)).exists()) {
            File file = settingsFile;
            Charset charset = Charsets.UTF_8;
            settings = new Json().fromJson(TexturePacker.Settings.class, new InputStreamReader((InputStream)new FileInputStream(file), charset));
        } else {
            settings = defaultSettings;
        }
        TexturePacker.Settings settings2 = settings;
        TexturePacker.process(settings2, input2, output2, packFileName);
    }

    private final Sequence<ImageFolderResult> imageFolders(File parent) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super ImageFolderResult>, Continuation<? super Unit>, Object>(parent, null){
            Object L$1;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ File $parent;
            {
                this.$parent = $parent;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        v0 = this.$parent.listFiles();
                        Intrinsics.checkNotNull(v0);
                        var3_4 = v0;
                        var4_5 = 0;
                        var5_6 = var3_4.length;
lbl11:
                        // 2 sources

                        while (var4_5 < var5_6) {
                            folder = var3_4[var4_5];
                            if (folder.isDirectory()) {
                                Intrinsics.checkNotNullExpressionValue(folder, "folder");
                                if (Intrinsics.areEqual(FilesKt.getNameWithoutExtension(folder), "Images")) {
                                    atlasName = Intrinsics.areEqual(folder.getName(), "Images") != false ? "game" : FilesKt.getExtension(folder);
                                    var8_9 = folder.getPath();
                                    Intrinsics.checkNotNullExpressionValue(var8_9, "folder.path");
                                    this.L$0 = $this$sequence;
                                    this.L$1 = var3_4;
                                    this.I$0 = var4_5;
                                    this.I$1 = var5_6;
                                    this.label = 1;
                                    v1 = $this$sequence.yield(new ImageFolderResult(var8_9, atlasName), this);
                                    if (v1 == var9_2) {
                                        return var9_2;
                                    }
                                }
                            }
                            ** GOTO lbl36
                        }
                        break;
                    }
                    case 1: {
                        var5_6 = this.I$1;
                        var4_5 = this.I$0;
                        var3_4 = (File[])this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl36:
                        // 2 sources

                        ++var4_5;
                        ** GOTO lbl11
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super ImageFolderResult>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super ImageFolderResult> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final Sequence<File> packImagesIfOutdated$listTree(File $this$packImagesIfOutdated_u24listTree) {
        Sequence<File> sequence;
        if ($this$packImagesIfOutdated_u24listTree.isFile()) {
            File[] fileArray = new File[]{$this$packImagesIfOutdated_u24listTree};
            sequence = SequencesKt.sequenceOf(fileArray);
        } else if ($this$packImagesIfOutdated_u24listTree.isDirectory()) {
            File[] fileArray = $this$packImagesIfOutdated_u24listTree.listFiles();
            Intrinsics.checkNotNull(fileArray);
            sequence = SequencesKt.flatMap(ArraysKt.asSequence(fileArray), packImagesIfOutdated.listTree.1.INSTANCE);
        } else {
            sequence = SequencesKt.sequenceOf(new File[0]);
        }
        return sequence;
    }

    public static final /* synthetic */ Sequence access$packImagesIfOutdated$listTree(File $receiver) {
        return ImagePacker.packImagesIfOutdated$listTree($receiver);
    }

    static {
        String[] stringArray = new String[]{"png", "jpg", "jpeg"};
        imageExtensions = CollectionsKt.listOf(stringArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/unciv/app/desktop/ImagePacker$ImageFolderResult;", "", "folder", "", "atlasName", "(Ljava/lang/String;Ljava/lang/String;)V", "getAtlasName", "()Ljava/lang/String;", "getFolder", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "desktop"})
    private static final class ImageFolderResult {
        @NotNull
        private final String folder;
        @NotNull
        private final String atlasName;

        public ImageFolderResult(@NotNull String folder, @NotNull String atlasName) {
            Intrinsics.checkNotNullParameter(folder, "folder");
            Intrinsics.checkNotNullParameter(atlasName, "atlasName");
            this.folder = folder;
            this.atlasName = atlasName;
        }

        @NotNull
        public final String getFolder() {
            return this.folder;
        }

        @NotNull
        public final String getAtlasName() {
            return this.atlasName;
        }

        @NotNull
        public final String component1() {
            return this.folder;
        }

        @NotNull
        public final String component2() {
            return this.atlasName;
        }

        @NotNull
        public final ImageFolderResult copy(@NotNull String folder, @NotNull String atlasName) {
            Intrinsics.checkNotNullParameter(folder, "folder");
            Intrinsics.checkNotNullParameter(atlasName, "atlasName");
            return new ImageFolderResult(folder, atlasName);
        }

        public static /* synthetic */ ImageFolderResult copy$default(ImageFolderResult imageFolderResult, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = imageFolderResult.folder;
            }
            if ((n & 2) != 0) {
                string2 = imageFolderResult.atlasName;
            }
            return imageFolderResult.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ImageFolderResult(folder=" + this.folder + ", atlasName=" + this.atlasName + ')';
        }

        public int hashCode() {
            int result2 = this.folder.hashCode();
            result2 = result2 * 31 + this.atlasName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ImageFolderResult)) {
                return false;
            }
            ImageFolderResult imageFolderResult = (ImageFolderResult)other;
            if (!Intrinsics.areEqual(this.folder, imageFolderResult.folder)) {
                return false;
            }
            return Intrinsics.areEqual(this.atlasName, imageFolderResult.atlasName);
        }
    }
}

