/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic;

import com.badlogic.gdx.Gdx;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.BackwardCompatibility;
import com.unciv.logic.CompatibilityVersion;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.HasGameInfoSerializationVersion;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.MissingModsException;
import com.unciv.logic.VictoryData;
import com.unciv.logic.automation.civilization.BarbarianManager;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.CivilizationInfoPreview;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.managers.TurnManager;
import com.unciv.logic.civilization.transients.CivInfoTransientCache;
import com.unciv.logic.github.Github;
import com.unciv.logic.map.CityDistanceData;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Religion;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.ModOptions;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.Speed;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.YearsPerTurn;
import com.unciv.models.ruleset.nation.Difficulty;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicMood;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.screens.savescreens.Gzip;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.status.NextTurnProgress;
import com.unciv.ui.screens.worldscreen.unit.AutoPlay;
import com.unciv.utils.DebugUtils;
import com.unciv.utils.LogKt;
import java.security.MessageDigest;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00ce\u00012\u00020\u00012\u00020\u0002:\u0002\u00ce\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0093\u0001\u001a\u00030\u0094\u00012\u0007\u0010\u0095\u0001\u001a\u00020\u00182\u000f\u0010\u0096\u0001\u001a\n\u0012\u0005\u0012\u00030\u0098\u00010\u0097\u0001H\u0002J-\u0010\u0099\u0001\u001a\u00030\u0094\u00012\u0007\u0010\u0095\u0001\u001a\u00020\u00182\u000f\u0010\u009a\u0001\u001a\n\u0012\u0005\u0012\u00030\u009b\u00010\u0097\u00012\u0007\u0010\u009c\u0001\u001a\u00020\u000bH\u0002J\b\u0010\u009d\u0001\u001a\u00030\u009e\u0001J\u0007\u0010\u009f\u0001\u001a\u00020\u000bJ\u0007\u0010\u00a0\u0001\u001a\u00020EJ\u0007\u0010\u00a1\u0001\u001a\u00020\u0000J\n\u0010\u00a2\u0001\u001a\u00030\u0094\u0001H\u0002J\u0012\u0010\u00a3\u0001\u001a\u00020\u00182\u0007\u0010\u00a4\u0001\u001a\u00020\u000bH\u0002J\u000e\u0010\u00a5\u0001\u001a\t\u0012\u0004\u0012\u00020\u00180\u0097\u0001J\u000e\u0010\u00a6\u0001\u001a\t\u0012\u0004\u0012\u00020\u00180\u0097\u0001J\u0007\u0010\u00a7\u0001\u001a\u00020\u0018J\u000f\u0010\u00a8\u0001\u001a\n\u0012\u0005\u0012\u00030\u0098\u00010\u00a9\u0001J\u0010\u0010\u00aa\u0001\u001a\u00020\u00182\u0007\u0010\u00ab\u0001\u001a\u00020\u000bJ\u000e\u0010\u00ac\u0001\u001a\t\u0012\u0005\u0012\u00030\u00ad\u00010\u001eJK\u0010\u00ae\u0001\u001a\t\u0012\u0004\u0012\u00020\u00180\u00a9\u00012\t\b\u0002\u0010\u00af\u0001\u001a\u00020E2\t\b\u0002\u0010\u00b0\u0001\u001a\u00020E2\u000b\b\u0002\u0010\u00b1\u0001\u001a\u0004\u0018\u00010\u00182\u0018\b\u0002\u0010\u00b2\u0001\u001a\u0011\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020E\u0018\u00010\u00b3\u0001J\u0007\u0010\u00b4\u0001\u001a\u00020\u0018J\u0006\u00105\u001a\u000208J\u0014\u0010\u00b5\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u000b\u0012\u0005\u0012\u00030\u00b6\u00010\u0017J\t\u0010\u00b7\u0001\u001a\u00020TH\u0002J@\u0010\u00b8\u0001\u001a\u0005\u0018\u00010\u00b9\u00012\u0007\u0010\u00ba\u0001\u001a\u00020\u00182\u0007\u0010\u00bb\u0001\u001a\u00020\u000b2\t\b\u0002\u0010\u00bc\u0001\u001a\u00020T2\u0017\b\u0002\u0010\u00bd\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u009b\u0001\u0012\u0004\u0012\u00020E0\u00b3\u0001J\u0007\u0010\u00be\u0001\u001a\u00020\u0018J\u0010\u0010\u00bf\u0001\u001a\u00020\u00182\u0007\u0010\u00a4\u0001\u001a\u00020\u000bJ\u0012\u0010\u00c0\u0001\u001a\u00020T2\t\b\u0002\u0010\u00c1\u0001\u001a\u00020TJ\u0007\u0010\u00c2\u0001\u001a\u00020EJ\u0007\u0010\u00c3\u0001\u001a\u00020EJ\u0007\u0010\u00c4\u0001\u001a\u00020EJ\u0016\u0010\u00c5\u0001\u001a\u00030\u0094\u00012\f\b\u0002\u0010\u00c6\u0001\u001a\u0005\u0018\u00010\u00c7\u0001J=\u0010\u00c8\u0001\u001a\u00020E2\u0007\u0010\u00c9\u0001\u001a\u00020\u00182\u0007\u0010\u00bb\u0001\u001a\u00020\u000b2\t\b\u0002\u0010\u00bc\u0001\u001a\u00020T2\u0017\b\u0002\u0010\u00bd\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u009b\u0001\u0012\u0004\u0012\u00020E0\u00b3\u0001J\u0013\u0010\u00ca\u0001\u001a\u00030\u0094\u00012\u0007\u0010\u0095\u0001\u001a\u00020\u0018H\u0002J\b\u0010\u00cb\u0001\u001a\u00030\u0094\u0001J\b\u0010\u00cc\u0001\u001a\u00030\u0094\u0001J\n\u0010\u00cd\u0001\u001a\u00030\u0094\u0001H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R'\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\r\"\u0004\b%\u0010\u000fR\u001a\u0010&\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001c\u00101\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\r\"\u0004\b3\u0010\u000fR\u001a\u00104\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\r\"\u0004\b6\u0010\u000fR\u001a\u00107\u001a\u000208X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R:\u0010=\u001a\"\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0>j\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b`?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u001a\u0010D\u001a\u00020EX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\r\"\u0004\bL\u0010\u000fR\u001a\u0010M\u001a\u00020NX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u001a\u0010S\u001a\u00020TX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010V\"\u0004\bW\u0010XR\u001a\u0010Y\u001a\u00020EX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010G\"\u0004\bZ\u0010IR\u001a\u0010[\u001a\u00020TX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\\\u0010V\"\u0004\b]\u0010XR\u001a\u0010^\u001a\u00020EX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u0010G\"\u0004\b`\u0010IR6\u0010a\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020b0>j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020b`?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010A\"\u0004\bd\u0010CR\u001a\u0010e\u001a\u00020fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR\u001a\u0010k\u001a\u00020TX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010V\"\u0004\bm\u0010XR\u001a\u0010n\u001a\u00020EX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bo\u0010G\"\u0004\bp\u0010IR*\u0010q\u001a\u0012\u0012\u0004\u0012\u00020\u000b0rj\b\u0012\u0004\u0012\u00020\u000b`sX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bt\u0010u\"\u0004\bv\u0010wR\u001a\u0010x\u001a\u00020yX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bz\u0010{\"\u0004\b|\u0010}R\u001e\u0010~\u001a\u00020\u007fX\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0080\u0001\u0010\u0081\u0001\"\u0006\b\u0082\u0001\u0010\u0083\u0001R\u001d\u0010\u0084\u0001\u001a\u00020TX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0085\u0001\u0010V\"\u0005\b\u0086\u0001\u0010XR \u0010\u0087\u0001\u001a\u00030\u0088\u0001X\u0096\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0089\u0001\u0010\u008a\u0001\"\u0006\b\u008b\u0001\u0010\u008c\u0001R\"\u0010\u008d\u0001\u001a\u0005\u0018\u00010\u008e\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u008f\u0001\u0010\u0090\u0001\"\u0006\b\u0091\u0001\u0010\u0092\u0001\u00a8\u0006\u00cf\u0001"}, d2={"Lcom/unciv/logic/GameInfo;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "Lcom/unciv/logic/HasGameInfoSerializationVersion;", "()V", "barbarians", "Lcom/unciv/logic/automation/civilization/BarbarianManager;", "getBarbarians", "()Lcom/unciv/logic/automation/civilization/BarbarianManager;", "setBarbarians", "(Lcom/unciv/logic/automation/civilization/BarbarianManager;)V", "checksum", "", "getChecksum", "()Ljava/lang/String;", "setChecksum", "(Ljava/lang/String;)V", "cityDistances", "Lcom/unciv/logic/map/CityDistanceData;", "getCityDistances", "()Lcom/unciv/logic/map/CityDistanceData;", "setCityDistances", "(Lcom/unciv/logic/map/CityDistanceData;)V", "civMap", "", "Lcom/unciv/logic/civilization/Civilization;", "getCivMap", "()Ljava/util/Map;", "civMap$delegate", "Lkotlin/Lazy;", "civilizations", "", "getCivilizations", "()Ljava/util/List;", "setCivilizations", "(Ljava/util/List;)V", "currentPlayer", "getCurrentPlayer", "setCurrentPlayer", "currentPlayerCiv", "getCurrentPlayerCiv", "()Lcom/unciv/logic/civilization/Civilization;", "setCurrentPlayerCiv", "(Lcom/unciv/logic/civilization/Civilization;)V", "currentTurnStartTime", "", "getCurrentTurnStartTime", "()J", "setCurrentTurnStartTime", "(J)V", "customSaveLocation", "getCustomSaveLocation", "setCustomSaveLocation", "difficulty", "getDifficulty", "setDifficulty", "difficultyObject", "Lcom/unciv/models/ruleset/nation/Difficulty;", "getDifficultyObject", "()Lcom/unciv/models/ruleset/nation/Difficulty;", "setDifficultyObject", "(Lcom/unciv/models/ruleset/nation/Difficulty;)V", "diplomaticVictoryVotesCast", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getDiplomaticVictoryVotesCast", "()Ljava/util/HashMap;", "setDiplomaticVictoryVotesCast", "(Ljava/util/HashMap;)V", "diplomaticVictoryVotesProcessed", "", "getDiplomaticVictoryVotesProcessed", "()Z", "setDiplomaticVictoryVotesProcessed", "(Z)V", "gameId", "getGameId", "setGameId", "gameParameters", "Lcom/unciv/models/metadata/GameParameters;", "getGameParameters", "()Lcom/unciv/models/metadata/GameParameters;", "setGameParameters", "(Lcom/unciv/models/metadata/GameParameters;)V", "historyStartTurn", "", "getHistoryStartTurn", "()I", "setHistoryStartTurn", "(I)V", "isUpToDate", "setUpToDate", "lastUnitId", "getLastUnitId", "setLastUnitId", "oneMoreTurnMode", "getOneMoreTurnMode", "setOneMoreTurnMode", "religions", "Lcom/unciv/models/Religion;", "getReligions", "setReligions", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "setRuleset", "(Lcom/unciv/models/ruleset/Ruleset;)V", "simulateMaxTurns", "getSimulateMaxTurns", "setSimulateMaxTurns", "simulateUntilWin", "getSimulateUntilWin", "setSimulateUntilWin", "spaceResources", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getSpaceResources", "()Ljava/util/HashSet;", "setSpaceResources", "(Ljava/util/HashSet;)V", "speed", "Lcom/unciv/models/ruleset/Speed;", "getSpeed", "()Lcom/unciv/models/ruleset/Speed;", "setSpeed", "(Lcom/unciv/models/ruleset/Speed;)V", "tileMap", "Lcom/unciv/logic/map/TileMap;", "getTileMap", "()Lcom/unciv/logic/map/TileMap;", "setTileMap", "(Lcom/unciv/logic/map/TileMap;)V", "turns", "getTurns", "setTurns", "version", "Lcom/unciv/logic/CompatibilityVersion;", "getVersion", "()Lcom/unciv/logic/CompatibilityVersion;", "setVersion", "(Lcom/unciv/logic/CompatibilityVersion;)V", "victoryData", "Lcom/unciv/logic/VictoryData;", "getVictoryData", "()Lcom/unciv/logic/VictoryData;", "setVictoryData", "(Lcom/unciv/logic/VictoryData;)V", "addBombardNotification", "", "thisPlayer", "cities", "", "Lcom/unciv/logic/city/City;", "addEnemyUnitNotification", "tiles", "Lcom/unciv/logic/map/tile/Tile;", "inOrNear", "asPreview", "Lcom/unciv/logic/GameInfoPreview;", "calculateChecksum", "checkForVictory", "clone", "convertOldSavesToNewSaves", "createTemporarySpectatorCiv", "playerId", "getAliveCityStates", "getAliveMajorCivs", "getBarbarianCivilization", "getCities", "Lkotlin/sequences/Sequence;", "getCivilization", "civName", "getCivilizationsAsPreviews", "Lcom/unciv/logic/civilization/CivilizationInfoPreview;", "getCivsSorted", "includeCityStates", "includeDefeated", "civToSortFirst", "additionalFilter", "Lkotlin/Function1;", "getCurrentPlayerCivilization", "getEnabledVictories", "Lcom/unciv/models/ruleset/Victory;", "getEquivalentTurn", "getExploredResourcesNotification", "Lcom/unciv/logic/civilization/Notification;", "civ", "resourceName", "maxDistance", "filter", "getPlayerToViewAs", "getSpectator", "getYear", "turnOffset", "isEspionageEnabled", "isReligionEnabled", "isSimulation", "nextTurn", "progressBar", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnProgress;", "notifyExploredResources", "civInfo", "notifyOfCloseEnemyUnits", "processDiplomaticVictory", "setTransients", "updateCivilizationState", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nGameInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameInfo.kt\ncom/unciv/logic/GameInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,786:1\n1747#2,3:787\n1549#2:790\n1620#2,3:791\n223#2,2:794\n1549#2:796\n1620#2,3:797\n766#2:800\n857#2,2:801\n766#2:803\n857#2,2:804\n288#2,2:806\n288#2,2:808\n1549#2:810\n1620#2,3:811\n766#2:814\n857#2:815\n858#2:818\n766#2:819\n857#2,2:820\n766#2:822\n857#2,2:823\n766#2:825\n857#2:826\n1747#2,3:827\n858#2:830\n1549#2:838\n1620#2,3:839\n819#2:842\n847#2,2:843\n223#2,2:845\n223#2,2:847\n1360#2:849\n1446#2,5:850\n766#2:855\n857#2,2:856\n1360#2:858\n1446#2,5:859\n1360#2:864\n1446#2,5:865\n288#2,2:871\n766#2:873\n857#2,2:874\n1747#2,3:876\n223#2,2:879\n1747#2,3:881\n223#2,2:884\n1229#3,2:816\n614#3:870\n515#4:831\n500#4,6:832\n*S KotlinDebug\n*F\n+ 1 GameInfo.kt\ncom/unciv/logic/GameInfo\n*L\n215#1:787,3\n216#1:790\n216#1:791,3\n233#1:794,2\n235#1:796\n235#1:797,3\n241#1:800\n241#1:801,2\n242#1:803\n242#1:804,2\n275#1:806,2\n316#1:808,2\n444#1:810\n444#1:811,3\n446#1:814\n446#1:815\n446#1:818\n456#1:819\n456#1:820,2\n462#1:822\n462#1:823,2\n468#1:825\n468#1:826\n470#1:827,3\n468#1:830\n616#1:838\n616#1:839,3\n628#1:842\n628#1:843,2\n655#1:845,2\n656#1:847,2\n670#1:849\n670#1:850,5\n677#1:855\n677#1:856,2\n678#1:858\n678#1:859,5\n679#1:864\n679#1:865,5\n739#1:871,2\n742#1:873\n742#1:874,2\n374#1:876,3\n375#1:879,2\n381#1:881,3\n382#1:884,2\n449#1:816,2\n695#1:870\n475#1:831\n475#1:832,6\n*E\n"})
public final class GameInfo
implements IsPartOfGameInfoSerialization,
HasGameInfoSerializationVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private CompatibilityVersion version = FIRST_WITHOUT;
    @NotNull
    private List<Civilization> civilizations = new ArrayList();
    @NotNull
    private BarbarianManager barbarians = new BarbarianManager();
    @NotNull
    private HashMap<String, Religion> religions = new HashMap();
    @NotNull
    private String difficulty = "Chieftain";
    @NotNull
    private TileMap tileMap = new TileMap(0, 1, null);
    @NotNull
    private GameParameters gameParameters = new GameParameters();
    private int turns;
    private boolean oneMoreTurnMode;
    @NotNull
    private String currentPlayer = "";
    private long currentTurnStartTime;
    @NotNull
    private String gameId;
    @NotNull
    private String checksum;
    private int lastUnitId;
    @Nullable
    private VictoryData victoryData;
    @NotNull
    private HashMap<String, String> diplomaticVictoryVotesCast;
    private boolean diplomaticVictoryVotesProcessed;
    private int historyStartTurn;
    @Nullable
    private volatile String customSaveLocation;
    public transient Difficulty difficultyObject;
    public transient Speed speed;
    public transient Civilization currentPlayerCiv;
    private transient boolean isUpToDate;
    public transient Ruleset ruleset;
    private transient int simulateMaxTurns;
    private transient boolean simulateUntilWin;
    @NotNull
    private transient HashSet<String> spaceResources;
    @NotNull
    private transient CityDistanceData cityDistances;
    @NotNull
    private final transient Lazy civMap$delegate;
    public static final int CURRENT_COMPATIBILITY_NUMBER = 4;
    @NotNull
    private static final CompatibilityVersion CURRENT_COMPATIBILITY_VERSION = new CompatibilityVersion(4, UncivGame.Companion.getVERSION());
    @NotNull
    private static final CompatibilityVersion FIRST_WITHOUT = new CompatibilityVersion(1, new UncivGame.Version("4.1.14", 731));

    public GameInfo() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue(string, "randomUUID().toString()");
        this.gameId = string;
        this.checksum = "";
        this.diplomaticVictoryVotesCast = new HashMap();
        this.historyStartTurn = -1;
        this.simulateMaxTurns = 1000;
        this.spaceResources = new HashSet();
        this.cityDistances = new CityDistanceData();
        this.civMap$delegate = LazyKt.lazy((Function0)new Function0<Map<String, ? extends Civilization>>(this){
            final /* synthetic */ GameInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, Civilization> invoke() {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = this.this$0.getCivilizations();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    Civilization civilization = (Civilization)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    map2.put(it.getCivName(), element$iv$iv);
                }
                return destination$iv$iv;
            }
        });
    }

    @Override
    @NotNull
    public CompatibilityVersion getVersion() {
        return this.version;
    }

    public void setVersion(@NotNull CompatibilityVersion compatibilityVersion) {
        Intrinsics.checkNotNullParameter(compatibilityVersion, "<set-?>");
        this.version = compatibilityVersion;
    }

    @NotNull
    public final List<Civilization> getCivilizations() {
        return this.civilizations;
    }

    public final void setCivilizations(@NotNull List<Civilization> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.civilizations = list2;
    }

    @NotNull
    public final BarbarianManager getBarbarians() {
        return this.barbarians;
    }

    public final void setBarbarians(@NotNull BarbarianManager barbarianManager) {
        Intrinsics.checkNotNullParameter(barbarianManager, "<set-?>");
        this.barbarians = barbarianManager;
    }

    @NotNull
    public final HashMap<String, Religion> getReligions() {
        return this.religions;
    }

    public final void setReligions(@NotNull HashMap<String, Religion> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.religions = hashMap;
    }

    @NotNull
    public final String getDifficulty() {
        return this.difficulty;
    }

    public final void setDifficulty(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.difficulty = string;
    }

    @NotNull
    public final TileMap getTileMap() {
        return this.tileMap;
    }

    public final void setTileMap(@NotNull TileMap tileMap) {
        Intrinsics.checkNotNullParameter(tileMap, "<set-?>");
        this.tileMap = tileMap;
    }

    @NotNull
    public final GameParameters getGameParameters() {
        return this.gameParameters;
    }

    public final void setGameParameters(@NotNull GameParameters gameParameters) {
        Intrinsics.checkNotNullParameter(gameParameters, "<set-?>");
        this.gameParameters = gameParameters;
    }

    public final int getTurns() {
        return this.turns;
    }

    public final void setTurns(int n) {
        this.turns = n;
    }

    public final boolean getOneMoreTurnMode() {
        return this.oneMoreTurnMode;
    }

    public final void setOneMoreTurnMode(boolean bl) {
        this.oneMoreTurnMode = bl;
    }

    @NotNull
    public final String getCurrentPlayer() {
        return this.currentPlayer;
    }

    public final void setCurrentPlayer(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.currentPlayer = string;
    }

    public final long getCurrentTurnStartTime() {
        return this.currentTurnStartTime;
    }

    public final void setCurrentTurnStartTime(long l) {
        this.currentTurnStartTime = l;
    }

    @NotNull
    public final String getGameId() {
        return this.gameId;
    }

    public final void setGameId(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.gameId = string;
    }

    @NotNull
    public final String getChecksum() {
        return this.checksum;
    }

    public final void setChecksum(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.checksum = string;
    }

    public final int getLastUnitId() {
        return this.lastUnitId;
    }

    public final void setLastUnitId(int n) {
        this.lastUnitId = n;
    }

    @Nullable
    public final VictoryData getVictoryData() {
        return this.victoryData;
    }

    public final void setVictoryData(@Nullable VictoryData victoryData) {
        this.victoryData = victoryData;
    }

    @NotNull
    public final HashMap<String, String> getDiplomaticVictoryVotesCast() {
        return this.diplomaticVictoryVotesCast;
    }

    public final void setDiplomaticVictoryVotesCast(@NotNull HashMap<String, String> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.diplomaticVictoryVotesCast = hashMap;
    }

    public final boolean getDiplomaticVictoryVotesProcessed() {
        return this.diplomaticVictoryVotesProcessed;
    }

    public final void setDiplomaticVictoryVotesProcessed(boolean bl) {
        this.diplomaticVictoryVotesProcessed = bl;
    }

    public final int getHistoryStartTurn() {
        return this.historyStartTurn;
    }

    public final void setHistoryStartTurn(int n) {
        this.historyStartTurn = n;
    }

    @Nullable
    public final String getCustomSaveLocation() {
        return this.customSaveLocation;
    }

    public final void setCustomSaveLocation(@Nullable String string) {
        this.customSaveLocation = string;
    }

    @NotNull
    public final Difficulty getDifficultyObject() {
        Difficulty difficulty = this.difficultyObject;
        if (difficulty != null) {
            return difficulty;
        }
        Intrinsics.throwUninitializedPropertyAccessException("difficultyObject");
        return null;
    }

    public final void setDifficultyObject(@NotNull Difficulty difficulty) {
        Intrinsics.checkNotNullParameter(difficulty, "<set-?>");
        this.difficultyObject = difficulty;
    }

    @NotNull
    public final Speed getSpeed() {
        Speed speed = this.speed;
        if (speed != null) {
            return speed;
        }
        Intrinsics.throwUninitializedPropertyAccessException("speed");
        return null;
    }

    public final void setSpeed(@NotNull Speed speed) {
        Intrinsics.checkNotNullParameter(speed, "<set-?>");
        this.speed = speed;
    }

    @NotNull
    public final Civilization getCurrentPlayerCiv() {
        Civilization civilization = this.currentPlayerCiv;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("currentPlayerCiv");
        return null;
    }

    public final void setCurrentPlayerCiv(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.currentPlayerCiv = civilization;
    }

    public final boolean isUpToDate() {
        return this.isUpToDate;
    }

    public final void setUpToDate(boolean bl) {
        this.isUpToDate = bl;
    }

    @NotNull
    public final Ruleset getRuleset() {
        Ruleset ruleset2 = this.ruleset;
        if (ruleset2 != null) {
            return ruleset2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("ruleset");
        return null;
    }

    public final void setRuleset(@NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(ruleset2, "<set-?>");
        this.ruleset = ruleset2;
    }

    public final int getSimulateMaxTurns() {
        return this.simulateMaxTurns;
    }

    public final void setSimulateMaxTurns(int n) {
        this.simulateMaxTurns = n;
    }

    public final boolean getSimulateUntilWin() {
        return this.simulateUntilWin;
    }

    public final void setSimulateUntilWin(boolean bl) {
        this.simulateUntilWin = bl;
    }

    @NotNull
    public final HashSet<String> getSpaceResources() {
        return this.spaceResources;
    }

    public final void setSpaceResources(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.spaceResources = hashSet;
    }

    @NotNull
    public final CityDistanceData getCityDistances() {
        return this.cityDistances;
    }

    public final void setCityDistances(@NotNull CityDistanceData cityDistanceData) {
        Intrinsics.checkNotNullParameter(cityDistanceData, "<set-?>");
        this.cityDistances = cityDistanceData;
    }

    @NotNull
    public final GameInfo clone() {
        GameInfo toReturn = new GameInfo();
        toReturn.tileMap = this.tileMap.clone();
        toReturn.civilizations = (List)SequencesKt.toCollection(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.civilizations), clone.1.INSTANCE), (Collection)new ArrayList(this.civilizations.size()));
        toReturn.barbarians = this.barbarians.clone();
        MapsKt.putAll((Map)toReturn.religions, SequencesKt.map(MapsKt.asSequence((Map)this.religions), clone.2.INSTANCE));
        toReturn.currentPlayer = this.currentPlayer;
        toReturn.currentTurnStartTime = this.currentTurnStartTime;
        toReturn.turns = this.turns;
        toReturn.difficulty = this.difficulty;
        toReturn.gameParameters = this.gameParameters;
        toReturn.gameId = this.gameId;
        toReturn.diplomaticVictoryVotesCast.putAll((Map<String, String>)this.diplomaticVictoryVotesCast);
        toReturn.oneMoreTurnMode = this.oneMoreTurnMode;
        toReturn.customSaveLocation = this.customSaveLocation;
        VictoryData victoryData = this.victoryData;
        toReturn.victoryData = victoryData != null ? VictoryData.copy$default(victoryData, null, null, 0, 7, null) : null;
        toReturn.historyStartTurn = this.historyStartTurn;
        toReturn.lastUnitId = this.lastUnitId;
        return toReturn;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Civilization getPlayerToViewAs() {
        boolean bl;
        String userId;
        block8: {
            if (!this.gameParameters.isOnlineMultiplayer()) {
                return this.getCurrentPlayerCivilization();
            }
            userId = UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getUserId();
            Iterable $this$any$iv = this.civilizations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getPlayerId(), userId)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$mapTo$iv$iv;
            Object element$iv;
            Iterable $this$map$iv = this.civilizations;
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Civilization civilization = (Civilization)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getCivName());
            }
            int civIndex = ((List)destination$iv$iv).indexOf(this.currentPlayer);
            while (true) {
                Civilization civToCheck;
                if (Intrinsics.areEqual((civToCheck = this.civilizations.get(civIndex % this.civilizations.size())).getPlayerId(), userId)) {
                    return civToCheck;
                }
                ++civIndex;
            }
        }
        return this.getSpectator(userId);
    }

    @NotNull
    public final Map<String, Civilization> getCivMap() {
        Lazy lazy = this.civMap$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final Civilization getCivilization(@NotNull String civName) {
        Intrinsics.checkNotNullParameter(civName, "civName");
        Civilization civilization = this.getCivMap().get(civName);
        if (civilization == null) {
            Object element$iv2;
            block2: {
                Iterable $this$first$iv = this.civilizations;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Civilization it = (Civilization)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getCivName(), civName)) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            civilization = (Civilization)element$iv2;
        }
        return civilization;
    }

    @NotNull
    public final Civilization getCurrentPlayerCivilization() {
        return this.getCurrentPlayerCiv();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CivilizationInfoPreview> getCivilizationsAsPreviews() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.civilizations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Civilization civilization = (Civilization)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asPreview());
        }
        return CollectionsKt.toMutableList((List)destination$iv$iv);
    }

    @NotNull
    public final Civilization getBarbarianCivilization() {
        return this.getCivilization("Barbarians");
    }

    @NotNull
    public final Difficulty getDifficulty() {
        return this.getDifficultyObject();
    }

    @NotNull
    public final Sequence<City> getCities() {
        return SequencesKt.flatMapIterable(CollectionsKt.asSequence((Iterable)this.civilizations), getCities.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Civilization> getAliveCityStates() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.civilizations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(it.isAlive() && it.isCityState())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Civilization> getAliveMajorCivs() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.civilizations;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(it.isAlive() && it.isMajorCiv())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Sequence<Civilization> getCivsSorted(boolean includeCityStates, boolean includeDefeated, @Nullable Civilization civToSortFirst, @Nullable Function1<? super Civilization, Boolean> additionalFilter) {
        Collator collator = GUI.INSTANCE.getSettings().getCollatorFromLocale();
        Comparator comparator = new Comparator(civToSortFirst){
            final /* synthetic */ Civilization $civToSortFirst$inlined;
            {
                this.$civToSortFirst$inlined = civilization;
            }

            public final int compare(T a, T b) {
                Civilization it = (Civilization)a;
                boolean bl = false;
                boolean bl2 = !Intrinsics.areEqual(it, this.$civToSortFirst$inlined);
                it = (Civilization)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues(comparable, !Intrinsics.areEqual(it, this.$civToSortFirst$inlined));
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Civilization it = (Civilization)b;
                    boolean bl = false;
                    Comparable comparable = Boolean.valueOf(it.isMajorCiv());
                    it = (Civilization)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, it.isMajorCiv());
                }
                return n;
            }
        };
        return SequencesKt.sortedWith(SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)this.civilizations), (Function1)new Function1<Civilization, Boolean>(includeDefeated, includeCityStates, additionalFilter){
            final /* synthetic */ boolean $includeDefeated;
            final /* synthetic */ boolean $includeCityStates;
            final /* synthetic */ Function1<Civilization, Boolean> $additionalFilter;
            {
                this.$includeDefeated = $includeDefeated;
                this.$includeCityStates = $includeCityStates;
                this.$additionalFilter = $additionalFilter;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, "it");
                if (!(it.isBarbarian() || it.isSpectator() || !this.$includeDefeated && it.isDefeated() || !this.$includeCityStates && it.isCityState())) {
                    Function1<Civilization, Boolean> function1 = this.$additionalFilter;
                    if (!(function1 != null ? !function1.invoke(it).booleanValue() : false)) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        }), new Comparator(comparator, collator){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Civilization civilization = (Civilization)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    Civilization it = (Civilization)b;
                    String string = TranslationsKt.tr(it.getCivName(), true);
                    bl = false;
                    String string2 = TranslationsKt.tr(it.getCivName(), true);
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        });
    }

    public static /* synthetic */ Sequence getCivsSorted$default(GameInfo gameInfo2, boolean bl, boolean bl2, Civilization civilization, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            civilization = null;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        return gameInfo2.getCivsSorted(bl, bl2, civilization, function1);
    }

    @NotNull
    public final Civilization getSpectator(@NotNull String playerId) {
        Civilization gameSpectatorCiv;
        Civilization civilization;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            Iterable $this$firstOrNull$iv = this.civilizations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl = false;
                if (!(it.isSpectator() && Intrinsics.areEqual(it.getPlayerId(), playerId))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((civilization = (gameSpectatorCiv = (Civilization)v0)) == null) {
            civilization = this.createTemporarySpectatorCiv(playerId);
        }
        return civilization;
    }

    private final Civilization createTemporarySpectatorCiv(String playerId) {
        Civilization civilization;
        Civilization it = civilization = new Civilization("Spectator");
        boolean bl = false;
        it.setPlayerType(PlayerType.Human);
        it.setPlayerId(playerId);
        this.civilizations.add(it);
        it.setGameInfo(this);
        it.setNationTransient();
        CivInfoTransientCache.updateViewableTiles$default(it.getCache(), null, 1, null);
        it.setTransients();
        return civilization;
    }

    public final boolean isReligionEnabled() {
        Era era2 = this.getRuleset().getEras().get(this.gameParameters.getStartingEra());
        Intrinsics.checkNotNull(era2);
        boolean religionDisabledByRuleset = IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)era2, UniqueType.DisablesReligion, null, 2, null) || IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)this.getRuleset().getModOptions(), UniqueType.DisableReligion, null, 2, null);
        return !religionDisabledByRuleset;
    }

    public final boolean isEspionageEnabled() {
        return this.gameParameters.getEspionageEnabled();
    }

    private final int getEquivalentTurn() {
        int totalTurns = this.getSpeed().numTotalTurns();
        Era era2 = this.getRuleset().getEras().get(this.gameParameters.getStartingEra());
        Intrinsics.checkNotNull(era2);
        int startPercent = era2.getStartPercent();
        return this.turns + totalTurns * startPercent / 100;
    }

    public final int getYear(int turnOffset) {
        int turn = this.getEquivalentTurn() + turnOffset;
        ArrayList<YearsPerTurn> yearsToTurn = this.getSpeed().getYearsPerTurn();
        float year2 = this.getSpeed().getStartYear();
        float yearsPerTurn2 = 0.0f;
        for (int i = 0; i < turn; ++i) {
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = yearsToTurn;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    YearsPerTurn it = (YearsPerTurn)element$iv;
                    boolean bl = false;
                    if (!(i < it.getUntilTurn())) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            YearsPerTurn yearsPerTurn3 = v0;
            yearsPerTurn2 = yearsPerTurn3 != null ? yearsPerTurn3.getYearInterval() : ((YearsPerTurn)CollectionsKt.last((List)yearsToTurn)).getYearInterval();
            year2 += yearsPerTurn2;
        }
        return (int)year2;
    }

    public static /* synthetic */ int getYear$default(GameInfo gameInfo2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return gameInfo2.getYear(n);
    }

    @NotNull
    public final String calculateChecksum() {
        String oldChecksum = this.checksum;
        this.checksum = "";
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        String string = UncivJsonKt.json().toJson(this);
        Intrinsics.checkNotNullExpressionValue(string, "json().toJson(this)");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        byte[] bytes = messageDigest.digest(byArray);
        this.checksum = oldChecksum;
        Intrinsics.checkNotNullExpressionValue(bytes, "bytes");
        return Gzip.INSTANCE.encode(bytes);
    }

    public final boolean isSimulation() {
        return this.turns < DebugUtils.INSTANCE.getSIMULATE_UNTIL_TURN() || this.turns < this.simulateMaxTurns && this.simulateUntilWin;
    }

    public final void nextTurn(@Nullable NextTurnProgress progressBar) {
        Ref.ObjectRef<Civilization> player = new Ref.ObjectRef<Civilization>();
        player.element = this.getCurrentPlayerCiv();
        Ref.IntRef playerIndex = new Ref.IntRef();
        playerIndex.element = this.civilizations.indexOf(player.element);
        if (((Civilization)player.element).isHuman()) {
            new TurnManager((Civilization)player.element).endTurn(progressBar);
            GameInfo.nextTurn$setNextPlayer(playerIndex, this, player);
        }
        boolean isOnline = this.gameParameters.isOnlineMultiplayer();
        while (this.isSimulation() || ((Civilization)player.element).isAI() || GameInfo.nextTurn$shouldAutoProcessHotseatPlayer(isOnline, player, this) || GameInfo.nextTurn$shouldAutoProcessOnlinePlayer(isOnline, player, this)) {
            new TurnManager((Civilization)player.element).startTurn(progressBar);
            new TurnManager((Civilization)player.element).automateTurn();
            WorldScreen worldScreen = UncivGame.Companion.getCurrent().getWorldScreen();
            if (this.simulateUntilWin && ((Civilization)player.element).getVictoryManager().hasWon()) {
                this.simulateUntilWin = false;
                Object object = worldScreen;
                if (object != null && (object = ((WorldScreen)object).getAutoPlay()) != null) {
                    ((AutoPlay)object).stopAutoPlay();
                }
                break;
            }
            if (worldScreen != null && worldScreen.getAutoPlay().isAutoPlaying() && ((Civilization)player.element).getVictoryManager().hasWon() && !this.oneMoreTurnMode) {
                worldScreen.getAutoPlay().stopAutoPlay();
            }
            new TurnManager((Civilization)player.element).endTurn(progressBar);
            GameInfo.nextTurn$setNextPlayer(playerIndex, this, player);
        }
        if (this.turns == DebugUtils.INSTANCE.getSIMULATE_UNTIL_TURN()) {
            DebugUtils.INSTANCE.setSIMULATE_UNTIL_TURN(0);
        }
        this.currentTurnStartTime = System.currentTimeMillis();
        this.currentPlayer = ((Civilization)player.element).getCivName();
        this.setCurrentPlayerCiv(this.getCivilization(this.currentPlayer));
        new TurnManager((Civilization)player.element).startTurn(progressBar);
        if (this.getCurrentPlayerCiv().isSpectator()) {
            this.getCurrentPlayerCiv().getPopupAlerts().clear();
        }
        if (this.turns % 10 == 0 && Gdx.app != null) {
            UncivGame.Companion.getCurrent().getMusicController().chooseTrack(this.getCurrentPlayerCiv().getCivName(), MusicMood.INSTANCE.peaceOrWar(this.getCurrentPlayerCiv().isAtWar()), MusicTrackChooserFlags.Companion.getSetNextTurn());
        }
        this.notifyOfCloseEnemyUnits((Civilization)player.element);
    }

    public static /* synthetic */ void nextTurn$default(GameInfo gameInfo2, NextTurnProgress nextTurnProgress, int n, Object object) {
        if ((n & 1) != 0) {
            nextTurnProgress = null;
        }
        gameInfo2.nextTurn(nextTurnProgress);
    }

    /*
     * Unable to fully structure code
     */
    private final void notifyOfCloseEnemyUnits(Civilization thisPlayer) {
        $this$map$iv = thisPlayer.getViewableInvisibleUnitsTiles();
        $i$f$map = false;
        var5_5 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var10_14 = (Tile)item$iv$iv;
            var19_12 = destination$iv$iv;
            $i$a$-map-GameInfo$notifyOfCloseEnemyUnits$viewableInvisibleTiles$1 = false;
            var19_12.add(it.getPosition());
        }
        viewableInvisibleTiles = (List)destination$iv$iv;
        $i$f$map = thisPlayer.getViewableTiles();
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block14: {
                it = (Tile)element$iv$iv;
                $i$a$-filter-GameInfo$notifyOfCloseEnemyUnits$enemyUnitsCloseToTerritory$1 = false;
                if (it.getMilitaryUnit() == null) ** GOTO lbl-1000
                v0 = it.getMilitaryUnit();
                Intrinsics.checkNotNull(v0);
                if (Intrinsics.areEqual(v0.getCiv(), thisPlayer)) ** GOTO lbl-1000
                v1 = it.getMilitaryUnit();
                Intrinsics.checkNotNull(v1);
                if (!thisPlayer.isAtWarWith(v1.getCiv())) ** GOTO lbl-1000
                if (Intrinsics.areEqual(it.getOwner(), thisPlayer)) ** GOTO lbl-1000
                $this$any$iv = it.getNeighbors();
                $i$f$any = false;
                var15_24 = $this$any$iv.iterator();
                while (var15_24.hasNext()) {
                    neighbor = element$iv = var15_24.next();
                    $i$a$-any-GameInfo$notifyOfCloseEnemyUnits$enemyUnitsCloseToTerritory$1$1 = false;
                    if (!Intrinsics.areEqual(neighbor.getOwner(), thisPlayer)) continue;
                    v2 = true;
                    break block14;
                }
                v2 = false;
            }
            if (v2) {
                v3 = it.getMilitaryUnit();
                Intrinsics.checkNotNull(v3);
                ** if (v3.isInvisible((Civilization)thisPlayer) && !viewableInvisibleTiles.contains((Object)it.getPosition())) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v4 = true;
                ** GOTO lbl51
            }
lbl-1000:
            // 5 sources

            {
                v4 = false;
            }
lbl51:
            // 2 sources

            if (!v4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        enemyUnitsCloseToTerritory = (List)destination$iv$iv;
        $this$filter$iv = enemyUnitsCloseToTerritory;
        var20_28 = thisPlayer;
        var19_12 = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tile)element$iv$iv;
            $i$a$-filter-GameInfo$notifyOfCloseEnemyUnits$1 = false;
            if (!Intrinsics.areEqual(it.getOwner(), thisPlayer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var21_29 = (List)destination$iv$iv;
        super.addEnemyUnitNotification(var20_28, var21_29, "in");
        $this$filter$iv = enemyUnitsCloseToTerritory;
        var20_28 = thisPlayer;
        var19_12 = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tile)element$iv$iv;
            $i$a$-filter-GameInfo$notifyOfCloseEnemyUnits$2 = false;
            if (!(Intrinsics.areEqual(it.getOwner(), thisPlayer) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var21_29 = (List)destination$iv$iv;
        super.addEnemyUnitNotification(var20_28, var21_29, "near");
        $this$filter$iv = thisPlayer.getCities();
        var20_28 = thisPlayer;
        var19_12 = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block15: {
                city = (City)element$iv$iv;
                $i$a$-filter-GameInfo$notifyOfCloseEnemyUnits$3 = false;
                if (!city.canBombard()) ** GOTO lbl-1000
                $this$any$iv = enemyUnitsCloseToTerritory;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v5 = false;
                } else {
                    var15_24 = $this$any$iv.iterator();
                    while (var15_24.hasNext()) {
                        tile = element$iv = var15_24.next();
                        $i$a$-any-GameInfo$notifyOfCloseEnemyUnits$3$1 = false;
                        if (!(tile.aerialDistanceTo(city.getCenterTile()) <= city.getBombardRange())) continue;
                        v5 = true;
                        break block15;
                    }
                    v5 = false;
                }
            }
            if (v5) {
                v6 = true;
            } else lbl-1000:
            // 2 sources

            {
                v6 = false;
            }
            if (!v6) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var21_29 = (List)destination$iv$iv;
        super.addBombardNotification(var20_28, var21_29);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Victory> getEnabledVictories() {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.getRuleset().getVictories();
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(!((Victory)it.getValue()).getHiddenInVictoryScreen() && this.gameParameters.getVictoryTypes().contains(it.getKey()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    public final void processDiplomaticVictory() {
        if (this.diplomaticVictoryVotesProcessed) {
            return;
        }
        for (Civilization civInfo : this.civilizations) {
            if (!civInfo.getVictoryManager().hasEnoughVotesForDiplomaticVictory()) continue;
            civInfo.getVictoryManager().setHasEverWonDiplomaticVote(true);
        }
        this.diplomaticVictoryVotesProcessed = true;
    }

    public final boolean checkForVictory() {
        if (this.victoryData != null) {
            return true;
        }
        for (Civilization civ : this.civilizations) {
            new TurnManager(civ).updateWinningCiv();
            if (this.victoryData == null) continue;
            return true;
        }
        return false;
    }

    private final void addEnemyUnitNotification(Civilization thisPlayer, List<Tile> tiles2, String inOrNear) {
        if (tiles2.size() < 3) {
            for (Tile tile : tiles2) {
                MapUnit mapUnit = tile.getMilitaryUnit();
                Intrinsics.checkNotNull(mapUnit);
                String unitName = mapUnit.getName();
                String[] stringArray = new String[]{"OtherIcons/Pillage", unitName};
                thisPlayer.addNotification("An enemy [" + unitName + "] was spotted " + inOrNear + " our territory", tile.getPosition(), Notification.NotificationCategory.War, stringArray);
            }
        } else {
            Sequence positions2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)tiles2), addEnemyUnitNotification.positions.1.INSTANCE);
            String[] stringArray = new String[]{"OtherIcons/Pillage"};
            thisPlayer.addNotification("" + '[' + tiles2.size() + "] enemy units were spotted " + inOrNear + " our territory", LocationAction.Companion.invoke(positions2), Notification.NotificationCategory.War, stringArray);
        }
    }

    private final void addBombardNotification(Civilization thisPlayer, List<City> cities) {
        if (cities.size() < 3) {
            for (City city2 : cities) {
                String[] stringArray = new String[]{"ImprovementIcons/City center", "OtherIcons/CrosshairB"};
                thisPlayer.addNotification("Your city [" + city2.getName() + "] can bombard the enemy!", city2.getLocation(), Notification.NotificationCategory.War, stringArray);
            }
        } else {
            Sequence positions2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)cities), addBombardNotification.positions.1.INSTANCE);
            String[] stringArray = new String[]{"ImprovementIcons/City center", "OtherIcons/CrosshairB"};
            thisPlayer.addNotification("" + '[' + cities.size() + "] of your cities can bombard the enemy!", LocationAction.Companion.invoke(positions2), Notification.NotificationCategory.War, stringArray);
        }
    }

    public final boolean notifyExploredResources(@NotNull Civilization civInfo, @NotNull String resourceName, int maxDistance, @NotNull Function1<? super Tile, Boolean> filter2) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Notification notification = this.getExploredResourcesNotification(civInfo, resourceName, maxDistance, filter2);
        if (notification == null) {
            return false;
        }
        Notification notification2 = notification;
        civInfo.getNotifications().add(notification2);
        return true;
    }

    public static /* synthetic */ boolean notifyExploredResources$default(GameInfo gameInfo2, Civilization civilization, String string, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 8) != 0) {
            function1 = notifyExploredResources.1.INSTANCE;
        }
        return gameInfo2.notifyExploredResources(civilization, string, n, function1);
    }

    @Nullable
    public final Notification getExploredResourcesNotification(@NotNull Civilization civ, @NotNull String resourceName, int maxDistance, @NotNull Function1<? super Tile, Boolean> filter2) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Sequence<City> relevantCities2 = SequencesKt.plus(CollectionsKt.asSequence((Iterable)civ.getCities()), SequencesKt.flatMapIterable(SequencesKt.filter(civ.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(civ){
            final /* synthetic */ Civilization $civ;
            {
                this.$civ = $civ;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isCityState() && Intrinsics.areEqual(it.getAllyCiv(), this.$civ.getCivName());
            }
        }), getExploredResourcesNotification.relevantCities.2.INSTANCE));
        TileResource tileResource = this.getRuleset().getTileResources().get(resourceName);
        Intrinsics.checkNotNull(tileResource);
        Sequence exploredRevealTiles2 = IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)tileResource, UniqueType.CityStateOnlyResource, null, 2, null) ? SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.getAliveCityStates()), (Function1)new Function1<Civilization, Boolean>(resourceName){
            final /* synthetic */ String $resourceName;
            {
                this.$resourceName = $resourceName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getCityStateResource(), this.$resourceName);
            }
        }), getExploredResourcesNotification.exploredRevealTiles.2.INSTANCE) : SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.tileMap.getValues()), (Function1)new Function1<Tile, Boolean>(resourceName){
            final /* synthetic */ String $resourceName;
            {
                this.$resourceName = $resourceName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getResource(), this.$resourceName);
            }
        });
        Sequence exploredRevealInfo2 = SequencesKt.distinctBy(SequencesKt.sortedWith(SequencesKt.filter(SequencesKt.flatMap(SequencesKt.filter(exploredRevealTiles2, (Function1)new Function1<Tile, Boolean>(civ){
            final /* synthetic */ Civilization $civ;
            {
                this.$civ = $civ;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$civ.hasExplored(it);
            }
        }), (Function1)new Function1<Tile, Sequence<? extends CityTileAndDistance>>(relevantCities2){
            final /* synthetic */ Sequence<City> $relevantCities;
            {
                this.$relevantCities = $relevantCities;
                super(1);
            }

            @NotNull
            public final Sequence<CityTileAndDistance> invoke(@NotNull Tile tile) {
                Intrinsics.checkNotNullParameter(tile, "tile");
                return SequencesKt.map(this.$relevantCities, (Function1)new Function1<City, CityTileAndDistance>(tile){
                    final /* synthetic */ Tile $tile;
                    {
                        this.$tile = $tile;
                        super(1);
                    }

                    @NotNull
                    public final CityTileAndDistance invoke(@NotNull City city2) {
                        Intrinsics.checkNotNullParameter(city2, "city");
                        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000-\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J,\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"com/unciv/logic/GameInfo$getExploredResourcesNotification$CityTileAndDistance", "", "city", "Lcom/unciv/logic/city/City;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "distance", "", "(Lcom/unciv/logic/city/City;Lcom/unciv/logic/map/tile/Tile;I)V", "getCity", "()Lcom/unciv/logic/city/City;", "getDistance", "()I", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "component1", "component2", "component3", "copy", "(Lcom/unciv/logic/city/City;Lcom/unciv/logic/map/tile/Tile;I)Lcom/unciv/logic/GameInfo$getExploredResourcesNotification$CityTileAndDistance;", "equals", "", "other", "hashCode", "toString", "", "core"})
                        public final class CityTileAndDistance {
                            @NotNull
                            private final City city;
                            @NotNull
                            private final Tile tile;
                            private final int distance;

                            public CityTileAndDistance(@NotNull City city2, @NotNull Tile tile, int distance) {
                                Intrinsics.checkNotNullParameter(city2, "city");
                                Intrinsics.checkNotNullParameter(tile, "tile");
                                this.city = city2;
                                this.tile = tile;
                                this.distance = distance;
                            }

                            @NotNull
                            public final City getCity() {
                                return this.city;
                            }

                            @NotNull
                            public final Tile getTile() {
                                return this.tile;
                            }

                            public final int getDistance() {
                                return this.distance;
                            }

                            @NotNull
                            public final City component1() {
                                return this.city;
                            }

                            @NotNull
                            public final Tile component2() {
                                return this.tile;
                            }

                            public final int component3() {
                                return this.distance;
                            }

                            @NotNull
                            public final CityTileAndDistance copy(@NotNull City city2, @NotNull Tile tile, int distance) {
                                Intrinsics.checkNotNullParameter(city2, "city");
                                Intrinsics.checkNotNullParameter(tile, "tile");
                                return new CityTileAndDistance(city2, tile, distance);
                            }

                            public static /* synthetic */ CityTileAndDistance copy$default(CityTileAndDistance cityTileAndDistance, City city2, Tile tile, int n, int n2, Object object) {
                                if ((n2 & 1) != 0) {
                                    city2 = cityTileAndDistance.city;
                                }
                                if ((n2 & 2) != 0) {
                                    tile = cityTileAndDistance.tile;
                                }
                                if ((n2 & 4) != 0) {
                                    n = cityTileAndDistance.distance;
                                }
                                return cityTileAndDistance.copy(city2, tile, n);
                            }

                            @NotNull
                            public String toString() {
                                return "CityTileAndDistance(city=" + this.city + ", tile=" + this.tile + ", distance=" + this.distance + ')';
                            }

                            public int hashCode() {
                                int result2 = this.city.hashCode();
                                result2 = result2 * 31 + this.tile.hashCode();
                                result2 = result2 * 31 + Integer.hashCode(this.distance);
                                return result2;
                            }

                            public boolean equals(@Nullable Object other) {
                                if (this == other) {
                                    return true;
                                }
                                if (!(other instanceof CityTileAndDistance)) {
                                    return false;
                                }
                                CityTileAndDistance cityTileAndDistance = (CityTileAndDistance)other;
                                if (!Intrinsics.areEqual(this.city, cityTileAndDistance.city)) {
                                    return false;
                                }
                                if (!Intrinsics.areEqual(this.tile, cityTileAndDistance.tile)) {
                                    return false;
                                }
                                return this.distance == cityTileAndDistance.distance;
                            }
                        }
                        return new CityTileAndDistance(city2, this.$tile, this.$tile.aerialDistanceTo(city2.getCenterTile()));
                    }
                });
            }
        }), (Function1)new Function1<CityTileAndDistance, Boolean>(maxDistance, filter2){
            final /* synthetic */ int $maxDistance;
            final /* synthetic */ Function1<Tile, Boolean> $filter;
            {
                this.$maxDistance = $maxDistance;
                this.$filter = $filter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull CityTileAndDistance it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getDistance() <= this.$maxDistance && this.$filter.invoke(it.getTile()) != false;
            }
        }), new Comparator(){

            public final int compare(T a, T b) {
                CityTileAndDistance it = (CityTileAndDistance)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getDistance());
                it = (CityTileAndDistance)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getDistance());
            }
        }), getExploredResourcesNotification.exploredRevealInfo.5.INSTANCE);
        Object object = (CityTileAndDistance)SequencesKt.firstOrNull(exploredRevealInfo2);
        if (object == null || (object = ((CityTileAndDistance)object).getCity()) == null) {
            return null;
        }
        Object chosenCity = object;
        Sequence positions2 = SequencesKt.map(SequencesKt.sortedWith(exploredRevealInfo2, new Comparator((City)chosenCity){
            final /* synthetic */ City $chosenCity$inlined;
            {
                this.$chosenCity$inlined = city2;
            }

            public final int compare(T a, T b) {
                CityTileAndDistance it = (CityTileAndDistance)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTile().aerialDistanceTo(this.$chosenCity$inlined.getCenterTile()));
                it = (CityTileAndDistance)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getTile().aerialDistanceTo(this.$chosenCity$inlined.getCenterTile()));
            }
        }), getExploredResourcesNotification.positions.2.INSTANCE);
        int positionsCount = SequencesKt.count(positions2);
        String text2 = positionsCount == 1 ? '[' + resourceName + "] revealed near [" + ((City)chosenCity).getName() + ']' : "" + '[' + positionsCount + "] sources of [" + resourceName + "] revealed, e.g. near [" + ((City)chosenCity).getName() + ']';
        String[] stringArray = new String[]{"ResourceIcons/" + resourceName};
        return new Notification(text2, stringArray, SequencesKt.asIterable(LocationAction.Companion.invoke(positions2)), Notification.NotificationCategory.General);
    }

    public static /* synthetic */ Notification getExploredResourcesNotification$default(GameInfo gameInfo2, Civilization civilization, String string, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 8) != 0) {
            function1 = getExploredResourcesNotification.1.INSTANCE;
        }
        return gameInfo2.getExploredResourcesNotification(civilization, string, n, function1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setTransients() {
        Iterable list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$flatMap$iv2;
        Object $this$first$iv;
        Object $this$filterNotTo$iv$iv;
        Object newName;
        Object it;
        HashSet<String> hashSet;
        void $this$mapTo$iv$iv;
        this.tileMap.setGameInfo(this);
        this.convertOldSavesToNewSaves();
        Object $this$map$iv2 = this.gameParameters.getMods();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            hashSet = destination$iv$iv;
            boolean bl = false;
            hashSet.add((String)((Object)TuplesKt.to(it, Github.INSTANCE.repoNameToFolderName((String)it, true))));
        }
        for (Object $this$map$iv2 : (List)destination$iv$iv) {
            String oldName = (String)((Pair)$this$map$iv2).component1();
            newName = (String)((Pair)$this$map$iv2).component2();
            if (Intrinsics.areEqual(newName, oldName)) continue;
            this.gameParameters.getMods().remove(oldName);
            this.gameParameters.getMods().add((String)newName);
        }
        this.setRuleset(RulesetCache.INSTANCE.getComplexRuleset(this.gameParameters));
        Object $this$filterNot$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf(this.gameParameters.getBaseRuleset()), (Iterable)this.gameParameters.getMods());
        boolean $i$f$filterNot = false;
        newName = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            it = (String)element$iv$iv;
            boolean bl = false;
            if (this.getRuleset().getMods().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingMods = (List)destination$iv$iv;
        if (!((Collection)missingMods).isEmpty()) {
            throw new MissingModsException(missingMods);
        }
        BackwardCompatibility.INSTANCE.removeMissingModReferences(this);
        for (BaseUnit baseUnit : this.getRuleset().getUnits().values()) {
            baseUnit.setRuleset(this.getRuleset());
        }
        for (Building building : this.getRuleset().getBuildings().values()) {
            building.setRuleset(this.getRuleset());
        }
        for (Civilization civInfo : this.civilizations) {
            civInfo.setGameInfo(this);
        }
        for (Civilization civInfo : this.civilizations) {
            civInfo.setNationTransient();
        }
        for (Civilization civInfo : this.civilizations) {
            for (DiplomacyManager diplomacyManager : civInfo.getDiplomacy().values()) {
                diplomacyManager.setCivInfo(civInfo);
                diplomacyManager.updateHasOpenBorders();
            }
        }
        TileMap.setTransients$default(this.tileMap, this.getRuleset(), false, 2, null);
        if (Intrinsics.areEqual(this.currentPlayer, "")) {
            String string;
            HashSet<String> hashSet2;
            Civilization it2;
            DiplomacyManager element$iv;
            boolean $i$f$first;
            GameInfo gameInfo2 = this;
            if (this.gameParameters.isOnlineMultiplayer()) {
                block22: {
                    $this$filterNot$iv = this.civilizations;
                    hashSet = gameInfo2;
                    $i$f$first = false;
                    $this$filterNotTo$iv$iv = $this$first$iv.iterator();
                    while ($this$filterNotTo$iv$iv.hasNext()) {
                        element$iv = $this$filterNotTo$iv$iv.next();
                        it2 = (Civilization)((Object)element$iv);
                        boolean bl = false;
                        if (!(it2.isHuman() && !it2.isSpectator())) continue;
                        break block22;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                hashSet2 = hashSet;
                string = ((Civilization)((Object)element$iv)).getCivName();
            } else {
                block23: {
                    $this$first$iv = this.civilizations;
                    hashSet = gameInfo2;
                    $i$f$first = false;
                    $this$filterNotTo$iv$iv = $this$first$iv.iterator();
                    while ($this$filterNotTo$iv$iv.hasNext()) {
                        element$iv = $this$filterNotTo$iv$iv.next();
                        it2 = (Civilization)((Object)element$iv);
                        boolean bl = false;
                        if (!it2.isHuman()) continue;
                        break block23;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                hashSet2 = hashSet;
                string = ((Civilization)((Object)element$iv)).getCivName();
            }
            ((GameInfo)((Object)hashSet2)).currentPlayer = string;
        }
        this.setCurrentPlayerCiv(this.getCivilization(this.currentPlayer));
        Difficulty difficulty = this.getRuleset().getDifficulties().get(this.difficulty);
        Intrinsics.checkNotNull(difficulty);
        this.setDifficultyObject(difficulty);
        Speed speed = this.getRuleset().getSpeeds().get(this.gameParameters.getSpeed());
        Intrinsics.checkNotNull(speed);
        this.setSpeed(speed);
        for (Religion religion : this.religions.values()) {
            religion.setTransients(this);
        }
        for (Civilization civInfo : this.civilizations) {
            civInfo.setTransients();
        }
        this.tileMap.setNeutralTransients();
        for (Civilization civInfo : this.civilizations) {
            void $this$flatMapTo$iv$iv2;
            $this$filterNotTo$iv$iv = civInfo.getPreferredVictoryTypeObjects();
            hashSet = civInfo;
            boolean $i$f$flatMap = false;
            void it3 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                Victory it4 = (Victory)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv2 = it4.getThingsToFocus(civInfo);
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv2);
            }
            ((Civilization)((Object)hashSet)).setThingsToFocusOnForVictory(CollectionsKt.toSet((List)destination$iv$iv2));
        }
        BackwardCompatibility.INSTANCE.convertFortify(this);
        this.updateCivilizationState();
        this.spaceResources.clear();
        Collection<Building> collection = this.getRuleset().getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection, "ruleset.buildings.values");
        $this$first$iv = collection;
        hashSet = this.spaceResources;
        boolean $i$f$filter = false;
        $this$flatMap$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Building)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.SpaceshipPart, null, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Building)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            Set set2 = IConstruction.DefaultImpls.getResourceRequirementsPerTurn$default((IConstruction)it, null, 1, null).keySet();
            Intrinsics.checkNotNullExpressionValue(set2, "it.getResourceRequirementsPerTurn().keys");
            list$iv$iv = set2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        hashSet.addAll((List)destination$iv$iv);
        Collection<Victory> collection2 = this.getRuleset().getVictories().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "ruleset.victories.values");
        $this$flatMap$iv = collection2;
        hashSet = this.spaceResources;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Victory)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((Victory)it).getRequiredSpaceshipParts();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        hashSet.addAll((List)destination$iv$iv);
        this.barbarians.setTransients(this);
        this.cityDistances.setGame(this);
        BackwardCompatibility.INSTANCE.guaranteeUnitPromotions(this);
        BackwardCompatibility.INSTANCE.migrateToTileHistory(this);
        BackwardCompatibility.INSTANCE.migrateGreatGeneralPools(this);
        BackwardCompatibility.INSTANCE.ensureUnitIds(this);
    }

    private final void updateCivilizationState() {
        Sequence $this$sortedByDescending$iv = CollectionsKt.asSequence((Iterable)this.civilizations);
        boolean $i$f$sortedByDescending2 = false;
        Iterator iterator2 = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Civilization it = (Civilization)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.isCityState());
                it = (Civilization)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.isCityState());
            }
        }).iterator();
        while (iterator2.hasNext()) {
            Civilization civInfo = (Civilization)iterator2.next();
            Iterator<MapUnit> $i$f$sortedByDescending2 = civInfo.getUnits().getCivUnits().iterator();
            while ($i$f$sortedByDescending2.hasNext()) {
                MapUnit unit = $i$f$sortedByDescending2.next();
                MapUnit.updateVisibleTiles$default(unit, false, null, 2, null);
            }
            if (civInfo.getPlayerType() == PlayerType.Human) {
                civInfo.getExploredRegion().setMapParameters(this.tileMap.getMapParameters());
            }
            civInfo.getCache().updateOurTiles();
            civInfo.getCache().updateSightAndResources();
            civInfo.getCache().updateCitiesConnectedToCapital(true);
            LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
            for (City city2 : civInfo.getCities()) {
                city2.getCityStats().updateTileStats(localUniqueCache);
                city2.getCityStats().updateCityHappiness(city2.getCityConstructions().getStats(localUniqueCache));
            }
            for (City city2 : civInfo.getCities()) {
                if (city2.getCityConstructions().getConstructionQueue().isEmpty()) {
                    city2.getCityConstructions().chooseNextConstruction();
                }
                if (!this.getRuleset().getTileResources().containsKey(city2.getDemandedResource())) {
                    city2.setDemandedResource("");
                }
                CityStats.update$default(city2.getCityStats(), null, false, false, localUniqueCache, 7, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void convertOldSavesToNewSaves() {
        Object v2;
        Iterable $this$firstOrNull$iv;
        block3: {
            $this$firstOrNull$iv = this.gameParameters.getMods();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Object object = (Ruleset)RulesetCache.INSTANCE.get((Object)it);
                boolean bl2 = object != null && (object = ((Ruleset)object).getModOptions()) != null ? ((ModOptions)object).isBaseRuleset() : false;
                if (!bl2) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        String baseRulesetInMods = v2;
        if (baseRulesetInMods != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            this.gameParameters.setBaseRuleset(baseRulesetInMods);
            $this$firstOrNull$iv = this.gameParameters.getMods();
            GameParameters gameParameters = this.gameParameters;
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it, baseRulesetInMods))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            gameParameters.setMods(new LinkedHashSet<String>(collection));
        }
    }

    @NotNull
    public final GameInfoPreview asPreview() {
        return new GameInfoPreview(this);
    }

    private static final void nextTurn$setNextPlayer(Ref.IntRef playerIndex, GameInfo this$0, Ref.ObjectRef<Civilization> player) {
        playerIndex.element = (playerIndex.element + 1) % this$0.civilizations.size();
        if (playerIndex.element == 0) {
            int n = this$0.turns;
            this$0.turns = n + 1;
            if (DebugUtils.INSTANCE.getSIMULATE_UNTIL_TURN() != 0) {
                Object[] objectArray = new Object[]{this$0.turns};
                LogKt.debug("Starting simulation of turn %s", objectArray);
            }
        }
        player.element = this$0.civilizations.get(playerIndex.element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean nextTurn$shouldAutoProcessHotseatPlayer(boolean isOnline, Ref.ObjectRef<Civilization> player, GameInfo this$0) {
        Civilization it;
        Object element$iv2;
        boolean bl;
        if (isOnline) return false;
        if (!((Civilization)player.element).isDefeated()) return false;
        Iterable $this$any$iv = this$0.civilizations;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv2 : $this$any$iv) {
                it = (Civilization)element$iv2;
                boolean bl2 = false;
                if (it.isHuman() && it.isAlive()) {
                    return true;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        Iterable $this$first$iv = this$0.civilizations;
        boolean $i$f$first = false;
        Iterator iterator2 = $this$first$iv.iterator();
        do {
            if (!iterator2.hasNext()) throw new NoSuchElementException("Collection contains no element matching the predicate.");
            element$iv2 = iterator2.next();
            it = (Civilization)element$iv2;
            boolean bl4 = false;
        } while (!it.isHuman());
        if (Intrinsics.areEqual(element$iv2, player.element)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean nextTurn$shouldAutoProcessOnlinePlayer(boolean isOnline, Ref.ObjectRef<Civilization> player, GameInfo this$0) {
        Civilization it;
        Object element$iv2;
        boolean bl;
        if (!isOnline) return false;
        if (((Civilization)player.element).isSpectator()) return true;
        if (!((Civilization)player.element).isDefeated()) return false;
        Iterable $this$any$iv = this$0.civilizations;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv2 : $this$any$iv) {
                it = (Civilization)element$iv2;
                boolean bl2 = false;
                if (it.isHuman() && it.isAlive()) {
                    return true;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        Iterable $this$first$iv = this$0.civilizations;
        boolean $i$f$first = false;
        Iterator iterator2 = $this$first$iv.iterator();
        do {
            if (!iterator2.hasNext()) throw new NoSuchElementException("Collection contains no element matching the predicate.");
            element$iv2 = iterator2.next();
            it = (Civilization)element$iv2;
            boolean bl4 = false;
        } while (!it.isHuman());
        if (Intrinsics.areEqual(element$iv2, player.element)) return false;
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/GameInfo$Companion;", "", "()V", "CURRENT_COMPATIBILITY_NUMBER", "", "CURRENT_COMPATIBILITY_VERSION", "Lcom/unciv/logic/CompatibilityVersion;", "getCURRENT_COMPATIBILITY_VERSION", "()Lcom/unciv/logic/CompatibilityVersion;", "FIRST_WITHOUT", "getFIRST_WITHOUT", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompatibilityVersion getCURRENT_COMPATIBILITY_VERSION() {
            return CURRENT_COMPATIBILITY_VERSION;
        }

        @NotNull
        public final CompatibilityVersion getFIRST_WITHOUT() {
            return FIRST_WITHOUT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

