/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.city;

import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.automation.city.ConstructionAutomation;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.automation.unit.WorkerAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.CityAction;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.map.BFS;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.Milestone;
import com.unciv.models.ruleset.MilestoneType;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.Personality;
import com.unciv.models.ruleset.nation.PersonalityValue;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.screens.cityscreen.CityScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001OB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00105\u001a\u000206H\u0002J0\u00107\u001a\u0002062\u0016\u00108\u001a\u0012\u0012\u0004\u0012\u00020,0+j\b\u0012\u0004\u0012\u00020,`-2\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u000204H\u0002J\b\u0010;\u001a\u000206H\u0002J\b\u0010<\u001a\u000206H\u0002J\b\u0010=\u001a\u000206H\u0002J\b\u0010>\u001a\u000206H\u0002J\u0010\u0010?\u001a\u0002042\u0006\u0010@\u001a\u00020\u0010H\u0002J\u0010\u0010A\u001a\u0002042\u0006\u0010@\u001a\u00020\u0010H\u0002J\u0010\u0010B\u001a\u0002042\u0006\u0010@\u001a\u00020\u0010H\u0002J\u0010\u0010C\u001a\u0002042\u0006\u0010@\u001a\u00020\u0010H\u0002J\u0006\u0010D\u001a\u000206J\u0018\u0010E\u001a\u0002062\u0006\u0010@\u001a\u00020\u00102\u0006\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u0002042\u0006\u0010@\u001a\u00020\u0010H\u0002J\u0010\u0010I\u001a\u00020\u00062\u0006\u0010J\u001a\u00020KH\u0002J\"\u0010L\u001a\b\u0012\u0004\u0012\u0002HM0\u000f\"\b\b\u0000\u0010M*\u00020N*\b\u0012\u0004\u0012\u0002HM0\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0006`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0006`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010*\u001a\u0012\u0012\u0004\u0012\u00020,0+j\b\u0012\u0004\u0012\u00020,`-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010.\u001a\u0012\u0012\u0004\u0012\u00020\u000b0/j\b\u0012\u0004\u0012\u00020\u000b`0X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u0002020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/unciv/logic/automation/city/ConstructionAutomation;", "", "cityConstructions", "Lcom/unciv/logic/city/CityConstructions;", "(Lcom/unciv/logic/city/CityConstructions;)V", "allTechsAreResearched", "", "averageProduction", "", "buildableBuildings", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "buildableUnits", "buildings", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/Building;", "buildingsForVictory", "", "cities", "", "city", "Lcom/unciv/logic/city/City;", "getCityConstructions", "()Lcom/unciv/logic/city/CityConstructions;", "cityIsOverAverageProduction", "cityState", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "cityStats", "Lcom/unciv/logic/city/CityStats;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "civUnits", "Lcom/unciv/logic/map/mapunit/MapUnit;", "constructionsToAvoid", "disabledAutoAssignConstructions", "", "isAtWar", "militaryUnits", "nonWonders", "personality", "Lcom/unciv/models/ruleset/nation/Personality;", "relativeCostEffectiveness", "Ljava/util/ArrayList;", "Lcom/unciv/logic/automation/city/ConstructionAutomation$ConstructionChoice;", "Lkotlin/collections/ArrayList;", "spaceshipParts", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "units", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "workers", "", "addBuildingChoices", "", "addChoice", "choices", "choice", "choiceModifier", "addMilitaryUnitChoice", "addSpaceshipPartChoice", "addWorkBoatChoice", "addWorkerChoice", "applyBuildingStats", "building", "applyMilitaryBuildingValue", "applyOnetimeUniqueBonuses", "applyVictoryBuildingValue", "chooseNextConstruction", "getBuildingStatsFromUniques", "buildingStats", "Lcom/unciv/models/stats/Stats;", "getValueOfBuilding", "shouldAvoidConstruction", "construction", "Lcom/unciv/models/ruleset/IConstruction;", "filterBuildable", "T", "Lcom/unciv/models/ruleset/INonPerpetualConstruction;", "ConstructionChoice", "core"})
@SourceDebugExtension(value={"SMAP\nConstructionAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstructionAutomation.kt\ncom/unciv/logic/automation/city/ConstructionAutomation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,372:1\n1250#2,3:373\n1250#2,3:376\n2141#2,2:454\n1229#2,2:457\n1821#2,14:473\n1229#2,2:487\n1726#3,3:379\n1603#3,9:382\n1855#3:391\n1856#3:393\n1612#3:394\n766#3:395\n857#3,2:396\n1549#3:398\n1620#3,3:399\n1549#3:402\n1620#3,3:403\n1747#3,3:406\n2624#3,3:409\n1963#3,14:412\n2333#3,14:426\n2333#3,14:440\n2310#3,14:459\n1#4:392\n1#4:456\n*S KotlinDebug\n*F\n+ 1 ConstructionAutomation.kt\ncom/unciv/logic/automation/city/ConstructionAutomation\n*L\n71#1:373,3\n72#1:376,3\n182#1:454,2\n205#1:457,2\n251#1:473,14\n301#1:487,2\n75#1:379,3\n79#1:382,9\n79#1:391\n79#1:393\n79#1:394\n80#1:395\n80#1:396,2\n81#1:398\n81#1:399,3\n86#1:402\n86#1:403,3\n133#1:406,3\n137#1:409,3\n138#1:412,14\n141#1:426,14\n146#1:440,14\n234#1:459,14\n79#1:392\n*E\n"})
public final class ConstructionAutomation {
    @NotNull
    private final CityConstructions cityConstructions;
    @NotNull
    private final City city;
    @NotNull
    private final Civilization civInfo;
    @NotNull
    private final Personality personality;
    @NotNull
    private final Sequence<String> constructionsToAvoid;
    @NotNull
    private final Set<String> disabledAutoAssignConstructions;
    @NotNull
    private final HashMap<String, Boolean> buildableBuildings;
    @NotNull
    private final HashMap<String, Boolean> buildableUnits;
    @NotNull
    private final Sequence<Building> buildings;
    @NotNull
    private final Sequence<Building> nonWonders;
    @NotNull
    private final Sequence<BaseUnit> units;
    @NotNull
    private final Sequence<MapUnit> civUnits;
    private final int militaryUnits;
    private final float workers;
    private final int cities;
    private final boolean allTechsAreResearched;
    private final boolean isAtWar;
    @NotNull
    private final List<String> buildingsForVictory;
    @NotNull
    private final HashSet<String> spaceshipParts;
    private final double averageProduction;
    private final boolean cityIsOverAverageProduction;
    @NotNull
    private final ArrayList<ConstructionChoice> relativeCostEffectiveness;
    @NotNull
    private final StateForConditionals cityState;
    @NotNull
    private final CityStats cityStats;

    /*
     * WARNING - void declaration
     */
    public ConstructionAutomation(@NotNull CityConstructions cityConstructions) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        int n;
        Iterable $this$all$iv;
        int n2;
        ConstructionAutomation constructionAutomation;
        block9: {
            MapUnit it2;
            Object element$iv;
            Object $this$count$iv;
            Intrinsics.checkNotNullParameter(cityConstructions, "cityConstructions");
            this.cityConstructions = cityConstructions;
            this.city = this.cityConstructions.getCity();
            this.civInfo = this.city.getCiv();
            this.personality = this.civInfo.getPersonality();
            this.constructionsToAvoid = SequencesKt.map(this.personality.getMatchingUniques(UniqueType.WillNotBuild, new StateForConditionals(this.city)), constructionsToAvoid.1.INSTANCE);
            this.disabledAutoAssignConstructions = this.civInfo.isHuman() ? (Set)GUI.INSTANCE.getSettings().getDisabledAutoAssignConstructions() : SetsKt.emptySet();
            this.buildableBuildings = new HashMap();
            this.buildableUnits = new HashMap();
            Collection<Building> collection = this.city.getRuleset().getBuildings().values();
            Intrinsics.checkNotNullExpressionValue(collection, "city.getRuleset().buildings.values");
            this.buildings = SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)collection), (Function1)new Function1<Building, Boolean>(this){
                final /* synthetic */ ConstructionAutomation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Building it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return ConstructionAutomation.access$getDisabledAutoAssignConstructions$p(this.this$0).contains(it.getName()) || ConstructionAutomation.access$shouldAvoidConstruction(this.this$0, it);
                }
            });
            this.nonWonders = SequencesKt.filterNot(SequencesKt.filterNot(this.buildings, nonWonders.1.INSTANCE), (Function1)new Function1<Building, Boolean>(this){
                final /* synthetic */ ConstructionAutomation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Building it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(ConstructionAutomation.access$getBuildableBuildings$p(this.this$0).get(it.getName()), false);
                }
            });
            Collection<BaseUnit> collection2 = this.city.getRuleset().getUnits().values();
            Intrinsics.checkNotNullExpressionValue(collection2, "city.getRuleset().units.values");
            this.units = SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)collection2), (Function1)new Function1<BaseUnit, Boolean>(this){
                final /* synthetic */ ConstructionAutomation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull BaseUnit it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(ConstructionAutomation.access$getBuildableUnits$p(this.this$0).get(it.getName()), false) || ConstructionAutomation.access$getDisabledAutoAssignConstructions$p(this.this$0).contains(it.getName()) || ConstructionAutomation.access$shouldAvoidConstruction(this.this$0, it);
                }
            });
            Sequence<MapUnit> sequence = this.civUnits = this.civInfo.getUnits().getCivUnits();
            constructionAutomation = this;
            boolean $i$f$count = false;
            int count$iv = 0;
            Iterator<Object> iterator2 = $this$count$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                it2 = (MapUnit)element$iv;
                boolean bl = false;
                if (!it2.getBaseUnit().isMilitary() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            constructionAutomation.militaryUnits = n2 = count$iv;
            $this$count$iv = this.civUnits;
            constructionAutomation = this;
            $i$f$count = false;
            count$iv = 0;
            iterator2 = $this$count$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                it2 = (MapUnit)element$iv;
                boolean bl = false;
                if (!it2.getCache().getHasUniqueToBuildImprovements() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
            constructionAutomation.workers = n2;
            this.cities = this.civInfo.getCities().size();
            Collection<Technology> collection3 = this.civInfo.getGameInfo().getRuleset().getTechnologies().values();
            Intrinsics.checkNotNullExpressionValue(collection3, "civInfo.gameInfo.ruleset.technologies.values");
            $this$count$iv = collection3;
            constructionAutomation = this;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                n = 1;
            } else {
                for (Object element$iv2 : $this$all$iv) {
                    Technology it3 = (Technology)element$iv2;
                    boolean bl = false;
                    if (this.civInfo.getTech().isResearched(it3.getName()) || !this.civInfo.getTech().canBeResearched(it3.getName())) continue;
                    n = 0;
                    break block9;
                }
                n = 1;
            }
        }
        n2 = n;
        constructionAutomation.allTechsAreResearched = n2;
        this.isAtWar = this.civInfo.isAtWar();
        $this$all$iv = this.civInfo.getGameInfo().getEnabledVictories().values();
        constructionAutomation = this;
        boolean $i$f$mapNotNull = false;
        void count$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            Milestone it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            Victory it4 = (Victory)element$iv$iv;
            boolean bl2 = false;
            if (this.civInfo.getVictoryManager().getNextMilestone(it4) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Milestone)element$iv$iv;
            boolean bl = false;
            if (!(((Milestone)it).getType() == MilestoneType.BuiltBuilding || ((Milestone)it).getType() == MilestoneType.BuildingBuiltGlobally)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Milestone)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Milestone)it).getParams().get(0));
        }
        constructionAutomation.buildingsForVictory = (List)destination$iv$iv;
        this.spaceshipParts = this.civInfo.getGameInfo().getSpaceResources();
        $this$map$iv = this.civInfo.getCities();
        constructionAutomation = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (City)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Float.valueOf(((City)it).getCityStats().getCurrentCityStats().getProduction()));
        }
        constructionAutomation.averageProduction = CollectionsKt.averageOfFloat((List)destination$iv$iv);
        this.cityIsOverAverageProduction = (double)this.city.getCityStats().getCurrentCityStats().getProduction() >= this.averageProduction;
        this.relativeCostEffectiveness = new ArrayList();
        this.cityState = new StateForConditionals(this.city);
        this.cityStats = this.city.getCityStats();
    }

    @NotNull
    public final CityConstructions getCityConstructions() {
        return this.cityConstructions;
    }

    private final boolean shouldAvoidConstruction(IConstruction construction2) {
        Iterator<String> iterator2 = this.constructionsToAvoid.iterator();
        while (iterator2.hasNext()) {
            String toAvoid = iterator2.next();
            if (construction2 instanceof Building && ((Building)construction2).matchesFilter(toAvoid)) {
                return true;
            }
            if (!(construction2 instanceof BaseUnit) || !((BaseUnit)construction2).matchesFilter(toAvoid)) continue;
            return true;
        }
        return false;
    }

    private final void addChoice(ArrayList<ConstructionChoice> choices, String choice, float choiceModifier) {
        choices.add(new ConstructionChoice(choice, choiceModifier, CityConstructions.getRemainingWork$default(this.cityConstructions, choice, false, 2, null), this.cityConstructions.productionForConstruction(choice)));
    }

    private final <T extends INonPerpetualConstruction> Sequence<T> filterBuildable(Sequence<? extends T> $this$filterBuildable) {
        return SequencesKt.filter($this$filterBuildable, new Function1<T, Boolean>(this){
            final /* synthetic */ ConstructionAutomation this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull T it) {
                HashMap cache2;
                Intrinsics.checkNotNullParameter(it, "it");
                HashMap hashMap = cache2 = it instanceof Building ? ConstructionAutomation.access$getBuildableBuildings$p(this.this$0) : ConstructionAutomation.access$getBuildableUnits$p(this.this$0);
                if (cache2.get(it.getName()) == null) {
                    ((Map)cache2).put(it.getName(), it.isBuildable(this.this$0.getCityConstructions()));
                }
                V v = cache2.get(it.getName());
                Intrinsics.checkNotNull(v);
                return (Boolean)v;
            }
        });
    }

    public final void chooseNextConstruction() {
        String string;
        if (!(this.cityConstructions.getCurrentConstruction() instanceof PerpetualConstruction)) {
            return;
        }
        this.addBuildingChoices();
        if (!this.city.isPuppet()) {
            this.addSpaceshipPartChoice();
            this.addWorkerChoice();
            this.addWorkBoatChoice();
            this.addMilitaryUnitChoice();
        }
        if (this.relativeCostEffectiveness.isEmpty()) {
            string = PerpetualConstruction.Companion.getScience().isBuildable(this.cityConstructions) && !this.allTechsAreResearched ? PerpetualConstruction.Companion.getScience().getName() : (PerpetualConstruction.Companion.getGold().isBuildable(this.cityConstructions) ? PerpetualConstruction.Companion.getGold().getName() : PerpetualConstruction.Companion.getIdle().getName());
        } else {
            Object minElem$iv;
            boolean $i$f$minByOrNull;
            Iterable $this$minByOrNull$iv;
            Iterator iterator$iv;
            ConstructionChoice it;
            boolean bl;
            block30: {
                Iterable $this$any$iv = this.relativeCostEffectiveness;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (ConstructionChoice)element$iv;
                        boolean bl2 = false;
                        if (!(it.getRemainingWork() < it.getProduction() * 30)) continue;
                        bl = true;
                        break block30;
                    }
                    bl = false;
                }
            }
            if (bl) {
                boolean bl3;
                block31: {
                    CollectionsKt.removeAll((List)this.relativeCostEffectiveness, (Function1)chooseNextConstruction.chosenConstruction.2.INSTANCE);
                    Iterable $this$none$iv = this.relativeCostEffectiveness;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (ConstructionChoice)element$iv;
                            boolean bl4 = false;
                            if (!(it.getChoiceModifier() >= 0.0f)) continue;
                            bl3 = false;
                            break block31;
                        }
                        bl3 = true;
                    }
                }
                if (bl3) {
                    Object v3;
                    Iterable $this$maxByOrNull$iv = this.relativeCostEffectiveness;
                    boolean $i$f$maxByOrNull = false;
                    iterator$iv = $this$maxByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v3 = null;
                    } else {
                        Object maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v3 = maxElem$iv;
                        } else {
                            it = (ConstructionChoice)maxElem$iv;
                            boolean bl5 = false;
                            float maxValue$iv = (float)it.getRemainingWork() / it.getChoiceModifier() / (float)RangesKt.coerceAtLeast(it.getProduction(), 1);
                            do {
                                Object e$iv = iterator$iv.next();
                                ConstructionChoice it2 = (ConstructionChoice)e$iv;
                                $i$a$-maxByOrNull-ConstructionAutomation$chooseNextConstruction$chosenConstruction$4 = false;
                                float v$iv = (float)it2.getRemainingWork() / it2.getChoiceModifier() / (float)RangesKt.coerceAtLeast(it2.getProduction(), 1);
                                if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v3 = maxElem$iv;
                        }
                    }
                    Intrinsics.checkNotNull(v3);
                    string = ((ConstructionChoice)v3).getChoice();
                } else {
                    Object v4;
                    CollectionsKt.removeAll((List)this.relativeCostEffectiveness, (Function1)chooseNextConstruction.chosenConstruction.5.INSTANCE);
                    $this$minByOrNull$iv = this.relativeCostEffectiveness;
                    $i$f$minByOrNull = false;
                    iterator$iv = $this$minByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v4 = null;
                    } else {
                        minElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v4 = minElem$iv;
                        } else {
                            it = (ConstructionChoice)minElem$iv;
                            boolean bl6 = false;
                            float minValue$iv = (float)it.getRemainingWork() / it.getChoiceModifier() / (float)RangesKt.coerceAtLeast(it.getProduction(), 1);
                            do {
                                Object e$iv = iterator$iv.next();
                                ConstructionChoice it3 = (ConstructionChoice)e$iv;
                                $i$a$-minByOrNull-ConstructionAutomation$chooseNextConstruction$chosenConstruction$6 = false;
                                float v$iv = (float)it3.getRemainingWork() / it3.getChoiceModifier() / (float)RangesKt.coerceAtLeast(it3.getProduction(), 1);
                                if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                                minElem$iv = e$iv;
                                minValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v4 = minElem$iv;
                        }
                    }
                    Intrinsics.checkNotNull(v4);
                    string = ((ConstructionChoice)v4).getChoice();
                }
            } else {
                Object v5;
                $this$minByOrNull$iv = this.relativeCostEffectiveness;
                $i$f$minByOrNull = false;
                iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v5 = null;
                } else {
                    minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v5 = minElem$iv;
                    } else {
                        it = (ConstructionChoice)minElem$iv;
                        boolean bl7 = false;
                        int minValue$iv = it.getRemainingWork() / RangesKt.coerceAtLeast(it.getProduction(), 1);
                        do {
                            Object e$iv = iterator$iv.next();
                            ConstructionChoice it4 = (ConstructionChoice)e$iv;
                            $i$a$-minByOrNull-ConstructionAutomation$chooseNextConstruction$chosenConstruction$7 = false;
                            int v$iv = it4.getRemainingWork() / RangesKt.coerceAtLeast(it4.getProduction(), 1);
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v5 = minElem$iv;
                    }
                }
                Intrinsics.checkNotNull(v5);
                string = ((ConstructionChoice)v5).getChoice();
            }
        }
        String chosenConstruction2 = string;
        boolean noNotification = this.city.isInResistance() || this.civInfo.isAI() || Intrinsics.areEqual(this.cityConstructions.getCurrentConstructionFromQueue(), chosenConstruction2) || UncivGame.Companion.getCurrent().getScreen() instanceof CityScreen;
        this.cityConstructions.setCurrentConstructionFromQueue(chosenConstruction2);
        if (noNotification) {
            return;
        }
        String[] stringArray = new String[]{"StatIcons/Production"};
        this.civInfo.addNotification('[' + this.city.getName() + "] has started working on [" + chosenConstruction2 + ']', (Iterable<? extends NotificationAction>)CityAction.Companion.withLocation(this.city), Notification.NotificationCategory.Production, stringArray);
    }

    private final void addMilitaryUnitChoice() {
        MapUnit civilianUnit;
        if (!this.isAtWar && !this.cityIsOverAverageProduction) {
            return;
        }
        if (!this.isAtWar && (this.civInfo.getStats().getStatsForNextTurn().getGold() < 0.0f || this.militaryUnits > Math.max(7, this.cities * 5))) {
            return;
        }
        if (this.civInfo.getGold() < -50) {
            return;
        }
        String string = Automation.INSTANCE.chooseMilitaryUnit(this.city, this.units);
        if (string == null) {
            return;
        }
        String militaryUnit = string;
        float unitsToCitiesRatio = (float)this.cities / (float)(this.militaryUnits + 1);
        float modifier = 1.0f + (float)Math.sqrt(unitsToCitiesRatio) / (float)2;
        if (this.civInfo.wantsToFocusOn(Victory.Focus.Military) || this.isAtWar) {
            modifier *= (float)2;
        }
        if (Automation.INSTANCE.afraidOfBarbarians(this.civInfo)) {
            modifier = 2.0f;
        }
        if (!this.cityIsOverAverageProduction) {
            modifier /= (float)5;
        }
        if ((civilianUnit = this.city.getCenterTile().getCivilianUnit()) != null && MapUnit.hasUnique$default(civilianUnit, UniqueType.FoundCity, null, false, 6, null)) {
            boolean bl;
            block11: {
                Sequence<Tile> $this$none$iv = this.city.getCenterTile().getTilesInDistance(this.city.getExpandRange());
                boolean $i$f$none = false;
                Iterator<Tile> iterator2 = $this$none$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    MapUnit mapUnit = it.getMilitaryUnit();
                    if (!Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, this.civInfo)) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
            if (bl) {
                modifier = 5.0f;
            }
        }
        if (!this.civInfo.isAIOrAutoPlaying()) {
            modifier /= (float)2;
        }
        this.addChoice(this.relativeCostEffectiveness, militaryUnit, modifier *= this.personality.modifierFocus(PersonalityValue.Military, 0.3f));
    }

    /*
     * WARNING - void declaration
     */
    private final void addWorkBoatChoice() {
        Object t;
        void $this$minBy$iv;
        boolean alreadyHasWorkBoat;
        Object it;
        Iterable $this$any$iv;
        Set<BaseUnit> buildableWorkboatUnits2;
        block10: {
            boolean bl;
            buildableWorkboatUnits2 = SequencesKt.toSet(this.filterBuildable(SequencesKt.filter(this.units, (Function1)new Function1<BaseUnit, Boolean>(this){
                final /* synthetic */ ConstructionAutomation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull BaseUnit it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.CreateWaterImprovements, null, 2, null) && Automation.INSTANCE.allowAutomatedConstruction(ConstructionAutomation.access$getCivInfo$p(this.this$0), ConstructionAutomation.access$getCity$p(this.this$0), it);
                }
            })));
            if (buildableWorkboatUnits2.isEmpty()) {
                return;
            }
            Iterator iterator2 = ((Iterable)buildableWorkboatUnits2).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            BaseUnit it22 = (BaseUnit)iterator2.next();
            boolean bl2 = false;
            int it22 = it22.getMovement();
            while (iterator2.hasNext()) {
                BaseUnit it32 = (BaseUnit)iterator2.next();
                $i$a$-maxOf-ConstructionAutomation$addWorkBoatChoice$twoTurnsMovement$1 = false;
                int it32 = it32.getMovement();
                if (it22 >= it32) continue;
                it22 = it32;
            }
            int twoTurnsMovement = it22 * 2;
            iterator2 = this.city.getCenterTile().getTilesInDistanceRange(new IntRange(1, twoTurnsMovement));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                it = (Tile)element$iv;
                boolean bl3 = false;
                MapUnit mapUnit = ((Tile)it).getCivilianUnit();
                boolean bl4 = mapUnit != null ? ConstructionAutomation.addWorkBoatChoice$isOurWorkBoat(mapUnit, this) : false;
                if (!bl4) continue;
                bl = true;
                break block10;
            }
            bl = alreadyHasWorkBoat = false;
        }
        if (alreadyHasWorkBoat) {
            return;
        }
        if (!ConstructionAutomation.addWorkBoatChoice$findTileWorthImproving(this)) {
            return;
        }
        $this$any$iv = buildableWorkboatUnits2;
        ArrayList<ConstructionChoice> arrayList = this.relativeCostEffectiveness;
        ConstructionAutomation constructionAutomation = this;
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t = minElem$iv;
        } else {
            it = (BaseUnit)minElem$iv;
            boolean bl = false;
            int minValue$iv = ((BaseUnit)it).getCost();
            do {
                Object e$iv = iterator$iv.next();
                BaseUnit it2 = (BaseUnit)e$iv;
                $i$a$-minByOrThrow-ConstructionAutomation$addWorkBoatChoice$1 = false;
                int v$iv = it2.getCost();
                if (minValue$iv <= v$iv) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t = minElem$iv;
        }
        Object t2 = t;
        constructionAutomation.addChoice(arrayList, ((BaseUnit)t2).getName(), 0.6f);
    }

    /*
     * WARNING - void declaration
     */
    private final void addWorkerChoice() {
        int numberOfWorkersWeWant;
        Sequence<BaseUnit> workerEquivalents2 = this.filterBuildable(SequencesKt.filter(this.units, (Function1)new Function1<BaseUnit, Boolean>(this){
            final /* synthetic */ ConstructionAutomation this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull BaseUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.BuildImprovements, null, 2, null) && Automation.INSTANCE.allowAutomatedConstruction(ConstructionAutomation.access$getCivInfo$p(this.this$0), ConstructionAutomation.access$getCity$p(this.this$0), it);
            }
        }));
        if (SequencesKt.none(workerEquivalents2)) {
            return;
        }
        int n = numberOfWorkersWeWant = this.cities <= 5 ? this.cities : 5 + (this.cities - 2);
        if (this.workers < (float)numberOfWorkersWeWant) {
            Object var14_17;
            Object v1;
            void $this$minByOrNull$iv;
            float modifier = (float)numberOfWorkersWeWant / (this.workers + 0.4f);
            if (!this.cityIsOverAverageProduction) {
                modifier /= (float)5;
            }
            Sequence<BaseUnit> sequence = workerEquivalents2;
            ArrayList<ConstructionChoice> arrayList = this.relativeCostEffectiveness;
            ConstructionAutomation constructionAutomation = this;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    BaseUnit it = (BaseUnit)minElem$iv;
                    boolean bl = false;
                    int minValue$iv = it.getCost();
                    do {
                        Object e$iv = iterator$iv.next();
                        BaseUnit it2 = (BaseUnit)e$iv;
                        $i$a$-minByOrNull-ConstructionAutomation$addWorkerChoice$1 = false;
                        int v$iv = it2.getCost();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            Object v2 = var14_17 = v1;
            Intrinsics.checkNotNull(v2);
            constructionAutomation.addChoice(arrayList, ((BaseUnit)v2).getName(), modifier);
        }
    }

    private final void addSpaceshipPartChoice() {
        if (!Civilization.hasUnique$default(this.civInfo, UniqueType.EnablesConstructionOfSpaceshipParts, null, 2, null)) {
            return;
        }
        INonPerpetualConstruction iNonPerpetualConstruction = SequencesKt.firstOrNull(this.filterBuildable(SequencesKt.filter(SequencesKt.plus(this.nonWonders, this.units), new Function1<?, Boolean>(this){
            final /* synthetic */ ConstructionAutomation this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IHasUniques it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return ConstructionAutomation.access$getSpaceshipParts$p(this.this$0).contains(((INonPerpetualConstruction)it).getName());
            }
        })));
        if (iNonPerpetualConstruction == null) {
            return;
        }
        INonPerpetualConstruction spaceshipPart2 = iNonPerpetualConstruction;
        float modifier = 3.0f * this.personality.modifierFocus(PersonalityValue.Science, 0.4f);
        this.addChoice(this.relativeCostEffectiveness, spaceshipPart2.getName(), modifier);
    }

    private final void addBuildingChoices() {
        Iterator<Building> iterator2 = this.filterBuildable(this.buildings).iterator();
        while (iterator2.hasNext()) {
            Building building = iterator2.next();
            if (building.isWonder() && this.city.isPuppet()) continue;
            String string = building.getName();
            Intrinsics.checkNotNullExpressionValue(building, "building");
            this.addChoice(this.relativeCostEffectiveness, string, this.getValueOfBuilding(building));
        }
    }

    private final float getValueOfBuilding(Building building) {
        float value = 0.0f;
        value += this.applyBuildingStats(building);
        value += this.applyMilitaryBuildingValue(building);
        value += this.applyVictoryBuildingValue(building);
        return value += this.applyOnetimeUniqueBonuses(building);
    }

    private final float applyOnetimeUniqueBonuses(Building building) {
        float value = 0.0f;
        return value;
    }

    private final float applyVictoryBuildingValue(Building building) {
        float value = 0.0f;
        if (!this.cityIsOverAverageProduction) {
            return value;
        }
        if (building.isWonder()) {
            value += 2.0f;
        }
        if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)building, UniqueType.TriggersCulturalVictory, null, 2, null)) {
            value += 10.0f * this.personality.modifierFocus(PersonalityValue.Culture, 0.3f);
        }
        if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)building, UniqueType.EnablesConstructionOfSpaceshipParts, null, 2, null)) {
            value += 10.0f * this.personality.modifierFocus(PersonalityValue.Science, 0.3f);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    private final float applyMilitaryBuildingValue(Building building) {
        boolean bl;
        Object object;
        float warModifier;
        float value;
        block4: {
            void $this$any$iv;
            value = 0.0f;
            warModifier = this.isAtWar ? 1.0f : 0.5f;
            object = SequencesKt.mapNotNull(this.civInfo.getKnownCivs(), (Function1)new Function1<Civilization, NextTurnAutomation.CityDistance>(this){
                final /* synthetic */ ConstructionAutomation this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final NextTurnAutomation.CityDistance invoke(@NotNull Civilization it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return NextTurnAutomation.INSTANCE.getClosestCities(ConstructionAutomation.access$getCivInfo$p(this.this$0), it);
                }
            });
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                NextTurnAutomation.CityDistance it = (NextTurnAutomation.CityDistance)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getCity1(), this.city)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            warModifier *= 2.0f;
        }
        value += warModifier * (float)building.getCityHealth() / (float)this.city.getMaxHealth$core() * this.personality.inverseModifierFocus(PersonalityValue.Aggressive, 0.3f);
        value += warModifier * (float)building.getCityStrength() / (this.city.getStrength() + (float)3) * this.personality.inverseModifierFocus(PersonalityValue.Aggressive, 0.3f);
        object = building.getMatchingUniques(UniqueType.UnitStartingExperience, this.cityState).iterator();
        while (object.hasNext()) {
            Unique experienceUnique = (Unique)object.next();
            float modifier = Float.parseFloat(experienceUnique.getParams().get(1)) / (float)5;
            modifier *= this.cityIsOverAverageProduction ? 1.0f : 0.2f;
            modifier *= this.personality.modifierFocus(PersonalityValue.Military, 0.3f);
            value += (modifier *= RangesKt.coerceAtLeast(this.personality.modifierFocus(PersonalityValue.Aggressive, 0.2f), 1.0f));
        }
        if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)building, UniqueType.EnablesNuclearWeapons, null, 2, null) && !Civilization.hasUnique$default(this.civInfo, UniqueType.EnablesNuclearWeapons, null, 2, null)) {
            value += 4.0f * this.personality.modifierFocus(PersonalityValue.Military, 0.3f);
        }
        return value;
    }

    private final float applyBuildingStats(Building building) {
        Stats buildingStats = this.city.getCityStats().getStatDifferenceFromBuilding(building.getName());
        this.getBuildingStatsFromUniques(building, buildingStats);
        float surplusFood = this.city.getCityStats().getCurrentCityStats().get(Stat.Food);
        if (surplusFood < 0.0f) {
            buildingStats.setFood(buildingStats.getFood() * (float)8);
        } else if (this.city.getPopulation().getPopulation() < 5) {
            buildingStats.setFood(buildingStats.getFood() * (float)3);
        }
        if (buildingStats.getGold() < 0.0f && this.civInfo.getStats().getStatsForNextTurn().getGold() < 10.0f) {
            buildingStats.setGold(buildingStats.getGold() * (float)2);
        }
        if (this.civInfo.getHappiness() < 5) {
            float cfr_ignored_0 = buildingStats.getHappiness() * (float)3;
        } else if (this.civInfo.getHappiness() < 10 || this.civInfo.getHappiness() < this.civInfo.getCities().size()) {
            float cfr_ignored_1 = buildingStats.getHappiness() * (float)2;
        }
        if (this.city.getCityStats().getCurrentCityStats().getCulture() < 1.0f) {
            buildingStats.setCulture(buildingStats.getCulture() * (float)2);
        } else if (this.city.getTiles().size() < 12 && this.city.getPopulation().getPopulation() < 5) {
            buildingStats.setCulture(buildingStats.getCulture() * (float)2);
        }
        for (Stat stat : Stat.values()) {
            if (this.civInfo.wantsToFocusOn(stat)) {
                buildingStats.set(stat, buildingStats.get(stat) * 2.0f);
            }
            buildingStats.set(stat, buildingStats.get(stat) * this.personality.modifierFocus(PersonalityValue.Companion.get(stat), 0.5f));
        }
        return Automation.INSTANCE.rankStatsValue(this.civInfo.getPersonality().scaleStats(buildingStats.clone(), 0.3f), this.civInfo);
    }

    private final void getBuildingStatsFromUniques(Building building, Stats buildingStats) {
        float relativeAmount;
        Unique unique;
        Iterator<Unique> iterator2 = building.getMatchingUniques(UniqueType.StatPercentBonusCities, this.cityState).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            Stat statType = Stat.valueOf(unique.getParams().get(1));
            relativeAmount = Float.parseFloat(unique.getParams().get(0)) / 100.0f;
            float amount = this.civInfo.getStats().getStatsForNextTurn().get(statType) * relativeAmount;
            buildingStats.set(statType, buildingStats.get(statType) + amount);
        }
        iterator2 = building.getMatchingUniques(UniqueType.CarryOverFood, this.cityState).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            if (!City.matchesFilter$default(this.city, unique.getParams().get(1), null, 2, null) || Integer.parseInt(unique.getParams().get(0)) == 0) continue;
            float foodGain = this.cityStats.getCurrentCityStats().getFood() + buildingStats.getFood();
            relativeAmount = Float.parseFloat(unique.getParams().get(0)) / 100.0f;
            Stat stat = Stat.Food;
            buildingStats.set(stat, buildingStats.get(stat) + foodGain * relativeAmount);
        }
    }

    private static final boolean addWorkBoatChoice$isOurWorkBoat(MapUnit $this$addWorkBoatChoice_u24isOurWorkBoat, ConstructionAutomation this$0) {
        return $this$addWorkBoatChoice_u24isOurWorkBoat.getCache().getHasUniqueToCreateWaterImprovements() && Intrinsics.areEqual($this$addWorkBoatChoice_u24isOurWorkBoat.getCiv(), this$0.civInfo);
    }

    private static final boolean addWorkBoatChoice$isWorthImproving(Tile $this$addWorkBoatChoice_u24isWorthImproving, ConstructionAutomation this$0) {
        if (!Intrinsics.areEqual($this$addWorkBoatChoice_u24isWorthImproving.getOwner(), this$0.civInfo)) {
            return false;
        }
        if (!WorkerAutomation.Companion.hasWorkableSeaResource($this$addWorkBoatChoice_u24isWorthImproving, this$0.civInfo)) {
            return false;
        }
        return WorkerAutomation.Companion.isNotBonusResourceOrWorkable($this$addWorkBoatChoice_u24isWorthImproving, this$0.civInfo);
    }

    private static final boolean addWorkBoatChoice$findTileWorthImproving(ConstructionAutomation this$0) {
        int searchMaxTiles = this$0.civInfo.getGameInfo().getRuleset().getModOptions().getConstants().getWorkboatAutomationSearchMaxTiles();
        BFS bfs2 = new BFS(this$0.city.getCenterTile(), (Function1<? super Tile, Boolean>)new Function1<Tile, Boolean>(this$0){
            final /* synthetic */ ConstructionAutomation this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !(!it.isWater() && !it.isCityCenter() || it.getOwner() != null && !it.isFriendlyTerritory(ConstructionAutomation.access$getCivInfo$p(this.this$0)) || !it.isExplored(ConstructionAutomation.access$getCivInfo$p(this.this$0)));
            }
        });
        while (bfs2.nextStep() != null) {
            Tile tile;
            if (ConstructionAutomation.addWorkBoatChoice$isWorthImproving(tile, this$0)) {
                return true;
            }
            if (bfs2.size() < searchMaxTiles) continue;
        }
        return false;
    }

    public static final /* synthetic */ HashMap access$getBuildableBuildings$p(ConstructionAutomation $this) {
        return $this.buildableBuildings;
    }

    public static final /* synthetic */ HashMap access$getBuildableUnits$p(ConstructionAutomation $this) {
        return $this.buildableUnits;
    }

    public static final /* synthetic */ Civilization access$getCivInfo$p(ConstructionAutomation $this) {
        return $this.civInfo;
    }

    public static final /* synthetic */ City access$getCity$p(ConstructionAutomation $this) {
        return $this.city;
    }

    public static final /* synthetic */ HashSet access$getSpaceshipParts$p(ConstructionAutomation $this) {
        return $this.spaceshipParts;
    }

    public static final /* synthetic */ Set access$getDisabledAutoAssignConstructions$p(ConstructionAutomation $this) {
        return $this.disabledAutoAssignConstructions;
    }

    public static final /* synthetic */ boolean access$shouldAvoidConstruction(ConstructionAutomation $this, IConstruction construction2) {
        return $this.shouldAvoidConstruction(construction2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/unciv/logic/automation/city/ConstructionAutomation$ConstructionChoice;", "", "choice", "", "choiceModifier", "", "remainingWork", "", "production", "(Ljava/lang/String;FII)V", "getChoice", "()Ljava/lang/String;", "getChoiceModifier", "()F", "setChoiceModifier", "(F)V", "getProduction", "()I", "getRemainingWork", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "core"})
    private static final class ConstructionChoice {
        @NotNull
        private final String choice;
        private float choiceModifier;
        private final int remainingWork;
        private final int production;

        public ConstructionChoice(@NotNull String choice, float choiceModifier, int remainingWork, int production) {
            Intrinsics.checkNotNullParameter(choice, "choice");
            this.choice = choice;
            this.choiceModifier = choiceModifier;
            this.remainingWork = remainingWork;
            this.production = production;
        }

        @NotNull
        public final String getChoice() {
            return this.choice;
        }

        public final float getChoiceModifier() {
            return this.choiceModifier;
        }

        public final void setChoiceModifier(float f) {
            this.choiceModifier = f;
        }

        public final int getRemainingWork() {
            return this.remainingWork;
        }

        public final int getProduction() {
            return this.production;
        }

        @NotNull
        public final String component1() {
            return this.choice;
        }

        public final float component2() {
            return this.choiceModifier;
        }

        public final int component3() {
            return this.remainingWork;
        }

        public final int component4() {
            return this.production;
        }

        @NotNull
        public final ConstructionChoice copy(@NotNull String choice, float choiceModifier, int remainingWork, int production) {
            Intrinsics.checkNotNullParameter(choice, "choice");
            return new ConstructionChoice(choice, choiceModifier, remainingWork, production);
        }

        public static /* synthetic */ ConstructionChoice copy$default(ConstructionChoice constructionChoice, String string, float f, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = constructionChoice.choice;
            }
            if ((n3 & 2) != 0) {
                f = constructionChoice.choiceModifier;
            }
            if ((n3 & 4) != 0) {
                n = constructionChoice.remainingWork;
            }
            if ((n3 & 8) != 0) {
                n2 = constructionChoice.production;
            }
            return constructionChoice.copy(string, f, n, n2);
        }

        @NotNull
        public String toString() {
            return "ConstructionChoice(choice=" + this.choice + ", choiceModifier=" + this.choiceModifier + ", remainingWork=" + this.remainingWork + ", production=" + this.production + ')';
        }

        public int hashCode() {
            int result2 = this.choice.hashCode();
            result2 = result2 * 31 + Float.hashCode(this.choiceModifier);
            result2 = result2 * 31 + Integer.hashCode(this.remainingWork);
            result2 = result2 * 31 + Integer.hashCode(this.production);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConstructionChoice)) {
                return false;
            }
            ConstructionChoice constructionChoice = (ConstructionChoice)other;
            if (!Intrinsics.areEqual(this.choice, constructionChoice.choice)) {
                return false;
            }
            if (Float.compare(this.choiceModifier, constructionChoice.choiceModifier) != 0) {
                return false;
            }
            if (this.remainingWork != constructionChoice.remainingWork) {
                return false;
            }
            return this.production == constructionChoice.production;
        }
    }
}

