/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.civilization;

import com.unciv.logic.automation.Automation;
import com.unciv.logic.automation.ThreatLevel;
import com.unciv.logic.automation.civilization.BarbarianAutomation;
import com.unciv.logic.automation.civilization.DiplomacyAutomation;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.automation.civilization.ReligionAutomation;
import com.unciv.logic.automation.civilization.TradeAutomation;
import com.unciv.logic.automation.civilization.UseGoldAutomation;
import com.unciv.logic.automation.unit.EspionageAutomation;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.CityStateFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.managers.GreatPersonManager;
import com.unciv.logic.civilization.managers.PolicyManager;
import com.unciv.logic.civilization.managers.ThreatManager;
import com.unciv.logic.civilization.managers.UnitManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.MilestoneType;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.PersonalityValue;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stat;
import com.unciv.ui.screens.victoryscreen.RankingType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J\u0016\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0006H\u0002J'\u0010#\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\b\b\u0002\u0010%\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b&\u00a8\u0006("}, d2={"Lcom/unciv/logic/automation/civilization/NextTurnAutomation;", "", "()V", "adoptPolicy", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "automateCities", "automateCityBombardment", "automateCivMoves", "automateGoldToSciencePercentage", "automateUnits", "bullyCityStates", "chooseGreatPerson", "chooseTechToResearch", "freeUpSpaceResources", "getClosestCities", "Lcom/unciv/logic/automation/civilization/NextTurnAutomation$CityDistance;", "civ1", "civ2", "getMinDistanceBetweenCities", "", "getUnitPriority", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "isAtWar", "", "issueRequests", "onCitySettledNearBorders", "otherCiv", "protectCityStates", "respondToPopupAlerts", "trainSettler", "tryVoteForDiplomaticVictory", "civ", "valueCityStateAlliance", "cityState", "includeQuests", "valueCityStateAlliance$core", "CityDistance", "core"})
@SourceDebugExtension(value={"SMAP\nNextTurnAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextTurnAutomation.kt\ncom/unciv/logic/automation/civilization/NextTurnAutomation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,576:1\n1774#2,3:577\n1549#2:580\n1620#2,3:581\n1777#2:584\n766#2:585\n857#2,2:586\n766#2:588\n857#2,2:589\n766#2:599\n857#2,2:600\n766#2:602\n857#2,2:603\n288#2,2:605\n288#2,2:607\n288#2,2:609\n766#2:628\n857#2,2:629\n766#2:632\n857#2,2:633\n1747#2,3:637\n766#2:640\n857#2:641\n858#2:644\n1747#2,3:648\n819#2:651\n847#2,2:652\n766#2:654\n857#2:655\n858#2:661\n1963#2,14:662\n2333#2,14:676\n2333#2,14:690\n467#3,7:591\n361#3,7:708\n1#4:598\n553#5,3:611\n1821#6,14:614\n603#6:631\n1229#6,2:635\n2141#6,2:642\n1250#6,3:645\n1250#6,3:656\n1229#6,2:659\n970#6:704\n999#6,3:705\n1002#6,3:715\n*S KotlinDebug\n*F\n+ 1 NextTurnAutomation.kt\ncom/unciv/logic/automation/civilization/NextTurnAutomation\n*L\n198#1:577,3\n200#1:580\n200#1:581,3\n198#1:584\n309#1:585\n309#1:586,2\n316#1:588\n316#1:589,2\n332#1:599\n332#1:600,2\n343#1:602\n343#1:603,2\n351#1:605,2\n356#1:607,2\n360#1:609,2\n389#1:628\n389#1:629,2\n437#1:632\n437#1:633,2\n472#1:637,3\n477#1:640\n477#1:641\n477#1:644\n484#1:648,3\n489#1:651\n489#1:652,2\n492#1:654\n492#1:655\n492#1:661\n496#1:662,14\n499#1:676,14\n573#1:690,14\n323#1:591,7\n243#1:708,7\n373#1:611,3\n383#1:614,14\n406#1:631\n471#1:635,2\n479#1:642,2\n482#1:645,3\n494#1:656,3\n495#1:659,2\n243#1:704\n243#1:705,3\n243#1:715,3\n*E\n"})
public final class NextTurnAutomation {
    @NotNull
    public static final NextTurnAutomation INSTANCE = new NextTurnAutomation();

    private NextTurnAutomation() {
    }

    public final void automateCivMoves(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        if (civInfo.isBarbarian()) {
            new BarbarianAutomation(civInfo).automate();
            return;
        }
        if (civInfo.isSpectator()) {
            return;
        }
        this.respondToPopupAlerts(civInfo);
        TradeAutomation.INSTANCE.respondToTradeRequests(civInfo);
        if (civInfo.isMajorCiv()) {
            if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)civInfo.getGameInfo().getRuleset().getModOptions(), UniqueType.DiplomaticRelationshipsCannotChange, null, 2, null)) {
                DiplomacyAutomation.INSTANCE.declareWar$core(civInfo);
                DiplomacyAutomation.INSTANCE.offerPeaceTreaty$core(civInfo);
                DiplomacyAutomation.INSTANCE.askForHelp$core(civInfo);
                DiplomacyAutomation.INSTANCE.offerDeclarationOfFriendship$core(civInfo);
            }
            if (civInfo.getGameInfo().isReligionEnabled()) {
                ReligionAutomation.INSTANCE.spendFaithOnReligion(civInfo);
            }
            DiplomacyAutomation.INSTANCE.offerOpenBorders$core(civInfo);
            DiplomacyAutomation.INSTANCE.offerResearchAgreement$core(civInfo);
            DiplomacyAutomation.INSTANCE.offerDefensivePact$core(civInfo);
            TradeAutomation.INSTANCE.exchangeLuxuries(civInfo);
            this.issueRequests(civInfo);
            this.adoptPolicy(civInfo);
            this.freeUpSpaceResources(civInfo);
        } else {
            civInfo.getCityStateFunctions().getFreeTechForCityState();
            civInfo.getCityStateFunctions().updateDiplomaticRelationshipForCityState();
        }
        this.chooseTechToResearch(civInfo);
        this.automateCityBombardment(civInfo);
        UseGoldAutomation.INSTANCE.useGold(civInfo);
        if (!civInfo.isCityState()) {
            this.protectCityStates(civInfo);
            this.bullyCityStates(civInfo);
        }
        this.automateUnits(civInfo);
        if (civInfo.isMajorCiv()) {
            if (civInfo.getGameInfo().isReligionEnabled()) {
                ReligionAutomation.INSTANCE.chooseReligiousBeliefs$core(civInfo);
            }
            if (civInfo.getGameInfo().isEspionageEnabled()) {
                new EspionageAutomation(civInfo).automateSpies();
            }
        }
        this.automateCities(civInfo);
        this.trainSettler(civInfo);
        this.tryVoteForDiplomaticVictory(civInfo);
    }

    public final void automateGoldToSciencePercentage(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        int estimatedIncome = (int)civInfo.getStats().getStatsForNextTurn().getGold();
        int projectedGold = civInfo.getGold() + estimatedIncome;
        int pissPoor = civInfo.getTech().getEra().getBaseUnitBuyCost();
        int stinkingRich = civInfo.getTech().getEra().getStartingGold() * 10 + civInfo.getCities().size() * 2 * pissPoor;
        float maxPercent = 0.8f;
        civInfo.getTech().setGoldPercentConvertedToScience(civInfo.getGold() <= 0 ? 0.0f : (projectedGold <= pissPoor ? 0.0f : RangesKt.coerceAtMost((float)(projectedGold - pissPoor) * maxPercent / (float)stinkingRich, maxPercent)));
    }

    private final void respondToPopupAlerts(Civilization civInfo) {
        for (PopupAlert popupAlert : CollectionsKt.toList((Iterable)civInfo.getPopupAlerts())) {
            String[] stringArray;
            DiplomacyManager diploManager;
            if (popupAlert.getType() == AlertType.DemandToStopSettlingCitiesNear) {
                Civilization demandingCiv = civInfo.getGameInfo().getCivilization(popupAlert.getValue());
                Intrinsics.checkNotNull(civInfo.getDiplomacyManager(demandingCiv));
                if (Automation.INSTANCE.threatAssessment(civInfo, demandingCiv).compareTo((Enum)ThreatLevel.High) >= 0) {
                    diploManager.agreeNotToSettleNear();
                } else {
                    diploManager.refuseDemandNotToSettleNear();
                }
            }
            if (popupAlert.getType() != AlertType.DeclarationOfFriendship) continue;
            Civilization requestingCiv = civInfo.getGameInfo().getCivilization(popupAlert.getValue());
            Intrinsics.checkNotNull(civInfo.getDiplomacyManager(requestingCiv));
            if (civInfo.getDiplomacyFunctions().canSignDeclarationOfFriendshipWith(requestingCiv) && DiplomacyAutomation.INSTANCE.wantsToSignDeclarationOfFrienship$core(civInfo, requestingCiv)) {
                diploManager.signDeclarationOfFriendship();
                stringArray = new String[]{"OtherIcons/Diplomacy", civInfo.getCivName()};
                requestingCiv.addNotification("We have signed a Declaration of Friendship with [" + civInfo.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, stringArray);
                continue;
            }
            diploManager.otherCivDiplomacy().setFlag(DiplomacyFlags.DeclinedDeclarationOfFriendship, 10);
            stringArray = new String[]{"OtherIcons/Diplomacy", civInfo.getCivName()};
            requestingCiv.addNotification('[' + civInfo.getCivName() + "] has denied our Declaration of Friendship!", Notification.NotificationCategory.Diplomacy, stringArray);
        }
        civInfo.getPopupAlerts().clear();
    }

    /*
     * Unable to fully structure code
     */
    public final int valueCityStateAlliance$core(@NotNull Civilization civInfo, @NotNull Civilization cityState, boolean includeQuests) {
        block26: {
            block25: {
                Intrinsics.checkNotNullParameter(civInfo, "civInfo");
                Intrinsics.checkNotNullParameter(cityState, "cityState");
                value = 0;
                civPersonality = civInfo.getPersonality();
                if (cityState.getCityStateFunctions().canProvideStat(Stat.Culture)) {
                    if (civInfo.wantsToFocusOn(Victory.Focus.Culture)) {
                        value += 10;
                    }
                    value += (int)civPersonality.get(PersonalityValue.Culture) - 5;
                }
                if (cityState.getCityStateFunctions().canProvideStat(Stat.Faith)) {
                    if (civInfo.wantsToFocusOn(Victory.Focus.Faith)) {
                        value += 10;
                    }
                    value += (int)civPersonality.get(PersonalityValue.Faith) - 5;
                }
                if (cityState.getCityStateFunctions().canProvideStat(Stat.Production)) {
                    if (civInfo.wantsToFocusOn(Victory.Focus.Production)) {
                        value += 10;
                    }
                    value += (int)civPersonality.get(PersonalityValue.Production) - 5;
                }
                if (cityState.getCityStateFunctions().canProvideStat(Stat.Science)) {
                    if (civInfo.wantsToFocusOn(Victory.Focus.Science)) {
                        value += 10;
                    }
                    value += (int)civPersonality.get(PersonalityValue.Science) - 5;
                }
                if (civInfo.wantsToFocusOn(Victory.Focus.Military)) {
                    if (!cityState.isAlive()) {
                        value -= 5;
                    } else {
                        distance = this.getMinDistanceBetweenCities(civInfo, cityState);
                        if (distance < 20) {
                            value -= (20 - distance) / 4;
                        }
                    }
                }
                if (civInfo.wantsToFocusOn(Victory.Focus.CityStates)) {
                    value += 5;
                }
                if (civInfo.getHappiness() < 5 && cityState.getCityStateFunctions().canProvideStat(Stat.Happiness)) {
                    value += 10 - civInfo.getHappiness();
                    value += (int)civPersonality.get(PersonalityValue.Happiness) - 5;
                }
                if (civInfo.getHappiness() > 5 && cityState.getCityStateFunctions().canProvideStat(Stat.Food)) {
                    value += 5;
                    value += (int)civPersonality.get(PersonalityValue.Food) - 5;
                }
                if (!cityState.isAlive() || cityState.getCities().isEmpty() || civInfo.getCities().isEmpty()) {
                    return value;
                }
                if (civInfo.knows(cityState)) {
                    v0 = cityState.getDiplomacyManager(civInfo);
                    Intrinsics.checkNotNull(v0);
                    v1 = (int)v0.getInfluence();
                } else {
                    v1 = 0;
                }
                ourInfluence = v1;
                value += ourInfluence / 10;
                if (civInfo.getGold() < 100 && ourInfluence < 30) {
                    value -= 5;
                }
                if (cityState.getAllyCiv() != null && !Intrinsics.areEqual(cityState.getAllyCiv(), civInfo.getCivName())) {
                    v2 = cityState.getAllyCiv();
                    Intrinsics.checkNotNull(v2);
                    v3 = cityState.getDiplomacyManager(v2);
                    Intrinsics.checkNotNull(v3);
                    thirdCivInfluence = (int)v3.getInfluence();
                    value -= (thirdCivInfluence - 30) / 10;
                }
                thirdCivInfluence = cityState.getDetailedCivResources();
                var24_9 = value;
                $i$f$count = false;
                if (!($this$count$iv instanceof Collection) || !((Collection)$this$count$iv).isEmpty()) break block25;
                v4 = 0;
                break block26;
            }
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = (ResourceSupplyList.ResourceSupply)element$iv;
                $i$a$-count-NextTurnAutomation$valueCityStateAlliance$1 = false;
                if (it.getResource().getResourceType() != ResourceType.Luxury) ** GOTO lbl-1000
                $this$map$iv = civInfo.getDetailedCivResources();
                $i$f$map = false;
                var16_18 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var21_23 = (ResourceSupplyList.ResourceSupply)item$iv$iv;
                    var22_24 = destination$iv$iv;
                    $i$a$-map-NextTurnAutomation$valueCityStateAlliance$1$1 = false;
                    var22_24.add(supply.getResource());
                }
                if (!((List)destination$iv$iv).contains(it.getResource())) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                if (!v5 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v4 = count$iv;
        }
        var25_26 = v4;
        value = var24_9 + var25_26;
        if (includeQuests) {
            value += (int)(cityState.getQuestManager().getInvestmentMultiplier(civInfo.getCivName()) * (float)10) - 10;
        }
        return value;
    }

    public static /* synthetic */ int valueCityStateAlliance$core$default(NextTurnAutomation nextTurnAutomation, Civilization civilization, Civilization civilization2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return nextTurnAutomation.valueCityStateAlliance$core(civilization, civilization2, bl);
    }

    private final void protectCityStates(Civilization civInfo) {
        Iterator<Civilization> iterator2 = SequencesKt.filter(civInfo.getKnownCivs(), protectCityStates.1.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            DiplomacyManager diplomacyManager;
            Civilization state = iterator2.next();
            Intrinsics.checkNotNull(state.getDiplomacyManager(civInfo.getCivName()));
            boolean isAtLeastFriend = diplomacyManager.isRelationshipLevelGE(RelationshipLevel.Friend);
            if (isAtLeastFriend && state.getCityStateFunctions().otherCivCanPledgeProtection(civInfo)) {
                state.getCityStateFunctions().addProtectorCiv(civInfo);
                continue;
            }
            if (isAtLeastFriend || !state.getCityStateFunctions().otherCivCanWithdrawProtection(civInfo)) continue;
            CityStateFunctions.removeProtectorCiv$default(state.getCityStateFunctions(), civInfo, false, 2, null);
        }
    }

    private final void bullyCityStates(Civilization civInfo) {
        for (Civilization state : SequencesKt.toList(SequencesKt.filter(civInfo.getKnownCivs(), bullyCityStates.1.INSTANCE))) {
            DiplomacyManager diplomacyManager;
            Intrinsics.checkNotNull(state.getDiplomacyManager(civInfo.getCivName()));
            if (!diplomacyManager.isRelationshipLevelLT(RelationshipLevel.Friend) || diplomacyManager.getDiplomaticStatus() != DiplomaticStatus.Peace || NextTurnAutomation.valueCityStateAlliance$core$default(this, civInfo, state, false, 4, null) > 0 || CityStateFunctions.getTributeWillingness$default(state.getCityStateFunctions(), civInfo, false, 2, null) < 0) continue;
            if (state.getCityStateFunctions().getTributeWillingness(civInfo, true) > 0) {
                state.getCityStateFunctions().tributeWorker(civInfo);
                continue;
            }
            state.getCityStateFunctions().tributeGold(civInfo);
        }
    }

    private final void chooseTechToResearch(Civilization civInfo) {
        List<List<Technology>> costs;
        while (civInfo.getTech().getFreeTechs() > 0) {
            costs = NextTurnAutomation.chooseTechToResearch$getGroupedResearchableTechs(civInfo);
            if (costs.isEmpty()) {
                return;
            }
            List<Technology> mostExpensiveTechs = costs.get(costs.size() - 1);
            civInfo.getTech().getFreeTechnology(((Technology)CollectionsKt.random((Collection)mostExpensiveTechs, Random.Default)).getName());
        }
        if (civInfo.getTech().getTechsToResearch().isEmpty()) {
            Technology technology2;
            costs = NextTurnAutomation.chooseTechToResearch$getGroupedResearchableTechs(civInfo);
            if (costs.isEmpty()) {
                return;
            }
            List<Technology> cheapestTechs = costs.get(0);
            if (cheapestTechs.size() == 1 || costs.size() == 1) {
                technology2 = (Technology)CollectionsKt.random((Collection)cheapestTechs, Random.Default);
            } else {
                List<Technology> techsAdvanced = costs.get(1);
                technology2 = (Technology)CollectionsKt.random(CollectionsKt.plus((Collection)cheapestTechs, (Iterable)techsAdvanced), Random.Default);
            }
            Technology techToResearch = technology2;
            civInfo.getTech().getTechsToResearch().add(techToResearch.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void adoptPolicy(Civilization civInfo) {
        while (civInfo.getPolicies().canAdoptPolicy()) {
            Policy policy2;
            Map.Entry<PolicyBranch, Integer> entry;
            Map.Entry<PolicyBranch, Integer> entry$iv2;
            Set set2;
            Iterable $this$filterTo$iv$iv;
            boolean $i$f$filterTo;
            Collection destination$iv$iv;
            boolean $i$f$filter;
            Iterable $this$filter$iv;
            Set<PolicyBranch> incompleteBranches = civInfo.getPolicies().getIncompleteBranches();
            Set<PolicyBranch> adoptableBranches = civInfo.getPolicies().getAdoptableBranches();
            if (incompleteBranches.isEmpty() && adoptableBranches.isEmpty()) {
                return;
            }
            Map<PolicyBranch, Integer> priorityMap = civInfo.getPolicies().getPriorityMap();
            Integer maxIncompletePriority = null;
            maxIncompletePriority = civInfo.getPolicies().getMaxPriority(incompleteBranches);
            Integer maxAdoptablePriority = null;
            maxAdoptablePriority = civInfo.getPolicies().getMaxPriority(adoptableBranches);
            if (maxIncompletePriority == null) {
                Integer n = maxAdoptablePriority;
                Intrinsics.checkNotNull(n);
                maxIncompletePriority = ((Number)n).intValue() - 1;
            }
            if (maxAdoptablePriority == null) {
                maxAdoptablePriority = ((Number)maxIncompletePriority).intValue() - 1;
            }
            if (((Number)maxAdoptablePriority).intValue() <= ((Number)maxIncompletePriority).intValue()) {
                $this$filter$iv = incompleteBranches;
                $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PolicyBranch it = (PolicyBranch)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(priorityMap.get(it), maxIncompletePriority)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                set2 = CollectionsKt.toSet((List)destination$iv$iv);
            } else {
                $this$filter$iv = adoptableBranches;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PolicyBranch it = (PolicyBranch)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(priorityMap.get(it), maxAdoptablePriority)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                set2 = CollectionsKt.toSet((List)destination$iv$iv);
            }
            Set candidates2 = set2;
            Map<PolicyBranch, Integer> $this$filterKeys$iv = civInfo.getPolicies().getBranchCompletionMap();
            boolean $i$f$filterKeys = false;
            Object result$iv = new LinkedHashMap();
            for (Map.Entry<PolicyBranch, Integer> entry$iv2 : $this$filterKeys$iv.entrySet()) {
                PolicyBranch key = entry$iv2.getKey();
                boolean bl = false;
                if (!candidates2.contains(key)) continue;
                ((HashMap)result$iv).put(entry$iv2.getKey(), entry$iv2.getValue());
            }
            Map candidateCompletionMap = (Map)result$iv;
            Iterator<Map.Entry<PolicyBranch, Integer>> $i$f$filterTo2 = (result$iv = (Iterable)candidateCompletionMap.entrySet()).iterator();
            if (!$i$f$filterTo2.hasNext()) {
                throw new NoSuchElementException();
            }
            entry$iv2 = $i$f$filterTo2.next();
            if (!$i$f$filterTo2.hasNext()) {
                entry = entry$iv2;
            } else {
                Map.Entry<PolicyBranch, Integer> it22 = entry$iv2;
                boolean bl = false;
                int it22 = it22.getKey().getPolicies().size() - ((Number)it22.getValue()).intValue();
                do {
                    Map.Entry<PolicyBranch, Integer> it = bl = $i$f$filterTo2.next();
                    $i$a$-minByOrThrow-NextTurnAutomation$adoptPolicy$targetBranch$1 = false;
                    int n = it.getKey().getPolicies().size() - ((Number)it.getValue()).intValue();
                    if (it22 <= n) continue;
                    entry$iv2 = bl;
                    it22 = n;
                } while ($i$f$filterTo2.hasNext());
                entry = entry$iv2;
            }
            PolicyBranch targetBranch = entry.getKey();
            if (PolicyManager.isAdoptable$default(civInfo.getPolicies(), targetBranch, false, 2, null)) {
                policy2 = targetBranch;
            } else {
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2 = targetBranch.getPolicies();
                boolean $i$f$filter2 = false;
                entry$iv2 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    Policy it = (Policy)element$iv$iv;
                    boolean bl = false;
                    if (!PolicyManager.isAdoptable$default(civInfo.getPolicies(), it, false, 2, null)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                policy2 = (Policy)CollectionsKt.random((List)destination$iv$iv2, Random.Default);
            }
            Policy policyToAdopt = policy2;
            PolicyManager.adopt$default(civInfo.getPolicies(), policyToAdopt, false, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void chooseGreatPerson(@NotNull Civilization civInfo) {
        Object v4;
        UnitManager unitManager;
        BaseUnit baseUnit;
        BaseUnit greatPerson;
        boolean mayanGreatPerson;
        block15: {
            void $this$firstOrNull$iv;
            BaseUnit it;
            Iterable $this$firstOrNull$iv2;
            Collection greatPeople;
            Collection collection;
            Intrinsics.checkNotNullParameter(civInfo, "civInfo");
            if (civInfo.getGreatPeople().getFreeGreatPeople() == 0) {
                return;
            }
            boolean bl = mayanGreatPerson = civInfo.getGreatPeople().getMayaLimitedFreeGP() > 0;
            if (mayanGreatPerson) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = civInfo.getGreatPeople().getGreatPeople();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    BaseUnit it2 = (BaseUnit)element$iv$iv;
                    boolean bl2 = false;
                    if (!civInfo.getGreatPeople().getLongCountGPPool().contains(it2.getName())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                collection = (List)destination$iv$iv;
            } else {
                collection = greatPeople = (Collection)civInfo.getGreatPeople().getGreatPeople();
            }
            if (greatPeople.isEmpty()) {
                return;
            }
            greatPerson = (BaseUnit)CollectionsKt.random(greatPeople, Random.Default);
            if (civInfo.wantsToFocusOn(Victory.Focus.Culture)) {
                Object v2;
                block13: {
                    $this$firstOrNull$iv2 = greatPeople;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv2) {
                        it = (BaseUnit)element$iv;
                        boolean bl3 = false;
                        if (!it.getUniques().contains("Great Person - [Culture]")) continue;
                        v2 = element$iv;
                        break block13;
                    }
                    v2 = null;
                }
                BaseUnit culturalGP = v2;
                if (culturalGP != null) {
                    greatPerson = culturalGP;
                }
            }
            if (civInfo.wantsToFocusOn(Victory.Focus.Science)) {
                Object v3;
                block14: {
                    $this$firstOrNull$iv2 = greatPeople;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv2) {
                        it = (BaseUnit)element$iv;
                        boolean bl4 = false;
                        if (!it.getUniques().contains("Great Person - [Science]")) continue;
                        v3 = element$iv;
                        break block14;
                    }
                    v3 = null;
                }
                BaseUnit scientificGP = v3;
                if (scientificGP != null) {
                    greatPerson = scientificGP;
                }
            }
            Iterable scientificGP = civInfo.getCities();
            baseUnit = greatPerson;
            unitManager = civInfo.getUnits();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                City it3 = (City)element$iv;
                boolean bl5 = false;
                if (!it3.isCapital()) continue;
                v4 = element$iv;
                break block15;
            }
            v4 = null;
        }
        Object var15_27 = v4;
        unitManager.addUnit(baseUnit, (City)var15_27);
        GreatPersonManager greatPersonManager = civInfo.getGreatPeople();
        int n = greatPersonManager.getFreeGreatPeople();
        greatPersonManager.setFreeGreatPeople(n + -1);
        if (mayanGreatPerson) {
            civInfo.getGreatPeople().getLongCountGPPool().remove(greatPerson.getName());
            greatPersonManager = civInfo.getGreatPeople();
            n = greatPersonManager.getMayaLimitedFreeGP();
            greatPersonManager.setMayaLimitedFreeGP(n + -1);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final void freeUpSpaceResources(Civilization civInfo) {
        block15: {
            $this$none$iv = civInfo.getGameInfo().getRuleset().getVictories();
            $i$f$none = false;
            if ($this$none$iv.isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$none$iv.entrySet()) {
                    it = element$iv;
                    $i$a$-none-NextTurnAutomation$freeUpSpaceResources$1 = false;
                    v1 = civInfo.getVictoryManager().getNextMilestone((Victory)it.getValue());
                    if (!((v1 != null ? v1.getType() : null) == MilestoneType.AddedSSPartsInCapital)) continue;
                    v0 = false;
                    break block15;
                }
                v0 = true;
            }
        }
        if (v0) {
            return;
        }
        block1: for (String resource : civInfo.getGameInfo().getSpaceResources()) {
            Intrinsics.checkNotNullExpressionValue(resource, "resource");
            if (civInfo.getResourceAmount(resource) >= Automation.INSTANCE.getReservedSpaceResourceAmount(civInfo)) continue;
            element$iv = SequencesKt.filter(civInfo.getUnits().getCivUnits(), (Function1)new Function1<MapUnit, Boolean>(resource){
                final /* synthetic */ String $resource;
                {
                    this.$resource = $resource;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull MapUnit it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    String string = this.$resource;
                    Intrinsics.checkNotNullExpressionValue(string, "resource");
                    return it.requiresResource(string);
                }
            });
            $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v2 = minElem$iv;
                } else {
                    it = (MapUnit)minElem$iv;
                    $i$a$-minByOrNull-NextTurnAutomation$freeUpSpaceResources$unitToDisband$2 = false;
                    minValue$iv = it.getForceEvaluation();
                    do {
                        e$iv /* !! */  = iterator$iv.next();
                        it = (MapUnit)e$iv /* !! */ ;
                        $i$a$-minByOrNull-NextTurnAutomation$freeUpSpaceResources$unitToDisband$2 = false;
                        v$iv = it.getForceEvaluation();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv /* !! */ ;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v2 = minElem$iv;
                }
            }
            v3 = unitToDisband = (MapUnit)v2;
            if (v3 != null) {
                v3.disband();
            }
            for (City city : civInfo.getCities()) {
                if (city.getHasSoldBuildingThisTurn()) continue;
                v4 = civInfo.getGameInfo().getRuleset().getBuildings().values();
                Intrinsics.checkNotNullExpressionValue(v4, "civInfo.gameInfo.ruleset.buildings.values");
                $this$filter$iv = v4;
                $i$f$filter = false;
                e$iv /* !! */  = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Building)element$iv$iv;
                    $i$a$-filter-NextTurnAutomation$freeUpSpaceResources$buildingToSell$1 = false;
                    if (!city.getCityConstructions().isBuilt(it.getName()) || !it.requiredResources(new StateForConditionals(civInfo, city, null, null, null, null, null, null, null, false, 1020, null)).contains(resource) || !it.isSellable()) ** GOTO lbl-1000
                    v5 = civInfo.getCivConstructions();
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    if (!v5.hasFreeBuilding(city, it)) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                    if (!v6) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                buildingToSell = (Building)CollectionsKt.randomOrNull((List)destination$iv$iv, Random.Default);
                if (buildingToSell == null) continue;
                city.sellBuilding(buildingToSell);
                continue block1;
            }
        }
    }

    private final void automateUnits(Civilization civInfo) {
        boolean isAtWar = civInfo.isAtWar();
        Sequence<MapUnit> $this$sortedBy$iv = civInfo.getUnits().getCivUnits();
        boolean $i$f$sortedBy = false;
        Sequence<MapUnit> sortedUnits2 = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(isAtWar){
            final /* synthetic */ boolean $isAtWar$inlined;
            {
                this.$isAtWar$inlined = bl;
            }

            public final int compare(T a, T b) {
                MapUnit unit = (MapUnit)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(NextTurnAutomation.INSTANCE.getUnitPriority(unit, this.$isAtWar$inlined));
                unit = (MapUnit)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, NextTurnAutomation.INSTANCE.getUnitPriority(unit, this.$isAtWar$inlined));
            }
        });
        Iterator<MapUnit> iterator2 = sortedUnits2.iterator();
        while (iterator2.hasNext()) {
            MapUnit unit = iterator2.next();
            UnitAutomation.INSTANCE.automateUnitMoves(unit);
        }
    }

    public final int getUnitPriority(@NotNull MapUnit unit, boolean isAtWar) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (unit.isCivilian() && !unit.isGreatPersonOfType("War")) {
            return 1;
        }
        if (unit.getBaseUnit().isAirUnit()) {
            return unit.canIntercept() ? 2 : (unit.isNuclearWeapon() ? 3 : (!MapUnit.hasUnique$default(unit, UniqueType.SelfDestructs, null, false, 6, null) ? 4 : 5));
        }
        int distance = !isAtWar ? 0 : ThreatManager.getDistanceToClosestEnemyUnit$default(unit.getCiv().getThreatManager(), unit.getTile(), 6, false, 4, null);
        return distance + unit.getHealth() / 10 + (unit.getBaseUnit().isRanged() ? 10 : (unit.getBaseUnit().isMelee() ? 30 : (unit.isGreatPersonOfType("War") ? 100 : 1)));
    }

    public final void automateCityBombardment(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        for (City city2 : civInfo.getCities()) {
            UnitAutomation.INSTANCE.tryBombardEnemy(city2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void automateCities(@NotNull Civilization civInfo) {
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        int ownMilitaryStrength = civInfo.getStatForRanking(RankingType.Force);
        Iterable iterable = civInfo.getGameInfo().getCivilizations();
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it, civInfo) && !it.isBarbarian() && civInfo.isAtWarWith(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        int n = 0;
        for (Object t : $this$filter$iv) {
            void it;
            Civilization $i$f$filterTo2 = (Civilization)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getStatForRanking(RankingType.Force);
            n = n2 + n3;
        }
        int sumOfEnemiesMilitaryStrength = n;
        boolean civHasSignificantlyWeakerMilitaryThanEnemies = (float)ownMilitaryStrength < (float)sumOfEnemiesMilitaryStrength * 0.66f;
        for (City city2 : civInfo.getCities()) {
            if (city2.isPuppet() && city2.getPopulation().getPopulation() > 9 && !city2.isInResistance() && !Civilization.hasUnique$default(civInfo, UniqueType.MayNotAnnexCities, null, 2, null)) {
                city2.annexCity();
            }
            city2.reassignAllPopulation();
            if (city2.getHealth() < city2.getMaxHealth$core() || civHasSignificantlyWeakerMilitaryThanEnemies) {
                Automation.INSTANCE.tryTrainMilitaryUnit(city2);
                if (!((Collection)city2.getCityConstructions().getConstructionQueue()).isEmpty()) continue;
            }
            city2.getCityConstructions().chooseNextConstruction();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void trainSettler(Civilization civInfo) {
        block43: {
            block41: {
                block40: {
                    personality = civInfo.getPersonality();
                    if (civInfo.isCityState()) {
                        return;
                    }
                    if (civInfo.isOneCityChallenger()) {
                        return;
                    }
                    if (civInfo.isAtWar()) {
                        return;
                    }
                    if (civInfo.wantsToFocusOn(Victory.Focus.Culture) && civInfo.getCities().size() > 3 && civInfo.getPersonality().isNeutralPersonality()) {
                        return;
                    }
                    if (CollectionsKt.none((Iterable)civInfo.getCities())) {
                        return;
                    }
                    if (civInfo.getHappiness() <= civInfo.getCities().size()) {
                        return;
                    }
                    $this$any$iv = civInfo.getUnits().getCivUnits();
                    $i$f$any = false;
                    var5_7 = $this$any$iv.iterator();
                    while (var5_7.hasNext()) {
                        element$iv = var5_7.next();
                        it = element$iv;
                        $i$a$-any-NextTurnAutomation$trainSettler$1 = false;
                        if (!MapUnit.hasUnique$default((MapUnit)it, UniqueType.FoundCity, null, false, 6, null)) continue;
                        v0 = true;
                        break block40;
                    }
                    v0 = false;
                }
                if (v0) {
                    return;
                }
                $this$any$iv = civInfo.getCities();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    var5_7 = $this$any$iv.iterator();
                    while (var5_7.hasNext()) {
                        element$iv = var5_7.next();
                        it = (City)element$iv;
                        $i$a$-any-NextTurnAutomation$trainSettler$2 = false;
                        currentConstruction = it.getCityConstructions().getCurrentConstruction();
                        if (!(currentConstruction instanceof BaseUnit != false && ((BaseUnit)currentConstruction).isCityFounder() != false)) continue;
                        v1 = true;
                        break block41;
                    }
                    v1 = false;
                }
            }
            if (v1) {
                return;
            }
            v2 = civInfo.getGameInfo().getRuleset().getUnits().values();
            Intrinsics.checkNotNullExpressionValue(v2, "civInfo.gameInfo.ruleset.units.values");
            $i$f$any = v2;
            $i$f$filter = false;
            element$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (E element$iv$iv : $this$filterTo$iv$iv) {
                block42: {
                    it = (BaseUnit)element$iv$iv;
                    $i$a$-filter-NextTurnAutomation$trainSettler$settlerUnits$1 = false;
                    if (!it.isCityFounder() || !it.isBuildable(civInfo)) ** GOTO lbl-1000
                    var13_37 = personality.getMatchingUniques(UniqueType.WillNotBuild, new StateForConditionals(civInfo, null, null, null, null, null, null, null, null, false, 1022, null));
                    $i$f$none = false;
                    for (T element$iv : $this$none$iv) {
                        unique = (Unique)element$iv;
                        $i$a$-none-NextTurnAutomation$trainSettler$settlerUnits$1$1 = false;
                        if (!it.matchesFilter(unique.getParams().get(0))) continue;
                        v3 = false;
                        break block42;
                    }
                    v3 = true;
                }
                if (v3) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            settlerUnits = (List)destination$iv$iv;
            if (settlerUnits.isEmpty()) {
                return;
            }
            $this$count$iv = civInfo.getUnits().getCivUnits();
            $i$f$count = false;
            count$iv = 0;
            destination$iv$iv = $this$count$iv.iterator();
            while (destination$iv$iv.hasNext()) {
                element$iv = destination$iv$iv.next();
                it = (MapUnit)element$iv;
                $i$a$-count-NextTurnAutomation$trainSettler$3 = false;
                if (!it.isMilitary() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            if (count$iv < civInfo.getCities().size()) {
                return;
            }
            v5 = civInfo.getGameInfo().getRuleset().getUnits().values();
            Intrinsics.checkNotNullExpressionValue(v5, "civInfo.gameInfo.ruleset.units.values");
            $this$any$iv = v5;
            $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                v6 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (BaseUnit)element$iv;
                    $i$a$-any-NextTurnAutomation$trainSettler$workersBuildableForThisCiv$1 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    v7 = IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.BuildImprovements, null, 2, null) && it.isBuildable(civInfo);
                    if (!v7) continue;
                    v6 = true;
                    break block43;
                }
                v6 = false;
            }
        }
        workersBuildableForThisCiv = v6;
        $this$filterNot$iv = civInfo.getCities();
        $i$f$filterNot = false;
        it = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (City)element$iv$iv;
            $i$a$-filterNot-NextTurnAutomation$trainSettler$bestCity$1 = false;
            if (it.isPuppet()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block44: {
                city = (City)element$iv$iv;
                $i$a$-filter-NextTurnAutomation$trainSettler$bestCity$2 = false;
                if (!workersBuildableForThisCiv) ** GOTO lbl-1000
                $this$count$iv = city.getCenterTile().getTilesInDistance(civInfo.getModConstants().getCityWorkRange() - 1);
                $i$f$count = false;
                count$iv = 0;
                var19_54 = $this$count$iv.iterator();
                while (var19_54.hasNext()) {
                    it = element$iv = var19_54.next();
                    $i$a$-count-NextTurnAutomation$trainSettler$bestCity$2$1 = false;
                    if (!(it.getImprovement() != null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                if (count$iv > true) ** GOTO lbl-1000
                $this$any$iv = city.getCenterTile().getTilesInDistance(civInfo.getModConstants().getCityWorkRange());
                $i$f$any = false;
                var18_53 = $this$any$iv.iterator();
                while (var18_53.hasNext()) {
                    it = element$iv = var18_53.next();
                    $i$a$-any-NextTurnAutomation$trainSettler$bestCity$2$2 = false;
                    v8 = it.getCivilianUnit();
                    v9 = v8 != null ? MapUnit.hasUnique$default(v8, UniqueType.BuildImprovements, null, false, 6, null) : false;
                    if (!v9) continue;
                    v10 = true;
                    break block44;
                }
                v10 = false;
            }
            if (v10) lbl-1000:
            // 3 sources

            {
                v11 = true;
            } else {
                v11 = false;
            }
            if (!v11) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$maxByOrNull = false;
        iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v12 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v12 = maxElem$iv;
            } else {
                it = (City)maxElem$iv;
                $i$a$-maxByOrNull-NextTurnAutomation$trainSettler$bestCity$3 = false;
                maxValue$iv = it.getCityStats().getCurrentCityStats().getProduction();
                do {
                    e$iv = iterator$iv.next();
                    it = (City)e$iv;
                    $i$a$-maxByOrNull-NextTurnAutomation$trainSettler$bestCity$3 = false;
                    v$iv = it.getCityStats().getCurrentCityStats().getProduction();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v12 = maxElem$iv;
            }
        }
        v13 = v12;
        if (v13 == null) {
            return;
        }
        bestCity = v13;
        if (SequencesKt.count(bestCity.getCityConstructions().getBuiltBuildings()) > 1) {
            $i$f$any = settlerUnits;
            var23_59 = bestCity.getCityConstructions();
            $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v14 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v14 = minElem$iv;
                } else {
                    it = (BaseUnit)minElem$iv;
                    $i$a$-minByOrNull-NextTurnAutomation$trainSettler$4 = false;
                    minValue$iv = it.getCost();
                    do {
                        e$iv = iterator$iv.next();
                        it = (BaseUnit)e$iv;
                        $i$a$-minByOrNull-NextTurnAutomation$trainSettler$4 = false;
                        v$iv = it.getCost();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v14 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v14);
            var23_59.setCurrentConstructionFromQueue(((BaseUnit)v14).getName());
        }
    }

    private final void tryVoteForDiplomaticVictory(Civilization civ) {
        Object object;
        if (!civ.mayVoteForDiplomaticVictory()) {
            return;
        }
        if (civ.isMajorCiv()) {
            Float highestOpinion;
            Float f;
            Sequence<Civilization> knownMajorCivs2 = SequencesKt.filter(civ.getKnownCivs(), tryVoteForDiplomaticVictory.chosenCiv.knownMajorCivs.1.INSTANCE);
            Iterator<Civilization> iterator2 = knownMajorCivs2.iterator();
            if (!iterator2.hasNext()) {
                f = null;
            } else {
                Civilization it = iterator2.next();
                boolean bl = false;
                DiplomacyManager diplomacyManager = civ.getDiplomacyManager(it);
                Intrinsics.checkNotNull(diplomacyManager);
                float f2 = diplomacyManager.opinionOfOtherCiv();
                while (iterator2.hasNext()) {
                    Civilization it2 = iterator2.next();
                    $i$a$-maxOfOrNull-NextTurnAutomation$tryVoteForDiplomaticVictory$chosenCiv$highestOpinion$1 = false;
                    DiplomacyManager diplomacyManager2 = civ.getDiplomacyManager(it2);
                    Intrinsics.checkNotNull(diplomacyManager2);
                    float f3 = diplomacyManager2.opinionOfOtherCiv();
                    f2 = Math.max(f2, f3);
                }
                f = highestOpinion = Float.valueOf(f2);
            }
            object = highestOpinion == null ? null : (highestOpinion.floatValue() < -80.0f || highestOpinion.floatValue() < -40.0f && highestOpinion.floatValue() + (float)Random.Default.nextInt(40) < -40.0f ? null : ((Civilization)CollectionsKt.random((Collection)SequencesKt.toList(SequencesKt.filter(knownMajorCivs2, (Function1)new Function1<Civilization, Boolean>(civ, highestOpinion){
                final /* synthetic */ Civilization $civ;
                final /* synthetic */ Float $highestOpinion;
                {
                    this.$civ = $civ;
                    this.$highestOpinion = $highestOpinion;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Civilization it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    DiplomacyManager diplomacyManager = this.$civ.getDiplomacyManager(it);
                    Intrinsics.checkNotNull(diplomacyManager);
                    return Intrinsics.areEqual(diplomacyManager.opinionOfOtherCiv(), this.$highestOpinion);
                }
            })), Random.Default)).getCivName());
        } else {
            object = civ.getAllyCiv();
        }
        String chosenCiv2 = object;
        civ.diplomaticVoteForCiv(chosenCiv2);
    }

    private final void issueRequests(Civilization civInfo) {
        Iterator<Civilization> iterator2 = SequencesKt.filter(civInfo.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(civInfo){
            final /* synthetic */ Civilization $civInfo;
            {
                this.$civInfo = $civInfo;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isMajorCiv() && !this.$civInfo.isAtWarWith(it);
            }
        }).iterator();
        while (iterator2.hasNext()) {
            DiplomacyManager diploManager;
            Civilization otherCiv = iterator2.next();
            Intrinsics.checkNotNull(civInfo.getDiplomacyManager(otherCiv));
            if (!diploManager.hasFlag(DiplomacyFlags.SettledCitiesNearUs)) continue;
            this.onCitySettledNearBorders(civInfo, otherCiv);
        }
    }

    private final void onCitySettledNearBorders(Civilization civInfo, Civilization otherCiv) {
        DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacyManager2 = diplomacyManager;
        if (!diplomacyManager2.hasFlag(DiplomacyFlags.IgnoreThemSettlingNearUs)) {
            if (diplomacyManager2.hasFlag(DiplomacyFlags.AgreedToNotSettleNearUs)) {
                otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.CitySettledNearOtherCivDespiteOurPromise, civInfo.getCivName()));
                diplomacyManager2.setFlag(DiplomacyFlags.IgnoreThemSettlingNearUs, 100);
                diplomacyManager2.setModifier(DiplomaticModifiers.BetrayedPromiseToNotSettleCitiesNearUs, -20.0f);
                diplomacyManager2.removeFlag(DiplomacyFlags.AgreedToNotSettleNearUs);
            } else {
                ThreatLevel threatLevel = Automation.INSTANCE.threatAssessment(civInfo, otherCiv);
                if (threatLevel.compareTo((Enum)ThreatLevel.High) < 0) {
                    otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.DemandToStopSettlingCitiesNear, civInfo.getCivName()));
                }
            }
        }
        diplomacyManager2.removeFlag(DiplomacyFlags.SettledCitiesNearUs);
    }

    public final int getMinDistanceBetweenCities(@NotNull Civilization civ1, @NotNull Civilization civ2) {
        Intrinsics.checkNotNullParameter(civ1, "civ1");
        Intrinsics.checkNotNullParameter(civ2, "civ2");
        CityDistance cityDistance = this.getClosestCities(civ1, civ2);
        return cityDistance != null ? cityDistance.getAerialDistance() : Integer.MAX_VALUE;
    }

    @Nullable
    public final CityDistance getClosestCities(@NotNull Civilization civ1, @NotNull Civilization civ2) {
        Object v0;
        Intrinsics.checkNotNullParameter(civ1, "civ1");
        Intrinsics.checkNotNullParameter(civ2, "civ2");
        if (civ1.getCities().isEmpty() || civ2.getCities().isEmpty()) {
            return null;
        }
        ArrayList cityDistances = new ArrayList();
        for (City civ1city : civ1.getCities()) {
            for (City civ2city : civ2.getCities()) {
                ((Collection)cityDistances).add(new CityDistance(civ1city, civ2city, civ1city.getCenterTile().aerialDistanceTo(civ2city.getCenterTile())));
            }
        }
        Iterable $this$minByOrNull$iv = cityDistances;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                CityDistance it = (CityDistance)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getAerialDistance();
                do {
                    Object e$iv = iterator$iv.next();
                    CityDistance it2 = (CityDistance)e$iv;
                    $i$a$-minByOrNull-NextTurnAutomation$getClosestCities$1 = false;
                    int v$iv = it2.getAerialDistance();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<List<Technology>> chooseTechToResearch$getGroupedResearchableTechs(Civilization $civInfo) {
        void $this$groupByTo$iv$iv;
        Collection<Technology> collection = $civInfo.getGameInfo().getRuleset().getTechnologies().values();
        Intrinsics.checkNotNullExpressionValue(collection, "civInfo.gameInfo.ruleset.technologies.values");
        Sequence $this$groupBy$iv = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), (Function1)new Function1<Technology, Boolean>($civInfo){
            final /* synthetic */ Civilization $civInfo;
            {
                this.$civInfo = $civInfo;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Technology it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$civInfo.getTech().canBeResearched(it.getName());
            }
        });
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Technology it = (Technology)element$iv$iv;
            boolean bl = false;
            Integer key$iv$iv = it.getCost();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map researchableTechs2 = destination$iv$iv;
        Collection collection2 = MapsKt.toSortedMap(researchableTechs2).values();
        Intrinsics.checkNotNullExpressionValue(collection2, "researchableTechs.toSortedMap().values");
        return CollectionsKt.toList(collection2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/unciv/logic/automation/civilization/NextTurnAutomation$CityDistance;", "", "city1", "Lcom/unciv/logic/city/City;", "city2", "aerialDistance", "", "(Lcom/unciv/logic/city/City;Lcom/unciv/logic/city/City;I)V", "getAerialDistance", "()I", "getCity1", "()Lcom/unciv/logic/city/City;", "getCity2", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    public static final class CityDistance {
        @NotNull
        private final City city1;
        @NotNull
        private final City city2;
        private final int aerialDistance;

        public CityDistance(@NotNull City city1, @NotNull City city2, int aerialDistance) {
            Intrinsics.checkNotNullParameter(city1, "city1");
            Intrinsics.checkNotNullParameter(city2, "city2");
            this.city1 = city1;
            this.city2 = city2;
            this.aerialDistance = aerialDistance;
        }

        @NotNull
        public final City getCity1() {
            return this.city1;
        }

        @NotNull
        public final City getCity2() {
            return this.city2;
        }

        public final int getAerialDistance() {
            return this.aerialDistance;
        }

        @NotNull
        public final City component1() {
            return this.city1;
        }

        @NotNull
        public final City component2() {
            return this.city2;
        }

        public final int component3() {
            return this.aerialDistance;
        }

        @NotNull
        public final CityDistance copy(@NotNull City city1, @NotNull City city2, int aerialDistance) {
            Intrinsics.checkNotNullParameter(city1, "city1");
            Intrinsics.checkNotNullParameter(city2, "city2");
            return new CityDistance(city1, city2, aerialDistance);
        }

        public static /* synthetic */ CityDistance copy$default(CityDistance cityDistance, City city2, City city3, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                city2 = cityDistance.city1;
            }
            if ((n2 & 2) != 0) {
                city3 = cityDistance.city2;
            }
            if ((n2 & 4) != 0) {
                n = cityDistance.aerialDistance;
            }
            return cityDistance.copy(city2, city3, n);
        }

        @NotNull
        public String toString() {
            return "CityDistance(city1=" + this.city1 + ", city2=" + this.city2 + ", aerialDistance=" + this.aerialDistance + ')';
        }

        public int hashCode() {
            int result2 = this.city1.hashCode();
            result2 = result2 * 31 + this.city2.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.aerialDistance);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CityDistance)) {
                return false;
            }
            CityDistance cityDistance = (CityDistance)other;
            if (!Intrinsics.areEqual(this.city1, cityDistance.city1)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.city2, cityDistance.city2)) {
                return false;
            }
            return this.aerialDistance == cityDistance.aerialDistance;
        }
    }
}

