/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.civilization;

import com.unciv.logic.automation.civilization.MotivationToAttackAutomation;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.automation.civilization.UseGoldAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.map.BFS;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tJ\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/unciv/logic/automation/civilization/UseGoldAutomation;", "", "()V", "getHighlyDesirableTilesToCityMap", "Ljava/util/SortedMap;", "Lcom/unciv/logic/map/tile/Tile;", "", "Lcom/unciv/logic/city/City;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "isHighlyDesirableTile", "", "it", "city", "maybeBuyCityTiles", "", "tryGainInfluence", "cityState", "useGold", "civ", "useGoldForCityStates", "core"})
@SourceDebugExtension(value={"SMAP\nUseGoldAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseGoldAutomation.kt\ncom/unciv/logic/automation/civilization/UseGoldAutomation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,180:1\n1054#2:181\n766#2:182\n857#2,2:183\n766#2:185\n857#2,2:186\n1271#2,2:188\n1285#2,4:190\n2310#2,14:195\n766#2:209\n857#2,2:210\n766#2:212\n857#2,2:213\n1#3:194\n361#4,7:215\n2141#5,2:222\n*S KotlinDebug\n*F\n+ 1 UseGoldAutomation.kt\ncom/unciv/logic/automation/civilization/UseGoldAutomation\n*L\n24#1:181\n53#1:182\n53#1:183,2\n63#1:185\n63#1:186,2\n64#1:188,2\n64#1:190,4\n85#1:195,14\n134#1:209\n134#1:210,2\n135#1:212\n135#1:213,2\n139#1:215,7\n149#1:222,2\n*E\n"})
public final class UseGoldAutomation {
    @NotNull
    public static final UseGoldAutomation INSTANCE = new UseGoldAutomation();

    private UseGoldAutomation() {
    }

    public final void useGold(@NotNull Civilization civ) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        if (civ.isMajorCiv()) {
            this.useGoldForCityStates(civ);
        }
        Iterable $this$sortedByDescending$iv = civ.getCities();
        boolean $i$f$sortedByDescending = false;
        for (City city2 : CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                City it = (City)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPopulation().getPopulation());
                it = (City)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getPopulation().getPopulation());
            }
        })) {
            IConstruction construction2 = city2.getCityConstructions().getCurrentConstruction();
            if (construction2 instanceof PerpetualConstruction) continue;
            Intrinsics.checkNotNull(construction2, "null cannot be cast to non-null type com.unciv.models.ruleset.INonPerpetualConstruction");
            if (!((INonPerpetualConstruction)construction2).canBePurchasedWithStat(city2, Stat.Gold)) continue;
            int n = city2.getCiv().getGold() / 3;
            Integer n2 = ((INonPerpetualConstruction)construction2).getStatBuyCost(city2, Stat.Gold);
            Intrinsics.checkNotNull(n2);
            if (n < n2) continue;
            CityConstructions.purchaseConstruction$default(city2.getCityConstructions(), (INonPerpetualConstruction)construction2, 0, true, null, null, 24, null);
        }
        this.maybeBuyCityTiles(civ);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void useGoldForCityStates(Civilization civ) {
        Object v0;
        void $this$associateWith$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection destination$iv$iv;
        List<Civilization> knownCityStates2 = SequencesKt.toList(SequencesKt.filter(civ.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(civ){
            final /* synthetic */ Civilization $civ;
            {
                this.$civ = $civ;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isCityState() && MotivationToAttackAutomation.INSTANCE.hasAtLeastMotivationToAttack(this.$civ, it, 0.0f) <= 0.0f;
            }
        }));
        if (civ.getGold() >= 330 && civ.getHappiness() > 0 && Civilization.hasUnique$default(civ, UniqueType.CityStateCanBeBoughtForGold, null, 2, null)) {
            for (Civilization cityState : CollectionsKt.toList((Iterable)knownCityStates2)) {
                if (cityState.getCityStateFunctions().canBeMarriedBy(civ)) {
                    cityState.getCityStateFunctions().diplomaticMarriage(civ);
                }
                if (civ.getHappiness() > 0) continue;
            }
        }
        if (civ.getGold() < 250) {
            return;
        }
        if (civ.wantsToFocusOn(Victory.Focus.Culture)) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = knownCityStates2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv2;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Civilization it = (Civilization)element$iv$iv;
                boolean bl = false;
                if (!it.getCityStateFunctions().canProvideStat(Stat.Culture)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Civilization cityState : (List)destination$iv$iv) {
                DiplomacyManager diploManager;
                Intrinsics.checkNotNull(cityState.getDiplomacyManager(civ));
                if (!(diploManager.getInfluence() < 40.0f)) continue;
                this.tryGainInfluence(civ, cityState);
            }
        }
        if (civ.getGold() < 250) return;
        if (CollectionsKt.none((Iterable)knownCityStates2)) {
            return;
        }
        Iterable diploManager = knownCityStates2;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getAllyCiv(), civ.getCivName()))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$associateWith = false;
        Object result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Object $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            Object e = element$iv$iv;
            Map map2 = (Map)result$iv;
            boolean bl = false;
            Integer n = NextTurnAutomation.INSTANCE.valueCityStateAlliance$core(civ, it, true);
            map2.put(e, n);
        }
        Object object = ((Map)result$iv).entrySet();
        if (!(result$iv = object.iterator()).hasNext()) {
            v0 = null;
        } else {
            $this$associateWithTo$iv$iv = result$iv.next();
            if (!result$iv.hasNext()) {
                v0 = $this$associateWithTo$iv$iv;
            } else {
                Map.Entry it = (Map.Entry)$this$associateWithTo$iv$iv;
                boolean bl = false;
                int n = ((Number)it.getValue()).intValue();
                do {
                    Object e = result$iv.next();
                    Map.Entry it2 = (Map.Entry)e;
                    $i$a$-maxByOrNull-UseGoldAutomation$useGoldForCityStates$cityState$3 = false;
                    int n2 = ((Number)it2.getValue()).intValue();
                    if (n >= n2) continue;
                    $this$associateWithTo$iv$iv = e;
                    n = n2;
                } while (result$iv.hasNext());
                v0 = $this$associateWithTo$iv$iv;
            }
        }
        Map.Entry entry = v0;
        Object object2 = entry;
        if (entry == null) return;
        Object it = object = object2;
        boolean bl = false;
        if (((Number)it.getValue()).intValue() <= 0) return;
        boolean bl2 = true;
        if (!bl2) return;
        Object object3 = object;
        object2 = object3;
        if (object3 == null) return;
        Civilization civilization = (Civilization)object2.getKey();
        Civilization cityState = civilization;
        if (cityState == null) return;
        this.tryGainInfluence(civ, cityState);
    }

    private final void maybeBuyCityTiles(Civilization civInfo) {
        if (civInfo.getGold() <= 0) {
            return;
        }
        if (civInfo.getGameInfo().getTurns() < (int)(civInfo.getGameInfo().getSpeed().getScienceCostModifier() * (float)20)) {
            return;
        }
        SortedMap<Tile, Set<City>> highlyDesirableTiles = this.getHighlyDesirableTilesToCityMap(civInfo);
        for (Map.Entry highlyDesirableTile : ((Map)highlyDesirableTiles).entrySet()) {
            Object t;
            Object v = highlyDesirableTile.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "highlyDesirableTile.value");
            Iterable $this$minBy$iv = (Iterable)v;
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = minElem$iv;
            } else {
                City it = (City)minElem$iv;
                boolean bl = false;
                Tile tile = it.getCenterTile();
                Object k = highlyDesirableTile.getKey();
                Intrinsics.checkNotNullExpressionValue(k, "highlyDesirableTile.key");
                int minValue$iv = tile.aerialDistanceTo((Tile)k);
                do {
                    Object e$iv = iterator$iv.next();
                    City it2 = (City)e$iv;
                    boolean bl2 = false;
                    Tile tile2 = it2.getCenterTile();
                    Object k2 = highlyDesirableTile.getKey();
                    Intrinsics.checkNotNullExpressionValue(k2, "highlyDesirableTile.key");
                    int v$iv = tile2.aerialDistanceTo((Tile)k2);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = minElem$iv;
            }
            City cityWithLeastCostToBuy = (City)t;
            BFS bfs2 = new BFS(cityWithLeastCostToBuy.getCenterTile(), (Function1<? super Tile, Boolean>)new Function1<Tile, Boolean>(cityWithLeastCostToBuy){
                final /* synthetic */ City $cityWithLeastCostToBuy;
                {
                    this.$cityWithLeastCostToBuy = $cityWithLeastCostToBuy;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Tile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.getOwner() == null || Intrinsics.areEqual(it.getOwningCity(), this.$cityWithLeastCostToBuy);
                }
            });
            Object k = highlyDesirableTile.getKey();
            Intrinsics.checkNotNullExpressionValue(k, "highlyDesirableTile.key");
            bfs2.stepUntilDestination((Tile)k);
            Object k3 = highlyDesirableTile.getKey();
            Intrinsics.checkNotNullExpressionValue(k3, "highlyDesirableTile.key");
            List<Tile> tilesThatNeedBuying2 = CollectionsKt.reversed((Iterable)SequencesKt.toList(SequencesKt.filter(bfs2.getPathTo((Tile)k3), maybeBuyCityTiles.tilesThatNeedBuying.1.INSTANCE)));
            boolean ranOutOfMoney = false;
            int goldSpent = 0;
            for (Tile tileThatNeedsBuying : tilesThatNeedBuying2) {
                int goldCostOfTile = cityWithLeastCostToBuy.getExpansion().getGoldCostOfTile(tileThatNeedsBuying);
                if (civInfo.getGold() >= goldCostOfTile) {
                    cityWithLeastCostToBuy.getExpansion().buyTile(tileThatNeedsBuying);
                    goldSpent += goldCostOfTile;
                    continue;
                }
                ranOutOfMoney = true;
                break;
            }
            if (!ranOutOfMoney) continue;
            for (Tile tileThatNeedsBuying : tilesThatNeedBuying2) {
                cityWithLeastCostToBuy.getExpansion().relinquishOwnership(tileThatNeedsBuying);
            }
            civInfo.addGold(goldSpent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SortedMap<Tile, Set<City>> getHighlyDesirableTilesToCityMap(Civilization civInfo) {
        void $this$filterTo$iv$iv;
        Object object = new Comparator(){

            public final int compare(T a, T b) {
                Tile it = (Tile)b;
                boolean bl = false;
                Tile tile = it;
                it = (Tile)a;
                Comparable comparable = Boolean.valueOf((tile != null ? tile.getNaturalWonder() : null) != null);
                bl = false;
                Tile tile2 = it;
                return ComparisonsKt.compareValues(comparable, (tile2 != null ? tile2.getNaturalWonder() : null) != null);
            }
        };
        object = new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Tile it = (Tile)b;
                    boolean bl = false;
                    Tile tile = it;
                    boolean bl2 = (tile != null ? tile.getResource() : null) != null && it.getTileResource().getResourceType() == ResourceType.Luxury;
                    it = (Tile)a;
                    Comparable comparable = Boolean.valueOf(bl2);
                    bl = false;
                    Tile tile2 = it;
                    n = ComparisonsKt.compareValues(comparable, (tile2 != null ? tile2.getResource() : null) != null && it.getTileResource().getResourceType() == ResourceType.Luxury);
                }
                return n;
            }
        };
        object = new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Tile it = (Tile)b;
                    boolean bl = false;
                    Tile tile = it;
                    boolean bl2 = (tile != null ? tile.getResource() : null) != null && it.getTileResource().getResourceType() == ResourceType.Strategic;
                    it = (Tile)a;
                    Comparable comparable = Boolean.valueOf(bl2);
                    bl = false;
                    Tile tile2 = it;
                    n = ComparisonsKt.compareValues(comparable, (tile2 != null ? tile2.getResource() : null) != null && it.getTileResource().getResourceType() == ResourceType.Strategic);
                }
                return n;
            }
        };
        SortedMap highlyDesirableTiles = new TreeMap(new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Tile tile = it;
                    it = (Tile)b;
                    Comparable comparable = Integer.valueOf(tile != null ? tile.hashCode() : 0);
                    bl = false;
                    Tile tile2 = it;
                    n = ComparisonsKt.compareValues(comparable, tile2 != null ? tile2.hashCode() : 0);
                }
                return n;
            }
        });
        Iterable $this$filter$iv = civInfo.getCities();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            City it = (City)element$iv$iv;
            boolean bl = false;
            if (!(!it.isPuppet() && !it.isBeingRazed())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (City city2 : (List)destination$iv$iv) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = city2.getTilesInRange();
            boolean $i$f$filter2 = false;
            Iterable $i$f$filterTo2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Tile it = (Tile)element$iv$iv;
                boolean bl = false;
                if (!INSTANCE.isHighlyDesirableTile(it, civInfo, city2)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List highlyDesirableTilesInCity = (List)destination$iv$iv2;
            for (Tile highlyDesirableTileInCity : highlyDesirableTilesInCity) {
                Object object2;
                Map $this$getOrPut$iv = highlyDesirableTiles;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(highlyDesirableTileInCity);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(highlyDesirableTileInCity, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((Set)object2).add(city2);
            }
        }
        return highlyDesirableTiles;
    }

    private final boolean isHighlyDesirableTile(Tile it, Civilization civInfo, City city2) {
        boolean bl;
        block4: {
            if (!it.isVisible(civInfo)) {
                return false;
            }
            if (it.getOwner() != null) {
                return false;
            }
            Sequence<Tile> $this$none$iv = it.getNeighbors();
            boolean $i$f$none = false;
            Iterator<Tile> iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                Tile element$iv;
                Tile neighbor = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(neighbor.getCity(), city2)) continue;
                bl = false;
                break block4;
            }
            bl = true;
        }
        if (bl) {
            return false;
        }
        return UseGoldAutomation.isHighlyDesirableTile$hasNaturalWonder(it) || UseGoldAutomation.isHighlyDesirableTile$hasLuxuryCivDoesntOwn(it, civInfo) || UseGoldAutomation.isHighlyDesirableTile$hasResourceCivHasNoneOrLittle(it, civInfo);
    }

    private final void tryGainInfluence(Civilization civInfo, Civilization cityState) {
        if (civInfo.getGold() < 250) {
            return;
        }
        DiplomacyManager diplomacyManager = cityState.getDiplomacyManager(civInfo);
        Intrinsics.checkNotNull(diplomacyManager);
        if (diplomacyManager.getInfluence() >= 20.0f && civInfo.getGold() < 500) {
            cityState.getCityStateFunctions().receiveGoldGift(civInfo, 250);
            return;
        }
        if (civInfo.getGold() < 500) {
            return;
        }
        cityState.getCityStateFunctions().receiveGoldGift(civInfo, 500);
    }

    private static final boolean isHighlyDesirableTile$hasNaturalWonder(Tile $it) {
        return $it.getNaturalWonder() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isHighlyDesirableTile$hasLuxuryCivDoesntOwn(Tile $it, Civilization $civInfo) {
        if (!$it.hasViewableResource($civInfo)) return false;
        if ($it.getTileResource().getResourceType() != ResourceType.Luxury) return false;
        String string = $it.getResource();
        Intrinsics.checkNotNull(string);
        if ($civInfo.hasResource(string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isHighlyDesirableTile$hasResourceCivHasNoneOrLittle(Tile $it, Civilization $civInfo) {
        if (!$it.hasViewableResource($civInfo)) return false;
        if ($it.getTileResource().getResourceType() != ResourceType.Strategic) return false;
        String string = $it.getResource();
        Intrinsics.checkNotNull(string);
        if ($civInfo.getResourceAmount(string) > 3) return false;
        return true;
    }
}

