/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.UncivGame;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.automation.unit.RoadBetweenCitiesAutomation;
import com.unciv.logic.automation.unit.RoadToAutomation;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.automation.unit.WorkerAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileStatFunctions;
import com.unciv.logic.map.tile.TileStatFunctionsKt;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stats;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActions;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsFromUniques;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\u0018\u0000 =2\u00020\u0001:\u0002=>B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ0\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u00180\"j\b\u0012\u0004\u0012\u00020\u0018`#2\b\b\u0002\u0010$\u001a\u00020%J\"\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0002J\u0016\u0010)\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u001cJ\u0018\u0010+\u001a\u00020,2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u001cH\u0002J&\u0010-\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00180/2\u0006\u0010$\u001a\u00020%H\u0002J\u0016\u00100\u001a\u00020,2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eJ \u00101\u001a\u00020,2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0002J \u00102\u001a\u00020,2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0002J(\u00103\u001a\u00020,2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00104\u001a\u0002052\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u00106\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u0018H\u0002J\u000e\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020'J\u000e\u00107\u001a\u00020\u001c2\u0006\u00104\u001a\u000205J$\u00109\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00182\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020'0;H\u0002J \u0010<\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/unciv/logic/automation/unit/WorkerAutomation;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "cachedForTurn", "", "cloningSource", "(Lcom/unciv/logic/civilization/Civilization;ILcom/unciv/logic/automation/unit/WorkerAutomation;)V", "getCachedForTurn", "()I", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "roadBetweenCitiesAutomation", "Lcom/unciv/logic/automation/unit/RoadBetweenCitiesAutomation;", "getRoadBetweenCitiesAutomation", "()Lcom/unciv/logic/automation/unit/RoadBetweenCitiesAutomation;", "roadToAutomation", "Lcom/unciv/logic/automation/unit/RoadToAutomation;", "getRoadToAutomation", "()Lcom/unciv/logic/automation/unit/RoadToAutomation;", "ruleSet", "Lcom/unciv/models/ruleset/Ruleset;", "tileRankings", "Ljava/util/HashMap;", "Lcom/unciv/logic/map/tile/Tile;", "Lcom/unciv/logic/automation/unit/WorkerAutomation$TileImprovementRank;", "Lkotlin/collections/HashMap;", "automateWorkBoats", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "automateWorkerAction", "", "dangerousTiles", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "chooseImprovement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "tile", "evaluateFortPlacement", "isCitadel", "evaluateFortSurroundings", "", "findTileToWork", "tilesToAvoid", "", "getBasePriority", "getFullPriority", "getImprovementPriority", "getImprovementRanking", "improvementName", "", "isAcceptableTileForFort", "isImprovementProbablyAFort", "improvement", "isResourceImprovementAllowedOnFeature", "potentialTileImprovements", "", "tileHasWorkToDo", "Companion", "TileImprovementRank", "core"})
@SourceDebugExtension(value={"SMAP\nWorkerAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerAutomation.kt\ncom/unciv/logic/automation/unit/WorkerAutomation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,632:1\n1250#2,2:633\n1229#2,2:635\n1252#2:637\n614#2:638\n179#2,2:639\n970#2:641\n999#2,3:642\n1002#2,3:652\n614#2:655\n1229#2,2:657\n1415#2,14:666\n1229#2,2:697\n1206#2,2:707\n603#2:764\n179#2,2:765\n361#3,7:645\n515#3:659\n500#3,6:660\n1045#4:656\n766#4:680\n857#4,2:681\n1963#4,14:683\n288#4,2:699\n1747#4,2:701\n1747#4,3:703\n1749#4:706\n766#4:709\n857#4,2:710\n1855#4:712\n1549#4:713\n1620#4,3:714\n1856#4:717\n2333#4,14:718\n2333#4,14:732\n1549#4:746\n1620#4,3:747\n2310#4,14:750\n*S KotlinDebug\n*F\n+ 1 WorkerAutomation.kt\ncom/unciv/logic/automation/unit/WorkerAutomation\n*L\n143#1:633,2\n144#1:635,2\n143#1:637\n150#1:638\n151#1:639,2\n192#1:641\n192#1:642,3\n192#1:652,3\n193#1:655\n233#1:657,2\n330#1:666,14\n394#1:697,2\n489#1:707,2\n593#1:764\n594#1:765,2\n192#1:645,7\n320#1:659\n320#1:660,6\n200#1:656\n349#1:680\n349#1:681,2\n350#1:683,14\n403#1:699,2\n453#1:701,2\n456#1:703,3\n453#1:706\n534#1:709\n534#1:710,2\n541#1:712\n541#1:713\n541#1:714,3\n541#1:717\n544#1:718,14\n547#1:732,14\n550#1:746\n550#1:747,3\n550#1:750,14\n*E\n"})
public final class WorkerAutomation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Civilization civInfo;
    private final int cachedForTurn;
    @NotNull
    private final RoadToAutomation roadToAutomation;
    @NotNull
    private final RoadBetweenCitiesAutomation roadBetweenCitiesAutomation;
    @NotNull
    private final Ruleset ruleSet;
    @NotNull
    private final HashMap<Tile, TileImprovementRank> tileRankings;

    public WorkerAutomation(@NotNull Civilization civInfo, int cachedForTurn, @Nullable WorkerAutomation cloningSource) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
        this.cachedForTurn = cachedForTurn;
        this.roadToAutomation = new RoadToAutomation(this.civInfo);
        WorkerAutomation workerAutomation = cloningSource;
        this.roadBetweenCitiesAutomation = new RoadBetweenCitiesAutomation(this.civInfo, this.cachedForTurn, workerAutomation != null ? workerAutomation.roadBetweenCitiesAutomation : null);
        this.ruleSet = this.civInfo.getGameInfo().getRuleset();
        this.tileRankings = new HashMap();
    }

    public /* synthetic */ WorkerAutomation(Civilization civilization, int n, WorkerAutomation workerAutomation, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            workerAutomation = null;
        }
        this(civilization, n, workerAutomation);
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    public final int getCachedForTurn() {
        return this.cachedForTurn;
    }

    @NotNull
    public final RoadToAutomation getRoadToAutomation() {
        return this.roadToAutomation;
    }

    @NotNull
    public final RoadBetweenCitiesAutomation getRoadBetweenCitiesAutomation() {
        return this.roadBetweenCitiesAutomation;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public final void automateWorkerAction(@NotNull MapUnit unit, @NotNull HashSet<Tile> dangerousTiles, @NotNull LocalUniqueCache localUniqueCache) {
        block26: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Intrinsics.checkNotNullParameter(dangerousTiles, "dangerousTiles");
            Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
            currentTile = unit.getTile();
            citiesToConnect = this.roadBetweenCitiesAutomation.getNearbyCitiesToConnect$core(unit);
            if (!dangerousTiles.contains(currentTile) && this.getFullPriority(unit.getTile(), unit, localUniqueCache) >= 10.0f && currentTile.getImprovementInProgress() != null) {
                return;
            }
            tileToWork = this.findTileToWork(unit, (Set<Tile>)dangerousTiles, localUniqueCache);
            if (!Intrinsics.areEqual(tileToWork, currentTile)) {
                var7_7 = new Object[]{unit.toString(), tileToWork};
                LogKt.debug("WorkerAutomation: %s -> head towards %s", var7_7);
                if (unit.getMovement().canReachInCurrentTurn(tileToWork) && UnitMovement.canMoveTo$default(unit.getMovement(), tileToWork, false, true, false, 10, null) && !UnitMovement.canMoveTo$default(unit.getMovement(), tileToWork, false, false, false, 10, null) && unit.getMovement().canUnitSwapTo(tileToWork)) {
                    unit.getMovement().swapMoveToTile(tileToWork);
                }
                if (!Intrinsics.areEqual(reachedTile = unit.getMovement().headTowards(tileToWork), currentTile)) {
                    unit.doAction();
                }
                if (Intrinsics.areEqual(reachedTile, tileToWork) && Intrinsics.areEqual(reachedTile.getImprovementInProgress(), "Fort") && this.evaluateFortSurroundings(currentTile, false) <= 0.0f) {
                    LogKt.debug("Replacing fort in progress with new improvement", new Object[0]);
                    reachedTile.stopWorkingOnImprovement();
                }
                if (unit.getCurrentMovement() > 0.0f && Intrinsics.areEqual(reachedTile, tileToWork)) {
                    if (reachedTile.isPillaged()) {
                        LogKt.debug("WorkerAutomation: " + unit + " -> repairs " + reachedTile, new Object[0]);
                        v0 = UnitActionsFromUniques.INSTANCE.getRepairAction(unit);
                        if (v0 != null && (v0 = v0.getAction()) != null) {
                            v0.invoke();
                        }
                        return;
                    }
                    if (reachedTile.getImprovementInProgress() == null && reachedTile.isLand() && this.tileHasWorkToDo(reachedTile, unit, localUniqueCache)) {
                        LogKt.debug("WorkerAutomation: " + unit + " -> start improving " + reachedTile, new Object[0]);
                        v1 = this.tileRankings.get(reachedTile);
                        Intrinsics.checkNotNull(v1);
                        v2 = v1.getBestImprovement();
                        Intrinsics.checkNotNull(v2);
                        reachedTile.startWorkingOnImprovement(v2, this.civInfo, unit);
                        return;
                    }
                }
                return;
            }
            if (currentTile.getImprovementInProgress() != null) {
                return;
            }
            if (this.tileHasWorkToDo(currentTile, unit, localUniqueCache)) {
                v3 = this.tileRankings.get(currentTile);
                Intrinsics.checkNotNull(v3);
                tileRankings = v3;
                v4 = tileRankings.getRepairImprovment();
                Intrinsics.checkNotNull(v4);
                if (v4.booleanValue()) {
                    LogKt.debug("WorkerAutomation: " + unit + " -> repairs " + currentTile, new Object[0]);
                    v5 = UnitActionsFromUniques.INSTANCE.getRepairAction(unit);
                    if (v5 != null && (v5 = v5.getAction()) != null) {
                        v5.invoke();
                    }
                    return;
                }
                if (tileRankings.getBestImprovement() != null) {
                    LogKt.debug("WorkerAutomation: " + unit + "} -> start improving " + currentTile, new Object[0]);
                    v6 = tileRankings.getBestImprovement();
                    Intrinsics.checkNotNull(v6);
                    currentTile.startWorkingOnImprovement(v6, this.civInfo, unit);
                    return;
                }
                throw new IllegalStateException("We didn't find anything to improve on this tile even though there was supposed to be something to improve!");
            }
            if (unit.getCache().getHasUniqueToCreateWaterImprovements() && this.automateWorkBoats(unit)) {
                return;
            }
            citiesToNumberOfUnimprovedTiles = new HashMap<String, Integer>();
            for (Object city : unit.getCiv().getCities()) {
                var10_12 = citiesToNumberOfUnimprovedTiles;
                var11_14 = city.getId();
                var12_15 = city.getTiles();
                $i$f$count = false;
                count$iv = 0;
                var15_19 = $this$count$iv.iterator();
                while (var15_19.hasNext()) {
                    block25: {
                        element$iv = var15_19.next();
                        tile = (Tile)element$iv;
                        $i$a$-count-WorkerAutomation$automateWorkerAction$1 = false;
                        if (!tile.isLand()) ** GOTO lbl-1000
                        $this$any$iv = tile.getUnits();
                        $i$f$any = false;
                        var21_25 = $this$any$iv.iterator();
                        while (var21_25.hasNext()) {
                            unit = element$iv = var21_25.next();
                            $i$a$-any-WorkerAutomation$automateWorkerAction$1$1 = false;
                            if (!unit.getCache().getHasUniqueToBuildImprovements()) continue;
                            v7 = true;
                            break block25;
                        }
                        v7 = false;
                    }
                    if (v7 && (tile.isPillaged() || this.tileHasWorkToDo(tile, unit, localUniqueCache))) {
                        v8 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v8 = false;
                    }
                    if (!v8 || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                $this$count$iv = count$iv;
                var10_12.put(var11_14, $this$count$iv);
            }
            city = SequencesKt.filter(CollectionsKt.asSequence((Iterable)unit.getCiv().getCities()), (Function1)new Function1<City, Boolean>(citiesToNumberOfUnimprovedTiles){
                final /* synthetic */ HashMap<String, Integer> $citiesToNumberOfUnimprovedTiles;
                {
                    this.$citiesToNumberOfUnimprovedTiles = $citiesToNumberOfUnimprovedTiles;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull City it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    Integer n = this.$citiesToNumberOfUnimprovedTiles.get(it.getId());
                    Intrinsics.checkNotNull(n);
                    return ((Number)n).intValue() > 0;
                }
            });
            $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(currentTile){
                final /* synthetic */ Tile $currentTile$inlined;
                {
                    this.$currentTile$inlined = tile;
                }

                public final int compare(T a, T b) {
                    City it = (City)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getCenterTile().aerialDistanceTo(this.$currentTile$inlined));
                    it = (City)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getCenterTile().aerialDistanceTo(this.$currentTile$inlined));
                }
            });
            $i$f$firstOrNull = false;
            for (E element$iv : $this$firstOrNull$iv) {
                it = (City)element$iv;
                $i$a$-firstOrNull-WorkerAutomation$automateWorkerAction$closestUndevelopedCity$3 = false;
                if (!unit.getMovement().canReach(it.getCenterTile())) continue;
                v9 = element$iv;
                break block26;
            }
            v9 = null;
        }
        closestUndevelopedCity = v9;
        if (closestUndevelopedCity != null && !Intrinsics.areEqual(closestUndevelopedCity, currentTile.getOwningCity())) {
            $this$firstOrNull$iv = new Object[]{unit, closestUndevelopedCity.getName()};
            LogKt.debug("WorkerAutomation: %s -> head towards undeveloped city %s", $this$firstOrNull$iv);
            reachedTile = unit.getMovement().headTowards(closestUndevelopedCity.getCenterTile());
            if (!Intrinsics.areEqual(reachedTile, currentTile)) {
                unit.doAction();
            }
            return;
        }
        if (this.civInfo.getStats().getStatsForNextTurn().getGold() > 10.0f && this.roadBetweenCitiesAutomation.tryConnectingCities$core(unit, citiesToConnect)) {
            return;
        }
        var9_11 = new Object[]{unit.toString()};
        LogKt.debug("WorkerAutomation: %s -> nothing to do", var9_11);
        var9_11 = new String[]{unit.getName(), "OtherIcons/Sleep"};
        unit.getCiv().addNotification(unit.shortDisplayName() + " has no work to do.", currentTile.getPosition(), Notification.NotificationCategory.Units, (String[])var9_11);
        if (unit.getCiv().isCityState()) {
            UnitAutomation.INSTANCE.wander(unit, true, (Set<Tile>)dangerousTiles);
        }
    }

    public static /* synthetic */ void automateWorkerAction$default(WorkerAutomation workerAutomation, MapUnit mapUnit, HashSet hashSet, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 4) != 0) {
            localUniqueCache = new LocalUniqueCache(false, 1, null);
        }
        workerAutomation.automateWorkerAction(mapUnit, hashSet, localUniqueCache);
    }

    /*
     * WARNING - void declaration
     */
    private final Tile findTileToWork(MapUnit unit, Set<Tile> tilesToAvoid, LocalUniqueCache localUniqueCache) {
        void $this$groupByTo$iv$iv;
        Sequence<Tile> workableTilesCenterFirst2;
        Tile currentTile = unit.getTile();
        if (!tilesToAvoid.contains(currentTile) && this.getBasePriority(currentTile, unit) >= 5.0f && (this.tileHasWorkToDo(currentTile, unit, localUniqueCache) || currentTile.isPillaged() || currentTile.hasFalloutEquivalent())) {
            return currentTile;
        }
        Sequence<Tile> $this$groupBy$iv = workableTilesCenterFirst2 = SequencesKt.filter(currentTile.getTilesInDistance(4), (Function1)new Function1<Tile, Boolean>(tilesToAvoid, currentTile, unit, this){
            final /* synthetic */ Set<Tile> $tilesToAvoid;
            final /* synthetic */ Tile $currentTile;
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ WorkerAutomation this$0;
            {
                this.$tilesToAvoid = $tilesToAvoid;
                this.$currentTile = $currentTile;
                this.$unit = $unit;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                boolean bl;
                block4: {
                    block5: {
                        block6: {
                            Intrinsics.checkNotNullParameter(it, "it");
                            if (this.$tilesToAvoid.contains(it)) break block4;
                            if (Intrinsics.areEqual(it, this.$currentTile)) break block5;
                            if (!this.$unit.isCivilian()) break block6;
                            if (it.getCivilianUnit() == null) break block5;
                            MapUnit mapUnit = it.getCivilianUnit();
                            Intrinsics.checkNotNull(mapUnit);
                            if (!mapUnit.getCache().getHasUniqueToBuildImprovements()) break block5;
                        }
                        if (!this.$unit.isMilitary()) break block4;
                        if (it.getMilitaryUnit() == null) break block5;
                        MapUnit mapUnit = it.getMilitaryUnit();
                        Intrinsics.checkNotNull(mapUnit);
                        if (mapUnit.getCache().getHasUniqueToBuildImprovements()) break block4;
                    }
                    if ((it.getOwningCity() == null || Intrinsics.areEqual(it.getOwner(), this.this$0.getCivInfo())) && !it.isCityCenter() && this.this$0.getBasePriority(it, this.$unit) > 1.0f) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        });
        boolean $i$f$groupBy = false;
        Sequence<Tile> sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Tile it = (Tile)element$iv$iv;
            boolean bl = false;
            Float key$iv$iv = Float.valueOf(this.getBasePriority(it, unit));
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Sequence $this$sortedByDescending$iv = MapsKt.asSequence(destination$iv$iv);
        boolean $i$f$sortedByDescending = false;
        Sequence workableTilesPrioritized = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Float)it.getKey();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)it.getKey()));
            }
        });
        Iterator iterator2 = workableTilesPrioritized.iterator();
        while (iterator2.hasNext()) {
            Map.Entry tilePriorityGroup = iterator2.next();
            Tile bestTile = null;
            Iterable $this$sortedBy$iv = (Iterable)tilePriorityGroup.getValue();
            boolean $i$f$sortedBy = false;
            for (Tile tileInGroup : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(this.$unit$inlined.getTile().aerialDistanceTo(it));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, this.$unit$inlined.getTile().aerialDistanceTo(it));
                }
            })) {
                if (!this.tileHasWorkToDo(tileInGroup, unit, localUniqueCache)) continue;
                if (Intrinsics.areEqual(unit.getTile(), tileInGroup)) {
                    return unit.getTile();
                }
                if (!unit.getMovement().canReach(tileInGroup) || bestTile != null && !(this.getFullPriority(tileInGroup, unit, localUniqueCache) > this.getFullPriority(bestTile, unit, localUniqueCache))) continue;
                bestTile = tileInGroup;
            }
            if (bestTile == null) continue;
            return bestTile;
        }
        return currentTile;
    }

    public final float getBasePriority(@NotNull Tile tile, @NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(unit, "unit");
        float unitSpecificPriority = (float)2 - RangesKt.coerceIn((float)tile.aerialDistanceTo(unit.getTile()) / 2.0f, 0.0f, 2.0f);
        if (this.tileRankings.containsKey(tile)) {
            TileImprovementRank tileImprovementRank = this.tileRankings.get(tile);
            Intrinsics.checkNotNull(tileImprovementRank);
            return tileImprovementRank.getTilePriority() + unitSpecificPriority;
        }
        float priority = 0.0f;
        if (Intrinsics.areEqual(tile.getOwner(), this.civInfo)) {
            priority += Automation.INSTANCE.rankStatsValue(TileStatFunctionsKt.toStats(TileStatFunctions.getTerrainStatsBreakdown$default(tile.getStats(), null, 1, null)), this.civInfo);
            if (tile.providesYield()) {
                priority += (float)2;
            }
            if (tile.isPillaged()) {
                priority += 1.0f;
            }
            if (tile.hasFalloutEquivalent()) {
                priority += 1.0f;
            }
        } else if (tile.getOwner() == null) {
            boolean bl;
            block13: {
                Sequence<Tile> $this$any$iv = tile.getNeighbors();
                boolean $i$f$any = false;
                Iterator<Tile> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getOwner(), this.civInfo)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
            if (bl) {
                priority += 1.0f;
            }
        }
        if (priority <= 0.0f && tile.hasViewableResource(this.civInfo)) {
            priority += 1.0f;
            if (tile.getTileResource().getResourceType() != ResourceType.Bonus) {
                String string = tile.getResource();
                Intrinsics.checkNotNull(string);
                if (!this.civInfo.hasResource(string)) {
                    priority += (float)2;
                }
            }
        }
        if (((Map)this.roadBetweenCitiesAutomation.getTilesOfRoadsMap$core()).containsKey(tile)) {
            priority += (float)(this.civInfo.getStats().getStatsForNextTurn().getGold() <= 5.0f ? 0 : (this.civInfo.getStats().getStatsForNextTurn().getGold() <= 10.0f ? 1 : (this.civInfo.getStats().getStatsForNextTurn().getGold() <= 30.0f ? 2 : 3)));
        }
        ((Map)this.tileRankings).put(tile, new TileImprovementRank(priority, null, null, null, 14, null));
        return priority + unitSpecificPriority;
    }

    private final float getImprovementPriority(Tile tile, MapUnit unit, LocalUniqueCache localUniqueCache) {
        TileImprovementRank rank;
        block8: {
            block9: {
                this.getBasePriority(tile, unit);
                TileImprovementRank tileImprovementRank = rank = this.tileRankings.get(tile);
                Intrinsics.checkNotNull(tileImprovementRank);
                if (tileImprovementRank.getImprovementPriority() == null) {
                    rank.setImprovementPriority(Float.valueOf(-100.0f));
                    rank.setBestImprovement(null);
                    rank.setRepairImprovment(false);
                    TileImprovement bestImprovement = this.chooseImprovement(unit, tile, localUniqueCache);
                    if (bestImprovement != null) {
                        rank.setBestImprovement(bestImprovement);
                        int timeSpentPriority = Intrinsics.areEqual(tile.getImprovementInProgress(), bestImprovement.getName()) ? bestImprovement.getTurnsToBuild(unit.getCiv(), unit) - tile.getTurnsToImprovement() : 0;
                        TileImprovement tileImprovement = rank.getBestImprovement();
                        Intrinsics.checkNotNull(tileImprovement);
                        rank.setImprovementPriority(Float.valueOf(this.getImprovementRanking(tile, unit, tileImprovement.getName(), localUniqueCache) + (float)timeSpentPriority));
                    }
                    if (tile.getImprovement() != null && tile.isPillaged() && tile.getOwningCity() != null) {
                        TileImprovement tileImprovement = tile.getImprovementToRepair();
                        Intrinsics.checkNotNull(tileImprovement);
                        int repairBonusPriority = tileImprovement.getTurnsToBuild(unit.getCiv(), unit) - UnitActionsFromUniques.INSTANCE.getRepairTurns$core(unit);
                        if (Intrinsics.areEqual(tile.getImprovementInProgress(), "Repair")) {
                            repairBonusPriority += UnitActionsFromUniques.INSTANCE.getRepairTurns$core(unit) - tile.getTurnsToImprovement();
                        }
                        float f = repairBonusPriority;
                        TileStatFunctions tileStatFunctions = tile.getStats();
                        TileImprovement tileImprovement2 = tile.getTileImprovement();
                        Intrinsics.checkNotNull(tileImprovement2);
                        float repairPriority = f + Automation.INSTANCE.rankStatsValue(TileStatFunctions.getStatDiffForImprovement$default(tileStatFunctions, tileImprovement2, unit.getCiv(), tile.getOwningCity(), null, 8, null), unit.getCiv());
                        Float f2 = rank.getImprovementPriority();
                        Intrinsics.checkNotNull(f2);
                        if (repairPriority > f2.floatValue()) {
                            rank.setImprovementPriority(Float.valueOf(repairPriority));
                            rank.setBestImprovement(null);
                            rank.setRepairImprovment(true);
                        }
                    }
                }
                Boolean bl = rank.getRepairImprovment();
                Intrinsics.checkNotNull(bl);
                if (bl.booleanValue()) break block8;
                if (rank.getBestImprovement() == null) break block9;
                TileImprovement tileImprovement = rank.getBestImprovement();
                Intrinsics.checkNotNull(tileImprovement);
                if (unit.canBuildImprovement(tileImprovement, tile)) break block8;
            }
            return -100.0f;
        }
        Float f = rank.getImprovementPriority();
        Intrinsics.checkNotNull(f);
        return f.floatValue();
    }

    private final float getFullPriority(Tile tile, MapUnit unit, LocalUniqueCache localUniqueCache) {
        return this.getBasePriority(tile, unit) + this.getImprovementPriority(tile, unit, localUniqueCache);
    }

    private final boolean tileHasWorkToDo(Tile tile, MapUnit unit, LocalUniqueCache localUniqueCache) {
        if (this.getImprovementPriority(tile, unit, localUniqueCache) <= 0.0f) {
            return false;
        }
        TileImprovementRank tileImprovementRank = this.tileRankings.get(tile);
        Intrinsics.checkNotNull(tileImprovementRank);
        if (tileImprovementRank.getBestImprovement() == null) {
            TileImprovementRank tileImprovementRank2 = this.tileRankings.get(tile);
            Intrinsics.checkNotNull(tileImprovementRank2);
            Boolean bl = tileImprovementRank2.getRepairImprovment();
            Intrinsics.checkNotNull(bl);
            if (!bl.booleanValue()) {
                throw new IllegalStateException("There was an improvementPriority > 0 and nothing to do");
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final TileImprovement chooseImprovement(MapUnit unit, Tile tile, LocalUniqueCache localUniqueCache) {
        block24: {
            block26: {
                block25: {
                    block23: {
                        if (tile.getImprovementInProgress() != null) {
                            v0 = this.ruleSet.getTileImprovements();
                            v1 = tile.getImprovementInProgress();
                            Intrinsics.checkNotNull(v1);
                            return v0.get(v1);
                        }
                        $this$filter$iv = this.ruleSet.getTileImprovements();
                        $i$f$filter = false;
                        var7_7 = $this$filter$iv;
                        destination$iv$iv = new LinkedHashMap<K, V>();
                        $i$f$filterTo = false;
                        var10_15 = $this$filterTo$iv$iv.entrySet().iterator();
                        while (var10_15.hasNext()) {
                            it = element$iv$iv = var10_15.next();
                            $i$a$-filter-WorkerAutomation$chooseImprovement$potentialTileImprovements$1 = false;
                            v2 = unit.canBuildImprovement((TileImprovement)it.getValue(), tile) && tile.getImprovementFunctions().canBuildImprovement((TileImprovement)it.getValue(), this.civInfo) && (((TileImprovement)it.getValue()).getUniqueTo() == null || Intrinsics.areEqual(((TileImprovement)it.getValue()).getUniqueTo(), unit.getCiv().getCivName()));
                            if (!v2) continue;
                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                        }
                        potentialTileImprovements = destination$iv$iv;
                        if (potentialTileImprovements.isEmpty()) {
                            return null;
                        }
                        $this$filterTo$iv$iv = SequencesKt.filter(SequencesKt.map(CollectionsKt.asSequence((Iterable)potentialTileImprovements.values()), (Function1)new Function1<TileImprovement, Pair<? extends TileImprovement, ? extends Float>>(this, tile, unit, localUniqueCache){
                            final /* synthetic */ WorkerAutomation this$0;
                            final /* synthetic */ Tile $tile;
                            final /* synthetic */ MapUnit $unit;
                            final /* synthetic */ LocalUniqueCache $localUniqueCache;
                            {
                                this.this$0 = $receiver;
                                this.$tile = $tile;
                                this.$unit = $unit;
                                this.$localUniqueCache = $localUniqueCache;
                                super(1);
                            }

                            @NotNull
                            public final Pair<TileImprovement, Float> invoke(@NotNull TileImprovement it) {
                                Intrinsics.checkNotNullParameter(it, "it");
                                return new Pair<TileImprovement, Float>(it, Float.valueOf(WorkerAutomation.access$getImprovementRanking(this.this$0, this.$tile, this.$unit, it.getName(), this.$localUniqueCache)));
                            }
                        }), chooseImprovement.bestBuildableImprovement.2.INSTANCE);
                        $i$f$maxByOrNull = false;
                        iterator$iv = $this$maxByOrNull$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            v3 = null;
                        } else {
                            maxElem$iv /* !! */  = iterator$iv.next();
                            if (!iterator$iv.hasNext()) {
                                v3 = maxElem$iv /* !! */ ;
                            } else {
                                it = (Pair)maxElem$iv /* !! */ ;
                                $i$a$-maxByOrNull-WorkerAutomation$chooseImprovement$bestBuildableImprovement$3 = false;
                                maxValue$iv = ((Number)it.getSecond()).floatValue();
                                do {
                                    e$iv = iterator$iv.next();
                                    it = (Pair)e$iv;
                                    $i$a$-maxByOrNull-WorkerAutomation$chooseImprovement$bestBuildableImprovement$3 = false;
                                    v$iv = ((Number)it.getSecond()).floatValue();
                                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                                    maxElem$iv /* !! */  = e$iv;
                                    maxValue$iv = v$iv;
                                } while (iterator$iv.hasNext());
                                v3 = maxElem$iv /* !! */ ;
                            }
                        }
                        v4 = v3;
                        v5 = bestBuildableImprovement = v4 != null ? (TileImprovement)v4.getFirst() : null;
                        if (tile.getImprovement() != null && this.civInfo.isHuman() && !UncivGame.Companion.getCurrent().getSettings().getAutomatedWorkersReplaceImprovements()) {
                            v6 = UncivGame.Companion.getCurrent().getWorldScreen();
                            v7 = v6 != null && (v6 = v6.getAutoPlay()) != null ? !v6.isAutoPlayingAndFullAutoPlayAI() : false;
                            if (v7) {
                                bestBuildableImprovement = null;
                            }
                        }
                        lastTerrain = tile.getLastTerrain();
                        if (tile.getResource() == null || !tile.hasViewableResource(this.civInfo)) {
                            v8 = null;
                        } else if (((Collection)tile.getTerrainFeatures()).isEmpty() == false && lastTerrain.getUnbuildable() && WorkerAutomation.chooseImprovement$isRemovable(this, lastTerrain) && !tile.providesResources(this.civInfo) && !this.isResourceImprovementAllowedOnFeature(tile, potentialTileImprovements)) {
                            v8 = "Remove " + lastTerrain.getName();
                        } else {
                            $this$filter$iv = tile.getTileResource().getImprovements();
                            $i$f$filter = false;
                            maxElem$iv /* !! */  = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                it = (String)element$iv$iv;
                                $i$a$-filter-WorkerAutomation$chooseImprovement$improvementStringForResource$1 = false;
                                if (!(potentialTileImprovements.containsKey(it) != false || Intrinsics.areEqual(it, tile.getImprovement()) != false)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            $i$f$maxByOrNull = false;
                            iterator$iv = $this$maxByOrNull$iv.iterator();
                            if (!iterator$iv.hasNext()) {
                                v9 = null;
                            } else {
                                maxElem$iv = iterator$iv.next();
                                if (!iterator$iv.hasNext()) {
                                    v9 = maxElem$iv;
                                } else {
                                    it = (String)maxElem$iv;
                                    $i$a$-maxByOrNull-WorkerAutomation$chooseImprovement$improvementStringForResource$2 = false;
                                    maxValue$iv = this.getImprovementRanking(tile, unit, it, localUniqueCache);
                                    do {
                                        e$iv = iterator$iv.next();
                                        it = (String)e$iv;
                                        $i$a$-maxByOrNull-WorkerAutomation$chooseImprovement$improvementStringForResource$2 = false;
                                        v$iv = this.getImprovementRanking(tile, unit, it, localUniqueCache);
                                        if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                                        maxElem$iv = e$iv;
                                        maxValue$iv = v$iv;
                                    } while (iterator$iv.hasNext());
                                    v9 = maxElem$iv;
                                }
                            }
                            v8 = v9;
                        }
                        improvementStringForResource = v8;
                        if (bestBuildableImprovement == null || !bestBuildableImprovement.isRoad()) break block23;
                        v10 /* !! */  = bestBuildableImprovement.getName();
                        break block24;
                    }
                    v11 = improvementStringForResource;
                    if (v11 == null) break block25;
                    v10 /* !! */  = Intrinsics.areEqual(v11, tile.getImprovement()) ? null : improvementStringForResource;
                    break block24;
                }
                if (tile.getResource() != null && tile.hasViewableResource(this.civInfo) && CollectionsKt.any((Iterable)tile.getTileResource().getImprovements())) {
                    return null;
                }
                if (bestBuildableImprovement != null) break block26;
                v10 /* !! */  = null;
                break block24;
            }
            if (tile.getImprovement() == null) ** GOTO lbl-1000
            v12 = tile.getImprovement();
            Intrinsics.checkNotNull(v12);
            if (this.getImprovementRanking(tile, unit, v12, localUniqueCache) > this.getImprovementRanking(tile, unit, bestBuildableImprovement.getName(), localUniqueCache)) {
                v10 /* !! */  = null;
            } else lbl-1000:
            // 2 sources

            {
                it = lastTerrain;
                $i$a$-let-WorkerAutomation$chooseImprovement$improvementString$1 = false;
                v10 /* !! */  = (WorkerAutomation.chooseImprovement$isRemovable(this, it) && (Automation.INSTANCE.rankStatsValue(it, this.civInfo) < 0.0f || IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.NullifyYields, null, 2, null))) != false ? "Remove " + lastTerrain.getName() : bestBuildableImprovement.getName();
            }
        }
        improvementString = v10 /* !! */ ;
        return (TileImprovement)((Map)this.ruleSet.getTileImprovements()).get(improvementString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final float getImprovementRanking(Tile tile, MapUnit unit, String improvementName, LocalUniqueCache localUniqueCache) {
        TileImprovement tileImprovement = this.ruleSet.getTileImprovements().get(improvementName);
        Intrinsics.checkNotNull(tileImprovement);
        TileImprovement improvement2 = tileImprovement;
        if (improvement2.isRoad() && Intrinsics.areEqual(this.roadBetweenCitiesAutomation.getBestRoadAvailable$core().improvement(this.ruleSet), improvement2) && ((Map)this.roadBetweenCitiesAutomation.getTilesOfRoadsMap$core()).containsKey(tile)) {
            RoadBetweenCitiesAutomation.RoadPlan roadPlan = this.roadBetweenCitiesAutomation.getTilesOfRoadsMap$core().get(tile);
            Intrinsics.checkNotNull(roadPlan);
            RoadBetweenCitiesAutomation.RoadPlan roadPlan2 = roadPlan;
            float value = roadPlan2.getPriority();
            if (!(this.civInfo.getStats().getStatsForNextTurn().getGold() >= 20.0f)) return value;
            value += (float)RangesKt.coerceAtLeast(5 - roadPlan2.getNumberOfRoadsToBuild(), 0);
            return value;
        }
        if (!Intrinsics.areEqual(tile.getOwner(), unit.getCiv())) {
            boolean bl;
            TileImprovement tileImprovement2 = this.ruleSet.getTileImprovements().get(improvementName);
            Intrinsics.checkNotNull(tileImprovement2);
            if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)tileImprovement2, UniqueType.CanBuildOutsideBorders, null, 2, null)) return 0.0f;
            Sequence<Tile> $this$any$iv = tile.getNeighbors();
            boolean $i$f$any = false;
            Iterator<Tile> iterator2 = $this$any$iv.iterator();
            do {
                Tile element$iv;
                if (!iterator2.hasNext()) return 0.0f;
                Tile it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (Intrinsics.areEqual(it.getOwner(), unit.getCiv()) && it.getOwningCity() != null) {
                    City city2 = it.getOwningCity();
                    Intrinsics.checkNotNull(city2);
                    if (tile.aerialDistanceTo(city2.getCenterTile()) <= this.civInfo.getModConstants().getCityWorkRange()) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            boolean bl3 = true;
            if (!bl3) {
                return 0.0f;
            }
        }
        Stats stats2 = tile.getStats().getStatDiffForImprovement(improvement2, this.civInfo, tile.getCity(), localUniqueCache);
        if (StringsKt.startsWith$default(improvementName, "Remove ", false, 2, null)) {
            String removedImprovement;
            Object v6;
            String removedObject;
            block19: {
                removedObject = StringsKt.replace$default(improvementName, "Remove ", "", false, 4, null);
                Iterable $this$firstOrNull$iv = tile.getTerrainFeatures();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it, removedObject)) continue;
                    v6 = element$iv;
                    break block19;
                }
                v6 = null;
            }
            String removedFeature = v6;
            String string = removedImprovement = Intrinsics.areEqual(removedObject, tile.getImprovement()) ? removedObject : null;
            if (removedFeature != null || removedImprovement != null) {
                TileImprovement wantedFinalImprovement;
                Tile newTile = tile.clone();
                newTile.setTerrainTransients();
                if (removedFeature != null) {
                    newTile.removeTerrainFeature(removedFeature);
                }
                if (removedImprovement != null) {
                    newTile.removeImprovement();
                }
                if ((wantedFinalImprovement = this.chooseImprovement(unit, newTile, localUniqueCache)) != null) {
                    stats2.add(newTile.getStats().getStatDiffForImprovement(wantedFinalImprovement, this.civInfo, newTile.getCity(), localUniqueCache));
                }
            }
        }
        if (!Intrinsics.areEqual(tile.getOwner(), unit.getCiv())) {
            stats2.div(3.0f);
        }
        float value = Automation.INSTANCE.rankStatsValue(stats2, unit.getCiv());
        if (tile.getResource() != null && tile.getTileResource().getResourceType() != ResourceType.Bonus) {
            if (tile.getImprovement() != null) {
                TileResource tileResource = tile.getTileResource();
                String string = tile.getImprovement();
                Intrinsics.checkNotNull(string);
                if (tileResource.isImprovedBy(string)) {
                    value -= (float)RangesKt.coerceIn(tile.getResourceAmount() / 2, 1, 2);
                }
            }
            if (tile.getTileResource().isImprovedBy(improvementName)) {
                value += (float)RangesKt.coerceIn(tile.getResourceAmount() / 2, 1, 2);
            }
        }
        if (this.isImprovementProbablyAFort(improvement2)) {
            value += this.evaluateFortSurroundings(tile, IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)improvement2, UniqueType.TakesOverAdjacentTiles, null, 2, null));
            return value;
        } else {
            if (tile.getTileImprovement() == null) return value;
            TileImprovement tileImprovement3 = tile.getTileImprovement();
            Intrinsics.checkNotNull(tileImprovement3);
            if (!this.isImprovementProbablyAFort(tileImprovement3)) return value;
            value /= (float)2;
        }
        return value;
    }

    private final boolean isResourceImprovementAllowedOnFeature(Tile tile, Map<String, TileImprovement> potentialTileImprovements) {
        boolean bl;
        block9: {
            Iterable $this$any$iv = tile.getTileResource().getImprovements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block8: {
                        String resourceImprovementName = (String)element$iv;
                        boolean bl3 = false;
                        if (!potentialTileImprovements.containsKey(resourceImprovementName)) {
                            bl2 = false;
                        } else {
                            Intrinsics.checkNotNull(potentialTileImprovements.get(resourceImprovementName));
                            Iterable $this$any$iv2 = tile.getTerrainFeatureObjects();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    TileImprovement resourceImprovement;
                                    Terrain it = (Terrain)element$iv2;
                                    boolean bl4 = false;
                                    if (!resourceImprovement.isAllowedOnFeature(it)) continue;
                                    bl2 = true;
                                    break block8;
                                }
                                bl2 = false;
                            }
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isAcceptableTileForFort(Tile tile) {
        return !tile.isCityCenter() && tile.isLand() && (!tile.hasViewableResource(this.civInfo) || tile.getTileResource().getResourceType() == ResourceType.Bonus) && !tile.containsGreatImprovement();
    }

    /*
     * WARNING - void declaration
     */
    private final float evaluateFortSurroundings(Tile tile, boolean isCitadel) {
        Object t;
        void $this$minBy$iv;
        void $this$mapTo$iv$iv;
        Object v6;
        Object v5;
        Object it;
        void $this$filterTo$iv$iv;
        block37: {
            block36: {
                block35: {
                    boolean bl;
                    block34: {
                        City city2 = tile.getOwningCity();
                        if (Intrinsics.areEqual(city2 != null ? city2.getCiv() : null, this.civInfo)) break block35;
                        if (!isCitadel) break block36;
                        Sequence<Tile> $this$all$iv = tile.getNeighbors();
                        boolean $i$f$all = false;
                        Iterator<Tile> iterator2 = $this$all$iv.iterator();
                        while (iterator2.hasNext()) {
                            Tile element$iv = iterator2.next();
                            Tile it2 = element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it2.getOwner(), this.civInfo)) continue;
                            bl = false;
                            break block34;
                        }
                        bl = true;
                    }
                    if (bl) break block36;
                }
                if (this.isAcceptableTileForFort(tile)) break block37;
            }
            return 0.0f;
        }
        List<Civilization> enemyCivs = this.civInfo.getCivsAtWarWith();
        if (CollectionsKt.none((Iterable)enemyCivs)) {
            return 0.0f;
        }
        float valueOfFort = 2.0f;
        if (this.civInfo.isCityState() && this.civInfo.getAllyCiv() != null) {
            valueOfFort -= 1.0f;
        }
        if (tile.hasViewableResource(this.civInfo)) {
            valueOfFort -= 1.0f;
        }
        List<Tile> nearestTiles2 = SequencesKt.toList(SequencesKt.filter(tile.getTilesInDistance(1), (Function1)new Function1<Tile, Boolean>(this){
            final /* synthetic */ WorkerAutomation this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                City city2 = it.getOwningCity();
                return Intrinsics.areEqual(city2 != null ? city2.getCiv() : null, this.this$0.getCivInfo());
            }
        }));
        for (Tile closeTile : nearestTiles2) {
            block40: {
                block39: {
                    block38: {
                        if (closeTile.isCityCenter()) {
                            valueOfFort -= 0.5f;
                            continue;
                        }
                        if (closeTile.getImprovement() == null) break block38;
                        TileImprovement tileImprovement = closeTile.getTileImprovement();
                        Intrinsics.checkNotNull(tileImprovement);
                        if (this.isImprovementProbablyAFort(tileImprovement)) break block39;
                    }
                    if (closeTile.getImprovementInProgress() == null) break block40;
                    String string = closeTile.getImprovementInProgress();
                    Intrinsics.checkNotNull(string);
                    if (!this.isImprovementProbablyAFort(string)) break block40;
                }
                valueOfFort -= 1.0f;
            }
            if (!tile.isHill() && closeTile.isHill() && this.isAcceptableTileForFort(closeTile)) {
                valueOfFort -= 0.2f;
            }
            if (!tile.isImpassible()) continue;
            valueOfFort += 0.2f;
        }
        Function1 threatMapping2 = new Function1<Civilization, Integer>(this){
            final /* synthetic */ WorkerAutomation this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull Civilization it) {
                int n;
                Intrinsics.checkNotNullParameter(it, "it");
                int n2 = this.this$0.getCivInfo().isAtWarWith(it) ? 5 : 0;
                switch (evaluateFortSurroundings.threatMapping.WhenMappings.$EnumSwitchMapping$0[Automation.INSTANCE.threatAssessment(this.this$0.getCivInfo(), it).ordinal()]) {
                    case 1: {
                        n = 1;
                        break;
                    }
                    case 2: {
                        n = 6;
                        break;
                    }
                    case 3: {
                        n = 10;
                        break;
                    }
                    case 4: {
                        n = 15;
                        break;
                    }
                    case 5: {
                        n = 20;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return n2 + n;
            }
        };
        Iterable $this$filter$iv = enemyCivs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            boolean bl4 = false;
            boolean bl3 = NextTurnAutomation.INSTANCE.getMinDistanceBetweenCities(this.civInfo, (Civilization)it) <= ((Number)threatMapping2.invoke(it)).intValue();
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enemyCivsIsCloseEnough = (List)destination$iv$iv;
        if (CollectionsKt.none(enemyCivsIsCloseEnough)) {
            return 0.0f;
        }
        List enemyCities2 = new ArrayList();
        Iterable $this$forEach$iv = enemyCivsIsCloseEnough;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Civilization it3 = (Civilization)element$iv;
            boolean bl = false;
            it = it3.getCities();
            List bl4 = enemyCities2;
            boolean $i$f$map = false;
            void var18_44 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void city3;
                City city4 = (City)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl5 = false;
                collection.add(city3.getCenterTile());
            }
            bl4.addAll((List)destination$iv$iv2);
        }
        Iterable $this$minByOrNull$iv = enemyCities2;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v5 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v5 = minElem$iv;
            } else {
                Tile it4 = (Tile)minElem$iv;
                boolean bl = false;
                int minValue$iv = it4.aerialDistanceTo(tile);
                do {
                    Object e$iv = iterator$iv.next();
                    Tile it5 = (Tile)e$iv;
                    $i$a$-minByOrNull-WorkerAutomation$evaluateFortSurroundings$closestEnemyCity$1 = false;
                    int v$iv = it5.aerialDistanceTo(tile);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v5 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v5);
        Tile closestEnemyCity2 = v5;
        int distanceToEnemyCity = tile.aerialDistanceTo(closestEnemyCity2);
        Iterable $this$minByOrNull$iv2 = this.civInfo.getCities();
        boolean $i$f$minByOrNull2 = false;
        Iterator iterator$iv2 = $this$minByOrNull$iv2.iterator();
        if (!iterator$iv2.hasNext()) {
            v6 = null;
        } else {
            Object minElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v6 = minElem$iv;
            } else {
                City it6 = (City)minElem$iv;
                boolean bl = false;
                int minValue$iv = it6.getCenterTile().aerialDistanceTo(tile);
                do {
                    Object e$iv = iterator$iv2.next();
                    City it7 = (City)e$iv;
                    $i$a$-minByOrNull-WorkerAutomation$evaluateFortSurroundings$closestCity$1 = false;
                    int v$iv = it7.getCenterTile().aerialDistanceTo(tile);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v6 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v6);
        Tile closestCity = ((City)v6).getCenterTile();
        int distanceBetweenCities = closestEnemyCity2.aerialDistanceTo(closestCity);
        Iterable $this$map$iv = this.civInfo.getCities();
        boolean $i$f$map = false;
        Iterable minValue$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it8;
            City city5 = (City)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it8.getCenterTile().aerialDistanceTo(closestEnemyCity2));
        }
        $this$map$iv = (List)destination$iv$iv3;
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv3 = $this$minBy$iv.iterator();
        if (!iterator$iv3.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv3.next();
        if (!iterator$iv3.hasNext()) {
            t = minElem$iv;
        } else {
            int it9 = ((Number)minElem$iv).intValue();
            boolean bl = false;
            int minValue$iv2 = it9;
            do {
                Object e$iv = iterator$iv3.next();
                int it10 = ((Number)e$iv).intValue();
                $i$a$-minByOrThrow-WorkerAutomation$evaluateFortSurroundings$distanceOfEnemyCityToClosestCityOfUs$2 = false;
                int v$iv = it10;
                if (minValue$iv2 <= v$iv) continue;
                minElem$iv = e$iv;
                minValue$iv2 = v$iv;
            } while (iterator$iv3.hasNext());
            t = minElem$iv;
        }
        int distanceOfEnemyCityToClosestCityOfUs = ((Number)t).intValue();
        if (distanceBetweenCities >= distanceOfEnemyCityToClosestCityOfUs + 2) {
            return 0.0f;
        }
        if (distanceToEnemyCity >= distanceBetweenCities || distanceToEnemyCity <= 2) {
            return 0.0f;
        }
        return RangesKt.coerceAtLeast(valueOfFort += (float)(2 - Math.abs(distanceBetweenCities - 1 - distanceToEnemyCity)), 0.0f);
    }

    public final boolean evaluateFortPlacement(@NotNull Tile tile, boolean isCitadel) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return !Intrinsics.areEqual(tile.getImprovement(), "Fort") && this.evaluateFortSurroundings(tile, isCitadel) > 0.0f;
    }

    public final boolean isImprovementProbablyAFort(@NotNull String improvementName) {
        Intrinsics.checkNotNullParameter(improvementName, "improvementName");
        TileImprovement tileImprovement = this.ruleSet.getTileImprovements().get(improvementName);
        Intrinsics.checkNotNull(tileImprovement);
        return this.isImprovementProbablyAFort(tileImprovement);
    }

    public final boolean isImprovementProbablyAFort(@NotNull TileImprovement improvement2) {
        Intrinsics.checkNotNullParameter(improvement2, "improvement");
        return IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)improvement2, UniqueType.DefensiveBonus, null, 2, null);
    }

    public final boolean automateWorkBoats(@NotNull MapUnit unit) {
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Sequence $this$sortedBy$iv = SequencesKt.filter(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)unit.getCiv().getCities()), automateWorkBoats.closestReachableResource.1.INSTANCE), (Function1)new Function1<Tile, Boolean>(unit){
                final /* synthetic */ MapUnit $unit;
                {
                    this.$unit = $unit;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Tile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return WorkerAutomation.Companion.hasWorkableSeaResource(it, this.$unit.getCiv()) && (Intrinsics.areEqual(this.$unit.getCurrentTile(), it) || UnitMovement.canMoveTo$default(this.$unit.getMovement(), it, false, false, false, 14, null));
                }
            });
            boolean $i$f$sortedBy = false;
            Sequence $this$firstOrNull$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Tile it = (Tile)element$iv;
                boolean bl = false;
                if (!(unit.getMovement().canReach(it) && Companion.isNotBonusResourceOrWorkable(it, unit.getCiv()))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Tile tile = v0;
        if (tile == null) {
            return false;
        }
        Tile closestReachableResource2 = tile;
        unit.getMovement().headTowards(closestReachableResource2);
        if (!Intrinsics.areEqual(unit.getCurrentTile(), closestReachableResource2)) {
            return true;
        }
        return UnitActions.INSTANCE.invokeUnitAction(unit, UnitActionType.CreateImprovement);
    }

    private static final boolean chooseImprovement$isRemovable(WorkerAutomation this$0, Terrain terrain2) {
        return this$0.ruleSet.getTileImprovements().containsKey("Remove " + terrain2.getName());
    }

    public static final /* synthetic */ float access$getImprovementRanking(WorkerAutomation $this, Tile tile, MapUnit unit, String improvementName, LocalUniqueCache localUniqueCache) {
        return $this.getImprovementRanking(tile, unit, improvementName, localUniqueCache);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/unciv/logic/automation/unit/WorkerAutomation$Companion;", "", "()V", "hasWorkableSeaResource", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "isNotBonusResourceOrWorkable", "core"})
    @SourceDebugExtension(value={"SMAP\nWorkerAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerAutomation.kt\ncom/unciv/logic/automation/unit/WorkerAutomation$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,632:1\n1747#2,3:633\n1747#2,3:636\n*S KotlinDebug\n*F\n+ 1 WorkerAutomation.kt\ncom/unciv/logic/automation/unit/WorkerAutomation$Companion\n*L\n616#1:633,3\n629#1:636,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean hasWorkableSeaResource(@NotNull Tile tile, @NotNull Civilization civInfo) {
            TileImprovement improvement2;
            Intrinsics.checkNotNullParameter(tile, "tile");
            Intrinsics.checkNotNullParameter(civInfo, "civInfo");
            if (!tile.isWater()) {
                return false;
            }
            if (tile.getResource() == null) {
                return false;
            }
            if (tile.getImprovement() != null) {
                TileResource tileResource = tile.getTileResource();
                String string = tile.getImprovement();
                Intrinsics.checkNotNull(string);
                if (tileResource.isImprovedBy(string)) {
                    return false;
                }
            }
            if (!tile.hasViewableResource(civInfo)) {
                return false;
            }
            Iterable $this$any$iv = tile.getTileResource().getImprovements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                String it = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(civInfo.getGameInfo().getRuleset().getTileImprovements().get(it));
            } while (!tile.getImprovementFunctions().canBuildImprovement(improvement2, civInfo));
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isNotBonusResourceOrWorkable(@NotNull Tile tile, @NotNull Civilization civInfo) {
            City it;
            Intrinsics.checkNotNullParameter(tile, "tile");
            Intrinsics.checkNotNullParameter(civInfo, "civInfo");
            if (tile.getTileResource().getResourceType() != ResourceType.Bonus) return true;
            Iterable $this$any$iv = civInfo.getCities();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (City)element$iv;
                boolean bl = false;
            } while (!it.getTilesInRange().contains(tile));
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014J<\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001fJ\u0013\u0010 \u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lcom/unciv/logic/automation/unit/WorkerAutomation$TileImprovementRank;", "", "tilePriority", "", "improvementPriority", "bestImprovement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "repairImprovment", "", "(FLjava/lang/Float;Lcom/unciv/models/ruleset/tile/TileImprovement;Ljava/lang/Boolean;)V", "getBestImprovement", "()Lcom/unciv/models/ruleset/tile/TileImprovement;", "setBestImprovement", "(Lcom/unciv/models/ruleset/tile/TileImprovement;)V", "getImprovementPriority", "()Ljava/lang/Float;", "setImprovementPriority", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "getRepairImprovment", "()Ljava/lang/Boolean;", "setRepairImprovment", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getTilePriority", "()F", "component1", "component2", "component3", "component4", "copy", "(FLjava/lang/Float;Lcom/unciv/models/ruleset/tile/TileImprovement;Ljava/lang/Boolean;)Lcom/unciv/logic/automation/unit/WorkerAutomation$TileImprovementRank;", "equals", "other", "hashCode", "", "toString", "", "core"})
    public static final class TileImprovementRank {
        private final float tilePriority;
        @Nullable
        private Float improvementPriority;
        @Nullable
        private TileImprovement bestImprovement;
        @Nullable
        private Boolean repairImprovment;

        public TileImprovementRank(float tilePriority, @Nullable Float improvementPriority, @Nullable TileImprovement bestImprovement, @Nullable Boolean repairImprovment) {
            this.tilePriority = tilePriority;
            this.improvementPriority = improvementPriority;
            this.bestImprovement = bestImprovement;
            this.repairImprovment = repairImprovment;
        }

        public /* synthetic */ TileImprovementRank(float f, Float f2, TileImprovement tileImprovement, Boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                f2 = null;
            }
            if ((n & 4) != 0) {
                tileImprovement = null;
            }
            if ((n & 8) != 0) {
                bl = null;
            }
            this(f, f2, tileImprovement, bl);
        }

        public final float getTilePriority() {
            return this.tilePriority;
        }

        @Nullable
        public final Float getImprovementPriority() {
            return this.improvementPriority;
        }

        public final void setImprovementPriority(@Nullable Float f) {
            this.improvementPriority = f;
        }

        @Nullable
        public final TileImprovement getBestImprovement() {
            return this.bestImprovement;
        }

        public final void setBestImprovement(@Nullable TileImprovement tileImprovement) {
            this.bestImprovement = tileImprovement;
        }

        @Nullable
        public final Boolean getRepairImprovment() {
            return this.repairImprovment;
        }

        public final void setRepairImprovment(@Nullable Boolean bl) {
            this.repairImprovment = bl;
        }

        public final float component1() {
            return this.tilePriority;
        }

        @Nullable
        public final Float component2() {
            return this.improvementPriority;
        }

        @Nullable
        public final TileImprovement component3() {
            return this.bestImprovement;
        }

        @Nullable
        public final Boolean component4() {
            return this.repairImprovment;
        }

        @NotNull
        public final TileImprovementRank copy(float tilePriority, @Nullable Float improvementPriority, @Nullable TileImprovement bestImprovement, @Nullable Boolean repairImprovment) {
            return new TileImprovementRank(tilePriority, improvementPriority, bestImprovement, repairImprovment);
        }

        public static /* synthetic */ TileImprovementRank copy$default(TileImprovementRank tileImprovementRank, float f, Float f2, TileImprovement tileImprovement, Boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                f = tileImprovementRank.tilePriority;
            }
            if ((n & 2) != 0) {
                f2 = tileImprovementRank.improvementPriority;
            }
            if ((n & 4) != 0) {
                tileImprovement = tileImprovementRank.bestImprovement;
            }
            if ((n & 8) != 0) {
                bl = tileImprovementRank.repairImprovment;
            }
            return tileImprovementRank.copy(f, f2, tileImprovement, bl);
        }

        @NotNull
        public String toString() {
            return "TileImprovementRank(tilePriority=" + this.tilePriority + ", improvementPriority=" + this.improvementPriority + ", bestImprovement=" + this.bestImprovement + ", repairImprovment=" + this.repairImprovment + ')';
        }

        public int hashCode() {
            int result2 = Float.hashCode(this.tilePriority);
            result2 = result2 * 31 + (this.improvementPriority == null ? 0 : ((Object)this.improvementPriority).hashCode());
            result2 = result2 * 31 + (this.bestImprovement == null ? 0 : this.bestImprovement.hashCode());
            result2 = result2 * 31 + (this.repairImprovment == null ? 0 : ((Object)this.repairImprovment).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TileImprovementRank)) {
                return false;
            }
            TileImprovementRank tileImprovementRank = (TileImprovementRank)other;
            if (Float.compare(this.tilePriority, tileImprovementRank.tilePriority) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.improvementPriority, (Object)tileImprovementRank.improvementPriority)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.bestImprovement, tileImprovementRank.bestImprovement)) {
                return false;
            }
            return Intrinsics.areEqual(this.repairImprovment, tileImprovementRank.repairImprovment);
        }
    }
}

