/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.GameInfo;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\bH\u0002J\u001e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/unciv/logic/battle/BattleUnitCapture;", "", "()V", "captureCivilianUnit", "", "attacker", "Lcom/unciv/logic/battle/ICombatant;", "defender", "Lcom/unciv/logic/battle/MapUnitCombatant;", "checkDefeat", "", "captureOrConvertToWorker", "Lcom/badlogic/gdx/math/Vector2;", "capturedUnit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "capturingCiv", "Lcom/unciv/logic/civilization/Civilization;", "spawnCapturedUnit", "tryCaptureMilitaryUnit", "attackedTile", "Lcom/unciv/logic/map/tile/Tile;", "unitCapturedFromEncampment", "unitCapturedPrizeShipsUnique", "unitGainFromDefeatingUnit", "core"})
@SourceDebugExtension(value={"SMAP\nBattleUnitCapture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleUnitCapture.kt\ncom/unciv/logic/battle/BattleUnitCapture\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,227:1\n1747#2,3:228\n288#2:233\n289#2:236\n2141#3,2:231\n1229#3,2:234\n*S KotlinDebug\n*F\n+ 1 BattleUnitCapture.kt\ncom/unciv/logic/battle/BattleUnitCapture\n*L\n38#1:228,3\n219#1:233\n219#1:236\n52#1:231,2\n220#1:234,2\n*E\n"})
public final class BattleUnitCapture {
    @NotNull
    public static final BattleUnitCapture INSTANCE = new BattleUnitCapture();

    private BattleUnitCapture() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryCaptureMilitaryUnit(@NotNull ICombatant attacker, @NotNull ICombatant defender, @NotNull Tile attackedTile) {
        boolean wasUnitCaptured;
        block7: {
            boolean bl;
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(attacker, "attacker");
            Intrinsics.checkNotNullParameter(defender, "defender");
            Intrinsics.checkNotNullParameter(attackedTile, "attackedTile");
            if (!(defender instanceof MapUnitCombatant) || !(attacker instanceof MapUnitCombatant)) {
                return false;
            }
            if (((MapUnitCombatant)defender).hasUnique(UniqueType.Uncapturable, new StateForConditionals(null, null, ((MapUnitCombatant)defender).getUnit(), null, defender, attacker, attackedTile, null, null, false, 907, null))) {
                return false;
            }
            if (!defender.isDefeated() || ((MapUnitCombatant)defender).getUnit().isCivilian()) {
                return false;
            }
            Object object = new Boolean[]{this.unitCapturedPrizeShipsUnique((MapUnitCombatant)attacker, (MapUnitCombatant)defender), this.unitCapturedFromEncampment((MapUnitCombatant)attacker, (MapUnitCombatant)defender, attackedTile), this.unitGainFromDefeatingUnit((MapUnitCombatant)attacker, (MapUnitCombatant)defender)};
            object = CollectionsKt.listOf(object);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean it = (Boolean)element$iv;
                    boolean bl2 = false;
                    if (!it) continue;
                    bl = true;
                    break block7;
                }
                bl = wasUnitCaptured = false;
            }
        }
        if (!wasUnitCaptured) {
            return false;
        }
        return this.spawnCapturedUnit((MapUnitCombatant)defender, (MapUnitCombatant)attacker);
    }

    private final boolean unitCapturedPrizeShipsUnique(MapUnitCombatant attacker, MapUnitCombatant defender) {
        boolean bl;
        block2: {
            Sequence $this$none$iv = MapUnit.getMatchingUniques$default(attacker.getUnit(), UniqueType.KillUnitCapture, null, false, 6, null);
            boolean $i$f$none = false;
            Iterator iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Unique it = (Unique)element$iv;
                boolean bl2 = false;
                if (!defender.matchesFilter(it.getParams().get(0))) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (bl) {
            return false;
        }
        float captureChance = Math.min(0.8f, 0.1f + (float)attacker.getAttackingStrength() / (float)ICombatant.DefaultImpls.getDefendingStrength$default(defender, false, 1, null) * 0.4f);
        Random random = RandomKt.Random((long)(attacker.getCivInfo().getGameInfo().getTurns() * defender.getTile().getPosition().hashCode()));
        return random.nextFloat() <= captureChance;
    }

    private final boolean unitGainFromDefeatingUnit(MapUnitCombatant attacker, MapUnitCombatant defender) {
        if (!attacker.isMelee()) {
            return false;
        }
        boolean unitCaptured = false;
        StateForConditionals state = new StateForConditionals(attacker.getCivInfo(), null, null, null, attacker, defender, null, null, null, false, 974, null);
        Iterator<Unique> iterator2 = attacker.getMatchingUniques(UniqueType.GainFromDefeatingUnit, state, true).iterator();
        while (iterator2.hasNext()) {
            Unique unique = iterator2.next();
            if (!defender.getUnit().matchesFilter(unique.getParams().get(0))) continue;
            attacker.getCivInfo().addGold(Integer.parseInt(unique.getParams().get(1)));
            unitCaptured = true;
        }
        return unitCaptured;
    }

    private final boolean unitCapturedFromEncampment(MapUnitCombatant attacker, MapUnitCombatant defender, Tile attackedTile) {
        if (!defender.getCivInfo().isBarbarian()) {
            return false;
        }
        if (!Intrinsics.areEqual(attackedTile.getImprovement(), "Barbarian encampment")) {
            return false;
        }
        boolean unitCaptured = false;
        Iterator iterator2 = Civilization.getMatchingUniques$default(attacker.getCivInfo(), UniqueType.GainFromEncampment, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            attacker.getCivInfo().addGold(Integer.parseInt(unique.getParams().get(0)));
            unitCaptured = true;
        }
        return unitCaptured;
    }

    private final boolean spawnCapturedUnit(MapUnitCombatant defender, MapUnitCombatant attacker) {
        Tile defenderTile = defender.getTile();
        MapUnit mapUnit = attacker.getCivInfo().getUnits().placeUnitNearTile(defenderTile.getPosition(), defender.getName());
        if (mapUnit == null) {
            return false;
        }
        MapUnit addedUnit = mapUnit;
        addedUnit.setCurrentMovement(0.0f);
        addedUnit.setHealth(50);
        String[] stringArray = new String[]{defender.getName()};
        attacker.getCivInfo().addNotification("An enemy [" + defender.getName() + "] has joined us!", addedUnit.getTile().getPosition(), Notification.NotificationCategory.War, stringArray);
        stringArray = new String[]{attacker.getName(), "OtherIcons/Pillage", defender.getName()};
        defender.getCivInfo().addNotification("An enemy [" + attacker.getName() + "] has captured our [" + defender.getName() + ']', defender.getTile().getPosition(), Notification.NotificationCategory.War, stringArray);
        MapUnit civilianUnit = defenderTile.getCivilianUnit();
        if (!Intrinsics.areEqual(addedUnit.getTile(), defenderTile) && civilianUnit != null) {
            BattleUnitCapture.captureCivilianUnit$default(this, attacker, new MapUnitCombatant(civilianUnit), false, 4, null);
        }
        return true;
    }

    public final void captureCivilianUnit(@NotNull ICombatant attacker, @NotNull MapUnitCombatant defender, boolean checkDefeat) {
        Civilization civilization;
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(defender, "defender");
        if (!(!Intrinsics.areEqual(attacker.getCivInfo(), defender.getCivInfo()))) {
            boolean $i$a$-require-BattleUnitCapture$captureCivilianUnit$22 = false;
            String $i$a$-require-BattleUnitCapture$captureCivilianUnit$22 = "Can't capture our own unit!";
            throw new IllegalArgumentException($i$a$-require-BattleUnitCapture$captureCivilianUnit$22.toString());
        }
        Civilization defenderCiv = defender.getCivInfo();
        MapUnit capturedUnit = defender.getUnit();
        capturedUnit.setAction(null);
        capturedUnit.setAutomated(false);
        Tile capturedUnitTile = capturedUnit.getTile();
        if (capturedUnit.getOriginalOwner() != null) {
            GameInfo gameInfo2 = capturedUnit.getCiv().getGameInfo();
            String string = capturedUnit.getOriginalOwner();
            Intrinsics.checkNotNull(string);
            civilization = gameInfo2.getCivilization(string);
        } else {
            civilization = null;
        }
        Civilization originalOwner = civilization;
        boolean wasDestroyedInstead = false;
        if (MapUnit.hasUnique$default(defender.getUnit(), UniqueType.Uncapturable, null, false, 6, null)) {
            MapUnit.destroy$default(capturedUnit, false, 1, null);
            wasDestroyedInstead = true;
        } else if (MapUnit.hasUnique$default(capturedUnit, UniqueType.FoundCity, null, false, 6, null) && attacker.getCivInfo().isCityState()) {
            MapUnit.destroy$default(capturedUnit, false, 1, null);
            wasDestroyedInstead = true;
        } else if (Intrinsics.areEqual(attacker.getCivInfo(), originalOwner)) {
            capturedUnit.capturedBy(attacker.getCivInfo());
        } else if (defender.getCivInfo().isBarbarian() && originalOwner != null && !originalOwner.isBarbarian() && !Intrinsics.areEqual(attacker.getCivInfo(), originalOwner) && attacker.getCivInfo().knows(originalOwner) && originalOwner.isAlive() && !attacker.getCivInfo().isAtWarWith(originalOwner) && attacker.getCivInfo().getPlayerType() == PlayerType.Human) {
            capturedUnit.capturedBy(attacker.getCivInfo());
            ArrayList<PopupAlert> arrayList = attacker.getCivInfo().getPopupAlerts();
            String string = capturedUnit.getCurrentTile().getPosition().toString();
            Intrinsics.checkNotNullExpressionValue(string, "capturedUnit.currentTile.position.toString()");
            arrayList.add(new PopupAlert(AlertType.RecapturedCivilian, string));
        } else if (this.captureOrConvertToWorker(capturedUnit, attacker.getCivInfo()) == null) {
            wasDestroyedInstead = true;
        }
        if (!wasDestroyedInstead) {
            String[] stringArray = new String[]{attacker.getName(), "OtherIcons/Pillage", defender.getName()};
            defenderCiv.addNotification("An enemy [" + attacker.getName() + "] has captured our [" + defender.getName() + ']', defender.getTile().getPosition(), Notification.NotificationCategory.War, stringArray);
        } else {
            String[] stringArray = new String[]{attacker.getName(), "OtherIcons/Pillage", defender.getName()};
            defenderCiv.addNotification("An enemy [" + attacker.getName() + "] has destroyed our [" + defender.getName() + ']', defender.getTile().getPosition(), Notification.NotificationCategory.War, stringArray);
            Battle.INSTANCE.triggerDefeatUniques$core(defender, attacker, capturedUnitTile);
        }
        if (checkDefeat) {
            Battle.destroyIfDefeated$default(Battle.INSTANCE, defenderCiv, attacker.getCivInfo(), null, 4, null);
        }
        MapUnit.updateVisibleTiles$default(capturedUnit, false, null, 3, null);
    }

    public static /* synthetic */ void captureCivilianUnit$default(BattleUnitCapture battleUnitCapture, ICombatant iCombatant, MapUnitCombatant mapUnitCombatant, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        battleUnitCapture.captureCivilianUnit(iCombatant, mapUnitCombatant, bl);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Vector2 captureOrConvertToWorker(@NotNull MapUnit capturedUnit, @NotNull Civilization capturingCiv) {
        block7: {
            Intrinsics.checkNotNullParameter(capturedUnit, "capturedUnit");
            Intrinsics.checkNotNullParameter(capturingCiv, "capturingCiv");
            if (!MapUnit.hasUnique$default(capturedUnit, UniqueType.FoundCity, null, false, 6, null) || capturingCiv.isBarbarian()) {
                capturedUnit.capturedBy(capturingCiv);
                return capturedUnit.getCurrentTile().getPosition();
            }
            MapUnit.destroy$default(capturedUnit, false, 1, null);
            capturedUnit.setCiv(capturingCiv);
            v0 = capturingCiv.getGameInfo().getRuleset().getUnits().values();
            Intrinsics.checkNotNullExpressionValue(v0, "capturingCiv.gameInfo.ruleset.units.values");
            var6_3 = v0;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                block6: {
                    it = (BaseUnit)element$iv;
                    $i$a$-firstOrNull-BattleUnitCapture$captureOrConvertToWorker$workerTypeUnit$1 = false;
                    if (!it.isCivilian()) ** GOTO lbl-1000
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    var12_9 = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)it, UniqueType.BuildImprovements, null, 2, null);
                    $i$f$any = false;
                    for (T element$iv : $this$any$iv) {
                        unique = (Unique)element$iv;
                        $i$a$-any-BattleUnitCapture$captureOrConvertToWorker$workerTypeUnit$1$1 = false;
                        if (!Intrinsics.areEqual(unique.getParams().get(0), "Land")) continue;
                        v1 = true;
                        break block6;
                    }
                    v1 = false;
                }
                if (v1) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = element$iv;
                break block7;
            }
            v3 = null;
        }
        v4 = v3;
        if (v4 == null) {
            return null;
        }
        workerTypeUnit = v4;
        var4_16 = capturingCiv.getUnits().placeUnitNearTile(capturedUnit.getCurrentTile().getPosition(), workerTypeUnit, capturedUnit.getId());
        return var4_16 != null && (var5_17 = var4_16.getCurrentTile()) != null ? var5_17.getPosition() : null;
    }
}

