/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city.managers;

import com.badlogic.gdx.math.Vector2;
import com.unciv.GUI;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.CityFlags;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.city.managers.CityConquestFunctions;
import com.unciv.logic.city.managers.SpyFleeReason;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.diplomacy.DiplomacyFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.trade.TradeLogic;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeType;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\nH\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u001a\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/unciv/logic/city/managers/CityConquestFunctions;", "", "city", "Lcom/unciv/logic/city/City;", "(Lcom/unciv/logic/city/City;)V", "getCity", "()Lcom/unciv/logic/city/City;", "tileBasedRandom", "Lkotlin/random/Random;", "annexCity", "", "conquerCity", "conqueringCiv", "Lcom/unciv/logic/civilization/Civilization;", "conqueredCiv", "receivingCiv", "destroyBuildingsOnCapture", "diplomaticRepercussionsForConqueringCity", "oldCiv", "diplomaticRepercussionsForLiberatingCity", "getGoldForCapturingCity", "", "liberateCity", "moveToCiv", "newCiv", "puppetCity", "removeBuildingsOnMoveToCiv", "core"})
@SourceDebugExtension(value={"SMAP\nCityConquestFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityConquestFunctions.kt\ncom/unciv/logic/city/managers/CityConquestFunctions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,314:1\n1774#2,4:315\n223#2,2:320\n819#2:322\n847#2,2:323\n1#3:319\n1295#4,2:325\n*S KotlinDebug\n*F\n+ 1 CityConquestFunctions.kt\ncom/unciv/logic/city/managers/CityConquestFunctions\n*L\n66#1:315,4\n215#1:320,2\n261#1:322\n261#1:323,2\n305#1:325,2\n*E\n"})
public final class CityConquestFunctions {
    @NotNull
    private final City city;
    @NotNull
    private final Random tileBasedRandom;

    public CityConquestFunctions(@NotNull City city2) {
        Intrinsics.checkNotNullParameter(city2, "city");
        this.city = city2;
        this.tileBasedRandom = RandomKt.Random(this.city.getCenterTile().getPosition().toString().hashCode());
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    private final int getGoldForCapturingCity(Civilization conqueringCiv) {
        int baseGold = 20 + 10 * this.city.getPopulation().getPopulation() + this.tileBasedRandom.nextInt(40);
        float turnModifier = (float)Math.max(0, Math.min(50, this.city.getCiv().getGameInfo().getTurns() - this.city.getTurnAcquired())) / 50.0f;
        float cityModifier = City.containsBuildingUnique$default(this.city, UniqueType.DoublesGoldFromCapturingCity, null, 2, null) ? 2.0f : 1.0f;
        float conqueringCivModifier = Civilization.hasUnique$default(conqueringCiv, UniqueType.TripleGoldFromEncampmentsAndCities, null, 2, null) ? 3.0f : 1.0f;
        float goldPlundered = (float)baseGold * turnModifier * cityModifier * conqueringCivModifier;
        return (int)goldPlundered;
    }

    private final void destroyBuildingsOnCapture() {
        Iterator<Building> iterator2 = this.city.getCityConstructions().getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Building building = iterator2.next();
            if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)building, UniqueType.NotDestroyedWhenCityCaptured, null, 2, null) || building.isWonder() || IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)building, UniqueType.IndicatesCapital, null, 2, null)) continue;
            if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)building, UniqueType.DestroyedWhenCityCaptured, null, 2, null)) {
                this.city.getCityConstructions().removeBuilding(building);
                continue;
            }
            if (this.tileBasedRandom.nextInt(100) >= 34) continue;
            this.city.getCityConstructions().removeBuilding(building);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeBuildingsOnMoveToCiv() {
        for (String string : this.city.getCiv().getCivConstructions().getFreeBuildingNames(this.city)) {
            this.city.getCityConstructions().removeBuilding(string);
        }
        this.city.getCityConstructions().getFreeBuildingsProvidedFromThisCity().clear();
        Iterator<Object> iterator2 = this.city.getCityConstructions().getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Building building = (Building)iterator2.next();
            if (building.isNationalWonder() && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)building, UniqueType.NotDestroyedWhenCityCaptured, null, 2, null)) {
                this.city.getCityConstructions().removeBuilding(building);
            }
            Iterator iterator3 = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)building, UniqueType.MaxNumberBuildable, null, 2, null).iterator();
            while (iterator3.hasNext()) {
                int n;
                void $this$count$iv;
                Unique unique = (Unique)iterator3.next();
                Iterable iterable = this.city.getCiv().getCities();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        City it = (City)element$iv;
                        boolean bl = false;
                        boolean bl2 = it.getCityConstructions().containsBuildingOrEquivalent(building.getName()) || it.getCityConstructions().isBeingConstructedOrEnqueued(building.getName());
                        if (!bl2 || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                if (n < Integer.parseInt(unique.getParams().get(0))) continue;
                this.city.getCityConstructions().removeBuilding(building);
            }
        }
    }

    private final void conquerCity(Civilization conqueringCiv, Civilization conqueredCiv, Civilization receivingCiv) {
        this.city.getEspionage().removeAllPresentSpies(SpyFleeReason.CityCaptured);
        int goldPlundered = this.getGoldForCapturingCity(conqueringCiv);
        conqueringCiv.addGold(goldPlundered);
        String[] stringArray = new String[]{"StatIcons/Gold"};
        conqueringCiv.addNotification("Received [" + goldPlundered + "] Gold for capturing [" + this.city.getName() + ']', this.city.getCenterTile().getPosition(), Notification.NotificationCategory.General, stringArray);
        boolean reconqueredCityWhileStillInResistance = Intrinsics.areEqual(this.city.getPreviousOwner(), receivingCiv.getCivName()) && this.city.isInResistance();
        this.destroyBuildingsOnCapture();
        this.city.moveToCiv(receivingCiv);
        Battle.INSTANCE.destroyIfDefeated(conqueredCiv, conqueringCiv, this.city.getLocation());
        this.city.setHealth(this.city.getMaxHealth$core() / 2);
        if (this.city.getPopulation().getPopulation() > 1) {
            this.city.getPopulation().addPopulation(-1 - this.city.getPopulation().getPopulation() / 4);
        }
        this.city.reassignAllPopulation();
        if (!reconqueredCityWhileStillInResistance && !Intrinsics.areEqual(this.city.getFoundingCiv(), receivingCiv.getCivName())) {
            this.city.setFlag(CityFlags.Resistance, this.city.getPopulation().getPopulation());
        } else {
            this.city.removeFlag(CityFlags.Resistance);
        }
    }

    public final void puppetCity(@NotNull Civilization conqueringCiv) {
        Intrinsics.checkNotNullParameter(conqueringCiv, "conqueringCiv");
        Civilization oldCiv = this.city.getCiv();
        this.diplomaticRepercussionsForConqueringCity(oldCiv, conqueringCiv);
        this.conquerCity(conqueringCiv, oldCiv, conqueringCiv);
        this.city.setPuppet(true);
        CityStats.update$default(this.city.getCityStats(), null, false, false, null, 15, null);
        this.city.getCityConstructions().setCurrentConstructionIsUserSet(false);
        this.city.getCityConstructions().getConstructionQueue().clear();
        this.city.getCityConstructions().chooseNextConstruction();
    }

    public final void annexCity() {
        this.city.setPuppet(false);
        this.city.getCityConstructions().getInProgressConstructions().clear();
        if (!this.city.isInResistance()) {
            this.city.setUpdateCitizens(true);
        }
        CityStats.update$default(this.city.getCityStats(), null, false, false, null, 15, null);
        GUI.INSTANCE.setUpdateWorldOnNextRender();
    }

    /*
     * WARNING - void declaration
     */
    private final void diplomaticRepercussionsForConqueringCity(Civilization oldCiv, Civilization conqueringCiv) {
        int n;
        int currentPopulation = this.city.getPopulation().getPopulation();
        Iterable iterable = oldCiv.getCities();
        float f = (float)currentPopulation * 100.0f;
        int n2 = 0;
        for (Object t : iterable) {
            void it;
            City city2 = (City)t;
            n = n2;
            boolean bl = false;
            int n3 = it.getPopulation().getPopulation();
            n2 = n + n3;
        }
        n = n2;
        float percentageOfCivPopulationInThatCity = f / (float)n;
        float aggroGenerated = 10.0f + (float)MathKt.roundToInt(percentageOfCivPopulationInThatCity);
        if (!conqueringCiv.knows(oldCiv)) {
            DiplomacyFunctions.makeCivilizationsMeet$default(conqueringCiv.getDiplomacyFunctions(), oldCiv, false, 2, null);
        }
        DiplomacyManager diplomacyManager = oldCiv.getDiplomacyManager(conqueringCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.addModifier(DiplomaticModifiers.CapturedOurCities, -aggroGenerated);
        Iterator<Civilization> iterator2 = SequencesKt.filter(conqueringCiv.getKnownCivs(), diplomaticRepercussionsForConqueringCity.1.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            Civilization thirdPartyCiv = iterator2.next();
            float aggroGeneratedForOtherCivs = MathKt.roundToInt(aggroGenerated / (float)10);
            if (thirdPartyCiv.isAtWarWith(oldCiv)) {
                DiplomacyManager diplomacyManager2 = thirdPartyCiv.getDiplomacyManager(conqueringCiv);
                Intrinsics.checkNotNull(diplomacyManager2);
                diplomacyManager2.addModifier(DiplomaticModifiers.SharedEnemy, aggroGeneratedForOtherCivs);
                continue;
            }
            DiplomacyManager diplomacyManager3 = thirdPartyCiv.getDiplomacyManager(conqueringCiv);
            Intrinsics.checkNotNull(diplomacyManager3);
            diplomacyManager3.addModifier(DiplomaticModifiers.WarMongerer, -aggroGeneratedForOtherCivs);
        }
    }

    public final void liberateCity(@NotNull Civilization conqueringCiv) {
        Intrinsics.checkNotNullParameter(conqueringCiv, "conqueringCiv");
        if (Intrinsics.areEqual(this.city.getFoundingCiv(), "")) {
            this.puppetCity(conqueringCiv);
            this.annexCity();
            return;
        }
        Civilization foundingCiv = this.city.getCiv().getGameInfo().getCivilization(this.city.getFoundingCiv());
        if (foundingCiv.isDefeated()) {
            for (DiplomacyManager diploManager : foundingCiv.getDiplomacy().values()) {
                if (diploManager.getDiplomaticStatus() != DiplomaticStatus.War) continue;
                diploManager.makePeace();
            }
        }
        Civilization oldCiv = this.city.getCiv();
        this.diplomaticRepercussionsForLiberatingCity(conqueringCiv, oldCiv);
        this.conquerCity(conqueringCiv, oldCiv, foundingCiv);
        if (foundingCiv.getCities().size() == 1) {
            Building capitalCityIndicator2 = this.city.capitalCityIndicator();
            if (capitalCityIndicator2 != null) {
                CityConstructions.addBuilding$default(this.city.getCityConstructions(), capitalCityIndicator2, false, 2, null);
            }
            for (Civilization civ : this.city.getCiv().getGameInfo().getCivilizations()) {
                String[] stringArray;
                if (Intrinsics.areEqual(civ, foundingCiv) || Intrinsics.areEqual(civ, conqueringCiv)) continue;
                if (civ.knows(conqueringCiv) && civ.knows(foundingCiv)) {
                    stringArray = new String[]{foundingCiv.getCivName(), "OtherIcons/Diplomacy", conqueringCiv.getCivName()};
                    civ.addNotification("" + '[' + conqueringCiv + "] has liberated [" + foundingCiv + ']', Notification.NotificationCategory.Diplomacy, stringArray);
                    continue;
                }
                if (civ.knows(conqueringCiv) && !civ.knows(foundingCiv)) {
                    stringArray = new String[]{"OtherIcons/Diplomacy", conqueringCiv.getCivName()};
                    civ.addNotification("" + '[' + conqueringCiv + "] has liberated an unknown civilization", Notification.NotificationCategory.Diplomacy, stringArray);
                    continue;
                }
                if (civ.knows(conqueringCiv) || !civ.knows(foundingCiv)) continue;
                stringArray = new String[]{"OtherIcons/Diplomacy", foundingCiv.getCivName()};
                civ.addNotification("An unknown civilization has liberated [" + foundingCiv + ']', Notification.NotificationCategory.Diplomacy, stringArray);
            }
        }
        this.city.setPuppet(false);
        CityStats.update$default(this.city.getCityStats(), null, false, false, null, 15, null);
        for (MapUnit unit : SequencesKt.toList(this.city.getCenterTile().getUnits())) {
            unit.getMovement().teleportToClosestMoveableTile();
        }
        for (MapUnit unit : SequencesKt.toList(SequencesKt.flatMap(this.city.getTiles(), liberateCity.1.INSTANCE))) {
            if (UnitMovement.canPassThrough$default(unit.getMovement(), unit.getCurrentTile(), false, 2, null)) continue;
            unit.getMovement().teleportToClosestMoveableTile();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void diplomaticRepercussionsForLiberatingCity(Civilization conqueringCiv, Civilization conqueredCiv) {
        int n;
        Object element$iv2;
        block6: {
            Iterable $this$first$iv = conqueredCiv.getGameInfo().getCivilizations();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Civilization it = (Civilization)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getCivName(), this.city.getFoundingCiv())) continue;
                break block6;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Civilization foundingCiv = (Civilization)element$iv2;
        Iterable $i$f$first = foundingCiv.getCities();
        float f = (float)this.city.getPopulation().getPopulation() * 100.0f;
        int n2 = 0;
        for (Civilization it : $i$f$first) {
            void it2;
            City bl = (City)((Object)it);
            n = n2;
            boolean bl2 = false;
            int n3 = it2.getPopulation().getPopulation();
            n2 = n + n3;
        }
        n = n2;
        float percentageOfCivPopulationInThatCity = f / (float)(n + this.city.getPopulation().getPopulation());
        float respectForLiberatingOurCity = 10.0f + (float)MathKt.roundToInt(percentageOfCivPopulationInThatCity);
        if (foundingCiv.isMajorCiv()) {
            foundingCiv.getDiplomacyManagerOrMeet(conqueringCiv).addModifier(DiplomaticModifiers.CapturedOurCities, respectForLiberatingOurCity);
            TradeLogic openBordersTrade = new TradeLogic(foundingCiv, conqueringCiv);
            openBordersTrade.getCurrentTrade().getOurOffers().add(new TradeOffer("Open Borders", TradeType.Agreement, 0, null, 12, null));
            openBordersTrade.acceptTrade(false);
        } else {
            foundingCiv.getDiplomacyManagerOrMeet(conqueringCiv).setInfluence(90.0f);
            if (foundingCiv.isAtWarWith(conqueringCiv)) {
                TradeLogic tradeLogic = new TradeLogic(foundingCiv, conqueringCiv);
                tradeLogic.getCurrentTrade().getOurOffers().add(new TradeOffer("Peace Treaty", TradeType.Treaty, 0, null, 12, null));
                tradeLogic.getCurrentTrade().getTheirOffers().add(new TradeOffer("Peace Treaty", TradeType.Treaty, 0, null, 12, null));
                tradeLogic.acceptTrade(false);
            }
        }
        float otherCivsRespectForLiberating = MathKt.roundToInt(respectForLiberatingOurCity / (float)10);
        Iterator<Object> iterator2 = SequencesKt.filter(conqueringCiv.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(conqueredCiv){
            final /* synthetic */ Civilization $conqueredCiv;
            {
                this.$conqueredCiv = $conqueredCiv;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isMajorCiv() && !Intrinsics.areEqual(it, this.$conqueredCiv);
            }
        }).iterator();
        while (iterator2.hasNext()) {
            Civilization thirdPartyCiv = (Civilization)iterator2.next();
            DiplomacyManager diplomacyManager = thirdPartyCiv.getDiplomacyManager(conqueringCiv);
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.addModifier(DiplomaticModifiers.LiberatedCity, otherCivsRespectForLiberating);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void moveToCiv(@NotNull Civilization newCiv) {
        void $this$filterNotTo$iv$iv;
        void $this$moveToCiv_u24lambda_u245;
        List<City> $this$moveToCiv_u24lambda_u244;
        Intrinsics.checkNotNullParameter(newCiv, "newCiv");
        Civilization oldCiv = this.city.getCiv();
        if (this.city.isCapital()) {
            oldCiv.moveCapitalToNextLargest(this.city);
        }
        Iterator<Building> iterator2 = CollectionsKt.toMutableList((Collection)oldCiv.getCities());
        List<City> list2 = iterator2;
        Civilization civilization = oldCiv;
        boolean bl = false;
        $this$moveToCiv_u24lambda_u244.remove(this.city);
        civilization.setCities((List<City>)((Object)iterator2));
        iterator2 = CollectionsKt.toMutableList((Collection)newCiv.getCities());
        $this$moveToCiv_u24lambda_u244 = iterator2;
        civilization = newCiv;
        boolean bl2 = false;
        $this$moveToCiv_u24lambda_u245.add(this.city);
        civilization.setCities((List<City>)((Object)iterator2));
        this.city.setCiv(newCiv);
        this.city.setHasJustBeenConquered(false);
        this.city.setTurnAcquired(this.city.getCiv().getGameInfo().getTurns());
        this.city.setPreviousOwner(oldCiv.getCivName());
        Iterable $this$filterNot$iv = this.city.getWorkedTiles();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Vector2 it = (Vector2)element$iv$iv;
            boolean bl3 = false;
            if (this.city.getTiles().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Vector2 workedTile : (List)destination$iv$iv) {
            this.city.getPopulation().stopWorkingTile(workedTile);
            this.city.getPopulation().autoAssignPopulation$core();
        }
        this.city.resetWLTKD();
        this.removeBuildingsOnMoveToCiv();
        if (newCiv.getCities().size() == 1) {
            newCiv.moveCapitalTo(this.city, null);
        }
        this.city.getCiv().getCivConstructions().tryAddFreeBuildings();
        this.city.setBeingRazed(false);
        iterator2 = this.city.getCityConstructions().getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Building civEquivalentBuilding;
            Building building = iterator2.next();
            if (Intrinsics.areEqual(building, civEquivalentBuilding = newCiv.getEquivalentBuilding(building))) continue;
            this.city.getCityConstructions().removeBuilding(building);
            CityConstructions.addBuilding$default(this.city.getCityConstructions(), civEquivalentBuilding, false, 2, null);
        }
        if (this.city.getCiv().getGameInfo().isReligionEnabled()) {
            this.city.getReligion().removeUnknownPantheons();
        }
        if (Civilization.hasUnique$default(newCiv, UniqueType.MayNotAnnexCities, null, 2, null)) {
            this.city.setPuppet(true);
            this.city.getCityConstructions().setCurrentConstructionIsUserSet(false);
            this.city.getCityConstructions().getConstructionQueue().clear();
            this.city.getCityConstructions().chooseNextConstruction();
        }
        this.city.tryUpdateRoadStatus$core();
        CityStats.update$default(this.city.getCityStats(), null, false, false, null, 15, null);
        this.city.getCiv().updateProximity(oldCiv, Civilization.updateProximity$default(oldCiv, this.city.getCiv(), null, 2, null));
        Sequence<Tile> $this$forEach$iv = this.city.getTiles();
        boolean $i$f$forEach = false;
        Iterator<Tile> iterator3 = $this$forEach$iv.iterator();
        while (iterator3.hasNext()) {
            Tile element$iv;
            Tile tile = element$iv = iterator3.next();
            boolean bl4 = false;
            tile.getHistory().recordTakeOwnership(tile);
        }
        newCiv.getCache().updateOurTiles();
        oldCiv.getCache().updateOurTiles();
    }
}

