/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city.managers;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.city.City;
import com.unciv.logic.city.managers.CityFounder;
import com.unciv.logic.city.managers.CityPopulationManager;
import com.unciv.logic.city.managers.CityReligionManager;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Proximity;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.managers.ReligionState;
import com.unciv.logic.civilization.transients.CivInfoTransientCache;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J.\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\"\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J \u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/unciv/logic/city/managers/CityFounder;", "", "()V", "addStartingBuildings", "", "city", "Lcom/unciv/logic/city/City;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "startingEra", "", "borrowCityName", "foundingCiv", "aliveCivs", "", "usedCityNames", "foundCity", "cityLocation", "Lcom/badlogic/gdx/math/Vector2;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "generateNewCityName", "triggerCitiesSettledNearOtherCiv", "NamingConstants", "core"})
@SourceDebugExtension(value={"SMAP\nCityFounder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityFounder.kt\ncom/unciv/logic/city/managers/CityFounder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,250:1\n1#2:251\n766#3:252\n857#3,2:253\n179#4,2:255\n*S KotlinDebug\n*F\n+ 1 CityFounder.kt\ncom/unciv/logic/city/managers/CityFounder\n*L\n50#1:252\n50#1:253,2\n150#1:255,2\n*E\n"})
public final class CityFounder {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final City foundCity(@NotNull Civilization civInfo, @NotNull Vector2 cityLocation, @Nullable MapUnit unit) {
        void $this$filterTo$iv$iv;
        void $this$foundCity_u24lambda_u240;
        List<City> list2;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(cityLocation, "cityLocation");
        City city2 = new City();
        city2.setFoundingCiv(civInfo.getCivName());
        city2.setTurnAcquired(civInfo.getGameInfo().getTurns());
        city2.setLocation(cityLocation);
        city2.setTransients(civInfo);
        String string = this.generateNewCityName(civInfo, SequencesKt.toSet(SequencesKt.filter(CollectionsKt.asSequence((Iterable)civInfo.getGameInfo().getCivilizations()), foundCity.1.INSTANCE)));
        if (string == null) {
            string = "City Without A Name";
        }
        city2.setName(string);
        city2.setOriginalCapital(civInfo.getCitiesCreated() == 0);
        if (city2.isOriginalCapital()) {
            civInfo.setHasEverOwnedOriginalCapital(true);
            civInfo.getPolicies().setShouldOpenPolicyPicker(true);
        }
        int n = civInfo.getCitiesCreated();
        civInfo.setCitiesCreated(n + 1);
        List<City> list3 = list2 = CollectionsKt.toMutableList((Collection)civInfo.getCities());
        Civilization civilization = civInfo;
        boolean bl = false;
        $this$foundCity_u24lambda_u240.add(city2);
        civilization.setCities(list2);
        String startingEra = civInfo.getGameInfo().getGameParameters().getStartingEra();
        this.addStartingBuildings(city2, civInfo, startingEra);
        city2.getExpansion().reset();
        city2.tryUpdateRoadStatus$core();
        Tile tile = city2.getCenterTile();
        Iterable $this$filter$iv = tile.getTerrainFeatures();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (!city2.getRuleset().getTileImprovements().containsKey("Remove " + it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (String terrainFeature : (List)destination$iv$iv) {
            tile.removeTerrainFeature(terrainFeature);
        }
        if (civInfo.getGameInfo().getRuleset().getTileImprovements().containsKey("City center")) {
            Tile.setImprovement$default(tile, "City center", civInfo, null, 4, null);
        }
        tile.stopWorkingOnImprovement();
        Ruleset ruleset2 = civInfo.getGameInfo().getRuleset();
        city2.setWorkedTiles(new HashSet<Vector2>());
        CityPopulationManager cityPopulationManager = city2.getPopulation();
        Era era2 = ruleset2.getEras().get(startingEra);
        Intrinsics.checkNotNull(era2);
        cityPopulationManager.setPopulation(era2.getSettlerPopulation());
        if (civInfo.getReligionManager().getReligionState() == ReligionState.Pantheon) {
            CityReligionManager cityReligionManager = city2.getReligion();
            Religion religion = civInfo.getReligionManager().getReligion();
            Intrinsics.checkNotNull(religion);
            CityReligionManager.addPressure$default(cityReligionManager, religion.getName(), 200 * city2.getPopulation().getPopulation(), false, 4, null);
        }
        city2.getPopulation().autoAssignPopulation$core();
        for (Civilization otherCiv : civInfo.getGameInfo().getAliveMajorCivs()) {
            if (civInfo.getProximity(otherCiv) == Proximity.Neighbors) continue;
            civInfo.getCache().updateProximity(otherCiv, CivInfoTransientCache.updateProximity$default(otherCiv.getCache(), civInfo, null, 2, null));
        }
        for (Civilization otherCiv : civInfo.getGameInfo().getAliveCityStates()) {
            if (civInfo.getProximity(otherCiv) == Proximity.Neighbors) continue;
            civInfo.getCache().updateProximity(otherCiv, CivInfoTransientCache.updateProximity$default(otherCiv.getCache(), civInfo, null, 2, null));
        }
        this.triggerCitiesSettledNearOtherCiv(city2);
        civInfo.getGameInfo().getCityDistances().setDirty();
        for (Unique unique : civInfo.getTriggeredUniques(UniqueType.TriggerUponFoundingCity, new StateForConditionals(civInfo, city2, unit, null, null, null, null, null, null, false, 1016, null))) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, civInfo, city2, unit, null, null, "due to founding a city", 48, null);
        }
        if (unit != null) {
            Iterator<Object> iterator2 = unit.getTriggeredUniques(UniqueType.TriggerUponFoundingCity, new StateForConditionals(civInfo, city2, unit, null, null, null, null, null, null, false, 1016, null)).iterator();
            while (iterator2.hasNext()) {
                Unique unique = (Unique)iterator2.next();
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, civInfo, city2, unit, null, null, "due to founding a city", 48, null);
            }
        }
        return city2;
    }

    public static /* synthetic */ City foundCity$default(CityFounder cityFounder, Civilization civilization, Vector2 vector2, MapUnit mapUnit, int n, Object object) {
        if ((n & 4) != 0) {
            mapUnit = null;
        }
        return cityFounder.foundCity(civilization, vector2, mapUnit);
    }

    /*
     * WARNING - void declaration
     */
    private final String generateNewCityName(Civilization foundingCiv, Set<Civilization> aliveCivs) {
        Set<String> usedCityNames2 = SequencesKt.toSet(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)aliveCivs), generateNewCityName.usedCityNames.1.INSTANCE));
        for (String cityName : foundingCiv.getNation().getCities()) {
            if (usedCityNames2.contains(cityName)) continue;
            return cityName;
        }
        if (Civilization.hasUnique$default(foundingCiv, UniqueType.BorrowsCityNames, null, 2, null)) {
            return this.borrowCityName(foundingCiv, aliveCivs, usedCityNames2);
        }
        for (int number = 1; number < 11; ++number) {
            for (String prefix2 : NamingConstants.INSTANCE.getPrefixes()) {
                String candidate2;
                Object v0;
                block5: {
                    void $this$firstOrNull$iv;
                    String repeatedPredix = StringsKt.repeat(prefix2 + " [", number);
                    String suffix = StringsKt.repeat("]", number);
                    Sequence sequence = SequencesKt.map(CollectionsKt.asSequence((Iterable)foundingCiv.getNation().getCities()), (Function1)new Function1<String, String>(repeatedPredix, suffix){
                        final /* synthetic */ String $repeatedPredix;
                        final /* synthetic */ String $suffix;
                        {
                            this.$repeatedPredix = $repeatedPredix;
                            this.$suffix = $suffix;
                            super(1);
                        }

                        @NotNull
                        public final String invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return this.$repeatedPredix + it + this.$suffix;
                        }
                    });
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!(!usedCityNames2.contains(it))) continue;
                        v0 = element$iv;
                        break block5;
                    }
                    v0 = null;
                }
                String string = candidate2 = (String)v0;
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }

    private final String borrowCityName(Civilization foundingCiv, Set<Civilization> aliveCivs, Set<String> usedCityNames2) {
        Sequence<Nation> aliveMajorNations2 = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)aliveCivs), borrowCityName.aliveMajorNations.1.INSTANCE), borrowCityName.aliveMajorNations.2.INSTANCE);
        Sequence otherMajorNations2 = SequencesKt.filter(aliveMajorNations2, (Function1)new Function1<Nation, Boolean>(foundingCiv){
            final /* synthetic */ Civilization $foundingCiv;
            {
                this.$foundingCiv = $foundingCiv;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Nation nation2) {
                Intrinsics.checkNotNullParameter(nation2, "nation");
                return !Intrinsics.areEqual(nation2, this.$foundingCiv.getNation());
            }
        });
        Set newCityNames2 = SequencesKt.toSet(SequencesKt.mapNotNull(otherMajorNations2, (Function1)new Function1<Nation, String>(usedCityNames2){
            final /* synthetic */ Set<String> $usedCityNames;
            {
                this.$usedCityNames = $usedCityNames;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final String invoke(@NotNull Nation nation2) {
                Object v0;
                block1: {
                    void $this$lastOrNull$iv;
                    Intrinsics.checkNotNullParameter(nation2, "nation");
                    List list2 = nation2.getCities();
                    Set<String> set2 = this.$usedCityNames;
                    boolean $i$f$lastOrNull = false;
                    ListIterator<E> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        E element$iv = iterator$iv.previous();
                        String city2 = (String)element$iv;
                        boolean bl = false;
                        if (!(!set2.contains(city2))) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
        }));
        if (!((Collection)newCityNames2).isEmpty()) {
            return (String)CollectionsKt.random(newCityNames2, Random.Default);
        }
        Collection<Nation> collection = foundingCiv.getGameInfo().getRuleset().getNations().values();
        Intrinsics.checkNotNullExpressionValue(collection, "foundingCiv.gameInfo.ruleset.nations.values");
        Sequence absentMajorNations2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), (Function1)new Function1<Nation, Boolean>(aliveMajorNations2){
            final /* synthetic */ Sequence<Nation> $aliveMajorNations;
            {
                this.$aliveMajorNations = $aliveMajorNations;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Nation nation2) {
                Intrinsics.checkNotNullParameter(nation2, "nation");
                return nation2.isMajorCiv() && !SequencesKt.contains(this.$aliveMajorNations, nation2);
            }
        });
        newCityNames2 = SequencesKt.toSet(SequencesKt.flatMap(absentMajorNations2, (Function1)new Function1<Nation, Sequence<? extends String>>(usedCityNames2){
            final /* synthetic */ Set<String> $usedCityNames;
            {
                this.$usedCityNames = $usedCityNames;
                super(1);
            }

            @NotNull
            public final Sequence<String> invoke(@NotNull Nation nation2) {
                Intrinsics.checkNotNullParameter(nation2, "nation");
                return SequencesKt.filter(CollectionsKt.asSequence((Iterable)nation2.getCities()), (Function1)new Function1<String, Boolean>(this.$usedCityNames){
                    final /* synthetic */ Set<String> $usedCityNames;
                    {
                        this.$usedCityNames = $usedCityNames;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull String city2) {
                        Intrinsics.checkNotNullParameter(city2, "city");
                        return !this.$usedCityNames.contains(city2);
                    }
                });
            }
        }));
        if (!((Collection)newCityNames2).isEmpty()) {
            return (String)CollectionsKt.random(newCityNames2, Random.Default);
        }
        return null;
    }

    private final void addStartingBuildings(City city2, Civilization civInfo, String startingEra) {
        Building capitalCityIndicator2;
        Ruleset ruleset2 = civInfo.getGameInfo().getRuleset();
        if (civInfo.getCities().size() == 1 && (capitalCityIndicator2 = city2.capitalCityIndicator()) != null) {
            city2.getCityConstructions().addBuilding(capitalCityIndicator2, false);
        }
        Era era2 = ruleset2.getEras().get(startingEra);
        Intrinsics.checkNotNull(era2);
        for (String buildingName : era2.getSettlerBuildings()) {
            Building building;
            Building uniqueBuilding;
            if (ruleset2.getBuildings().get(buildingName) == null || !(uniqueBuilding = civInfo.getEquivalentBuilding(building)).isBuildable(city2.getCityConstructions())) continue;
            city2.getCityConstructions().addBuilding(uniqueBuilding, false);
        }
        civInfo.getCivConstructions().tryAddFreeBuildings();
    }

    private final void triggerCitiesSettledNearOtherCiv(City city2) {
        Sequence citiesWithin6Tiles2 = SequencesKt.filter(SequencesKt.flatMapIterable(SequencesKt.filter(CollectionsKt.asSequence((Iterable)city2.getCiv().getGameInfo().getCivilizations()), (Function1)new Function1<Civilization, Boolean>(city2){
            final /* synthetic */ City $city;
            {
                this.$city = $city;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isMajorCiv() && !Intrinsics.areEqual(it, this.$city.getCiv());
            }
        }), triggerCitiesSettledNearOtherCiv.citiesWithin6Tiles.2.INSTANCE), (Function1)new Function1<City, Boolean>(city2){
            final /* synthetic */ City $city;
            {
                this.$city = $city;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull City it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getCenterTile().aerialDistanceTo(this.$city.getCenterTile()) <= 6;
            }
        });
        Sequence civsWithCloseCities2 = SequencesKt.filter(SequencesKt.distinct(SequencesKt.map(citiesWithin6Tiles2, triggerCitiesSettledNearOtherCiv.civsWithCloseCities.1.INSTANCE)), (Function1)new Function1<Civilization, Boolean>(city2){
            final /* synthetic */ City $city;
            {
                this.$city = $city;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.knows(this.$city.getCiv()) && it.hasExplored(this.$city.getCenterTile());
            }
        });
        Iterator iterator2 = civsWithCloseCities2.iterator();
        while (iterator2.hasNext()) {
            Civilization otherCiv = (Civilization)iterator2.next();
            DiplomacyManager diplomacyManager = otherCiv.getDiplomacyManager(city2.getCiv());
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.setFlag(DiplomacyFlags.SettledCitiesNearUs, 30);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0006j\b\u0012\u0004\u0012\u00020\u0004`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/unciv/logic/city/managers/CityFounder$NamingConstants;", "", "()V", "fallback", "", "prefixes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getPrefixes", "()Ljava/util/ArrayList;", "core"})
    private static final class NamingConstants {
        @NotNull
        public static final NamingConstants INSTANCE = new NamingConstants();
        @NotNull
        private static final ArrayList<String> prefixes;
        @NotNull
        public static final String fallback = "City Without A Name";

        private NamingConstants() {
        }

        @NotNull
        public final ArrayList<String> getPrefixes() {
            return prefixes;
        }

        static {
            String[] stringArray = new String[]{"New", "Neo", "Nova", "Altera"};
            prefixes = CollectionsKt.arrayListOf(stringArray);
        }
    }
}

