/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/unciv/logic/civilization/CityAction;", "Lcom/unciv/logic/civilization/NotificationAction;", "city", "Lcom/badlogic/gdx/math/Vector2;", "(Lcom/badlogic/gdx/math/Vector2;)V", "execute", "", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "Companion", "core"})
public final class CityAction
implements NotificationAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vector2 city;

    public CityAction(@NotNull Vector2 city2) {
        Intrinsics.checkNotNullParameter(city2, "city");
        this.city = city2;
    }

    public /* synthetic */ CityAction(Vector2 vector2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Vector2 vector22 = Vector2.Zero;
            Intrinsics.checkNotNullExpressionValue(vector22, "Zero");
            vector2 = vector22;
        }
        this(vector2);
    }

    @Override
    public void execute(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        City city2 = worldScreen.getMapHolder().getTileMap$core().get(this.city).getCity();
        if (city2 == null) {
            return;
        }
        City cityObject = city2;
        if (Intrinsics.areEqual(cityObject.getCiv(), worldScreen.getViewingCiv())) {
            worldScreen.getGame().pushScreen(new CityScreen(cityObject, null, null, null, 14, null));
        }
    }

    public CityAction() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/logic/civilization/CityAction$Companion;", "", "()V", "withLocation", "", "Lcom/unciv/logic/civilization/NotificationAction;", "city", "Lcom/unciv/logic/city/City;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<NotificationAction> withLocation(@NotNull City city2) {
            Intrinsics.checkNotNullParameter(city2, "city");
            NotificationAction[] notificationActionArray = new NotificationAction[]{new LocationAction(city2.getLocation()), new CityAction(city2.getLocation())};
            return CollectionsKt.listOf(notificationActionArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

