/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.MapParameters;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bJ\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u001b\u001a\u00020\u0000J\u0006\u0010\u001c\u001a\u00020\u000bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u000bJ\u000e\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bJ\u0006\u0010\"\u001a\u00020\tJ\u0006\u0010#\u001a\u00020\u000bJ\u0006\u0010$\u001a\u00020\u000bJ\u0006\u0010%\u001a\u00020\u001eJ\u000e\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0004J\u000e\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*J\u0006\u0010\r\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/unciv/logic/civilization/ExploredRegion;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "()V", "bottomRight", "Lcom/badlogic/gdx/math/Vector2;", "bottomRightStage", "evenMapWidth", "", "exploredRectangle", "Lcom/badlogic/gdx/math/Rectangle;", "mapRadius", "", "rectangularMap", "shouldRecalculateCoords", "shouldRestrictX", "shouldUpdateMinimap", "tileRadius", "topLeft", "topLeftStage", "worldWrap", "calculateStageCoords", "", "mapMaxX", "mapMaxY", "checkTilePosition", "tilePosition", "explorerPosition", "clone", "getBottomY", "getHeight", "", "getLeftX", "getMinimapLeft", "tileSize", "getRectangle", "getRightX", "getTopY", "getWidth", "isPositionInRegion", "postition", "setMapParameters", "mapParameters", "Lcom/unciv/logic/map/MapParameters;", "core"})
public final class ExploredRegion
implements IsPartOfGameInfoSerialization {
    private transient boolean worldWrap;
    private transient boolean evenMapWidth;
    private transient boolean rectangularMap;
    private transient float mapRadius;
    private final transient float tileRadius;
    private transient boolean shouldRecalculateCoords = true;
    private transient boolean shouldUpdateMinimap = true;
    @NotNull
    private final transient Rectangle exploredRectangle = new Rectangle();
    private transient boolean shouldRestrictX;
    @NotNull
    private transient Vector2 topLeftStage = new Vector2();
    @NotNull
    private transient Vector2 bottomRightStage = new Vector2();
    @NotNull
    private Vector2 topLeft = new Vector2();
    @NotNull
    private Vector2 bottomRight = new Vector2();

    public ExploredRegion() {
        this.tileRadius = 40.0f;
    }

    public final boolean shouldRecalculateCoords() {
        return this.shouldRecalculateCoords;
    }

    public final boolean shouldUpdateMinimap() {
        return this.shouldUpdateMinimap;
    }

    @NotNull
    public final Rectangle getRectangle() {
        return this.exploredRectangle;
    }

    public final boolean shouldRestrictX() {
        return this.shouldRestrictX;
    }

    public final float getLeftX() {
        return this.topLeftStage.x;
    }

    public final float getRightX() {
        return this.bottomRightStage.x;
    }

    public final float getTopY() {
        return this.topLeftStage.y;
    }

    public final float getBottomY() {
        return this.bottomRightStage.y;
    }

    @NotNull
    public final ExploredRegion clone() {
        ExploredRegion toReturn = new ExploredRegion();
        toReturn.topLeft = this.topLeft;
        toReturn.bottomRight = this.bottomRight;
        return toReturn;
    }

    public final void setMapParameters(@NotNull MapParameters mapParameters) {
        Intrinsics.checkNotNullParameter(mapParameters, "mapParameters");
        this.evenMapWidth = this.worldWrap = mapParameters.getWorldWrap();
        if (Intrinsics.areEqual(mapParameters.getShape(), "Rectangular")) {
            this.mapRadius = mapParameters.getMapSize().getWidth() / 2;
            this.evenMapWidth = mapParameters.getMapSize().getWidth() % 2 == 0 || this.evenMapWidth;
            this.rectangularMap = true;
        } else {
            this.mapRadius = mapParameters.getMapSize().getRadius();
        }
    }

    public final void checkTilePosition(@NotNull Vector2 tilePosition, @Nullable Vector2 explorerPosition) {
        Intrinsics.checkNotNullParameter(tilePosition, "tilePosition");
        boolean mapExplored = false;
        float longitude = HexMath.INSTANCE.getLongitude(tilePosition);
        float latitude = HexMath.INSTANCE.getLatitude(tilePosition);
        if (Intrinsics.areEqual(this.topLeft, Vector2.Zero) && Intrinsics.areEqual(this.bottomRight, Vector2.Zero)) {
            this.topLeft = new Vector2(longitude, latitude);
            this.bottomRight = new Vector2(longitude, latitude);
            return;
        }
        if (this.topLeft.x >= this.bottomRight.x) {
            if (longitude > this.topLeft.x) {
                if (this.worldWrap && longitude == this.mapRadius) {
                    longitude = this.mapRadius * -1.0f;
                }
                this.topLeft.x = longitude;
                mapExplored = true;
            } else if (longitude < this.bottomRight.x) {
                if (this.worldWrap && longitude == this.mapRadius * -1.0f + 1.0f) {
                    longitude = this.mapRadius + 1.0f;
                }
                this.bottomRight.x = longitude;
                mapExplored = true;
            }
        } else if (longitude < this.bottomRight.x && longitude > this.topLeft.x) {
            float rightSideDistance = 0.0f;
            float leftSideDistance = 0.0f;
            if (explorerPosition != null) {
                float explorerLongitude = HexMath.INSTANCE.getLongitude(explorerPosition);
                rightSideDistance = explorerLongitude < 0.0f && this.bottomRight.x > 0.0f ? this.mapRadius * 2.0f + explorerLongitude - this.bottomRight.x : Math.abs(explorerLongitude - this.bottomRight.x);
                leftSideDistance = explorerLongitude > 0.0f && this.topLeft.x < 0.0f ? this.mapRadius * 2.0f - explorerLongitude + this.topLeft.x : Math.abs(this.topLeft.x - explorerLongitude);
            } else {
                rightSideDistance = this.bottomRight.x - longitude;
                leftSideDistance = longitude - this.topLeft.x;
            }
            if (rightSideDistance > leftSideDistance) {
                this.topLeft.x = longitude;
            } else {
                this.bottomRight.x = longitude;
            }
            mapExplored = true;
        }
        if (latitude > this.topLeft.y) {
            this.topLeft.y = latitude;
            mapExplored = true;
        } else if (latitude < this.bottomRight.y) {
            this.bottomRight.y = latitude;
            mapExplored = true;
        }
        if (mapExplored) {
            this.shouldRecalculateCoords = true;
            this.shouldUpdateMinimap = true;
        }
    }

    public final void calculateStageCoords(float mapMaxX, float mapMaxY) {
        this.shouldRecalculateCoords = false;
        this.shouldRestrictX = !(this.bottomRight.x - this.topLeft.x == 1.0f);
        Vector2 topLeftWorld = HexMath.INSTANCE.worldFromLatLong(this.topLeft, this.tileRadius);
        Vector2 bottomRightWorld = HexMath.INSTANCE.worldFromLatLong(this.bottomRight, this.tileRadius);
        float mapCenterX = this.evenMapWidth ? (mapMaxX + 50.0f + 4.0f) * 0.5f : mapMaxX * 0.5f;
        float left = mapCenterX + topLeftWorld.x;
        float right = mapCenterX + bottomRightWorld.x;
        if (left > mapMaxX) {
            left = 10.0f;
        }
        if (right < 0.0f) {
            right = mapMaxX - 10.0f;
        }
        float mapCenterY = this.rectangularMap ? mapMaxY * 0.5f + 12.5f : mapMaxY * 0.5f;
        float top = mapCenterY - topLeftWorld.y;
        float bottom = mapCenterY - bottomRightWorld.y;
        this.topLeftStage = new Vector2(left, top);
        this.bottomRightStage = new Vector2(right, bottom);
        float yOffset = this.tileRadius * (float)Math.sqrt(3.0f) * 0.5f;
        this.exploredRectangle.x = left - this.tileRadius;
        this.exploredRectangle.y = mapMaxY - bottom - yOffset * 0.5f;
        this.exploredRectangle.width = (float)this.getWidth() * this.tileRadius * 1.5f;
        this.exploredRectangle.height = (float)this.getHeight() * yOffset;
    }

    public final boolean isPositionInRegion(@NotNull Vector2 postition) {
        Intrinsics.checkNotNullParameter(postition, "postition");
        float f = HexMath.INSTANCE.getLongitude(postition);
        float lat = HexMath.INSTANCE.getLatitude(postition);
        return this.topLeft.x > this.bottomRight.x ? f <= this.topLeft.x && f >= this.bottomRight.x && lat <= this.topLeft.y && lat >= this.bottomRight.y : (f >= this.topLeft.x && f >= this.bottomRight.x || f <= this.topLeft.x && f <= this.bottomRight.x) && lat <= this.topLeft.y && lat >= this.bottomRight.y;
    }

    public final int getWidth() {
        float result2 = 0.0f;
        result2 = this.topLeft.x > this.bottomRight.x ? this.topLeft.x - this.bottomRight.x : this.mapRadius * 2.0f - (this.bottomRight.x - this.topLeft.x);
        return (int)result2 + 1;
    }

    public final int getHeight() {
        return (int)(this.topLeft.y - this.bottomRight.y) + 1;
    }

    public final float getMinimapLeft(float tileSize) {
        this.shouldUpdateMinimap = false;
        return (this.topLeft.x + 1.0f) * tileSize * -0.75f;
    }
}

