/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.diplomacy;

import com.badlogic.gdx.math.Vector2;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\b\b\u0002\u0010\u0012\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\bJ\u001a\u0010\u001a\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/unciv/logic/civilization/diplomacy/DiplomacyFunctions;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/logic/civilization/Civilization;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "canPassThroughTiles", "", "otherCiv", "canSignDeclarationOfFriendshipWith", "canSignDefensivePact", "canSignDefensivePactWith", "canSignResearchAgreement", "canSignResearchAgreementNoCostWith", "canSignResearchAgreementsWith", "getKnownCivsSorted", "Lkotlin/sequences/Sequence;", "includeCityStates", "includeDefeated", "getResearchAgreementCost", "", "isAtWarWith", "makeCivilizationsMeet", "", "warOnContact", "meetCiv", "core"})
@SourceDebugExtension(value={"SMAP\nDiplomacyFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiplomacyFunctions.kt\ncom/unciv/logic/civilization/diplomacy/DiplomacyFunctions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1#2:167\n204#3,4:168\n2624#4,3:172\n*S KotlinDebug\n*F\n+ 1 DiplomacyFunctions.kt\ncom/unciv/logic/civilization/diplomacy/DiplomacyFunctions\n*L\n52#1:168,4\n100#1:172,3\n*E\n"})
public final class DiplomacyFunctions {
    @NotNull
    private final Civilization civInfo;

    public DiplomacyFunctions(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    @NotNull
    public final Sequence<Civilization> getKnownCivsSorted(boolean includeCityStates, boolean includeDefeated) {
        return GameInfo.getCivsSorted$default(this.civInfo.getGameInfo(), includeCityStates, includeDefeated, null, new Function1<Civilization, Boolean>(this){
            final /* synthetic */ DiplomacyFunctions this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !Intrinsics.areEqual(it, this.this$0.getCivInfo()) && this.this$0.getCivInfo().knows(it);
            }
        }, 4, null);
    }

    public static /* synthetic */ Sequence getKnownCivsSorted$default(DiplomacyFunctions diplomacyFunctions, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return diplomacyFunctions.getKnownCivsSorted(bl, bl2);
    }

    public final void makeCivilizationsMeet(@NotNull Civilization otherCiv, boolean warOnContact) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        this.meetCiv(otherCiv, warOnContact);
        otherCiv.getDiplomacyFunctions().meetCiv(this.civInfo, warOnContact);
    }

    public static /* synthetic */ void makeCivilizationsMeet$default(DiplomacyFunctions diplomacyFunctions, Civilization civilization, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        diplomacyFunctions.makeCivilizationsMeet(civilization, bl);
    }

    private final void meetCiv(Civilization otherCiv, boolean warOnContact) {
        DiplomacyManager diplomacyManager;
        Map map2 = this.civInfo.getDiplomacy();
        String string = otherCiv.getCivName();
        DiplomacyManager $this$meetCiv_u24lambda_u240 = diplomacyManager = new DiplomacyManager(this.civInfo, otherCiv.getCivName());
        boolean bl = false;
        $this$meetCiv_u24lambda_u240.setDiplomaticStatus(DiplomaticStatus.Peace);
        map2.put(string, diplomacyManager);
        if (!otherCiv.isSpectator()) {
            otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.FirstContact, this.civInfo.getCivName()));
        }
        if (this.civInfo.isCurrentPlayer()) {
            UncivGame.Companion.getCurrent().getSettings().addCompletedTutorialTask("Meet another civilization");
        }
        if (this.civInfo.isCityState() && otherCiv.isMajorCiv()) {
            IsPartOfGameInfoSerialization isPartOfGameInfoSerialization;
            Object object;
            int n;
            Vector2 vector2;
            if (warOnContact || otherCiv.isMinorCivAggressor()) {
                return;
            }
            if (this.civInfo.getCities().isEmpty()) {
                vector2 = null;
            } else {
                City city2 = Civilization.getCapital$default(this.civInfo, false, 1, null);
                Intrinsics.checkNotNull(city2);
                vector2 = city2.getLocation();
            }
            Vector2 cityStateLocation = vector2;
            Stats giftAmount = new Stats(0.0f, 0.0f, 15.0f, 0.0f, 0.0f, 0.0f, 0.0f, 123, null);
            Stats faithAmount = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 4.0f, 63, null);
            String meetString = '[' + this.civInfo.getCivName() + "] has given us [" + giftAmount + "] as a token of goodwill for meeting us";
            String religionMeetString = '[' + this.civInfo.getCivName() + "] has also given us [" + faithAmount + ']';
            Map $this$count$iv = this.civInfo.getDiplomacy();
            boolean $i$f$count = false;
            if ($this$count$iv.isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                Iterator iterator2 = $this$count$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!((DiplomacyManager)it.getValue()).otherCiv().isMajorCiv()) continue;
                    ++count$iv;
                }
                n = count$iv;
            }
            if (n == 1) {
                giftAmount.timesInPlace(2.0f);
                meetString = '[' + this.civInfo.getCivName() + "] has given us [" + giftAmount + "] as we are the first major civ to meet them";
            }
            if (cityStateLocation != null) {
                object = new String[]{"StatIcons/Gold"};
                otherCiv.addNotification(meetString, cityStateLocation, Notification.NotificationCategory.Diplomacy, (String[])object);
            } else {
                object = new String[]{"StatIcons/Gold"};
                otherCiv.addNotification(meetString, Notification.NotificationCategory.Diplomacy, (String[])object);
            }
            if (otherCiv.isCityState() && otherCiv.getCityStateFunctions().canProvideStat(Stat.Faith)) {
                object = new String[]{"StatIcons/Faith"};
                otherCiv.addNotification(religionMeetString, Notification.NotificationCategory.Diplomacy, (String[])object);
                for (Stats.StatValuePair statValuePair : faithAmount) {
                    Stat key = statValuePair.component1();
                    float value = statValuePair.component2();
                    otherCiv.addStat(key, (int)value);
                }
            }
            for (Stats.StatValuePair statValuePair : giftAmount) {
                Stat key = statValuePair.component1();
                float value = statValuePair.component2();
                otherCiv.addStat(key, (int)value);
            }
            if (!((Collection)this.civInfo.getCities()).isEmpty() && (isPartOfGameInfoSerialization = Civilization.getCapital$default(this.civInfo, false, 1, null)) != null && (isPartOfGameInfoSerialization = isPartOfGameInfoSerialization.getCenterTile()) != null) {
                Tile.setExplored$default((Tile)isPartOfGameInfoSerialization, otherCiv, true, null, 4, null);
            }
            this.civInfo.getQuestManager().justMet(otherCiv);
        }
    }

    static /* synthetic */ void meetCiv$default(DiplomacyFunctions diplomacyFunctions, Civilization civilization, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        diplomacyFunctions.meetCiv(civilization, bl);
    }

    public final boolean isAtWarWith(@NotNull Civilization otherCiv) {
        boolean bl;
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (Intrinsics.areEqual(otherCiv, this.civInfo)) {
            bl = false;
        } else if (otherCiv.isBarbarian() || this.civInfo.isBarbarian()) {
            bl = true;
        } else {
            DiplomacyManager diplomacyManager = this.civInfo.getDiplomacy().get(otherCiv.getCivName());
            if (diplomacyManager == null) {
                return false;
            }
            DiplomacyManager diplomacyManager2 = diplomacyManager;
            return diplomacyManager2.getDiplomaticStatus() == DiplomaticStatus.War;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canSignDeclarationOfFriendshipWith(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!otherCiv.isMajorCiv()) return false;
        if (otherCiv.isAtWarWith(this.civInfo)) return false;
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        if (diplomacyManager.hasFlag(DiplomacyFlags.Denunciation)) return false;
        DiplomacyManager diplomacyManager2 = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager2);
        if (diplomacyManager2.hasFlag(DiplomacyFlags.DeclarationOfFriendship)) return false;
        return true;
    }

    public final boolean canSignResearchAgreement() {
        boolean bl;
        block5: {
            if (!this.civInfo.isMajorCiv()) {
                return false;
            }
            if (!Civilization.hasUnique$default(this.civInfo, UniqueType.EnablesResearchAgreements, null, 2, null)) {
                return false;
            }
            Collection<Technology> collection = this.civInfo.getGameInfo().getRuleset().getTechnologies().values();
            Intrinsics.checkNotNullExpressionValue(collection, "civInfo.gameInfo.ruleset.technologies.values");
            Iterable $this$none$iv = collection;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Technology it = (Technology)element$iv;
                    boolean bl2 = false;
                    if (!(this.civInfo.getTech().canBeResearched(it.getName()) && !this.civInfo.getTech().isResearched(it.getName()))) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return !bl;
    }

    public final boolean canSignResearchAgreementNoCostWith(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacyManager2 = diplomacyManager;
        return this.canSignResearchAgreement() && otherCiv.getDiplomacyFunctions().canSignResearchAgreement() && diplomacyManager2.hasFlag(DiplomacyFlags.DeclarationOfFriendship) && !diplomacyManager2.hasFlag(DiplomacyFlags.ResearchAgreement) && !diplomacyManager2.otherCivDiplomacy().hasFlag(DiplomacyFlags.ResearchAgreement);
    }

    public final boolean canSignResearchAgreementsWith(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        int cost = this.getResearchAgreementCost(otherCiv);
        return this.canSignResearchAgreementNoCostWith(otherCiv) && this.civInfo.getGold() >= cost && otherCiv.getGold() >= cost;
    }

    public final int getResearchAgreementCost(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        return (int)((float)Math.max(this.civInfo.getEra().getResearchAgreementCost(), otherCiv.getEra().getResearchAgreementCost()) * this.civInfo.getGameInfo().getSpeed().getGoldCostModifier());
    }

    public final boolean canSignDefensivePact() {
        if (!this.civInfo.isMajorCiv()) {
            return false;
        }
        return Civilization.hasUnique$default(this.civInfo, UniqueType.EnablesDefensivePacts, null, 2, null);
    }

    public final boolean canSignDefensivePactWith(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacyManager2 = diplomacyManager;
        return this.canSignDefensivePact() && otherCiv.getDiplomacyFunctions().canSignDefensivePact() && (diplomacyManager2.hasFlag(DiplomacyFlags.DeclarationOfFriendship) || diplomacyManager2.otherCivDiplomacy().hasFlag(DiplomacyFlags.DeclarationOfFriendship)) && !diplomacyManager2.hasFlag(DiplomacyFlags.DefensivePact) && !diplomacyManager2.otherCivDiplomacy().hasFlag(DiplomacyFlags.DefensivePact) && diplomacyManager2.getDiplomaticStatus() != DiplomaticStatus.DefensivePact;
    }

    public final boolean canPassThroughTiles(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (Intrinsics.areEqual(otherCiv, this.civInfo)) {
            return true;
        }
        if (otherCiv.isBarbarian()) {
            return true;
        }
        if (this.civInfo.isBarbarian() && this.civInfo.getGameInfo().getTurns() >= this.civInfo.getGameInfo().getDifficultyObject().getTurnBarbariansCanEnterPlayerTiles()) {
            return true;
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacy().get(otherCiv.getCivName());
        if (diplomacyManager != null && (diplomacyManager.getHasOpenBorders() || diplomacyManager.getDiplomaticStatus() == DiplomaticStatus.War)) {
            return true;
        }
        return !this.civInfo.isAIOrAutoPlaying() && otherCiv.isCityState();
    }
}

