/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.badlogic.gdx.math.Vector2;
import com.unciv.GUI;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.Quest;
import com.unciv.models.ruleset.QuestName;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.screens.worldscreen.WorldMapHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u0007J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u0007J\u0006\u0010\"\u001a\u00020\u001cJ\u0006\u0010#\u001a\u00020\u001cJ\u0006\u0010$\u001a\u00020\u001cJ\u0006\u0010%\u001a\u00020&J!\u0010'\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u001aH\u0000\u00a2\u0006\u0002\b)R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/unciv/logic/civilization/managers/AssignedQuest;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "questName", "", "assigner", "assignee", "assignedOnTurn", "", "data1", "data2", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getAssignedOnTurn", "()I", "getAssignee", "()Ljava/lang/String;", "getAssigner", "getData1", "getData2", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getQuestName", "questNameInstance", "Lcom/unciv/models/ruleset/QuestName;", "getQuestNameInstance", "()Lcom/unciv/models/ruleset/QuestName;", "questObject", "Lcom/unciv/models/ruleset/Quest;", "doesExpire", "", "getDescription", "getDuration", "getInfluence", "", "getRemainingTurns", "isExpired", "isGlobal", "isIndividual", "onClickAction", "", "setTransients", "quest", "setTransients$core", "core"})
public final class AssignedQuest
implements IsPartOfGameInfoSerialization {
    @NotNull
    private final String questName;
    @NotNull
    private final String assigner;
    @NotNull
    private final String assignee;
    private final int assignedOnTurn;
    @NotNull
    private final String data1;
    @NotNull
    private final String data2;
    private transient GameInfo gameInfo;
    private transient Quest questObject;

    public AssignedQuest(@NotNull String questName, @NotNull String assigner, @NotNull String assignee, int assignedOnTurn, @NotNull String data1, @NotNull String data2) {
        Intrinsics.checkNotNullParameter(questName, "questName");
        Intrinsics.checkNotNullParameter(assigner, "assigner");
        Intrinsics.checkNotNullParameter(assignee, "assignee");
        Intrinsics.checkNotNullParameter(data1, "data1");
        Intrinsics.checkNotNullParameter(data2, "data2");
        this.questName = questName;
        this.assigner = assigner;
        this.assignee = assignee;
        this.assignedOnTurn = assignedOnTurn;
        this.data1 = data1;
        this.data2 = data2;
    }

    public /* synthetic */ AssignedQuest(String string, String string2, String string3, int n, String string4, String string5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "";
        }
        if ((n2 & 0x20) != 0) {
            string5 = "";
        }
        this(string, string2, string3, n, string4, string5);
    }

    @NotNull
    public final String getQuestName() {
        return this.questName;
    }

    @NotNull
    public final String getAssigner() {
        return this.assigner;
    }

    @NotNull
    public final String getAssignee() {
        return this.assignee;
    }

    public final int getAssignedOnTurn() {
        return this.assignedOnTurn;
    }

    @NotNull
    public final String getData1() {
        return this.data1;
    }

    @NotNull
    public final String getData2() {
        return this.data2;
    }

    @NotNull
    public final QuestName getQuestNameInstance() {
        Quest quest2 = this.questObject;
        if (quest2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("questObject");
            quest2 = null;
        }
        return quest2.getQuestNameInstance();
    }

    public final void setTransients$core(@NotNull GameInfo gameInfo2, @Nullable Quest quest2) {
        Intrinsics.checkNotNullParameter(gameInfo2, "gameInfo");
        this.gameInfo = gameInfo2;
        Quest quest3 = quest2;
        if (quest3 == null) {
            Quest quest4 = gameInfo2.getRuleset().getQuests().get(this.questName);
            Intrinsics.checkNotNull(quest4);
            quest3 = quest4;
        }
        this.questObject = quest3;
    }

    public static /* synthetic */ void setTransients$core$default(AssignedQuest assignedQuest, GameInfo gameInfo2, Quest quest2, int n, Object object) {
        if ((n & 2) != 0) {
            quest2 = null;
        }
        assignedQuest.setTransients$core(gameInfo2, quest2);
    }

    public final boolean isIndividual() {
        return !this.isGlobal();
    }

    public final boolean isGlobal() {
        Quest quest2 = this.questObject;
        if (quest2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("questObject");
            quest2 = null;
        }
        return quest2.isGlobal();
    }

    public final boolean doesExpire() {
        Quest quest2 = this.questObject;
        if (quest2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("questObject");
            quest2 = null;
        }
        return quest2.getDuration() > 0;
    }

    public final boolean isExpired() {
        return this.doesExpire() && this.getRemainingTurns() == 0;
    }

    public final int getDuration() {
        GameInfo gameInfo2 = this.gameInfo;
        if (gameInfo2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gameInfo");
            gameInfo2 = null;
        }
        float f = gameInfo2.getSpeed().getModifier();
        Quest quest2 = this.questObject;
        if (quest2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("questObject");
            quest2 = null;
        }
        return (int)(f * (float)quest2.getDuration());
    }

    public final int getRemainingTurns() {
        int n = this.assignedOnTurn + this.getDuration();
        GameInfo gameInfo2 = this.gameInfo;
        if (gameInfo2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gameInfo");
            gameInfo2 = null;
        }
        return RangesKt.coerceAtLeast(n - gameInfo2.getTurns(), 0);
    }

    public final float getInfluence() {
        Quest quest2 = this.questObject;
        if (quest2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("questObject");
            quest2 = null;
        }
        return quest2.getInfluence();
    }

    @NotNull
    public final String getDescription() {
        Quest quest2 = this.questObject;
        if (quest2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("questObject");
            quest2 = null;
        }
        String[] stringArray = new String[]{this.data1};
        return TranslationsKt.fillPlaceholders(quest2.getDescription(), stringArray);
    }

    public final void onClickAction() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getQuestNameInstance().ordinal()]) {
            case 1: {
                GUI.INSTANCE.resetToWorldScreen();
                WorldMapHolder.setCenterPosition$default(GUI.INSTANCE.getMap(), new Vector2(Float.parseFloat(this.data1), Float.parseFloat(this.data2)), false, false, null, 10, null);
                break;
            }
            case 2: {
                GUI.INSTANCE.resetToWorldScreen();
                WorldMapHolder worldMapHolder = GUI.INSTANCE.getMap();
                GameInfo gameInfo2 = this.gameInfo;
                if (gameInfo2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("gameInfo");
                    gameInfo2 = null;
                }
                City city2 = Civilization.getCapital$default(gameInfo2.getCivilization(this.assigner), false, 1, null);
                Intrinsics.checkNotNull(city2);
                WorldMapHolder.setCenterPosition$default(worldMapHolder, city2.getLocation(), false, false, null, 10, null);
                break;
            }
        }
    }

    public AssignedQuest() {
        this(null, null, null, 0, null, null, 63, null);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QuestName.values().length];
            try {
                nArray[QuestName.ClearBarbarianCamp.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.Route.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

