/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.EspionageManager;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Spy;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001d\u001a\u00020\u0017J\u0006\u0010\u001e\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020 J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170\"J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170\"2\u0006\u0010&\u001a\u00020#J\u0010\u0010'\u001a\u0004\u0018\u00010\u00172\u0006\u0010&\u001a\u00020#J\u0006\u0010(\u001a\u00020\u0011J\u0006\u0010)\u001a\u00020*J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110,2\u0006\u0010-\u001a\u00020\u0004J\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/J\u0006\u00101\u001a\u00020\nJ\u0006\u00102\u001a\u00020 J\u000e\u00103\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u00104\u001a\u00020\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R*\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00065"}, d2={"Lcom/unciv/logic/civilization/managers/EspionageManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "()V", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "setCivInfo", "(Lcom/unciv/logic/civilization/Civilization;)V", "dismissedShouldMoveSpies", "", "getDismissedShouldMoveSpies", "()Z", "setDismissedShouldMoveSpies", "(Z)V", "erasSpyEarnedFor", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "getErasSpyEarnedFor", "()Ljava/util/LinkedHashSet;", "spyList", "Ljava/util/ArrayList;", "Lcom/unciv/models/Spy;", "Lkotlin/collections/ArrayList;", "getSpyList", "()Ljava/util/ArrayList;", "setSpyList", "(Ljava/util/ArrayList;)V", "addSpy", "clone", "endTurn", "", "getCitiesWithOurSpies", "", "Lcom/unciv/logic/city/City;", "getIdleSpies", "getSpiesInCity", "city", "getSpyAssignedToCity", "getSpyName", "getStartingSpyRank", "", "getTechsToSteal", "", "otherCiv", "getTilesVisibleViaSpies", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/map/tile/Tile;", "hasIdleSpies", "removeAllSpies", "setTransients", "shouldShowMoveSpies", "core"})
@SourceDebugExtension(value={"SMAP\nEspionageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EspionageManager.kt\ncom/unciv/logic/civilization/managers/EspionageManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1620#2,3:114\n1549#2:117\n1620#2,3:118\n766#2:121\n857#2,2:122\n857#2,2:124\n766#2:127\n857#2,2:128\n1603#2,9:130\n1855#2:139\n1856#2:141\n1612#2:142\n288#2,2:143\n1747#2,3:145\n857#2,2:148\n1855#2,2:150\n1#3:126\n1#3:140\n*S KotlinDebug\n*F\n+ 1 EspionageManager.kt\ncom/unciv/logic/civilization/managers/EspionageManager\n*L\n28#1:114,3\n46#1:117\n46#1:118,3\n47#1:121\n47#1:122,2\n78#1:124,2\n87#1:127\n87#1:128,2\n87#1:130,9\n87#1:139\n87#1:141\n87#1:142\n89#1:143,2\n99#1:145,3\n102#1:148,2\n110#1:150,2\n87#1:140\n*E\n"})
public final class EspionageManager
implements IsPartOfGameInfoSerialization {
    @NotNull
    private ArrayList<Spy> spyList = new ArrayList();
    @NotNull
    private final LinkedHashSet<String> erasSpyEarnedFor = new LinkedHashSet();
    public transient Civilization civInfo;
    private transient boolean dismissedShouldMoveSpies;

    @NotNull
    public final ArrayList<Spy> getSpyList() {
        return this.spyList;
    }

    public final void setSpyList(@NotNull ArrayList<Spy> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.spyList = arrayList;
    }

    @NotNull
    public final LinkedHashSet<String> getErasSpyEarnedFor() {
        return this.erasSpyEarnedFor;
    }

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public final void setCivInfo(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.civInfo = civilization;
    }

    public final boolean getDismissedShouldMoveSpies() {
        return this.dismissedShouldMoveSpies;
    }

    public final void setDismissedShouldMoveSpies(boolean bl) {
        this.dismissedShouldMoveSpies = bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final EspionageManager clone() {
        void $this$mapTo$iv;
        EspionageManager toReturn = new EspionageManager();
        Iterable iterable = this.spyList;
        Collection destination$iv = toReturn.spyList;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Spy spy = (Spy)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.clone());
        }
        toReturn.erasSpyEarnedFor.addAll((Collection<String>)this.erasSpyEarnedFor);
        return toReturn;
    }

    public final void setTransients(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.setCivInfo(civInfo);
        for (Spy spy : this.spyList) {
            spy.setTransients(civInfo);
        }
    }

    public final void endTurn() {
        for (Spy spy : CollectionsKt.toList((Iterable)this.spyList)) {
            spy.endTurn();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getSpyName() {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.spyList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Spy spy = (Spy)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        HashSet usedSpyNames = CollectionsKt.toHashSet((List)destination$iv$iv);
        Iterable $this$filter$iv = this.getCivInfo().getNation().getSpyNames();
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!usedSpyNames.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List validSpyNames = (List)destination$iv$iv2;
        String string = (String)CollectionsKt.randomOrNull(validSpyNames, Random.Default);
        if (string == null) {
            string = "Spy " + (this.spyList.size() + 1);
        }
        return string;
    }

    @NotNull
    public final Spy addSpy() {
        String spyName = this.getSpyName();
        Spy newSpy = new Spy(spyName, this.getStartingSpyRank());
        newSpy.setTransients(this.getCivInfo());
        this.spyList.add(newSpy);
        return newSpy;
    }

    @NotNull
    public final Sequence<Tile> getTilesVisibleViaSpies() {
        return SequencesKt.flatMap(SequencesKt.mapNotNull(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.spyList), getTilesVisibleViaSpies.1.INSTANCE), getTilesVisibleViaSpies.2.INSTANCE), getTilesVisibleViaSpies.3.INSTANCE);
    }

    @NotNull
    public final Set<String> getTechsToSteal(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        Set techsToSteal = new LinkedHashSet();
        for (String tech : otherCiv.getTech().getTechsResearched()) {
            TechManager techManager = this.getCivInfo().getTech();
            Intrinsics.checkNotNullExpressionValue(tech, "tech");
            if (techManager.isResearched(tech) || !this.getCivInfo().getTech().canBeResearched(tech)) continue;
            techsToSteal.add(tech);
        }
        return techsToSteal;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Spy> getSpiesInCity(@NotNull City city2) {
        void var3_3;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(city2, "city");
        Iterable iterable = this.spyList;
        Collection destination$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            Spy it = (Spy)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getCityOrNull(), city2)) continue;
            destination$iv.add(element$iv);
        }
        return (List)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final int getStartingSpyRank() {
        int n;
        Sequence sequence = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.SpyStartingLevel, null, 2, null);
        int n2 = 1;
        int n3 = 0;
        Iterator iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object t = iterator2.next();
            Unique unique = (Unique)t;
            n = n3;
            boolean bl = false;
            int n4 = Integer.parseInt(it.getParams().get(0));
            n3 = n + n4;
        }
        n = n3;
        return n2 + n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<City> getCitiesWithOurSpies() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.spyList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Spy it = (Spy)element$iv$iv;
            boolean bl = false;
            if (!it.isSetUp()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            City it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Spy it = (Spy)element$iv$iv;
            boolean bl2 = false;
            if (it.getCityOrNull() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final Spy getSpyAssignedToCity(@NotNull City city2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(city2, "city");
            Iterable $this$firstOrNull$iv = this.spyList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Spy it = (Spy)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getCityOrNull(), city2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean shouldShowMoveSpies() {
        return !this.dismissedShouldMoveSpies && this.hasIdleSpies();
    }

    public final boolean hasIdleSpies() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.spyList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Spy it = (Spy)element$iv;
                    boolean bl2 = false;
                    if (!it.isIdle()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Spy> getIdleSpies() {
        void var2_2;
        void $this$filterTo$iv;
        Iterable iterable = this.spyList;
        Collection destination$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            Spy it = (Spy)element$iv;
            boolean bl = false;
            if (!it.isIdle()) continue;
            destination$iv.add(element$iv);
        }
        return (List)var2_2;
    }

    public final void removeAllSpies() {
        Iterable $this$forEach$iv = this.spyList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Spy it = (Spy)element$iv;
            boolean bl = false;
            it.moveTo(null);
        }
    }
}

