/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.CivilopediaAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nJ\u0010\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\u0014\u001a\u00020\nJ\u0006\u0010\u001a\u001a\u00020\nJ\u0006\u0010\u001b\u001a\u00020\u001cR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/unciv/logic/civilization/managers/GoldenAgeManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "()V", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "setCivInfo", "(Lcom/unciv/logic/civilization/Civilization;)V", "numberOfGoldenAges", "", "storedHappiness", "getStoredHappiness", "()I", "setStoredHappiness", "(I)V", "turnsLeftForCurrentGoldenAge", "getTurnsLeftForCurrentGoldenAge", "setTurnsLeftForCurrentGoldenAge", "calculateGoldenAgeLength", "unmodifiedNumberOfTurns", "clone", "endTurn", "", "happiness", "enterGoldenAge", "happinessRequiredForNextGoldenAge", "isGoldenAge", "", "core"})
public final class GoldenAgeManager
implements IsPartOfGameInfoSerialization {
    public transient Civilization civInfo;
    private int storedHappiness;
    private int numberOfGoldenAges;
    private int turnsLeftForCurrentGoldenAge;

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public final void setCivInfo(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.civInfo = civilization;
    }

    public final int getStoredHappiness() {
        return this.storedHappiness;
    }

    public final void setStoredHappiness(int n) {
        this.storedHappiness = n;
    }

    public final int getTurnsLeftForCurrentGoldenAge() {
        return this.turnsLeftForCurrentGoldenAge;
    }

    public final void setTurnsLeftForCurrentGoldenAge(int n) {
        this.turnsLeftForCurrentGoldenAge = n;
    }

    @NotNull
    public final GoldenAgeManager clone() {
        GoldenAgeManager toReturn = new GoldenAgeManager();
        toReturn.numberOfGoldenAges = this.numberOfGoldenAges;
        toReturn.storedHappiness = this.storedHappiness;
        toReturn.turnsLeftForCurrentGoldenAge = this.turnsLeftForCurrentGoldenAge;
        return toReturn;
    }

    public final boolean isGoldenAge() {
        return this.turnsLeftForCurrentGoldenAge > 0;
    }

    public final int happinessRequiredForNextGoldenAge() {
        float cost = 500 + this.numberOfGoldenAges * 250;
        cost *= FormattingExtensionsKt.toPercent(this.getCivInfo().getCities().size());
        return (int)(cost *= this.getCivInfo().getGameInfo().getSpeed().getModifier());
    }

    public final int calculateGoldenAgeLength(int unmodifiedNumberOfTurns) {
        float turnsToGoldenAge = unmodifiedNumberOfTurns;
        Iterator iterator2 = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.GoldenAgeLength, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            turnsToGoldenAge *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return (int)(turnsToGoldenAge *= this.getCivInfo().getGameInfo().getSpeed().getGoldenAgeLengthModifier());
    }

    public final void enterGoldenAge(int unmodifiedNumberOfTurns) {
        this.turnsLeftForCurrentGoldenAge += this.calculateGoldenAgeLength(unmodifiedNumberOfTurns);
        String[] stringArray = new String[]{"StatIcons/Happiness"};
        this.getCivInfo().addNotification("You have entered a Golden Age!", new CivilopediaAction("Tutorial/Golden Age"), Notification.NotificationCategory.General, stringArray);
        this.getCivInfo().getPopupAlerts().add(new PopupAlert(AlertType.GoldenAge, ""));
        for (Unique unique : Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponEnteringGoldenAge, null, 2, null)) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, null, 124, null);
        }
        for (City city2 : this.getCivInfo().getCities()) {
            CityStats.update$default(city2.getCityStats(), null, false, false, null, 15, null);
        }
    }

    public static /* synthetic */ void enterGoldenAge$default(GoldenAgeManager goldenAgeManager, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        goldenAgeManager.enterGoldenAge(n);
    }

    public final void endTurn(int happiness) {
        if (!this.isGoldenAge()) {
            this.storedHappiness = RangesKt.coerceAtLeast(this.storedHappiness + happiness, 0);
        }
        if (this.isGoldenAge()) {
            int n = this.turnsLeftForCurrentGoldenAge;
            this.turnsLeftForCurrentGoldenAge = n + -1;
        } else if (this.storedHappiness > this.happinessRequiredForNextGoldenAge()) {
            this.storedHappiness -= this.happinessRequiredForNextGoldenAge();
            GoldenAgeManager.enterGoldenAge$default(this, 0, 1, null);
            int n = this.numberOfGoldenAges;
            this.numberOfGoldenAges = n + 1;
        }
    }
}

