/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0010J\u0010\u00109\u001a\u0002072\u0006\u00108\u001a\u00020\u0010H\u0002J\u0010\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020<H\u0002J\u0018\u0010=\u001a\u0002072\u0006\u0010;\u001a\u00020<2\b\b\u0002\u0010>\u001a\u00020.J\u000e\u0010?\u001a\u00020.2\u0006\u0010@\u001a\u00020.J\u0006\u0010A\u001a\u00020.J\u0006\u0010B\u001a\u00020\u0000J\u000e\u0010C\u001a\u0002072\u0006\u00108\u001a\u00020\u0010J\u0016\u0010D\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bJ\u0006\u0010E\u001a\u00020\u0010J\u0006\u0010F\u001a\u00020\u0010J(\u0010G\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020<0I2\u0006\u0010J\u001a\u00020\u0010J\u001b\u0010K\u001a\u0004\u0018\u00010\u00102\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010MJ\u000e\u0010N\u001a\u00020<2\u0006\u0010O\u001a\u00020\nJ\u000e\u0010P\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0010J$\u0010Q\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020<0Rj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020<`SH\u0002J\u0018\u0010T\u001a\u00020.2\u0006\u0010;\u001a\u00020<2\b\b\u0002\u0010@\u001a\u00020.J\u000e\u0010U\u001a\u00020.2\u0006\u0010V\u001a\u00020\nJ\"\u0010W\u001a\u0002072\u0006\u0010;\u001a\u00020<2\b\b\u0002\u0010>\u001a\u00020.2\b\b\u0002\u0010X\u001a\u00020.J\u0010\u0010Y\u001a\u0002072\u0006\u0010;\u001a\u00020<H\u0002J\u000e\u0010Z\u001a\u0002072\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010[\u001a\u00020.J\u001a\u0010\\\u001a\u0002072\u0006\u0010;\u001a\u00020<2\b\b\u0002\u0010]\u001a\u00020\nH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R$\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0007R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0007R\u000e\u0010&\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020(X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001d\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000f8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0012R\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010!\"\u0004\b5\u0010#\u00a8\u0006^"}, d2={"Lcom/unciv/logic/civilization/managers/PolicyManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "()V", "adoptableBranches", "", "Lcom/unciv/models/ruleset/PolicyBranch;", "getAdoptableBranches", "()Ljava/util/Set;", "adoptedPolicies", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getAdoptedPolicies$core", "()Ljava/util/HashSet;", "branchCompletionMap", "", "", "getBranchCompletionMap", "()Ljava/util/Map;", "branches", "getBranches", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "setCivInfo", "(Lcom/unciv/logic/civilization/Civilization;)V", "completedBranches", "getCompletedBranches", "cultureOfLast8Turns", "", "freePolicies", "getFreePolicies", "()I", "setFreePolicies", "(I)V", "incompleteBranches", "getIncompleteBranches", "numberOfAdoptedPolicies", "policyUniques", "Lcom/unciv/models/ruleset/unique/UniqueMap;", "getPolicyUniques$core", "()Lcom/unciv/models/ruleset/unique/UniqueMap;", "priorityMap", "getPriorityMap", "shouldOpenPolicyPicker", "", "getShouldOpenPolicyPicker", "()Z", "setShouldOpenPolicyPicker", "(Z)V", "storedCulture", "getStoredCulture", "setStoredCulture", "addCulture", "", "culture", "addCurrentCultureToCultureOfLast8Turns", "addPolicyToTransients", "policy", "Lcom/unciv/models/ruleset/Policy;", "adopt", "branchCompletion", "allPoliciesAdopted", "checkEra", "canAdoptPolicy", "clone", "endTurn", "getAdoptedPolicies", "getCultureFromGreatWriter", "getCultureNeededForNextPolicy", "getCultureRefundMap", "policiesToRemove", "", "refundPercentage", "getMaxPriority", "branchesToCompare", "(Ljava/util/Set;)Ljava/lang/Integer;", "getPolicyByName", "name", "getPolicyCultureCost", "getRulesetPolicies", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "isAdoptable", "isAdopted", "policyName", "removePolicy", "assumeWasFree", "removePolicyFromTransients", "setTransients", "shouldShowPolicyPicker", "triggerGlobalAlerts", "extraNotificationText", "core"})
@SourceDebugExtension(value={"SMAP\nPolicyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolicyManager.kt\ncom/unciv/logic/civilization/managers/PolicyManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,324:1\n766#2:325\n857#2,2:326\n1747#2,3:328\n1726#2,3:331\n1774#2,4:334\n1774#2,4:338\n1747#2,3:344\n1774#2,4:347\n1747#2,3:351\n1774#2,4:354\n766#2:365\n857#2,2:366\n2624#2,3:368\n1229#3,2:342\n467#4,7:358\n*S KotlinDebug\n*F\n+ 1 PolicyManager.kt\ncom/unciv/logic/civilization/managers/PolicyManager\n*L\n55#1:325\n55#1:326,2\n61#1:328,3\n70#1:331,3\n79#1:334,4\n160#1:338,4\n197#1:344,3\n219#1:347,4\n236#1:351,3\n271#1:354,4\n297#1:365\n297#1:366,2\n322#1:368,3\n187#1:342,2\n290#1:358,7\n*E\n"})
public final class PolicyManager
implements IsPartOfGameInfoSerialization {
    public transient Civilization civInfo;
    @NotNull
    private final transient UniqueMap policyUniques = new UniqueMap();
    private int freePolicies;
    private int storedCulture;
    @NotNull
    private final HashSet<String> adoptedPolicies = new HashSet();
    private int numberOfAdoptedPolicies;
    @NotNull
    private int[] cultureOfLast8Turns;
    private boolean shouldOpenPolicyPicker;

    public PolicyManager() {
        int n = 0;
        int[] nArray = new int[8];
        PolicyManager policyManager = this;
        while (n < 8) {
            int n2 = n++;
            nArray[n2] = 0;
        }
        policyManager.cultureOfLast8Turns = nArray;
    }

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public final void setCivInfo(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "<set-?>");
        this.civInfo = civilization;
    }

    @NotNull
    public final UniqueMap getPolicyUniques$core() {
        return this.policyUniques;
    }

    public final int getFreePolicies() {
        return this.freePolicies;
    }

    public final void setFreePolicies(int n) {
        this.freePolicies = n;
    }

    public final int getStoredCulture() {
        return this.storedCulture;
    }

    public final void setStoredCulture(int n) {
        this.storedCulture = n;
    }

    @NotNull
    public final HashSet<String> getAdoptedPolicies$core() {
        return this.adoptedPolicies;
    }

    public final boolean getShouldOpenPolicyPicker() {
        return this.shouldOpenPolicyPicker;
    }

    public final void setShouldOpenPolicyPicker(boolean bl) {
        this.shouldOpenPolicyPicker = bl;
    }

    public final boolean shouldShowPolicyPicker() {
        return (this.shouldOpenPolicyPicker || this.freePolicies > 0) && this.canAdoptPolicy();
    }

    @NotNull
    public final Map<PolicyBranch, Integer> getPriorityMap() {
        HashMap value = new HashMap();
        for (PolicyBranch branch : this.getBranches()) {
            Integer n = branch.getPriorities().get(this.getCivInfo().getNation().getPreferredVictoryType());
            if (n == null) {
                n = 0;
            }
            int victoryPriority = ((Number)n).intValue();
            Integer n2 = this.getCivInfo().getPersonality().getPriorities().get(branch.getName());
            if (n2 == null) {
                n2 = 0;
            }
            int personalityPriority = ((Number)n2).intValue();
            ((Map)value).put(branch, victoryPriority + personalityPriority);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<PolicyBranch> getAdoptableBranches() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getBranches();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PolicyBranch it = (PolicyBranch)element$iv$iv;
            boolean bl = false;
            if (!PolicyManager.isAdoptable$default(this, it, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    @NotNull
    public final Set<PolicyBranch> getIncompleteBranches() {
        HashSet<PolicyBranch> value = new HashSet<PolicyBranch>();
        for (PolicyBranch branch : this.getBranches()) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = branch.getPolicies();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Policy it = (Policy)element$iv;
                        boolean bl2 = false;
                        if (!PolicyManager.isAdoptable$default(this, it, false, 2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            value.add(branch);
        }
        return value;
    }

    @NotNull
    public final Set<PolicyBranch> getCompletedBranches() {
        HashSet<PolicyBranch> value = new HashSet<PolicyBranch>();
        for (PolicyBranch branch : this.getBranches()) {
            boolean bl;
            block4: {
                Iterable $this$all$iv = branch.getPolicies();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Policy it = (Policy)element$iv;
                        boolean bl2 = false;
                        if (this.isAdopted(it.getName())) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            value.add(branch);
        }
        return value;
    }

    @NotNull
    public final Map<PolicyBranch, Integer> getBranchCompletionMap() {
        HashMap value = new HashMap();
        for (PolicyBranch branch : this.getBranches()) {
            int n;
            Map map2 = value;
            Iterable $this$count$iv = this.adoptedPolicies;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!branch.getPolicies().contains(this.getPolicyByName(it)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            Integer n2 = n;
            map2.put(branch, n2);
        }
        return value;
    }

    @NotNull
    public final Set<PolicyBranch> getBranches() {
        Collection<PolicyBranch> collection = this.getCivInfo().getGameInfo().getRuleset().getPolicyBranches().values();
        Intrinsics.checkNotNullExpressionValue(collection, "civInfo.gameInfo.ruleset.policyBranches.values");
        return CollectionsKt.toSet((Iterable)collection);
    }

    @NotNull
    public final PolicyManager clone() {
        PolicyManager toReturn = new PolicyManager();
        toReturn.numberOfAdoptedPolicies = this.numberOfAdoptedPolicies;
        toReturn.adoptedPolicies.addAll((Collection<String>)this.adoptedPolicies);
        toReturn.freePolicies = this.freePolicies;
        toReturn.shouldOpenPolicyPicker = this.shouldOpenPolicyPicker;
        toReturn.storedCulture = this.storedCulture;
        toReturn.cultureOfLast8Turns = (int[])this.cultureOfLast8Turns.clone();
        return toReturn;
    }

    private final LinkedHashMap<String, Policy> getRulesetPolicies() {
        return this.getCivInfo().getGameInfo().getRuleset().getPolicies();
    }

    @NotNull
    public final Policy getPolicyByName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Policy policy2 = this.getRulesetPolicies().get(name2);
        Intrinsics.checkNotNull(policy2);
        return policy2;
    }

    public final void setTransients(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.setCivInfo(civInfo);
        for (String policyName : this.adoptedPolicies) {
            Intrinsics.checkNotNullExpressionValue(policyName, "policyName");
            this.addPolicyToTransients(this.getPolicyByName(policyName));
        }
    }

    private final void addPolicyToTransients(Policy policy2) {
        for (Unique unique : policy2.getUniqueObjects()) {
            this.policyUniques.addUnique(unique);
        }
    }

    private final void removePolicyFromTransients(Policy policy2) {
        for (Unique unique : policy2.getUniqueObjects()) {
            this.policyUniques.removeUnique(unique);
        }
    }

    public final void addCulture(int culture) {
        boolean couldAdoptPolicyBefore = this.canAdoptPolicy();
        this.storedCulture += culture;
        if (!couldAdoptPolicyBefore && this.canAdoptPolicy()) {
            this.shouldOpenPolicyPicker = true;
        }
    }

    public final void endTurn(int culture) {
        this.addCulture(culture);
        this.addCurrentCultureToCultureOfLast8Turns(culture);
    }

    public final int getCultureNeededForNextPolicy() {
        return this.getPolicyCultureCost(this.numberOfAdoptedPolicies);
    }

    @NotNull
    public final Map<Policy, Integer> getCultureRefundMap(@NotNull List<? extends Policy> policiesToRemove, int refundPercentage) {
        Intrinsics.checkNotNullParameter(policiesToRemove, "policiesToRemove");
        int policyCostInput = this.numberOfAdoptedPolicies;
        Map policyMap = new LinkedHashMap();
        for (Policy policy2 : policiesToRemove) {
            policyMap.put(policy2, MathKt.roundToInt((float)(this.getPolicyCultureCost(--policyCostInput) * refundPercentage) / 100.0f));
        }
        return MapsKt.toMap(policyMap);
    }

    public final int getPolicyCultureCost(int numberOfAdoptedPolicies) {
        int n;
        Iterator $this$count$iv;
        double policyCultureCost = (double)25 + Math.pow(numberOfAdoptedPolicies * 6, 1.7);
        float worldSizeModifier = this.getCivInfo().getGameInfo().getTileMap().getMapParameters().getMapSize().getPredefinedOrNextSmaller().getPolicyCostPerCityModifier();
        Iterable iterable = this.getCivInfo().getCities();
        float f = worldSizeModifier;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)((Object)$this$count$iv)).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            Iterator iterator2 = $this$count$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                City it = (City)element$iv;
                boolean bl = false;
                if (!(!it.isPuppet()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n2 = n;
        float cityModifier = f * (float)(n2 - 1);
        $this$count$iv = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.LessPolicyCostFromCities, null, 2, null).iterator();
        while ($this$count$iv.hasNext()) {
            Unique unique = (Unique)$this$count$iv.next();
            cityModifier *= 1.0f - Float.parseFloat(unique.getParams().get(0)) / (float)100;
        }
        $this$count$iv = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.LessPolicyCost, null, 2, null).iterator();
        while ($this$count$iv.hasNext()) {
            Unique unique = (Unique)$this$count$iv.next();
            policyCultureCost *= (double)FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        if (this.getCivInfo().isHuman()) {
            policyCultureCost *= (double)this.getCivInfo().getDifficulty().getPolicyCostModifier();
        }
        int cost = MathKt.roundToInt((policyCultureCost *= (double)this.getCivInfo().getGameInfo().getSpeed().getCultureCostModifier()) * (double)(1.0f + cityModifier));
        return cost - cost % 5;
    }

    @NotNull
    public final HashSet<String> getAdoptedPolicies() {
        return this.adoptedPolicies;
    }

    public final boolean isAdopted(@NotNull String policyName) {
        Intrinsics.checkNotNullParameter(policyName, "policyName");
        return this.adoptedPolicies.contains(policyName);
    }

    public final boolean isAdoptable(@NotNull Policy policy2, boolean checkEra) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter(policy2, "policy");
            if (this.isAdopted(policy2.getName())) {
                return false;
            }
            if (policy2.getPolicyBranchType() == Policy.PolicyBranchType.BranchComplete) {
                return false;
            }
            HashSet<String> hashSet = this.getAdoptedPolicies();
            ArrayList<String> arrayList = policy2.getRequires();
            Intrinsics.checkNotNull(arrayList);
            if (!hashSet.containsAll((Collection)arrayList)) {
                return false;
            }
            if (checkEra) {
                Era era2 = this.getCivInfo().getGameInfo().getRuleset().getEras().get(policy2.getBranch().getEra());
                Intrinsics.checkNotNull(era2);
                if (era2.getEraNumber() > this.getCivInfo().getEraNumber()) {
                    return false;
                }
            }
            Sequence<Unique> $this$any$iv = policy2.getMatchingUniques(UniqueType.OnlyAvailable, StateForConditionals.Companion.getIgnoreConditionals());
            boolean $i$f$any = false;
            Iterator<Unique> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Unique element$iv;
                Unique it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(!Unique.conditionalsApply$default(it, this.getCivInfo(), null, 2, null))) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            return false;
        }
        return !policy2.hasUnique(UniqueType.Unavailable, new StateForConditionals(this.getCivInfo(), null, null, null, null, null, null, null, null, false, 1022, null));
    }

    public static /* synthetic */ boolean isAdoptable$default(PolicyManager policyManager, Policy policy2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return policyManager.isAdoptable(policy2, bl);
    }

    public final boolean canAdoptPolicy() {
        boolean bl;
        block5: {
            if (this.getCivInfo().isSpectator()) {
                return false;
            }
            if (this.freePolicies == 0 && this.storedCulture < this.getCultureNeededForNextPolicy()) {
                return false;
            }
            Collection<Policy> collection = this.getRulesetPolicies().values();
            Intrinsics.checkNotNullExpressionValue(collection, "getRulesetPolicies().values");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Policy it = (Policy)element$iv;
                    boolean bl2 = false;
                    PolicyManager policyManager = this.getCivInfo().getPolicies();
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    if (!PolicyManager.isAdoptable$default(policyManager, it, false, 2, null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void adopt(@NotNull Policy policy2, boolean branchCompletion) {
        Intrinsics.checkNotNullParameter(policy2, "policy");
        if (!branchCompletion) {
            if (this.freePolicies > 0) {
                int n = this.freePolicies;
                this.freePolicies = n + -1;
            } else if (!this.getCivInfo().getGameInfo().getGameParameters().getGodMode()) {
                int cultureNeededForNextPolicy = this.getCultureNeededForNextPolicy();
                if (cultureNeededForNextPolicy > this.storedCulture) {
                    throw new Exception("Trying to adopt a policy without enough culture????");
                }
                this.storedCulture -= cultureNeededForNextPolicy;
                int n = this.numberOfAdoptedPolicies;
                this.numberOfAdoptedPolicies = n + 1;
            }
        }
        this.adoptedPolicies.add(policy2.getName());
        this.addPolicyToTransients(policy2);
        if (!branchCompletion) {
            int n;
            PolicyBranch branch = policy2.getBranch();
            Iterable $this$count$iv = branch.getPolicies();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Policy it = (Policy)element$iv;
                    boolean bl = false;
                    if (!this.isAdopted(it.getName()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n == branch.getPolicies().size() - 1) {
                this.adopt((Policy)CollectionsKt.last((List)branch.getPolicies()), true);
            }
        }
        Iterator branch = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)policy2, UniqueType.OneTimeGlobalAlert, null, 2, null).iterator();
        while (branch.hasNext()) {
            Unique unique = (Unique)branch.next();
            this.triggerGlobalAlerts(policy2, unique.getParams().get(0));
        }
        String triggerNotificationText = "due to adopting [" + policy2.getName() + ']';
        for (Unique unique : policy2.getUniqueObjects()) {
            if (unique.hasTriggerConditional() || !unique.conditionalsApply(new StateForConditionals(this.getCivInfo(), null, null, null, null, null, null, null, null, false, 1022, null))) continue;
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, triggerNotificationText, 60, null);
        }
        for (Unique unique : Civilization.getTriggeredUniques$default(this.getCivInfo(), UniqueType.TriggerUponAdoptingPolicyOrBelief, null, 2, null)) {
            boolean bl;
            block18: {
                Iterable $this$any$iv = unique.getConditionals();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Unique it = (Unique)element$iv;
                        boolean bl2 = false;
                        if (!(it.getType() == UniqueType.TriggerUponAdoptingPolicyOrBelief && Intrinsics.areEqual(it.getParams().get(0), policy2.getName()))) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCivInfo(), null, null, null, null, triggerNotificationText, 60, null);
        }
        this.getCivInfo().getCache().updateCivResources();
        for (City city2 : this.getCivInfo().getCities()) {
            CityStats.update$default(city2.getCityStats(), null, false, false, null, 15, null);
            city2.reassignPopulationDeferred();
        }
        if (!this.canAdoptPolicy()) {
            this.shouldOpenPolicyPicker = false;
        }
    }

    public static /* synthetic */ void adopt$default(PolicyManager policyManager, Policy policy2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        policyManager.adopt(policy2, bl);
    }

    public final void removePolicy(@NotNull Policy policy2, boolean branchCompletion, boolean assumeWasFree) {
        Intrinsics.checkNotNullParameter(policy2, "policy");
        if (!this.adoptedPolicies.remove(policy2.getName())) {
            throw new IllegalStateException("Attempt to remove non-adopted Policy " + policy2.getName());
        }
        if (!assumeWasFree) {
            this.numberOfAdoptedPolicies += -1;
            if (this.numberOfAdoptedPolicies < 0) {
                throw new IllegalStateException("Attempt to remove Policy " + policy2.getName() + " but civ only has free policies left");
            }
        }
        this.removePolicyFromTransients(policy2);
        if (!branchCompletion) {
            int n;
            PolicyBranch branch = policy2.getBranch();
            Iterable $this$count$iv = branch.getPolicies();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Policy it = (Policy)element$iv;
                    boolean bl = false;
                    if (!this.isAdopted(it.getName()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n == branch.getPolicies().size() - 1) {
                PolicyManager.removePolicy$default(this, (Policy)CollectionsKt.last((List)branch.getPolicies()), true, false, 4, null);
            }
        }
        this.getCivInfo().getCache().updateCivResources();
        for (City city2 : this.getCivInfo().getCities()) {
            CityStats.update$default(city2.getCityStats(), null, false, false, null, 15, null);
            city2.reassignPopulationDeferred();
        }
    }

    public static /* synthetic */ void removePolicy$default(PolicyManager policyManager, Policy policy2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        policyManager.removePolicy(policy2, bl, bl2);
    }

    @Nullable
    public final Integer getMaxPriority(@NotNull Set<PolicyBranch> branchesToCompare) {
        Intrinsics.checkNotNullParameter(branchesToCompare, "branchesToCompare");
        Map<PolicyBranch, Integer> $this$filterKeys$iv = this.getPriorityMap();
        boolean $i$f$filterKeys = false;
        LinkedHashMap<PolicyBranch, Integer> result$iv = new LinkedHashMap<PolicyBranch, Integer>();
        for (Map.Entry<PolicyBranch, Integer> entry$iv : $this$filterKeys$iv.entrySet()) {
            PolicyBranch branch = entry$iv.getKey();
            boolean bl = false;
            if (!branchesToCompare.contains(branch)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map filteredMap = result$iv;
        return (Integer)CollectionsKt.maxOrNull(filteredMap.values());
    }

    /*
     * WARNING - void declaration
     */
    private final void triggerGlobalAlerts(Policy policy2, String extraNotificationText) {
        void $this$filterTo$iv$iv;
        String[] $this$filter$iv = (String[])this.getCivInfo().getGameInfo().getCivilizations();
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!it.isMajorCiv()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Civilization civ : (List)destination$iv$iv) {
            if (Intrinsics.areEqual(civ, this.getCivInfo())) continue;
            String defaultNotificationText = SequencesKt.contains(civ.getKnownCivs(), this.getCivInfo()) ? '[' + this.getCivInfo().getCivName() + "] has adopted the [" + policy2.getName() + "] policy" : "An unknown civilization has adopted the [" + policy2.getName() + "] policy";
            stringArray = new String[]{"StatIcons/Culture"};
            civ.addNotification('{' + defaultNotificationText + "} {" + extraNotificationText + '}', Notification.NotificationCategory.General, stringArray);
        }
    }

    static /* synthetic */ void triggerGlobalAlerts$default(PolicyManager policyManager, Policy policy2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        policyManager.triggerGlobalAlerts(policy2, string);
    }

    public final int getCultureFromGreatWriter() {
        return (int)((float)ArraysKt.sum(this.cultureOfLast8Turns) * this.getCivInfo().getGameInfo().getSpeed().getCultureCostModifier());
    }

    private final void addCurrentCultureToCultureOfLast8Turns(int culture) {
        this.cultureOfLast8Turns[this.getCivInfo().getGameInfo().getTurns() % 8] = culture;
    }

    public final boolean allPoliciesAdopted(boolean checkEra) {
        boolean bl;
        block3: {
            Collection<Policy> collection = this.getRulesetPolicies().values();
            Intrinsics.checkNotNullExpressionValue(collection, "getRulesetPolicies().values");
            Iterable $this$none$iv = collection;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Policy it = (Policy)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    if (!this.isAdoptable(it, checkEra)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }
}

