/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.ui.screens.victoryscreen.RankingType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\t0\u0014j\b\u0012\u0004\u0012\u00020\t`\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0012J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00122\b\b\u0002\u0010\u001b\u001a\u00020\u000fJ\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0012J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\u001dJ\u0018\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0\"0!J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0'2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/unciv/logic/civilization/managers/ThreatManager;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/logic/civilization/Civilization;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "distanceToClosestEnemyTiles", "Ljava/util/HashMap;", "Lcom/unciv/logic/map/tile/Tile;", "Lcom/unciv/logic/civilization/managers/ThreatManager$ClosestEnemyTileData;", "Lkotlin/collections/HashMap;", "clear", "", "doesTileHaveMilitaryEnemy", "", "tile", "getCombinedForceOfWarringCivs", "", "getDangerousTiles", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "distance", "getDistanceToClosestEnemyUnit", "maxDist", "takeLargerValues", "getEnemyMilitaryUnitsInDistance", "", "getEnemyUnitsOnTiles", "tilesWithEnemyUnitsInDistance", "getNeighboringCitiesOfOtherCivs", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "Lcom/unciv/logic/city/City;", "getNeighboringCivilizations", "", "getTilesWithEnemyUnitsInDistance", "", "ClosestEnemyTileData", "core"})
@SourceDebugExtension(value={"SMAP\nThreatManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreatManager.kt\ncom/unciv/logic/civilization/managers/ThreatManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1373#2:189\n1461#2,5:190\n1373#2:195\n1461#2,5:196\n766#2:201\n857#2,2:202\n1373#2:204\n1461#2,5:205\n1360#2:212\n1446#2,2:213\n766#2:215\n857#2,2:216\n1549#2:218\n1620#2,3:219\n1448#2,3:222\n1360#2:225\n1446#2,5:226\n766#2:231\n857#2,2:232\n1549#2:234\n1620#2,3:235\n1229#3,2:210\n1#4:238\n*S KotlinDebug\n*F\n+ 1 ThreatManager.kt\ncom/unciv/logic/civilization/managers/ThreatManager\n*L\n139#1:189\n139#1:190,5\n148#1:195\n148#1:196,5\n151#1:201\n151#1:202,2\n152#1:204\n152#1:205,5\n175#1:212\n175#1:213,2\n176#1:215\n176#1:216,2\n176#1:218\n176#1:219,3\n175#1:222,3\n179#1:225\n179#1:226,5\n179#1:231\n179#1:232,2\n179#1:234\n179#1:235,3\n167#1:210,2\n*E\n"})
public final class ThreatManager {
    @NotNull
    private final Civilization civInfo;
    @NotNull
    private final HashMap<Tile, ClosestEnemyTileData> distanceToClosestEnemyTiles;

    public ThreatManager(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
        this.distanceToClosestEnemyTiles = new HashMap();
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    public final int getDistanceToClosestEnemyUnit(@NotNull Tile tile, int maxDist, boolean takeLargerValues) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        ClosestEnemyTileData tileData = this.distanceToClosestEnemyTiles.get(tile);
        int notFoundDistance = takeLargerValues ? 500000 : maxDist;
        int minDistanceToSearch = 1;
        if (tileData != null) {
            List<Pair<Tile, Integer>> tilesWithEnemies = tileData.getTilesWithEnemies();
            while (!((Collection)tilesWithEnemies).isEmpty()) {
                Pair<Tile, Integer> enemyTile = CollectionsKt.first(tilesWithEnemies);
                if (this.doesTileHaveMilitaryEnemy(enemyTile.getFirst())) {
                    return takeLargerValues ? ((Number)enemyTile.getSecond()).intValue() : RangesKt.coerceAtMost(((Number)enemyTile.getSecond()).intValue(), maxDist);
                }
                CollectionsKt.removeFirst(tilesWithEnemies);
            }
            if (tileData.getDistanceSearched() > maxDist) {
                return takeLargerValues ? notFoundDistance : maxDist;
            }
            minDistanceToSearch = RangesKt.coerceAtLeast(tileData.getDistanceSearched() + 1, 1);
        }
        if (tileData != null && !((Collection)tileData.getTilesWithEnemies()).isEmpty()) {
            throw new IllegalStateException("There must be no elements in tile.data.tilesWithEnemies at this point");
        }
        List tilesWithEnemyAtDistance = new ArrayList();
        int i = minDistanceToSearch;
        if (i <= maxDist) {
            while (true) {
                Iterator<Tile> iterator2 = tile.getTilesAtDistance(i).iterator();
                while (iterator2.hasNext()) {
                    Tile searchTile = iterator2.next();
                    if (!this.doesTileHaveMilitaryEnemy(searchTile)) continue;
                    tilesWithEnemyAtDistance.add(new Pair<Tile, Integer>(searchTile, i));
                }
                if (!((Collection)tilesWithEnemyAtDistance).isEmpty()) {
                    ((Map)this.distanceToClosestEnemyTiles).put(tile, new ClosestEnemyTileData(i, tilesWithEnemyAtDistance));
                    return i;
                }
                if (i == maxDist) break;
                ++i;
            }
        }
        ((Map)this.distanceToClosestEnemyTiles).put(tile, new ClosestEnemyTileData(maxDist, new ArrayList()));
        return notFoundDistance;
    }

    public static /* synthetic */ int getDistanceToClosestEnemyUnit$default(ThreatManager threatManager, Tile tile, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        return threatManager.getDistanceToClosestEnemyUnit(tile, n, bl);
    }

    @NotNull
    public final List<Tile> getTilesWithEnemyUnitsInDistance(@NotNull Tile tile, int maxDist) {
        List tileDataTilesWithEnemies;
        Intrinsics.checkNotNullParameter(tile, "tile");
        ClosestEnemyTileData tileData = this.distanceToClosestEnemyTiles.get(tile);
        List tilesWithEnemies = new ArrayList();
        ClosestEnemyTileData closestEnemyTileData = tileData;
        List list2 = tileDataTilesWithEnemies = (closestEnemyTileData != null ? closestEnemyTileData.getTilesWithEnemies() : null) != null ? tileData.getTilesWithEnemies() : (List)new ArrayList();
        if (tileData != null && tileData.getDistanceSearched() >= maxDist) {
            ListIterator tilesWithEnemiesIterator;
            ListIterator listIterator = tilesWithEnemiesIterator = tileDataTilesWithEnemies.listIterator();
            while (listIterator.hasNext()) {
                Pair tileWithDistance = (Pair)listIterator.next();
                if (((Number)tileWithDistance.getSecond()).intValue() > maxDist) {
                    return tilesWithEnemies;
                }
                if (this.doesTileHaveMilitaryEnemy((Tile)tileWithDistance.getFirst())) {
                    tilesWithEnemies.add(tileWithDistance.getFirst());
                    continue;
                }
                tilesWithEnemiesIterator.remove();
            }
        }
        if (tileData != null && maxDist <= tileData.getDistanceSearched()) {
            return tilesWithEnemies;
        }
        ClosestEnemyTileData closestEnemyTileData2 = tileData;
        int minDistanceToSearch = (closestEnemyTileData2 != null ? RangesKt.coerceAtLeast(closestEnemyTileData2.getDistanceSearched(), 0) : 0) + 1;
        int i = minDistanceToSearch;
        if (i <= maxDist) {
            while (true) {
                Iterator<Tile> iterator2 = tile.getTilesAtDistance(i).iterator();
                while (iterator2.hasNext()) {
                    Tile searchTile = iterator2.next();
                    if (!this.doesTileHaveMilitaryEnemy(searchTile)) continue;
                    tilesWithEnemies.add(searchTile);
                    tileDataTilesWithEnemies.add(new Pair<Tile, Integer>(searchTile, i));
                }
                if (i == maxDist) break;
                ++i;
            }
        }
        if (tileData != null) {
            tileData.setDistanceSearched(Math.max(tileData.getDistanceSearched(), maxDist));
        } else {
            ((Map)this.distanceToClosestEnemyTiles).put(tile, new ClosestEnemyTileData(maxDist, tileDataTilesWithEnemies));
        }
        return tilesWithEnemies;
    }

    @NotNull
    public final List<MapUnit> getEnemyMilitaryUnitsInDistance(@NotNull Tile tile, int maxDist) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return this.getEnemyUnitsOnTiles(this.getTilesWithEnemyUnitsInDistance(tile, maxDist));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MapUnit> getEnemyUnitsOnTiles(@NotNull List<Tile> tilesWithEnemyUnitsInDistance) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(tilesWithEnemyUnitsInDistance, "tilesWithEnemyUnitsInDistance");
        Iterable $this$flatMap$iv = tilesWithEnemyUnitsInDistance;
        boolean $i$f$flatMapSequence = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Tile enemyTile = (Tile)element$iv$iv;
            boolean bl = false;
            Sequence<MapUnit> list$iv$iv = SequencesKt.filter(enemyTile.getUnits(), (Function1)new Function1<MapUnit, Boolean>(this){
                final /* synthetic */ ThreatManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull MapUnit it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.isMilitary() && this.this$0.getCivInfo().isAtWarWith(it.getCiv());
                }
            });
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final HashSet<Tile> getDangerousTiles(@NotNull MapUnit unit, int distance) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        tilesWithEnemyUnits = this.getTilesWithEnemyUnitsInDistance(unit.getTile(), distance);
        nearbyRangedEnemyUnits = this.getEnemyUnitsOnTiles(tilesWithEnemyUnits);
        var6_5 = nearbyRangedEnemyUnits;
        $i$f$flatMapSequence = false;
        var8_8 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapSequenceTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (MapUnit)element$iv$iv;
            $i$a$-flatMapSequence-ThreatManager$getDangerousTiles$tilesInRangeOfAttack$1 = false;
            list$iv$iv = it.getTile().getTilesInDistance(it.getRange());
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        tilesInRangeOfAttack = (List)destination$iv$iv;
        $i$f$flatMapSequence = tilesWithEnemyUnits;
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Tile)element$iv$iv;
            $i$a$-filter-ThreatManager$getDangerousTiles$tilesWithinBombardmentRange$1 = false;
            if (!it.isCityCenter()) ** GOTO lbl-1000
            v0 = it.getCity();
            Intrinsics.checkNotNull(v0);
            if (v0.getCiv().isAtWarWith(unit.getCiv())) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$flatMapSequence = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapSequenceTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Tile)element$iv$iv;
            $i$a$-flatMapSequence-ThreatManager$getDangerousTiles$tilesWithinBombardmentRange$2 = false;
            v2 = it.getCity();
            Intrinsics.checkNotNull(v2);
            list$iv$iv = it.getTilesInDistance(v2.getBombardRange());
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        tilesWithinBombardmentRange = (List)destination$iv$iv;
        tilesWithTerrainDamage = SequencesKt.filter(unit.getCurrentTile().getTilesInDistance(distance), (Function1)new Function1<Tile, Boolean>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$unit.getDamageFromTerrain(it) > 0;
            }
        });
        return CollectionsKt.toHashSet((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)tilesInRangeOfAttack, (Iterable)tilesWithinBombardmentRange), tilesWithTerrainDamage));
    }

    public static /* synthetic */ HashSet getDangerousTiles$default(ThreatManager threatManager, MapUnit mapUnit, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 3;
        }
        return threatManager.getDangerousTiles(mapUnit, n);
    }

    public final boolean doesTileHaveMilitaryEnemy(@NotNull Tile tile) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(tile, "tile");
            if (!tile.isExplored(this.civInfo)) {
                return false;
            }
            if (tile.isCityCenter()) {
                City city2 = tile.getCity();
                Intrinsics.checkNotNull(city2);
                if (city2.getCiv().isAtWarWith(this.civInfo)) {
                    return true;
                }
            }
            if (!tile.isVisible(this.civInfo)) {
                return false;
            }
            Sequence<MapUnit> $this$any$iv = tile.getUnits();
            boolean $i$f$any = false;
            Iterator<MapUnit> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                MapUnit element$iv;
                MapUnit it = element$iv = iterator2.next();
                boolean bl2 = false;
                boolean bl3 = it.isMilitary() && it.getCiv().isAtWarWith(this.civInfo) && !it.isInvisible(this.civInfo);
                if (!bl3) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Sequence<Pair<City, City>> getNeighboringCitiesOfOtherCivs() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.civInfo.getCities();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            City it;
            void $this$filterTo$iv$iv;
            City ourCity = (City)element$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = ourCity.getNeighboringCities();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                it = (City)element$iv$iv2;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual(it.getCiv(), this.civInfo))) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (City)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(new Pair<City, City>(ourCity, it));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.asSequence((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Civilization> getNeighboringCivilizations() {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        City it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.civInfo.getCities();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (City)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getNeighboringCities();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (City)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getCiv(), this.civInfo) && this.civInfo.knows(it.getCiv()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (City)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCiv());
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final int getCombinedForceOfWarringCivs() {
        Iterable iterable = this.civInfo.getCivsAtWarWith();
        int n = 0;
        for (Object t : iterable) {
            void it;
            Civilization civilization = (Civilization)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getStatForRanking(RankingType.Force);
            n = n2 + n3;
        }
        return n;
    }

    public final void clear() {
        this.distanceToClosestEnemyTiles.clear();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR,\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/unciv/logic/civilization/managers/ThreatManager$ClosestEnemyTileData;", "", "distanceSearched", "", "tilesWithEnemies", "", "Lkotlin/Pair;", "Lcom/unciv/logic/map/tile/Tile;", "(ILjava/util/List;)V", "getDistanceSearched", "()I", "setDistanceSearched", "(I)V", "getTilesWithEnemies", "()Ljava/util/List;", "setTilesWithEnemies", "(Ljava/util/List;)V", "core"})
    public static final class ClosestEnemyTileData {
        private int distanceSearched;
        @NotNull
        private List<Pair<Tile, Integer>> tilesWithEnemies;

        public ClosestEnemyTileData(int distanceSearched, @NotNull List<Pair<Tile, Integer>> tilesWithEnemies) {
            Intrinsics.checkNotNullParameter(tilesWithEnemies, "tilesWithEnemies");
            this.distanceSearched = distanceSearched;
            this.tilesWithEnemies = tilesWithEnemies;
        }

        public final int getDistanceSearched() {
            return this.distanceSearched;
        }

        public final void setDistanceSearched(int n) {
            this.distanceSearched = n;
        }

        @NotNull
        public final List<Pair<Tile, Integer>> getTilesWithEnemies() {
            return this.tilesWithEnemies;
        }

        public final void setTilesWithEnemies(@NotNull List<Pair<Tile, Integer>> list2) {
            Intrinsics.checkNotNullParameter(list2, "<set-?>");
            this.tilesWithEnemies = list2;
        }
    }
}

