/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.files;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.TileMap;
import com.unciv.ui.screens.savescreens.Gzip;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0011\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0004J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0013J\u0016\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lcom/unciv/logic/files/MapSaver;", "", "()V", "mapsFolder", "", "saveZipped", "", "getSaveZipped", "()Z", "setSaveZipped", "(Z)V", "getMap", "Lcom/badlogic/gdx/files/FileHandle;", "kotlin.jvm.PlatformType", "mapName", "getMaps", "", "()[Lcom/badlogic/gdx/files/FileHandle;", "loadMap", "Lcom/unciv/logic/map/TileMap;", "mapFile", "loadMapParameters", "Lcom/unciv/logic/map/MapParameters;", "loadMapPreview", "Lcom/unciv/logic/map/TileMap$Preview;", "mapFromJson", "json", "mapFromSavedString", "mapString", "mapPreviewFromSavedString", "mapToSavedString", "tileMap", "saveMap", "", "core"})
public final class MapSaver {
    @NotNull
    public static final MapSaver INSTANCE = new MapSaver();
    @NotNull
    public static final String mapsFolder = "maps";
    private static boolean saveZipped = true;

    private MapSaver() {
    }

    public final boolean getSaveZipped() {
        return saveZipped;
    }

    public final void setSaveZipped(boolean bl) {
        saveZipped = bl;
    }

    private final FileHandle getMap(String mapName) {
        return Gdx.files.local("maps/" + mapName);
    }

    @NotNull
    public final TileMap mapFromSavedString(@NotNull String mapString) {
        String string;
        Intrinsics.checkNotNullParameter(mapString, "mapString");
        try {
            string = Gzip.INSTANCE.unzip(((Object)StringsKt.trim((CharSequence)mapString)).toString());
        }
        catch (Exception _) {
            string = mapString;
        }
        String unzippedJson = string;
        return this.mapFromJson(unzippedJson);
    }

    @NotNull
    public final String mapToSavedString(@NotNull TileMap tileMap) {
        String string;
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        tileMap.assignContinents(TileMap.AssignContinentsMode.Reassign);
        String mapJson = UncivJsonKt.json().toJson(tileMap);
        if (saveZipped) {
            Intrinsics.checkNotNullExpressionValue(mapJson, "mapJson");
            string = Gzip.INSTANCE.zip(mapJson);
        } else {
            Intrinsics.checkNotNullExpressionValue(mapJson, "mapJson");
            string = mapJson;
        }
        return string;
    }

    public final void saveMap(@NotNull String mapName, @NotNull TileMap tileMap) {
        Intrinsics.checkNotNullParameter(mapName, "mapName");
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        this.getMap(mapName).writeString(this.mapToSavedString(tileMap), false, Charsets.UTF_8.name());
    }

    @NotNull
    public final TileMap loadMap(@NotNull FileHandle mapFile) {
        Intrinsics.checkNotNullParameter(mapFile, "mapFile");
        String string = mapFile.readString(Charsets.UTF_8.name());
        Intrinsics.checkNotNullExpressionValue(string, "mapFile.readString(Charsets.UTF_8.name())");
        return this.mapFromSavedString(string);
    }

    @NotNull
    public final FileHandle[] getMaps() {
        FileHandle[] fileHandleArray = Gdx.files.local(mapsFolder).list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "files.local(mapsFolder).list()");
        return fileHandleArray;
    }

    private final TileMap mapFromJson(String json) {
        TileMap tileMap = UncivJsonKt.json().fromJson(TileMap.class, json);
        Intrinsics.checkNotNullExpressionValue(tileMap, "json().fromJson(TileMap::class.java, json)");
        return tileMap;
    }

    @NotNull
    public final MapParameters loadMapParameters(@NotNull FileHandle mapFile) {
        Intrinsics.checkNotNullParameter(mapFile, "mapFile");
        return this.loadMapPreview(mapFile).getMapParameters();
    }

    @NotNull
    public final TileMap.Preview loadMapPreview(@NotNull FileHandle mapFile) {
        Intrinsics.checkNotNullParameter(mapFile, "mapFile");
        String string = mapFile.readString();
        Intrinsics.checkNotNullExpressionValue(string, "mapFile.readString()");
        return this.mapPreviewFromSavedString(string);
    }

    private final TileMap.Preview mapPreviewFromSavedString(String mapString) {
        String string;
        try {
            string = Gzip.INSTANCE.unzip(((Object)StringsKt.trim((CharSequence)mapString)).toString());
        }
        catch (Exception _) {
            string = mapString;
        }
        String unzippedJson = string;
        TileMap.Preview preview = UncivJsonKt.json().fromJson(TileMap.Preview.class, unzippedJson);
        Intrinsics.checkNotNullExpressionValue(preview, "json().fromJson(TileMap.\u2026class.java, unzippedJson)");
        return preview;
    }
}

