/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.github;

import com.unciv.json.UncivJsonKt;
import com.unciv.logic.github.Github;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u001b\u001c\u001d\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\bJ%\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000eJ\u001d\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0011J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J\f\u0010\u0015\u001a\u00020\u0004*\u00020\u0016H\u0002J\u0011\u0010\u0017\u001a\u00020\u0004*\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0018J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u0016*\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/unciv/logic/github/GithubAPI;", "", "()V", "urlToQueryModTopics", "", "getUrlForBranchZip", "gitRepoUrl", "branch", "getUrlForBranchZip$core", "getUrlForModListing", "searchRequest", "amountPerPage", "", "page", "getUrlForModListing$core", "getUrlForPreview", "modUrl", "getUrlForPreview$core", "getUrlForSingleRepoQuery", "owner", "repoName", "getUrlForReleaseZip", "Lcom/unciv/logic/github/GithubAPI$Repo;", "getUrlForTreeQuery", "getUrlForTreeQuery$core", "parseUrl", "url", "Repo", "RepoOwner", "RepoSearch", "TopicSearchResponse", "Tree", "core"})
public final class GithubAPI {
    @NotNull
    public static final GithubAPI INSTANCE = new GithubAPI();
    @NotNull
    public static final String urlToQueryModTopics = "https://api.github.com/search/topics?q=unciv-mod+repositories:%3E1&sort=name&order=asc";

    private GithubAPI() {
    }

    @NotNull
    public final String getUrlForBranchZip$core(@NotNull String gitRepoUrl, @NotNull String branch) {
        Intrinsics.checkNotNullParameter(gitRepoUrl, "gitRepoUrl");
        Intrinsics.checkNotNullParameter(branch, "branch");
        return gitRepoUrl + "/archive/refs/heads/" + branch + ".zip";
    }

    @NotNull
    public final String getUrlForModListing$core(@NotNull String searchRequest, int amountPerPage, int page) {
        Intrinsics.checkNotNullParameter(searchRequest, "searchRequest");
        return "https://api.github.com/search/repositories?q=" + searchRequest + (((CharSequence)searchRequest).length() == 0 ? "" : "+") + "%20topic:unciv-mod%20fork:true&sort:stars&per_page=" + amountPerPage + "&page=" + page;
    }

    private final String getUrlForSingleRepoQuery(String owner, String repoName) {
        return "https://api.github.com/repos/" + owner + '/' + repoName;
    }

    private final String getUrlForReleaseZip(Repo $this$getUrlForReleaseZip) {
        return $this$getUrlForReleaseZip.getHtml_url() + "/archive/refs/tags/" + $this$getUrlForReleaseZip.getRelease_tag() + ".zip";
    }

    @NotNull
    public final String getUrlForTreeQuery$core(@NotNull Repo $this$getUrlForTreeQuery) {
        Intrinsics.checkNotNullParameter($this$getUrlForTreeQuery, "<this>");
        return "https://api.github.com/repos/" + $this$getUrlForTreeQuery.getFull_name() + "/git/trees/" + $this$getUrlForTreeQuery.getDefault_branch() + "?recursive=true";
    }

    @NotNull
    public final String getUrlForPreview$core(@NotNull String modUrl, @NotNull String branch) {
        Intrinsics.checkNotNullParameter(modUrl, "modUrl");
        Intrinsics.checkNotNullParameter(branch, "branch");
        return StringsKt.replace$default(modUrl + '/' + branch + "/preview", "github.com", "raw.githubusercontent.com", false, 4, null);
    }

    private final Repo parseUrl(Repo $this$parseUrl, String url2) {
        $this$parseUrl.setHtml_url(url2);
        $this$parseUrl.setDefault_branch("master");
        MatchResult matchZip = new Regex("^(.*/(.*)/(.*))/archive/(?:.*/)?heads/([^.]+).zip$").matchEntire(url2);
        if (matchZip != null && matchZip.getGroups().size() > 4) {
            return GithubAPI.parseUrl$processMatch($this$parseUrl, matchZip);
        }
        MatchResult matchBranch = new Regex("^(.*/(.*)/(.*))/tree/([^/]+)$").matchEntire(url2);
        if (matchBranch != null && matchBranch.getGroups().size() > 4) {
            return GithubAPI.parseUrl$processMatch($this$parseUrl, matchBranch);
        }
        MatchResult matchTagArchive = new Regex("^(.*/(.*)/(.*))/archive/(?:.*/)?tags/([^.]+).zip$").matchEntire(url2);
        if (matchTagArchive != null && matchTagArchive.getGroups().size() > 4) {
            GithubAPI.parseUrl$processMatch($this$parseUrl, matchTagArchive);
            $this$parseUrl.setRelease_tag($this$parseUrl.getDefault_branch());
            $this$parseUrl.setDirect_zip_url(url2);
            return $this$parseUrl;
        }
        MatchResult matchTagPage = new Regex("^(.*/(.*)/(.*))/releases/(?:.*/)?tag/([^.]+)$").matchEntire(url2);
        if (matchTagPage != null && matchTagPage.getGroups().size() > 4) {
            GithubAPI.parseUrl$processMatch($this$parseUrl, matchTagPage);
            $this$parseUrl.setRelease_tag($this$parseUrl.getDefault_branch());
            $this$parseUrl.setDirect_zip_url(this.getUrlForReleaseZip($this$parseUrl));
            return $this$parseUrl;
        }
        MatchResult matchRepo = new Regex("^.*//.*/(.+)/(.+)/?$").matchEntire(url2);
        if (matchRepo != null && matchRepo.getGroups().size() > 2) {
            MatchGroup matchGroup = matchRepo.getGroups().get(1);
            Intrinsics.checkNotNull(matchGroup);
            String string = matchGroup.getValue();
            MatchGroup matchGroup2 = matchRepo.getGroups().get(2);
            Intrinsics.checkNotNull(matchGroup2);
            Repo repo = Repo.Companion.query(string, matchGroup2.getValue());
            if (repo != null) {
                return repo;
            }
        }
        if (!StringsKt.startsWith$default(url2, "http://", false, 2, null) && !StringsKt.startsWith$default(url2, "https://", false, 2, null)) {
            return null;
        }
        $this$parseUrl.setHtml_url("");
        $this$parseUrl.setDirect_zip_url(url2);
        $this$parseUrl.getOwner().setLogin("-unknown-");
        $this$parseUrl.setDefault_branch("master");
        MatchResult matchAnyZip = new Regex("^.*//(?:.*/)*([^/]+\\.zip)$").matchEntire(url2);
        if (matchAnyZip != null && matchAnyZip.getGroups().size() > 1) {
            MatchGroup matchGroup = matchAnyZip.getGroups().get(1);
            Intrinsics.checkNotNull(matchGroup);
            $this$parseUrl.setName(matchGroup.getValue());
        }
        $this$parseUrl.setFull_name($this$parseUrl.getName());
        return $this$parseUrl;
    }

    private static final Repo parseUrl$processMatch(Repo $this_parseUrl, MatchResult matchResult) {
        MatchGroup matchGroup = matchResult.getGroups().get(1);
        Intrinsics.checkNotNull(matchGroup);
        $this_parseUrl.setHtml_url(matchGroup.getValue());
        RepoOwner repoOwner = $this_parseUrl.getOwner();
        MatchGroup matchGroup2 = matchResult.getGroups().get(2);
        Intrinsics.checkNotNull(matchGroup2);
        repoOwner.setLogin(matchGroup2.getValue());
        MatchGroup matchGroup3 = matchResult.getGroups().get(3);
        Intrinsics.checkNotNull(matchGroup3);
        $this_parseUrl.setName(matchGroup3.getValue());
        MatchGroup matchGroup4 = matchResult.getGroups().get(4);
        Intrinsics.checkNotNull(matchGroup4);
        $this_parseUrl.setDefault_branch(matchGroup4.getValue());
        return $this_parseUrl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0007\u0018\u0000 :2\u00020\u0001:\u0001:B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00109\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\u001a\u0010\u001b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0006\"\u0004\b\u001d\u0010\bR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0006\"\u0004\b&\u0010\bR\u001a\u0010'\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0006\"\u0004\b)\u0010\bR\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010-\"\u0004\b2\u0010/R \u00103\u001a\b\u0012\u0004\u0012\u00020\u000404X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108\u00a8\u0006;"}, d2={"Lcom/unciv/logic/github/GithubAPI$Repo;", "", "()V", "default_branch", "", "getDefault_branch", "()Ljava/lang/String;", "setDefault_branch", "(Ljava/lang/String;)V", "description", "getDescription", "setDescription", "direct_zip_url", "getDirect_zip_url", "setDirect_zip_url", "full_name", "getFull_name", "setFull_name", "hasUpdatedSize", "", "getHasUpdatedSize", "()Z", "setHasUpdatedSize", "(Z)V", "html_url", "getHtml_url", "setHtml_url", "name", "getName", "setName", "owner", "Lcom/unciv/logic/github/GithubAPI$RepoOwner;", "getOwner", "()Lcom/unciv/logic/github/GithubAPI$RepoOwner;", "setOwner", "(Lcom/unciv/logic/github/GithubAPI$RepoOwner;)V", "pushed_at", "getPushed_at", "setPushed_at", "release_tag", "getRelease_tag", "setRelease_tag", "size", "", "getSize", "()I", "setSize", "(I)V", "stargazers_count", "getStargazers_count", "setStargazers_count", "topics", "", "getTopics", "()Ljava/util/List;", "setTopics", "(Ljava/util/List;)V", "toString", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nGithubAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubAPI.kt\ncom/unciv/logic/github/GithubAPI$Repo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n1#2:252\n*E\n"})
    public static final class Repo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean hasUpdatedSize;
        @NotNull
        private String direct_zip_url = "";
        @NotNull
        private String release_tag = "";
        @NotNull
        private String name = "";
        @NotNull
        private String full_name = "";
        @Nullable
        private String description;
        @NotNull
        private RepoOwner owner = new RepoOwner();
        private int stargazers_count;
        @NotNull
        private String default_branch = "";
        @NotNull
        private String html_url = "";
        @NotNull
        private String pushed_at = "";
        private int size;
        @NotNull
        private List<String> topics = new ArrayList();

        public final boolean getHasUpdatedSize() {
            return this.hasUpdatedSize;
        }

        public final void setHasUpdatedSize(boolean bl) {
            this.hasUpdatedSize = bl;
        }

        @NotNull
        public final String getDirect_zip_url() {
            return this.direct_zip_url;
        }

        public final void setDirect_zip_url(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.direct_zip_url = string;
        }

        @NotNull
        public final String getRelease_tag() {
            return this.release_tag;
        }

        public final void setRelease_tag(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.release_tag = string;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.name = string;
        }

        @NotNull
        public final String getFull_name() {
            return this.full_name;
        }

        public final void setFull_name(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.full_name = string;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(@Nullable String string) {
            this.description = string;
        }

        @NotNull
        public final RepoOwner getOwner() {
            return this.owner;
        }

        public final void setOwner(@NotNull RepoOwner repoOwner) {
            Intrinsics.checkNotNullParameter(repoOwner, "<set-?>");
            this.owner = repoOwner;
        }

        public final int getStargazers_count() {
            return this.stargazers_count;
        }

        public final void setStargazers_count(int n) {
            this.stargazers_count = n;
        }

        @NotNull
        public final String getDefault_branch() {
            return this.default_branch;
        }

        public final void setDefault_branch(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.default_branch = string;
        }

        @NotNull
        public final String getHtml_url() {
            return this.html_url;
        }

        public final void setHtml_url(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.html_url = string;
        }

        @NotNull
        public final String getPushed_at() {
            return this.pushed_at;
        }

        public final void setPushed_at(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.pushed_at = string;
        }

        public final int getSize() {
            return this.size;
        }

        public final void setSize(int n) {
            this.size = n;
        }

        @NotNull
        public final List<String> getTopics() {
            return this.topics;
        }

        public final void setTopics(@NotNull List<String> list2) {
            Intrinsics.checkNotNullParameter(list2, "<set-?>");
            this.topics = list2;
        }

        @NotNull
        public String toString() {
            CharSequence charSequence;
            CharSequence charSequence2 = this.name;
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = this.direct_zip_url;
            } else {
                charSequence = charSequence2;
            }
            return (String)charSequence;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lcom/unciv/logic/github/GithubAPI$Repo$Companion;", "", "()V", "parseUrl", "Lcom/unciv/logic/github/GithubAPI$Repo;", "url", "", "query", "owner", "repoName", "core"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Repo parseUrl(@NotNull String url2) {
                Intrinsics.checkNotNullParameter(url2, "url");
                return INSTANCE.parseUrl(new Repo(), url2);
            }

            @Nullable
            public final Repo query(@NotNull String owner, @NotNull String repoName) {
                InputStream response2;
                Intrinsics.checkNotNullParameter(owner, "owner");
                Intrinsics.checkNotNullParameter(repoName, "repoName");
                InputStream inputStream2 = Github.download$default(Github.INSTANCE, INSTANCE.getUrlForSingleRepoQuery(owner, repoName), null, 2, null);
                if (inputStream2 == null) {
                    return null;
                }
                InputStream inputStream3 = response2 = inputStream2;
                Charset charset = Charsets.UTF_8;
                Reader reader = new InputStreamReader(inputStream3, charset);
                int n = 8192;
                String repoString = TextStreamsKt.readText(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n));
                return UncivJsonKt.json().fromJson(Repo.class, repoString);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/unciv/logic/github/GithubAPI$RepoOwner;", "", "()V", "avatar_url", "", "getAvatar_url", "()Ljava/lang/String;", "setAvatar_url", "(Ljava/lang/String;)V", "login", "getLogin", "setLogin", "core"})
    public static final class RepoOwner {
        @NotNull
        private String login = "";
        @Nullable
        private String avatar_url;

        @NotNull
        public final String getLogin() {
            return this.login;
        }

        public final void setLogin(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.login = string;
        }

        @Nullable
        public final String getAvatar_url() {
            return this.avatar_url;
        }

        public final void setAvatar_url(@Nullable String string) {
            this.avatar_url = string;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0013\u0010\u0002\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/unciv/logic/github/GithubAPI$RepoSearch;", "", "()V", "incomplete_results", "", "getIncomplete_results", "()Z", "setIncomplete_results", "(Z)V", "items", "Ljava/util/ArrayList;", "Lcom/unciv/logic/github/GithubAPI$Repo;", "Lkotlin/collections/ArrayList;", "getItems", "()Ljava/util/ArrayList;", "setItems", "(Ljava/util/ArrayList;)V", "total_count", "", "getTotal_count$annotations", "getTotal_count", "()I", "setTotal_count", "(I)V", "core"})
    public static final class RepoSearch {
        private int total_count;
        private boolean incomplete_results;
        @NotNull
        private ArrayList<Repo> items = new ArrayList();

        public final int getTotal_count() {
            return this.total_count;
        }

        public final void setTotal_count(int n) {
            this.total_count = n;
        }

        public static /* synthetic */ void getTotal_count$annotations() {
        }

        public final boolean getIncomplete_results() {
            return this.incomplete_results;
        }

        public final void setIncomplete_results(boolean bl) {
            this.incomplete_results = bl;
        }

        @NotNull
        public final ArrayList<Repo> getItems() {
            return this.items;
        }

        public final void setItems(@NotNull ArrayList<Repo> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
            this.items = arrayList;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002R*\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/unciv/logic/github/GithubAPI$TopicSearchResponse;", "", "()V", "items", "Ljava/util/ArrayList;", "Lcom/unciv/logic/github/GithubAPI$TopicSearchResponse$Topic;", "Lkotlin/collections/ArrayList;", "getItems", "()Ljava/util/ArrayList;", "setItems", "(Ljava/util/ArrayList;)V", "Topic", "core"})
    public static final class TopicSearchResponse {
        @NotNull
        private ArrayList<Topic> items = new ArrayList();

        @NotNull
        public final ArrayList<Topic> getItems() {
            return this.items;
        }

        public final void setItems(@NotNull ArrayList<Topic> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
            this.items = arrayList;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/unciv/logic/github/GithubAPI$TopicSearchResponse$Topic;", "", "()V", "created_at", "", "getCreated_at", "()Ljava/lang/String;", "setCreated_at", "(Ljava/lang/String;)V", "display_name", "getDisplay_name", "setDisplay_name", "name", "getName", "setName", "updated_at", "getUpdated_at", "setUpdated_at", "core"})
        public static final class Topic {
            @NotNull
            private String name = "";
            @Nullable
            private String display_name;
            @NotNull
            private String created_at = "";
            @NotNull
            private String updated_at = "";

            @NotNull
            public final String getName() {
                return this.name;
            }

            public final void setName(@NotNull String string) {
                Intrinsics.checkNotNullParameter(string, "<set-?>");
                this.name = string;
            }

            @Nullable
            public final String getDisplay_name() {
                return this.display_name;
            }

            public final void setDisplay_name(@Nullable String string) {
                this.display_name = string;
            }

            @NotNull
            public final String getCreated_at() {
                return this.created_at;
            }

            public final void setCreated_at(@NotNull String string) {
                Intrinsics.checkNotNullParameter(string, "<set-?>");
                this.created_at = string;
            }

            @NotNull
            public final String getUpdated_at() {
                return this.updated_at;
            }

            public final void setUpdated_at(@NotNull String string) {
                Intrinsics.checkNotNullParameter(string, "<set-?>");
                this.updated_at = string;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002R0\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/unciv/logic/github/GithubAPI$Tree;", "", "()V", "tree", "Ljava/util/ArrayList;", "Lcom/unciv/logic/github/GithubAPI$Tree$TreeFile;", "Lkotlin/collections/ArrayList;", "getTree$annotations", "getTree", "()Ljava/util/ArrayList;", "setTree", "(Ljava/util/ArrayList;)V", "truncated", "", "getTruncated", "()Z", "setTruncated", "(Z)V", "TreeFile", "core"})
    public static final class Tree {
        @NotNull
        private ArrayList<TreeFile> tree = new ArrayList();
        private boolean truncated;

        @NotNull
        public final ArrayList<TreeFile> getTree() {
            return this.tree;
        }

        public final void setTree(@NotNull ArrayList<TreeFile> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
            this.tree = arrayList;
        }

        public static /* synthetic */ void getTree$annotations() {
        }

        public final boolean getTruncated() {
            return this.truncated;
        }

        public final void setTruncated(boolean bl) {
            this.truncated = bl;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/unciv/logic/github/GithubAPI$Tree$TreeFile;", "", "()V", "size", "", "getSize", "()J", "setSize", "(J)V", "core"})
        public static final class TreeFile {
            private long size;

            public final long getSize() {
                return this.size;
            }

            public final void setSize(long l) {
                this.size = l;
            }
        }
    }
}

