/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.unciv.logic.map.MapParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00060\tj\b\u0012\u0004\u0012\u00020\u0006`\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J\u0016\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0006J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0006J\u000e\u0010\"\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005J\u000e\u0010#\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005J\u001e\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0005H\u0002J\u000e\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u001dJ,\u00100\u001a\b\u0012\u0004\u0012\u00020\u0006012\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u000205J$\u00106\u001a\b\u0012\u0004\u0012\u00020\u0006012\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u00052\u0006\u00104\u001a\u000205J\u000e\u00107\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u00108\u001a\u00020\u00062\u0006\u00109\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u001dJ\u000e\u0010;\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u0006J\u0016\u0010>\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u001dR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/unciv/logic/map/HexMath;", "", "()V", "clockPositionToHexVectorMap", "", "", "Lcom/badlogic/gdx/math/Vector2;", "clockPositionToWorldVectorMap", "getAdjacentVectors", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "origin", "getClockPositionToHexVector", "clockPosition", "getClockPositionToWorldVector", "getColumn", "hexCoord", "getDistance", "destination", "getDistanceFromEdge", "vector", "mapParameters", "Lcom/unciv/logic/map/MapParameters;", "getEquivalentHexagonalRadius", "width", "height", "getEquivalentRectangularSize", "size", "ratio", "", "getHexagonalRadiusForArea", "numberOfTiles", "getLatitude", "getLongitude", "getNumberOfTilesInHexagon", "getRow", "getTileCoordsFromColumnRow", "column", "row", "getUnwrappedNearestTo", "unwrapHexCoord", "staticHexCoord", "longitudinalRadius", "", "getVectorByClockHour", "hour", "getVectorForAngle", "angle", "getVectorsAtDistance", "", "distance", "maxDistance", "worldWrap", "", "getVectorsInDistance", "hex2WorldCoords", "hexFromLatLong", "latitude", "longitude", "roundHexCoords", "world2HexCoords", "worldCoord", "worldFromLatLong", "tileRadius", "core"})
public final class HexMath {
    @NotNull
    public static final HexMath INSTANCE = new HexMath();
    @NotNull
    private static final Map<Integer, Vector2> clockPositionToHexVectorMap;
    @NotNull
    private static final Map<Integer, Vector2> clockPositionToWorldVectorMap;

    private HexMath() {
    }

    @NotNull
    public final Vector2 getVectorForAngle(float angle) {
        return new Vector2((float)Math.sin(angle), (float)Math.cos(angle));
    }

    private final Vector2 getVectorByClockHour(int hour2) {
        return this.getVectorForAngle((float)(Math.PI * 2 * (double)((float)hour2 / 12.0f)));
    }

    public final int getNumberOfTilesInHexagon(int size2) {
        if (size2 < 0) {
            return 0;
        }
        return 1 + 6 * size2 * (size2 + 1) / 2;
    }

    public final float getHexagonalRadiusForArea(int numberOfTiles) {
        return numberOfTiles < 1 ? 0.0f : ((float)Math.sqrt(12.0f * (float)numberOfTiles - (float)3) - (float)3) / (float)6;
    }

    public final float getLatitude(@NotNull Vector2 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return vector.x + vector.y;
    }

    public final float getLongitude(@NotNull Vector2 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return vector.x - vector.y;
    }

    @NotNull
    public final Vector2 hexFromLatLong(float latitude, float longitude) {
        float y = (latitude - longitude) / 2.0f;
        float x = longitude + y;
        return new Vector2(x, y);
    }

    @NotNull
    public final Vector2 worldFromLatLong(@NotNull Vector2 vector, float tileRadius) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        float x = vector.x * tileRadius * 1.5f * -1.0f;
        float y = vector.y * tileRadius * (float)Math.sqrt(3.0f) * 0.5f;
        return new Vector2(x, y);
    }

    @NotNull
    public final Vector2 getEquivalentRectangularSize(int size2, float ratio) {
        if (size2 < 0) {
            Vector2 vector2 = Vector2.Zero;
            Intrinsics.checkNotNullExpressionValue(vector2, "Zero");
            return vector2;
        }
        int nTiles = this.getNumberOfTilesInHexagon(size2);
        float width = (float)Math.rint((float)Math.sqrt((float)nTiles / ratio));
        float height = (float)Math.rint(width * ratio);
        return new Vector2(width, height);
    }

    public static /* synthetic */ Vector2 getEquivalentRectangularSize$default(HexMath hexMath, int n, float f, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 0.65f;
        }
        return hexMath.getEquivalentRectangularSize(n, f);
    }

    public final int getEquivalentHexagonalRadius(int width, int height) {
        return MathKt.roundToInt(this.getHexagonalRadiusForArea(width * height));
    }

    @NotNull
    public final ArrayList<Vector2> getAdjacentVectors(@NotNull Vector2 origin2) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        Vector2[] vector2Array = new Vector2[]{new Vector2(1.0f, 0.0f), new Vector2(1.0f, 1.0f), new Vector2(0.0f, 1.0f), new Vector2(-1.0f, 0.0f), new Vector2(-1.0f, -1.0f), new Vector2(0.0f, -1.0f)};
        ArrayList<Vector2> vectors = CollectionsKt.arrayListOf(vector2Array);
        for (Vector2 vector : vectors) {
            vector.add(origin2);
        }
        return vectors;
    }

    @NotNull
    public final Vector2 getUnwrappedNearestTo(@NotNull Vector2 unwrapHexCoord, @NotNull Vector2 staticHexCoord, @NotNull Number longitudinalRadius) {
        Intrinsics.checkNotNullParameter(unwrapHexCoord, "unwrapHexCoord");
        Intrinsics.checkNotNullParameter(staticHexCoord, "staticHexCoord");
        Intrinsics.checkNotNullParameter(longitudinalRadius, "longitudinalRadius");
        float referenceLong = this.getLongitude(staticHexCoord);
        float toWrapLat = this.getLatitude(unwrapHexCoord);
        float toWrapLong = this.getLongitude(unwrapHexCoord);
        float longRadius = longitudinalRadius.floatValue();
        float f = toWrapLong - referenceLong + longRadius;
        float f2 = longRadius * 2.0f;
        float f3 = f % f2;
        return this.hexFromLatLong(toWrapLat, (!(f3 == 0.0f) && !(Math.signum(f3) == Math.signum(f2)) ? f3 + f2 : f3) - longRadius + referenceLong);
    }

    @NotNull
    public final Vector2 hex2WorldCoords(@NotNull Vector2 hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        Vector2 xVector = this.getVectorByClockHour(10).scl((float)Math.sqrt(3.0));
        Vector2 yVector = this.getVectorByClockHour(2).scl((float)Math.sqrt(3.0));
        Vector2 vector2 = xVector.scl(hexCoord.x).add(yVector.scl(hexCoord.y));
        Intrinsics.checkNotNullExpressionValue(vector2, "xVector.scl(hexCoord.x).\u2026(yVector.scl(hexCoord.y))");
        return vector2;
    }

    @NotNull
    public final Vector2 world2HexCoords(@NotNull Vector2 worldCoord) {
        Intrinsics.checkNotNullParameter(worldCoord, "worldCoord");
        Vector2 D = this.getVectorByClockHour(10).scl((float)Math.sqrt(3.0));
        Vector2 A = this.getVectorByClockHour(2).scl((float)Math.sqrt(3.0));
        float den = D.x * A.y - D.y * A.x;
        float x = (worldCoord.x * A.y - worldCoord.y * A.x) / den;
        float y = (worldCoord.y * D.x - worldCoord.x * D.y) / den;
        return new Vector2(x, y);
    }

    public final int getRow(@NotNull Vector2 hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return (int)(hexCoord.x / (float)2 + hexCoord.y / (float)2);
    }

    public final int getColumn(@NotNull Vector2 hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return (int)(hexCoord.y - hexCoord.x);
    }

    @NotNull
    public final Vector2 getTileCoordsFromColumnRow(int column, int row) {
        int twoRows = row * 2;
        if (Math.abs(column) % 2 == 1) {
            ++twoRows;
        }
        return new Vector2((twoRows - column) / 2, (twoRows + column) / 2);
    }

    @NotNull
    public final Vector2 roundHexCoords(@NotNull Vector2 hexCoord) {
        Intrinsics.checkNotNullParameter(hexCoord, "hexCoord");
        return HexMath.roundHexCoords$cubic2HexCoords(HexMath.roundHexCoords$roundCubicCoords(HexMath.roundHexCoords$hex2CubicCoords(hexCoord)));
    }

    @NotNull
    public final List<Vector2> getVectorsAtDistance(@NotNull Vector2 origin2, int distance, int maxDistance, boolean worldWrap) {
        int i;
        Intrinsics.checkNotNullParameter(origin2, "origin");
        List vectors = new ArrayList();
        if (distance == 0) {
            ((Collection)vectors).add(origin2.cpy());
            return vectors;
        }
        Vector2 current = origin2.cpy().sub(distance, distance);
        for (i = 0; i < distance; ++i) {
            ((Collection)vectors).add(current.cpy());
            ((Collection)vectors).add(origin2.cpy().scl(2.0f).sub(current));
            current.add(1.0f, 0.0f);
        }
        for (i = 0; i < distance; ++i) {
            ((Collection)vectors).add(current.cpy());
            if (!worldWrap || distance != maxDistance) {
                ((Collection)vectors).add(origin2.cpy().scl(2.0f).sub(current));
            }
            current.add(1.0f, 1.0f);
        }
        for (i = 0; i < distance; ++i) {
            ((Collection)vectors).add(current.cpy());
            if (!worldWrap || distance != maxDistance || i != 0) {
                ((Collection)vectors).add(origin2.cpy().scl(2.0f).sub(current));
            }
            current.add(0.0f, 1.0f);
        }
        return vectors;
    }

    @NotNull
    public final List<Vector2> getVectorsInDistance(@NotNull Vector2 origin2, int distance, boolean worldWrap) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        List hexesToReturn = new ArrayList();
        int i = 0;
        if (i <= distance) {
            while (true) {
                CollectionsKt.addAll((Collection)hexesToReturn, (Iterable)this.getVectorsAtDistance(origin2, i, distance, worldWrap));
                if (i == distance) break;
                ++i;
            }
        }
        return hexesToReturn;
    }

    public final int getDistance(@NotNull Vector2 origin2, @NotNull Vector2 destination2) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        Intrinsics.checkNotNullParameter(destination2, "destination");
        float relativeX = origin2.x - destination2.x;
        float relativeY = origin2.y - destination2.y;
        return relativeX * relativeY >= 0.0f ? (int)Math.max(Math.abs(relativeX), Math.abs(relativeY)) : (int)(Math.abs(relativeX) + Math.abs(relativeY));
    }

    @NotNull
    public final Vector2 getClockPositionToHexVector(int clockPosition) {
        Vector2 vector2 = clockPositionToHexVectorMap.get(clockPosition);
        if (vector2 == null) {
            Vector2 vector22 = Vector2.Zero;
            vector2 = vector22;
            Intrinsics.checkNotNullExpressionValue(vector22, "Zero");
        }
        return vector2;
    }

    @NotNull
    public final Vector2 getClockPositionToWorldVector(int clockPosition) {
        Vector2 vector2 = clockPositionToWorldVectorMap.get(clockPosition);
        if (vector2 == null) {
            Vector2 vector22 = Vector2.Zero;
            vector2 = vector22;
            Intrinsics.checkNotNullExpressionValue(vector22, "Zero");
        }
        return vector2;
    }

    public final int getDistanceFromEdge(@NotNull Vector2 vector, @NotNull MapParameters mapParameters) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        Intrinsics.checkNotNullParameter(mapParameters, "mapParameters");
        int x = (int)vector.x;
        int y = (int)vector.y;
        if (Intrinsics.areEqual(mapParameters.getShape(), "Rectangular")) {
            int height = mapParameters.getMapSize().getHeight();
            int width = mapParameters.getMapSize().getWidth();
            int left = mapParameters.getWorldWrap() ? Integer.MAX_VALUE : width / 2 - (x - y);
            int right = mapParameters.getWorldWrap() ? Integer.MAX_VALUE : (width - 1) / 2 - (y - x);
            int top = height / 2 - (x + y) / 2;
            int bottom = (x + y - 1) / 2 + (height - 1) / 2;
            int[] nArray = new int[]{right, top, bottom};
            return ComparisonsKt.minOf(left, nArray);
        }
        int radius = mapParameters.getMapSize().getRadius();
        if (!mapParameters.getWorldWrap()) {
            Vector2 vector2 = Vector2.Zero;
            Intrinsics.checkNotNullExpressionValue(vector2, "Zero");
            return radius - this.getDistance(vector, vector2);
        }
        if (MathKt.getSign(x) == MathKt.getSign(y)) {
            Vector2 vector2 = Vector2.Zero;
            Intrinsics.checkNotNullExpressionValue(vector2, "Zero");
            return radius - this.getDistance(vector, vector2);
        }
        if (x > 0) {
            return Math.min(this.getDistance(vector, new Vector2(radius, 0.0f)), this.getDistance(vector, new Vector2(0.0f, -((float)radius))));
        }
        return Math.min(this.getDistance(vector, new Vector2(1.0f, radius)), this.getDistance(vector, new Vector2(-((float)radius), -1.0f)));
    }

    private static final Vector3 roundHexCoords$roundCubicCoords(Vector3 cubicCoords) {
        float rx = (float)Math.rint(cubicCoords.x);
        float ry = (float)Math.rint(cubicCoords.y);
        float rz = (float)Math.rint(cubicCoords.z);
        float deltaX = Math.abs(rx - cubicCoords.x);
        float deltaY = Math.abs(ry - cubicCoords.y);
        float deltaZ = Math.abs(rz - cubicCoords.z);
        if (deltaX > deltaY && deltaX > deltaZ) {
            rx = -ry - rz;
        } else if (deltaY > deltaZ) {
            ry = -rx - rz;
        } else {
            rz = -rx - ry;
        }
        return new Vector3(rx, ry, rz);
    }

    private static final Vector3 roundHexCoords$hex2CubicCoords(Vector2 hexCoord) {
        return new Vector3(hexCoord.y - hexCoord.x, hexCoord.x, -hexCoord.y);
    }

    private static final Vector2 roundHexCoords$cubic2HexCoords(Vector3 cubicCoord) {
        return new Vector2(cubicCoord.y, -cubicCoord.z);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(0, new Vector2(1.0f, 1.0f)), TuplesKt.to(12, new Vector2(1.0f, 1.0f)), TuplesKt.to(2, new Vector2(0.0f, 1.0f)), TuplesKt.to(4, new Vector2(-1.0f, 0.0f)), TuplesKt.to(6, new Vector2(-1.0f, -1.0f)), TuplesKt.to(8, new Vector2(0.0f, -1.0f)), TuplesKt.to(10, new Vector2(1.0f, 0.0f))};
        clockPositionToHexVectorMap = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to(2, INSTANCE.hex2WorldCoords(new Vector2(0.0f, -1.0f))), TuplesKt.to(4, INSTANCE.hex2WorldCoords(new Vector2(1.0f, 0.0f))), TuplesKt.to(6, INSTANCE.hex2WorldCoords(new Vector2(1.0f, 1.0f))), TuplesKt.to(8, INSTANCE.hex2WorldCoords(new Vector2(0.0f, 1.0f))), TuplesKt.to(10, INSTANCE.hex2WorldCoords(new Vector2(-1.0f, 0.0f))), TuplesKt.to(12, INSTANCE.hex2WorldCoords(new Vector2(-1.0f, -1.0f)))};
        clockPositionToWorldVectorMap = MapsKt.mapOf(pairArray);
    }
}

