/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.map.HexMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0017\b\u0016\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eB'\b\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0019\u001a\u00020\u0000J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0004J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010 \u001a\u00020\u0007H\u0016R\u001a\u0010\r\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u000bR\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/unciv/logic/map/MapSize;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "()V", "size", "Lcom/unciv/logic/map/MapSize$Predefined;", "(Lcom/unciv/logic/map/MapSize$Predefined;)V", "name", "", "(Ljava/lang/String;)V", "radius", "", "(I)V", "width", "height", "(II)V", "(Ljava/lang/String;III)V", "getHeight", "()I", "setHeight", "getName", "()Ljava/lang/String;", "getRadius", "setRadius", "getWidth", "setWidth", "clone", "fixUndesiredSizes", "worldWrap", "", "getPredefinedOrNextSmaller", "setNewRadius", "", "toString", "Companion", "Predefined", "core"})
public final class MapSize
implements IsPartOfGameInfoSerialization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private int radius;
    private int width;
    private int height;
    @NotNull
    public static final String custom = "Custom";

    private MapSize(String name2, int radius, int width, int height) {
        this.name = name2;
        this.radius = radius;
        this.width = width;
        this.height = height;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getRadius() {
        return this.radius;
    }

    public final void setRadius(int n) {
        this.radius = n;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    private MapSize() {
        this("", 0, 0, 0);
    }

    public MapSize(@NotNull Predefined size2) {
        Intrinsics.checkNotNullParameter((Object)size2, "size");
        this(size2.name(), size2.getRadius(), size2.getWidth(), size2.getHeight());
    }

    public MapSize(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        this(Predefined.Companion.safeValueOf(name2));
    }

    public MapSize(int radius) {
        this(custom, radius, 0, 0);
        this.setNewRadius(radius);
    }

    public MapSize(int width, int height) {
        this(custom, HexMath.INSTANCE.getEquivalentHexagonalRadius(width, height), width, height);
    }

    @NotNull
    public final MapSize clone() {
        return new MapSize(this.name, this.radius, this.width, this.height);
    }

    @NotNull
    public final Predefined getPredefinedOrNextSmaller() {
        if (!Intrinsics.areEqual(this.name, custom)) {
            return Predefined.Companion.safeValueOf(this.name);
        }
        List<Predefined> list2 = ArraysKt.reversed(Predefined.values());
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            Predefined predef = list2.get(i);
            if (this.radius < predef.getRadius()) continue;
            return predef;
        }
        return Predefined.Tiny;
    }

    @Nullable
    public final String fixUndesiredSizes(boolean worldWrap) {
        if (!Intrinsics.areEqual(this.name, custom)) {
            return null;
        }
        if (worldWrap && this.width % 2 != 0) {
            int n = this.width;
            this.width = n + -1;
        }
        String string = worldWrap && this.width < 32 ? "World wrap requires a minimum width of 32 tiles" : (this.width < 3 || this.height < 3 || this.radius < 2 ? "The provided map dimensions were too small" : (this.radius > 500 ? "The provided map dimensions were too big" : (this.height * 16 < this.width || this.width * 16 < this.height ? "The provided map dimensions had an unacceptable aspect ratio" : null)));
        if (string == null) {
            return null;
        }
        String message2 = string;
        this.setNewRadius(this.radius < 2 ? 2 : (this.radius > 500 ? 500 : (worldWrap && this.radius < 15 ? 15 : this.radius)));
        return message2;
    }

    private final void setNewRadius(int radius) {
        this.radius = radius;
        Vector2 size2 = HexMath.getEquivalentRectangularSize$default(HexMath.INSTANCE, radius, 0.0f, 2, null);
        this.width = (int)size2.x;
        this.height = (int)size2.y;
    }

    @NotNull
    public String toString() {
        return Intrinsics.areEqual(this.name, custom) ? "" + this.width + 'x' + this.height : this.name;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/logic/map/MapSize$Companion;", "", "()V", "Huge", "Lcom/unciv/logic/map/MapSize;", "getHuge", "()Lcom/unciv/logic/map/MapSize;", "Medium", "getMedium", "Small", "getSmall", "Tiny", "getTiny", "custom", "", "names", "", "core"})
    @SourceDebugExtension(value={"SMAP\nMapSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapSize.kt\ncom/unciv/logic/map/MapSize$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,138:1\n11335#2:139\n11670#2,3:140\n*S KotlinDebug\n*F\n+ 1 MapSize.kt\ncom/unciv/logic/map/MapSize$Companion\n*L\n82#1:139\n82#1:140,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapSize getTiny() {
            return new MapSize(Predefined.Tiny);
        }

        @NotNull
        public final MapSize getSmall() {
            return new MapSize(Predefined.Small);
        }

        @NotNull
        public final MapSize getMedium() {
            return new MapSize(Predefined.Medium);
        }

        @NotNull
        public final MapSize getHuge() {
            return new MapSize(Predefined.Huge);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> names() {
            void $this$mapTo$iv$iv;
            Predefined[] $this$map$iv = Predefined.values();
            boolean $i$f$map = false;
            Predefined[] predefinedArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.name());
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0012\b\u0086\u0001\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0018B=\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fj\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017\u00a8\u0006\u0019"}, d2={"Lcom/unciv/logic/map/MapSize$Predefined;", "", "radius", "", "width", "height", "techCostMultiplier", "", "techCostPerCityModifier", "policyCostPerCityModifier", "(Ljava/lang/String;IIIIFFF)V", "getHeight", "()I", "getPolicyCostPerCityModifier", "()F", "getRadius", "getTechCostMultiplier", "getTechCostPerCityModifier", "getWidth", "Tiny", "Small", "Medium", "Large", "Huge", "Companion", "core"})
    public static final class Predefined
    extends Enum<Predefined> {
        @NotNull
        public static final Companion Companion;
        private final int radius;
        private final int width;
        private final int height;
        private final float techCostMultiplier;
        private final float techCostPerCityModifier;
        private final float policyCostPerCityModifier;
        public static final /* enum */ Predefined Tiny;
        public static final /* enum */ Predefined Small;
        public static final /* enum */ Predefined Medium;
        public static final /* enum */ Predefined Large;
        public static final /* enum */ Predefined Huge;
        private static final /* synthetic */ Predefined[] $VALUES;

        private Predefined(int radius, int width, int height, float techCostMultiplier, float techCostPerCityModifier, float policyCostPerCityModifier) {
            this.radius = radius;
            this.width = width;
            this.height = height;
            this.techCostMultiplier = techCostMultiplier;
            this.techCostPerCityModifier = techCostPerCityModifier;
            this.policyCostPerCityModifier = policyCostPerCityModifier;
        }

        /* synthetic */ Predefined(String string, int n, int n2, int n3, int n4, float f, float f2, float f3, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 8) != 0) {
                f = 1.0f;
            }
            if ((n5 & 0x10) != 0) {
                f2 = 0.05f;
            }
            if ((n5 & 0x20) != 0) {
                f3 = 0.1f;
            }
            this(n2, n3, n4, f, f2, f3);
        }

        public final int getRadius() {
            return this.radius;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final float getTechCostMultiplier() {
            return this.techCostMultiplier;
        }

        public final float getTechCostPerCityModifier() {
            return this.techCostPerCityModifier;
        }

        public final float getPolicyCostPerCityModifier() {
            return this.policyCostPerCityModifier;
        }

        public static Predefined[] values() {
            return (Predefined[])$VALUES.clone();
        }

        public static Predefined valueOf(String value) {
            return Enum.valueOf(Predefined.class, value);
        }

        static {
            Tiny = new Predefined("Tiny", 0, 10, 23, 15, 0.0f, 0.0f, 0.0f, 56, null);
            Small = new Predefined("Small", 1, 15, 33, 21, 0.0f, 0.0f, 0.0f, 56, null);
            Medium = new Predefined("Medium", 2, 20, 44, 29, 1.1f, 0.0f, 0.0f, 48, null);
            Large = new Predefined(30, 66, 43, 1.2f, 0.0375f, 0.075f);
            Huge = new Predefined(40, 87, 57, 1.3f, 0.025f, 0.05f);
            $VALUES = predefinedArray = new Predefined[]{Predefined.Tiny, Predefined.Small, Predefined.Medium, Predefined.Large, Predefined.Huge};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/logic/map/MapSize$Predefined$Companion;", "", "()V", "safeValueOf", "Lcom/unciv/logic/map/MapSize$Predefined;", "name", "", "core"})
        @SourceDebugExtension(value={"SMAP\nMapSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapSize.kt\ncom/unciv/logic/map/MapSize$Predefined$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,138:1\n1282#2,2:139\n*S KotlinDebug\n*F\n+ 1 MapSize.kt\ncom/unciv/logic/map/MapSize$Predefined$Companion\n*L\n69#1:139,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Predefined safeValueOf(@NotNull String name2) {
                Predefined predefined;
                Predefined predefined2;
                block2: {
                    Intrinsics.checkNotNullParameter(name2, "name");
                    Predefined[] $this$firstOrNull$iv = Predefined.values();
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        Predefined element$iv;
                        Predefined it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.name(), name2)) continue;
                        predefined2 = element$iv;
                        break block2;
                    }
                    predefined2 = predefined = null;
                }
                if (predefined2 == null) {
                    predefined = Tiny;
                }
                return predefined;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

