/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.MapVisualization;
import com.unciv.logic.map.mapunit.MapUnit;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/unciv/logic/map/MapVisualization;", "", "gameInfo", "Lcom/unciv/logic/GameInfo;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/logic/GameInfo;Lcom/unciv/logic/civilization/Civilization;)V", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "getViewingCiv", "()Lcom/unciv/logic/civilization/Civilization;", "isAttackVisible", "", "attacker", "source", "Lcom/badlogic/gdx/math/Vector2;", "target", "isUnitFutureVisible", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "isUnitPastVisible", "core"})
@SourceDebugExtension(value={"SMAP\nMapVisualization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapVisualization.kt\ncom/unciv/logic/map/MapVisualization\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,29:1\n1206#2,2:30\n*S KotlinDebug\n*F\n+ 1 MapVisualization.kt\ncom/unciv/logic/map/MapVisualization\n*L\n16#1:30,2\n*E\n"})
public final class MapVisualization {
    @NotNull
    private final GameInfo gameInfo;
    @NotNull
    private final Civilization viewingCiv;

    public MapVisualization(@NotNull GameInfo gameInfo2, @NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(gameInfo2, "gameInfo");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        this.gameInfo = gameInfo2;
        this.viewingCiv = viewingCiv;
    }

    @NotNull
    public final GameInfo getGameInfo() {
        return this.gameInfo;
    }

    @NotNull
    public final Civilization getViewingCiv() {
        return this.viewingCiv;
    }

    public final boolean isUnitPastVisible(@NotNull MapUnit unit) {
        boolean bl;
        block2: {
            Sequence checkPositions2;
            Intrinsics.checkNotNullParameter(unit, "unit");
            if (Intrinsics.areEqual(unit.getCiv(), this.viewingCiv)) {
                return true;
            }
            Sequence[] sequenceArray = new Sequence[2];
            sequenceArray[0] = SequencesKt.map(CollectionsKt.asSequence((Iterable)unit.getMovementMemories()), isUnitPastVisible.checkPositions.1.INSTANCE);
            Vector2[] vector2Array = new Vector2[]{unit.getTile().getPosition()};
            sequenceArray[1] = SequencesKt.sequenceOf(vector2Array);
            Sequence $this$all$iv = checkPositions2 = SequencesKt.flatten(SequencesKt.sequenceOf(sequenceArray));
            boolean $i$f$all = false;
            Iterator iterator2 = $this$all$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Vector2 it = (Vector2)element$iv;
                boolean bl2 = false;
                if (this.viewingCiv.getViewableTiles().contains(this.gameInfo.getTileMap().get(it))) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        return bl && (!unit.isInvisible(this.viewingCiv) || this.viewingCiv.getViewableInvisibleUnitsTiles().contains(unit.getTile()));
    }

    public final boolean isUnitFutureVisible(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        return this.viewingCiv.isSpectator() || Intrinsics.areEqual(unit.getCiv(), this.viewingCiv);
    }

    public final boolean isAttackVisible(@NotNull Civilization attacker, @NotNull Vector2 source, @NotNull Vector2 target) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        return Intrinsics.areEqual(attacker, this.viewingCiv) || this.viewingCiv.getViewableTiles().contains(this.gameInfo.getTileMap().get(source)) || this.viewingCiv.getViewableTiles().contains(this.gameInfo.getTileMap().get(target));
    }
}

