/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator;

import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.MapElevationGenerator;
import com.unciv.logic.map.mapgenerator.MapGenerationRandomness;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0005\u001b\u001c\u001d\u001e\u001fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u001a\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0006\u0010\u001a\u001a\u00020\u0015R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/unciv/logic/map/mapgenerator/MapElevationGenerator;", "", "tileMap", "Lcom/unciv/logic/map/TileMap;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "randomness", "Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;", "(Lcom/unciv/logic/map/TileMap;Lcom/unciv/models/ruleset/Ruleset;Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;)V", "dummyMutator", "Lcom/unciv/logic/map/mapgenerator/MapElevationGenerator$TileDummyMutator;", "getDummyMutator", "()Lcom/unciv/logic/map/mapgenerator/MapElevationGenerator$TileDummyMutator;", "dummyMutator$delegate", "Lkotlin/Lazy;", "flat", "", "hillMutator", "Lcom/unciv/logic/map/mapgenerator/MapElevationGenerator$ITileMutator;", "mountainMutator", "cellularHills", "", "cellularMountainRanges", "getTileMutator", "type", "Lcom/unciv/models/ruleset/unique/UniqueType;", "raiseMountainsAndHills", "Companion", "ITileMutator", "TileBaseMutator", "TileDummyMutator", "TileFeatureMutator", "core"})
@SourceDebugExtension(value={"SMAP\nMapElevationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapElevationGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapElevationGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,213:1\n288#2,2:214\n288#2,2:216\n766#2:218\n857#2,2:219\n1549#2:221\n1620#2,3:222\n1250#3,3:225\n*S KotlinDebug\n*F\n+ 1 MapElevationGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapElevationGenerator\n*L\n24#1:214,2\n38#1:216,2\n78#1:218\n78#1:219,2\n78#1:221\n78#1:222,3\n86#1:225,3\n*E\n"})
public final class MapElevationGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TileMap tileMap;
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final MapGenerationRandomness randomness;
    @Nullable
    private final String flat;
    @NotNull
    private final ITileMutator hillMutator;
    @NotNull
    private final ITileMutator mountainMutator;
    @NotNull
    private final Lazy dummyMutator$delegate;
    @NotNull
    private static final String rising = "~Raising~";
    @NotNull
    private static final String lowering = "~Lowering~";

    /*
     * Unable to fully structure code
     */
    public MapElevationGenerator(@NotNull TileMap tileMap, @NotNull Ruleset ruleset, @NotNull MapGenerationRandomness randomness) {
        block3: {
            Intrinsics.checkNotNullParameter(tileMap, "tileMap");
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            Intrinsics.checkNotNullParameter(randomness, "randomness");
            super();
            this.tileMap = tileMap;
            this.ruleset = ruleset;
            this.randomness = randomness;
            v0 = this.ruleset.getTerrains().values();
            Intrinsics.checkNotNullExpressionValue(v0, "ruleset.terrains.values");
            var5_4 = v0;
            var11_5 = this;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (Terrain)element$iv;
                $i$a$-firstOrNull-MapElevationGenerator$flat$1 = false;
                if (it.getImpassable() || it.getType() != TerrainType.Land) ** GOTO lbl-1000
                Intrinsics.checkNotNullExpressionValue(it, "it");
                if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.RoughTerrain, null, 2, null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        var4_11 = v2;
        var11_5.flat = var4_11 != null ? var4_11.getName() : null;
        this.dummyMutator$delegate = LazyKt.lazy(dummyMutator.2.INSTANCE);
        this.mountainMutator = this.getTileMutator(UniqueType.OccursInChains, this.flat);
        this.hillMutator = this.getTileMutator(UniqueType.OccursInGroups, this.flat);
    }

    private final TileDummyMutator getDummyMutator() {
        Lazy lazy = this.dummyMutator$delegate;
        return (TileDummyMutator)lazy.getValue();
    }

    private final ITileMutator getTileMutator(UniqueType type2, String flat) {
        Object v1;
        block3: {
            if (flat == null) {
                return this.getDummyMutator();
            }
            Collection<Terrain> collection = this.ruleset.getTerrains().values();
            Intrinsics.checkNotNullExpressionValue(collection, "ruleset.terrains.values");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Terrain it = (Terrain)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, type2, null, 2, null)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Terrain terrain2 = v1;
        if (terrain2 == null) {
            return this.getDummyMutator();
        }
        Terrain terrain3 = terrain2;
        return terrain3.getType() == TerrainType.TerrainFeature ? (ITileMutator)new TileFeatureMutator(terrain3.getName()) : (ITileMutator)new TileBaseMutator(flat, terrain3.getName());
    }

    public final void raiseMountainsAndHills() {
        if (this.flat == null) {
            Log.INSTANCE.debug("Ruleset seems to contain no flat terrain - can't generate heightmap", new Object[0]);
            return;
        }
        double elevationSeed = this.randomness.getRNG().nextInt();
        double exponent = 1.0 - (double)this.tileMap.getMapParameters().getElevationExponent();
        TileMap.setTransients$default(this.tileMap, this.ruleset, false, 2, null);
        for (Tile tile : this.tileMap.getValues()) {
            if (tile.isWater()) continue;
            double elevation = MapElevationGenerator.raiseMountainsAndHills$powSigned(MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, elevationSeed, 0, 0.0, 0.0, 2.0, 28, null), exponent);
            tile.setBaseTerrain(this.flat);
            this.hillMutator.setElevated(tile, elevation > 0.5 && elevation <= 0.7);
            this.mountainMutator.setElevated(tile, elevation > 0.7);
            tile.setTerrainTransients();
        }
        this.cellularMountainRanges();
        this.cellularHills();
    }

    /*
     * WARNING - void declaration
     */
    private final void cellularMountainRanges() {
        void $this$mapTo$iv$iv;
        Terrain it;
        Iterable $this$filterTo$iv$iv;
        if (this.mountainMutator instanceof TileDummyMutator) {
            return;
        }
        Object[] objectArray = new Object[]{this.mountainMutator.getName()};
        Log.INSTANCE.debug("Mountain-like generation for %s", objectArray);
        int targetMountains = this.mountainMutator.count((Iterable<Tile>)this.tileMap.getValues()) * 2;
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "ruleset.terrains.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterator<Tile> iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Terrain)element$iv$iv;
            boolean bl = false;
            if (!it.getImpassable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Terrain)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getName());
        }
        Set impassableTerrains = CollectionsKt.toSet((List)destination$iv$iv);
        for (int i = 1; i < 6; ++i) {
            int totalMountains = this.mountainMutator.count((Iterable<Tile>)this.tileMap.getValues());
            for (Tile tile : this.tileMap.getValues()) {
                if (tile.isWater()) continue;
                int adjacentMountains = this.mountainMutator.count(tile.getNeighbors());
                Sequence<Tile> $this$count$iv = tile.getNeighbors();
                boolean $i$f$count = false;
                int count$iv = 0;
                Iterator<Tile> iterator3 = $this$count$iv.iterator();
                while (iterator3.hasNext()) {
                    Tile element$iv;
                    Tile it2 = element$iv = iterator3.next();
                    boolean bl = false;
                    if (!impassableTerrains.contains(it2.getBaseTerrain()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int adjacentImpassible = count$iv;
                if (adjacentMountains == 0 && this.mountainMutator.isElevated(tile)) {
                    if (this.randomness.getRNG().nextInt(4) != 0) continue;
                    tile.addTerrainFeature(lowering);
                    continue;
                }
                if (adjacentMountains == 1) {
                    if (this.randomness.getRNG().nextInt(10) != 0) continue;
                    tile.addTerrainFeature(rising);
                    continue;
                }
                if (adjacentImpassible == 3) {
                    if (this.randomness.getRNG().nextInt(2) != 0) continue;
                    tile.addTerrainFeature(lowering);
                    continue;
                }
                if (adjacentImpassible <= 3) continue;
                tile.addTerrainFeature(lowering);
            }
            for (Tile tile : this.tileMap.getValues()) {
                if (tile.isWater()) continue;
                if (tile.getTerrainFeatures().contains(rising)) {
                    tile.removeTerrainFeature(rising);
                    if (totalMountains >= targetMountains) continue;
                    if (!this.mountainMutator.isElevated(tile)) {
                        ++totalMountains;
                    }
                    this.hillMutator.lower(tile);
                    this.mountainMutator.raise(tile);
                }
                if (!tile.getTerrainFeatures().contains(lowering)) continue;
                tile.removeTerrainFeature(lowering);
                if (totalMountains * 2 <= targetMountains) continue;
                if (this.mountainMutator.isElevated(tile)) {
                    --totalMountains;
                }
                this.mountainMutator.lower(tile);
                this.hillMutator.raise(tile);
            }
        }
    }

    private final void cellularHills() {
        if (this.hillMutator instanceof TileDummyMutator) {
            return;
        }
        Object[] objectArray = new Object[]{this.hillMutator.getName()};
        Log.INSTANCE.debug("Hill-like generation for %s", objectArray);
        int targetHills = this.hillMutator.count((Iterable<Tile>)this.tileMap.getValues());
        for (int i = 1; i < 6; ++i) {
            int totalHills = this.hillMutator.count((Iterable<Tile>)this.tileMap.getValues());
            for (Tile tile : this.tileMap.getValues()) {
                if (tile.isWater() || this.mountainMutator.isElevated(tile)) continue;
                int adjacentMountains = this.mountainMutator.count(tile.getNeighbors());
                int adjacentHills = this.hillMutator.count(tile.getNeighbors());
                if (adjacentHills <= 1 && adjacentMountains == 0 && this.randomness.getRNG().nextInt(2) == 0) {
                    tile.addTerrainFeature(lowering);
                    continue;
                }
                if (adjacentHills > 3 && adjacentMountains == 0 && this.randomness.getRNG().nextInt(2) == 0) {
                    tile.addTerrainFeature(lowering);
                    continue;
                }
                int n = adjacentHills + adjacentMountains;
                boolean bl = 2 <= n ? n < 4 : false;
                if (!bl || this.randomness.getRNG().nextInt(2) != 0) continue;
                tile.addTerrainFeature(rising);
            }
            for (Tile tile : this.tileMap.getValues()) {
                if (tile.isWater() || this.mountainMutator.isElevated(tile)) continue;
                if (tile.getTerrainFeatures().contains(rising)) {
                    tile.removeTerrainFeature(rising);
                    if (totalHills > targetHills && i != 1) continue;
                    if (!this.hillMutator.isElevated(tile)) {
                        this.hillMutator.raise(tile);
                        ++totalHills;
                    }
                }
                if (!tile.getTerrainFeatures().contains(lowering)) continue;
                tile.removeTerrainFeature(lowering);
                if (!((float)totalHills >= (float)targetHills * 0.9f) && i != 1 || !this.hillMutator.isElevated(tile)) continue;
                this.hillMutator.lower(tile);
                --totalHills;
            }
        }
    }

    private static final double raiseMountainsAndHills$powSigned(double $this$raiseMountainsAndHills_u24powSigned, double exponent) {
        return Math.pow(Math.abs($this$raiseMountainsAndHills_u24powSigned), exponent) * Math.signum($this$raiseMountainsAndHills_u24powSigned);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapElevationGenerator$Companion;", "", "()V", "lowering", "", "rising", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\bb\u0018\u00002\u00020\u0001J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH&J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\nH&J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\nH&J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\rH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0014"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapElevationGenerator$ITileMutator;", "", "name", "", "getName", "()Ljava/lang/String;", "count", "", "tiles", "", "Lcom/unciv/logic/map/tile/Tile;", "Lkotlin/sequences/Sequence;", "isElevated", "", "tile", "lower", "", "raise", "setElevated", "value", "core"})
    private static interface ITileMutator {
        @NotNull
        public String getName();

        public void lower(@NotNull Tile var1);

        public void raise(@NotNull Tile var1);

        public boolean isElevated(@NotNull Tile var1);

        public void setElevated(@NotNull Tile var1, boolean var2);

        public int count(@NotNull Iterable<Tile> var1);

        public int count(@NotNull Sequence<Tile> var1);

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        @SourceDebugExtension(value={"SMAP\nMapElevationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapElevationGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapElevationGenerator$ITileMutator$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,213:1\n1774#2,4:214\n1250#3,3:218\n*S KotlinDebug\n*F\n+ 1 MapElevationGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapElevationGenerator$ITileMutator$DefaultImpls\n*L\n175#1:214,4\n176#1:218,3\n*E\n"})
        public static final class DefaultImpls {
            public static void setElevated(@NotNull ITileMutator $this, @NotNull Tile tile, boolean value) {
                Intrinsics.checkNotNullParameter(tile, "tile");
                if (value) {
                    $this.raise(tile);
                } else {
                    $this.lower(tile);
                }
            }

            public static int count(@NotNull ITileMutator $this, @NotNull Iterable<Tile> tiles2) {
                int n;
                Intrinsics.checkNotNullParameter(tiles2, "tiles");
                Iterable<Tile> $this$count$iv = tiles2;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    Iterator<Tile> iterator2 = $this$count$iv.iterator();
                    while (iterator2.hasNext()) {
                        Tile element$iv;
                        Tile it = element$iv = iterator2.next();
                        boolean bl = false;
                        if (!$this.isElevated(it) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                return n;
            }

            public static int count(@NotNull ITileMutator $this, @NotNull Sequence<Tile> tiles2) {
                Intrinsics.checkNotNullParameter(tiles2, "tiles");
                Sequence<Tile> $this$count$iv = tiles2;
                boolean $i$f$count = false;
                int count$iv = 0;
                Iterator<Tile> iterator2 = $this$count$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl = false;
                    if (!$this.isElevated(it) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                return count$iv;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapElevationGenerator$TileBaseMutator;", "Lcom/unciv/logic/map/mapgenerator/MapElevationGenerator$ITileMutator;", "flat", "", "elevated", "(Ljava/lang/String;Ljava/lang/String;)V", "name", "getName", "()Ljava/lang/String;", "isElevated", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "lower", "", "raise", "core"})
    private static final class TileBaseMutator
    implements ITileMutator {
        @NotNull
        private final String flat;
        @NotNull
        private final String elevated;

        public TileBaseMutator(@NotNull String flat, @NotNull String elevated) {
            Intrinsics.checkNotNullParameter(flat, "flat");
            Intrinsics.checkNotNullParameter(elevated, "elevated");
            this.flat = flat;
            this.elevated = elevated;
        }

        @Override
        @NotNull
        public String getName() {
            return this.elevated;
        }

        @Override
        public void lower(@NotNull Tile tile) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            tile.setBaseTerrain(this.flat);
        }

        @Override
        public void raise(@NotNull Tile tile) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            tile.setBaseTerrain(this.elevated);
        }

        @Override
        public boolean isElevated(@NotNull Tile tile) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            return Intrinsics.areEqual(tile.getBaseTerrain(), this.elevated);
        }

        @Override
        public void setElevated(@NotNull Tile tile, boolean value) {
            ITileMutator.DefaultImpls.setElevated(this, tile, value);
        }

        @Override
        public int count(@NotNull Iterable<Tile> tiles2) {
            return ITileMutator.DefaultImpls.count((ITileMutator)this, tiles2);
        }

        @Override
        public int count(@NotNull Sequence<Tile> tiles2) {
            return ITileMutator.DefaultImpls.count((ITileMutator)this, tiles2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapElevationGenerator$TileDummyMutator;", "Lcom/unciv/logic/map/mapgenerator/MapElevationGenerator$ITileMutator;", "()V", "name", "", "getName", "()Ljava/lang/String;", "isElevated", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "lower", "", "raise", "core"})
    private static final class TileDummyMutator
    implements ITileMutator {
        @Override
        @NotNull
        public String getName() {
            return "";
        }

        @Override
        public void lower(@NotNull Tile tile) {
            Intrinsics.checkNotNullParameter(tile, "tile");
        }

        @Override
        public void raise(@NotNull Tile tile) {
            Intrinsics.checkNotNullParameter(tile, "tile");
        }

        @Override
        public boolean isElevated(@NotNull Tile tile) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            return false;
        }

        @Override
        public void setElevated(@NotNull Tile tile, boolean value) {
            ITileMutator.DefaultImpls.setElevated(this, tile, value);
        }

        @Override
        public int count(@NotNull Iterable<Tile> tiles2) {
            return ITileMutator.DefaultImpls.count((ITileMutator)this, tiles2);
        }

        @Override
        public int count(@NotNull Sequence<Tile> tiles2) {
            return ITileMutator.DefaultImpls.count((ITileMutator)this, tiles2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapElevationGenerator$TileFeatureMutator;", "Lcom/unciv/logic/map/mapgenerator/MapElevationGenerator$ITileMutator;", "elevated", "", "(Ljava/lang/String;)V", "getElevated", "()Ljava/lang/String;", "name", "getName", "isElevated", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "lower", "", "raise", "core"})
    private static final class TileFeatureMutator
    implements ITileMutator {
        @NotNull
        private final String elevated;

        public TileFeatureMutator(@NotNull String elevated) {
            Intrinsics.checkNotNullParameter(elevated, "elevated");
            this.elevated = elevated;
        }

        @NotNull
        public final String getElevated() {
            return this.elevated;
        }

        @Override
        @NotNull
        public String getName() {
            return this.elevated;
        }

        @Override
        public void lower(@NotNull Tile tile) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            tile.removeTerrainFeature(this.elevated);
        }

        @Override
        public void raise(@NotNull Tile tile) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            tile.addTerrainFeature(this.elevated);
        }

        @Override
        public boolean isElevated(@NotNull Tile tile) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            return tile.getTerrainFeatures().contains(this.elevated);
        }

        @Override
        public void setElevated(@NotNull Tile tile, boolean value) {
            ITileMutator.DefaultImpls.setElevated(this, tile, value);
        }

        @Override
        public int count(@NotNull Iterable<Tile> tiles2) {
            return ITileMutator.DefaultImpls.count((ITileMutator)this, tiles2);
        }

        @Override
        public int count(@NotNull Sequence<Tile> tiles2) {
            return ITileMutator.DefaultImpls.count((ITileMutator)this, tiles2);
        }
    }
}

