/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator;

import com.unciv.Constants;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.MapSize;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.MapElevationGenerator;
import com.unciv.logic.map.mapgenerator.MapGenerationRandomness;
import com.unciv.logic.map.mapgenerator.MapGenerator;
import com.unciv.logic.map.mapgenerator.MapLandmassGenerator;
import com.unciv.logic.map.mapgenerator.NaturalWonderGenerator;
import com.unciv.logic.map.mapgenerator.RiverGenerator;
import com.unciv.logic.map.mapgenerator.mapregions.MapRegions;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileNormalizer;
import com.unciv.models.Counter;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.screens.mapeditorscreen.MapGeneratorSteps;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 K2\u00020\u0001:\u0003KLMB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J(\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0016\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\n2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00110-H\u0002J0\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020%2\u0006\u00101\u001a\u00020%2\u0006\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020'H\u0002J,\u00104\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u00172\u0006\u00105\u001a\u00020\n2\b\u00106\u001a\u0004\u0018\u00010\n2\b\u00107\u001a\u0004\u0018\u00010\nH\u0002J2\u00108\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u00172\f\u00109\u001a\b\u0012\u0004\u0012\u00020\n0\u001e2\b\u00106\u001a\u0004\u0018\u00010\n2\b\u00107\u001a\u0004\u0018\u00010\nH\u0002J\u001e\u0010:\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u001eH\u0002J\u0010\u0010=\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010>\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0013H\u0002J\u0010\u0010?\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010@\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010A\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0013H\u0002J\u0010\u0010B\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0013H\u0002J\u0010\u0010C\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010C\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0002J\u0018\u0010H\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010D\u001a\u00020EH\u0002J\u0012\u0010I\u001a\b\u0012\u0004\u0012\u00020<0J*\u00020\bH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator;", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/unciv/models/ruleset/Ruleset;Lkotlinx/coroutines/CoroutineScope;)V", "firstLandTerrain", "Lcom/unciv/models/ruleset/tile/Terrain;", "landTerrainName", "", "randomness", "Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "waterTerrainName", "applyHumidityAndTemperature", "", "tileMap", "Lcom/unciv/logic/map/TileMap;", "convertTerrains", "tiles", "", "Lcom/unciv/logic/map/tile/Tile;", "generateMap", "mapParameters", "Lcom/unciv/logic/map/MapParameters;", "gameParameters", "Lcom/unciv/models/metadata/GameParameters;", "civilizations", "", "Lcom/unciv/logic/civilization/Civilization;", "generateSingleStep", "map", "step", "Lcom/unciv/ui/screens/mapeditorscreen/MapGeneratorSteps;", "getTemperatureAtRadius", "", "radius", "", "getTileRadius", "tile", "runAndMeasure", "text", "action", "Lkotlin/Function0;", "scaleToRange", "x1", "x2", "y1", "y2", "value", "spawnFlatEarthCenterIceWall", "bestArcticTileName", "iceTerrainName", "mountainTerrainName", "spawnFlatEarthEdgeIceWall", "arcticTileNameList", "spawnFlatEarthIceWalls", "iceEquivalents", "Lcom/unciv/logic/map/mapgenerator/MapGenerator$TerrainOccursRange;", "spawnIce", "spawnLakesAndCoasts", "spawnRareFeatures", "spawnVegetation", "spreadAncientRuins", "spreadCoast", "spreadResources", "mapRadius", "", "resourceType", "Lcom/unciv/models/ruleset/tile/ResourceType;", "spreadStrategicResources", "getGenerationConditions", "Lkotlin/sequences/Sequence;", "Companion", "Helpers", "TerrainOccursRange", "core"})
@SourceDebugExtension(value={"SMAP\nMapGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,785:1\n223#2,2:786\n766#2:788\n857#2,2:789\n766#2:791\n857#2,2:792\n766#2:801\n857#2,2:802\n766#2:804\n857#2,2:805\n766#2:807\n857#2:808\n858#2:811\n1774#2,4:812\n819#2:816\n847#2,2:817\n766#2:819\n857#2,2:820\n766#2:822\n857#2,2:823\n819#2:825\n847#2,2:826\n766#2:828\n857#2:829\n1747#2,3:832\n858#2:835\n1774#2,4:836\n766#2:840\n857#2,2:841\n2333#2,14:843\n766#2:857\n857#2,2:858\n1373#2:860\n1461#2,5:861\n288#2,2:869\n766#2:884\n857#2,2:885\n1360#2:887\n1446#2,5:888\n766#2:893\n857#2:894\n858#2:897\n766#2:898\n857#2,2:899\n766#2:901\n857#2,2:902\n766#2:904\n857#2,2:905\n1549#2:907\n1620#2,3:908\n766#2:911\n857#2,2:912\n1549#2:914\n1620#2,3:915\n766#2:918\n857#2,2:919\n1549#2:921\n1620#2,3:922\n288#2,2:925\n515#3:794\n500#3,6:795\n2141#4,2:809\n2141#4,2:830\n1137#4,3:866\n2141#4,2:895\n11653#5,9:871\n13579#5:880\n13580#5:882\n11662#5:883\n1#6:881\n*S KotlinDebug\n*F\n+ 1 MapGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapGenerator\n*L\n55#1:786,2\n246#1:788\n246#1:789,2\n272#1:791\n272#1:792,2\n315#1:801\n315#1:802,2\n336#1:804\n336#1:805,2\n339#1:807\n339#1:808\n339#1:811\n341#1:812,4\n346#1:816\n346#1:817,2\n347#1:819\n347#1:820,2\n361#1:822\n361#1:823,2\n364#1:825\n364#1:826,2\n365#1:828\n365#1:829\n367#1:832,3\n365#1:835\n369#1:836,4\n376#1:840\n376#1:841,2\n378#1:843,14\n403#1:857\n403#1:858,2\n404#1:860\n404#1:861,5\n452#1:869,2\n530#1:884\n530#1:885,2\n531#1:887\n531#1:888,5\n539#1:893\n539#1:894\n539#1:897\n557#1:898\n557#1:899,2\n562#1:901\n562#1:902,2\n611#1:904\n611#1:905,2\n614#1:907\n614#1:908,3\n623#1:911\n623#1:912,2\n625#1:914\n625#1:915,3\n647#1:918\n647#1:919,2\n649#1:921\n649#1:922,3\n660#1:925,2\n312#1:794\n312#1:795,6\n340#1:809,2\n366#1:830,2\n409#1:866,3\n541#1:895,2\n529#1:871,9\n529#1:880\n529#1:882\n529#1:883\n529#1:881\n*E\n"})
public final class MapGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ruleset ruleset;
    @Nullable
    private final CoroutineScope coroutineScope;
    @NotNull
    private final String landTerrainName;
    @NotNull
    private final String waterTerrainName;
    @NotNull
    private MapGenerationRandomness randomness;
    @NotNull
    private final Terrain firstLandTerrain;
    private static final boolean consoleTimings = false;

    /*
     * WARNING - void declaration
     */
    public MapGenerator(@NotNull Ruleset ruleset2, @Nullable CoroutineScope coroutineScope) {
        Object element$iv2;
        block3: {
            void $this$first$iv;
            String string;
            MapGenerator mapGenerator;
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            this.ruleset = ruleset2;
            this.coroutineScope = coroutineScope;
            this.landTerrainName = MapLandmassGenerator.Companion.getInitializationTerrain$core(this.ruleset, TerrainType.Land);
            MapGenerator mapGenerator2 = this;
            try {
                mapGenerator = mapGenerator2;
                string = MapLandmassGenerator.Companion.getInitializationTerrain$core(this.ruleset, TerrainType.Water);
            }
            catch (Exception exception2) {
                mapGenerator = mapGenerator2;
                string = this.landTerrainName;
            }
            mapGenerator.waterTerrainName = string;
            this.randomness = new MapGenerationRandomness();
            Collection<Terrain> collection = this.ruleset.getTerrains().values();
            Intrinsics.checkNotNullExpressionValue(collection, "ruleset.terrains.values");
            Iterable _ = collection;
            mapGenerator2 = this;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Terrain it = (Terrain)element$iv2;
                boolean bl = false;
                if (!(it.getType() == TerrainType.Land)) continue;
                break block3;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        Intrinsics.checkNotNullExpressionValue(t, "ruleset.terrains.values.\u2026.type==TerrainType.Land }");
        mapGenerator2.firstLandTerrain = (Terrain)t;
    }

    public /* synthetic */ MapGenerator(Ruleset ruleset2, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineScope = null;
        }
        this(ruleset2, coroutineScope);
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    private final Sequence<TerrainOccursRange> getGenerationConditions(Terrain $this$getGenerationConditions) {
        return SequencesKt.map(IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)$this$getGenerationConditions, UniqueType.TileGenerationConditions, null, 2, null), (Function1)new Function1<Unique, TerrainOccursRange>($this$getGenerationConditions){
            final /* synthetic */ Terrain $this_getGenerationConditions;
            {
                this.$this_getGenerationConditions = $receiver;
                super(1);
            }

            @NotNull
            public final TerrainOccursRange invoke(@NotNull Unique unique) {
                Intrinsics.checkNotNullParameter(unique, "unique");
                return new TerrainOccursRange(this.$this_getGenerationConditions, unique);
            }
        });
    }

    @NotNull
    public final TileMap generateMap(@NotNull MapParameters mapParameters, @NotNull GameParameters gameParameters, @NotNull List<Civilization> civilizations) {
        Intrinsics.checkNotNullParameter(mapParameters, "mapParameters");
        Intrinsics.checkNotNullParameter(gameParameters, "gameParameters");
        Intrinsics.checkNotNullParameter(civilizations, "civilizations");
        MapSize mapSize = mapParameters.getMapSize();
        String mapType = mapParameters.getType();
        if (mapParameters.getSeed() == 0L) {
            mapParameters.setSeed(System.currentTimeMillis());
        }
        this.randomness.seedRNG(mapParameters.getSeed());
        TileMap map2 = Intrinsics.areEqual(mapParameters.getShape(), "Rectangular") ? new TileMap(mapSize.getWidth(), mapSize.getHeight(), this.ruleset, mapParameters.getWorldWrap()) : new TileMap(mapSize.getRadius(), this.ruleset, mapParameters.getWorldWrap());
        mapParameters.setCreatedWithVersion(UncivGame.Companion.getVERSION().toNiceString());
        map2.setMapParameters(mapParameters);
        if (Intrinsics.areEqual(mapType, "Empty")) {
            for (Tile tile : map2.getValues()) {
                tile.setBaseTerrain("Ocean");
                tile.setTerrainTransients();
            }
            return map2;
        }
        this.runAndMeasure("MapLandmassGenerator", new Function0<Unit>(map2, this){
            final /* synthetic */ TileMap $map;
            final /* synthetic */ MapGenerator this$0;
            {
                this.$map = $map;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                new MapLandmassGenerator(this.$map, this.this$0.getRuleset(), MapGenerator.access$getRandomness$p(this.this$0)).generateLand();
            }
        });
        this.runAndMeasure("raiseMountainsAndHills", new Function0<Unit>(map2, this){
            final /* synthetic */ TileMap $map;
            final /* synthetic */ MapGenerator this$0;
            {
                this.$map = $map;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                new MapElevationGenerator(this.$map, this.this$0.getRuleset(), MapGenerator.access$getRandomness$p(this.this$0)).raiseMountainsAndHills();
            }
        });
        this.runAndMeasure("applyHumidityAndTemperature", new Function0<Unit>(this, map2){
            final /* synthetic */ MapGenerator this$0;
            final /* synthetic */ TileMap $map;
            {
                this.this$0 = $receiver;
                this.$map = $map;
                super(0);
            }

            public final void invoke() {
                MapGenerator.access$applyHumidityAndTemperature(this.this$0, this.$map);
            }
        });
        this.runAndMeasure("spawnLakesAndCoasts", new Function0<Unit>(this, map2){
            final /* synthetic */ MapGenerator this$0;
            final /* synthetic */ TileMap $map;
            {
                this.this$0 = $receiver;
                this.$map = $map;
                super(0);
            }

            public final void invoke() {
                MapGenerator.access$spawnLakesAndCoasts(this.this$0, this.$map);
            }
        });
        this.runAndMeasure("spawnVegetation", new Function0<Unit>(this, map2){
            final /* synthetic */ MapGenerator this$0;
            final /* synthetic */ TileMap $map;
            {
                this.this$0 = $receiver;
                this.$map = $map;
                super(0);
            }

            public final void invoke() {
                MapGenerator.access$spawnVegetation(this.this$0, this.$map);
            }
        });
        this.runAndMeasure("spawnRareFeatures", new Function0<Unit>(this, map2){
            final /* synthetic */ MapGenerator this$0;
            final /* synthetic */ TileMap $map;
            {
                this.this$0 = $receiver;
                this.$map = $map;
                super(0);
            }

            public final void invoke() {
                MapGenerator.access$spawnRareFeatures(this.this$0, this.$map);
            }
        });
        this.runAndMeasure("spawnIce", new Function0<Unit>(this, map2){
            final /* synthetic */ MapGenerator this$0;
            final /* synthetic */ TileMap $map;
            {
                this.this$0 = $receiver;
                this.$map = $map;
                super(0);
            }

            public final void invoke() {
                MapGenerator.access$spawnIce(this.this$0, this.$map);
            }
        });
        this.runAndMeasure("assignContinents", new Function0<Unit>(map2){
            final /* synthetic */ TileMap $map;
            {
                this.$map = $map;
                super(0);
            }

            public final void invoke() {
                this.$map.assignContinents(TileMap.AssignContinentsMode.Assign);
            }
        });
        this.runAndMeasure("RiverGenerator", new Function0<Unit>(map2, this){
            final /* synthetic */ TileMap $map;
            final /* synthetic */ MapGenerator this$0;
            {
                this.$map = $map;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RiverGenerator.spawnRivers$default(new RiverGenerator(this.$map, MapGenerator.access$getRandomness$p(this.this$0), this.this$0.getRuleset()), null, 1, null);
            }
        });
        this.convertTerrains((Iterable<Tile>)map2.getValues());
        if (!((Collection)civilizations).isEmpty()) {
            MapRegions regions = new MapRegions(this.ruleset);
            this.runAndMeasure("generateRegions", new Function0<Unit>(regions, map2, civilizations, this){
                final /* synthetic */ MapRegions $regions;
                final /* synthetic */ TileMap $map;
                final /* synthetic */ List<Civilization> $civilizations;
                final /* synthetic */ MapGenerator this$0;
                {
                    this.$regions = $regions;
                    this.$map = $map;
                    this.$civilizations = $civilizations;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    int n;
                    void $this$count$iv;
                    Iterable iterable = this.$civilizations;
                    MapGenerator mapGenerator = this.this$0;
                    TileMap tileMap = this.$map;
                    MapRegions mapRegions = this.$regions;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (T element$iv : $this$count$iv) {
                            Civilization it = (Civilization)element$iv;
                            boolean bl = false;
                            Nation nation2 = mapGenerator.getRuleset().getNations().get(it.getCivName());
                            Intrinsics.checkNotNull(nation2);
                            if (!nation2.isMajorCiv() || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    int n2 = n;
                    mapRegions.generateRegions(tileMap, n2);
                }
            });
            this.runAndMeasure("assignRegions", new Function0<Unit>(regions, map2, civilizations, gameParameters, this){
                final /* synthetic */ MapRegions $regions;
                final /* synthetic */ TileMap $map;
                final /* synthetic */ List<Civilization> $civilizations;
                final /* synthetic */ GameParameters $gameParameters;
                final /* synthetic */ MapGenerator this$0;
                {
                    this.$regions = $regions;
                    this.$map = $map;
                    this.$civilizations = $civilizations;
                    this.$gameParameters = $gameParameters;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable = this.$civilizations;
                    MapGenerator mapGenerator = this.this$0;
                    TileMap tileMap = this.$map;
                    MapRegions mapRegions = this.$regions;
                    boolean $i$f$filter = false;
                    void var4_6 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Civilization it = (Civilization)element$iv$iv;
                        boolean bl = false;
                        Nation nation2 = mapGenerator.getRuleset().getNations().get(it.getCivName());
                        Intrinsics.checkNotNull(nation2);
                        if (!nation2.isMajorCiv()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List list2 = (List)destination$iv$iv;
                    mapRegions.assignRegions(tileMap, list2, this.$gameParameters);
                }
            });
            this.runAndMeasure("NaturalWonderGenerator", new Function0<Unit>(this, map2){
                final /* synthetic */ MapGenerator this$0;
                final /* synthetic */ TileMap $map;
                {
                    this.this$0 = $receiver;
                    this.$map = $map;
                    super(0);
                }

                public final void invoke() {
                    new NaturalWonderGenerator(this.this$0.getRuleset(), MapGenerator.access$getRandomness$p(this.this$0)).spawnNaturalWonders(this.$map);
                }
            });
            this.runAndMeasure("placeResourcesAndMinorCivs", new Function0<Unit>(regions, map2, civilizations, this){
                final /* synthetic */ MapRegions $regions;
                final /* synthetic */ TileMap $map;
                final /* synthetic */ List<Civilization> $civilizations;
                final /* synthetic */ MapGenerator this$0;
                {
                    this.$regions = $regions;
                    this.$map = $map;
                    this.$civilizations = $civilizations;
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable = this.$civilizations;
                    MapGenerator mapGenerator = this.this$0;
                    TileMap tileMap = this.$map;
                    MapRegions mapRegions = this.$regions;
                    boolean $i$f$filter = false;
                    void var4_6 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Civilization it = (Civilization)element$iv$iv;
                        boolean bl = false;
                        Nation nation2 = mapGenerator.getRuleset().getNations().get(it.getCivName());
                        Intrinsics.checkNotNull(nation2);
                        if (!nation2.isCityState()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List list2 = (List)destination$iv$iv;
                    mapRegions.placeResourcesAndMinorCivs(tileMap, list2);
                }
            });
        } else {
            this.runAndMeasure("NaturalWonderGenerator", new Function0<Unit>(this, map2){
                final /* synthetic */ MapGenerator this$0;
                final /* synthetic */ TileMap $map;
                {
                    this.this$0 = $receiver;
                    this.$map = $map;
                    super(0);
                }

                public final void invoke() {
                    new NaturalWonderGenerator(this.this$0.getRuleset(), MapGenerator.access$getRandomness$p(this.this$0)).spawnNaturalWonders(this.$map);
                }
            });
            this.runAndMeasure("spreadResources", new Function0<Unit>(this, map2){
                final /* synthetic */ MapGenerator this$0;
                final /* synthetic */ TileMap $map;
                {
                    this.this$0 = $receiver;
                    this.$map = $map;
                    super(0);
                }

                public final void invoke() {
                    MapGenerator.access$spreadResources(this.this$0, this.$map);
                }
            });
        }
        this.runAndMeasure("spreadAncientRuins", new Function0<Unit>(this, map2){
            final /* synthetic */ MapGenerator this$0;
            final /* synthetic */ TileMap $map;
            {
                this.this$0 = $receiver;
                this.$map = $map;
                super(0);
            }

            public final void invoke() {
                MapGenerator.access$spreadAncientRuins(this.this$0, this.$map);
            }
        });
        for (Tile tile : map2.getValues()) {
            TileNormalizer.INSTANCE.normalizeToRuleset(tile, this.ruleset);
        }
        return map2;
    }

    public static /* synthetic */ TileMap generateMap$default(MapGenerator mapGenerator, MapParameters mapParameters, GameParameters gameParameters, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            gameParameters = new GameParameters();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return mapGenerator.generateMap(mapParameters, gameParameters, list2);
    }

    public final void generateSingleStep(@NotNull TileMap map2, @NotNull MapGeneratorSteps step) {
        Intrinsics.checkNotNullParameter(map2, "map");
        Intrinsics.checkNotNullParameter((Object)step, "step");
        if (map2.getMapParameters().getSeed() == 0L) {
            map2.getMapParameters().setSeed(System.currentTimeMillis());
        }
        this.randomness.seedRNG(map2.getMapParameters().getSeed());
        this.runAndMeasure("SingleStep " + (Object)((Object)step), new Function0<Unit>(step, map2, this){
            final /* synthetic */ MapGeneratorSteps $step;
            final /* synthetic */ TileMap $map;
            final /* synthetic */ MapGenerator this$0;
            {
                this.$step = $step;
                this.$map = $map;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                switch (generateSingleStep.WhenMappings.$EnumSwitchMapping$0[this.$step.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        throw new IllegalArgumentException("MapGeneratorSteps.All cannot be used in generateSingleStep");
                    }
                    case 3: {
                        new MapLandmassGenerator(this.$map, this.this$0.getRuleset(), MapGenerator.access$getRandomness$p(this.this$0)).generateLand();
                        break;
                    }
                    case 4: {
                        new MapElevationGenerator(this.$map, this.this$0.getRuleset(), MapGenerator.access$getRandomness$p(this.this$0)).raiseMountainsAndHills();
                        break;
                    }
                    case 5: {
                        MapGenerator.access$applyHumidityAndTemperature(this.this$0, this.$map);
                        break;
                    }
                    case 6: {
                        MapGenerator.access$spawnLakesAndCoasts(this.this$0, this.$map);
                        break;
                    }
                    case 7: {
                        MapGenerator.access$spawnVegetation(this.this$0, this.$map);
                        break;
                    }
                    case 8: {
                        MapGenerator.access$spawnRareFeatures(this.this$0, this.$map);
                        break;
                    }
                    case 9: {
                        MapGenerator.access$spawnIce(this.this$0, this.$map);
                        break;
                    }
                    case 10: {
                        this.$map.assignContinents(TileMap.AssignContinentsMode.Reassign);
                        break;
                    }
                    case 11: {
                        new NaturalWonderGenerator(this.this$0.getRuleset(), MapGenerator.access$getRandomness$p(this.this$0)).spawnNaturalWonders(this.$map);
                        break;
                    }
                    case 12: {
                        Set resultingTiles = new LinkedHashSet<E>();
                        new RiverGenerator(this.$map, MapGenerator.access$getRandomness$p(this.this$0), this.this$0.getRuleset()).spawnRivers(resultingTiles);
                        this.this$0.convertTerrains(resultingTiles);
                        break;
                    }
                    case 13: {
                        MapGenerator.access$spreadResources(this.this$0, this.$map);
                        break;
                    }
                    case 14: {
                        MapGenerator.access$spreadAncientRuins(this.this$0, this.$map);
                    }
                }
            }
        });
    }

    private final void runAndMeasure(String text2, Function0<Unit> action2) {
        CoroutineScope coroutineScope = this.coroutineScope;
        boolean bl = coroutineScope != null ? !CoroutineScopeKt.isActive(coroutineScope) : false;
        if (bl) {
            return;
        }
        action2.invoke();
    }

    public final void convertTerrains(@NotNull Iterable<Tile> tiles2) {
        Intrinsics.checkNotNullParameter(tiles2, "tiles");
        Helpers.INSTANCE.convertTerrains(this.ruleset, tiles2);
    }

    /*
     * WARNING - void declaration
     */
    private final void spreadCoast(TileMap map2) {
        int i = 1;
        int n = map2.getMapParameters().getMaxCoastExtension();
        if (i <= n) {
            while (true) {
                void $this$filterTo$iv$iv;
                List toCoast = new ArrayList();
                Iterable $this$filter$iv = map2.getValues();
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Tile it = (Tile)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getBaseTerrain(), "Ocean")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                block2: for (Tile tile : (List)destination$iv$iv) {
                    Sequence<Tile> tilesInDistance = tile.getTilesInDistance(1);
                    object = tilesInDistance.iterator();
                    while (object.hasNext()) {
                        Tile neighborTile = (Tile)object.next();
                        if (neighborTile.isLand()) {
                            toCoast.add(tile);
                            continue block2;
                        }
                        if (!Intrinsics.areEqual(neighborTile.getBaseTerrain(), "Coast")) continue;
                        boolean randbool = this.randomness.getRNG().nextBoolean();
                        if (!randbool) continue block2;
                        toCoast.add(tile);
                        continue block2;
                    }
                }
                for (Tile tile : toCoast) {
                    tile.setBaseTerrain("Coast");
                    tile.setTransients();
                }
                if (i == n) break;
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnLakesAndCoasts(TileMap map2) {
        if (this.ruleset.getTerrains().containsKey("Lakes")) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = map2.getValues();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Tile it = (Tile)element$iv$iv;
                boolean bl = false;
                if (!it.isWater()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List<Tile> waterTiles2 = CollectionsKt.toMutableList((List)destination$iv$iv);
            ArrayList<Tile> tilesInArea = new ArrayList<Tile>();
            ArrayList tilesToCheck = new ArrayList();
            int maxLakeSize = this.ruleset.getModOptions().getConstants().getMaxLakeSize();
            while (!((Collection)waterTiles2).isEmpty()) {
                Tile initialWaterTile = (Tile)CollectionsKt.removeFirst(waterTiles2);
                ((Collection)tilesInArea).add(initialWaterTile);
                ((Collection)tilesToCheck).add(initialWaterTile);
                while (!((Collection)tilesToCheck).isEmpty()) {
                    Tile tileWeAreChecking = (Tile)CollectionsKt.removeFirst(tilesToCheck);
                    Iterator<Object> iterator2 = SequencesKt.filter(tileWeAreChecking.getNeighbors(), (Function1)new Function1<Tile, Boolean>(tilesInArea, waterTiles2){
                        final /* synthetic */ ArrayList<Tile> $tilesInArea;
                        final /* synthetic */ List<Tile> $waterTiles;
                        {
                            this.$tilesInArea = $tilesInArea;
                            this.$waterTiles = $waterTiles;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull Tile it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return !this.$tilesInArea.contains(it) & this.$waterTiles.contains(it);
                        }
                    }).iterator();
                    while (iterator2.hasNext()) {
                        Tile vector = (Tile)iterator2.next();
                        ((Collection)tilesInArea).add(vector);
                        ((Collection)tilesToCheck).add(vector);
                        ((Collection)waterTiles2).remove(vector);
                    }
                }
                if (tilesInArea.size() <= maxLakeSize) {
                    for (Tile tile : tilesInArea) {
                        tile.setBaseTerrain("Lakes");
                        tile.setTransients();
                    }
                }
                tilesInArea.clear();
            }
        }
        if (this.ruleset.getTerrains().containsKey("Coast")) {
            this.spreadCoast(map2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void spreadAncientRuins(TileMap map2) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Map $this$filter$iv = this.ruleset.getTileImprovements();
        boolean $i$f$filter = false;
        Map map3 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!((TileImprovement)it.getValue()).isAncientRuinsEquivalent()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map ruinsEquivalents = destination$iv$iv;
        if (map2.getMapParameters().getNoRuins() || ruinsEquivalents.isEmpty()) {
            return;
        }
        Iterable $this$filter$iv2 = map2.getValues();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tile it = (Tile)element$iv$iv;
            boolean bl = false;
            if (!(it.isLand() && !it.isImpassible())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List suitableTiles = (List)destination$iv$iv2;
        ArrayList<Tile> locations = this.randomness.chooseSpreadOutLocations(MathKt.roundToInt((float)suitableTiles.size() * this.ruleset.getModOptions().getConstants().getAncientRuinCountMultiplier()), suitableTiles, map2.getMapParameters().getMapSize().getRadius());
        for (Tile tile : locations) {
            tile.setImprovement((String)CollectionsKt.random(ruinsEquivalents.keySet(), Random.Default));
        }
    }

    private final void spreadResources(TileMap tileMap) {
        int mapRadius = tileMap.getMapParameters().getMapSize().getRadius();
        for (Tile tile : tileMap.getValues()) {
            tile.setResource(null);
        }
        this.spreadStrategicResources(tileMap, mapRadius);
        this.spreadResources(tileMap, mapRadius, ResourceType.Luxury);
        this.spreadResources(tileMap, mapRadius, ResourceType.Bonus);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void spreadStrategicResources(TileMap tileMap, int mapRadius) {
        v0 = this.ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(v0, "ruleset.tileResources.values");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var6_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TileResource)element$iv$iv;
            $i$a$-filter-MapGenerator$spreadStrategicResources$strategicResources$1 = false;
            if (!(it.getResourceType() == ResourceType.Strategic)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        strategicResources = (List)destination$iv$iv;
        $this$filter$iv = tileMap.getValues();
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            block12: {
                it = (Tile)element$iv$iv;
                $i$a$-filter-MapGenerator$spreadStrategicResources$candidateTiles$1 = false;
                if (it.getResource() != null || it.isImpassible()) ** GOTO lbl-1000
                $this$none$iv = it.getNeighbors();
                $i$f$none = false;
                var16_36 = $this$none$iv.iterator();
                while (var16_36.hasNext()) {
                    neighbor = element$iv = var16_36.next();
                    $i$a$-none-MapGenerator$spreadStrategicResources$candidateTiles$1$1 = false;
                    if (!neighbor.isNaturalWonder()) continue;
                    v1 = false;
                    break block12;
                }
                v1 = true;
            }
            if (v1) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        candidateTiles = (List)destination$iv$iv;
        $this$count$iv = candidateTiles;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v3 = 0;
        } else {
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = (Tile)element$iv /* !! */ ;
                $i$a$-count-MapGenerator$spreadStrategicResources$totalNumberOfResources$1 = false;
                if (!it.isLand() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v3 = count$iv;
        }
        totalNumberOfResources = (float)v3 * tileMap.getMapParameters().getResourceRichness();
        resourcesPerType = (int)(totalNumberOfResources / (float)strategicResources.size());
        for (TileResource resource : strategicResources) {
            element$iv /* !! */  = candidateTiles;
            $i$f$filterNot = false;
            $i$a$-count-MapGenerator$spreadStrategicResources$totalNumberOfResources$1 = $this$filterNot$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterNotTo = false;
            for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (Tile)element$iv$iv;
                $i$a$-filterNot-MapGenerator$spreadStrategicResources$suitableTiles$1 = false;
                if (Intrinsics.areEqual(it.getBaseTerrain(), "Snow") != false && it.isHill() != false) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterNotTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Tile)element$iv$iv;
                $i$a$-filter-MapGenerator$spreadStrategicResources$suitableTiles$2 = false;
                if (!(it.getResource() == null && resource.generatesNaturallyOn(it) != false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            suitableTiles = (List)destination$iv$iv;
            locations = this.randomness.chooseSpreadOutLocations(resourcesPerType, suitableTiles, mapRadius);
            for (Tile location : locations) {
                Intrinsics.checkNotNullExpressionValue(location, "location");
                Intrinsics.checkNotNullExpressionValue(resource, "resource");
                Tile.setTileResource$default(location, resource, null, this.randomness.getRNG(), 2, null);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void spreadResources(TileMap tileMap, int mapRadius, ResourceType resourceType) {
        v0 = this.ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(v0, "ruleset.tileResources.values");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var7_8 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TileResource)element$iv$iv;
            $i$a$-filter-MapGenerator$spreadResources$resourcesOfType$1 = false;
            if (!(it.getResourceType() == resourceType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        resourcesOfType = (List)destination$iv$iv;
        $i$f$filter = tileMap.getValues();
        $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (E element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Tile)element$iv$iv;
            $i$a$-filterNot-MapGenerator$spreadResources$suitableTiles$1 = false;
            if (Intrinsics.areEqual(it.getBaseTerrain(), "Snow") != false && it.isHill() != false) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            block20: {
                block19: {
                    it = (Tile)element$iv$iv;
                    $i$a$-filter-MapGenerator$spreadResources$suitableTiles$2 = false;
                    if (it.getResource() != null) ** GOTO lbl-1000
                    $this$none$iv = it.getNeighbors();
                    $i$f$none = false;
                    var17_39 = $this$none$iv.iterator();
                    while (var17_39.hasNext()) {
                        neighbor = element$iv = var17_39.next();
                        $i$a$-none-MapGenerator$spreadResources$suitableTiles$2$1 = false;
                        if (!neighbor.isNaturalWonder()) continue;
                        v1 = false;
                        break block19;
                    }
                    v1 = true;
                }
                if (!v1) ** GOTO lbl-1000
                $this$any$iv = resourcesOfType;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (Tile element$iv : $this$any$iv) {
                        r = (TileResource)element$iv;
                        $i$a$-any-MapGenerator$spreadResources$suitableTiles$2$2 = false;
                        if (!r.generatesNaturallyOn(it)) continue;
                        v2 = true;
                        break block20;
                    }
                    v2 = false;
                }
            }
            if (v2) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        suitableTiles = (List)destination$iv$iv;
        $this$count$iv = tileMap.getValues();
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v4 = 0;
        } else {
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = (Tile)element$iv;
                $i$a$-count-MapGenerator$spreadResources$numberOfResources$1 = false;
                if (!(it.isLand() != false && it.isImpassible() == false) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v4 = count$iv;
        }
        numberOfResources = (float)v4 * tileMap.getMapParameters().getResourceRichness();
        locations = this.randomness.chooseSpreadOutLocations((int)numberOfResources, suitableTiles, mapRadius);
        resourceToNumber = new Counter<String>(null, 1, null);
        for (Tile tile : locations) {
            $this$filter$iv = resourcesOfType;
            $i$f$filter = false;
            $i$a$-filter-MapGenerator$spreadResources$suitableTiles$2 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (TileResource)element$iv$iv;
                $i$a$-filter-MapGenerator$spreadResources$possibleResources$1 = false;
                Intrinsics.checkNotNullExpressionValue(tile, "tile");
                if (!it.generatesNaturallyOn(tile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            possibleResources = (List)destination$iv$iv;
            if (possibleResources.isEmpty()) continue;
            $this$minByOrNull$iv = possibleResources;
            $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v5 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v5 = minElem$iv;
                } else {
                    it = (TileResource)minElem$iv;
                    $i$a$-minByOrNull-MapGenerator$spreadResources$resourceWithLeastAssignments$1 = false;
                    minValue$iv = ((Number)resourceToNumber.get((Object)it.getName())).intValue();
                    do {
                        e$iv = iterator$iv.next();
                        it = (TileResource)e$iv;
                        $i$a$-minByOrNull-MapGenerator$spreadResources$resourceWithLeastAssignments$1 = false;
                        v$iv = ((Number)resourceToNumber.get((Object)it.getName())).intValue();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v5 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v5);
            resourceWithLeastAssignments = v5;
            resourceToNumber.add(resourceWithLeastAssignments.getName(), 1);
            Intrinsics.checkNotNullExpressionValue(tile, "tile");
            Tile.setTileResource$default(tile, resourceWithLeastAssignments, null, this.randomness.getRNG(), 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyHumidityAndTemperature(TileMap tileMap) {
        void destination$iv;
        void $this$mapTo$iv;
        Object list$iv$iv;
        Sequence $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Terrain it;
        void $this$filterTo$iv$iv;
        double humiditySeed = this.randomness.getRNG().nextInt();
        double temperatureSeed = this.randomness.getRNG().nextInt();
        TileMap.setTransients$default(tileMap, this.ruleset, false, 2, null);
        double scale = tileMap.getMapParameters().getTilesPerBiomeArea();
        float temperatureExtremeness = tileMap.getMapParameters().getTemperatureExtremeness();
        float temperatureShift = tileMap.getMapParameters().getTemperatureShift();
        float humidityShift = temperatureShift > 0.0f ? -temperatureShift / (float)2 : 0.0f;
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "ruleset.terrains.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Terrain)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == TerrainType.Land)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapSequence = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            element$iv$iv = iterator2.next();
            it = (Terrain)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            list$iv$iv = this.getGenerationConditions(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List limitsMap = (List)destination$iv$iv;
        boolean noTerrainUniques = limitsMap.isEmpty();
        Collection<Terrain> collection2 = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "ruleset.terrains.values");
        $this$flatMapTo$iv$iv = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection2), applyHumidityAndTemperature.elevationTerrains.1.INSTANCE);
        destination$iv$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            list$iv$iv = (Terrain)item$iv;
            void var32_23 = destination$iv;
            boolean bl = false;
            var32_23.add(it.getName());
        }
        Set elevationTerrains2 = (Set)destination$iv;
        if (elevationTerrains2.isEmpty()) {
            elevationTerrains2.add("Mountain");
        }
        object = CollectionsKt.asSequence((Iterable)tileMap.getValues()).iterator();
        while (object.hasNext()) {
            TerrainOccursRange matchingTerrain;
            Object v4;
            Object[] objectArray;
            double temperature;
            double humidity;
            Tile tile;
            block18: {
                double d;
                tile = (Tile)object.next();
                if (tile.isWater() || elevationTerrains2.contains(tile.getBaseTerrain())) continue;
                double humidityRandom = MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, humiditySeed, 1, 0.0, 0.0, scale, 24, null);
                humidity = ((Number)RangesKt.coerceIn((Comparable)Double.valueOf((humidityRandom + 1.0) / 2.0 + (double)humidityShift), RangesKt.rangeTo(0.0, 1.0))).doubleValue();
                if (tileMap.getMapParameters().getShape() == "Flat Earth Hexagonal") {
                    double radiusTemperature;
                    float radius = this.getTileRadius(tile, tileMap);
                    d = radiusTemperature = this.getTemperatureAtRadius(radius);
                } else {
                    double latitudeTemperature;
                    d = latitudeTemperature = 1.0 - 2.0 * (double)Math.abs(tile.getLatitude()) / (double)tileMap.getMaxLatitude();
                }
                double expectedTemperature = d;
                double randomTemperature = MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, temperatureSeed, 1, 0.0, 0.0, scale, 24, null);
                temperature = 0.0;
                temperature = (5.0 * expectedTemperature + randomTemperature) / 6.0;
                temperature = Math.pow(Math.abs(temperature), 1.0 - (double)temperatureExtremeness) * Math.signum(temperature);
                temperature = ((Number)RangesKt.coerceIn((Comparable)Double.valueOf(temperature + (double)temperatureShift), RangesKt.rangeTo(-1.0, 1.0))).doubleValue();
                if (noTerrainUniques) {
                    String autoTerrain;
                    String string;
                    if (temperature < -0.4) {
                        string = humidity < 0.5 ? "Snow" : "Tundra";
                    } else if (temperature < 0.8) {
                        string = humidity < 0.5 ? "Plains" : "Grassland";
                    } else if (temperature <= 1.0) {
                        string = humidity < 0.7 ? "Desert" : "Plains";
                    } else {
                        objectArray = new Object[]{temperature};
                        LogKt.debug("applyHumidityAndTemperature: Invalid temperature %s", objectArray);
                        string = autoTerrain = this.firstLandTerrain.getName();
                    }
                    if (this.ruleset.getTerrains().containsKey(autoTerrain)) {
                        tile.setBaseTerrain(autoTerrain);
                    }
                    tile.setTerrainTransients();
                    continue;
                }
                Iterable $this$firstOrNull$iv = limitsMap;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TerrainOccursRange it2 = (TerrainOccursRange)element$iv;
                    boolean bl = false;
                    if (!it2.matches(temperature, humidity)) continue;
                    v4 = element$iv;
                    break block18;
                }
                v4 = null;
            }
            TerrainOccursRange terrainOccursRange = matchingTerrain = (TerrainOccursRange)v4;
            if (terrainOccursRange != null) {
                tile.setBaseTerrain(terrainOccursRange.getTerrain().getName());
            } else {
                tile.setBaseTerrain(this.firstLandTerrain.getName());
                objectArray = new Object[]{temperature, humidity};
                LogKt.debug("applyHumidityAndTemperature: No terrain found for temperature: %s, humidity: %s", objectArray);
            }
            tile.setHumidity(humidity);
            tile.setTemperature(temperature);
            tile.setTerrainTransients();
        }
    }

    private final float getTileRadius(Tile tile, TileMap tileMap) {
        float latitudeRatio = Math.abs(tile.getLatitude()) / tileMap.getMaxLatitude();
        float longitudeRatio = Math.abs(tile.getLongitude()) / tileMap.getMaxLongitude();
        return (float)Math.sqrt((float)Math.pow(latitudeRatio, 2) + (float)Math.pow(longitudeRatio, 2));
    }

    private final double getTemperatureAtRadius(float radius) {
        return (double)radius < 0.5 ? this.scaleToRange(0.05, 0.5, -1.0, 1.0, radius) : ((double)radius > 0.5 ? this.scaleToRange(0.5, 0.95, 1.0, -1.0, radius) : 1.0);
    }

    private final double scaleToRange(double x1, double x2, double y1, double y2, float value) {
        double gain = (y2 - y1) / (x2 - x1);
        double offset = y2 - gain * x2;
        return gain * (double)value + offset;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void spawnVegetation(TileMap tileMap) {
        vegetationSeed = this.randomness.getRNG().nextInt();
        $this$mapNotNull$iv /* !! */  = Constants.INSTANCE.getVegetation();
        $i$f$mapNotNull = false;
        var7_6 = $this$mapNotNull$iv /* !! */ ;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var13_22 = ((void)$this$forEach$iv$iv$iv).length;
        for (var12_19 = 0; var12_19 < var13_22; ++var12_19) {
            element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var12_19];
            $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
            it = element$iv$iv;
            $i$a$-mapNotNull-MapGenerator$spawnVegetation$vegetationTerrains$1 = false;
            if (this.ruleset.getTerrains().get(it) == null) continue;
            $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        v0 = (List)destination$iv$iv;
        v1 = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(v1, "ruleset.terrains.values");
        $this$mapNotNull$iv /* !! */  = v1;
        var26_39 = v0;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Terrain)element$iv$iv;
            $i$a$-filter-MapGenerator$spawnVegetation$vegetationTerrains$2 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.Vegetation, null, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        vegetationTerrains = CollectionsKt.toHashSet((Iterable)CollectionsKt.plus(var26_39, (Iterable)((List)destination$iv$iv)));
        $this$flatMap$iv = vegetationTerrains;
        $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Terrain)element$iv$iv;
            $i$a$-flatMap-MapGenerator$spawnVegetation$candidateTerrains$1 = false;
            list$iv$iv = it.getOccursOn();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        candidateTerrains = (List)destination$iv$iv;
        var6_5 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)tileMap.getValues()), (Function1)new Function1<Tile, Boolean>((List<String>)candidateTerrains){
            final /* synthetic */ List<String> $candidateTerrains;
            {
                this.$candidateTerrains = $candidateTerrains;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$candidateTerrains.contains(it.getBaseTerrain()) && this.$candidateTerrains.contains(it.getLastTerrain().getName());
            }
        }).iterator();
        while (var6_5.hasNext()) {
            tile = (Tile)var6_5.next();
            vegetation = (MapGenerationRandomness.getPerlinNoise$default(this.randomness, tile, vegetationSeed, 1, 0.0, 0.0, 3.0, 24, null) + 1.0) / 2.0;
            if (!(vegetation <= (double)tileMap.getMapParameters().getVegetationRichness())) continue;
            $this$filter$iv = vegetationTerrains;
            $i$f$filter = false;
            list$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                block10: {
                    vegetationTerrain = (Terrain)element$iv$iv;
                    $i$a$-filter-MapGenerator$spawnVegetation$possibleVegetation$1 = false;
                    if (!vegetationTerrain.getOccursOn().contains(tile.getLastTerrain().getName())) ** GOTO lbl-1000
                    Intrinsics.checkNotNullExpressionValue(vegetationTerrain, "vegetationTerrain");
                    $this$none$iv = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)vegetationTerrain, UniqueType.TileGenerationConditions, null, 2, null);
                    $i$f$none = false;
                    var22_42 = $this$none$iv.iterator();
                    while (var22_42.hasNext()) {
                        element$iv = var22_42.next();
                        it = (Unique)element$iv;
                        $i$a$-none-MapGenerator$spawnVegetation$possibleVegetation$1$1 = false;
                        v2 = tile.getTemperature();
                        Intrinsics.checkNotNull(v2);
                        if (v2 < Double.parseDouble(it.getParams().get(0))) ** GOTO lbl-1000
                        v3 = tile.getTemperature();
                        Intrinsics.checkNotNull(v3);
                        if (v3 > Double.parseDouble(it.getParams().get(1))) ** GOTO lbl-1000
                        v4 = tile.getHumidity();
                        Intrinsics.checkNotNull(v4);
                        if (v4 < Double.parseDouble(it.getParams().get(2))) ** GOTO lbl-1000
                        v5 = tile.getHumidity();
                        Intrinsics.checkNotNull(v5);
                        if (v5 > Double.parseDouble(it.getParams().get(3))) lbl-1000:
                        // 4 sources

                        {
                            v6 = true;
                        } else {
                            v6 = false;
                        }
                        if (!v6) continue;
                        v7 = false;
                        break block10;
                    }
                    v7 = true;
                }
                if (v7) {
                    v8 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v8 = false;
                }
                if (!v8) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            possibleVegetation = (List)destination$iv$iv;
            if (possibleVegetation.isEmpty()) continue;
            v9 = CollectionsKt.random(possibleVegetation, this.randomness.getRNG());
            Intrinsics.checkNotNullExpressionValue(v9, "possibleVegetation.random(randomness.RNG)");
            randomVegetation = (Terrain)v9;
            tile.addTerrainFeature(randomVegetation.getName());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void spawnRareFeatures(TileMap tileMap) {
        v0 = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(v0, "ruleset.terrains.values");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var5_5 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Terrain)element$iv$iv;
            $i$a$-filter-MapGenerator$spawnRareFeatures$rareFeatures$1 = false;
            if (it.getType() != TerrainType.TerrainFeature) ** GOTO lbl-1000
            Intrinsics.checkNotNullExpressionValue(it, "it");
            if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.RareFeature, null, 2, null)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        rareFeatures = (List)destination$iv$iv;
        var3_2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)tileMap.getValues()), spawnRareFeatures.1.INSTANCE).iterator();
        while (var3_2.hasNext()) {
            tile = (Tile)var3_2.next();
            if (!(this.randomness.getRNG().nextDouble() <= (double)tileMap.getMapParameters().getRareFeaturesRichness())) continue;
            $this$filter$iv = rareFeatures;
            $i$f$filter = false;
            var8_8 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Terrain)element$iv$iv;
                $i$a$-filter-MapGenerator$spawnRareFeatures$possibleFeatures$1 = false;
                v2 = it.getOccursOn().contains(tile.getBaseTerrain()) && (!tile.isHill() || it.getOccursOn().contains("Hill"));
                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            possibleFeatures = (List)destination$iv$iv;
            if (!CollectionsKt.any(possibleFeatures)) continue;
            tile.addTerrainFeature(((Terrain)CollectionsKt.random(possibleFeatures, this.randomness.getRNG())).getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnIce(TileMap tileMap) {
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "ruleset.terrains.values");
        Set<String> waterTerrain2 = SequencesKt.toSet(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), spawnIce.waterTerrain.1.INSTANCE), spawnIce.waterTerrain.2.INSTANCE));
        Collection<Terrain> collection2 = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "ruleset.terrains.values");
        List<TerrainOccursRange> iceEquivalents2 = SequencesKt.toList(SequencesKt.flatMap(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection2), (Function1)new Function1<Terrain, Boolean>(waterTerrain2){
            final /* synthetic */ Set<String> $waterTerrain;
            {
                this.$waterTerrain = $waterTerrain;
                super(1);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Terrain terrain2) {
                boolean bl;
                Intrinsics.checkNotNullParameter(terrain2, "terrain");
                if (terrain2.getType() == TerrainType.TerrainFeature && terrain2.getImpassable()) {
                    boolean bl2;
                    block5: {
                        void $this$all$iv;
                        Iterable iterable = terrain2.getOccursOn();
                        Set<String> set2 = this.$waterTerrain;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                String it = (String)element$iv;
                                boolean bl3 = false;
                                if (set2.contains(it)) continue;
                                bl2 = false;
                                break block5;
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }), (Function1)new Function1<Terrain, Sequence<? extends TerrainOccursRange>>(this){
            final /* synthetic */ MapGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<TerrainOccursRange> invoke(@NotNull Terrain terrain2) {
                Sequence<TerrainOccursRange> sequence;
                Intrinsics.checkNotNullParameter(terrain2, "terrain");
                Sequence<TerrainOccursRange> conditions = MapGenerator.access$getGenerationConditions(this.this$0, terrain2);
                if (SequencesKt.any(conditions)) {
                    sequence = conditions;
                } else {
                    TerrainOccursRange[] terrainOccursRangeArray = new TerrainOccursRange[]{new TerrainOccursRange(terrain2, -1.0f, this.this$0.getRuleset().getModOptions().getConstants().getSpawnIceBelowTemperature(), 0.0f, 1.0f)};
                    sequence = SequencesKt.sequenceOf(terrainOccursRangeArray);
                }
                return sequence;
            }
        }));
        if (tileMap.getMapParameters().getShape() == "Flat Earth Hexagonal") {
            this.spawnFlatEarthIceWalls(tileMap, iceEquivalents2);
        }
        if (iceEquivalents2.isEmpty()) {
            return;
        }
        TileMap.setTransients$default(tileMap, this.ruleset, false, 2, null);
        double temperatureSeed = this.randomness.getRNG().nextInt();
        for (Tile tile : tileMap.getValues()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            TerrainOccursRange it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            if (!waterTerrain2.contains(tile.getBaseTerrain()) || !((Collection)tile.getTerrainFeatures()).isEmpty()) continue;
            MapGenerationRandomness mapGenerationRandomness = this.randomness;
            double d = tileMap.getMapParameters().getTilesPerBiomeArea();
            double randomTemperature = MapGenerationRandomness.getPerlinNoise$default(mapGenerationRandomness, tile, temperatureSeed, 1, 0.0, 0.0, d, 24, null);
            double latitudeTemperature = 1.0 - 2.0 * (double)Math.abs(tile.getLatitude()) / (double)tileMap.getMaxLatitude();
            double temperature = 0.0;
            temperature = (latitudeTemperature + randomTemperature) / 2.0;
            temperature = Math.pow(Math.abs(temperature), 1.0 - (double)tileMap.getMapParameters().getTemperatureExtremeness()) * Math.signum(temperature);
            temperature = ((Number)RangesKt.coerceIn((Comparable)Double.valueOf(temperature + (double)tileMap.getMapParameters().getTemperatureShift()), RangesKt.rangeTo(-1.0, 1.0))).doubleValue();
            Iterable iterable = iceEquivalents2;
            boolean $i$f$filter = false;
            void var16_15 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TerrainOccursRange)element$iv$iv;
                boolean bl = false;
                boolean bl2 = it.matches(temperature, 1.0) && it.getTerrain().getOccursOn().contains(tile.getLastTerrain().getName());
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TerrainOccursRange)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add(it.getTerrain().getName());
            }
            List candidates2 = (List)destination$iv$iv;
            int n = candidates2.size();
            if (n == 1) {
                tile.addTerrainFeature((String)CollectionsKt.first(candidates2));
                continue;
            }
            if (0 <= n ? n < 2 : false) continue;
            tile.addTerrainFeature((String)CollectionsKt.random(candidates2, this.randomness.getRNG()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void spawnFlatEarthIceWalls(TileMap tileMap, List<TerrainOccursRange> iceEquivalents2) {
        Object v2;
        String snowTerrainName;
        String iceTerrainName;
        block9: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object it;
            void $this$filterTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Iterator it2;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = iceEquivalents2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it2 = (TerrainOccursRange)element$iv$iv;
                boolean bl = false;
                if (!((TerrainOccursRange)((Object)it2)).matches(-1.0, 1.0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            int $i$f$map = 0;
            $this$filterTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it2 = (TerrainOccursRange)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((TerrainOccursRange)((Object)it2)).getTerrain().getName());
            }
            List iceCandidates = (List)destination$iv$iv;
            $i$f$map = iceCandidates.size();
            iceTerrainName = $i$f$map == 1 ? (String)CollectionsKt.first(iceCandidates) : (!(0 <= $i$f$map ? $i$f$map < 2 : false) ? (String)CollectionsKt.random(iceCandidates, this.randomness.getRNG()) : null);
            Collection<Terrain> collection2 = this.ruleset.getTerrains().values();
            Intrinsics.checkNotNullExpressionValue(collection2, "ruleset.terrains.values");
            Iterable $this$filter$iv2 = SequencesKt.toList(SequencesKt.flatMap(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection2), spawnFlatEarthIceWalls.snowCandidates.1.INSTANCE), (Function1)new Function1<Terrain, Sequence<? extends TerrainOccursRange>>(this){
                final /* synthetic */ MapGenerator this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Sequence<TerrainOccursRange> invoke(@NotNull Terrain terrain2) {
                    Sequence<TerrainOccursRange> sequence;
                    Intrinsics.checkNotNullParameter(terrain2, "terrain");
                    Sequence<TerrainOccursRange> conditions = MapGenerator.access$getGenerationConditions(this.this$0, terrain2);
                    if (SequencesKt.any(conditions)) {
                        sequence = conditions;
                    } else {
                        TerrainOccursRange[] terrainOccursRangeArray = new TerrainOccursRange[]{new TerrainOccursRange(terrain2, -1.0f, this.this$0.getRuleset().getModOptions().getConstants().getSpawnIceBelowTemperature(), 0.0f, 1.0f)};
                        sequence = SequencesKt.sequenceOf(terrainOccursRangeArray);
                    }
                    return sequence;
                }
            }));
            boolean $i$f$filter2 = false;
            Iterable $i$f$mapTo22 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TerrainOccursRange)element$iv$iv;
                boolean bl = false;
                if (!((TerrainOccursRange)it).matches(-1.0, 1.0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            int $i$f$map2 = 0;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TerrainOccursRange)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(((TerrainOccursRange)it).getTerrain().getName());
            }
            List snowCandidates2 = (List)destination$iv$iv2;
            $i$f$map2 = snowCandidates2.size();
            snowTerrainName = $i$f$map2 == 1 ? (String)CollectionsKt.first(snowCandidates2) : (!(0 <= $i$f$map2 ? $i$f$map2 < 2 : false) ? (String)CollectionsKt.random(snowCandidates2, this.randomness.getRNG()) : null);
            Collection<Terrain> collection3 = this.ruleset.getTerrains().values();
            Intrinsics.checkNotNullExpressionValue(collection3, "ruleset.terrains.values");
            Iterable $this$firstOrNull$iv = collection3;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (Terrain)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.OccursInChains, null, 2, null)) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        Terrain terrain2 = v2;
        String mountainTerrainName = terrain2 != null ? terrain2.getName() : null;
        String string = iceTerrainName;
        if (string == null && (string = snowTerrainName) == null && (string = mountainTerrainName) == null) {
            string = null;
        }
        String bestArcticTileName = string;
        String[] stringArray = new String[]{iceTerrainName, snowTerrainName, mountainTerrainName};
        List<String> arcticTileNameList = ArraysKt.filterNotNull(stringArray);
        if (bestArcticTileName == null && arcticTileNameList.isEmpty()) {
            return;
        }
        for (Tile tile : tileMap.getValues()) {
            boolean isEdgeTile;
            boolean isCenterTile = tile.getLatitude() == 0.0f && tile.getLongitude() == 0.0f;
            boolean bl = isEdgeTile = SequencesKt.count(tile.getNeighbors()) < 6;
            if (isCenterTile && bestArcticTileName != null) {
                this.spawnFlatEarthCenterIceWall(tile, bestArcticTileName, iceTerrainName, mountainTerrainName);
            }
            if (!isEdgeTile || !(!((Collection)arcticTileNameList).isEmpty())) continue;
            this.spawnFlatEarthEdgeIceWall(tile, arcticTileNameList, iceTerrainName, mountainTerrainName);
        }
    }

    private final void spawnFlatEarthCenterIceWall(Tile tile, String bestArcticTileName, String iceTerrainName, String mountainTerrainName) {
        if (Intrinsics.areEqual(bestArcticTileName, iceTerrainName)) {
            tile.setBaseTerrain(this.waterTerrainName);
            tile.removeTerrainFeatures();
            tile.addTerrainFeature(iceTerrainName);
        } else if (iceTerrainName != null && !Intrinsics.areEqual(bestArcticTileName, mountainTerrainName)) {
            tile.setBaseTerrain(bestArcticTileName);
            tile.removeTerrainFeatures();
            tile.addTerrainFeature(iceTerrainName);
        } else {
            tile.setBaseTerrain(bestArcticTileName);
            tile.removeTerrainFeatures();
        }
        Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile neighbor = iterator2.next();
            if (Intrinsics.areEqual(bestArcticTileName, iceTerrainName)) {
                neighbor.setBaseTerrain(this.waterTerrainName);
                neighbor.removeTerrainFeatures();
                neighbor.addTerrainFeature(iceTerrainName);
            } else if (iceTerrainName != null && !Intrinsics.areEqual(bestArcticTileName, mountainTerrainName)) {
                neighbor.setBaseTerrain(bestArcticTileName);
                neighbor.removeTerrainFeatures();
                neighbor.addTerrainFeature(iceTerrainName);
            } else {
                neighbor.setBaseTerrain(bestArcticTileName);
                neighbor.removeTerrainFeatures();
            }
            Iterator<Tile> iterator3 = neighbor.getNeighbors().iterator();
            while (iterator3.hasNext()) {
                Tile neighbor2 = iterator3.next();
                if (this.randomness.getRNG().nextDouble() < 0.75) continue;
                if (Intrinsics.areEqual(bestArcticTileName, iceTerrainName)) {
                    neighbor2.setBaseTerrain(this.waterTerrainName);
                    neighbor2.removeTerrainFeatures();
                    neighbor2.addTerrainFeature(iceTerrainName);
                    continue;
                }
                if (iceTerrainName != null && !Intrinsics.areEqual(bestArcticTileName, mountainTerrainName)) {
                    neighbor2.setBaseTerrain(bestArcticTileName);
                    neighbor2.removeTerrainFeatures();
                    neighbor2.addTerrainFeature(iceTerrainName);
                    continue;
                }
                neighbor2.setBaseTerrain(bestArcticTileName);
                neighbor2.removeTerrainFeatures();
            }
        }
    }

    private final void spawnFlatEarthEdgeIceWall(Tile tile, List<String> arcticTileNameList, String iceTerrainName, String mountainTerrainName) {
        String arcticTileName;
        String string = arcticTileName = arcticTileNameList.size() == 1 ? CollectionsKt.first(arcticTileNameList) : (String)CollectionsKt.random((Collection)arcticTileNameList, this.randomness.getRNG());
        if (Intrinsics.areEqual(arcticTileName, iceTerrainName)) {
            tile.setBaseTerrain(this.waterTerrainName);
            tile.removeTerrainFeatures();
            tile.addTerrainFeature(iceTerrainName);
        } else if (iceTerrainName != null && !Intrinsics.areEqual(arcticTileName, mountainTerrainName)) {
            tile.setBaseTerrain(arcticTileName);
            tile.removeTerrainFeatures();
            tile.addTerrainFeature(iceTerrainName);
        } else {
            tile.setBaseTerrain(arcticTileName);
            tile.removeTerrainFeatures();
        }
        Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile neighbor = iterator2.next();
            boolean neighborIsEdgeTile = SequencesKt.count(neighbor.getNeighbors()) < 6;
            if (neighborIsEdgeTile || this.randomness.getRNG().nextDouble() < 0.75) continue;
            if (Intrinsics.areEqual(arcticTileName, iceTerrainName)) {
                neighbor.setBaseTerrain(this.waterTerrainName);
                neighbor.removeTerrainFeatures();
                neighbor.addTerrainFeature(iceTerrainName);
                continue;
            }
            if (iceTerrainName != null && !Intrinsics.areEqual(arcticTileName, mountainTerrainName)) {
                neighbor.setBaseTerrain(arcticTileName);
                neighbor.removeTerrainFeatures();
                neighbor.addTerrainFeature(iceTerrainName);
                continue;
            }
            neighbor.setBaseTerrain(arcticTileName);
            neighbor.removeTerrainFeatures();
        }
    }

    public static final /* synthetic */ MapGenerationRandomness access$getRandomness$p(MapGenerator $this) {
        return $this.randomness;
    }

    public static final /* synthetic */ void access$applyHumidityAndTemperature(MapGenerator $this, TileMap tileMap) {
        $this.applyHumidityAndTemperature(tileMap);
    }

    public static final /* synthetic */ void access$spawnLakesAndCoasts(MapGenerator $this, TileMap map2) {
        $this.spawnLakesAndCoasts(map2);
    }

    public static final /* synthetic */ void access$spawnVegetation(MapGenerator $this, TileMap tileMap) {
        $this.spawnVegetation(tileMap);
    }

    public static final /* synthetic */ void access$spawnRareFeatures(MapGenerator $this, TileMap tileMap) {
        $this.spawnRareFeatures(tileMap);
    }

    public static final /* synthetic */ void access$spawnIce(MapGenerator $this, TileMap tileMap) {
        $this.spawnIce(tileMap);
    }

    public static final /* synthetic */ void access$spreadResources(MapGenerator $this, TileMap tileMap) {
        $this.spreadResources(tileMap);
    }

    public static final /* synthetic */ void access$spreadAncientRuins(MapGenerator $this, TileMap map2) {
        $this.spreadAncientRuins(map2);
    }

    public static final /* synthetic */ Sequence access$getGenerationConditions(MapGenerator $this, Terrain $receiver) {
        return $this.getGenerationConditions($receiver);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator$Companion;", "", "()V", "consoleTimings", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\n"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator$Helpers;", "", "()V", "convertTerrains", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "tiles", "", "Lcom/unciv/logic/map/tile/Tile;", "core"})
    @SourceDebugExtension(value={"SMAP\nMapGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapGenerator$Helpers\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,785:1\n179#2,2:786\n*S KotlinDebug\n*F\n+ 1 MapGenerator.kt\ncom/unciv/logic/map/mapgenerator/MapGenerator$Helpers\n*L\n229#1:786,2\n*E\n"})
    public static final class Helpers {
        @NotNull
        public static final Helpers INSTANCE = new Helpers();

        private Helpers() {
        }

        /*
         * WARNING - void declaration
         */
        public final void convertTerrains(@NotNull Ruleset ruleset2, @NotNull Iterable<Tile> tiles2) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            Intrinsics.checkNotNullParameter(tiles2, "tiles");
            for (Tile tile : tiles2) {
                Terrain terrain2;
                Unique conversionUnique;
                Object v0;
                block4: {
                    void $this$firstOrNull$iv;
                    Sequence sequence = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)tile.getBaseTerrain(), UniqueType.ChangesTerrain, null, 2, null);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Unique it = (Unique)element$iv;
                        boolean bl = false;
                        if (!Tile.isAdjacentTo$default(tile, it.getParams().get(1), null, 2, null)) continue;
                        v0 = element$iv;
                        break block4;
                    }
                    v0 = null;
                }
                if ((Unique)v0 == null || ruleset2.getTerrains().get(conversionUnique.getParams().get(0)) == null) continue;
                if (terrain2.getType() != TerrainType.TerrainFeature) {
                    tile.setBaseTerrain(terrain2.getName());
                } else {
                    if (!terrain2.getOccursOn().contains(tile.getLastTerrain().getName())) continue;
                    tile.addTerrainFeature(terrain2.getName());
                }
                tile.setTerrainTransients();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator$TerrainOccursRange;", "", "terrain", "Lcom/unciv/models/ruleset/tile/Terrain;", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "(Lcom/unciv/models/ruleset/tile/Terrain;Lcom/unciv/models/ruleset/unique/Unique;)V", "tempFrom", "", "tempTo", "humidFrom", "humidTo", "(Lcom/unciv/models/ruleset/tile/Terrain;FFFF)V", "getHumidFrom", "()F", "getHumidTo", "getTempFrom", "getTempTo", "getTerrain", "()Lcom/unciv/models/ruleset/tile/Terrain;", "matches", "", "temperature", "", "humidity", "Companion", "core"})
    private static final class TerrainOccursRange {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Terrain terrain;
        private final float tempFrom;
        private final float tempTo;
        private final float humidFrom;
        private final float humidTo;

        public TerrainOccursRange(@NotNull Terrain terrain2, float tempFrom, float tempTo, float humidFrom, float humidTo) {
            Intrinsics.checkNotNullParameter(terrain2, "terrain");
            this.terrain = terrain2;
            this.tempFrom = tempFrom;
            this.tempTo = tempTo;
            this.humidFrom = humidFrom;
            this.humidTo = humidTo;
        }

        @NotNull
        public final Terrain getTerrain() {
            return this.terrain;
        }

        public final float getTempFrom() {
            return this.tempFrom;
        }

        public final float getTempTo() {
            return this.tempTo;
        }

        public final float getHumidFrom() {
            return this.humidFrom;
        }

        public final float getHumidTo() {
            return this.humidTo;
        }

        public TerrainOccursRange(@NotNull Terrain terrain2, @NotNull Unique unique) {
            Intrinsics.checkNotNullParameter(terrain2, "terrain");
            Intrinsics.checkNotNullParameter(unique, "unique");
            this(terrain2, TerrainOccursRange.Companion.toFloatMakeInclusive(unique.getParams().get(0), -1.0f), Float.parseFloat(unique.getParams().get(1)), TerrainOccursRange.Companion.toFloatMakeInclusive(unique.getParams().get(2), 0.0f), Float.parseFloat(unique.getParams().get(3)));
        }

        public final boolean matches(double temperature, double humidity) {
            return (double)this.tempFrom < temperature && temperature <= (double)this.tempTo && (double)this.humidFrom < humidity && humidity <= (double)this.humidTo;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/unciv/logic/map/mapgenerator/MapGenerator$TerrainOccursRange$Companion;", "", "()V", "toFloatMakeInclusive", "", "", "limit", "core"})
        public static final class Companion {
            private Companion() {
            }

            private final float toFloatMakeInclusive(String $this$toFloatMakeInclusive, float limit2) {
                float result2 = Float.parseFloat($this$toFloatMakeInclusive);
                if (!(result2 == limit2)) {
                    return result2;
                }
                return result2 - Math.ulp(result2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

