/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator.mapregions;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.mapregions.MapRegionsKt;
import com.unciv.logic.map.mapgenerator.mapregions.Region;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u00109\u001a\u00020:J\u000e\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0018J\b\u0010=\u001a\u00020\u0018H\u0016J\u0010\u0010>\u001a\u00020:2\b\b\u0002\u0010?\u001a\u00020\nR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R-\u0010%\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00070&j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0007`'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R!\u0010,\u001a\u0012\u0012\u0004\u0012\u00020.0-j\b\u0012\u0004\u0012\u00020.`/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0016\"\u0004\b4\u00105R\u001a\u00106\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001a\"\u0004\b8\u0010\u001c\u00a8\u0006@"}, d2={"Lcom/unciv/logic/map/mapgenerator/mapregions/Region;", "", "tileMap", "Lcom/unciv/logic/map/TileMap;", "rect", "Lcom/badlogic/gdx/math/Rectangle;", "continentID", "", "(Lcom/unciv/logic/map/TileMap;Lcom/badlogic/gdx/math/Rectangle;I)V", "affectedByWorldWrap", "", "getAffectedByWorldWrap", "()Z", "setAffectedByWorldWrap", "(Z)V", "assignedMinorCivs", "Ljava/util/ArrayList;", "Lcom/unciv/logic/civilization/Civilization;", "Lkotlin/collections/ArrayList;", "getAssignedMinorCivs", "()Ljava/util/ArrayList;", "getContinentID", "()I", "luxury", "", "getLuxury", "()Ljava/lang/String;", "setLuxury", "(Ljava/lang/String;)V", "getRect", "()Lcom/badlogic/gdx/math/Rectangle;", "startPosition", "Lcom/badlogic/gdx/math/Vector2;", "getStartPosition", "()Lcom/badlogic/gdx/math/Vector2;", "setStartPosition", "(Lcom/badlogic/gdx/math/Vector2;)V", "terrainCounts", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getTerrainCounts", "()Ljava/util/HashMap;", "getTileMap", "()Lcom/unciv/logic/map/TileMap;", "tiles", "Ljava/util/HashSet;", "Lcom/unciv/logic/map/tile/Tile;", "Lkotlin/collections/HashSet;", "getTiles", "()Ljava/util/HashSet;", "totalFertility", "getTotalFertility", "setTotalFertility", "(I)V", "type", "getType", "setType", "countTerrains", "", "getTerrainAmount", "name", "toString", "updateTiles", "trim", "core"})
@SourceDebugExtension(value={"SMAP\nRegion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Region.kt\ncom/unciv/logic/map/mapgenerator/mapregions/Region\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n766#2:92\n857#2,2:93\n1549#2:96\n1620#2,3:97\n1#3:95\n*S KotlinDebug\n*F\n+ 1 Region.kt\ncom/unciv/logic/map/mapgenerator/mapregions/Region\n*L\n55#1:92\n55#1:93,2\n75#1:96\n75#1:97,3\n*E\n"})
public final class Region {
    @NotNull
    private final TileMap tileMap;
    @NotNull
    private final Rectangle rect;
    private final int continentID;
    @NotNull
    private final HashSet<Tile> tiles;
    @NotNull
    private final HashMap<String, Integer> terrainCounts;
    private int totalFertility;
    @NotNull
    private String type;
    @Nullable
    private String luxury;
    @Nullable
    private Vector2 startPosition;
    @NotNull
    private final ArrayList<Civilization> assignedMinorCivs;
    private boolean affectedByWorldWrap;

    public Region(@NotNull TileMap tileMap, @NotNull Rectangle rect, int continentID) {
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Intrinsics.checkNotNullParameter(rect, "rect");
        this.tileMap = tileMap;
        this.rect = rect;
        this.continentID = continentID;
        this.tiles = new HashSet();
        this.terrainCounts = new HashMap();
        this.type = "Hybrid";
        this.assignedMinorCivs = new ArrayList();
    }

    public /* synthetic */ Region(TileMap tileMap, Rectangle rectangle, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = -1;
        }
        this(tileMap, rectangle, n);
    }

    @NotNull
    public final TileMap getTileMap() {
        return this.tileMap;
    }

    @NotNull
    public final Rectangle getRect() {
        return this.rect;
    }

    public final int getContinentID() {
        return this.continentID;
    }

    @NotNull
    public final HashSet<Tile> getTiles() {
        return this.tiles;
    }

    @NotNull
    public final HashMap<String, Integer> getTerrainCounts() {
        return this.terrainCounts;
    }

    public final int getTotalFertility() {
        return this.totalFertility;
    }

    public final void setTotalFertility(int n) {
        this.totalFertility = n;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final void setType(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.type = string;
    }

    @Nullable
    public final String getLuxury() {
        return this.luxury;
    }

    public final void setLuxury(@Nullable String string) {
        this.luxury = string;
    }

    @Nullable
    public final Vector2 getStartPosition() {
        return this.startPosition;
    }

    public final void setStartPosition(@Nullable Vector2 vector2) {
        this.startPosition = vector2;
    }

    @NotNull
    public final ArrayList<Civilization> getAssignedMinorCivs() {
        return this.assignedMinorCivs;
    }

    public final boolean getAffectedByWorldWrap() {
        return this.affectedByWorldWrap;
    }

    public final void setAffectedByWorldWrap(boolean bl) {
        this.affectedByWorldWrap = bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTiles(boolean trim) {
        this.totalFertility = 0;
        float minColumn = 99999.0f;
        float maxColumn = -99999.0f;
        float minRow = 99999.0f;
        float maxRow = -99999.0f;
        HashSet<Integer> columnHasTile = new HashSet<Integer>();
        this.tiles.clear();
        Object object = SequencesKt.filter(this.tileMap.getTilesInRectangle(this.rect), (Function1)new Function1<Tile, Boolean>(this){
            final /* synthetic */ Region this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.getContinentID() == -1 || it.getContinent() == this.this$0.getContinentID();
            }
        }).iterator();
        while (object.hasNext()) {
            Tile tile = object.next();
            int fertility = MapRegionsKt.getTileFertility(tile, this.continentID != -1);
            this.tiles.add(tile);
            this.totalFertility += fertility;
            if (this.affectedByWorldWrap) {
                columnHasTile.add(tile.getColumn());
            }
            if (!trim) continue;
            float row = tile.getRow();
            float column = tile.getColumn();
            minColumn = Math.min(minColumn, column);
            maxColumn = Math.max(maxColumn, column);
            minRow = Math.min(minRow, row);
            maxRow = Math.max(maxRow, row);
        }
        if (trim) {
            if (this.affectedByWorldWrap) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                object = columnHasTile;
                Rectangle rectangle = this.rect;
                boolean $i$f$filter = false;
                void fertility = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    int it = ((Number)element$iv$iv).intValue();
                    boolean bl = false;
                    if (!(!columnHasTile.contains(it - 1))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                object = (List)destination$iv$iv;
                Iterator iterator2 = object.iterator();
                if (!iterator2.hasNext()) {
                    throw new NoSuchElementException();
                }
                int it = ((Number)iterator2.next()).intValue();
                boolean bl = false;
                int n = it;
                while (iterator2.hasNext()) {
                    int it2 = ((Number)iterator2.next()).intValue();
                    $i$a$-maxOf-Region$updateTiles$3 = false;
                    int n2 = it2;
                    if (n >= n2) continue;
                    n = n2;
                }
                int n3 = n;
                rectangle.x = n3;
            } else {
                this.rect.x = minColumn;
            }
            this.rect.y = minRow;
            this.rect.height = maxRow - minRow + 1.0f;
            if (this.affectedByWorldWrap && minColumn < this.rect.x) {
                this.rect.width = columnHasTile.size();
            } else {
                this.rect.width = maxColumn - minColumn + 1.0f;
                this.affectedByWorldWrap = false;
            }
        }
    }

    public static /* synthetic */ void updateTiles$default(Region region, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        region.updateTiles(bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void countTerrains() {
        this.terrainCounts.clear();
        for (Tile tile : this.tiles) {
            Sequence<Object> sequence;
            Object object;
            Intrinsics.checkNotNullExpressionValue(tile, "tile");
            if (Tile.terrainHasUnique$default(tile, UniqueType.IgnoreBaseTerrainForRegion, null, 2, null)) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = tile.getTerrainFeatureObjects();
                boolean $i$f$map = false;
                object = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Terrain terrain2 = (Terrain)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                sequence = CollectionsKt.asSequence((List)destination$iv$iv);
            } else {
                sequence = SequencesKt.map(tile.getAllTerrains(), countTerrains.terrainsToCount.2.INSTANCE);
            }
            Sequence terrainsToCount2 = sequence;
            Object object2 = terrainsToCount2.iterator();
            while (object2.hasNext()) {
                String terrain3 = (String)object2.next();
                object = this.terrainCounts;
                Integer n = this.terrainCounts.get(terrain3);
                if (n == null) {
                    n = 0;
                }
                Integer n2 = n + 1;
                object.put(terrain3, n2);
            }
            if (!tile.isCoastalTile()) continue;
            object2 = this.terrainCounts;
            String string = "Coastal";
            Integer n = this.terrainCounts.get("Coastal");
            if (n == null) {
                n = 0;
            }
            object = n + 1;
            object2.put(string, object);
        }
    }

    public final int getTerrainAmount(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Integer n = this.terrainCounts.get(name2);
        if (n == null) {
            n = 0;
        }
        return ((Number)n).intValue();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Region(").append(this.type).append(", ").append(this.tiles.size()).append(" tiles, ");
        Set<Map.Entry<String, Integer>> set2 = this.terrainCounts.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, "terrainCounts.entries");
        return stringBuilder.append(CollectionsKt.joinToString$default(set2, null, null, null, 0, null, toString.1.INSTANCE, 31, null)).append(')').toString();
    }
}

