/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.tile;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010'\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003:\u0001\u001cB\u001b\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0006H\u0007J\u0006\u0010\u000e\u001a\u00020\u0000J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0005J\u001b\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0011H\u0097\u0002J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/unciv/logic/map/tile/TileHistory;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "Lcom/badlogic/gdx/utils/Json$Serializable;", "", "", "", "Lcom/unciv/logic/map/tile/TileHistory$TileHistoryState;", "history", "Ljava/util/TreeMap;", "(Ljava/util/TreeMap;)V", "addTestEntry", "", "turn", "entry", "clone", "getState", "iterator", "", "read", "json", "Lcom/badlogic/gdx/utils/Json;", "jsonData", "Lcom/badlogic/gdx/utils/JsonValue;", "recordRelinquishOwnership", "tile", "Lcom/unciv/logic/map/tile/Tile;", "recordTakeOwnership", "write", "TileHistoryState", "core"})
@SourceDebugExtension(value={"SMAP\nTileHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileHistory.kt\ncom/unciv/logic/map/tile/TileHistory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1#2:96\n*E\n"})
public final class TileHistory
implements IsPartOfGameInfoSerialization,
Json.Serializable,
Iterable<Map.Entry<Integer, TileHistoryState>>,
KMappedMarker {
    @NotNull
    private final TreeMap<Integer, TileHistoryState> history;

    public TileHistory(@NotNull TreeMap<Integer, TileHistoryState> history) {
        Intrinsics.checkNotNullParameter(history, "history");
        this.history = history;
    }

    public /* synthetic */ TileHistory(TreeMap treeMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            treeMap = new TreeMap();
        }
        this(treeMap);
    }

    public final void recordTakeOwnership(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        ((Map)this.history).put(tile.getTileMap().getGameInfo().getTurns(), new TileHistoryState(tile));
    }

    public final void recordRelinquishOwnership(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        ((Map)this.history).put(tile.getTileMap().getGameInfo().getTurns(), new TileHistoryState(null, null, 3, null));
    }

    @NotNull
    public final TileHistoryState getState(int turn) {
        Map.Entry<Integer, TileHistoryState> entry = this.history.floorEntry(turn);
        TileHistoryState tileHistoryState = entry != null ? entry.getValue() : null;
        if (tileHistoryState == null) {
            tileHistoryState = new TileHistoryState(null, null, 3, null);
        }
        return tileHistoryState;
    }

    @NotNull
    public final TileHistory clone() {
        return new TileHistory(new TreeMap<Integer, TileHistoryState>((SortedMap)this.history));
    }

    @Override
    public void write(@NotNull Json json) {
        Intrinsics.checkNotNullParameter(json, "json");
        for (Map.Entry entry : ((Map)this.history).entrySet()) {
            int key = ((Number)entry.getKey()).intValue();
            TileHistoryState entry2 = (TileHistoryState)entry.getValue();
            json.writeArrayStart(String.valueOf(key));
            json.writeValue(entry2.getOwningCivName());
            json.writeValue(entry2.getCityCenterType().getSerializedRepresentation());
            json.writeArrayEnd();
        }
    }

    @Override
    public void read(@NotNull Json json, @NotNull JsonValue jsonData) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(jsonData, "jsonData");
        for (JsonValue entry : jsonData) {
            String string;
            String string2 = entry.name;
            Intrinsics.checkNotNullExpressionValue(string2, "entry.name");
            int turn = Integer.parseInt(string2);
            String it = string = entry.get(0).isString() ? entry.getString(0) : "";
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            String owningCivName = !(((CharSequence)it).length() == 0) ? string : null;
            String string3 = entry.getString(1);
            Intrinsics.checkNotNullExpressionValue(string3, "entry.getString(1)");
            TileHistoryState.CityCenterType cityCenterType = TileHistoryState.CityCenterType.Companion.deserialize(string3);
            Integer n = turn;
            ((Map)this.history).put(n, new TileHistoryState(owningCivName, cityCenterType));
        }
    }

    @VisibleForTesting
    public final void addTestEntry(int turn, @NotNull TileHistoryState entry) {
        Intrinsics.checkNotNullParameter(entry, "entry");
        Integer n = turn;
        ((Map)this.history).put(n, entry);
    }

    @Override
    @VisibleForTesting
    @NotNull
    public Iterator<Map.Entry<Integer, TileHistoryState>> iterator() {
        return ((Map)this.history).entrySet().iterator();
    }

    public TileHistory() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/unciv/logic/map/tile/TileHistory$TileHistoryState;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "(Lcom/unciv/logic/map/tile/Tile;)V", "owningCivName", "", "cityCenterType", "Lcom/unciv/logic/map/tile/TileHistory$TileHistoryState$CityCenterType;", "(Ljava/lang/String;Lcom/unciv/logic/map/tile/TileHistory$TileHistoryState$CityCenterType;)V", "getCityCenterType", "()Lcom/unciv/logic/map/tile/TileHistory$TileHistoryState$CityCenterType;", "getOwningCivName", "()Ljava/lang/String;", "CityCenterType", "core"})
    public static final class TileHistoryState
    implements IsPartOfGameInfoSerialization {
        @Nullable
        private final String owningCivName;
        @NotNull
        private final CityCenterType cityCenterType;

        public TileHistoryState(@Nullable String owningCivName, @NotNull CityCenterType cityCenterType) {
            Intrinsics.checkNotNullParameter((Object)cityCenterType, "cityCenterType");
            this.owningCivName = owningCivName;
            this.cityCenterType = cityCenterType;
        }

        public /* synthetic */ TileHistoryState(String string, CityCenterType cityCenterType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                cityCenterType = CityCenterType.None;
            }
            this(string, cityCenterType);
        }

        @Nullable
        public final String getOwningCivName() {
            return this.owningCivName;
        }

        @NotNull
        public final CityCenterType getCityCenterType() {
            return this.cityCenterType;
        }

        public TileHistoryState(@NotNull Tile tile) {
            CityCenterType cityCenterType;
            Intrinsics.checkNotNullParameter(tile, "tile");
            Civilization civilization = tile.getOwner();
            String string = civilization != null ? civilization.getCivName() : null;
            if (!tile.isCityCenter()) {
                cityCenterType = CityCenterType.None;
            } else {
                City city2 = tile.getCity();
                cityCenterType = (city2 != null ? city2.isCapital() : false) ? CityCenterType.Capital : CityCenterType.Regular;
            }
            this(string, cityCenterType);
        }

        public TileHistoryState() {
            this(null, null, 3, null);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0001\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/map/tile/TileHistory$TileHistoryState$CityCenterType;", "", "serializedRepresentation", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getSerializedRepresentation", "()Ljava/lang/String;", "None", "Regular", "Capital", "Companion", "core"})
        public static final class CityCenterType
        extends Enum<CityCenterType> {
            @NotNull
            public static final Companion Companion;
            @NotNull
            private final String serializedRepresentation;
            public static final /* enum */ CityCenterType None;
            public static final /* enum */ CityCenterType Regular;
            public static final /* enum */ CityCenterType Capital;
            private static final /* synthetic */ CityCenterType[] $VALUES;

            private CityCenterType(String serializedRepresentation) {
                this.serializedRepresentation = serializedRepresentation;
            }

            @NotNull
            public final String getSerializedRepresentation() {
                return this.serializedRepresentation;
            }

            public static CityCenterType[] values() {
                return (CityCenterType[])$VALUES.clone();
            }

            public static CityCenterType valueOf(String value) {
                return Enum.valueOf(CityCenterType.class, value);
            }

            static {
                None = new CityCenterType("N");
                Regular = new CityCenterType("R");
                Capital = new CityCenterType("C");
                $VALUES = cityCenterTypeArray = new CityCenterType[]{CityCenterType.None, CityCenterType.Regular, CityCenterType.Capital};
                Companion = new Companion(null);
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/logic/map/tile/TileHistory$TileHistoryState$CityCenterType$Companion;", "", "()V", "deserialize", "Lcom/unciv/logic/map/tile/TileHistory$TileHistoryState$CityCenterType;", "s", "", "core"})
            @SourceDebugExtension(value={"SMAP\nTileHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileHistory.kt\ncom/unciv/logic/map/tile/TileHistory$TileHistoryState$CityCenterType$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,95:1\n1282#2,2:96\n*S KotlinDebug\n*F\n+ 1 TileHistory.kt\ncom/unciv/logic/map/tile/TileHistory$TileHistoryState$CityCenterType$Companion\n*L\n34#1:96,2\n*E\n"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final CityCenterType deserialize(@NotNull String s) {
                    CityCenterType cityCenterType;
                    CityCenterType cityCenterType2;
                    block2: {
                        Intrinsics.checkNotNullParameter(s, "s");
                        CityCenterType[] $this$firstOrNull$iv = CityCenterType.values();
                        boolean $i$f$firstOrNull = false;
                        int n = $this$firstOrNull$iv.length;
                        for (int i = 0; i < n; ++i) {
                            CityCenterType element$iv;
                            CityCenterType it = element$iv = $this$firstOrNull$iv[i];
                            boolean bl = false;
                            if (!Intrinsics.areEqual(it.getSerializedRepresentation(), s)) continue;
                            cityCenterType2 = element$iv;
                            break block2;
                        }
                        cityCenterType2 = cityCenterType = null;
                    }
                    if (cityCenterType2 == null) {
                        cityCenterType = None;
                    }
                    return cityCenterType;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

