/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.tile;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.ImprovementBuildingProblem;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.NamedStats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJE\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u000e2\u0010\b\u0002\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0019J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nJ\u0006\u0010\u001e\u001a\u00020\bJ(\u0010\u001f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!J\u0018\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J$\u0010$\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0018\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\n2\u0006\u0010#\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006'"}, d2={"Lcom/unciv/logic/map/tile/TileImprovementFunctions;", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "(Lcom/unciv/logic/map/tile/Tile;)V", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "activateRemovalImprovement", "", "improvementName", "", "civToActivateBroaderEffects", "Lcom/unciv/logic/civilization/Civilization;", "canBuildImprovement", "", "improvement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "civInfo", "canImprovementBeBuiltHere", "resourceIsVisible", "knownFeatureRemovals", "", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "isNormalizeCheck", "canImprovementBeBuiltHere$core", "getImprovementBuildingProblems", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/map/tile/ImprovementBuildingProblem;", "markForCreatesOneImprovement", "removeCreatesOneImprovementMarker", "setImprovement", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "takeOverTilesAround", "civ", "triggerImprovementUniques", "tryProvideProductionToClosestCity", "removedTerrainFeature", "core"})
@SourceDebugExtension(value={"SMAP\nTileImprovementFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileImprovementFunctions.kt\ncom/unciv/logic/map/tile/TileImprovementFunctions\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,386:1\n12744#2,2:387\n12744#2,2:392\n12744#2,2:420\n1747#3,3:389\n766#3:402\n857#3,2:403\n819#3:405\n847#3:406\n1747#3,3:407\n848#3:410\n766#3:411\n857#3,2:412\n766#3:414\n857#3,2:415\n1747#3,3:417\n2333#3,14:422\n1603#3,9:450\n1855#3:459\n288#3,2:460\n1856#3:463\n1612#3:464\n1747#3,3:465\n819#3:468\n847#3:469\n1747#3,3:470\n848#3:473\n2333#3,14:474\n1229#4,2:394\n1229#4,2:396\n1229#4,2:398\n1229#4,2:400\n1821#4,14:436\n1#5:462\n*S KotlinDebug\n*F\n+ 1 TileImprovementFunctions.kt\ncom/unciv/logic/map/tile/TileImprovementFunctions\n*L\n137#1:387,2\n142#1:392,2\n293#1:420,2\n139#1:389,3\n232#1:402\n232#1:403,2\n239#1:405\n239#1:406\n239#1:407,3\n239#1:410\n265#1:411\n265#1:412,2\n270#1:414\n270#1:415,2\n287#1:417,3\n310#1:422,14\n118#1:450,9\n118#1:459\n119#1:460,2\n118#1:463\n118#1:464\n121#1:465,3\n123#1:468\n123#1:469\n124#1:470,3\n123#1:473\n337#1:474,14\n154#1:394,2\n159#1:396,2\n167#1:398,2\n171#1:400,2\n346#1:436,14\n118#1:462\n*E\n"})
public final class TileImprovementFunctions {
    @NotNull
    private final Tile tile;

    public TileImprovementFunctions(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        this.tile = tile;
    }

    @NotNull
    public final Tile getTile() {
        return this.tile;
    }

    public final boolean canBuildImprovement(@NotNull TileImprovement improvement2, @NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(improvement2, "improvement");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        return SequencesKt.none(this.getImprovementBuildingProblems(improvement2, civInfo));
    }

    @NotNull
    public final Sequence<ImprovementBuildingProblem> getImprovementBuildingProblems(@NotNull TileImprovement improvement2, @NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(improvement2, "improvement");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super ImprovementBuildingProblem>, Continuation<? super Unit>, Object>(civInfo, this, improvement2, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Civilization $civInfo;
            final /* synthetic */ TileImprovementFunctions this$0;
            final /* synthetic */ TileImprovement $improvement;
            {
                this.$civInfo = $civInfo;
                this.this$0 = $receiver;
                this.$improvement = $improvement;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block53: {
                    var22_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            stateForConditionals = new StateForConditionals(this.$civInfo, null, null, this.this$0.getTile(), null, null, null, null, null, false, 1014, null);
                            if (this.$improvement.getUniqueTo() != null && !Intrinsics.areEqual(this.$improvement.getUniqueTo(), this.$civInfo.getCivName())) {
                                this.L$0 = $this$sequence;
                                this.L$1 = stateForConditionals;
                                this.label = 1;
                                v0 = $this$sequence.yield(ImprovementBuildingProblem.WrongCiv, this);
                                if (v0 == var22_2) {
                                    return var22_2;
                                }
                            }
                            ** GOTO lbl20
                        }
                        case 1: {
                            stateForConditionals = (StateForConditionals)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl20:
                            // 2 sources

                            var4_5 = this.$civInfo.getCache().getUniqueImprovements();
                            var5_6 = this.$improvement;
                            $i$f$any = false;
                            if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl26
                            v1 = false;
                            ** GOTO lbl35
lbl26:
                            // 1 sources

                            var7_17 = $this$any$iv.iterator();
                            while (var7_17.hasNext()) {
                                element$iv /* !! */  = var7_17.next();
                                it = (TileImprovement)element$iv /* !! */ ;
                                $i$a$-any-TileImprovementFunctions$getImprovementBuildingProblems$1$1 = false;
                                if (!Intrinsics.areEqual(it.getReplaces(), var5_6.getName())) continue;
                                v1 = true;
                                ** GOTO lbl35
                            }
                            v1 = false;
lbl35:
                            // 3 sources

                            if (v1) {
                                this.L$0 = $this$sequence;
                                this.L$1 = stateForConditionals;
                                this.label = 2;
                                v2 = $this$sequence.yield(ImprovementBuildingProblem.Replaced, this);
                                if (v2 == var22_2) {
                                    return var22_2;
                                }
                            }
                            ** GOTO lbl48
                        }
                        case 2: {
                            stateForConditionals = (StateForConditionals)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v2 = $result;
lbl48:
                            // 2 sources

                            if (this.$improvement.getTechRequired() != null) {
                                v3 = this.$civInfo.getTech();
                                v4 = this.$improvement.getTechRequired();
                                Intrinsics.checkNotNull(v4);
                                if (!v3.isResearched(v4)) {
                                    this.L$0 = $this$sequence;
                                    this.L$1 = stateForConditionals;
                                    this.label = 3;
                                    v5 = $this$sequence.yield(ImprovementBuildingProblem.MissingTech, this);
                                    if (v5 == var22_2) {
                                        return var22_2;
                                    }
                                }
                            }
                            ** GOTO lbl65
                        }
                        case 3: {
                            stateForConditionals = (StateForConditionals)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v5 = $result;
lbl65:
                            // 2 sources

                            $this$any$iv = this.$improvement.getMatchingUniques(UniqueType.Unbuildable, StateForConditionals.Companion.getIgnoreConditionals());
                            $i$f$any = false;
                            $i$f$any = $this$any$iv.iterator();
                            while ($i$f$any.hasNext()) {
                                element$iv = $i$f$any.next();
                                it = (Unique)element$iv;
                                $i$a$-any-TileImprovementFunctions$getImprovementBuildingProblems$1$2 = false;
                                if (!it.getConditionals().isEmpty()) continue;
                                v6 = true;
                                ** GOTO lbl76
                            }
                            v6 = false;
lbl76:
                            // 2 sources

                            if (!v6) break;
                            this.L$0 = $this$sequence;
                            this.L$1 = stateForConditionals;
                            this.label = 4;
                            v7 = $this$sequence.yield(ImprovementBuildingProblem.Unbuildable, this);
                            if (v7 == var22_2) {
                                return var22_2;
                            }
                            ** GOTO lbl103
                        }
                        case 4: {
                            stateForConditionals = (StateForConditionals)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v7 = $result;
                            ** GOTO lbl103
                        }
                    }
                    if (this.$improvement.hasUnique(UniqueType.Unbuildable, stateForConditionals)) {
                        this.L$0 = $this$sequence;
                        this.L$1 = stateForConditionals;
                        this.label = 5;
                        v8 = $this$sequence.yield(ImprovementBuildingProblem.ConditionallyUnbuildable, this);
                        if (v8 == var22_2) {
                            return var22_2;
                        }
                    }
                    ** GOTO lbl103
                    {
                        case 5: {
                            stateForConditionals = (StateForConditionals)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v8 = $result;
lbl103:
                            // 4 sources

                            if (this.$improvement.hasUnique(UniqueType.Unavailable, stateForConditionals)) {
                                this.L$0 = $this$sequence;
                                this.L$1 = stateForConditionals;
                                this.label = 6;
                                v9 = $this$sequence.yield(ImprovementBuildingProblem.ConditionallyUnbuildable, this);
                                if (v9 == var22_2) {
                                    return var22_2;
                                }
                            }
                            ** GOTO lbl116
                        }
                        case 6: {
                            stateForConditionals = (StateForConditionals)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v9 = $result;
lbl116:
                            // 2 sources

                            if (!Intrinsics.areEqual(this.this$0.getTile().getOwner(), this.$civInfo) && !this.$improvement.hasUnique(UniqueType.CanBuildOutsideBorders, stateForConditionals)) {
                                if (this.$improvement.hasUnique(UniqueType.CanBuildJustOutsideBorders, stateForConditionals)) break;
                                this.L$0 = $this$sequence;
                                this.L$1 = stateForConditionals;
                                this.label = 7;
                                v10 = $this$sequence.yield(ImprovementBuildingProblem.OutsideBorders, this);
                                if (v10 == var22_2) {
                                    return var22_2;
                                }
                            }
                            ** GOTO lbl155
                        }
                        case 7: {
                            stateForConditionals = (StateForConditionals)this.L$1;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v10 = $result;
                            ** GOTO lbl155
                        }
                    }
                    $this$any$iv = this.this$0.getTile().getNeighbors();
                    $i$f$any = this.$civInfo;
                    $i$f$none = false;
                    for (Iterable element$iv : $this$none$iv) {
                        it = (Tile)element$iv /* !! */ ;
                        $i$a$-none-TileImprovementFunctions$getImprovementBuildingProblems$1$3 = false;
                        if (!Intrinsics.areEqual(it.getOwner(), $i$f$any)) continue;
                        v11 = false;
                        break block53;
                    }
                    v11 = true;
                }
                if (v11) {
                    this.L$0 = $this$sequence;
                    this.L$1 = stateForConditionals;
                    this.label = 8;
                    v12 = $this$sequence.yield(ImprovementBuildingProblem.NotJustOutsideBorders, this);
                    if (v12 == var22_2) {
                        return var22_2;
                    }
                }
                ** GOTO lbl155
                {
                    case 8: {
                        stateForConditionals = (StateForConditionals)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v12 = $result;
lbl155:
                        // 4 sources

                        $this$any$iv = this.$improvement.getMatchingUniques(UniqueType.OnlyAvailable, StateForConditionals.Companion.getIgnoreConditionals());
                        $i$f$any = false;
                        $i$f$none = $this$any$iv.iterator();
                        while ($i$f$none.hasNext()) {
                            element$iv = $i$f$none.next();
                            it = (Unique)element$iv;
                            $i$a$-any-TileImprovementFunctions$getImprovementBuildingProblems$1$4 = false;
                            if (!(it.conditionalsApply(stateForConditionals) == false)) continue;
                            v13 = true;
                            ** GOTO lbl166
                        }
                        v13 = false;
lbl166:
                        // 2 sources

                        if (v13) {
                            this.L$0 = $this$sequence;
                            this.L$1 = stateForConditionals;
                            this.label = 9;
                            v14 = $this$sequence.yield(ImprovementBuildingProblem.UnmetConditional, this);
                            if (v14 == var22_2) {
                                return var22_2;
                            }
                        }
                        ** GOTO lbl179
                    }
                    case 9: {
                        stateForConditionals = (StateForConditionals)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v14 = $result;
lbl179:
                        // 2 sources

                        $this$any$iv = this.$improvement.getMatchingUniques(UniqueType.ObsoleteWith, stateForConditionals);
                        $i$f$any = this.$civInfo;
                        $i$f$any = false;
                        element$iv = $this$any$iv.iterator();
                        while (element$iv.hasNext()) {
                            element$iv /* !! */  = element$iv.next();
                            it = (Unique)element$iv /* !! */ ;
                            $i$a$-any-TileImprovementFunctions$getImprovementBuildingProblems$1$5 = false;
                            if (!$i$f$any.getTech().isResearched(it.getParams().get(0))) continue;
                            v15 = true;
                            ** GOTO lbl191
                        }
                        v15 = false;
lbl191:
                        // 2 sources

                        if (v15) {
                            this.L$0 = $this$sequence;
                            this.L$1 = stateForConditionals;
                            this.label = 10;
                            v16 = $this$sequence.yield(ImprovementBuildingProblem.Obsolete, this);
                            if (v16 == var22_2) {
                                return var22_2;
                            }
                        }
                        ** GOTO lbl204
                    }
                    case 10: {
                        stateForConditionals = (StateForConditionals)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v16 = $result;
lbl204:
                        // 2 sources

                        $this$any$iv = this.$improvement.getMatchingUniques(UniqueType.ConsumesResources, stateForConditionals);
                        $i$f$any = this.$civInfo;
                        $i$f$any = false;
                        element$iv = $this$any$iv.iterator();
                        while (element$iv.hasNext()) {
                            element$iv /* !! */  = element$iv.next();
                            it = (Unique)element$iv /* !! */ ;
                            $i$a$-any-TileImprovementFunctions$getImprovementBuildingProblems$1$6 = false;
                            v17 = $i$f$any.getResourceAmount(it.getParams().get(1)) < Integer.parseInt(it.getParams().get(0));
                            if (!v17) continue;
                            v18 = true;
                            ** GOTO lbl217
                        }
                        v18 = false;
lbl217:
                        // 2 sources

                        if (v18) {
                            this.L$0 = $this$sequence;
                            this.L$1 = stateForConditionals;
                            this.label = 11;
                            v19 = $this$sequence.yield(ImprovementBuildingProblem.MissingResources, this);
                            if (v19 == var22_2) {
                                return var22_2;
                            }
                        }
                        ** GOTO lbl230
                    }
                    case 11: {
                        stateForConditionals = (StateForConditionals)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v19 = $result;
lbl230:
                        // 2 sources

                        $this$any$iv = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)this.$improvement, UniqueType.CostsResources, null, 2, null);
                        $i$f$any = this.$civInfo;
                        $i$f$any = false;
                        element$iv = $this$any$iv.iterator();
                        while (element$iv.hasNext()) {
                            element$iv /* !! */  = element$iv.next();
                            it = (Unique)element$iv /* !! */ ;
                            $i$a$-any-TileImprovementFunctions$getImprovementBuildingProblems$1$7 = false;
                            v20 = $i$f$any.getResourceAmount(it.getParams().get(1)) < Integer.parseInt(it.getParams().get(0));
                            if (!v20) continue;
                            v21 = true;
                            ** GOTO lbl243
                        }
                        v21 = false;
lbl243:
                        // 2 sources

                        if (v21) {
                            this.L$0 = $this$sequence;
                            this.L$1 = stateForConditionals;
                            this.label = 12;
                            v22 = $this$sequence.yield(ImprovementBuildingProblem.MissingResources, this);
                            if (v22 == var22_2) {
                                return var22_2;
                            }
                        }
                        ** GOTO lbl256
                    }
                    case 12: {
                        stateForConditionals = (StateForConditionals)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v22 = $result;
lbl256:
                        // 2 sources

                        $this$filter$iv = this.this$0.getTile().getRuleset().getTileRemovals();
                        var6_16 = this.$civInfo;
                        $i$f$filter = false;
                        element$iv /* !! */  = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            rulesetImprovement = (TileImprovement)element$iv$iv;
                            $i$a$-filter-TileImprovementFunctions$getImprovementBuildingProblems$1$knownFeatureRemovals$1 = false;
                            $this$none$iv = RoadStatus.values();
                            $i$f$none = false;
                            var18_36 = $this$none$iv.length;
                            for (var17_35 = 0; var17_35 < var18_36; ++var17_35) {
                                it = element$iv = $this$none$iv[var17_35];
                                $i$a$-none-TileImprovementFunctions$getImprovementBuildingProblems$1$knownFeatureRemovals$1$1 = false;
                                if (!Intrinsics.areEqual(it.getRemoveAction(), rulesetImprovement.getName())) continue;
                                v23 = false;
                                ** GOTO lbl275
                            }
                            v23 = true;
lbl275:
                            // 2 sources

                            if (!v23) ** GOTO lbl-1000
                            if (rulesetImprovement.getTechRequired() == null) ** GOTO lbl-1000
                            v24 = var6_16.getTech();
                            v25 = rulesetImprovement.getTechRequired();
                            Intrinsics.checkNotNull(v25);
                            if (v24.isResearched(v25)) lbl-1000:
                            // 2 sources

                            {
                                v26 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v26 = false;
                            }
                            if (!v26) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        knownFeatureRemovals = (List)destination$iv$iv;
                        if (!TileImprovementFunctions.canImprovementBeBuiltHere$core$default(this.this$0, this.$improvement, this.this$0.getTile().hasViewableResource(this.$civInfo), knownFeatureRemovals, stateForConditionals, false, 16, null)) {
                            this.L$0 = null;
                            this.L$1 = null;
                            this.label = 13;
                            v27 = $this$sequence.yield(ImprovementBuildingProblem.Other, this);
                            if (v27 == var22_2) {
                                return var22_2;
                            }
                        }
                        ** GOTO lbl301
                    }
                    case 13: {
                        ResultKt.throwOnFailure($result);
                        v27 = $result;
lbl301:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super ImprovementBuildingProblem>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super ImprovementBuildingProblem> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canImprovementBeBuiltHere$core(@NotNull TileImprovement improvement2, boolean resourceIsVisible, @Nullable List<TileImprovement> knownFeatureRemovals, @NotNull StateForConditionals stateForConditionals, boolean isNormalizeCheck) {
        boolean bl;
        Object it;
        Object element$iv;
        int n;
        boolean $i$f$any;
        Object $this$any$iv;
        block33: {
            Intrinsics.checkNotNullParameter(improvement2, "improvement");
            Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
            if (Intrinsics.areEqual(improvement2.getName(), this.tile.getImprovement()) && !isNormalizeCheck) {
                return false;
            }
            if (this.tile.isCityCenter()) {
                if (!isNormalizeCheck) return false;
                if (!Intrinsics.areEqual(improvement2.getName(), "City center")) return false;
                return true;
            }
            if (Intrinsics.areEqual(improvement2.getName(), "Cancel improvement order")) {
                if (this.tile.getImprovementInProgress() == null) return false;
                return true;
            }
            $this$any$iv = RoadStatus.values();
            $i$f$any = false;
            int n2 = ((RoadStatus[])$this$any$iv).length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$any$iv[n];
                boolean bl2 = false;
                if (!Intrinsics.areEqual(((RoadStatus)it).getRemoveAction(), improvement2.getName())) continue;
                bl = true;
                break block33;
            }
            bl = false;
        }
        if (!bl) {
            Unique unique;
            boolean bl3;
            block34: {
                if (StringsKt.startsWith$default(improvement2.getName(), "Remove ", false, 2, null)) {
                    boolean bl4;
                    $this$any$iv = this.tile.getTerrainFeatures();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        Iterator iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object element$iv2 = iterator2.next();
                            String it2 = (String)element$iv2;
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual("Remove " + it2, improvement2.getName())) continue;
                            return true;
                        }
                        bl4 = false;
                    }
                    if (bl4) return true;
                    if (!Intrinsics.areEqual("Remove " + this.tile.getImprovement(), improvement2.getName())) return false;
                    return true;
                }
                $this$any$iv = RoadStatus.values();
                $i$f$any = false;
                int element$iv2 = ((RoadStatus[])$this$any$iv).length;
                for (n = 0; n < element$iv2; ++n) {
                    it = element$iv = $this$any$iv[n];
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual(((Enum)it).name(), improvement2.getName())) continue;
                    bl3 = true;
                    break block34;
                }
                bl3 = false;
            }
            if (bl3) {
                if (this.tile.isWater()) return false;
                if (RoadStatus.valueOf(improvement2.getName()).compareTo((Enum)this.tile.getRoadStatus()) <= 0) return false;
                return true;
            }
            if (this.tile.getImprovement() != null) {
                TileImprovement tileImprovement = this.tile.getTileImprovement();
                Intrinsics.checkNotNull(tileImprovement);
                if (tileImprovement.hasUnique(UniqueType.Irremovable, stateForConditionals)) {
                    return false;
                }
            }
            if (this.tile.getLastTerrain().getUnbuildable() && !TileImprovementFunctions.canImprovementBeBuiltHere$canBeBuiltOnThisUnbuildableTerrain(improvement2, this, stateForConditionals, improvement2, resourceIsVisible, knownFeatureRemovals)) {
                return false;
            }
            $this$any$iv = this.tile.getTerrainMatchingUniques(UniqueType.RestrictedBuildableImprovements, stateForConditionals);
            $i$f$any = false;
            Iterator iterator3 = $this$any$iv.iterator();
            while (iterator3.hasNext()) {
                Object element$iv3 = iterator3.next();
                unique = (Unique)element$iv3;
                boolean bl7 = false;
                if (!improvement2.matchesFilter(unique.getParams().get(0))) {
                    return false;
                }
                boolean bl8 = false;
                if (!bl8) continue;
                return false;
            }
            boolean bl9 = false;
            if (bl9) {
                return false;
            }
            $this$any$iv = improvement2.getMatchingUniques(UniqueType.CannotBuildOnTile, stateForConditionals);
            $i$f$any = false;
            iterator3 = $this$any$iv.iterator();
            while (iterator3.hasNext()) {
                Object element$iv4 = iterator3.next();
                unique = (Unique)element$iv4;
                boolean bl10 = false;
                if (!Tile.matchesTerrainFilter$default(this.tile, unique.getParams().get(0), null, 2, null)) continue;
                return false;
            }
            boolean bl11 = false;
            if (bl11) {
                return false;
            }
            Sequence<Unique> it3 = improvement2.getMatchingUniques(UniqueType.CanOnlyBeBuiltOnTile, stateForConditionals);
            boolean bl12 = false;
            if (SequencesKt.any(it3)) {
                Sequence<Unique> $this$any$iv2 = it3;
                boolean $i$f$any2 = false;
                Iterator<Unique> bl10 = $this$any$iv2.iterator();
                while (bl10.hasNext()) {
                    Unique element$iv5;
                    Unique unique2 = element$iv5 = bl10.next();
                    boolean bl13 = false;
                    if (!Tile.matchesTerrainFilter$default(this.tile, unique2.getParams().get(0), null, 2, null)) {
                        return false;
                    }
                    boolean bl14 = false;
                    if (!bl14) continue;
                    return false;
                }
                boolean bl15 = false;
                if (bl15) {
                    return false;
                }
            }
            boolean bl16 = false;
            if (bl16) {
                return false;
            }
            $this$any$iv = improvement2.getMatchingUniques(UniqueType.MustBeNextTo, stateForConditionals);
            $i$f$any = false;
            Iterator iterator4 = $this$any$iv.iterator();
            while (iterator4.hasNext()) {
                Object element$iv6 = iterator4.next();
                Unique it4 = (Unique)element$iv6;
                boolean bl17 = false;
                if (!Tile.isAdjacentTo$default(this.tile, it4.getParams().get(0), null, 2, null)) {
                    return false;
                }
                boolean bl18 = false;
                if (!bl18) continue;
                return false;
            }
            boolean bl19 = false;
            if (bl19) {
                return false;
            }
            if (improvement2.hasUnique(UniqueType.CanOnlyImproveResource, stateForConditionals)) {
                if (!resourceIsVisible) return false;
                if (!this.tile.getTileResource().isImprovedBy(improvement2.getName())) {
                    return false;
                }
            }
            if (improvement2.isAllowedOnFeature(this.tile.getLastTerrain())) {
                return true;
            }
            if (this.tile.isLand() && improvement2.canBeBuiltOn("Land")) {
                return true;
            }
            if (this.tile.isWater() && improvement2.canBeBuiltOn("Water")) {
                return true;
            }
            if (improvement2.hasUnique(UniqueType.ImprovementBuildableByFreshWater, stateForConditionals) && Tile.isAdjacentTo$default(this.tile, "Fresh water", null, 2, null)) {
                return true;
            }
            if (!resourceIsVisible) return false;
            if (!this.tile.getTileResource().isImprovedBy(improvement2.getName())) return false;
            return true;
        }
        boolean bl20 = Intrinsics.areEqual(this.tile.getRoadStatus().getRemoveAction(), improvement2.getName());
        return bl20;
    }

    public static /* synthetic */ boolean canImprovementBeBuiltHere$core$default(TileImprovementFunctions tileImprovementFunctions, TileImprovement tileImprovement, boolean bl, List list2, StateForConditionals stateForConditionals, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl3 = bl = tileImprovementFunctions.tile.getResource() != null;
        }
        if ((n & 4) != 0) {
            list2 = null;
        }
        if ((n & 8) != 0) {
            stateForConditionals = new StateForConditionals(null, null, null, tileImprovementFunctions.tile, null, null, null, null, null, false, 1015, null);
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return tileImprovementFunctions.canImprovementBeBuiltHere$core(tileImprovement, bl, list2, stateForConditionals, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public final void setImprovement(@Nullable String improvementName, @Nullable Civilization civToActivateBroaderEffects, @Nullable MapUnit unit) {
        TileImprovement improvementObject = (TileImprovement)((Map)this.tile.getRuleset().getTileImprovements()).get(improvementName);
        boolean improvementFieldHasChanged = false;
        String string = improvementName;
        boolean bl = string != null ? StringsKt.startsWith$default(string, "Remove ", false, 2, null) : false;
        if (bl) {
            this.activateRemovalImprovement(improvementName, civToActivateBroaderEffects);
        } else if (Intrinsics.areEqual(improvementName, "Road")) {
            this.tile.addRoad(RoadStatus.Road, civToActivateBroaderEffects);
        } else if (Intrinsics.areEqual(improvementName, "Railroad")) {
            this.tile.addRoad(RoadStatus.Railroad, civToActivateBroaderEffects);
        } else if (Intrinsics.areEqual(improvementName, "Repair")) {
            this.tile.setRepaired();
        } else {
            this.tile.setImprovementIsPillaged(false);
            this.tile.setImprovement(improvementName);
            improvementFieldHasChanged = true;
            this.removeCreatesOneImprovementMarker();
        }
        if (improvementFieldHasChanged && this.tile.getTileMap().hasGameInfo()) {
            for (Civilization civ : this.tile.getTileMap().getGameInfo().getCivilizations()) {
                if (civ.isDefeated() || !civ.isMajorCiv() || !Intrinsics.areEqual(civ, civToActivateBroaderEffects) && !this.tile.isVisible(civ)) continue;
                civ.setLastSeenImprovement(this.tile.getPosition(), improvementName);
            }
        }
        if (improvementObject != null && IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)improvementObject, UniqueType.RemovesFeaturesIfBuilt, null, 2, null)) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            Object feature;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.tile.getTerrainFeatureObjects();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                feature = (Terrain)element$iv$iv;
                boolean bl2 = false;
                String removingAction = "Remove " + ((NamedStats)feature).getName();
                boolean bl3 = ((Map)this.tile.getRuleset().getTileImprovements()).containsKey(removingAction) && !improvementObject.isAllowedOnFeature((Terrain)feature);
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List removableTerrainFeatures = (List)destination$iv$iv;
            $this$filter$iv = this.tile.getTerrainFeatures();
            Tile tile = this.tile;
            boolean $i$f$filterNot = false;
            $this$filterTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                boolean bl4;
                block19: {
                    feature = (String)element$iv$iv;
                    boolean bl5 = false;
                    Iterable $this$any$iv = removableTerrainFeatures;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Terrain it = (Terrain)element$iv;
                            boolean bl6 = false;
                            if (!Intrinsics.areEqual(it.getName(), feature)) continue;
                            bl4 = true;
                            break block19;
                        }
                        bl4 = false;
                    }
                }
                if (bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            tile.setTerrainFeatures((List)destination$iv$iv);
        }
        if (civToActivateBroaderEffects != null && improvementObject != null && IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)improvementObject, UniqueType.TakesOverAdjacentTiles, null, 2, null)) {
            this.takeOverTilesAround(civToActivateBroaderEffects, this.tile);
        }
        if (civToActivateBroaderEffects != null && improvementObject != null) {
            this.triggerImprovementUniques(improvementObject, civToActivateBroaderEffects, unit);
        }
        City city2 = this.tile.getOwningCity();
        if (civToActivateBroaderEffects != null && city2 != null) {
            CityStats.update$default(city2.getCityStats(), null, false, false, null, 15, null);
            city2.getCiv().getCache().updateCivResources();
            city2.reassignPopulationDeferred();
        }
    }

    public static /* synthetic */ void setImprovement$default(TileImprovementFunctions tileImprovementFunctions, String string, Civilization civilization, MapUnit mapUnit, int n, Object object) {
        if ((n & 2) != 0) {
            civilization = null;
        }
        if ((n & 4) != 0) {
            mapUnit = null;
        }
        tileImprovementFunctions.setImprovement(string, civilization, mapUnit);
    }

    private final void triggerImprovementUniques(TileImprovement improvement2, Civilization civ, MapUnit unit) {
        Object unique2;
        Unique it;
        Iterable $this$filterTo$iv$iv;
        StateForConditionals stateForConditionals = new StateForConditionals(civ, null, unit, this.tile, null, null, null, null, null, false, 1010, null);
        Iterable $this$filter$iv = improvement2.getUniqueObjects();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Unique)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !it.hasTriggerConditional() && it.conditionalsApply(stateForConditionals);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Object unique2 : (List)destination$iv$iv) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, (Unique)unique2, civ, null, unit, this.tile, null, null, 100, null);
        }
        unique2 = civ.getTriggeredUniques(UniqueType.TriggerUponBuildingImprovement, stateForConditionals);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Unique)element$iv$iv;
            boolean bl = false;
            if (!improvement2.matchesFilter(it.getParams().get(0))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Object unique2 : (List)destination$iv$iv) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, (Unique)unique2, civ, null, unit, this.tile, null, null, 100, null);
        }
        if (unit == null) {
            return;
        }
        Iterator<Object> iterator2 = SequencesKt.filter(unit.getTriggeredUniques(UniqueType.TriggerUponBuildingImprovement, stateForConditionals), (Function1)new Function1<Unique, Boolean>(improvement2){
            final /* synthetic */ TileImprovement $improvement;
            {
                this.$improvement = $improvement;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Unique it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$improvement.matchesFilter(it.getParams().get(0));
            }
        }).iterator();
        while (iterator2.hasNext()) {
            unique2 = (Unique)iterator2.next();
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, (Unique)unique2, civ, null, unit, this.tile, null, null, 100, null);
        }
    }

    static /* synthetic */ void triggerImprovementUniques$default(TileImprovementFunctions tileImprovementFunctions, TileImprovement tileImprovement, Civilization civilization, MapUnit mapUnit, int n, Object object) {
        if ((n & 4) != 0) {
            mapUnit = null;
        }
        tileImprovementFunctions.triggerImprovementUniques(tileImprovement, civilization, mapUnit);
    }

    private final void activateRemovalImprovement(String improvementName, Civilization civToActivateBroaderEffects) {
        boolean bl;
        String removedFeatureName;
        block12: {
            boolean $i$f$any;
            Object $this$any$iv;
            removedFeatureName = StringsKt.removePrefix(improvementName, (CharSequence)"Remove ");
            TileImprovement currentTileImprovement = this.tile.getTileImprovement();
            if (currentTileImprovement != null) {
                boolean bl2;
                block11: {
                    $this$any$iv = this.tile.getTerrainFeatures();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        Iterator iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object element$iv = iterator2.next();
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!(currentTileImprovement.getTerrainsCanBeBuiltOn().contains(it) && Intrinsics.areEqual(it, removedFeatureName))) continue;
                            bl2 = true;
                            break block11;
                        }
                        bl2 = false;
                    }
                }
                if (bl2 && !currentTileImprovement.getTerrainsCanBeBuiltOn().contains(this.tile.getBaseTerrain())) {
                    this.tile.removeImprovement();
                }
            }
            $this$any$iv = RoadStatus.values();
            $i$f$any = false;
            int n = ((RoadStatus[])$this$any$iv).length;
            for (int i = 0; i < n; ++i) {
                Object element$iv;
                Object it = element$iv = $this$any$iv[i];
                boolean bl4 = false;
                if (!Intrinsics.areEqual(improvementName, ((RoadStatus)it).getRemoveAction())) continue;
                bl = true;
                break block12;
            }
            bl = false;
        }
        if (bl) {
            this.tile.removeRoad();
        } else if (Intrinsics.areEqual(this.tile.getImprovement(), removedFeatureName)) {
            this.tile.removeImprovement();
        } else {
            Terrain removedFeatureObject = this.tile.getRuleset().getTerrains().get(removedFeatureName);
            if (removedFeatureObject != null && civToActivateBroaderEffects != null && IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)removedFeatureObject, UniqueType.ProductionBonusWhenRemoved, null, 2, null)) {
                this.tryProvideProductionToClosestCity(removedFeatureName, civToActivateBroaderEffects);
            }
            this.tile.removeTerrainFeature(removedFeatureName);
        }
    }

    private final void tryProvideProductionToClosestCity(String removedTerrainFeature, Civilization civ) {
        int productionPointsToAdd;
        City closestCity;
        block11: {
            block10: {
                Object v0;
                Iterable $this$minByOrNull$iv = civ.getCities();
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = minElem$iv;
                    } else {
                        City it = (City)minElem$iv;
                        boolean bl = false;
                        int minValue$iv = it.getCenterTile().aerialDistanceTo(this.tile);
                        do {
                            Object e$iv = iterator$iv.next();
                            City it2 = (City)e$iv;
                            $i$a$-minByOrNull-TileImprovementFunctions$tryProvideProductionToClosestCity$closestCity$1 = false;
                            int v$iv = it2.getCenterTile().aerialDistanceTo(this.tile);
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = minElem$iv;
                    }
                }
                City city2 = v0;
                if (city2 == null) {
                    return;
                }
                closestCity = city2;
                int distance = closestCity.getCenterTile().aerialDistanceTo(this.tile);
                int n = productionPointsToAdd = distance == 1 ? 20 : 20 - (distance - 2) * 5;
                if (this.tile.getOwningCity() == null) break block10;
                City city3 = this.tile.getOwningCity();
                Intrinsics.checkNotNull(city3);
                if (Intrinsics.areEqual(city3.getCiv(), civ)) break block11;
            }
            productionPointsToAdd = productionPointsToAdd * 2 / 3;
        }
        if (productionPointsToAdd > 0) {
            closestCity.getCityConstructions().addProductionPoints(productionPointsToAdd);
            Object[] objectArray = new Vector2[]{this.tile.getPosition(), closestCity.getLocation()};
            Sequence<LocationAction> locations = LocationAction.Companion.invoke((Vector2[])objectArray);
            objectArray = new String[]{"StatIcons/Production"};
            civ.addNotification("Clearing a [" + removedTerrainFeature + "] has created [" + productionPointsToAdd + "] Production for [" + closestCity.getName() + ']', locations, Notification.NotificationCategory.Production, (String[])objectArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void takeOverTilesAround(Civilization civ, Tile tile) {
        IsPartOfGameInfoSerialization isPartOfGameInfoSerialization;
        Object v0;
        void $this$minByOrNull$iv;
        Sequence<Tile> sequence = SequencesKt.filter(tile.getNeighbors(), (Function1)new Function1<Tile, Boolean>(civ){
            final /* synthetic */ Civilization $civ;
            {
                this.$civ = $civ;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getOwner(), this.$civ);
            }
        });
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                Tile it = (Tile)minElem$iv;
                boolean bl = false;
                int minValue$iv = TileImprovementFunctions.takeOverTilesAround$priority(it);
                do {
                    Object e$iv = iterator$iv.next();
                    Tile it2 = (Tile)e$iv;
                    $i$a$-minByOrNull-TileImprovementFunctions$takeOverTilesAround$nearestCity$2 = false;
                    int v$iv = TileImprovementFunctions.takeOverTilesAround$priority(it2);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        if ((isPartOfGameInfoSerialization = (Tile)v0) == null || (isPartOfGameInfoSerialization = isPartOfGameInfoSerialization.getCity()) == null) {
            isPartOfGameInfoSerialization = TileImprovementFunctions.takeOverTilesAround$fallbackNearestCity(civ, tile);
        }
        IsPartOfGameInfoSerialization nearestCity2 = isPartOfGameInfoSerialization;
        Sequence<Tile> tilesToTakeOver2 = SequencesKt.filter(tile.getTilesInDistance(1), (Function1)new Function1<Tile, Boolean>(civ){
            final /* synthetic */ Civilization $civ;
            {
                this.$civ = $civ;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !it.isCityCenter() && !Intrinsics.areEqual(it.getOwner(), this.$civ);
            }
        });
        Set civsToNotify = new LinkedHashSet();
        Iterator<Tile> iterator2 = tilesToTakeOver2.iterator();
        while (iterator2.hasNext()) {
            Tile tileToTakeOver = iterator2.next();
            Civilization otherCiv = tileToTakeOver.getOwner();
            if (otherCiv != null) {
                otherCiv.getDiplomacyManagerOrMeet(civ).addModifier(DiplomaticModifiers.StealingTerritory, -10.0f);
                civsToNotify.add(otherCiv);
            }
            ((City)nearestCity2).getExpansion().takeOwnership(tileToTakeOver);
        }
        for (Civilization otherCiv : civsToNotify) {
            String[] stringArray = new String[]{civ.getCivName(), "OtherIcons/Pillage"};
            otherCiv.addNotification("Your territory has been stolen by [" + civ + "]!", tile.getPosition(), Notification.NotificationCategory.Cities, stringArray);
        }
    }

    public final void markForCreatesOneImprovement(@NotNull String improvement2) {
        Intrinsics.checkNotNullParameter(improvement2, "improvement");
        this.tile.stopWorkingOnImprovement();
        this.tile.queueImprovement(improvement2, -1);
    }

    public final void removeCreatesOneImprovementMarker() {
        if (!this.tile.isMarkedForCreatesOneImprovement()) {
            return;
        }
        IsPartOfGameInfoSerialization isPartOfGameInfoSerialization = this.tile.getOwningCity();
        if (isPartOfGameInfoSerialization != null && (isPartOfGameInfoSerialization = ((City)isPartOfGameInfoSerialization).getCityConstructions()) != null) {
            String string = this.tile.getImprovementInProgress();
            Intrinsics.checkNotNull(string);
            ((CityConstructions)isPartOfGameInfoSerialization).removeCreateOneImprovementConstruction(string);
        }
        this.tile.stopWorkingOnImprovement();
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean canImprovementBeBuiltHere$canBeBuiltOnThisUnbuildableTerrain(TileImprovement $this$canImprovementBeBuiltHere_u24canBeBuiltOnThisUnbuildableTerrain, TileImprovementFunctions this$0, StateForConditionals $stateForConditionals, TileImprovement $improvement, boolean $resourceIsVisible, List<TileImprovement> knownFeatureRemovals) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Object element$iv3;
        boolean bl;
        List featureRemovals;
        block15: {
            Iterator $this$mapNotNullTo$iv$iv;
            Terrain topTerrain = this$0.tile.getLastTerrain();
            if ($this$canImprovementBeBuiltHere_u24canBeBuiltOnThisUnbuildableTerrain.isAllowedOnFeature(topTerrain)) {
                return true;
            }
            if (!$this$canImprovementBeBuiltHere_u24canBeBuiltOnThisUnbuildableTerrain.hasUnique(UniqueType.RemovesFeaturesIfBuilt, $stateForConditionals)) {
                return false;
            }
            Collection collection = knownFeatureRemovals;
            if (collection == null || collection.isEmpty()) {
                return false;
            }
            Iterable $this$mapNotNull$iv = this$0.tile.getTerrainFeatures();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                TileImprovement it$iv$iv;
                Object v0;
                block14: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    String feature = (String)element$iv$iv;
                    boolean bl3 = false;
                    Iterable $this$firstOrNull$iv = this$0.tile.getRuleset().getTileRemovals();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        TileImprovement it = (TileImprovement)element$iv2;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual(it.getName(), "Remove " + feature)) continue;
                        v0 = element$iv2;
                        break block14;
                    }
                    v0 = null;
                }
                if ((TileImprovement)v0 == null) continue;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            featureRemovals = (List)destination$iv$iv;
            if (featureRemovals.isEmpty()) {
                return false;
            }
            Iterable $this$any$iv = featureRemovals;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv3 : $this$any$iv) {
                    TileImprovement it = (TileImprovement)element$iv3;
                    boolean bl6 = false;
                    if (!(!knownFeatureRemovals.contains(it))) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Tile clonedTile = this$0.tile.clone();
        Iterable $i$f$any = this$0.tile.getTerrainFeatures();
        Tile tile = clonedTile;
        boolean $i$f$filterNot = false;
        element$iv3 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl7;
            block16: {
                String feature = (String)element$iv$iv;
                boolean bl8 = false;
                Iterable $this$any$iv = featureRemovals;
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl7 = false;
                } else {
                    for (Object element$iv4 : $this$any$iv) {
                        TileImprovement it = (TileImprovement)element$iv4;
                        boolean bl9 = false;
                        if (!Intrinsics.areEqual(StringsKt.removePrefix(it.getName(), (CharSequence)"Remove "), feature)) continue;
                        bl7 = true;
                        break block16;
                    }
                    bl7 = false;
                }
            }
            if (bl7) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        tile.setTerrainFeatures((List)destination$iv$iv);
        return TileImprovementFunctions.canImprovementBeBuiltHere$core$default(clonedTile.getImprovementFunctions(), $improvement, $resourceIsVisible, knownFeatureRemovals, $stateForConditionals, false, 16, null);
    }

    static /* synthetic */ boolean canImprovementBeBuiltHere$canBeBuiltOnThisUnbuildableTerrain$default(TileImprovement tileImprovement, TileImprovementFunctions tileImprovementFunctions, StateForConditionals stateForConditionals, TileImprovement tileImprovement2, boolean bl, List list2, int n, Object object) {
        if ((n & 0x10) != 0) {
            list2 = null;
        }
        return TileImprovementFunctions.canImprovementBeBuiltHere$canBeBuiltOnThisUnbuildableTerrain(tileImprovement, tileImprovementFunctions, stateForConditionals, tileImprovement2, bl, list2);
    }

    private static final int takeOverTilesAround$priority(Tile tile) {
        City city2 = tile.getCity();
        Intrinsics.checkNotNull(city2);
        City city3 = city2;
        return city3.getCenterTile().aerialDistanceTo(tile) + (city3.isBeingRazed() ? 5 : 0);
    }

    private static final City takeOverTilesAround$fallbackNearestCity(Civilization civ, Tile tile) {
        Object v0;
        Iterable $this$minByOrNull$iv = civ.getCities();
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                City it = (City)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getCenterTile().aerialDistanceTo(tile) + (it.isBeingRazed() ? 5 : 0);
                do {
                    Object e$iv = iterator$iv.next();
                    City it2 = (City)e$iv;
                    $i$a$-minByOrNull-TileImprovementFunctions$takeOverTilesAround$fallbackNearestCity$1 = false;
                    int v$iv = it2.getCenterTile().aerialDistanceTo(tile) + (it2.isBeingRazed() ? 5 : 0);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }
}

