/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.tile;

import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileStatFunctionsKt;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.NamedStats;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J@\u0010\u0015\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e0\u00170\u0016j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e0\u0017`\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J*\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ8\u0010 \u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e0\u00170\u0016j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e0\u0017`\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u001cJ>\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e0\"j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e`#2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010$\u001a\u00020\u001fJ\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000eJ\u0010\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\u000eH\u0002J$\u0010*\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010+\u001a\u00020\u001fJ\u001a\u0010*\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010+\u001a\u00020\u001fJ6\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000e0\u00170-2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010+\u001a\u00020\u001fJ\u0018\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020\u000eH\u0002R\u001d\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00060"}, d2={"Lcom/unciv/logic/map/tile/TileStatFunctions;", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "(Lcom/unciv/logic/map/tile/Tile;)V", "riverTerrain", "Lcom/unciv/models/ruleset/tile/Terrain;", "getRiverTerrain", "()Lcom/unciv/models/ruleset/tile/Terrain;", "riverTerrain$delegate", "Lkotlin/Lazy;", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "getExtraImprovementStats", "Lcom/unciv/models/stats/Stats;", "improvement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "observingCiv", "Lcom/unciv/logic/civilization/Civilization;", "city", "Lcom/unciv/logic/city/City;", "getSingleTerrainStats", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "", "Lkotlin/collections/ArrayList;", "terrain", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "getStatDiffForImprovement", "cityUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "getTerrainStatsBreakdown", "getTilePercentageStats", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "uniqueCache", "getTileStartScore", "", "cityCenterMinStats", "getTileStartYield", "minimumStats", "getTileStats", "localUniqueCache", "getTileStatsBreakdown", "", "missingFromMinimum", "current", "core"})
@SourceDebugExtension(value={"SMAP\nTileStatFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileStatFunctions.kt\ncom/unciv/logic/map/tile/TileStatFunctions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,321:1\n766#2:322\n857#2,2:323\n1549#2:325\n1620#2,3:326\n1229#3,2:329\n1229#3,2:331\n1250#3,3:333\n*S KotlinDebug\n*F\n+ 1 TileStatFunctions.kt\ncom/unciv/logic/map/tile/TileStatFunctions\n*L\n129#1:322\n129#1:323,2\n129#1:325\n129#1:326,3\n246#1:329,2\n250#1:331,2\n302#1:333,3\n*E\n"})
public final class TileStatFunctions {
    @NotNull
    private final Tile tile;
    @NotNull
    private final Lazy riverTerrain$delegate;

    public TileStatFunctions(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        this.tile = tile;
        this.riverTerrain$delegate = LazyKt.lazy((Function0)new Function0<Terrain>(this){
            final /* synthetic */ TileStatFunctions this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Terrain invoke() {
                return this.this$0.getTile().getRuleset().getTerrains().get("River");
            }
        });
    }

    @NotNull
    public final Tile getTile() {
        return this.tile;
    }

    private final Terrain getRiverTerrain() {
        Lazy lazy = this.riverTerrain$delegate;
        return (Terrain)lazy.getValue();
    }

    @NotNull
    public final Stats getTileStats(@Nullable Civilization observingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        return this.getTileStats(this.tile.getCity(), observingCiv, localUniqueCache);
    }

    public static /* synthetic */ Stats getTileStats$default(TileStatFunctions tileStatFunctions, Civilization civilization, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 2) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        return tileStatFunctions.getTileStats(civilization, localUniqueCache);
    }

    @NotNull
    public final Stats getTileStats(@Nullable City city2, @Nullable Civilization observingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        List<Pair<String, Stats>> statsBreakdown = this.getTileStatsBreakdown(city2, observingCiv, localUniqueCache);
        String improvement2 = this.tile.getUnpillagedImprovement();
        RoadStatus road = this.tile.getUnpillagedRoad();
        HashMap<String, Stats> percentageStats = this.getTilePercentageStats(observingCiv, city2, localUniqueCache);
        for (Pair<String, Stats> stats2 : statsBreakdown) {
            String string = stats2.getFirst();
            String tileType = Intrinsics.areEqual(string, improvement2) ? "Improvement" : (Intrinsics.areEqual(string, road.name()) ? "Road" : "Terrain");
            Stats stats3 = percentageStats.get(tileType);
            Intrinsics.checkNotNull(stats3);
            for (Stats.StatValuePair statValuePair : stats3) {
                Stat stat = statValuePair.component1();
                float value = statValuePair.component2();
                Stats stats4 = stats2.getSecond();
                stats4.set(stat, stats4.get(stat) * FormattingExtensionsKt.toPercent(value));
            }
        }
        return TileStatFunctionsKt.toStats((Iterable<? extends Pair<String, ? extends Stats>>)statsBreakdown);
    }

    public static /* synthetic */ Stats getTileStats$default(TileStatFunctions tileStatFunctions, City city2, Civilization civilization, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 4) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        return tileStatFunctions.getTileStats(city2, civilization, localUniqueCache);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<String, Stats>> getTileStatsBreakdown(@Nullable City city2, @Nullable Civilization observingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair it;
        void $this$filterTo$iv$iv;
        Stats minimumStats;
        Object unique;
        Stats roadStats;
        TileImprovement road;
        Stats stats2;
        Stats improvementStats;
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        StateForConditionals stateForConditionals = new StateForConditionals(observingCiv, city2, null, this.tile, null, null, null, null, null, false, 1012, null);
        ArrayList<Pair<String, Stats>> listOfStats = this.getTerrainStatsBreakdown(stateForConditionals);
        TileImprovement improvement2 = this.tile.getUnpillagedTileImprovement();
        Stats stats3 = improvement2;
        if (stats3 == null || (stats3 = ((NamedStats)stats3).cloneStats()) == null) {
            stats3 = improvementStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        }
        if ((stats2 = (road = this.tile.getUnpillagedRoadImprovement())) == null || (stats2 = ((NamedStats)stats2).cloneStats()) == null) {
            stats2 = roadStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        }
        if (city2 != null) {
            Sequence<Unique> statsFromTilesUniques2 = SequencesKt.filter(localUniqueCache.forCityGetMatchingUniques(city2, UniqueType.StatsFromTiles, stateForConditionals), (Function1)new Function1<Unique, Boolean>(city2){
                final /* synthetic */ City $city;
                {
                    this.$city = $city;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Unique it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return City.matchesFilter$default(this.$city, it.getParams().get(2), null, 2, null);
                }
            });
            Sequence<Unique> statsFromObjectsUniques = localUniqueCache.forCityGetMatchingUniques(city2, UniqueType.StatsFromObject, stateForConditionals);
            Sequence<Unique> statsFromTilesWithoutUniques2 = SequencesKt.filter(localUniqueCache.forCityGetMatchingUniques(city2, UniqueType.StatsFromTilesWithout, stateForConditionals), (Function1)new Function1<Unique, Boolean>(city2, this){
                final /* synthetic */ City $city;
                final /* synthetic */ TileStatFunctions this$0;
                {
                    this.$city = $city;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Unique it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return City.matchesFilter$default(this.$city, it.getParams().get(3), null, 2, null) && !Tile.matchesFilter$default(this.this$0.getTile(), it.getParams().get(2), null, false, 6, null);
                }
            });
            Iterator<Unique> iterator2 = SequencesKt.plus(SequencesKt.plus(statsFromTilesUniques2, statsFromObjectsUniques), statsFromTilesWithoutUniques2).iterator();
            while (iterator2.hasNext()) {
                unique = iterator2.next();
                String tileType = ((Unique)unique).getParams().get(1);
                if (this.tile.matchesFilter(tileType, observingCiv, true)) {
                    listOfStats.add(TuplesKt.to('{' + ((Unique)unique).getSourceObjectName() + "} ({" + ((Unique)unique).getDisplayText() + "})", ((Unique)unique).getStats()));
                    continue;
                }
                if (improvement2 != null && improvement2.matchesFilter(tileType)) {
                    improvementStats.add(((Unique)unique).getStats());
                    continue;
                }
                if (road == null || !road.matchesFilter(tileType)) continue;
                roadStats.add(((Unique)unique).getStats());
            }
        }
        if (this.tile.isAdjacentToRiver()) {
            if (this.getRiverTerrain() == null) {
                listOfStats.add(TuplesKt.to("River", new Stats(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 123, null)));
            } else {
                Collection collection = listOfStats;
                Terrain terrain2 = this.getRiverTerrain();
                Intrinsics.checkNotNull(terrain2);
                CollectionsKt.addAll(collection, (Iterable)this.getSingleTerrainStats(terrain2, stateForConditionals));
            }
        }
        Stats stats4 = minimumStats = this.tile.isCityCenter() ? Stats.Companion.getDefaultCityCenterMinimum() : Stats.Companion.getZERO();
        if (observingCiv != null) {
            Unique ensureMinUnique;
            if (this.tile.hasViewableResource(observingCiv)) {
                listOfStats.add(TuplesKt.to(this.tile.getTileResource().getName(), this.tile.getTileResource()));
            }
            if (improvement2 != null) {
                improvementStats.add(this.getExtraImprovementStats(improvement2, observingCiv, city2));
            }
            if (road != null) {
                roadStats.add(this.getExtraImprovementStats(road, observingCiv, city2));
            }
            if (improvement2 != null && (ensureMinUnique = SequencesKt.firstOrNull(improvement2.getMatchingUniques(UniqueType.EnsureMinimumStats, stateForConditionals))) != null) {
                minimumStats = ensureMinUnique.getStats();
            }
        }
        if (road != null) {
            listOfStats.add(TuplesKt.to(road.getName(), roadStats));
        }
        if (improvement2 != null) {
            listOfStats.add(TuplesKt.to(improvement2.getName(), improvementStats));
        }
        Stats statsFromMinimum = this.missingFromMinimum(TileStatFunctionsKt.toStats((Iterable<? extends Pair<String, ? extends Stats>>)listOfStats), minimumStats);
        listOfStats.add(TuplesKt.to("Minimum", statsFromMinimum));
        if (observingCiv != null && !(TileStatFunctionsKt.toStats((Iterable<? extends Pair<String, ? extends Stats>>)listOfStats).getGold() == 0.0f) && observingCiv.getGoldenAges().isGoldenAge()) {
            listOfStats.add(TuplesKt.to("Golden Age", new Stats(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 123, null)));
        }
        Iterable $this$filter$iv = listOfStats;
        boolean $i$f$filter = false;
        unique = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(!((Stats)it.getSecond()).isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getFirst(), ((Stats)it.getSecond()).clone()));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getTileStatsBreakdown$default(TileStatFunctions tileStatFunctions, City city2, Civilization civilization, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 4) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        return tileStatFunctions.getTileStatsBreakdown(city2, civilization, localUniqueCache);
    }

    private final Stats missingFromMinimum(Stats current, Stats minimumStats) {
        Stats missingStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        for (Stat stat : Stat.values()) {
            if (!(current.get(stat) < minimumStats.get(stat))) continue;
            missingStats.set(stat, minimumStats.get(stat) - current.get(stat));
        }
        return missingStats;
    }

    private final ArrayList<Pair<String, Stats>> getSingleTerrainStats(Terrain terrain2, StateForConditionals stateForConditionals) {
        Object object = new Pair[1];
        String string = terrain2.getName();
        Intrinsics.checkNotNull(terrain2, "null cannot be cast to non-null type com.unciv.models.stats.Stats");
        object[0] = TuplesKt.to(string, (Stats)terrain2);
        ArrayList<Pair<String, Stats>> list2 = CollectionsKt.arrayListOf(object);
        object = terrain2.getMatchingUniques(UniqueType.Stats, stateForConditionals).iterator();
        while (object.hasNext()) {
            Unique unique = (Unique)object.next();
            list2.add(TuplesKt.to(terrain2.getName() + ": " + unique.getDisplayText(), unique.getStats()));
        }
        return list2;
    }

    @NotNull
    public final ArrayList<Pair<String, Stats>> getTerrainStatsBreakdown(@NotNull StateForConditionals stateForConditionals) {
        Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
        ArrayList<Pair<String, Stats>> list2 = new ArrayList<Pair<String, Stats>>();
        Iterator<Terrain> iterator2 = this.tile.getAllTerrains().iterator();
        while (iterator2.hasNext()) {
            Terrain terrain2 = iterator2.next();
            ArrayList<Pair<String, Stats>> terrainStats = this.getSingleTerrainStats(terrain2, stateForConditionals);
            if (terrain2.hasUnique(UniqueType.NullifyYields, stateForConditionals)) {
                return terrainStats;
            }
            if (terrain2.getOverrideStats()) {
                list2 = terrainStats;
                continue;
            }
            CollectionsKt.addAll((Collection)list2, (Iterable)terrainStats);
        }
        return list2;
    }

    public static /* synthetic */ ArrayList getTerrainStatsBreakdown$default(TileStatFunctions tileStatFunctions, StateForConditionals stateForConditionals, int n, Object object) {
        if ((n & 1) != 0) {
            stateForConditionals = new StateForConditionals(null, null, null, null, null, null, null, null, null, false, 1023, null);
        }
        return tileStatFunctions.getTerrainStatsBreakdown(stateForConditionals);
    }

    @NotNull
    public final HashMap<String, Stats> getTilePercentageStats(@Nullable Civilization observingCiv, @Nullable City city2, @NotNull LocalUniqueCache uniqueCache) {
        Intrinsics.checkNotNullParameter(uniqueCache, "uniqueCache");
        Stats terrainStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        StateForConditionals stateForConditionals = new StateForConditionals(observingCiv, city2, null, this.tile, null, null, null, null, null, false, 1012, null);
        TileImprovement improvement2 = this.tile.getUnpillagedTileImprovement();
        Stats improvementStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        TileImprovement road = this.tile.getUnpillagedRoadImprovement();
        Stats roadStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        if (city2 != null) {
            Object unique;
            Sequence<Unique> cachedStatPercentFromObjectCityUniques = uniqueCache.forCityGetMatchingUniques(city2, UniqueType.StatPercentFromObject, stateForConditionals);
            Iterator<Unique> iterator2 = cachedStatPercentFromObjectCityUniques.iterator();
            while (iterator2.hasNext()) {
                unique = iterator2.next();
                TileStatFunctions.getTilePercentageStats$addStats(this, observingCiv, terrainStats, improvement2, improvementStats, road, roadStats, ((Unique)unique).getParams().get(2), Stat.valueOf(((Unique)unique).getParams().get(1)), Float.parseFloat(((Unique)unique).getParams().get(0)));
            }
            Sequence<Unique> cachedAllStatPercentFromObjectCityUniques = uniqueCache.forCityGetMatchingUniques(city2, UniqueType.AllStatsPercentFromObject, stateForConditionals);
            unique = cachedAllStatPercentFromObjectCityUniques.iterator();
            while (unique.hasNext()) {
                Unique unique2 = (Unique)unique.next();
                for (Stat stat : Stat.values()) {
                    TileStatFunctions.getTilePercentageStats$addStats(this, observingCiv, terrainStats, improvement2, improvementStats, road, roadStats, unique2.getParams().get(1), stat, Float.parseFloat(unique2.getParams().get(0)));
                }
            }
        } else if (observingCiv != null) {
            Sequence<Unique> cachedStatPercentFromObjectCivUniques = uniqueCache.forCivGetMatchingUniques(observingCiv, UniqueType.StatPercentFromObject, stateForConditionals);
            Iterator<Unique> cachedAllStatPercentFromObjectCityUniques = cachedStatPercentFromObjectCivUniques.iterator();
            while (cachedAllStatPercentFromObjectCityUniques.hasNext()) {
                Unique unique = cachedAllStatPercentFromObjectCityUniques.next();
                TileStatFunctions.getTilePercentageStats$addStats(this, observingCiv, terrainStats, improvement2, improvementStats, road, roadStats, unique.getParams().get(2), Stat.valueOf(unique.getParams().get(1)), Float.parseFloat(unique.getParams().get(0)));
            }
            Sequence<Unique> cachedAllStatPercentFromObjectCivUniques = uniqueCache.forCivGetMatchingUniques(observingCiv, UniqueType.AllStatsPercentFromObject, stateForConditionals);
            Iterator<Unique> iterator3 = cachedAllStatPercentFromObjectCivUniques.iterator();
            while (iterator3.hasNext()) {
                Unique unique = iterator3.next();
                for (Stat stat : Stat.values()) {
                    TileStatFunctions.getTilePercentageStats$addStats(this, observingCiv, terrainStats, improvement2, improvementStats, road, roadStats, unique.getParams().get(1), stat, Float.parseFloat(unique.getParams().get(0)));
                }
            }
        }
        Pair[] pairArray = new Pair[]{new Pair<String, Stats>("Terrain", terrainStats), new Pair<String, Stats>("Improvement", improvementStats), new Pair<String, Stats>("Road", roadStats)};
        return MapsKt.hashMapOf(pairArray);
    }

    public final float getTileStartScore(@NotNull Stats cityCenterMinStats2) {
        boolean bl;
        Tile it;
        Tile element$iv;
        Iterator<Tile> iterator2;
        boolean $i$f$any;
        Sequence<Tile> $this$any$iv;
        float sum;
        block9: {
            Intrinsics.checkNotNullParameter(cityCenterMinStats2, "cityCenterMinStats");
            sum = 0.0f;
            Iterator<Tile> iterator3 = this.tile.getTilesInDistance(2).iterator();
            while (iterator3.hasNext()) {
                Tile closeTile = iterator3.next();
                float tileYield = closeTile.getStats().getTileStartYield(Intrinsics.areEqual(closeTile, this.tile) ? cityCenterMinStats2 : Stats.Companion.getZERO());
                sum += tileYield;
                if (!SequencesKt.contains(this.tile.getNeighbors(), closeTile)) continue;
                sum += tileYield;
            }
            if (this.tile.isHill()) {
                sum -= 2.0f;
            }
            if (this.tile.isAdjacentToRiver()) {
                sum += 2.0f;
            }
            $this$any$iv = this.tile.getNeighbors();
            $i$f$any = false;
            iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getBaseTerrain(), "Mountain")) continue;
                bl = true;
                break block9;
            }
            bl = false;
        }
        if (bl) {
            sum += 2.0f;
        }
        if (this.tile.isCoastalTile()) {
            sum += 3.0f;
        }
        if (!this.tile.isCoastalTile()) {
            boolean bl3;
            block10: {
                $this$any$iv = this.tile.getNeighbors();
                $i$f$any = false;
                iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    it = element$iv = iterator2.next();
                    boolean bl4 = false;
                    if (!it.isCoastalTile()) continue;
                    bl3 = true;
                    break block10;
                }
                bl3 = false;
            }
            if (bl3) {
                sum -= 7.0f;
            }
        }
        return sum;
    }

    private final float getTileStartYield(Stats minimumStats) {
        Stats $this$getTileStartYield_u24lambda_u244 = TileStatFunctionsKt.toStats(TileStatFunctions.getTerrainStatsBreakdown$default(this, null, 1, null));
        boolean bl = false;
        if (this.tile.getResource() != null) {
            $this$getTileStartYield_u24lambda_u244.add(this.tile.getTileResource());
        }
        $this$getTileStartYield_u24lambda_u244.add(this.missingFromMinimum($this$getTileStartYield_u24lambda_u244, minimumStats));
        return $this$getTileStartYield_u24lambda_u244.getFood() + $this$getTileStartYield_u24lambda_u244.getProduction() + $this$getTileStartYield_u24lambda_u244.getGold();
    }

    @NotNull
    public final Stats getStatDiffForImprovement(@NotNull TileImprovement improvement2, @NotNull Civilization observingCiv, @Nullable City city2, @NotNull LocalUniqueCache cityUniqueCache) {
        Intrinsics.checkNotNullParameter(improvement2, "improvement");
        Intrinsics.checkNotNullParameter(observingCiv, "observingCiv");
        Intrinsics.checkNotNullParameter(cityUniqueCache, "cityUniqueCache");
        Stats currentStats = this.getTileStats(city2, observingCiv, cityUniqueCache);
        Tile tileClone = this.tile.clone();
        tileClone.setTerrainTransients();
        Tile.setImprovement$default(tileClone, improvement2.getName(), null, null, 6, null);
        Stats futureStats = tileClone.getStats().getTileStats(city2, observingCiv, cityUniqueCache);
        return futureStats.minus(currentStats);
    }

    public static /* synthetic */ Stats getStatDiffForImprovement$default(TileStatFunctions tileStatFunctions, TileImprovement tileImprovement, Civilization civilization, City city2, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 8) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        return tileStatFunctions.getStatDiffForImprovement(tileImprovement, civilization, city2, localUniqueCache);
    }

    private final Stats getExtraImprovementStats(TileImprovement improvement2, Civilization observingCiv, City city2) {
        Unique unique;
        Stats stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        if (this.tile.hasViewableResource(observingCiv) && this.tile.getTileResource().isImprovedBy(improvement2.getName()) && this.tile.getTileResource().getImprovementStats() != null) {
            Stats stats3 = this.tile.getTileResource().getImprovementStats();
            Intrinsics.checkNotNull(stats3);
            stats2.add(stats3.clone());
        }
        StateForConditionals conditionalState = new StateForConditionals(observingCiv, city2, null, this.tile, null, null, null, null, null, false, 1012, null);
        Iterator<Unique> iterator2 = improvement2.getMatchingUniques(UniqueType.Stats, conditionalState).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            stats2.add(unique.getStats());
        }
        iterator2 = improvement2.getMatchingUniques(UniqueType.ImprovementStatsForAdjacencies, conditionalState).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            String adjacent = unique.getParams().get(1);
            Sequence<Tile> $this$count$iv = this.tile.getNeighbors();
            boolean $i$f$count = false;
            int count$iv = 0;
            Iterator<Tile> iterator3 = $this$count$iv.iterator();
            while (iterator3.hasNext()) {
                Tile element$iv;
                Tile it = element$iv = iterator3.next();
                boolean bl = false;
                boolean bl2 = Tile.matchesFilter$default(it, adjacent, observingCiv, false, 4, null) || Intrinsics.areEqual(it.getUnpillagedRoad().name(), adjacent);
                if (!bl2 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            int numberOfBonuses = count$iv;
            stats2.add(unique.getStats().times((float)numberOfBonuses));
        }
        iterator2 = improvement2.getMatchingUniques(UniqueType.ImprovementStatsOnTile, conditionalState).iterator();
        while (iterator2.hasNext()) {
            unique = iterator2.next();
            if (!Tile.matchesFilter$default(this.tile, unique.getParams().get(1), null, false, 6, null) && (!Intrinsics.areEqual(unique.getParams().get(1), "Fresh water") || !Tile.isAdjacentTo$default(this.tile, "Fresh water", null, 2, null)) && (!Intrinsics.areEqual(unique.getParams().get(1), "non-fresh water") || Tile.isAdjacentTo$default(this.tile, "Fresh water", null, 2, null))) continue;
            stats2.add(unique.getStats());
        }
        return stats2;
    }

    private static final void getTilePercentageStats$addStats(TileStatFunctions this$0, Civilization $observingCiv, Stats terrainStats, TileImprovement improvement2, Stats improvementStats, TileImprovement road, Stats roadStats, String filter2, Stat stat, float amount) {
        if (this$0.tile.matchesFilter(filter2, $observingCiv, true)) {
            terrainStats.add(stat, amount);
        } else if (improvement2 != null && improvement2.matchesFilter(filter2)) {
            improvementStats.add(stat, amount);
        } else if (road != null && road.matchesFilter(filter2)) {
            roadStats.add(stat, amount);
        }
    }
}

