/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.multiplayer;

import com.unciv.UncivGame;
import com.unciv.models.metadata.GameSettings;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u001e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u000fJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u000fJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000fJ\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fR \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/unciv/logic/multiplayer/FriendList;", "", "()V", "listOfFriends", "", "Lcom/unciv/logic/multiplayer/FriendList$Friend;", "getListOfFriends", "()Ljava/util/List;", "setListOfFriends", "(Ljava/util/List;)V", "settings", "Lcom/unciv/models/metadata/GameSettings;", "add", "Lcom/unciv/logic/multiplayer/FriendList$ErrorType;", "friendName", "", "playerID", "delete", "", "friend", "edit", "name", "getFriendById", "id", "getFriendByName", "getFriendsList", "isFriendIDInFriendList", "isFriendNameInFriendList", "ErrorType", "Friend", "core"})
@SourceDebugExtension(value={"SMAP\nFriendList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FriendList.kt\ncom/unciv/logic/multiplayer/FriendList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n288#2,2:78\n288#2,2:80\n288#2,2:82\n288#2,2:84\n*S KotlinDebug\n*F\n+ 1 FriendList.kt\ncom/unciv/logic/multiplayer/FriendList\n*L\n58#1:78,2\n66#1:80,2\n73#1:82,2\n75#1:84,2\n*E\n"})
public final class FriendList {
    @NotNull
    private final GameSettings settings = UncivGame.Companion.getCurrent().getSettings();
    @NotNull
    private List<Friend> listOfFriends = this.settings.getMultiplayer().getFriendList();

    @NotNull
    public final List<Friend> getListOfFriends() {
        return this.listOfFriends;
    }

    public final void setListOfFriends(@NotNull List<Friend> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.listOfFriends = list2;
    }

    @NotNull
    public final ErrorType add(@NotNull String friendName, @NotNull String playerID) {
        Intrinsics.checkNotNullParameter(friendName, "friendName");
        Intrinsics.checkNotNullParameter(playerID, "playerID");
        int n = this.listOfFriends.size();
        for (int index = 0; index < n; ++index) {
            if (Intrinsics.areEqual(this.listOfFriends.get(index).getName(), friendName)) {
                return ErrorType.NAME;
            }
            if (!Intrinsics.areEqual(this.listOfFriends.get(index).getPlayerID(), playerID)) continue;
            return ErrorType.ID;
        }
        if (Intrinsics.areEqual(friendName, "")) {
            return ErrorType.NONAME;
        }
        if (Intrinsics.areEqual(playerID, "")) {
            return ErrorType.NOID;
        }
        if (Intrinsics.areEqual(playerID, UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getUserId())) {
            return ErrorType.YOURSELF;
        }
        this.listOfFriends.add(new Friend(friendName, playerID));
        this.settings.save();
        return ErrorType.NOERROR;
    }

    public final void edit(@NotNull Friend friend, @NotNull String name2, @NotNull String playerID) {
        Intrinsics.checkNotNullParameter(friend, "friend");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(playerID, "playerID");
        this.listOfFriends.remove(friend);
        Friend editedFriend = new Friend(name2, playerID);
        this.listOfFriends.add(editedFriend);
        this.settings.save();
    }

    public final void delete(@NotNull Friend friend) {
        Intrinsics.checkNotNullParameter(friend, "friend");
        this.listOfFriends.remove(friend);
        this.settings.save();
    }

    @NotNull
    public final List<Friend> getFriendsList() {
        return this.listOfFriends;
    }

    @NotNull
    public final ErrorType isFriendNameInFriendList(@NotNull String name2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(name2, "name");
            Iterable $this$firstOrNull$iv = this.listOfFriends;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Friend it = (Friend)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0 != null ? ErrorType.ALREADYINLIST : ErrorType.NOERROR;
    }

    @NotNull
    public final ErrorType isFriendIDInFriendList(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(id, "id");
            Iterable $this$firstOrNull$iv = this.listOfFriends;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Friend it = (Friend)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getPlayerID(), id)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0 != null ? ErrorType.ALREADYINLIST : ErrorType.NOERROR;
    }

    @Nullable
    public final Friend getFriendById(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(id, "id");
            Iterable $this$firstOrNull$iv = this.listOfFriends;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Friend it = (Friend)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getPlayerID(), id)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Friend getFriendByName(@NotNull String name2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(name2, "name");
            Iterable $this$firstOrNull$iv = this.listOfFriends;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Friend it = (Friend)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/unciv/logic/multiplayer/FriendList$ErrorType;", "", "(Ljava/lang/String;I)V", "NOERROR", "NAME", "ID", "NONAME", "NOID", "YOURSELF", "ALREADYINLIST", "core"})
    public static final class ErrorType
    extends Enum<ErrorType> {
        public static final /* enum */ ErrorType NOERROR = new ErrorType();
        public static final /* enum */ ErrorType NAME = new ErrorType();
        public static final /* enum */ ErrorType ID = new ErrorType();
        public static final /* enum */ ErrorType NONAME = new ErrorType();
        public static final /* enum */ ErrorType NOID = new ErrorType();
        public static final /* enum */ ErrorType YOURSELF = new ErrorType();
        public static final /* enum */ ErrorType ALREADYINLIST = new ErrorType();
        private static final /* synthetic */ ErrorType[] $VALUES;

        public static ErrorType[] values() {
            return (ErrorType[])$VALUES.clone();
        }

        public static ErrorType valueOf(String value) {
            return Enum.valueOf(ErrorType.class, value);
        }

        static {
            $VALUES = errorTypeArray = new ErrorType[]{ErrorType.NOERROR, ErrorType.NAME, ErrorType.ID, ErrorType.NONAME, ErrorType.NOID, ErrorType.YOURSELF, ErrorType.ALREADYINLIST};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/unciv/logic/multiplayer/FriendList$Friend;", "", "()V", "name", "", "playerID", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getPlayerID", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    public static final class Friend {
        @NotNull
        private final String name;
        @NotNull
        private final String playerID;

        public Friend(@NotNull String name2, @NotNull String playerID) {
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(playerID, "playerID");
            this.name = name2;
            this.playerID = playerID;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getPlayerID() {
            return this.playerID;
        }

        public Friend() {
            this("", "");
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.playerID;
        }

        @NotNull
        public final Friend copy(@NotNull String name2, @NotNull String playerID) {
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter(playerID, "playerID");
            return new Friend(name2, playerID);
        }

        public static /* synthetic */ Friend copy$default(Friend friend, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = friend.name;
            }
            if ((n & 2) != 0) {
                string2 = friend.playerID;
            }
            return friend.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Friend(name=" + this.name + ", playerID=" + this.playerID + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.playerID.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Friend)) {
                return false;
            }
            Friend friend = (Friend)other;
            if (!Intrinsics.areEqual(this.name, friend.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.playerID, friend.playerID);
        }
    }
}

