/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.multiplayer;

import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.event.Event;
import com.unciv.logic.event.EventBus;
import com.unciv.logic.files.UncivFiles;
import com.unciv.logic.multiplayer.MultiplayerGameNameChanged;
import com.unciv.logic.multiplayer.OnlineMultiplayer;
import com.unciv.logic.multiplayer.OnlineMultiplayerGame;
import com.unciv.logic.multiplayer.OnlineMultiplayerKt;
import com.unciv.logic.multiplayer.storage.MultiplayerFileNotFoundException;
import com.unciv.logic.multiplayer.storage.OnlineMultiplayerServer;
import com.unciv.models.metadata.GameSettings;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.Dispatcher;
import com.unciv.utils.LogKt;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 G2\u00020\u0001:\u0001GB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0002J%\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\"2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\"H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J2\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\"2\u001a\u0010)\u001a\u0016\u0012\f\u0012\n\u0018\u00010+j\u0004\u0018\u0001`,\u0012\u0004\u0012\u00020\u001b0*J\u0019\u0010-\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u000e\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u0007J\u0019\u00101\u001a\u00020 2\u0006\u0010#\u001a\u00020\"H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J\n\u00103\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u00104\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020\"J\u0010\u00105\u001a\u0004\u0018\u00010\u00072\u0006\u00106\u001a\u00020\"J\u0016\u00107\u001a\u0002082\u0006\u00109\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010:\u001a\u0002082\u0006\u0010;\u001a\u00020\u001e2\u0006\u0010<\u001a\u00020\u001eH\u0002J\u0019\u0010=\u001a\u00020>2\u0006\u00109\u001a\u00020 H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J\u0019\u0010=\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u0007H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u0019\u0010=\u001a\u00020>2\u0006\u0010#\u001a\u00020\"H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J \u0010@\u001a\u00020\u001b2\b\b\u0002\u0010A\u001a\u0002082\u000e\b\u0002\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00070CJ\u0019\u0010D\u001a\u0002082\u0006\u0010'\u001a\u00020\u0007H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u0019\u0010E\u001a\u00020\u001b2\u0006\u00109\u001a\u00020 H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J\b\u0010F\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00070\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006H"}, d2={"Lcom/unciv/logic/multiplayer/OnlineMultiplayer;", "", "()V", "files", "Lcom/unciv/logic/files/UncivFiles;", "games", "", "Lcom/unciv/logic/multiplayer/OnlineMultiplayerGame;", "getGames", "()Ljava/util/Set;", "lastAllGamesRefresh", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/time/Instant;", "lastCurGameRefresh", "lastFileUpdate", "multiplayerGameUpdater", "Lkotlinx/coroutines/Job;", "getMultiplayerGameUpdater", "()Lkotlinx/coroutines/Job;", "multiplayerServer", "Lcom/unciv/logic/multiplayer/storage/OnlineMultiplayerServer;", "getMultiplayerServer", "()Lcom/unciv/logic/multiplayer/storage/OnlineMultiplayerServer;", "savedGames", "", "Lcom/badlogic/gdx/files/FileHandle;", "addGame", "", "fileHandle", "preview", "Lcom/unciv/logic/GameInfoPreview;", "newGame", "Lcom/unciv/logic/GameInfo;", "saveFileName", "", "gameId", "gameName", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "changeGameName", "game", "newName", "onException", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "createGame", "(Lcom/unciv/logic/GameInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteGame", "multiplayerGame", "downloadGame", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCurrentGame", "getGameByGameId", "getGameByName", "name", "hasLatestGameState", "", "gameInfo", "hasNewerGameState", "preview1", "preview2", "loadGame", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/logic/multiplayer/OnlineMultiplayerGame;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "requestUpdate", "forceUpdate", "doNotUpdate", "", "resign", "updateGame", "updateSavesFromFiles", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nOnlineMultiplayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnlineMultiplayer.kt\ncom/unciv/logic/multiplayer/OnlineMultiplayer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,399:1\n288#2,2:400\n288#2,2:402\n*S KotlinDebug\n*F\n+ 1 OnlineMultiplayer.kt\ncom/unciv/logic/multiplayer/OnlineMultiplayer\n*L\n172#1:400,2\n176#1:402,2\n*E\n"})
public final class OnlineMultiplayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UncivFiles files = UncivGame.Companion.getCurrent().getFiles();
    @NotNull
    private final OnlineMultiplayerServer multiplayerServer = new OnlineMultiplayerServer(null, null, 3, null);
    @NotNull
    private final Map<FileHandle, OnlineMultiplayerGame> savedGames;
    @NotNull
    private final AtomicReference<Instant> lastFileUpdate;
    @NotNull
    private final AtomicReference<Instant> lastAllGamesRefresh;
    @NotNull
    private final AtomicReference<Instant> lastCurGameRefresh;
    @NotNull
    private final Job multiplayerGameUpdater;

    public OnlineMultiplayer() {
        Map map2 = Collections.synchronizedMap(new LinkedHashMap());
        Intrinsics.checkNotNullExpressionValue(map2, "synchronizedMap(mutableMapOf())");
        this.savedGames = map2;
        this.lastFileUpdate = new AtomicReference();
        this.lastAllGamesRefresh = new AtomicReference();
        this.lastCurGameRefresh = new AtomicReference();
        this.multiplayerGameUpdater = FlowKt.launchIn(FlowKt.flow((Function2)new Function2<FlowCollector<? super Unit>, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ OnlineMultiplayer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Override
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
lbl6:
                        // 3 sources

                        while (true) {
                            this.label = 1;
                            v0 = DelayKt.delay(500L, this);
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl15
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        $i$f$currentCoroutineContext = false;
                        if (!JobKt.isActive(this.getContext())) {
                            return Unit.INSTANCE;
                        }
                        try {
                            multiplayerSettings = UncivGame.Companion.getCurrent().getSettings().getMultiplayer();
                        }
                        catch (Exception var3_6) {
                            ** GOTO lbl6
                        }
                        v1 = currentGame = OnlineMultiplayer.access$getCurrentGame(this.this$0);
                        v2 = preview = v1 != null ? v1.getPreview() : null;
                        if (currentGame != null && (OnlineMultiplayer.Companion.usesCustomServer() || preview == null || !OnlineMultiplayerKt.isUsersTurn(preview))) {
                            this.L$0 = multiplayerSettings;
                            this.L$1 = currentGame;
                            this.label = 2;
                            v3 = OnlineMultiplayerKt.throttle$default(OnlineMultiplayer.access$getLastCurGameRefresh$p(this.this$0), multiplayerSettings.getCurrentGameRefreshDelay(), 1.INSTANCE, null, new Function1<Continuation<? super Object>, Object>(currentGame, null){
                                int label;
                                final /* synthetic */ OnlineMultiplayerGame $currentGame;
                                {
                                    this.$currentGame = $currentGame;
                                    super(1, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Override
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.label = 1;
                                            Object object3 = OnlineMultiplayerGame.requestUpdate$default(this.$currentGame, false, this, 1, null);
                                            if (object3 != object2) return object3;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure($result);
                                            Object object3 = $result;
                                            return object3;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @Override
                                @NotNull
                                public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Override
                                @Nullable
                                public final Object invoke(@Nullable Continuation<Object> p1) {
                                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, this, 8, null);
                            if (v3 == var6_2) {
                                return var6_2;
                            }
                        }
                        ** GOTO lbl40
                    }
                    case 2: {
                        currentGame = (OnlineMultiplayerGame)this.L$1;
                        multiplayerSettings = (GameSettings.GameSettingsMultiplayer)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl40:
                        // 2 sources

                        doNotUpdate = currentGame == null ? CollectionsKt.emptyList() : CollectionsKt.listOf(currentGame);
                        this.L$0 = null;
                        this.L$1 = null;
                        this.label = 3;
                        v4 = OnlineMultiplayerKt.throttle$default(OnlineMultiplayer.access$getLastAllGamesRefresh$p(this.this$0), multiplayerSettings.getAllGameRefreshDelay(), 3.INSTANCE, null, new Function1<Continuation<? super Unit>, Object>(this.this$0, doNotUpdate, null){
                            int label;
                            final /* synthetic */ OnlineMultiplayer this$0;
                            final /* synthetic */ List<OnlineMultiplayerGame> $doNotUpdate;
                            {
                                this.this$0 = $receiver;
                                this.$doNotUpdate = $doNotUpdate;
                                super(1, $completion);
                            }

                            @Override
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(object);
                                        OnlineMultiplayer.requestUpdate$default(this.this$0, false, this.$doNotUpdate, 1, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @Override
                            @NotNull
                            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Override
                            @Nullable
                            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, this, 8, null);
                        if (v4 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl51
                    }
                    case 3: {
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl51:
                        // 2 sources

                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Override
            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Override
            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super Unit> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), CoroutineScopeKt.CoroutineScope(Dispatcher.INSTANCE.getDAEMON()));
    }

    @NotNull
    public final OnlineMultiplayerServer getMultiplayerServer() {
        return this.multiplayerServer;
    }

    @NotNull
    public final Set<OnlineMultiplayerGame> getGames() {
        return CollectionsKt.toSet((Iterable)this.savedGames.values());
    }

    @NotNull
    public final Job getMultiplayerGameUpdater() {
        return this.multiplayerGameUpdater;
    }

    private final OnlineMultiplayerGame getCurrentGame() {
        GameInfo gameInfo2 = UncivGame.Companion.getCurrent().getGameInfo();
        return gameInfo2 != null && gameInfo2.getGameParameters().isOnlineMultiplayer() ? this.getGameByGameId(gameInfo2.getGameId()) : null;
    }

    public final void requestUpdate(boolean forceUpdate, @NotNull List<OnlineMultiplayerGame> doNotUpdate) {
        Intrinsics.checkNotNullParameter(doNotUpdate, "doNotUpdate");
        Concurrency.run$default(Concurrency.INSTANCE, "Update all multiplayer games", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(forceUpdate, this, doNotUpdate, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ boolean $forceUpdate;
            final /* synthetic */ OnlineMultiplayer this$0;
            final /* synthetic */ List<OnlineMultiplayerGame> $doNotUpdate;
            {
                this.$forceUpdate = $forceUpdate;
                this.this$0 = $receiver;
                this.$doNotUpdate = $doNotUpdate;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$run = (CoroutineScope)this.L$0;
                        fileThrottleInterval = this.$forceUpdate != false ? Duration.ZERO : OnlineMultiplayerKt.access$getFILE_UPDATE_THROTTLE_PERIOD$p();
                        v0 = OnlineMultiplayer.access$getLastFileUpdate$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue(fileThrottleInterval, "fileThrottleInterval");
                        this.L$0 = $this$run;
                        this.label = 1;
                        v1 = OnlineMultiplayerKt.throttle$default(v0, fileThrottleInterval, requestUpdate.1.INSTANCE, null, new Function1<Continuation<? super Unit>, Object>((Object)this.this$0){

                            @Nullable
                            public final Object invoke(@NotNull Continuation<? super Unit> $completion) {
                                return requestUpdate.1.access$invokeSuspend$updateSavesFromFiles((OnlineMultiplayer)requestUpdate.2.access$getReceiver$p(this), $completion);
                            }

                            public static final /* synthetic */ Object access$getReceiver$p(requestUpdate.2 $this) {
                                return $this.receiver;
                            }
                        }, this, 8, null);
                        if (v1 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        $this$run = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl19:
                        // 4 sources

                        for (OnlineMultiplayerGame game : OnlineMultiplayer.access$getSavedGames$p(this.this$0).values()) {
                            if (this.$doNotUpdate.contains(game)) continue;
                            ConcurrencyKt.launchOnThreadPool$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(game, this.$forceUpdate, null){
                                int label;
                                final /* synthetic */ OnlineMultiplayerGame $game;
                                final /* synthetic */ boolean $forceUpdate;
                                {
                                    this.$game = $game;
                                    this.$forceUpdate = $forceUpdate;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.label = 1;
                                            Object object3 = this.$game.requestUpdate(this.$forceUpdate, this);
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure($result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final /* synthetic */ Object invokeSuspend$updateSavesFromFiles(OnlineMultiplayer $this$invokeSuspend_u24updateSavesFromFiles, Continuation $completion) {
                OnlineMultiplayer.access$updateSavesFromFiles($this$invokeSuspend_u24updateSavesFromFiles);
                return Unit.INSTANCE;
            }

            public static final /* synthetic */ Object access$invokeSuspend$updateSavesFromFiles(OnlineMultiplayer $receiver, Continuation $completion) {
                return requestUpdate.1.invokeSuspend$updateSavesFromFiles($receiver, $completion);
            }
        }, 2, null);
    }

    public static /* synthetic */ void requestUpdate$default(OnlineMultiplayer onlineMultiplayer, boolean bl, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        onlineMultiplayer.requestUpdate(bl, list2);
    }

    private final void updateSavesFromFiles() {
        Sequence<FileHandle> saves = this.files.getMultiplayerSaves();
        Set<FileHandle> removedSaves = SetsKt.minus(this.savedGames.keySet(), (Iterable)SequencesKt.toSet(saves));
        for (FileHandle saveFile : removedSaves) {
            this.deleteGame(saveFile);
        }
        Sequence<FileHandle> newSaves = SequencesKt.minus(saves, (Iterable)this.savedGames.keySet());
        Iterator<FileHandle> iterator2 = newSaves.iterator();
        while (iterator2.hasNext()) {
            FileHandle saveFile = iterator2.next();
            OnlineMultiplayer.addGame$default(this, saveFile, null, 2, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object createGame(@NotNull GameInfo var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof createGame.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ OnlineMultiplayer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createGame(null, this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = this;
                $continuation.L$1 = newGame;
                $continuation.label = 1;
                v0 = this.multiplayerServer.tryUploadGame(newGame, true, $continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                newGame = (GameInfo)$continuation.L$1;
                this = (OnlineMultiplayer)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl24:
                // 2 sources

                this.addGame(newGame);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object addGame(@NotNull String var1_1, @Nullable String var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof addGame.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ OnlineMultiplayer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.addGame(null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                var5_7 = (CharSequence)gameName;
                saveFileName = (var5_7 == null || StringsKt.isBlank(var5_7) != false) != false ? gameId : var2_2;
                $continuation.L$0 = this;
                $continuation.L$1 = gameId;
                $continuation.L$2 = saveFileName;
                $continuation.label = 1;
                v0 = this.multiplayerServer.tryDownloadGamePreview(gameId, $continuation);
                ** if (v0 != var10_6) goto lbl23
lbl22:
                // 1 sources

                return var10_6;
lbl23:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                saveFileName = (String)$continuation.L$2;
                gameId = (String)$continuation.L$1;
                this = (OnlineMultiplayer)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure($result);
                    v0 = $result;
lbl32:
                    // 2 sources

                    var6_9 = (GameInfoPreview)v0;
                    ** GOTO lbl49
                }
                catch (MultiplayerFileNotFoundException var7_10) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = saveFileName;
                    $continuation.L$2 = null;
                    $continuation.label = 2;
                    v1 = this.multiplayerServer.tryDownloadGame(gameId, $continuation);
                    if (v1 == var10_6) {
                        return var10_6;
                    }
                    ** GOTO lbl48
                }
            }
            case 2: {
                saveFileName = (String)$continuation.L$1;
                this = (OnlineMultiplayer)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl48:
                // 2 sources

                var6_9 = ((GameInfo)v1).asPreview();
lbl49:
                // 2 sources

                gamePreview = var6_9;
                this.addGame(gamePreview, saveFileName);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object addGame$default(OnlineMultiplayer onlineMultiplayer, String string, String string2, Continuation continuation2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return onlineMultiplayer.addGame(string, string2, continuation2);
    }

    private final void addGame(GameInfo newGame) {
        GameInfoPreview newGamePreview = newGame.asPreview();
        this.addGame(newGamePreview, newGamePreview.getGameId());
    }

    private final void addGame(GameInfoPreview preview, String saveFileName) {
        FileHandle fileHandle = UncivFiles.saveGame$default(this.files, preview, saveFileName, null, 4, null);
        this.addGame(fileHandle, preview);
    }

    private final void addGame(FileHandle fileHandle, GameInfoPreview preview) {
        Object[] objectArray = new Object[]{fileHandle.name()};
        LogKt.debug("Adding game %s", objectArray);
        OnlineMultiplayerGame game = new OnlineMultiplayerGame(fileHandle, preview, preview != null ? Instant.now() : null);
        this.savedGames.put(fileHandle, game);
    }

    static /* synthetic */ void addGame$default(OnlineMultiplayer onlineMultiplayer, FileHandle fileHandle, GameInfoPreview gameInfoPreview, int n, Object object) {
        if ((n & 2) != 0) {
            gameInfoPreview = null;
        }
        onlineMultiplayer.addGame(fileHandle, gameInfoPreview);
    }

    @Nullable
    public final OnlineMultiplayerGame getGameByName(@NotNull String name2) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(name2, "name");
            Iterable $this$firstOrNull$iv = this.savedGames.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OnlineMultiplayerGame it = (OnlineMultiplayerGame)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final OnlineMultiplayerGame getGameByGameId(@NotNull String gameId) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter(gameId, "gameId");
            Iterable $this$firstOrNull$iv = this.savedGames.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                OnlineMultiplayerGame it = (OnlineMultiplayerGame)element$iv;
                boolean bl = false;
                GameInfoPreview gameInfoPreview = it.getPreview();
                if (!Intrinsics.areEqual(gameInfoPreview != null ? gameInfoPreview.getGameId() : null, gameId)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object resign(@NotNull OnlineMultiplayerGame var1_1, @NotNull Continuation<? super Boolean> var2_2) {
        if (!(var2_2 instanceof resign.1)) ** GOTO lbl-1000
        var10_3 = var2_2;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ OnlineMultiplayer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.resign(null, this);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                v0 = game.getPreview();
                if (v0 == null) {
                    v1 = game.getError();
                    Intrinsics.checkNotNull(v1);
                    throw v1;
                }
                preview = v0;
                $continuation.L$0 = this;
                $continuation.L$1 = game;
                $continuation.label = 1;
                v2 = this.multiplayerServer.tryDownloadGame(preview.getGameId(), $continuation);
                if (v2 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                game = (OnlineMultiplayerGame)$continuation.L$1;
                this = (OnlineMultiplayer)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl30:
                // 2 sources

                gameInfo = (GameInfo)v2;
                playerCiv = gameInfo.getCurrentPlayerCivilization();
                if (!OnlineMultiplayerKt.isUsersTurn(gameInfo)) {
                    return Boxing.boxBoolean(false);
                }
                playerCiv.setPlayerType(PlayerType.AI);
                playerCiv.setPlayerId("");
                GameInfo.nextTurn$default(gameInfo, null, 1, null);
                for (Civilization civ : gameInfo.getCivilizations()) {
                    var8_11 = new String[]{playerCiv.getCivName()};
                    civ.addNotification('[' + playerCiv.getCivName() + "] resigned and is now controlled by AI", Notification.NotificationCategory.General, var8_11);
                }
                newPreview = gameInfo.asPreview();
                UncivFiles.saveGame$default(this.files, newPreview, game.getFileHandle(), null, 4, null);
                $continuation.L$0 = game;
                $continuation.L$1 = newPreview;
                $continuation.label = 2;
                v3 = this.multiplayerServer.tryUploadGame(gameInfo, true, $continuation);
                if (v3 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl55
            }
            case 2: {
                newPreview = (GameInfoPreview)$continuation.L$1;
                game = (OnlineMultiplayerGame)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v3 = $result;
lbl55:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 3;
                v4 = game.doManualUpdate(newPreview, $continuation);
                if (v4 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl65
            }
            case 3: {
                ResultKt.throwOnFailure($result);
                v4 = $result;
lbl65:
                // 2 sources

                return Boxing.boxBoolean(true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object loadGame(@NotNull OnlineMultiplayerGame game, @NotNull Continuation<? super Unit> $completion) {
        GameInfoPreview gameInfoPreview = game.getPreview();
        if (gameInfoPreview == null) {
            Exception exception2 = game.getError();
            Intrinsics.checkNotNull(exception2);
            throw exception2;
        }
        GameInfoPreview preview = gameInfoPreview;
        Object object = this.loadGame(preview.getGameId(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object loadGame(@NotNull String gameId, @NotNull Continuation<? super WorldScreen> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)new Function2<CoroutineScope, Continuation<? super WorldScreen>, Object>(this, gameId, null){
            Object L$0;
            int label;
            final /* synthetic */ OnlineMultiplayer this$0;
            final /* synthetic */ String $gameId;
            {
                this.this$0 = $receiver;
                this.$gameId = $gameId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        this.label = 1;
                        v0 = this.this$0.downloadGame(this.$gameId, this);
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        gameInfo = (GameInfo)v0;
                        preview = gameInfo.asPreview();
                        v1 = onlineGame = this.this$0.getGameByGameId(this.$gameId);
                        v2 = onlinePreview = v1 != null ? v1.getPreview() : null;
                        if (onlineGame != null) break;
                        this.L$0 = gameInfo;
                        this.label = 2;
                        v3 = this.this$0.createGame(gameInfo, this);
                        if (v3 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl40
                    }
                    case 2: {
                        gameInfo = (GameInfo)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
                        ** GOTO lbl40
                    }
                }
                if (onlinePreview != null && OnlineMultiplayer.access$hasNewerGameState(this.this$0, preview, onlinePreview)) {
                    this.L$0 = gameInfo;
                    this.label = 3;
                    v4 = onlineGame.doManualUpdate(preview, this);
                    if (v4 == var6_2) {
                        return var6_2;
                    }
                }
                ** GOTO lbl40
                {
                    case 3: {
                        gameInfo = (GameInfo)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl40:
                        // 4 sources

                        this.L$0 = null;
                        this.label = 4;
                        v5 = UncivGame.loadGame$default(UncivGame.Companion.getCurrent(), gameInfo, null, false, this, 6, null);
                        if (v5 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl49
                    }
                    case 4: {
                        ResultKt.throwOnFailure($result);
                        v5 = $result;
lbl49:
                        // 2 sources

                        return v5;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super WorldScreen> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Nullable
    public final Object loadGame(@NotNull GameInfo gameInfo2, @NotNull Continuation<? super WorldScreen> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)new Function2<CoroutineScope, Continuation<? super WorldScreen>, Object>(gameInfo2, this, null){
            Object L$0;
            int label;
            final /* synthetic */ GameInfo $gameInfo;
            final /* synthetic */ OnlineMultiplayer this$0;
            {
                this.$gameInfo = $gameInfo;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        gameId = this.$gameInfo.getGameId();
                        this.L$0 = gameId;
                        this.label = 1;
                        v0 = this.this$0.getMultiplayerServer().tryDownloadGamePreview(gameId, this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        gameId = (String)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        if (!this.this$0.hasLatestGameState(this.$gameInfo, preview = (GameInfoPreview)v0)) break;
                        this.$gameInfo.setUpToDate(true);
                        this.L$0 = null;
                        this.label = 2;
                        v1 = UncivGame.loadGame$default(UncivGame.Companion.getCurrent(), this.$gameInfo, null, false, this, 6, null);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl27:
                        // 2 sources

                        v2 = (WorldScreen)v1;
                        ** GOTO lbl39
                    }
                }
                this.L$0 = null;
                this.label = 3;
                v3 = this.this$0.loadGame(gameId, (Continuation<? super WorldScreen>)this);
                if (v3 == var4_2) {
                    return var4_2;
                }
                ** GOTO lbl38
                {
                    case 3: {
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl38:
                        // 2 sources

                        v2 = (WorldScreen)v3;
lbl39:
                        // 2 sources

                        return v2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super WorldScreen> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadGame(@NotNull String var1_1, @NotNull Continuation<? super GameInfo> var2_2) {
        if (!(var2_2 instanceof downloadGame.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ OnlineMultiplayer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadGame(null, this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.label = 1;
                v0 = this.multiplayerServer.tryDownloadGame((String)gameId, $continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl20:
                // 2 sources

                latestGame = (GameInfo)v0;
                latestGame.setUpToDate(true);
                return latestGame;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void deleteGame(@NotNull OnlineMultiplayerGame multiplayerGame) {
        Intrinsics.checkNotNullParameter(multiplayerGame, "multiplayerGame");
        this.deleteGame(multiplayerGame.getFileHandle());
    }

    private final void deleteGame(FileHandle fileHandle) {
        this.files.deleteSave(fileHandle);
        OnlineMultiplayerGame onlineMultiplayerGame = this.savedGames.get(fileHandle);
        if (onlineMultiplayerGame == null) {
            return;
        }
        OnlineMultiplayerGame game = onlineMultiplayerGame;
        Object[] objectArray = new Object[2];
        objectArray[0] = fileHandle.name();
        GameInfoPreview gameInfoPreview = game.getPreview();
        objectArray[1] = gameInfoPreview != null ? gameInfoPreview.getGameId() : null;
        LogKt.debug("Deleting game %s with id %s", objectArray);
        this.savedGames.remove(game.getFileHandle());
    }

    public final void changeGameName(@NotNull OnlineMultiplayerGame game, @NotNull String newName, @NotNull Function1<? super Exception, Unit> onException) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(newName, "newName");
        Intrinsics.checkNotNullParameter(onException, "onException");
        Object[] objectArray = new Object[]{game.getName(), newName};
        LogKt.debug("Changing name of game %s to", objectArray);
        GameInfoPreview gameInfoPreview = game.getPreview();
        if (gameInfoPreview == null) {
            Exception exception2 = game.getError();
            Intrinsics.checkNotNull(exception2);
            throw exception2;
        }
        GameInfoPreview oldPreview = gameInfoPreview;
        Instant oldLastUpdate = game.getLastUpdate();
        String oldName = game.getName();
        FileHandle newFileHandle = this.files.saveGame(oldPreview, newName, onException);
        OnlineMultiplayerGame newGame = new OnlineMultiplayerGame(newFileHandle, oldPreview, oldLastUpdate);
        this.savedGames.put(newFileHandle, newGame);
        this.savedGames.remove(game.getFileHandle());
        this.files.deleteSave(game.getFileHandle());
        Intrinsics.checkNotNullExpressionValue(oldName, "oldName");
        EventBus.INSTANCE.send((Event)new MultiplayerGameNameChanged(oldName, newName));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object updateGame(@NotNull GameInfo var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof updateGame.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ OnlineMultiplayer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateGame(null, this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                var3_6 = new Object[]{gameInfo.getGameId()};
                LogKt.debug("Updating remote game %s", var3_6);
                $continuation.L$0 = this;
                $continuation.L$1 = gameInfo;
                $continuation.label = 1;
                v0 = this.multiplayerServer.tryUploadGame(gameInfo, true, $continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                gameInfo = (GameInfo)$continuation.L$1;
                this = (OnlineMultiplayer)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl26:
                // 2 sources

                game = this.getGameByGameId(gameInfo.getGameId());
                var4_7 = new Object[]{game};
                LogKt.debug("Existing OnlineMultiplayerGame: %s", var4_7);
                if (game == null) {
                    this.addGame(gameInfo);
                    break;
                }
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v1 = game.doManualUpdate(gameInfo.asPreview(), $continuation);
                if (v1 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl42
            }
            case 2: {
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl42:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean hasLatestGameState(@NotNull GameInfo gameInfo2, @NotNull GameInfoPreview preview) {
        Intrinsics.checkNotNullParameter(gameInfo2, "gameInfo");
        Intrinsics.checkNotNullParameter(preview, "preview");
        return Intrinsics.areEqual(gameInfo2.getCurrentPlayer(), preview.getCurrentPlayer()) && gameInfo2.getTurns() == preview.getTurns();
    }

    private final boolean hasNewerGameState(GameInfoPreview preview1, GameInfoPreview preview2) {
        return preview1.getTurns() > preview2.getTurns();
    }

    public static final /* synthetic */ AtomicReference access$getLastFileUpdate$p(OnlineMultiplayer $this) {
        return $this.lastFileUpdate;
    }

    public static final /* synthetic */ Map access$getSavedGames$p(OnlineMultiplayer $this) {
        return $this.savedGames;
    }

    public static final /* synthetic */ void access$updateSavesFromFiles(OnlineMultiplayer $this) {
        $this.updateSavesFromFiles();
    }

    public static final /* synthetic */ boolean access$hasNewerGameState(OnlineMultiplayer $this, GameInfoPreview preview1, GameInfoPreview preview2) {
        return $this.hasNewerGameState(preview1, preview2);
    }

    public static final /* synthetic */ OnlineMultiplayerGame access$getCurrentGame(OnlineMultiplayer $this) {
        return $this.getCurrentGame();
    }

    public static final /* synthetic */ AtomicReference access$getLastCurGameRefresh$p(OnlineMultiplayer $this) {
        return $this.lastCurGameRefresh;
    }

    public static final /* synthetic */ AtomicReference access$getLastAllGamesRefresh$p(OnlineMultiplayer $this) {
        return $this.lastAllGamesRefresh;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/multiplayer/OnlineMultiplayer$Companion;", "", "()V", "usesCustomServer", "", "usesDropbox", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean usesCustomServer() {
            return !Intrinsics.areEqual(UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getServer(), "Dropbox");
        }

        public final boolean usesDropbox() {
            return !this.usesCustomServer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

