/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.multiplayer.storage;

import com.badlogic.gdx.utils.Base64Coder;
import com.unciv.logic.multiplayer.storage.FileMetaData;
import com.unciv.logic.multiplayer.storage.FileStorage;
import com.unciv.logic.multiplayer.storage.MultiplayerAuthException;
import com.unciv.logic.multiplayer.storage.MultiplayerFileNotFoundException;
import com.unciv.logic.multiplayer.storage.SimpleHttp;
import com.unciv.logic.multiplayer.storage.UncivServerFileStorage;
import com.unciv.utils.LogKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0016J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0005H\u0016R(\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/unciv/logic/multiplayer/storage/UncivServerFileStorage;", "Lcom/unciv/logic/multiplayer/storage/FileStorage;", "()V", "authHeader", "", "", "getAuthHeader", "()Ljava/util/Map;", "setAuthHeader", "(Ljava/util/Map;)V", "serverUrl", "getServerUrl", "()Ljava/lang/String;", "setServerUrl", "(Ljava/lang/String;)V", "timeout", "", "getTimeout", "()I", "setTimeout", "(I)V", "authenticate", "", "userId", "password", "deleteFile", "", "fileName", "fileUrl", "getFileMetaData", "Lcom/unciv/logic/multiplayer/storage/FileMetaData;", "loadFileData", "saveFileData", "data", "setPassword", "newPassword", "core"})
public final class UncivServerFileStorage
implements FileStorage {
    @NotNull
    public static final UncivServerFileStorage INSTANCE = new UncivServerFileStorage();
    @Nullable
    private static Map<String, String> authHeader;
    @NotNull
    private static String serverUrl;
    private static int timeout;

    private UncivServerFileStorage() {
    }

    @Nullable
    public final Map<String, String> getAuthHeader() {
        return authHeader;
    }

    public final void setAuthHeader(@Nullable Map<String, String> map2) {
        authHeader = map2;
    }

    @NotNull
    public final String getServerUrl() {
        return serverUrl;
    }

    public final void setServerUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        serverUrl = string;
    }

    public final int getTimeout() {
        return timeout;
    }

    public final void setTimeout(int n) {
        timeout = n;
    }

    @Override
    public void saveFileData(@NotNull String fileName, @NotNull String data2) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(data2, "data");
        SimpleHttp.INSTANCE.sendRequest("PUT", this.fileUrl(fileName), data2, timeout, authHeader, saveFileData.1.INSTANCE);
    }

    @Override
    @NotNull
    public String loadFileData(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Ref.ObjectRef<String> fileData = new Ref.ObjectRef<String>();
        fileData.element = "";
        SimpleHttp.INSTANCE.sendGetRequest(this.fileUrl(fileName), timeout, authHeader, (Function3<? super Boolean, ? super String, ? super Integer, Unit>)new Function3<Boolean, String, Integer, Unit>(fileData){
            final /* synthetic */ Ref.ObjectRef<String> $fileData;
            {
                this.$fileData = $fileData;
                super(3);
            }

            public final void invoke(boolean success, @NotNull String result2, @Nullable Integer code) {
                Intrinsics.checkNotNullParameter(result2, "result");
                if (!success) {
                    Object[] objectArray = new Object[]{result2};
                    LogKt.debug("Error from UncivServer during load: %s", objectArray);
                    Integer n = code;
                    int n2 = 404;
                    if (n != null && n == n2) {
                        throw new MultiplayerFileNotFoundException(new Exception(result2));
                    }
                    throw new Exception(result2);
                }
                this.$fileData.element = result2;
            }
        });
        return (String)fileData.element;
    }

    @Override
    @NotNull
    public FileMetaData getFileMetaData(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void deleteFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        SimpleHttp.INSTANCE.sendRequest("DELETE", this.fileUrl(fileName), "", timeout, authHeader, deleteFile.1.INSTANCE);
    }

    @Override
    public boolean authenticate(@NotNull String userId, @NotNull String password) {
        Intrinsics.checkNotNullParameter(userId, "userId");
        Intrinsics.checkNotNullParameter(password, "password");
        Ref.BooleanRef authenticated = new Ref.BooleanRef();
        String preEncodedAuthValue = userId + ':' + password;
        authHeader = MapsKt.mapOf(TuplesKt.to("Authorization", "Basic " + Base64Coder.encodeString(preEncodedAuthValue)));
        SimpleHttp.INSTANCE.sendGetRequest(serverUrl + "/auth", timeout, authHeader, (Function3<? super Boolean, ? super String, ? super Integer, Unit>)new Function3<Boolean, String, Integer, Unit>(authenticated){
            final /* synthetic */ Ref.BooleanRef $authenticated;
            {
                this.$authenticated = $authenticated;
                super(3);
            }

            public final void invoke(boolean success, @NotNull String result2, @Nullable Integer code) {
                Intrinsics.checkNotNullParameter(result2, "result");
                if (!success) {
                    Object[] objectArray = new Object[]{result2};
                    LogKt.debug("Error from UncivServer during authentication: %s", objectArray);
                    UncivServerFileStorage.INSTANCE.setAuthHeader(null);
                    Integer n = code;
                    int n2 = 401;
                    if (n != null && n == n2) {
                        throw new MultiplayerAuthException(new Exception(result2));
                    }
                    throw new Exception(result2);
                }
                this.$authenticated.element = true;
            }
        });
        return authenticated.element;
    }

    @Override
    public boolean setPassword(@NotNull String newPassword) {
        Intrinsics.checkNotNullParameter(newPassword, "newPassword");
        if (authHeader == null) {
            return false;
        }
        Ref.BooleanRef setSuccessful = new Ref.BooleanRef();
        SimpleHttp.INSTANCE.sendRequest("PUT", serverUrl + "/auth", newPassword, timeout, authHeader, (Function3<? super Boolean, ? super String, ? super Integer, Unit>)new Function3<Boolean, String, Integer, Unit>(setSuccessful){
            final /* synthetic */ Ref.BooleanRef $setSuccessful;
            {
                this.$setSuccessful = $setSuccessful;
                super(3);
            }

            public final void invoke(boolean success, @NotNull String result2, @Nullable Integer code) {
                Intrinsics.checkNotNullParameter(result2, "result");
                if (!success) {
                    Object[] objectArray = new Object[]{result2};
                    LogKt.debug("Error from UncivServer during password set: %s", objectArray);
                    Integer n = code;
                    int n2 = 401;
                    if (n != null && n == n2) {
                        throw new MultiplayerAuthException(new Exception(result2));
                    }
                    throw new Exception(result2);
                }
                this.$setSuccessful.element = true;
            }
        });
        return setSuccessful.element;
    }

    private final String fileUrl(String fileName) {
        return serverUrl + "/files/" + fileName;
    }

    static {
        serverUrl = "";
        timeout = 30000;
    }
}

