/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.simulation;

import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameStarter;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.simulation.MutableInt;
import com.unciv.logic.simulation.Simulation;
import com.unciv.logic.simulation.SimulationStep;
import com.unciv.models.metadata.GameSetupInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.ExperimentalTime;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001c2\b\b\u0002\u00101\u001a\u00020\u0005J\u0006\u00102\u001a\u00020/J\u0006\u00103\u001a\u00020/J\b\u00104\u001a\u00020\u0010H\u0016J\u0010\u00105\u001a\u00020/2\b\b\u0002\u00101\u001a\u00020\u0005R\u0019\u0010\t\u001a\u00020\nX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u001bj\b\u0012\u0004\u0012\u00020\u001c`\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\"\u001a\u00020\nX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010#\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020&0%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*RB\u0010+\u001a6\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020&0%0,j\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020&0%`-X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00066"}, d2={"Lcom/unciv/logic/simulation/Simulation;", "", "newGameInfo", "Lcom/unciv/logic/GameInfo;", "simulationsPerThread", "", "threadsNumber", "maxTurns", "(Lcom/unciv/logic/GameInfo;III)V", "avgDuration", "Lkotlin/time/Duration;", "J", "avgSpeed", "", "civilizations", "", "", "getCivilizations", "()Ljava/util/List;", "endTime", "", "maxSimulations", "getSimulationsPerThread", "()I", "startTime", "stepCounter", "steps", "Ljava/util/ArrayList;", "Lcom/unciv/logic/simulation/SimulationStep;", "Lkotlin/collections/ArrayList;", "getSteps", "()Ljava/util/ArrayList;", "setSteps", "(Ljava/util/ArrayList;)V", "totalDuration", "totalTurns", "winRate", "", "Lcom/unciv/logic/simulation/MutableInt;", "getWinRate", "()Ljava/util/Map;", "setWinRate", "(Ljava/util/Map;)V", "winRateByVictory", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "add", "", "step", "threadId", "getStats", "start", "toString", "updateCounter", "core"})
@ExperimentalTime
@SourceDebugExtension(value={"SMAP\nSimulation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Simulation.kt\ncom/unciv/logic/simulation/Simulation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n766#2:128\n857#2,2:129\n1549#2:131\n1620#2,3:132\n1855#2,2:135\n1#3:137\n*S KotlinDebug\n*F\n+ 1 Simulation.kt\ncom/unciv/logic/simulation/Simulation\n*L\n26#1:128\n26#1:129,2\n26#1:131\n26#1:132,3\n95#1:135,2\n*E\n"})
public final class Simulation {
    @NotNull
    private final GameInfo newGameInfo;
    private final int simulationsPerThread;
    private final int threadsNumber;
    private final int maxTurns;
    private final int maxSimulations;
    @NotNull
    private final List<String> civilizations;
    private long startTime;
    private long endTime;
    @NotNull
    private ArrayList<SimulationStep> steps;
    @NotNull
    private Map<String, MutableInt> winRate;
    @NotNull
    private HashMap<String, Map<String, MutableInt>> winRateByVictory;
    private float avgSpeed;
    private long avgDuration;
    private int totalTurns;
    private long totalDuration;
    private int stepCounter;

    /*
     * WARNING - void declaration
     */
    public Simulation(@NotNull GameInfo newGameInfo, int simulationsPerThread, int threadsNumber, int maxTurns) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Civilization it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(newGameInfo, "newGameInfo");
        this.newGameInfo = newGameInfo;
        this.simulationsPerThread = simulationsPerThread;
        this.threadsNumber = threadsNumber;
        this.maxTurns = maxTurns;
        this.maxSimulations = this.threadsNumber * this.simulationsPerThread;
        Iterable iterable = this.newGameInfo.getCivilizations();
        Simulation simulation = this;
        boolean $i$f$filter = false;
        Iterator<String> iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getCivName(), "Spectator"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Civilization)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCivName());
        }
        simulation.civilizations = (List)destination$iv$iv;
        this.steps = new ArrayList();
        this.winRate = new LinkedHashMap();
        this.winRateByVictory = new HashMap();
        this.avgDuration = Duration.Companion.getZERO-UwyO8pc();
        this.totalDuration = Duration.Companion.getZERO-UwyO8pc();
        for (String civ : this.civilizations) {
            this.winRate.put(civ, new MutableInt(0));
            ((Map)this.winRateByVictory).put(civ, (Map)new LinkedHashMap());
            GameInfo gameInfo2 = UncivGame.Companion.getCurrent().getGameInfo();
            Intrinsics.checkNotNull(gameInfo2);
            for (String victory : gameInfo2.getRuleset().getVictories().keySet()) {
                Map<String, MutableInt> map2 = this.winRateByVictory.get(civ);
                Intrinsics.checkNotNull(map2);
                Intrinsics.checkNotNullExpressionValue(victory, "victory");
                map2.put(victory, new MutableInt(0));
            }
        }
    }

    public /* synthetic */ Simulation(GameInfo gameInfo2, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n = 1;
        }
        if ((n4 & 4) != 0) {
            n2 = 1;
        }
        if ((n4 & 8) != 0) {
            n3 = 1000;
        }
        this(gameInfo2, n, n2, n3);
    }

    public final int getSimulationsPerThread() {
        return this.simulationsPerThread;
    }

    @NotNull
    public final List<String> getCivilizations() {
        return this.civilizations;
    }

    @NotNull
    public final ArrayList<SimulationStep> getSteps() {
        return this.steps;
    }

    public final void setSteps(@NotNull ArrayList<SimulationStep> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.steps = arrayList;
    }

    @NotNull
    public final Map<String, MutableInt> getWinRate() {
        return this.winRate;
    }

    public final void setWinRate(@NotNull Map<String, MutableInt> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        this.winRate = map2;
    }

    public final void start() {
        BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Simulation this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        Simulation.access$setStartTime$p(this.this$0, System.currentTimeMillis());
                        jobs = new ArrayList<Job>();
                        var4_5 = Simulation.access$getNewGameInfo$p(this.this$0).getCivilizations();
                        var13_8 = new StringBuilder().append("Starting new game with major civs: ");
                        $i$f$filter = 0;
                        var6_11 = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (Civilization)element$iv$iv;
                            $i$a$-filter-Simulation$start$1$1 = false;
                            if (!it.isMajorCiv()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = Simulation.access$getNewGameInfo$p(this.this$0).getCivilizations();
                        var13_8 = var13_8.append(CollectionsKt.joinToString$default((List)destination$iv$iv, null, null, null, 0, null, start.2.INSTANCE, 31, null)).append(" and minor civs: ");
                        $i$f$filter = 0;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (Civilization)element$iv$iv;
                            $i$a$-filter-Simulation$start$1$3 = false;
                            if (!it.isCityState()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        System.out.println((Object)var13_8.append(CollectionsKt.joinToString$default((List)destination$iv$iv, null, null, null, 0, null, start.4.INSTANCE, 31, null)).toString());
                        threadId = 1;
                        $i$f$filter = Simulation.access$getThreadsNumber$p(this.this$0);
                        if (threadId <= $i$f$filter) {
                            while (true) {
                                jobs.add(BuildersKt.launch$default($this$runBlocking, new CoroutineName("simulation-" + threadId), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, threadId, null){
                                    int label;
                                    final /* synthetic */ Simulation this$0;
                                    final /* synthetic */ int $threadId;
                                    {
                                        this.this$0 = $receiver;
                                        this.$threadId = $threadId;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure(object);
                                                int n = this.this$0.getSimulationsPerThread();
                                                Simulation simulation = this.this$0;
                                                int n2 = this.$threadId;
                                                for (int i = 0; i < n; ++i) {
                                                    boolean bl = false;
                                                    GameInfo gameInfo2 = GameStarter.INSTANCE.startNewGame(new GameSetupInfo(Simulation.access$getNewGameInfo$p(simulation)));
                                                    gameInfo2.setSimulateMaxTurns(Simulation.access$getMaxTurns$p(simulation));
                                                    gameInfo2.setSimulateUntilWin(true);
                                                    GameInfo.nextTurn$default(gameInfo2, null, 1, null);
                                                    SimulationStep step = new SimulationStep(gameInfo2);
                                                    if (step.getVictoryType() != null) {
                                                        step.setWinner(step.getCurrentPlayer());
                                                        System.out.println((Object)(step.getWinner() + " won " + step.getVictoryType() + " victory on turn " + step.getTurns()));
                                                    } else {
                                                        System.out.println((Object)("Max simulation " + step.getTurns() + " turns reached: Draw"));
                                                    }
                                                    simulation.updateCounter(n2);
                                                    Simulation.add$default(simulation, step, 0, 2, null);
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, 2, null));
                                if (threadId == $i$f$filter) break;
                                ++threadId;
                            }
                        }
                        var4_7 = jobs.iterator();
lbl45:
                        // 3 sources

                        while (var4_7.hasNext()) {
                            job = (Job)var4_7.next();
                            this.L$0 = var4_7;
                            this.label = 1;
                            v0 = job.join(this);
                            if (v0 != var14_2) continue;
                            return var14_2;
                        }
                        break;
                    }
                    case 1: {
                        var4_7 = (Iterator<E>)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
                        ** GOTO lbl45
                    }
                }
                Simulation.access$setEndTime$p(this.this$0, System.currentTimeMillis());
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    public final synchronized void add(@NotNull SimulationStep step, int threadId) {
        Intrinsics.checkNotNullParameter(step, "step");
        this.steps.add(step);
    }

    public static /* synthetic */ void add$default(Simulation simulation, SimulationStep simulationStep, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        simulation.add(simulationStep, n);
    }

    public final synchronized void updateCounter(int threadId) {
        int n = this.stepCounter;
        this.stepCounter = n + 1;
        System.out.println((Object)("Simulation step (" + this.stepCounter + '/' + this.maxSimulations + ')'));
    }

    public static /* synthetic */ void updateCounter$default(Simulation simulation, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        simulation.updateCounter(n);
    }

    public final void getStats() {
        int n;
        SimulationStep it;
        Iterable $this$forEach$iv = this.steps;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SimulationStep)element$iv;
            boolean bl = false;
            if (it.getWinner() == null) continue;
            String string = it.getWinner();
            Intrinsics.checkNotNull(string);
            MutableInt mutableInt = this.winRate.get(string);
            Intrinsics.checkNotNull(mutableInt);
            mutableInt.inc();
            String string2 = it.getWinner();
            Intrinsics.checkNotNull(string2);
            Map<String, MutableInt> map2 = this.winRateByVictory.get(string2);
            Intrinsics.checkNotNull(map2);
            MutableInt mutableInt2 = map2.get(it.getVictoryType());
            Intrinsics.checkNotNull(mutableInt2);
            mutableInt2.inc();
        }
        Iterable iterable = this.steps;
        Simulation simulation = this;
        int n2 = 0;
        for (Object t : iterable) {
            it = (SimulationStep)t;
            n = n2;
            boolean bl = false;
            int n3 = it.getTurns();
            n2 = n + n3;
        }
        simulation.totalTurns = n = n2;
        this.totalDuration = DurationKt.toDuration(this.endTime - this.startTime, DurationUnit.MILLISECONDS);
        this.avgSpeed = (float)this.totalTurns / (float)Duration.getInWholeSeconds-impl(this.totalDuration);
        this.avgDuration = Duration.div-UwyO8pc(this.totalDuration, this.steps.size());
    }

    @NotNull
    public String toString() {
        String outString = "";
        for (String civ : this.civilizations) {
            outString = outString + '\n' + civ + ":\n";
            MutableInt mutableInt = this.winRate.get(civ);
            Intrinsics.checkNotNull(mutableInt);
            int wins = mutableInt.getValue() * 100 / Math.max(this.steps.size(), 1);
            outString = outString + wins + "% total win rate \n";
            GameInfo gameInfo2 = UncivGame.Companion.getCurrent().getGameInfo();
            Intrinsics.checkNotNull(gameInfo2);
            for (String victory : gameInfo2.getRuleset().getVictories().keySet()) {
                Map<String, MutableInt> map2 = this.winRateByVictory.get(civ);
                Intrinsics.checkNotNull(map2);
                MutableInt mutableInt2 = map2.get(victory);
                Intrinsics.checkNotNull(mutableInt2);
                int n = mutableInt2.getValue() * 100;
                MutableInt mutableInt3 = this.winRate.get(civ);
                Intrinsics.checkNotNull(mutableInt3);
                int winsVictory = n / Math.max(mutableInt3.getValue(), 1);
                outString = outString + victory + ": " + winsVictory + "%    ";
            }
            outString = outString + '\n';
        }
        StringBuilder stringBuilder = new StringBuilder().append(outString);
        String string = "\nAverage speed: %.1f turns/s \n";
        Object[] objectArray = new Object[]{Float.valueOf(this.avgSpeed)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
        outString = stringBuilder.append(string2).toString();
        outString = outString + "Average game duration: " + Duration.toString-impl(this.avgDuration) + '\n';
        outString = outString + "Total time: " + Duration.toString-impl(this.totalDuration) + '\n';
        return outString;
    }

    public static final /* synthetic */ void access$setStartTime$p(Simulation $this, long l) {
        $this.startTime = l;
    }

    public static final /* synthetic */ GameInfo access$getNewGameInfo$p(Simulation $this) {
        return $this.newGameInfo;
    }

    public static final /* synthetic */ int access$getThreadsNumber$p(Simulation $this) {
        return $this.threadsNumber;
    }

    public static final /* synthetic */ int access$getMaxTurns$p(Simulation $this) {
        return $this.maxTurns;
    }

    public static final /* synthetic */ void access$setEndTime$p(Simulation $this, long l) {
        $this.endTime = l;
    }
}

