/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.trade;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeType;
import com.unciv.models.ruleset.nation.PersonalityValue;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/unciv/logic/trade/TradeRequest;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "()V", "requestingCiv", "", "trade", "Lcom/unciv/logic/trade/Trade;", "(Ljava/lang/String;Lcom/unciv/logic/trade/Trade;)V", "getRequestingCiv", "()Ljava/lang/String;", "setRequestingCiv", "(Ljava/lang/String;)V", "getTrade", "()Lcom/unciv/logic/trade/Trade;", "setTrade", "(Lcom/unciv/logic/trade/Trade;)V", "decline", "", "decliningCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
@SourceDebugExtension(value={"SMAP\nTrade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Trade.kt\ncom/unciv/logic/trade/TradeRequest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1726#2,3:93\n1726#2,3:96\n1747#2,3:99\n1747#2,3:102\n1747#2,3:105\n1747#2,3:108\n1747#2,3:111\n*S KotlinDebug\n*F\n+ 1 Trade.kt\ncom/unciv/logic/trade/TradeRequest\n*L\n59#1:93,3\n60#1:96,3\n62#1:99,3\n64#1:102,3\n66#1:105,3\n68#1:108,3\n70#1:111,3\n*E\n"})
public final class TradeRequest
implements IsPartOfGameInfoSerialization {
    public String requestingCiv;
    public Trade trade;

    public final void decline(@NotNull Civilization decliningCiv) {
        boolean bl;
        DiplomacyManager requestingCivDiploManager;
        Civilization requestingCivInfo;
        block35: {
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            TradeOffer it;
            block34: {
                boolean bl3;
                block33: {
                    boolean bl4;
                    block32: {
                        boolean bl5;
                        block31: {
                            boolean bl6;
                            boolean $i$f$all;
                            Iterable $this$all$iv;
                            block29: {
                                Intrinsics.checkNotNullParameter(decliningCiv, "decliningCiv");
                                requestingCivInfo = decliningCiv.getGameInfo().getCivilization(this.getRequestingCiv());
                                DiplomacyManager diplomacyManager = requestingCivInfo.getDiplomacyManager(decliningCiv);
                                Intrinsics.checkNotNull(diplomacyManager);
                                requestingCivDiploManager = diplomacyManager;
                                $this$all$iv = this.getTrade().getOurOffers();
                                $i$f$all = false;
                                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                    bl6 = true;
                                } else {
                                    for (Object element$iv : $this$all$iv) {
                                        it = (TradeOffer)element$iv;
                                        boolean bl7 = false;
                                        if (it.getType() == TradeType.Luxury_Resource) continue;
                                        bl6 = false;
                                        break block29;
                                    }
                                    bl6 = true;
                                }
                            }
                            if (bl6) {
                                boolean bl8;
                                block30: {
                                    $this$all$iv = this.getTrade().getTheirOffers();
                                    $i$f$all = false;
                                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                        bl8 = true;
                                    } else {
                                        for (Object element$iv : $this$all$iv) {
                                            it = (TradeOffer)element$iv;
                                            boolean bl9 = false;
                                            if (it.getType() == TradeType.Luxury_Resource) continue;
                                            bl8 = false;
                                            break block30;
                                        }
                                        bl8 = true;
                                    }
                                }
                                if (bl8) {
                                    requestingCivDiploManager.setFlag(DiplomacyFlags.DeclinedLuxExchange, 5 - (int)(requestingCivInfo.getPersonality().get(PersonalityValue.Commerce) / (float)2));
                                }
                            }
                            $this$any$iv = this.getTrade().getOurOffers();
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl5 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    it = (TradeOffer)element$iv;
                                    boolean bl10 = false;
                                    if (!Intrinsics.areEqual(it.getName(), "Research Agreement")) continue;
                                    bl5 = true;
                                    break block31;
                                }
                                bl5 = false;
                            }
                        }
                        if (bl5) {
                            requestingCivDiploManager.setFlag(DiplomacyFlags.DeclinedResearchAgreement, 15 - (int)requestingCivInfo.getPersonality().get(PersonalityValue.Science));
                        }
                        $this$any$iv = this.getTrade().getOurOffers();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (TradeOffer)element$iv;
                                boolean bl11 = false;
                                if (!Intrinsics.areEqual(it.getName(), "Defensive Pact")) continue;
                                bl4 = true;
                                break block32;
                            }
                            bl4 = false;
                        }
                    }
                    if (bl4) {
                        requestingCivDiploManager.setFlag(DiplomacyFlags.DeclinedDefensivePact, 10);
                    }
                    $this$any$iv = this.getTrade().getOurOffers();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (TradeOffer)element$iv;
                            boolean bl12 = false;
                            if (!Intrinsics.areEqual(it.getName(), "Open Borders")) continue;
                            bl3 = true;
                            break block33;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    requestingCivDiploManager.setFlag(DiplomacyFlags.DeclinedOpenBorders, decliningCiv.isAI() ? 5 : 10);
                }
                $this$any$iv = this.getTrade().getTheirOffers();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (TradeOffer)element$iv;
                        boolean bl13 = false;
                        if (!(it.getType() == TradeType.WarDeclaration)) continue;
                        bl2 = true;
                        break block34;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                requestingCivDiploManager.setFlag(DiplomacyFlags.DeclinedJoinWarOffer, decliningCiv.isAI() ? 5 : 10);
            }
            $this$any$iv = this.getTrade().getOurOffers();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    boolean bl14 = false;
                    if (!(it.getType() == TradeType.WarDeclaration)) continue;
                    bl = true;
                    break block35;
                }
                bl = false;
            }
        }
        if (bl) {
            requestingCivDiploManager.otherCivDiplomacy().setFlag(DiplomacyFlags.DeclinedJoinWarOffer, decliningCiv.isAI() ? 5 : 10);
        }
        if (this.getTrade().isPeaceTreaty()) {
            requestingCivDiploManager.setFlag(DiplomacyFlags.DeclinedPeace, 3);
        }
        String[] stringArray = new String[]{decliningCiv.getCivName(), "StatIcons/Acquire"};
        requestingCivInfo.addNotification('[' + decliningCiv.getCivName() + "] has denied your trade request", Notification.NotificationCategory.Trade, stringArray);
    }

    @NotNull
    public final String getRequestingCiv() {
        String string = this.requestingCiv;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("requestingCiv");
        return null;
    }

    public final void setRequestingCiv(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.requestingCiv = string;
    }

    @NotNull
    public final Trade getTrade() {
        Trade trade = this.trade;
        if (trade != null) {
            return trade;
        }
        Intrinsics.throwUninitializedPropertyAccessException("trade");
        return null;
    }

    public final void setTrade(@NotNull Trade trade) {
        Intrinsics.checkNotNullParameter(trade, "<set-?>");
        this.trade = trade;
    }

    public TradeRequest() {
    }

    public TradeRequest(@NotNull String requestingCiv, @NotNull Trade trade) {
        Intrinsics.checkNotNullParameter(requestingCiv, "requestingCiv");
        Intrinsics.checkNotNullParameter(trade, "trade");
        this.setRequestingCiv(requestingCiv);
        this.setTrade(trade);
    }
}

