/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.EspionageAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.managers.EspionageManager;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.map.TileMap;
import com.unciv.models.SpyAction;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0014\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003J\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010$\u001a\u00020\u0000J\u0006\u0010%\u001a\u00020\u001fJ\u0006\u0010&\u001a\u00020\u000eJ\b\u0010'\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\"J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020\u0003J\u0006\u0010.\u001a\u00020\u0005J\b\u0010/\u001a\u00020\u0005H\u0002J\b\u00100\u001a\u00020\u001fH\u0002J\u0006\u00101\u001a\u00020\"J\u0006\u00102\u001a\u00020\"J\u0006\u00103\u001a\u00020\"J\u0006\u00104\u001a\u00020\"J\b\u00105\u001a\u00020\u001fH\u0002J\u0010\u00106\u001a\u00020\u001f2\b\b\u0002\u00107\u001a\u00020\u0005J\u0010\u00108\u001a\u00020\u001f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\b\u00109\u001a\u00020\u0005H\u0002J\u0018\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020\t2\b\b\u0002\u0010<\u001a\u00020\u0005J\u000e\u0010=\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u000fJ\b\u0010>\u001a\u00020\u001fH\u0002J\b\u0010?\u001a\u00020\u001fH\u0002R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006@"}, d2={"Lcom/unciv/models/Spy;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "name", "", "rank", "", "(Ljava/lang/String;I)V", "()V", "<set-?>", "Lcom/unciv/models/SpyAction;", "action", "getAction", "()Lcom/unciv/models/SpyAction;", "city", "Lcom/unciv/logic/city/City;", "Lcom/unciv/logic/civilization/Civilization;", "civInfo", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "espionageManager", "Lcom/unciv/logic/civilization/managers/EspionageManager;", "location", "Lcom/badlogic/gdx/math/Vector2;", "getName", "()Ljava/lang/String;", "progressTowardsStealingTech", "getRank", "()I", "turnsRemainingForAction", "getTurnsRemainingForAction", "addNotification", "", "text", "canDoCoup", "", "canMoveTo", "clone", "endTurn", "getCity", "getCityOrNull", "getCoupChanceOfSuccess", "", "includeUnkownFactors", "getEfficiencyModifier", "", "getLocationName", "getSkillModifierPercent", "getTurnsRemainingToStealTech", "initiateCoup", "isAlive", "isDoingWork", "isIdle", "isSetUp", "killSpy", "levelUpSpy", "amount", "moveTo", "randomSeed", "setAction", "newAction", "turns", "setTransients", "startStealingTech", "stealTech", "core"})
@SourceDebugExtension(value={"SMAP\nSpy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Spy.kt\ncom/unciv/models/Spy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,426:1\n1#2:427\n*E\n"})
public final class Spy
implements IsPartOfGameInfoSerialization {
    private String name;
    private int rank;
    @Nullable
    private Vector2 location;
    @NotNull
    private SpyAction action;
    private int turnsRemainingForAction;
    private int progressTowardsStealingTech;
    private transient Civilization civInfo;
    private transient EspionageManager espionageManager;
    @Nullable
    private transient City city;

    private Spy() {
        this.rank = 1;
        this.action = SpyAction.None;
    }

    @NotNull
    public final String getName() {
        String string = this.name;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("name");
        return null;
    }

    public final int getRank() {
        return this.rank;
    }

    @NotNull
    public final SpyAction getAction() {
        return this.action;
    }

    public final int getTurnsRemainingForAction() {
        return this.turnsRemainingForAction;
    }

    @NotNull
    public final Civilization getCivInfo() {
        Civilization civilization = this.civInfo;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("civInfo");
        return null;
    }

    public Spy(@NotNull String name2, int rank) {
        Intrinsics.checkNotNullParameter(name2, "name");
        this();
        this.name = name2;
        this.rank = rank;
    }

    @NotNull
    public final Spy clone() {
        Spy toReturn = new Spy(this.getName(), this.rank);
        toReturn.location = this.location;
        toReturn.action = this.action;
        toReturn.turnsRemainingForAction = this.turnsRemainingForAction;
        toReturn.progressTowardsStealingTech = this.progressTowardsStealingTech;
        return toReturn;
    }

    public final void setTransients(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
        this.espionageManager = civInfo.getEspionageManager();
    }

    public final void setAction(@NotNull SpyAction newAction, int turns) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)newAction, "newAction");
        boolean bl2 = bl = !newAction.getHasCountdownTurns() || turns > 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.action = newAction;
        this.turnsRemainingForAction = turns;
    }

    public static /* synthetic */ void setAction$default(Spy spy, SpyAction spyAction, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        spy.setAction(spyAction, n);
    }

    public final void endTurn() {
        if (this.action.getHasCountdownTurns()) {
            this.turnsRemainingForAction += -1;
            if (this.turnsRemainingForAction > 0) {
                return;
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.action.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                if (Intrinsics.areEqual(this.getCity().getCiv(), this.getCivInfo())) {
                    this.setAction(SpyAction.CounterIntelligence, 10);
                    break;
                }
                this.setAction(SpyAction.EstablishNetwork, 3);
                break;
            }
            case 3: {
                City city2 = this.getCity();
                if (city2.getCiv().isCityState()) {
                    Integer n = this.getCity().getCiv().getFlagsCountdown().get("TurnsTillCityStateElection");
                    if (n == null) {
                        n = 1;
                    }
                    this.setAction(SpyAction.RiggingElections, n - 1);
                    break;
                }
                if (Intrinsics.areEqual(city2.getCiv(), this.getCivInfo())) {
                    this.setAction(SpyAction.CounterIntelligence, 10);
                    break;
                }
                this.startStealingTech();
                break;
            }
            case 4: {
                Set<String> stealableTechs;
                if (!this.getCity().getCiv().isMajorCiv()) {
                    return;
                }
                EspionageManager espionageManager = this.espionageManager;
                if (espionageManager == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("espionageManager");
                    espionageManager = null;
                }
                if ((stealableTechs = espionageManager.getTechsToSteal(this.getCity().getCiv())).isEmpty() || this.getTurnsRemainingToStealTech() < 0) {
                    return;
                }
                Spy.setAction$default(this, SpyAction.StealingTech, 0, 2, null);
                break;
            }
            case 5: {
                this.turnsRemainingForAction = this.getTurnsRemainingToStealTech();
                if (this.turnsRemainingForAction < 0) {
                    Spy.setAction$default(this, SpyAction.Surveillance, 0, 2, null);
                    if (this.turnsRemainingForAction != -1) break;
                    this.addNotification("Your spy [" + this.getName() + "] cannot steal any more techs from [" + this.getCity().getCiv() + "] as we've already researched all the technology they know!");
                    break;
                }
                if (this.turnsRemainingForAction != 0) break;
                this.stealTech();
                break;
            }
            case 6: {
                Integer n = this.getCity().getCiv().getFlagsCountdown().get("TurnsTillCityStateElection");
                if (n == null) {
                    n = 0;
                }
                this.turnsRemainingForAction = n - 1;
                break;
            }
            case 7: {
                this.initiateCoup();
                break;
            }
            case 8: {
                String oldSpyName = this.getName();
                EspionageManager espionageManager = this.espionageManager;
                if (espionageManager == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("espionageManager");
                    espionageManager = null;
                }
                this.name = espionageManager.getSpyName();
                Spy.setAction$default(this, SpyAction.None, 0, 2, null);
                EspionageManager espionageManager2 = this.espionageManager;
                if (espionageManager2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("espionageManager");
                    espionageManager2 = null;
                }
                this.rank = espionageManager2.getStartingSpyRank();
                this.addNotification("We have recruited a new spy name [" + this.getName() + "] after [" + oldSpyName + "] was killed.");
                break;
            }
            case 9: {
                this.turnsRemainingForAction += -1;
                return;
            }
        }
    }

    private final void startStealingTech() {
        this.progressTowardsStealingTech = 0;
        Spy.setAction$default(this, SpyAction.StealingTech, 0, 2, null);
        this.endTurn();
    }

    private final int getTurnsRemainingToStealTech() {
        Comparable comparable;
        Set<String> stealableTechs;
        EspionageManager espionageManager = this.espionageManager;
        if (espionageManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("espionageManager");
            espionageManager = null;
        }
        if ((stealableTechs = espionageManager.getTechsToSteal(this.getCity().getCiv())).isEmpty()) {
            return -1;
        }
        Iterator iterator2 = ((Iterable)stealableTechs).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            String it = (String)iterator2.next();
            boolean bl = false;
            Technology technology2 = this.getCivInfo().getGameInfo().getRuleset().getTechnologies().get(it);
            Intrinsics.checkNotNull(technology2);
            Comparable comparable2 = Integer.valueOf(technology2.getCost());
            while (iterator2.hasNext()) {
                String it2 = (String)iterator2.next();
                $i$a$-maxOfOrNull-Spy$getTurnsRemainingToStealTech$techStealCost$1 = false;
                Technology technology3 = this.getCivInfo().getGameInfo().getRuleset().getTechnologies().get(it2);
                Intrinsics.checkNotNull(technology3);
                Comparable comparable3 = Integer.valueOf(technology3.getCost());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Intrinsics.checkNotNull(comparable);
        int techStealCost = ((Number)((Object)comparable)).intValue();
        float progressThisTurn = this.getCity().getCityStats().getCurrentCityStats().getScience();
        if (progressThisTurn <= 0.0f) {
            return -2;
        }
        progressThisTurn *= ((float)this.rank + 2.0f) / 3.0f;
        this.progressTowardsStealingTech += (int)(progressThisTurn *= (float)this.getEfficiencyModifier());
        if (this.progressTowardsStealingTech >= techStealCost) {
            return 0;
        }
        return (int)Math.ceil((float)(techStealCost - this.progressTowardsStealingTech) / progressThisTurn);
    }

    private final void stealTech() {
        block7: {
            String detectionString;
            Spy defendingSpy;
            City city2 = this.getCity();
            Civilization otherCiv = city2.getCiv();
            int randomSeed = this.randomSeed();
            EspionageManager espionageManager = this.espionageManager;
            if (espionageManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException("espionageManager");
                espionageManager = null;
            }
            String stolenTech = (String)CollectionsKt.randomOrNull((Collection)espionageManager.getTechsToSteal(this.getCity().getCiv()), RandomKt.Random(randomSeed));
            int spyResult = RandomKt.Random(randomSeed).nextInt(300);
            spyResult -= this.getSkillModifierPercent();
            Spy spy = defendingSpy = city2.getCiv().getEspionageManager().getSpyAssignedToCity(city2);
            int n = spy != null ? spy.getSkillModifierPercent() : 0;
            String string = (spyResult += n) >= 200 ? (defendingSpy == null ? "A spy from [" + this.getCivInfo().getCivName() + "] was found and killed trying to steal Technology in [" + city2 + "]!" : "A spy from [" + this.getCivInfo().getCivName() + "] was found and killed by [" + defendingSpy.getName() + "] trying to steal Technology in [" + city2 + "]!") : (stolenTech == null ? null : (spyResult < 0 ? null : (detectionString = spyResult < 100 ? "An unidentified spy stole the Technology [" + stolenTech + "] from [" + city2 + "]!" : "A spy from [" + this.getCivInfo().getCivName() + "] stole the Technology [" + stolenTech + "] from [" + city2 + "]!")));
            if (detectionString != null) {
                String[] stringArray = new String[]{"OtherIcons/Spy"};
                otherCiv.addNotification(detectionString, city2.getLocation(), Notification.NotificationCategory.Espionage, stringArray);
            }
            if (spyResult < 200 && stolenTech != null) {
                TechManager.addTechnology$default(this.getCivInfo().getTech(), stolenTech, false, 2, null);
                this.addNotification("Your spy [" + this.getName() + "] stole the Technology [" + stolenTech + "] from [" + city2 + "]!");
                Spy.levelUpSpy$default(this, 0, 1, null);
            }
            if (spyResult >= 200) {
                this.addNotification("Your spy [" + this.getName() + "] was killed trying to steal Technology in [" + city2 + "]!");
                Spy spy2 = defendingSpy;
                if (spy2 != null) {
                    Spy.levelUpSpy$default(spy2, 0, 1, null);
                }
                this.killSpy();
            } else {
                this.startStealingTech();
            }
            if (spyResult < 100) break block7;
            DiplomacyManager diplomacyManager = otherCiv.getDiplomacyManager(this.getCivInfo());
            if (diplomacyManager != null) {
                diplomacyManager.addModifier(DiplomaticModifiers.SpiedOnUs, -15.0f);
            }
        }
    }

    public final boolean canDoCoup() {
        return this.getCityOrNull() != null && this.getCity().getCiv().isCityState() && this.isSetUp() && !Intrinsics.areEqual(this.getCity().getCiv().getAllyCiv(), this.getCivInfo().getCivName());
    }

    private final void initiateCoup() {
        block10: {
            IsPartOfGameInfoSerialization isPartOfGameInfoSerialization;
            Civilization allyCiv;
            Civilization cityState;
            block9: {
                float f;
                Civilization civilization;
                if (!this.canDoCoup()) {
                    this.setAction(SpyAction.RiggingElections, 10);
                    return;
                }
                cityState = this.getCity().getCiv();
                String string = cityState.getAllyCiv();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    civilization = this.getCivInfo().getGameInfo().getCivilization(it);
                } else {
                    civilization = null;
                }
                allyCiv = civilization;
                float successChance = this.getCoupChanceOfSuccess(true);
                float randomValue = RandomKt.Random(this.randomSeed()).nextFloat();
                if (!(randomValue <= successChance)) break block9;
                Civilization civilization2 = allyCiv;
                if (civilization2 != null) {
                    DiplomacyManager diplomacyManager = cityState.getDiplomacyManager(civilization2);
                    Intrinsics.checkNotNull(diplomacyManager);
                    f = diplomacyManager.getInfluence();
                } else {
                    f = 80.0f;
                }
                float previousInfluence = f;
                DiplomacyManager diplomacyManager = cityState.getDiplomacyManager(this.getCivInfo());
                Intrinsics.checkNotNull(diplomacyManager);
                diplomacyManager.setInfluence(previousInfluence);
                Object object = new String[]{"OtherIcons/Spy", cityState.getCivName()};
                this.getCivInfo().addNotification("Your spy [" + this.getName() + "] successfully staged a coup in [" + cityState.getCivName() + "]!", this.getCity().getLocation(), Notification.NotificationCategory.Espionage, (String[])object);
                if (allyCiv != null) {
                    cityState.getDiplomacyManagerOrMeet(allyCiv).reduceInfluence(20.0f);
                    object = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Spy", cityState.getCivName()};
                    allyCiv.addNotification("A spy from [" + this.getCivInfo().getCivName() + "] successfully staged a coup in our former ally [" + cityState.getCivName() + "]!", this.getCity().getLocation(), Notification.NotificationCategory.Espionage, (String[])object);
                    allyCiv.getDiplomacyManagerOrMeet(this.getCivInfo()).addModifier(DiplomaticModifiers.SpiedOnUs, -15.0f);
                }
                object = cityState.getKnownCivsWithSpectators().iterator();
                while (object.hasNext()) {
                    Civilization civ = (Civilization)object.next();
                    if (Intrinsics.areEqual(civ, allyCiv) || Intrinsics.areEqual(civ, this.getCivInfo())) continue;
                    String[] stringArray = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Spy", cityState.getCivName()};
                    civ.addNotification("A spy from [" + this.getCivInfo().getCivName() + "] successfully staged a coup in [" + cityState.getCivName() + "]!", this.getCity().getLocation(), Notification.NotificationCategory.Espionage, stringArray);
                    if (civ.isSpectator()) continue;
                    DiplomacyManager diplomacyManager2 = cityState.getDiplomacyManager(civ);
                    Intrinsics.checkNotNull(diplomacyManager2);
                    diplomacyManager2.reduceInfluence(10.0f);
                }
                this.setAction(SpyAction.RiggingElections, 10);
                cityState.getCityStateFunctions().updateAllyCivForCityState();
                break block10;
            }
            IsPartOfGameInfoSerialization isPartOfGameInfoSerialization2 = allyCiv;
            Spy spy = isPartOfGameInfoSerialization2 != null && (isPartOfGameInfoSerialization2 = ((Civilization)isPartOfGameInfoSerialization2).getEspionageManager()) != null ? ((EspionageManager)isPartOfGameInfoSerialization2).getSpyAssignedToCity(this.getCity()) : null;
            DiplomacyManager diplomacyManager = cityState.getDiplomacyManager(this.getCivInfo());
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.addInfluence(-20.0f);
            Civilization civilization = allyCiv;
            if (civilization != null) {
                String[] stringArray = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Spy", cityState.getCivName()};
                civilization.addNotification("A spy from [" + this.getCivInfo().getCivName() + "] failed to stag a coup in our ally [" + cityState.getCivName() + "] and was killed!", this.getCity().getLocation(), Notification.NotificationCategory.Espionage, stringArray);
            }
            if ((isPartOfGameInfoSerialization = allyCiv) != null && (isPartOfGameInfoSerialization = ((Civilization)isPartOfGameInfoSerialization).getDiplomacyManagerOrMeet(this.getCivInfo())) != null) {
                ((DiplomacyManager)isPartOfGameInfoSerialization).addModifier(DiplomaticModifiers.SpiedOnUs, -10.0f);
            }
            String[] stringArray = new String[]{this.getCivInfo().getCivName(), "OtherIcons/Spy", cityState.getCivName()};
            this.getCivInfo().addNotification("Our spy [" + this.getName() + "] failed to stag a coup in [" + cityState.getCivName() + "] and was killed!", this.getCity().getLocation(), Notification.NotificationCategory.Espionage, stringArray);
            this.killSpy();
            Spy spy2 = spy;
            if (spy2 == null) break block10;
            Spy.levelUpSpy$default(spy2, 0, 1, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final float getCoupChanceOfSuccess(boolean includeUnkownFactors) {
        block5: {
            block4: {
                cityState = this.getCity().getCiv();
                successPercentage = 50.0f;
                if (cityState.getAllyCiv() != null) {
                    v0 = cityState.getAllyCiv();
                    Intrinsics.checkNotNull(v0);
                    v1 = cityState.getDiplomacyManager(v0);
                    Intrinsics.checkNotNull(v1);
                    v2 = v1.getInfluence();
                } else {
                    v2 = 60.0f;
                }
                influenceDifference = v2;
                v3 = cityState.getDiplomacyManager(this.getCivInfo());
                Intrinsics.checkNotNull(v3);
                successPercentage -= (influenceDifference -= v3.getInfluence()) / 2.0f;
                if (!includeUnkownFactors) break block4;
                v4 = cityState.getAllyCiv();
                if (v4 == null) ** GOTO lbl-1000
                it = v4;
                $i$a$-let-Spy$getCoupChanceOfSuccess$defendingSpy$1 = false;
                v5 = this.getCivInfo().getGameInfo().getCivilization(it);
                v4 = v5;
                if (v5 != null && (v4 = v4.getEspionageManager()) != null) {
                    v6 = v4.getSpyAssignedToCity(this.getCity());
                } else lbl-1000:
                // 2 sources

                {
                    v6 = null;
                }
                break block5;
            }
            v6 = null;
        }
        defendingSpy = v6;
        v7 = defendingSpy;
        spyRanks = this.getSkillModifierPercent() - (v7 != null ? v7.getSkillModifierPercent() : 0);
        successPercentage += (float)spyRanks / 2.0f;
        successPercentage = RangesKt.coerceIn(successPercentage, 0.0f, 85.0f);
        return successPercentage / 100.0f;
    }

    public final void moveTo(@Nullable City city2) {
        if (city2 == null) {
            this.location = null;
            this.city = null;
            Spy.setAction$default(this, SpyAction.None, 0, 2, null);
            return;
        }
        this.location = city2.getLocation();
        this.city = city2;
        this.setAction(SpyAction.Moving, 1);
    }

    public final boolean canMoveTo(@NotNull City city2) {
        Intrinsics.checkNotNullParameter(city2, "city");
        if (Intrinsics.areEqual(this.getCityOrNull(), city2)) {
            return true;
        }
        if (!city2.getCenterTile().isExplored(this.getCivInfo())) {
            return false;
        }
        EspionageManager espionageManager = this.espionageManager;
        if (espionageManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("espionageManager");
            espionageManager = null;
        }
        return espionageManager.getSpyAssignedToCity(city2) == null;
    }

    public final boolean isSetUp() {
        return this.action.isSetUp$core();
    }

    public final boolean isIdle() {
        return this.action == SpyAction.None;
    }

    public final boolean isDoingWork() {
        return this.action.isDoingWork$core(this);
    }

    @Nullable
    public final City getCityOrNull() {
        if (this.location == null) {
            return null;
        }
        if (this.city == null) {
            TileMap tileMap = this.getCivInfo().getGameInfo().getTileMap();
            Vector2 vector2 = this.location;
            Intrinsics.checkNotNull(vector2);
            this.city = tileMap.get(vector2).getCity();
        }
        return this.city;
    }

    @NotNull
    public final City getCity() {
        City city2 = this.getCityOrNull();
        Intrinsics.checkNotNull(city2);
        return city2;
    }

    @NotNull
    public final String getLocationName() {
        Object object = this.getCityOrNull();
        if (object == null || (object = ((City)object).getName()) == null) {
            object = "Spy Hideout";
        }
        return object;
    }

    public final void levelUpSpy(int amount) {
        if (this.rank >= this.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getMaxSpyRank()) {
            return;
        }
        int ranksToLevelUp = RangesKt.coerceAtMost(amount, this.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getMaxSpyRank() - this.rank);
        if (ranksToLevelUp == 1) {
            this.addNotification("Your spy [" + this.getName() + "] has leveled up!");
        } else {
            this.addNotification("Your spy [" + this.getName() + "] has leveled up [" + ranksToLevelUp + "] times!");
        }
        this.rank += ranksToLevelUp;
    }

    public static /* synthetic */ void levelUpSpy$default(Spy spy, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        spy.levelUpSpy(n);
    }

    public final int getSkillModifierPercent() {
        return this.rank * this.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getSpyRankSkillPercentBonus();
    }

    public final double getEfficiencyModifier() {
        int n;
        Unique it;
        int n2;
        Unique unique;
        Sequence<Unique> friendlyUniques = null;
        Sequence<Unique> enemyUniques = null;
        City city2 = this.getCityOrNull();
        if (city2 == null) {
            friendlyUniques = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.SpyEffectiveness, null, 2, null);
            enemyUniques = SequencesKt.sequenceOf(new Unique[0]);
        } else if (Intrinsics.areEqual(city2.getCiv(), this.getCivInfo())) {
            friendlyUniques = city2.getMatchingUniques(UniqueType.SpyEffectiveness, new StateForConditionals(city2), true);
            enemyUniques = SequencesKt.sequenceOf(new Unique[0]);
        } else {
            friendlyUniques = Civilization.getMatchingUniques$default(this.getCivInfo(), UniqueType.SpyEffectiveness, null, 2, null);
            enemyUniques = city2.getMatchingUniques(UniqueType.EnemySpyEffectiveness, new StateForConditionals(city2), true);
        }
        double totalEfficiency = 1.0;
        Sequence<Unique> sequence = friendlyUniques;
        double d = 100.0;
        double d2 = totalEfficiency;
        int n3 = 0;
        Iterator<Unique> iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            Unique unique2 = unique = iterator2.next();
            n2 = n3;
            boolean bl = false;
            n = Integer.parseInt(it.getParams().get(0));
            n3 = n2 + n;
        }
        n2 = n3;
        totalEfficiency = d2 * ((d + (double)n2) / (double)100);
        sequence = enemyUniques;
        d = 100.0;
        d2 = totalEfficiency;
        n3 = 0;
        iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            it = unique = iterator2.next();
            n2 = n3;
            boolean bl = false;
            n = Integer.parseInt(it.getParams().get(0));
            n3 = n2 + n;
        }
        n2 = n3;
        totalEfficiency = d2 * ((d + (double)n2) / (double)100);
        return RangesKt.coerceAtLeast(totalEfficiency, 0.0);
    }

    private final void killSpy() {
        this.moveTo(null);
        this.setAction(SpyAction.Dead, 5);
        this.rank = 1;
    }

    public final boolean isAlive() {
        return this.action != SpyAction.Dead;
    }

    public final void addNotification(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        String[] stringArray = new String[]{"OtherIcons/Spy"};
        this.getCivInfo().addNotification(text2, EspionageAction.Companion.withLocation(this.location), Notification.NotificationCategory.Espionage, stringArray);
    }

    private final int randomSeed() {
        City $this$randomSeed_u24lambda_u245 = this.getCity();
        boolean bl = false;
        return (int)($this$randomSeed_u24lambda_u245.getLocation().x * $this$randomSeed_u24lambda_u245.getLocation().y + 123.0f * (float)this.getCivInfo().getGameInfo().getTurns());
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpyAction.values().length];
            try {
                nArray[SpyAction.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.Moving.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.EstablishNetwork.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.Surveillance.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.StealingTech.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.RiggingElections.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.Coup.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.Dead.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpyAction.CounterIntelligence.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

