/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.RejectionReason;
import com.unciv.models.ruleset.RejectionReasonType;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.TechColumn;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.INamed;
import com.unciv.models.stats.Stat;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001f\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010 \u001a\u00020\u0005H\u0016J \u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)H\u0016J\u001a\u0010*\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H&J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020,0&2\u0006\u0010-\u001a\u00020.H&J\u001f\u0010/\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H&\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\r0&H\u0016J\u001c\u00103\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.2\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u0018H&J\u0018\u00105\u001a\b\u0012\u0004\u0012\u00020\r062\b\u00107\u001a\u0004\u0018\u000108H\u0016R\u0018\u0010\u0004\u001a\u00020\u0005X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\u0004\u0018\u00010\rX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u00069"}, d2={"Lcom/unciv/models/ruleset/INonPerpetualConstruction;", "Lcom/unciv/models/ruleset/IConstruction;", "Lcom/unciv/models/stats/INamed;", "Lcom/unciv/models/ruleset/unique/IHasUniques;", "cost", "", "getCost", "()I", "setCost", "(I)V", "hurryCostModifier", "getHurryCostModifier", "requiredTech", "", "getRequiredTech", "()Ljava/lang/String;", "setRequiredTech", "(Ljava/lang/String;)V", "canBePurchasedWithAnyStat", "", "city", "Lcom/unciv/logic/city/City;", "canBePurchasedWithStat", "stat", "Lcom/unciv/models/stats/Stat;", "getBaseBuyCost", "", "(Lcom/unciv/logic/city/City;Lcom/unciv/models/stats/Stat;)Ljava/lang/Float;", "getBaseGoldCost", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getCivilopediaGoldCost", "getCostForConstructionsIncreasingInPrice", "baseCost", "increaseCost", "previouslyBought", "getMatchingUniquesNotConflicting", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/unique/Unique;", "uniqueType", "Lcom/unciv/models/ruleset/unique/UniqueType;", "getProductionCost", "getRejectionReasons", "Lcom/unciv/models/ruleset/RejectionReason;", "cityConstructions", "Lcom/unciv/logic/city/CityConstructions;", "getStatBuyCost", "(Lcom/unciv/logic/city/City;Lcom/unciv/models/stats/Stat;)Ljava/lang/Integer;", "isPurchasable", "legacyRequiredTechs", "postBuildEvent", "boughtWith", "requiredResources", "", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "core"})
public interface INonPerpetualConstruction
extends IConstruction,
INamed,
IHasUniques {
    public int getCost();

    public void setCost(int var1);

    public int getHurryCostModifier();

    @Nullable
    public String getRequiredTech();

    public void setRequiredTech(@Nullable String var1);

    @Override
    @NotNull
    public Sequence<String> legacyRequiredTechs();

    public int getProductionCost(@NotNull Civilization var1, @Nullable City var2);

    @Nullable
    public Integer getStatBuyCost(@NotNull City var1, @NotNull Stat var2);

    @NotNull
    public Sequence<RejectionReason> getRejectionReasons(@NotNull CityConstructions var1);

    public boolean postBuildEvent(@NotNull CityConstructions var1, @Nullable Stat var2);

    public boolean canBePurchasedWithStat(@Nullable City var1, @NotNull Stat var2);

    public boolean isPurchasable(@NotNull CityConstructions var1);

    public boolean canBePurchasedWithAnyStat(@NotNull City var1);

    public int getCivilopediaGoldCost();

    public double getBaseGoldCost(@NotNull Civilization var1, @Nullable City var2);

    @Nullable
    public Float getBaseBuyCost(@NotNull City var1, @NotNull Stat var2);

    public int getCostForConstructionsIncreasingInPrice(int var1, int var2, int var3);

    @Override
    @NotNull
    public Sequence<Unique> getMatchingUniquesNotConflicting(@NotNull UniqueType var1);

    @Override
    @NotNull
    public Set<String> requiredResources(@Nullable StateForConditionals var1);

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nIConstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IConstruction.kt\ncom/unciv/models/ruleset/INonPerpetualConstruction$DefaultImpls\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n1229#2,2:280\n1229#2,2:282\n1206#2,2:284\n1821#2,14:289\n1229#2,2:303\n1747#3,3:286\n*S KotlinDebug\n*F\n+ 1 IConstruction.kt\ncom/unciv/models/ruleset/INonPerpetualConstruction$DefaultImpls\n*L\n53#1:280,2\n57#1:282,2\n66#1:284,2\n90#1:289,14\n97#1:303,2\n71#1:286,3\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static Sequence<String> legacyRequiredTechs(@NotNull INonPerpetualConstruction $this) {
            Sequence<String> sequence;
            if ($this.getRequiredTech() == null) {
                sequence = SequencesKt.sequenceOf(new String[0]);
            } else {
                String[] stringArray = new String[1];
                Intrinsics.checkNotNull($this.getRequiredTech());
                sequence = SequencesKt.sequenceOf(stringArray);
            }
            return sequence;
        }

        public static /* synthetic */ boolean postBuildEvent$default(INonPerpetualConstruction iNonPerpetualConstruction, CityConstructions cityConstructions, Stat stat, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: postBuildEvent");
            }
            if ((n & 2) != 0) {
                stat = null;
            }
            return iNonPerpetualConstruction.postBuildEvent(cityConstructions, stat);
        }

        public static boolean canBePurchasedWithStat(@NotNull INonPerpetualConstruction $this, @Nullable City city2, @NotNull Stat stat) {
            Unique it;
            Unique element$iv;
            Iterator<Unique> iterator2;
            Sequence<Unique> $this$any$iv;
            boolean $i$f$any;
            Intrinsics.checkNotNullParameter((Object)stat, "stat");
            City city3 = city2;
            StateForConditionals stateForConditionals = new StateForConditionals(city3 != null ? city3.getCiv() : null, city2, null, null, null, null, null, null, null, false, 1020, null);
            if (stat == Stat.Production || stat == Stat.Happiness) {
                return false;
            }
            if ($this.hasUnique(UniqueType.CannotBePurchased, stateForConditionals)) {
                return false;
            }
            if (city2 != null) {
                boolean bl;
                block9: {
                    Sequence<Unique> sequence = $this.getMatchingUniques(UniqueType.CanBePurchasedWithStat, stateForConditionals);
                    $i$f$any = false;
                    iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual(it.getParams().get(0), stat.name()) && City.matchesFilter$default(city2, it.getParams().get(1), null, 2, null))) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
                if (bl) {
                    return true;
                }
            }
            if (city2 != null) {
                boolean bl;
                block10: {
                    $this$any$iv = $this.getMatchingUniques(UniqueType.CanBePurchasedForAmountStat, stateForConditionals);
                    $i$f$any = false;
                    iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        it = element$iv = iterator2.next();
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual(it.getParams().get(1), stat.name()) && City.matchesFilter$default(city2, it.getParams().get(2), null, 2, null))) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
                if (bl) {
                    return true;
                }
            }
            if (stat == Stat.Gold) {
                return !$this.hasUnique(UniqueType.Unbuildable, stateForConditionals);
            }
            return false;
        }

        public static boolean isPurchasable(@NotNull INonPerpetualConstruction $this, @NotNull CityConstructions cityConstructions) {
            boolean bl;
            block1: {
                Sequence<RejectionReason> rejectionReasons;
                Intrinsics.checkNotNullParameter(cityConstructions, "cityConstructions");
                Sequence<RejectionReason> $this$all$iv = rejectionReasons = $this.getRejectionReasons(cityConstructions);
                boolean $i$f$all = false;
                Iterator<RejectionReason> iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    RejectionReason element$iv;
                    RejectionReason it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (it.getType() == RejectionReasonType.Unbuildable) continue;
                    bl = false;
                    break block1;
                }
                bl = true;
            }
            return bl;
        }

        public static boolean canBePurchasedWithAnyStat(@NotNull INonPerpetualConstruction $this, @NotNull City city2) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter(city2, "city");
                Iterable $this$any$iv = Stat.Companion.getStatsUsableToBuy();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Stat it = (Stat)((Object)element$iv);
                        boolean bl2 = false;
                        if (!$this.canBePurchasedWithStat(city2, it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public static int getCivilopediaGoldCost(@NotNull INonPerpetualConstruction $this) {
            return (int)(Math.pow(30.0 * (double)$this.getCost(), 0.75) * (double)FormattingExtensionsKt.toPercent($this.getHurryCostModifier()) / (double)10) * 10;
        }

        public static double getBaseGoldCost(@NotNull INonPerpetualConstruction $this, @NotNull Civilization civInfo, @Nullable City city2) {
            Intrinsics.checkNotNullParameter(civInfo, "civInfo");
            return Math.pow(30.0 * (double)$this.getProductionCost(civInfo, city2), 0.75) * (double)FormattingExtensionsKt.toPercent($this.getHurryCostModifier());
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public static Float getBaseBuyCost(@NotNull INonPerpetualConstruction $this, @NotNull City city2, @NotNull Stat stat) {
            boolean bl;
            block9: {
                void $this$any$iv;
                Unique lowestCostUnique2;
                Object v0;
                Sequence<Unique> $this$minByOrNull$iv;
                Intrinsics.checkNotNullParameter(city2, "city");
                Intrinsics.checkNotNullParameter((Object)stat, "stat");
                StateForConditionals conditionalState = new StateForConditionals(city2.getCiv(), city2, null, null, null, null, null, null, null, false, 1020, null);
                Sequence<Unique> sequence = SequencesKt.filter($this.getMatchingUniques(UniqueType.CanBePurchasedForAmountStat, conditionalState), (Function1)new Function1<Unique, Boolean>(stat, city2){
                    final /* synthetic */ Stat $stat;
                    final /* synthetic */ City $city;
                    {
                        this.$stat = $stat;
                        this.$city = $city;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Unique it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return Intrinsics.areEqual(it.getParams().get(1), this.$stat.name()) && City.matchesFilter$default(this.$city, it.getParams().get(2), null, 2, null);
                    }
                });
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = minElem$iv;
                    } else {
                        Unique it = (Unique)minElem$iv;
                        boolean bl2 = false;
                        int minValue$iv = Integer.parseInt(it.getParams().get(0));
                        do {
                            Object e$iv = iterator$iv.next();
                            Unique it2 = (Unique)e$iv;
                            $i$a$-minByOrNull-INonPerpetualConstruction$getBaseBuyCost$lowestCostUnique$2 = false;
                            int v$iv = Integer.parseInt(it2.getParams().get(0));
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = minElem$iv;
                    }
                }
                Unique unique = lowestCostUnique2 = (Unique)v0;
                if (unique != null) {
                    float f = Integer.parseInt(unique.getParams().get(0));
                    Float f2 = city2.getCiv().getGameInfo().getSpeed().getStatCostModifiers().get((Object)stat);
                    Intrinsics.checkNotNull(f2);
                    return Float.valueOf(f * ((Number)f2).floatValue());
                }
                if (stat == Stat.Gold) {
                    return Float.valueOf((float)$this.getBaseGoldCost(city2.getCiv(), city2));
                }
                $this$minByOrNull$iv = $this.getMatchingUniques(UniqueType.CanBePurchasedWithStat, conditionalState);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Unique it = (Unique)element$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual(it.getParams().get(0), stat.name()) && City.matchesFilter$default(city2, it.getParams().get(1), null, 2, null))) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
            if (bl) {
                float f = city2.getCiv().getEra().getBaseUnitBuyCost();
                Float f3 = city2.getCiv().getGameInfo().getSpeed().getStatCostModifiers().get((Object)stat);
                Intrinsics.checkNotNull(f3);
                return Float.valueOf(f * ((Number)f3).floatValue());
            }
            return null;
        }

        public static int getCostForConstructionsIncreasingInPrice(@NotNull INonPerpetualConstruction $this, int baseCost, int increaseCost, int previouslyBought) {
            return (int)((float)baseCost + (float)increaseCost / 2.0f * (float)(previouslyBought * previouslyBought + previouslyBought));
        }

        @NotNull
        public static Sequence<Unique> getMatchingUniquesNotConflicting(@NotNull INonPerpetualConstruction $this, @NotNull UniqueType uniqueType) {
            Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
            return IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)$this, uniqueType, null, 2, null);
        }

        @NotNull
        public static Set<String> requiredResources(@NotNull INonPerpetualConstruction $this, @Nullable StateForConditionals stateForConditionals) {
            Set<String> set2 = $this.getResourceRequirementsPerTurn(stateForConditionals).keySet();
            Intrinsics.checkNotNullExpressionValue(set2, "getResourceRequirementsP\u2026tateForConditionals).keys");
            return SetsKt.plus(set2, SequencesKt.map($this.getMatchingUniques(UniqueType.CostsResources, stateForConditionals), requiredResources.1.INSTANCE));
        }

        @NotNull
        public static List<Unique> uniqueObjectsProvider(@NotNull INonPerpetualConstruction $this) {
            return IHasUniques.DefaultImpls.uniqueObjectsProvider($this);
        }

        @NotNull
        public static UniqueMap uniqueMapProvider(@NotNull INonPerpetualConstruction $this) {
            return IHasUniques.DefaultImpls.uniqueMapProvider($this);
        }

        @NotNull
        public static Sequence<Unique> getMatchingUniques(@NotNull INonPerpetualConstruction $this, @NotNull String uniqueTemplate, @Nullable StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter(uniqueTemplate, "uniqueTemplate");
            return IHasUniques.DefaultImpls.getMatchingUniques((IHasUniques)$this, uniqueTemplate, stateForConditionals);
        }

        @NotNull
        public static Sequence<Unique> getMatchingUniques(@NotNull INonPerpetualConstruction $this, @NotNull UniqueType uniqueType, @Nullable StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
            return IHasUniques.DefaultImpls.getMatchingUniques((IHasUniques)$this, uniqueType, stateForConditionals);
        }

        public static boolean hasUnique(@NotNull INonPerpetualConstruction $this, @NotNull String uniqueTemplate, @Nullable StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter(uniqueTemplate, "uniqueTemplate");
            return IHasUniques.DefaultImpls.hasUnique((IHasUniques)$this, uniqueTemplate, stateForConditionals);
        }

        public static boolean hasUnique(@NotNull INonPerpetualConstruction $this, @NotNull UniqueType uniqueType, @Nullable StateForConditionals stateForConditionals) {
            Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
            return IHasUniques.DefaultImpls.hasUnique((IHasUniques)$this, uniqueType, stateForConditionals);
        }

        @NotNull
        public static Sequence<Unique> availabilityUniques(@NotNull INonPerpetualConstruction $this) {
            return IHasUniques.DefaultImpls.availabilityUniques($this);
        }

        @NotNull
        public static Sequence<String> techsRequiredByUniques(@NotNull INonPerpetualConstruction $this) {
            return IHasUniques.DefaultImpls.techsRequiredByUniques($this);
        }

        @NotNull
        public static Sequence<String> requiredTechs(@NotNull INonPerpetualConstruction $this) {
            return IHasUniques.DefaultImpls.requiredTechs($this);
        }

        @NotNull
        public static Sequence<Technology> requiredTechnologies(@NotNull INonPerpetualConstruction $this, @NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return IHasUniques.DefaultImpls.requiredTechnologies($this, ruleset2);
        }

        @Nullable
        public static Era era(@NotNull INonPerpetualConstruction $this, @NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return IHasUniques.DefaultImpls.era($this, ruleset2);
        }

        @Nullable
        public static TechColumn techColumn(@NotNull INonPerpetualConstruction $this, @NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return IHasUniques.DefaultImpls.techColumn($this, ruleset2);
        }

        public static boolean availableInEra(@NotNull INonPerpetualConstruction $this, @NotNull Ruleset ruleset2, @NotNull String requestedEra) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            Intrinsics.checkNotNullParameter(requestedEra, "requestedEra");
            return IHasUniques.DefaultImpls.availableInEra($this, ruleset2, requestedEra);
        }

        public static boolean isHiddenBySettings(@NotNull INonPerpetualConstruction $this, @NotNull GameInfo gameInfo2) {
            Intrinsics.checkNotNullParameter(gameInfo2, "gameInfo");
            return IHasUniques.DefaultImpls.isHiddenBySettings($this, gameInfo2);
        }

        public static boolean isHiddenFromCivilopedia(@NotNull INonPerpetualConstruction $this, @Nullable GameInfo gameInfo2, @Nullable Ruleset ruleset2) {
            return IHasUniques.DefaultImpls.isHiddenFromCivilopedia($this, gameInfo2, ruleset2);
        }

        public static boolean isHiddenFromCivilopedia(@NotNull INonPerpetualConstruction $this, @NotNull Ruleset ruleset2) {
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            return IHasUniques.DefaultImpls.isHiddenFromCivilopedia($this, ruleset2);
        }
    }
}

