/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.validation;

import com.badlogic.gdx.files.FileHandle;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.validation.ModCompatibility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J$\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011J\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/unciv/models/ruleset/validation/ModCompatibility;", "", "()V", "isAudioVisualDeclared", "", "mod", "Lcom/unciv/models/ruleset/Ruleset;", "(Lcom/unciv/models/ruleset/Ruleset;)Ljava/lang/Boolean;", "isAudioVisualGuessed", "isAudioVisualMod", "isExtensionMod", "isIncompatible", "otherMod", "isIncompatibleWith", "meetsAllRequirements", "baseRuleset", "selectedExtensionMods", "", "meetsBaseRequirements", "modNameFilter", "modName", "", "filter", "core"})
@SourceDebugExtension(value={"SMAP\nModCompatibility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModCompatibility.kt\ncom/unciv/models/ruleset/validation/ModCompatibility\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1229#2,2:121\n2624#3,3:123\n819#3:126\n847#3,2:127\n1747#3,3:129\n2624#3,3:132\n*S KotlinDebug\n*F\n+ 1 ModCompatibility.kt\ncom/unciv/models/ruleset/validation/ModCompatibility\n*L\n68#1:121,2\n92#1:123,3\n109#1:126\n109#1:127,2\n110#1:129,3\n115#1:132,3\n*E\n"})
public final class ModCompatibility {
    @NotNull
    public static final ModCompatibility INSTANCE = new ModCompatibility();

    private ModCompatibility() {
    }

    public final boolean isAudioVisualMod(@NotNull Ruleset mod) {
        Intrinsics.checkNotNullParameter(mod, "mod");
        Boolean bl = this.isAudioVisualDeclared(mod);
        return bl != null ? bl.booleanValue() : this.isAudioVisualGuessed(mod);
    }

    private final Boolean isAudioVisualDeclared(Ruleset mod) {
        if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)mod.getModOptions(), UniqueType.ModIsAudioVisualOnly, null, 2, null)) {
            return true;
        }
        if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)mod.getModOptions(), UniqueType.ModIsAudioVisual, null, 2, null)) {
            return true;
        }
        if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)mod.getModOptions(), UniqueType.ModIsNotAudioVisual, null, 2, null)) {
            return false;
        }
        return null;
    }

    private final boolean isAudioVisualGuessed(Ruleset mod) {
        FileHandle fileHandle = mod.getFolderLocation();
        if (fileHandle == null) {
            return false;
        }
        FileHandle folder = fileHandle;
        if (ModCompatibility.isAudioVisualGuessed$isSubFolderNotEmpty(folder, "music")) {
            return true;
        }
        if (ModCompatibility.isAudioVisualGuessed$isSubFolderNotEmpty(folder, "sounds")) {
            return true;
        }
        if (ModCompatibility.isAudioVisualGuessed$isSubFolderNotEmpty(folder, "voices")) {
            return true;
        }
        FileHandle[] fileHandleArray = folder.list("atlas");
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "folder.list(\"atlas\")");
        return !(((Object[])fileHandleArray).length == 0);
    }

    public final boolean isExtensionMod(@NotNull Ruleset mod) {
        Intrinsics.checkNotNullParameter(mod, "mod");
        return !mod.getModOptions().isBaseRuleset() && !StringsKt.isBlank(mod.getName()) && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)mod.getModOptions(), UniqueType.ModIsAudioVisualOnly, null, 2, null);
    }

    private final boolean modNameFilter(String modName, String filter2) {
        if (Intrinsics.areEqual(modName, filter2)) {
            return true;
        }
        if (filter2.length() < 3 || !StringsKt.startsWith$default((CharSequence)filter2, '*', false, 2, null) || !StringsKt.endsWith$default((CharSequence)filter2, '*', false, 2, null)) {
            return false;
        }
        String string = filter2.substring(1, filter2.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        String partialName = string2;
        String string3 = modName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return StringsKt.contains$default((CharSequence)string3, partialName, false, 2, null);
    }

    private final boolean isIncompatibleWith(Ruleset mod, Ruleset otherMod) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)mod.getModOptions(), UniqueType.ModIncompatibleWith, null, 2, null);
            boolean $i$f$any = false;
            Iterator iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Unique it = (Unique)element$iv;
                boolean bl2 = false;
                if (!INSTANCE.modNameFilter(otherMod.getName(), it.getParams().get(0))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isIncompatible(Ruleset mod, Ruleset otherMod) {
        return this.isIncompatibleWith(mod, otherMod) || this.isIncompatibleWith(otherMod, mod);
    }

    public final boolean meetsBaseRequirements(@NotNull Ruleset mod, @NotNull Ruleset baseRuleset) {
        Intrinsics.checkNotNullParameter(mod, "mod");
        Intrinsics.checkNotNullParameter(baseRuleset, "baseRuleset");
        if (this.isIncompatible(mod, baseRuleset)) {
            return false;
        }
        Collection<Ruleset> collection = RulesetCache.INSTANCE.values();
        Intrinsics.checkNotNullExpressionValue(collection, "RulesetCache.values");
        List allOtherExtensionModNames2 = SequencesKt.toList(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), (Function1)new Function1<Ruleset, Boolean>(mod){
            final /* synthetic */ Ruleset $mod;
            {
                this.$mod = $mod;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Ruleset it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !Intrinsics.areEqual(it, this.$mod) && !it.getModOptions().isBaseRuleset() && ((CharSequence)it.getName()).length() > 0;
            }
        }), meetsBaseRequirements.allOtherExtensionModNames.2.INSTANCE));
        Iterator iterator2 = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)mod.getModOptions(), UniqueType.ModRequires, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            block5: {
                Unique unique = (Unique)iterator2.next();
                String filter2 = unique.getParams().get(0);
                if (this.modNameFilter(baseRuleset.getName(), filter2)) continue;
                Iterable $this$none$iv = allOtherExtensionModNames2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.modNameFilter(it, filter2)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            return false;
        }
        return true;
    }

    public final boolean meetsAllRequirements(@NotNull Ruleset mod, @NotNull Ruleset baseRuleset, @NotNull Iterable<Ruleset> selectedExtensionMods) {
        boolean bl;
        List otherSelectedExtensionMods;
        Ruleset it;
        block9: {
            Iterator $this$filterNotTo$iv$iv;
            Intrinsics.checkNotNullParameter(mod, "mod");
            Intrinsics.checkNotNullParameter(baseRuleset, "baseRuleset");
            Intrinsics.checkNotNullParameter(selectedExtensionMods, "selectedExtensionMods");
            Iterable<Ruleset> $this$filterNot$iv = selectedExtensionMods;
            boolean $i$f$filterNot = false;
            Iterable<Ruleset> iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                it = (Ruleset)element$iv$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual(it, mod)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            otherSelectedExtensionMods = CollectionsKt.toList((List)destination$iv$iv);
            Iterable $this$any$iv = otherSelectedExtensionMods;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Ruleset it2 = (Ruleset)element$iv;
                    boolean bl3 = false;
                    if (!INSTANCE.isIncompatible(mod, it2)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Iterator iterator3 = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)mod.getModOptions(), UniqueType.ModRequires, null, 2, null).iterator();
        while (iterator3.hasNext()) {
            boolean bl4;
            block10: {
                Unique unique = (Unique)iterator3.next();
                String filter2 = unique.getParams().get(0);
                if (this.modNameFilter(baseRuleset.getName(), filter2)) continue;
                Iterable $this$none$iv = otherSelectedExtensionMods;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl4 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (Ruleset)element$iv;
                        boolean bl5 = false;
                        if (!INSTANCE.modNameFilter(it.getName(), filter2)) continue;
                        bl4 = false;
                        break block10;
                    }
                    bl4 = true;
                }
            }
            if (!bl4) continue;
            return false;
        }
        return true;
    }

    private static final boolean isAudioVisualGuessed$isSubFolderNotEmpty(FileHandle modFolder, String name2) {
        FileHandle file = modFolder.child(name2);
        if (!file.exists()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        FileHandle[] fileHandleArray = file.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "file.list()");
        return !(((Object[])fileHandleArray).length == 0);
    }
}

