/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.validation;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Json;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.BeliefType;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Event;
import com.unciv.models.ruleset.EventChoice;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.models.ruleset.Milestone;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.RuinReward;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.Specialist;
import com.unciv.models.ruleset.Speed;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.CityStateType;
import com.unciv.models.ruleset.nation.Difficulty;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.nation.NationKt;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.TechColumn;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.ruleset.unit.UnitType;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.models.ruleset.validation.RulesetValidator;
import com.unciv.models.ruleset.validation.UniqueValidator;
import com.unciv.models.stats.INamed;
import com.unciv.models.stats.Stats;
import com.unciv.models.tilesets.TileSetCache;
import com.unciv.models.tilesets.TileSetConfig;
import com.unciv.ui.images.AtlasPreview;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.ICivilopediaText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001TB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010 \u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010$\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010)\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010*\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010+\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010/\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u00100\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u00101\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u00102\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u00103\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u00104\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u00105\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u00106\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u00107\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u00108\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u00109\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010:\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010;\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010<\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010=\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010>\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010?\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010@\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010A\u001a\u00020\u00162\u0006\u0010B\u001a\u00020C2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010D\u001a\u00020\u00162\u0006\u0010B\u001a\u00020C2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010E\u001a\u00020\u00162\u0006\u0010F\u001a\u00020\u00072\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00160HH\u0002J\u0010\u0010I\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010J\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010K\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00070M2\u0006\u0010N\u001a\u00020\u0007H\u0002J\u0010\u0010O\u001a\u00020P2\u0006\u0010'\u001a\u00020(H\u0002J\u000e\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00070MH\u0002J\u000e\u0010R\u001a\u00020\u001a2\u0006\u0010S\u001a\u00020\u0007RJ\u0010\u0005\u001a>\u0012\u0004\u0012\u00020\u0007\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\bj\b\u0012\u0004\u0012\u00020\u0007`\t0\u0006j\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\bj\b\u0012\u0004\u0012\u00020\u0007`\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0012\u0010\f\u00a8\u0006U"}, d2={"Lcom/unciv/models/ruleset/validation/RulesetValidator;", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "(Lcom/unciv/models/ruleset/Ruleset;)V", "prereqsHashMap", "Ljava/util/HashMap;", "", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "Lkotlin/collections/HashMap;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "textureNamesCache", "Lcom/unciv/ui/images/AtlasPreview;", "uniqueValidator", "Lcom/unciv/models/ruleset/validation/UniqueValidator;", "vanillaRuleset", "getVanillaRuleset", "vanillaRuleset$delegate", "Lkotlin/Lazy;", "addBeliefErrors", "", "lines", "Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "tryFixUnknownUniques", "", "addBuildingErrorRulesetInvariant", "building", "Lcom/unciv/models/ruleset/Building;", "addBuildingErrors", "addBuildingErrorsRulesetInvariant", "addCityStateTypeErrors", "addDifficultyErrors", "addEraErrors", "addEventErrors", "addImprovementErrors", "addModOptionsErrors", "addNationErrorRulesetInvariant", "nation", "Lcom/unciv/models/ruleset/nation/Nation;", "addNationErrors", "addNationErrorsRulesetInvariant", "addPolicyErrors", "addPromotionErrorRulesetInvariant", "promotion", "Lcom/unciv/models/ruleset/unit/Promotion;", "addPromotionErrors", "addPromotionErrorsRulesetInvariant", "addResourceErrors", "addResourceErrorsRulesetInvariant", "addRuinsErrors", "addSpecialistErrors", "addSpeedErrors", "addTechColumnErrorsRulesetInvariant", "addTechErrors", "addTechErrorsRulesetInvariant", "addTerrainErrors", "addUnitErrorsBaseRuleset", "addUnitErrorsRulesetInvariant", "addUnitTypeErrors", "addVictoryTypeErrors", "checkCivilopediaText", "checkPromotionCircularReferences", "checkTilesetSanity", "checkUnitRulesetInvariant", "unit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "checkUnitRulesetSpecific", "checkUnitType", "type", "reportError", "Lkotlin/Function0;", "getBaseRulesetErrorList", "getErrorList", "getNonBaseRulesetErrorList", "getPrereqTree", "", "technologyName", "getSuggestedColors", "Lcom/unciv/models/ruleset/validation/RulesetValidator$SuggestedColors;", "getTilesetNamesFromAtlases", "uncachedImageExists", "name", "SuggestedColors", "core"})
@SourceDebugExtension(value={"SMAP\nRulesetValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RulesetValidator.kt\ncom/unciv/models/ruleset/validation/RulesetValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,901:1\n1774#2,4:902\n1360#2:910\n1446#2,5:911\n2624#2,3:916\n2624#2,3:919\n1747#2,3:922\n2624#2,3:925\n766#2:932\n857#2,2:933\n2624#2,3:937\n766#2:940\n857#2:941\n1549#2:942\n1620#2,3:943\n858#2:946\n766#2:947\n857#2,2:948\n766#2:950\n857#2,2:951\n766#2:953\n857#2,2:954\n1549#2:956\n1620#2,3:957\n11335#3:906\n11670#3,3:907\n11335#3:928\n11670#3,3:929\n1229#4,2:935\n*S KotlinDebug\n*F\n+ 1 RulesetValidator.kt\ncom/unciv/models/ruleset/validation/RulesetValidator\n*L\n124#1:902,4\n275#1:910\n275#1:911,5\n343#1:916,3\n347#1:919,3\n384#1:922,3\n404#1:925,3\n454#1:932\n454#1:933,2\n545#1:937,3\n676#1:940\n676#1:941\n677#1:942\n677#1:943,3\n676#1:946\n680#1:947\n680#1:948,2\n687#1:950\n687#1:951,2\n856#1:953\n856#1:954,2\n857#1:956\n857#1:957,3\n133#1:906\n133#1:907,3\n445#1:928\n445#1:929,3\n457#1:935,2\n*E\n"})
public final class RulesetValidator {
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final UniqueValidator uniqueValidator;
    private AtlasPreview textureNamesCache;
    @NotNull
    private final HashMap<String, HashSet<String>> prereqsHashMap;
    @NotNull
    private final Lazy vanillaRuleset$delegate;

    public RulesetValidator(@NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        this.ruleset = ruleset2;
        this.uniqueValidator = new UniqueValidator(this.ruleset);
        this.prereqsHashMap = new HashMap();
        this.vanillaRuleset$delegate = LazyKt.lazy(vanillaRuleset.2.INSTANCE);
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    @NotNull
    public final RulesetErrorList getErrorList(boolean tryFixUnknownUniques) {
        if (!this.ruleset.getModOptions().isBaseRuleset()) {
            return this.getNonBaseRulesetErrorList(tryFixUnknownUniques);
        }
        return this.getBaseRulesetErrorList(tryFixUnknownUniques);
    }

    public static /* synthetic */ RulesetErrorList getErrorList$default(RulesetValidator rulesetValidator, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return rulesetValidator.getErrorList(bl);
    }

    private final RulesetErrorList getNonBaseRulesetErrorList(boolean tryFixUnknownUniques) {
        RulesetErrorList lines2 = new RulesetErrorList(this.ruleset);
        this.addModOptionsErrors(lines2, tryFixUnknownUniques);
        this.uniqueValidator.checkUniques(this.ruleset.getGlobalUniques(), lines2, false, tryFixUnknownUniques);
        this.addUnitErrorsRulesetInvariant(lines2, tryFixUnknownUniques);
        this.addTechErrorsRulesetInvariant(lines2, tryFixUnknownUniques);
        this.addTechColumnErrorsRulesetInvariant(lines2);
        this.addBuildingErrorsRulesetInvariant(lines2, tryFixUnknownUniques);
        this.addNationErrorsRulesetInvariant(lines2, tryFixUnknownUniques);
        this.addPromotionErrorsRulesetInvariant(lines2, tryFixUnknownUniques);
        this.addResourceErrorsRulesetInvariant(lines2, tryFixUnknownUniques);
        if (this.textureNamesCache == null) {
            this.textureNamesCache = new AtlasPreview(this.ruleset, lines2);
        }
        this.checkTilesetSanity(lines2);
        this.checkCivilopediaText(lines2);
        return lines2;
    }

    private final RulesetErrorList getBaseRulesetErrorList(boolean tryFixUnknownUniques) {
        this.uniqueValidator.populateFilteringUniqueHashsets();
        RulesetErrorList lines2 = new RulesetErrorList(this.ruleset);
        this.addModOptionsErrors(lines2, tryFixUnknownUniques);
        this.uniqueValidator.checkUniques(this.ruleset.getGlobalUniques(), lines2, true, tryFixUnknownUniques);
        this.addUnitErrorsBaseRuleset(lines2, tryFixUnknownUniques);
        this.addBuildingErrors(lines2, tryFixUnknownUniques);
        this.addSpecialistErrors(lines2);
        this.addResourceErrors(lines2, tryFixUnknownUniques);
        this.addImprovementErrors(lines2, tryFixUnknownUniques);
        this.addTerrainErrors(lines2, tryFixUnknownUniques);
        this.addTechErrors(lines2, tryFixUnknownUniques);
        this.addTechColumnErrorsRulesetInvariant(lines2);
        this.addEraErrors(lines2, tryFixUnknownUniques);
        this.addSpeedErrors(lines2);
        this.addBeliefErrors(lines2, tryFixUnknownUniques);
        this.addNationErrors(lines2, tryFixUnknownUniques);
        this.addPolicyErrors(lines2, tryFixUnknownUniques);
        this.addRuinsErrors(lines2, tryFixUnknownUniques);
        this.addPromotionErrors(lines2, tryFixUnknownUniques);
        this.addUnitTypeErrors(lines2, tryFixUnknownUniques);
        this.addVictoryTypeErrors(lines2);
        this.addDifficultyErrors(lines2);
        this.addEventErrors(lines2, tryFixUnknownUniques);
        this.addCityStateTypeErrors(tryFixUnknownUniques, lines2);
        if (this.textureNamesCache == null) {
            this.textureNamesCache = new AtlasPreview(this.ruleset, lines2);
        }
        if (this.ruleset.getFolderLocation() != null || Intrinsics.areEqual(this.ruleset.getName(), BaseRuleset.Civ_V_GnK.getFullName())) {
            this.checkTilesetSanity(lines2);
        }
        this.checkCivilopediaText(lines2);
        return lines2;
    }

    /*
     * WARNING - void declaration
     */
    private final void addModOptionsErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        List<Unique> mapSelectUniques;
        Object[] it;
        int n;
        this.uniqueValidator.checkUniques(this.ruleset.getModOptions(), lines2, true, tryFixUnknownUniques);
        if (StringsKt.isBlank(this.ruleset.getName())) {
            return;
        }
        UniqueType[] uniqueTypeArray = new UniqueType[]{UniqueType.ModIsAudioVisual, UniqueType.ModIsAudioVisualOnly, UniqueType.ModIsNotAudioVisual};
        Set<UniqueType> audioVisualUniqueTypes = SetsKt.setOf(uniqueTypeArray);
        Iterable $this$count$iv = this.ruleset.getModOptions().getUniqueObjects();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Object[])element$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)audioVisualUniqueTypes, it.getType()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n > 1) {
            RulesetErrorList.add$default(lines2, "A mod should only specify one of the 'can/should/cannot be used as permanent audiovisual mod' options.", null, null, null, 10, null);
        }
        if ((mapSelectUniques = SequencesKt.toList(IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)this.ruleset.getModOptions(), UniqueType.ModMapPreselection, null, 2, null))).size() > 1) {
            RulesetErrorList.add$default(lines2, "Specifying more than one map as preselection makes no sense", RulesetErrorSeverity.WarningOptionsOnly, null, null, 8, null);
        }
        if (!((Collection)mapSelectUniques).isEmpty()) {
            FileHandle mapsFolder = Gdx.files.local("mods").child(this.ruleset.getName()).child("maps");
            if (mapsFolder.exists()) {
                void $this$mapTo$iv$iv;
                FileHandle[] fileHandleArray = mapsFolder.list();
                Intrinsics.checkNotNullExpressionValue(fileHandleArray, "mapsFolder.list()");
                Object[] $this$map$iv = fileHandleArray;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    FileHandle fileHandle = (FileHandle)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it2.name();
                    Intrinsics.checkNotNullExpressionValue(string, "it.name()");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    collection.add(string2);
                }
                List maps = (List)destination$iv$iv;
                for (Unique unique : mapSelectUniques) {
                    String string = unique.getParams().get(0).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    if (maps.contains(string)) continue;
                    RulesetErrorList.add$default(lines2, "Mod names map '" + unique.getParams().get(0) + "' as preselection, which does not exist.", RulesetErrorSeverity.WarningOptionsOnly, null, null, 8, null);
                }
            } else {
                RulesetErrorList.add$default(lines2, "Mod option for map preselection exists but Mod has no 'maps' folder.", RulesetErrorSeverity.WarningOptionsOnly, null, null, 8, null);
            }
        }
        if (!this.ruleset.getModOptions().isBaseRuleset()) {
            return;
        }
        Iterator iterator2 = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)this.ruleset.getModOptions(), UniqueType.ModRequires, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            RulesetErrorList.add$default(lines2, "Mod option '" + unique.getText() + "' is invalid for a base ruleset.", null, null, null, 10, null);
        }
    }

    private final void addCityStateTypeErrors(boolean tryFixUnknownUniques, RulesetErrorList lines2) {
        for (CityStateType cityStateType2 : this.ruleset.getCityStateTypes().values()) {
            Iterator<Unique> iterator2 = SequencesKt.plus(cityStateType2.getAllyBonusUniqueMap().getAllUniques(), cityStateType2.getFriendBonusUniqueMap().getAllUniques()).iterator();
            while (iterator2.hasNext()) {
                Unique unique = iterator2.next();
                RulesetErrorList errors = this.uniqueValidator.checkUnique(unique, tryFixUnknownUniques, null, true);
                lines2.addAll(errors);
            }
        }
    }

    private final void addDifficultyErrors(RulesetErrorList lines2) {
        for (Difficulty difficulty : this.ruleset.getDifficulties().values()) {
            for (String unitName : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)difficulty.getAiCityStateBonusStartingUnits(), (Iterable)difficulty.getAiMajorCivBonusStartingUnits()), (Iterable)difficulty.getPlayerBonusStartingUnits())) {
                if (Intrinsics.areEqual(unitName, "Era Starting Unit") || this.ruleset.getUnits().containsKey(unitName)) continue;
                RulesetErrorList.add$default(lines2, "Difficulty " + difficulty.getName() + " contains starting unit " + unitName + " which does not exist!", null, null, null, 10, null);
            }
        }
    }

    private final void addEventErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Event event : this.ruleset.getEvents().values()) {
            for (EventChoice choice : event.getChoices()) {
                for (Unique unique : CollectionsKt.plus((Collection)choice.getConditionObjects(), (Iterable)choice.getTriggeredUniqueObjects())) {
                    CollectionsKt.addAll((Collection)lines2, this.uniqueValidator.checkUnique(unique, tryFixUnknownUniques, null, true));
                }
            }
        }
    }

    private final void addVictoryTypeErrors(RulesetErrorList lines2) {
        for (Victory victoryType : this.ruleset.getVictories().values()) {
            for (String requiredUnit : victoryType.getRequiredSpaceshipParts()) {
                Map map2 = this.ruleset.getUnits();
                Intrinsics.checkNotNullExpressionValue(requiredUnit, "requiredUnit");
                if (map2.containsKey(requiredUnit)) continue;
                RulesetErrorList.add$default(lines2, "Victory type " + victoryType.getName() + " requires adding the non-existant unit " + requiredUnit + " to the capital to win!", RulesetErrorSeverity.Warning, null, null, 8, null);
            }
            for (Milestone milestone : victoryType.getMilestoneObjects()) {
                if (milestone.getType() != null) continue;
                RulesetErrorList.add$default(lines2, "Victory type " + victoryType.getName() + " has milestone " + milestone.getUniqueDescription() + " that is of an unknown type!", RulesetErrorSeverity.Error, null, null, 8, null);
            }
            for (Victory victory : this.ruleset.getVictories().values()) {
                if (Intrinsics.areEqual(victory.getName(), victoryType.getName()) || !Intrinsics.areEqual(victory.getMilestones(), victoryType.getMilestones())) continue;
                RulesetErrorList.add$default(lines2, "Victory types " + victoryType.getName() + " and " + victory.getName() + " have the same requirements!", RulesetErrorSeverity.Warning, null, null, 8, null);
            }
        }
    }

    private final void addUnitTypeErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (UnitType unitType2 : this.ruleset.getUnitTypes().values()) {
            Intrinsics.checkNotNullExpressionValue(unitType2, "unitType");
            this.uniqueValidator.checkUniques(unitType2, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addPromotionErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Promotion promotion2 : this.ruleset.getUnitPromotions().values()) {
            Intrinsics.checkNotNullExpressionValue(promotion2, "promotion");
            this.addPromotionErrorRulesetInvariant(promotion2, lines2);
            for (String prereq : promotion2.getPrerequisites()) {
                if (this.ruleset.getUnitPromotions().containsKey(prereq)) continue;
                RulesetErrorList.add$default(lines2, promotion2.getName() + " requires promotion " + prereq + " which does not exist!", RulesetErrorSeverity.Warning, promotion2, null, 8, null);
            }
            for (String unitType2 : promotion2.getUnitTypes()) {
                this.checkUnitType(unitType2, new Function0<Unit>(lines2, promotion2, unitType2){
                    final /* synthetic */ RulesetErrorList $lines;
                    final /* synthetic */ Promotion $promotion;
                    final /* synthetic */ String $unitType;
                    {
                        this.$lines = $lines;
                        this.$promotion = $promotion;
                        this.$unitType = $unitType;
                        super(0);
                    }

                    public final void invoke() {
                        RulesetErrorList.add$default(this.$lines, this.$promotion.getName() + " references unit type " + this.$unitType + ", which does not exist!", RulesetErrorSeverity.Warning, this.$promotion, null, 8, null);
                    }
                });
            }
            this.uniqueValidator.checkUniques(promotion2, lines2, true, tryFixUnknownUniques);
        }
        this.checkPromotionCircularReferences(lines2);
    }

    private final void addRuinsErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (RuinReward reward : this.ruleset.getRuinRewards().values()) {
            if (reward.getWeight() < 0) {
                RulesetErrorList.add$default(lines2, reward.getName() + " has a negative weight, which is not allowed!", null, reward, null, 10, null);
            }
            for (String difficulty : reward.getExcludedDifficulties()) {
                if (this.ruleset.getDifficulties().containsKey(difficulty)) continue;
                RulesetErrorList.add$default(lines2, reward.getName() + " references difficulty " + difficulty + ", which does not exist!", null, reward, null, 10, null);
            }
            Intrinsics.checkNotNullExpressionValue(reward, "reward");
            this.uniqueValidator.checkUniques(reward, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addPolicyErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Policy policy2 : this.ruleset.getPolicies().values()) {
            if (policy2.getRequires() != null) {
                ArrayList<String> arrayList = policy2.getRequires();
                Intrinsics.checkNotNull(arrayList);
                for (String string : arrayList) {
                    if (this.ruleset.getPolicies().containsKey(string)) continue;
                    RulesetErrorList.add$default(lines2, policy2.getName() + " requires policy " + string + " which does not exist!", null, policy2, null, 10, null);
                }
            }
            Intrinsics.checkNotNullExpressionValue(policy2, "policy");
            this.uniqueValidator.checkUniques(policy2, lines2, true, tryFixUnknownUniques);
        }
        for (PolicyBranch branch : this.ruleset.getPolicyBranches().values()) {
            if (((Map)this.ruleset.getEras()).containsKey(branch.getEra())) continue;
            RulesetErrorList.add$default(lines2, branch.getName() + " requires era " + branch.getEra() + " which does not exist!", null, branch, null, 10, null);
        }
        Collection<PolicyBranch> collection = this.ruleset.getPolicyBranches().values();
        Intrinsics.checkNotNullExpressionValue(collection, "ruleset.policyBranches.values");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : iterable) {
            PolicyBranch it = (PolicyBranch)element$iv$iv;
            boolean bl = false;
            Collection collection2 = it.getPolicies();
            Intrinsics.checkNotNullExpressionValue(it, "it");
            Iterable list$iv$iv = CollectionsKt.plus(collection2, it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        for (Policy policy2 : (List)destination$iv$iv) {
            if (Intrinsics.areEqual(policy2, this.ruleset.getPolicies().get(policy2.getName()))) continue;
            RulesetErrorList.add$default(lines2, "More than one policy with the name " + policy2.getName() + " exists!", null, policy2, null, 10, null);
        }
    }

    private final void addNationErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Nation nation2 : this.ruleset.getNations().values()) {
            Intrinsics.checkNotNullExpressionValue(nation2, "nation");
            this.addNationErrorRulesetInvariant(nation2, lines2);
            this.uniqueValidator.checkUniques(nation2, lines2, true, tryFixUnknownUniques);
            if (!Intrinsics.areEqual(nation2.getPreferredVictoryType(), "Neutral") && !((Map)this.ruleset.getVictories()).containsKey(nation2.getPreferredVictoryType())) {
                RulesetErrorList.add$default(lines2, nation2.getName() + "'s preferredVictoryType is " + nation2.getPreferredVictoryType() + " which does not exist!", null, nation2, null, 10, null);
            }
            if (nation2.getCityStateType() != null && !((Map)this.ruleset.getCityStateTypes()).containsKey(nation2.getCityStateType())) {
                RulesetErrorList.add$default(lines2, nation2.getName() + " is of city-state type " + nation2.getCityStateType() + " which does not exist!", null, nation2, null, 10, null);
            }
            if (nation2.getFavoredReligion() == null || CollectionsKt.contains((Iterable)this.ruleset.getReligions(), nation2.getFavoredReligion())) continue;
            RulesetErrorList.add$default(lines2, nation2.getName() + " has " + nation2.getFavoredReligion() + " as their favored religion, which does not exist!", null, nation2, null, 10, null);
        }
    }

    private final void addBeliefErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Belief belief2 : this.ruleset.getBeliefs().values()) {
            if (belief2.getType() == BeliefType.Any || belief2.getType() == BeliefType.None) {
                RulesetErrorList.add$default(lines2, belief2.getName() + " type is " + (Object)((Object)belief2.getType()) + ", which is not allowed!", null, belief2, null, 10, null);
            }
            Intrinsics.checkNotNullExpressionValue(belief2, "belief");
            this.uniqueValidator.checkUniques(belief2, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addSpeedErrors(RulesetErrorList lines2) {
        for (Speed speed : this.ruleset.getSpeeds().values()) {
            if (speed.getModifier() < 0.0f) {
                RulesetErrorList.add$default(lines2, "Negative speed modifier for game speed " + speed.getName(), null, speed, null, 10, null);
            }
            if (!speed.getYearsPerTurn().isEmpty()) continue;
            RulesetErrorList.add$default(lines2, "Empty turn increment list for game speed " + speed.getName(), null, speed, null, 10, null);
        }
    }

    private final void addEraErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        if (this.ruleset.getEras().isEmpty()) {
            RulesetErrorList.add$default(lines2, "Eras file is empty! This will likely lead to crashes. Ask the mod maker to update this mod!", null, null, null, 10, null);
        }
        HashSet allDifficultiesStartingUnits = new HashSet();
        for (Difficulty difficulty : this.ruleset.getDifficulties().values()) {
            allDifficultiesStartingUnits.addAll(difficulty.getAiCityStateBonusStartingUnits());
            allDifficultiesStartingUnits.addAll(difficulty.getAiMajorCivBonusStartingUnits());
            allDifficultiesStartingUnits.addAll(difficulty.getPlayerBonusStartingUnits());
        }
        for (Era era2 : this.ruleset.getEras().values()) {
            boolean grantsStartingMilitaryUnit;
            BaseUnit it;
            Iterable $this$none$iv;
            for (String wonder : era2.getStartingObsoleteWonders()) {
                Map map2 = this.ruleset.getBuildings();
                Intrinsics.checkNotNullExpressionValue(wonder, "wonder");
                if (map2.containsKey(wonder)) continue;
                RulesetErrorList.add$default(lines2, "Nonexistent wonder " + wonder + " obsoleted when starting in " + era2.getName() + '!', null, era2, null, 10, null);
            }
            for (String building : era2.getSettlerBuildings()) {
                Map map3 = this.ruleset.getBuildings();
                Intrinsics.checkNotNullExpressionValue(building, "building");
                if (map3.containsKey(building)) continue;
                RulesetErrorList.add$default(lines2, "Nonexistent building " + building + " built by settlers when starting in " + era2.getName(), null, era2, null, 10, null);
            }
            if (!((Map)this.ruleset.getUnits()).containsKey(era2.getStartingSettlerUnit())) {
                boolean bl;
                block20: {
                    Collection<BaseUnit> collection = this.ruleset.getUnits().values();
                    Intrinsics.checkNotNullExpressionValue(collection, "ruleset.units.values");
                    $this$none$iv = collection;
                    boolean $i$f$none = false;
                    if (((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (BaseUnit)element$iv;
                            boolean bl2 = false;
                            if (!it.isCityFounder()) continue;
                            bl = false;
                            break block20;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    RulesetErrorList.add$default(lines2, "Nonexistent unit " + era2.getStartingSettlerUnit() + " marked as starting unit when starting in " + era2.getName(), null, era2, null, 10, null);
                }
            }
            if (era2.getStartingWorkerCount() != 0 && !((Map)this.ruleset.getUnits()).containsKey(era2.getStartingWorkerUnit())) {
                boolean bl;
                block21: {
                    Collection<BaseUnit> collection = this.ruleset.getUnits().values();
                    Intrinsics.checkNotNullExpressionValue(collection, "ruleset.units.values");
                    $this$none$iv = collection;
                    boolean $i$f$none = false;
                    if (((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (BaseUnit)element$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNullExpressionValue(it, "it");
                            if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.BuildImprovements, null, 2, null)) continue;
                            bl = false;
                            break block21;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    RulesetErrorList.add$default(lines2, "Nonexistent unit " + era2.getStartingWorkerUnit() + " marked as starting unit when starting in " + era2.getName(), null, era2, null, 10, null);
                }
            }
            boolean bl = grantsStartingMilitaryUnit = era2.getStartingMilitaryUnitCount() != 0 || allDifficultiesStartingUnits.contains("Era Starting Unit");
            if (grantsStartingMilitaryUnit && !((Map)this.ruleset.getUnits()).containsKey(era2.getStartingMilitaryUnit())) {
                RulesetErrorList.add$default(lines2, "Nonexistent unit " + era2.getStartingMilitaryUnit() + " marked as starting unit when starting in " + era2.getName(), null, era2, null, 10, null);
            }
            if (era2.getResearchAgreementCost() < 0 || era2.getStartingSettlerCount() < 0 || era2.getStartingWorkerCount() < 0 || era2.getStartingMilitaryUnitCount() < 0 || era2.getStartingGold() < 0 || era2.getStartingCulture() < 0) {
                RulesetErrorList.add$default(lines2, "Unexpected negative number found while parsing era " + era2.getName(), null, era2, null, 10, null);
            }
            if (era2.getSettlerPopulation() <= 0) {
                RulesetErrorList.add$default(lines2, "Population in cities from settlers must be strictly positive! Found value " + era2.getSettlerPopulation() + " for era " + era2.getName(), null, era2, null, 10, null);
            }
            if (!((Map)era2.getAllyBonus()).isEmpty()) {
                RulesetErrorList.add$default(lines2, "Era " + era2.getName() + " contains city-state bonuses. City-state bonuses are now defined in CityStateType.json", RulesetErrorSeverity.WarningOptionsOnly, era2, null, 8, null);
            }
            if (!((Map)era2.getFriendBonus()).isEmpty()) {
                RulesetErrorList.add$default(lines2, "Era " + era2.getName() + " contains city-state bonuses. City-state bonuses are now defined in CityStateType.json", RulesetErrorSeverity.WarningOptionsOnly, era2, null, 8, null);
            }
            Intrinsics.checkNotNullExpressionValue(era2, "era");
            this.uniqueValidator.checkUniques(era2, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addTechErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Technology tech : this.ruleset.getTechnologies().values()) {
            for (String prereq : tech.getPrerequisites()) {
                boolean bl;
                block8: {
                    if (!this.ruleset.getTechnologies().containsKey(prereq)) {
                        RulesetErrorList.add$default(lines2, tech.getName() + " requires tech " + prereq + " which does not exist!", null, tech, null, 10, null);
                    }
                    Iterable $this$any$iv = tech.getPrerequisites();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!(!Intrinsics.areEqual(it, prereq) && this.getPrereqTree(it).contains(prereq))) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    RulesetErrorList.add$default(lines2, "No need to add " + prereq + " as a prerequisite of " + tech.getName() + " - it is already implicit from the other prerequisites!", RulesetErrorSeverity.Warning, tech, null, 8, null);
                }
                Intrinsics.checkNotNullExpressionValue(prereq, "prereq");
                if (!this.getPrereqTree(prereq).contains(tech.getName())) continue;
                RulesetErrorList.add$default(lines2, "Techs " + tech.getName() + " and " + prereq + " require each other!", null, tech, null, 10, null);
            }
            if (!((Map)this.ruleset.getEras()).containsKey(tech.era())) {
                RulesetErrorList.add$default(lines2, "Unknown era " + tech.era() + " referenced in column of tech " + tech.getName(), null, tech, null, 10, null);
            }
            Intrinsics.checkNotNullExpressionValue(tech, "tech");
            this.uniqueValidator.checkUniques(tech, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addTerrainErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        boolean bl;
        block12: {
            Collection<Terrain> collection = this.ruleset.getTerrains().values();
            Intrinsics.checkNotNullExpressionValue(collection, "ruleset.terrains.values");
            Iterable $this$none$iv = collection;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Terrain it = (Terrain)element$iv;
                    boolean bl2 = false;
                    if (!(it.getType() == TerrainType.Land && !it.getImpassable())) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        if (bl) {
            RulesetErrorList.add$default(lines2, "No passable land terrains exist!", null, null, null, 10, null);
        }
        for (Terrain terrain2 : this.ruleset.getTerrains().values()) {
            for (String baseTerrainName : terrain2.getOccursOn()) {
                Terrain baseTerrain = this.ruleset.getTerrains().get(baseTerrainName);
                if (baseTerrain == null) {
                    RulesetErrorList.add$default(lines2, terrain2.getName() + " occurs on terrain " + baseTerrainName + " which does not exist!", null, terrain2, null, 10, null);
                    continue;
                }
                if (baseTerrain.getType() != TerrainType.NaturalWonder) continue;
                RulesetErrorList.add$default(lines2, terrain2.getName() + " occurs on natural wonder " + baseTerrainName + ": Unsupported.", RulesetErrorSeverity.WarningOptionsOnly, terrain2, null, 8, null);
            }
            if (terrain2.getType() == TerrainType.NaturalWonder) {
                Terrain baseTerrain;
                if (terrain2.getTurnsInto() == null) {
                    RulesetErrorList.add$default(lines2, "Natural Wonder " + terrain2.getName() + " is missing the turnsInto attribute!", null, terrain2, null, 10, null);
                }
                if ((baseTerrain = (Terrain)((Map)this.ruleset.getTerrains()).get(terrain2.getTurnsInto())) == null) {
                    RulesetErrorList.add$default(lines2, terrain2.getName() + " turns into terrain " + terrain2.getTurnsInto() + " which does not exist!", null, terrain2, null, 10, null);
                } else if (!baseTerrain.getType().isBaseTerrain()) {
                    RulesetErrorList.add$default(lines2, terrain2.getName() + " turns into terrain " + terrain2.getTurnsInto() + " which is not a base terrain!", RulesetErrorSeverity.Warning, terrain2, null, 8, null);
                }
            }
            Intrinsics.checkNotNullExpressionValue(terrain2, "terrain");
            this.uniqueValidator.checkUniques(terrain2, lines2, true, tryFixUnknownUniques);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addImprovementErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (TileImprovement improvement2 : this.ruleset.getTileImprovements().values()) {
            boolean hasPillageUnique;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Unique it;
            Collection destination$iv$iv;
            if (improvement2.getTechRequired() != null) {
                LinkedHashMap<String, Technology> linkedHashMap = this.ruleset.getTechnologies();
                String string = improvement2.getTechRequired();
                Intrinsics.checkNotNull(string);
                if (!linkedHashMap.containsKey(string)) {
                    RulesetErrorList.add$default(lines2, improvement2.getName() + " requires tech " + improvement2.getTechRequired() + " which does not exist!", null, improvement2, null, 10, null);
                }
            }
            if (improvement2.getReplaces() != null && !((Map)this.ruleset.getTileImprovements()).containsKey(improvement2.getReplaces())) {
                RulesetErrorList.add$default(lines2, improvement2.getName() + " replaces " + improvement2.getReplaces() + " which does not exist!", null, improvement2, null, 10, null);
            }
            for (String terrain2 : improvement2.getTerrainsCanBeBuiltOn()) {
                if (this.ruleset.getTerrains().containsKey(terrain2) || Intrinsics.areEqual(terrain2, "Land") || Intrinsics.areEqual(terrain2, "Water")) continue;
                RulesetErrorList.add$default(lines2, improvement2.getName() + " can be built on terrain " + terrain2 + " which does not exist!", null, improvement2, null, 10, null);
            }
            if (improvement2.getTerrainsCanBeBuiltOn().isEmpty()) {
                Intrinsics.checkNotNullExpressionValue(improvement2, "improvement");
                if (!(IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)improvement2, UniqueType.CanOnlyImproveResource, null, 2, null) || IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)improvement2, UniqueType.Unbuildable, null, 2, null) || StringsKt.startsWith$default(improvement2.getName(), "Remove ", false, 2, null))) {
                    void $this$mapTo$iv$iv;
                    RoadStatus[] $this$map$iv = RoadStatus.values();
                    boolean $i$f$map = false;
                    RoadStatus[] roadStatusArray = $this$map$iv;
                    destination$iv$iv = new ArrayList($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void item$iv$iv;
                        void var13_23 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(((RoadStatus)((Object)it)).getRemoveAction());
                    }
                    if (!((List)destination$iv$iv).contains(improvement2.getName()) && !Intrinsics.areEqual(improvement2.getName(), "Cancel improvement order")) {
                        RulesetErrorList.add$default(lines2, improvement2.getName() + " has an empty `terrainsCanBeBuiltOn`, isn't allowed to only improve resources. As such it isn't buildable! Either give this the unique \"Unbuildable\", \"Can only be built to improve a resource\", or add \"Land\", \"Water\" or any other value to `terrainsCanBeBuiltOn`.", RulesetErrorSeverity.Warning, improvement2, null, 8, null);
                    }
                }
            }
            Iterable $i$f$map = improvement2.getUniqueObjects();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Unique)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == UniqueType.PillageYieldRandom || it.getType() == UniqueType.PillageYieldFixed)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            for (Unique unique : (List)destination$iv$iv2) {
                boolean bl;
                block13: {
                    if (!Stats.Companion.isStats(unique.getParams().get(0))) continue;
                    Stats params = Stats.Companion.parse(unique.getParams().get(0));
                    Sequence<Float> $this$any$iv = params.getValues();
                    boolean $i$f$any = false;
                    Iterator<Float> iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        Float element$iv = iterator2.next();
                        float it2 = ((Number)element$iv).floatValue();
                        boolean bl2 = false;
                        if (!(it2 < 0.0f)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
                if (!bl) continue;
                RulesetErrorList.add$default(lines2, improvement2.getName() + " cannot have a negative value for a pillage yield!", RulesetErrorSeverity.Error, improvement2, null, 8, null);
            }
            boolean bl = hasPillageUnique = improvement2.hasUnique(UniqueType.PillageYieldRandom, StateForConditionals.Companion.getIgnoreConditionals()) || improvement2.hasUnique(UniqueType.PillageYieldFixed, StateForConditionals.Companion.getIgnoreConditionals());
            if (hasPillageUnique && improvement2.hasUnique(UniqueType.Unpillagable, StateForConditionals.Companion.getIgnoreConditionals())) {
                RulesetErrorList.add$default(lines2, improvement2.getName() + " has both an `Unpillagable` unique type and a `PillageYieldRandom` or `PillageYieldFixed` unique type!", RulesetErrorSeverity.Warning, improvement2, null, 8, null);
            }
            Intrinsics.checkNotNullExpressionValue(improvement2, "improvement");
            this.uniqueValidator.checkUniques(improvement2, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addResourceErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (TileResource resource2 : this.ruleset.getTileResources().values()) {
            if (resource2.getRevealedBy() != null) {
                LinkedHashMap<String, Technology> linkedHashMap = this.ruleset.getTechnologies();
                String string = resource2.getRevealedBy();
                Intrinsics.checkNotNull(string);
                if (!linkedHashMap.containsKey(string)) {
                    RulesetErrorList.add$default(lines2, resource2.getName() + " revealed by tech " + resource2.getRevealedBy() + " which does not exist!", null, resource2, null, 10, null);
                }
            }
            if (resource2.getImprovement() != null) {
                LinkedHashMap<String, TileImprovement> linkedHashMap = this.ruleset.getTileImprovements();
                String string = resource2.getImprovement();
                Intrinsics.checkNotNull(string);
                if (!linkedHashMap.containsKey(string)) {
                    RulesetErrorList.add$default(lines2, resource2.getName() + " improved by improvement " + resource2.getImprovement() + " which does not exist!", null, resource2, null, 10, null);
                }
            }
            for (String improvement2 : resource2.getImprovedBy()) {
                if (this.ruleset.getTileImprovements().containsKey(improvement2)) continue;
                RulesetErrorList.add$default(lines2, resource2.getName() + " improved by improvement " + improvement2 + " which does not exist!", null, resource2, null, 10, null);
            }
            for (String terrain2 : resource2.getTerrainsCanBeFoundOn()) {
                if (this.ruleset.getTerrains().containsKey(terrain2)) continue;
                RulesetErrorList.add$default(lines2, resource2.getName() + " can be found on terrain " + terrain2 + " which does not exist!", null, resource2, null, 10, null);
            }
            Intrinsics.checkNotNullExpressionValue(resource2, "resource");
            this.uniqueValidator.checkUniques(resource2, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addSpecialistErrors(RulesetErrorList lines2) {
        for (Specialist specialist : this.ruleset.getSpecialists().values()) {
            for (Map.Entry gpp : ((Map)specialist.getGreatPersonPoints()).entrySet()) {
                if (((Map)this.ruleset.getUnits()).containsKey(gpp.getKey())) continue;
                RulesetErrorList.add$default(lines2, "Specialist " + specialist.getName() + " has greatPersonPoints for " + (String)gpp.getKey() + ", which is not a unit in the ruleset!", RulesetErrorSeverity.Warning, null, null, 8, null);
            }
        }
    }

    private final void addBuildingErrors(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Building building : this.ruleset.getBuildings().values()) {
            Intrinsics.checkNotNullExpressionValue(building, "building");
            this.addBuildingErrorRulesetInvariant(building, lines2);
            Iterator<String> iterator2 = building.requiredTechs().iterator();
            while (iterator2.hasNext()) {
                String requiredTech = iterator2.next();
                if (this.ruleset.getTechnologies().containsKey(requiredTech)) continue;
                RulesetErrorList.add$default(lines2, building.getName() + " requires tech " + requiredTech + " which does not exist!", null, building, null, 10, null);
            }
            for (String specialistName : building.getSpecialistSlots().keySet()) {
                if (this.ruleset.getSpecialists().containsKey(specialistName)) continue;
                RulesetErrorList.add$default(lines2, building.getName() + " provides specialist " + specialistName + " which does not exist!", null, building, null, 10, null);
            }
            for (String resource2 : building.getResourceRequirementsPerTurn(StateForConditionals.Companion.getIgnoreConditionals()).keySet()) {
                if (this.ruleset.getTileResources().containsKey(resource2)) continue;
                RulesetErrorList.add$default(lines2, building.getName() + " requires resource " + resource2 + " which does not exist!", null, building, null, 10, null);
            }
            if (building.getReplaces() != null) {
                LinkedHashMap<String, Building> linkedHashMap = this.ruleset.getBuildings();
                String string = building.getReplaces();
                Intrinsics.checkNotNull(string);
                if (!linkedHashMap.containsKey(string)) {
                    RulesetErrorList.add$default(lines2, building.getName() + " replaces " + building.getReplaces() + " which does not exist!", null, building, null, 10, null);
                }
            }
            if (building.getRequiredBuilding() != null) {
                LinkedHashMap<String, Building> linkedHashMap = this.ruleset.getBuildings();
                String string = building.getRequiredBuilding();
                Intrinsics.checkNotNull(string);
                if (!linkedHashMap.containsKey(string)) {
                    RulesetErrorList.add$default(lines2, building.getName() + " requires " + building.getRequiredBuilding() + " which does not exist!", null, building, null, 10, null);
                }
            }
            this.uniqueValidator.checkUniques(building, lines2, true, tryFixUnknownUniques);
        }
    }

    private final void addUnitErrorsRulesetInvariant(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (BaseUnit unit : this.ruleset.getUnits().values()) {
            Intrinsics.checkNotNullExpressionValue(unit, "unit");
            this.checkUnitRulesetInvariant(unit, lines2);
            this.uniqueValidator.checkUniques(unit, lines2, false, tryFixUnknownUniques);
        }
    }

    private final void addUnitErrorsBaseRuleset(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        boolean bl;
        block5: {
            Collection<BaseUnit> collection = this.ruleset.getUnits().values();
            Intrinsics.checkNotNullExpressionValue(collection, "ruleset.units.values");
            Iterable $this$none$iv = collection;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    BaseUnit it = (BaseUnit)element$iv;
                    boolean bl2 = false;
                    if (!it.isCityFounder()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            RulesetErrorList.add$default(lines2, "No city-founding units in ruleset!", null, null, null, 10, null);
        }
        for (BaseUnit unit : this.ruleset.getUnits().values()) {
            Intrinsics.checkNotNullExpressionValue(unit, "unit");
            this.checkUnitRulesetInvariant(unit, lines2);
            this.checkUnitRulesetSpecific(unit, lines2);
            this.uniqueValidator.checkUniques(unit, lines2, false, tryFixUnknownUniques);
        }
    }

    private final void addResourceErrorsRulesetInvariant(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (TileResource resource2 : this.ruleset.getTileResources().values()) {
            Intrinsics.checkNotNullExpressionValue(resource2, "resource");
            this.uniqueValidator.checkUniques(resource2, lines2, false, tryFixUnknownUniques);
        }
    }

    private final void addPromotionErrorsRulesetInvariant(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Promotion promotion2 : this.ruleset.getUnitPromotions().values()) {
            Intrinsics.checkNotNullExpressionValue(promotion2, "promotion");
            this.uniqueValidator.checkUniques(promotion2, lines2, false, tryFixUnknownUniques);
            this.addPromotionErrorRulesetInvariant(promotion2, lines2);
        }
    }

    private final void addPromotionErrorRulesetInvariant(Promotion promotion2, RulesetErrorList lines2) {
        if (promotion2.getRow() < -1) {
            RulesetErrorList.add$default(lines2, "Promotion " + promotion2.getName() + " has invalid row value: " + promotion2.getRow(), null, promotion2, null, 10, null);
        }
        if (promotion2.getColumn() < 0) {
            RulesetErrorList.add$default(lines2, "Promotion " + promotion2.getName() + " has invalid column value: " + promotion2.getColumn(), null, promotion2, null, 10, null);
        }
        if (promotion2.getRow() == -1) {
            return;
        }
        for (Promotion otherPromotion : this.ruleset.getUnitPromotions().values()) {
            if (Intrinsics.areEqual(promotion2, otherPromotion) || promotion2.getColumn() != otherPromotion.getColumn() || promotion2.getRow() != otherPromotion.getRow()) continue;
            RulesetErrorList.add$default(lines2, "Promotions " + promotion2.getName() + " and " + otherPromotion.getName() + " have the same position: " + promotion2.getRow() + '/' + promotion2.getColumn(), null, promotion2, null, 10, null);
        }
    }

    private final void addNationErrorsRulesetInvariant(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Nation nation2 : this.ruleset.getNations().values()) {
            Intrinsics.checkNotNullExpressionValue(nation2, "nation");
            this.addNationErrorRulesetInvariant(nation2, lines2);
            this.uniqueValidator.checkUniques(nation2, lines2, false, tryFixUnknownUniques);
        }
    }

    private final void addNationErrorRulesetInvariant(Nation nation2, RulesetErrorList lines2) {
        double constrastRatio;
        if (nation2.getCities().isEmpty() && !nation2.isSpectator() && !nation2.isBarbarian()) {
            RulesetErrorList.add$default(lines2, nation2.getName() + " can settle cities, but has no city names!", null, nation2, null, 10, null);
        }
        if ((constrastRatio = nation2.getContrastRatio()) < 3.0) {
            SuggestedColors suggestedColors = this.getSuggestedColors(nation2);
            Color newInnerColor = suggestedColors.component1();
            Color newOuterColor = suggestedColors.component2();
            String text2 = nation2.getName() + "'s colors do not contrast enough - it is unreadable!";
            text2 = text2 + "\nSuggested colors: ";
            text2 = text2 + "\n\t\t\"outerColor\": [" + (int)(newOuterColor.r * (float)255) + ", " + (int)(newOuterColor.g * (float)255) + ", " + (int)(newOuterColor.b * (float)255) + "],";
            text2 = text2 + "\n\t\t\"innerColor\": [" + (int)(newInnerColor.r * (float)255) + ", " + (int)(newInnerColor.g * (float)255) + ", " + (int)(newInnerColor.b * (float)255) + "],";
            RulesetErrorList.add$default(lines2, text2, RulesetErrorSeverity.WarningOptionsOnly, nation2, null, 8, null);
        }
    }

    private final SuggestedColors getSuggestedColors(Nation nation2) {
        double innerColorLuminance = NationKt.getRelativeLuminance(nation2.getInnerColor());
        double outerColorLuminance = NationKt.getRelativeLuminance(nation2.getOuterColor());
        Color innerLerpColor = null;
        Color outerLerpColor = null;
        if (innerColorLuminance > outerColorLuminance) {
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            innerLerpColor = color;
            Color color2 = Color.BLACK;
            Intrinsics.checkNotNullExpressionValue(color2, "BLACK");
            outerLerpColor = color2;
        } else {
            Color color = Color.BLACK;
            Intrinsics.checkNotNullExpressionValue(color, "BLACK");
            innerLerpColor = color;
            Color color3 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color3, "WHITE");
            outerLerpColor = color3;
        }
        for (int i = 1; i < 11; ++i) {
            Color newInnerColor = nation2.getInnerColor().cpy().lerp(innerLerpColor, 0.05f * (float)i);
            Color newOuterColor = nation2.getOuterColor().cpy().lerp(outerLerpColor, 0.05f * (float)i);
            Intrinsics.checkNotNullExpressionValue(newInnerColor, "newInnerColor");
            Intrinsics.checkNotNullExpressionValue(newOuterColor, "newOuterColor");
            if (!(NationKt.getContrastRatio(newInnerColor, newOuterColor) > 3.0)) continue;
            return new SuggestedColors(newInnerColor, newOuterColor);
        }
        throw new Exception("Error getting suggested colors for nation " + nation2.getName());
    }

    private final void addBuildingErrorsRulesetInvariant(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Building building : this.ruleset.getBuildings().values()) {
            Intrinsics.checkNotNullExpressionValue(building, "building");
            this.addBuildingErrorRulesetInvariant(building, lines2);
            this.uniqueValidator.checkUniques(building, lines2, false, tryFixUnknownUniques);
        }
    }

    private final void addBuildingErrorRulesetInvariant(Building building, RulesetErrorList lines2) {
        if (SequencesKt.none(building.requiredTechs()) && building.getCost() == -1 && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)building, UniqueType.Unbuildable, null, 2, null)) {
            RulesetErrorList.add$default(lines2, building.getName() + " is buildable and therefore should either have an explicit cost or reference an existing tech!", RulesetErrorSeverity.Warning, building, null, 8, null);
        }
        for (Map.Entry gpp : ((Map)building.getGreatPersonPoints()).entrySet()) {
            if (((Map)this.ruleset.getUnits()).containsKey(gpp.getKey())) continue;
            RulesetErrorList.add$default(lines2, "Building " + building.getName() + " has greatPersonPoints for " + (String)gpp.getKey() + ", which is not a unit in the ruleset!", RulesetErrorSeverity.Warning, building, null, 8, null);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void addTechColumnErrorsRulesetInvariant(RulesetErrorList lines) {
        for (TechColumn techColumn : this.ruleset.getTechColumns()) {
            if (techColumn.getColumnNumber() < 0) {
                RulesetErrorList.add$default(lines, "Tech Column number " + techColumn.getColumnNumber() + " is negative", null, null, null, 10, null);
            }
            v0 = this.ruleset.getBuildings().values();
            Intrinsics.checkNotNullExpressionValue(v0, "ruleset.buildings.values");
            $this$filter$iv = v0;
            $i$f$filter = false;
            var7_8 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Building)element$iv$iv;
                $i$a$-filter-RulesetValidator$addTechColumnErrorsRulesetInvariant$buildingsWithoutAssignedCost$1 = false;
                if (it.getCost() != -1) ** GOTO lbl-1000
                $this$map$iv = techColumn.getTechs();
                $i$f$map = false;
                var16_26 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var21_31 = (Technology)item$iv$iv;
                    var22_32 = destination$iv$iv;
                    $i$a$-map-RulesetValidator$addTechColumnErrorsRulesetInvariant$buildingsWithoutAssignedCost$1$1 = false;
                    var22_32.add(it.getName());
                }
                if (CollectionsKt.contains((List)destination$iv$iv, it.getRequiredTech())) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            buildingsWithoutAssignedCost = CollectionsKt.toList((List)destination$iv$iv);
            $this$filter$iv = buildingsWithoutAssignedCost;
            $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            destination$iv$iv /* !! */  = new ArrayList<E>();
            $i$f$filterTo = false;
            element$iv$iv = $this$filterTo$iv$iv.iterator();
            while (element$iv$iv.hasNext()) {
                element$iv$iv = element$iv$iv.next();
                it = (Building)element$iv$iv;
                $i$a$-filter-RulesetValidator$addTechColumnErrorsRulesetInvariant$nonWondersWithoutAssignedCost$1 = false;
                if (!(it.isAnyWonder() == false)) continue;
                destination$iv$iv /* !! */ .add(element$iv$iv);
            }
            nonWondersWithoutAssignedCost = (List)destination$iv$iv /* !! */ ;
            if (techColumn.getBuildingCost() == -1 && CollectionsKt.any(nonWondersWithoutAssignedCost)) {
                RulesetErrorList.add$default(lines, "Tech Column number " + techColumn.getColumnNumber() + " has no explicit building cost leaving " + CollectionsKt.joinToString$default(nonWondersWithoutAssignedCost, null, null, null, 0, null, null, 63, null) + " unassigned", RulesetErrorSeverity.Warning, null, null, 8, null);
            }
            $this$filter$iv = buildingsWithoutAssignedCost;
            $i$f$filter = false;
            destination$iv$iv /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Building)element$iv$iv;
                $i$a$-filter-RulesetValidator$addTechColumnErrorsRulesetInvariant$wondersWithoutAssignedCost$1 = false;
                if (!it.isAnyWonder()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            wondersWithoutAssignedCost = (List)destination$iv$iv;
            if (techColumn.getWonderCost() != -1 || !CollectionsKt.any(wondersWithoutAssignedCost)) continue;
            RulesetErrorList.add$default(lines, "Tech Column number " + techColumn.getColumnNumber() + " has no explicit wonder cost leaving " + CollectionsKt.joinToString$default(wondersWithoutAssignedCost, null, null, null, 0, null, null, 63, null) + " unassigned", RulesetErrorSeverity.Warning, null, null, 8, null);
        }
        for (Technology tech : this.ruleset.getTechnologies().values()) {
            for (Technology otherTech : this.ruleset.getTechnologies().values()) {
                if (Intrinsics.areEqual(tech, otherTech)) continue;
                v2 = otherTech.getColumn();
                v3 = tech.getColumn();
                if (!Intrinsics.areEqual(v2 != null ? Integer.valueOf(v2.getColumnNumber()) : null, v3 != null ? Integer.valueOf(v3.getColumnNumber()) : null) || otherTech.getRow() != tech.getRow()) continue;
                RulesetErrorList.add$default(lines, tech.getName() + " is in the same row and column as " + otherTech.getName() + '!', null, tech, null, 10, null);
            }
        }
    }

    private final void addTechErrorsRulesetInvariant(RulesetErrorList lines2, boolean tryFixUnknownUniques) {
        for (Technology tech : this.ruleset.getTechnologies().values()) {
            Intrinsics.checkNotNullExpressionValue(tech, "tech");
            this.uniqueValidator.checkUniques(tech, lines2, false, tryFixUnknownUniques);
        }
    }

    private final Set<String> getPrereqTree(String technologyName) {
        if (this.prereqsHashMap.containsKey(technologyName)) {
            HashSet<String> hashSet = this.prereqsHashMap.get(technologyName);
            Intrinsics.checkNotNull(hashSet);
            return hashSet;
        }
        Technology technology2 = this.ruleset.getTechnologies().get(technologyName);
        if (technology2 == null) {
            return SetsKt.emptySet();
        }
        Technology technology3 = technology2;
        HashSet techHashSet = new HashSet();
        CollectionsKt.addAll((Collection)techHashSet, (Iterable)technology3.getPrerequisites());
        ((Map)this.prereqsHashMap).put(technologyName, techHashSet);
        for (String prerequisite : technology3.getPrerequisites()) {
            Collection collection = techHashSet;
            Intrinsics.checkNotNullExpressionValue(prerequisite, "prerequisite");
            CollectionsKt.addAll(collection, (Iterable)this.getPrereqTree(prerequisite));
        }
        return techHashSet;
    }

    private final void checkUnitRulesetInvariant(BaseUnit unit, RulesetErrorList lines2) {
        Iterator<String> iterator2 = unit.getUpgradeUnits(StateForConditionals.Companion.getIgnoreConditionals()).iterator();
        while (iterator2.hasNext()) {
            String upgradesTo = iterator2.next();
            if (!Intrinsics.areEqual(upgradesTo, unit.getName()) && !Intrinsics.areEqual(upgradesTo, unit.getReplaces())) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " upgrades to itself!", null, unit, null, 10, null);
        }
        if (unit.isMilitary() && unit.getStrength() == 0) {
            RulesetErrorList.add$default(lines2, unit.getName() + " is a military unit but has no assigned strength!", null, unit, null, 10, null);
        }
    }

    private final void checkUnitRulesetSpecific(BaseUnit unit, RulesetErrorList lines2) {
        String obsoleteTech;
        Iterator<Object> iterator2 = unit.requiredTechs().iterator();
        while (iterator2.hasNext()) {
            String requiredTech = iterator2.next();
            if (this.ruleset.getTechnologies().containsKey(requiredTech)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " requires tech " + requiredTech + " which does not exist!", null, unit, null, 10, null);
        }
        iterator2 = unit.techsAtWhichNoLongerAvailable().iterator();
        while (iterator2.hasNext()) {
            obsoleteTech = iterator2.next();
            if (this.ruleset.getTechnologies().containsKey(obsoleteTech)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " obsoletes at tech " + obsoleteTech + " which does not exist!", null, unit, null, 10, null);
        }
        iterator2 = unit.getUpgradeUnits(StateForConditionals.Companion.getIgnoreConditionals()).iterator();
        while (iterator2.hasNext()) {
            String upgradesTo = iterator2.next();
            if (this.ruleset.getUnits().containsKey(upgradesTo)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " upgrades to unit " + upgradesTo + " which does not exist!", null, unit, null, 10, null);
        }
        iterator2 = unit.techsAtWhichAutoUpgradeInProduction().iterator();
        while (iterator2.hasNext()) {
            obsoleteTech = iterator2.next();
            Iterator<String> iterator3 = unit.getUpgradeUnits(StateForConditionals.Companion.getIgnoreConditionals()).iterator();
            while (iterator3.hasNext()) {
                BaseUnit upgradedUnit;
                String upgradesTo = iterator3.next();
                if (!this.ruleset.getUnits().containsKey(upgradesTo) || !this.ruleset.getTechnologies().containsKey(obsoleteTech)) continue;
                Intrinsics.checkNotNull(this.ruleset.getUnits().get(upgradesTo));
                Iterator<String> iterator4 = upgradedUnit.requiredTechs().iterator();
                while (iterator4.hasNext()) {
                    String requiredTech = iterator4.next();
                    if (Intrinsics.areEqual(requiredTech, obsoleteTech) || this.getPrereqTree(obsoleteTech).contains(requiredTech)) continue;
                    RulesetErrorList.add$default(lines2, unit.getName() + " is supposed to automatically upgrade at tech " + obsoleteTech + ", and therefore " + requiredTech + " for its upgrade " + upgradedUnit.getName() + " may not yet be researched!", RulesetErrorSeverity.Warning, unit, null, 8, null);
                }
            }
        }
        for (String resource2 : unit.getResourceRequirementsPerTurn(StateForConditionals.Companion.getIgnoreConditionals()).keySet()) {
            if (this.ruleset.getTileResources().containsKey(resource2)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " requires resource " + resource2 + " which does not exist!", null, unit, null, 10, null);
        }
        if (unit.getReplaces() != null) {
            LinkedHashMap<String, BaseUnit> linkedHashMap = this.ruleset.getUnits();
            String string = unit.getReplaces();
            Intrinsics.checkNotNull(string);
            if (!linkedHashMap.containsKey(string)) {
                RulesetErrorList.add$default(lines2, unit.getName() + " replaces " + unit.getReplaces() + " which does not exist!", null, unit, null, 10, null);
            }
        }
        for (String promotion2 : unit.getPromotions()) {
            if (this.ruleset.getUnitPromotions().containsKey(promotion2)) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " contains promotion " + promotion2 + " which does not exist!", null, unit, null, 10, null);
        }
        this.checkUnitType(unit.getUnitType(), new Function0<Unit>(lines2, unit){
            final /* synthetic */ RulesetErrorList $lines;
            final /* synthetic */ BaseUnit $unit;
            {
                this.$lines = $lines;
                this.$unit = $unit;
                super(0);
            }

            public final void invoke() {
                RulesetErrorList.add$default(this.$lines, this.$unit.getName() + " is of type " + this.$unit.getUnitType() + ", which does not exist!", null, this.$unit, null, 10, null);
            }
        });
        iterator2 = unit.getMatchingUniques(UniqueType.ConstructImprovementInstantly, StateForConditionals.Companion.getIgnoreConditionals()).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            String improvementName = unique.getParams().get(0);
            if (this.ruleset.getTileImprovements().get(improvementName) == null) continue;
            TileImprovement tileImprovement = this.ruleset.getTileImprovements().get(improvementName);
            Intrinsics.checkNotNull(tileImprovement, "null cannot be cast to non-null type com.unciv.models.stats.Stats");
            if (!((Stats)tileImprovement).isEmpty() || !unit.isCivilian() || unit.isGreatPersonOfType("War")) continue;
            RulesetErrorList.add$default(lines2, unit.getName() + " can place improvement " + improvementName + " which has no stats, preventing unit automation!", RulesetErrorSeverity.WarningOptionsOnly, unit, null, 8, null);
        }
    }

    private final Ruleset getVanillaRuleset() {
        Lazy lazy = this.vanillaRuleset$delegate;
        return (Ruleset)lazy.getValue();
    }

    private final void checkUnitType(String type2, Function0<Unit> reportError) {
        if (this.ruleset.getUnitTypes().containsKey(type2)) {
            return;
        }
        if (this.ruleset.getUnitTypes().isEmpty() && this.getVanillaRuleset().getUnitTypes().containsKey(type2)) {
            return;
        }
        reportError.invoke();
    }

    private final void checkTilesetSanity(RulesetErrorList lines2) {
        Set<String> atlasOnlyTilesets;
        Set<String> atlasTilesets;
        Set configOnlyTilesets;
        FileHandle tilesetConfigFolder;
        FileHandle fileHandle;
        if (this.ruleset.getFolderLocation() == null) {
            Package package_ = this.getClass().getPackage();
            if ((package_ != null ? package_.getSpecificationVersion() : null) != null) {
                return;
            }
        }
        if ((fileHandle = this.ruleset.getFolderLocation()) == null) {
            fileHandle = Gdx.files.internal("");
        }
        if (!(tilesetConfigFolder = fileHandle.child("jsons/TileSets")).exists()) {
            return;
        }
        Set configTilesets = new LinkedHashSet();
        Set allFallbacks = new LinkedHashSet();
        FileHandle[] folderContent = tilesetConfigFolder.list();
        boolean folderContentBad = false;
        Intrinsics.checkNotNullExpressionValue(folderContent, "folderContent");
        for (FileHandle file : folderContent) {
            if (file.isDirectory() || !Intrinsics.areEqual(file.extension(), "json")) {
                folderContentBad = true;
                continue;
            }
            try {
                Json json = UncivJsonKt.json();
                Intrinsics.checkNotNullExpressionValue(file, "file");
                TileSetConfig config2 = UncivJsonKt.fromJsonFile(json, TileSetConfig.class, file);
                Collection collection = configTilesets;
                String string = file.nameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue(string, "file.nameWithoutExtension()");
                collection.add(StringsKt.removeSuffix(string, (CharSequence)"Config"));
                String string2 = config2.getFallbackTileSet();
                boolean bl = string2 != null ? ((CharSequence)string2).length() > 0 : false;
                if (!bl) continue;
                String string3 = config2.getFallbackTileSet();
                Intrinsics.checkNotNull(string3);
                allFallbacks.add(string3);
            }
            catch (Exception ex) {
                Throwable throwable = ex.getCause();
                RulesetErrorList.add$default(lines2, "Tileset config '" + file.name() + "' cannot be loaded (" + (throwable != null ? throwable.getMessage() : null) + ')', RulesetErrorSeverity.Warning, null, null, 8, null);
            }
        }
        if (folderContentBad) {
            RulesetErrorList.add$default(lines2, "The Mod tileset config folder contains non-json files or subdirectories", RulesetErrorSeverity.Warning, null, null, 8, null);
        }
        if (configTilesets.isEmpty()) {
            RulesetErrorList.add$default(lines2, "The Mod tileset config folder contains no json files", RulesetErrorSeverity.Warning, null, null, 8, null);
        }
        if (!((Collection)(configOnlyTilesets = SetsKt.minus(configTilesets, (Iterable)(atlasTilesets = this.getTilesetNamesFromAtlases())))).isEmpty()) {
            RulesetErrorList.add$default(lines2, "Mod has no graphics for configured tilesets: " + CollectionsKt.joinToString$default(configOnlyTilesets, null, null, null, 0, null, null, 63, null), RulesetErrorSeverity.Warning, null, null, 8, null);
        }
        if (!((Collection)(atlasOnlyTilesets = SetsKt.minus(atlasTilesets, configTilesets))).isEmpty()) {
            RulesetErrorList.add$default(lines2, "Mod has no configuration for tileset graphics: " + CollectionsKt.joinToString$default(atlasOnlyTilesets, null, null, null, 0, null, null, 63, null), RulesetErrorSeverity.Warning, null, null, 8, null);
        }
        Set<String> set2 = TileSetCache.INSTANCE.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "TileSetCache.keys");
        Set<String> unknownFallbacks = SetsKt.minus(SetsKt.minus(allFallbacks, (Iterable)set2), "FantasyHex");
        if (!((Collection)unknownFallbacks).isEmpty()) {
            RulesetErrorList.add$default(lines2, "Fallback tileset invalid: " + CollectionsKt.joinToString$default(unknownFallbacks, null, null, null, 0, null, null, 63, null), RulesetErrorSeverity.Warning, null, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getTilesetNamesFromAtlases() {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        AtlasPreview atlasPreview = this.textureNamesCache;
        if (atlasPreview == null) {
            Intrinsics.throwUninitializedPropertyAccessException("textureNamesCache");
            atlasPreview = null;
        }
        Iterable $this$filter$iv = atlasPreview;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.startsWith$default(it, "TileSets/", false, 2, null) && !StringsKt.contains$default((CharSequence)it, "/Units/", false, 2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"/"};
            collection.add((String)StringsKt.split$default((CharSequence)it, stringArray, false, 0, 6, null).get(1));
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    private final void checkPromotionCircularReferences(RulesetErrorList lines2) {
        for (Promotion promotion2 : this.ruleset.getUnitPromotions().values()) {
            if (promotion2.getPrerequisites().isEmpty()) continue;
            HashSet<Promotion> hashSet = new HashSet<Promotion>();
            Intrinsics.checkNotNullExpressionValue(promotion2, "promotion");
            RulesetValidator.checkPromotionCircularReferences$recursiveCheck(lines2, this, hashSet, promotion2, 0);
        }
    }

    private final void checkCivilopediaText(RulesetErrorList lines2) {
        Iterator<ICivilopediaText> iterator2 = this.ruleset.allICivilopediaText().iterator();
        while (iterator2.hasNext()) {
            ICivilopediaText sourceObject = iterator2.next();
            Iterator<FormattedLine> iterator3 = sourceObject.getCivilopediaText().iterator();
            int n = 0;
            while (iterator3.hasNext()) {
                int index = n++;
                FormattedLine line = iterator3.next();
                Iterator<String> iterator4 = line.unsupportedReasons(this).iterator();
                while (iterator4.hasNext()) {
                    String string;
                    String string2;
                    String error2 = iterator4.next();
                    INamed iNamed = sourceObject instanceof INamed ? (INamed)((Object)sourceObject) : null;
                    String nameText = iNamed != null && (string2 = iNamed.getName()) != null && (string = string2 + "'s ") != null ? string : "";
                    String text2 = '(' + sourceObject.getClass().getSimpleName() + ") " + nameText + "civilopediaText line " + (index + 1) + ": " + error2;
                    lines2.add(text2, RulesetErrorSeverity.WarningOptionsOnly, sourceObject instanceof IRulesetObject ? (IRulesetObject)sourceObject : null, null);
                }
            }
        }
    }

    public final boolean uncachedImageExists(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        if (this.ruleset.getFolderLocation() == null) {
            return false;
        }
        AtlasPreview atlasPreview = this.textureNamesCache;
        if (atlasPreview == null) {
            Intrinsics.throwUninitializedPropertyAccessException("textureNamesCache");
            atlasPreview = null;
        }
        return atlasPreview.imageExists(name2);
    }

    private static final void checkPromotionCircularReferences$recursiveCheck(RulesetErrorList $lines, RulesetValidator this$0, HashSet<Promotion> history, Promotion promotion2, int level) {
        if (history.contains(promotion2)) {
            RulesetErrorList.add$default($lines, "Circular Reference in Promotions: " + CollectionsKt.joinToString$default(history, "\u2192", null, null, 0, null, checkPromotionCircularReferences.recursiveCheck.1.INSTANCE, 30, null) + '\u2192' + promotion2.getName(), RulesetErrorSeverity.Warning, promotion2, null, 8, null);
            return;
        }
        if (level > 99) {
            return;
        }
        history.add((Promotion)promotion2);
        for (String prerequisiteName : promotion2.getPrerequisites()) {
            Promotion prerequisite;
            if (this$0.ruleset.getUnitPromotions().get(prerequisiteName) == null) continue;
            HashSet linkedSetToPass = promotion2.getPrerequisites().size() == 1 ? history : (HashSet)CollectionsKt.toCollection(history, (Collection)new HashSet());
            RulesetValidator.checkPromotionCircularReferences$recursiveCheck($lines, this$0, linkedSetToPass, prerequisite, level + 1);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/unciv/models/ruleset/validation/RulesetValidator$SuggestedColors;", "", "innerColor", "Lcom/badlogic/gdx/graphics/Color;", "outerColor", "(Lcom/badlogic/gdx/graphics/Color;Lcom/badlogic/gdx/graphics/Color;)V", "getInnerColor", "()Lcom/badlogic/gdx/graphics/Color;", "getOuterColor", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    public static final class SuggestedColors {
        @NotNull
        private final Color innerColor;
        @NotNull
        private final Color outerColor;

        public SuggestedColors(@NotNull Color innerColor, @NotNull Color outerColor) {
            Intrinsics.checkNotNullParameter(innerColor, "innerColor");
            Intrinsics.checkNotNullParameter(outerColor, "outerColor");
            this.innerColor = innerColor;
            this.outerColor = outerColor;
        }

        @NotNull
        public final Color getInnerColor() {
            return this.innerColor;
        }

        @NotNull
        public final Color getOuterColor() {
            return this.outerColor;
        }

        @NotNull
        public final Color component1() {
            return this.innerColor;
        }

        @NotNull
        public final Color component2() {
            return this.outerColor;
        }

        @NotNull
        public final SuggestedColors copy(@NotNull Color innerColor, @NotNull Color outerColor) {
            Intrinsics.checkNotNullParameter(innerColor, "innerColor");
            Intrinsics.checkNotNullParameter(outerColor, "outerColor");
            return new SuggestedColors(innerColor, outerColor);
        }

        public static /* synthetic */ SuggestedColors copy$default(SuggestedColors suggestedColors, Color color, Color color2, int n, Object object) {
            if ((n & 1) != 0) {
                color = suggestedColors.innerColor;
            }
            if ((n & 2) != 0) {
                color2 = suggestedColors.outerColor;
            }
            return suggestedColors.copy(color, color2);
        }

        @NotNull
        public String toString() {
            return "SuggestedColors(innerColor=" + this.innerColor + ", outerColor=" + this.outerColor + ')';
        }

        public int hashCode() {
            int result2 = this.innerColor.hashCode();
            result2 = result2 * 31 + this.outerColor.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SuggestedColors)) {
                return false;
            }
            SuggestedColors suggestedColors = (SuggestedColors)other;
            if (!Intrinsics.areEqual(this.innerColor, suggestedColors.innerColor)) {
                return false;
            }
            return Intrinsics.areEqual(this.outerColor, suggestedColors.outerColor);
        }
    }
}

