/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.validation;

import com.unciv.Constants;
import com.unciv.logic.map.mapunit.MapUnitCache;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueComplianceError;
import com.unciv.models.ruleset.unique.UniqueFlag;
import com.unciv.models.ruleset.unique.UniqueParameterType;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.models.ruleset.validation.TextSimilarityKt;
import com.unciv.models.ruleset.validation.UniqueValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 52\u00020\u0001:\u00015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u001b2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0002J*\u0010$\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020!H\u0002J(\u0010'\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020#2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#J&\u0010)\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020#J*\u0010+\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020#2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010\u001f\u001a\u00020\u001bH\u0002J\u001a\u0010/\u001a\u0004\u0018\u00010\r2\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\u0007H\u0002J\u0010\u00102\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u001bH\u0002J\u0006\u00103\u001a\u00020\u0019J\"\u00104\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001b2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rj\u0010\n\u001a^\u0012\u0004\u0012\u00020\f\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bj\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\r`\u000e0\u000bj.\u0012\u0004\u0012\u00020\f\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bj\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\r`\u000e`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00066\u00b2\u0006\n\u0010\u001e\u001a\u00020\u0007X\u008a\u0084\u0002"}, d2={"Lcom/unciv/models/ruleset/validation/UniqueValidator;", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "(Lcom/unciv/models/ruleset/Ruleset;)V", "allNonTypedUniques", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "allUniqueParameters", "paramTypeErrorSeverityCache", "Ljava/util/HashMap;", "Lcom/unciv/models/ruleset/unique/UniqueParameterType;", "Lcom/unciv/models/ruleset/unique/UniqueType$UniqueParameterErrorSeverity;", "Lkotlin/collections/HashMap;", "resourceConditionals", "", "Lcom/unciv/models/ruleset/unique/UniqueType;", "getResourceConditionals", "()Ljava/util/Set;", "resourceUniques", "getResourceUniques", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "addConditionalErrors", "", "conditional", "Lcom/unciv/models/ruleset/unique/Unique;", "rulesetErrors", "Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "prefix", "unique", "uniqueContainer", "Lcom/unciv/models/ruleset/unique/IHasUniques;", "reportRulesetSpecificErrors", "", "addDeprecationAnnotationErrors", "addToHashsets", "uniqueHolder", "checkUnique", "tryFixUnknownUniques", "checkUniques", "lines", "checkUntypedUnique", "getComplianceErrors", "", "Lcom/unciv/models/ruleset/unique/UniqueComplianceError;", "getParamTypeErrorSeverityCached", "uniqueParameterType", "param", "isFilteringUniqueAllowed", "populateFilteringUniqueHashsets", "tryFixUnknownUnique", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nUniqueValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UniqueValidator.kt\ncom/unciv/models/ruleset/validation/UniqueValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,326:1\n1855#2,2:327\n1855#2,2:329\n1855#2,2:331\n1855#2,2:333\n1855#2,2:335\n1855#2,2:337\n1855#2,2:339\n1855#2,2:341\n1747#2,3:343\n2624#2,3:349\n2624#2,3:352\n1549#2:356\n1620#2,3:357\n1747#2,3:360\n2333#2,14:363\n766#2:383\n857#2,2:384\n3792#3:346\n4307#3,2:347\n3792#3:380\n4307#3,2:381\n1#4:355\n1099#5,3:377\n*S KotlinDebug\n*F\n+ 1 UniqueValidator.kt\ncom/unciv/models/ruleset/validation/UniqueValidator\n*L\n35#1:327,2\n36#1:329,2\n37#1:331,2\n38#1:333,2\n39#1:335,2\n40#1:337,2\n41#1:339,2\n42#1:341,2\n94#1:343,3\n155#1:349,3\n163#1:352,3\n231#1:356\n231#1:357,3\n232#1:360,3\n237#1:363,14\n293#1:383\n293#1:384,2\n140#1:346\n140#1:347,2\n286#1:380\n286#1:381,2\n258#1:377,3\n*E\n"})
public final class UniqueValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final HashSet<String> allNonTypedUniques;
    @NotNull
    private final HashSet<String> allUniqueParameters;
    @NotNull
    private final Set<UniqueType> resourceUniques;
    @NotNull
    private final Set<UniqueType> resourceConditionals;
    @NotNull
    private final HashMap<UniqueParameterType, HashMap<String, UniqueType.UniqueParameterErrorSeverity>> paramTypeErrorSeverityCache;

    public UniqueValidator(@NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        this.ruleset = ruleset2;
        this.allNonTypedUniques = new HashSet();
        this.allUniqueParameters = new HashSet();
        UniqueType[] uniqueTypeArray = new UniqueType[]{UniqueType.ProvidesResources, UniqueType.ConsumesResources, UniqueType.DoubleResourceProduced, UniqueType.StrategicResourcesIncrease};
        this.resourceUniques = SetsKt.setOf(uniqueTypeArray);
        uniqueTypeArray = new UniqueType[]{UniqueType.ConditionalWithResource, UniqueType.ConditionalWithoutResource, UniqueType.ConditionalWhenBetweenStatResource, UniqueType.ConditionalWhenAboveAmountStatResource, UniqueType.ConditionalWhenBelowAmountStatResource, UniqueType.ConditionalWhenAboveAmountStatResourceSpeed, UniqueType.ConditionalWhenBelowAmountStatResourceSpeed, UniqueType.ConditionalWhenBetweenStatResourceSpeed};
        this.resourceConditionals = SetsKt.setOf(uniqueTypeArray);
        this.paramTypeErrorSeverityCache = new HashMap();
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    private final void addToHashsets(IHasUniques uniqueHolder) {
        for (Unique unique : uniqueHolder.getUniqueObjects()) {
            if (unique.getType() == null) {
                this.allNonTypedUniques.add(unique.getText());
                continue;
            }
            CollectionsKt.addAll((Collection)this.allUniqueParameters, SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)unique.getAllParams()), addToHashsets.1.INSTANCE));
        }
    }

    public final void populateFilteringUniqueHashsets() {
        IRulesetObject it;
        this.addToHashsets(this.ruleset.getGlobalUniques());
        Collection<BaseUnit> collection = this.ruleset.getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection, "ruleset.units.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (BaseUnit)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.addToHashsets(it);
        }
        Collection<Building> collection2 = this.ruleset.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "ruleset.buildings.values");
        $this$forEach$iv = collection2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Building)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.addToHashsets(it);
        }
        Collection<Promotion> collection3 = this.ruleset.getUnitPromotions().values();
        Intrinsics.checkNotNullExpressionValue(collection3, "ruleset.unitPromotions.values");
        $this$forEach$iv = collection3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Promotion)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.addToHashsets(it);
        }
        Collection<Technology> collection4 = this.ruleset.getTechnologies().values();
        Intrinsics.checkNotNullExpressionValue(collection4, "ruleset.technologies.values");
        $this$forEach$iv = collection4;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Technology)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.addToHashsets(it);
        }
        Collection<Nation> collection5 = this.ruleset.getNations().values();
        Intrinsics.checkNotNullExpressionValue(collection5, "ruleset.nations.values");
        $this$forEach$iv = collection5;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Nation)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.addToHashsets(it);
        }
        Collection<TileResource> collection6 = this.ruleset.getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(collection6, "ruleset.tileResources.values");
        $this$forEach$iv = collection6;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TileResource)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.addToHashsets(it);
        }
        Collection<Terrain> collection7 = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection7, "ruleset.terrains.values");
        $this$forEach$iv = collection7;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Terrain)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.addToHashsets(it);
        }
        Collection<TileImprovement> collection8 = this.ruleset.getTileImprovements().values();
        Intrinsics.checkNotNullExpressionValue(collection8, "ruleset.tileImprovements.values");
        $this$forEach$iv = collection8;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TileImprovement)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.addToHashsets(it);
        }
    }

    public final void checkUniques(@NotNull IHasUniques uniqueContainer, @NotNull RulesetErrorList lines2, boolean reportRulesetSpecificErrors, boolean tryFixUnknownUniques) {
        Intrinsics.checkNotNullParameter(uniqueContainer, "uniqueContainer");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        for (Unique unique : uniqueContainer.getUniqueObjects()) {
            RulesetErrorList errors = this.checkUnique(unique, tryFixUnknownUniques, uniqueContainer, reportRulesetSpecificErrors);
            lines2.addAll(errors);
        }
    }

    @NotNull
    public final RulesetErrorList checkUnique(@NotNull Unique unique, boolean tryFixUnknownUniques, @Nullable IHasUniques uniqueContainer, boolean reportRulesetSpecificErrors) {
        Intrinsics.checkNotNullParameter(unique, "unique");
        Lazy<String> prefix$delegate = LazyKt.lazy((Function0)new Function0<String>(uniqueContainer, unique){
            final /* synthetic */ IHasUniques $uniqueContainer;
            final /* synthetic */ Unique $unique;
            {
                this.$uniqueContainer = $uniqueContainer;
                this.$unique = $unique;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return UniqueValidator.Companion.getUniqueContainerPrefix$core(this.$uniqueContainer) + '\"' + this.$unique.getText() + '\"';
            }
        });
        if (unique.getType() == null) {
            return this.checkUntypedUnique(unique, tryFixUnknownUniques, uniqueContainer, UniqueValidator.checkUnique$lambda$8(prefix$delegate));
        }
        RulesetErrorList rulesetErrors = new RulesetErrorList(this.ruleset);
        if (uniqueContainer != null && !unique.getType().canAcceptUniqueTarget(uniqueContainer.getUniqueTarget())) {
            rulesetErrors.add(UniqueValidator.checkUnique$lambda$8(prefix$delegate) + " is not allowed on its target type", RulesetErrorSeverity.Warning, uniqueContainer, unique);
        }
        List<UniqueComplianceError> typeComplianceErrors = this.getComplianceErrors(unique);
        for (UniqueComplianceError complianceError : typeComplianceErrors) {
            if (!reportRulesetSpecificErrors && complianceError.getErrorSeverity() == UniqueType.UniqueParameterErrorSeverity.RulesetSpecific) continue;
            rulesetErrors.add(UniqueValidator.checkUnique$lambda$8(prefix$delegate) + " contains parameter " + complianceError.getParameterName() + ", which does not fit parameter type " + CollectionsKt.joinToString$default(complianceError.getAcceptableParameterTypes(), " or ", null, null, 0, null, checkUnique.1.INSTANCE, 30, null) + " !", complianceError.getErrorSeverity().getRulesetErrorSeverity(), uniqueContainer, unique);
        }
        for (Unique conditional : unique.getConditionals()) {
            this.addConditionalErrors(conditional, rulesetErrors, UniqueValidator.checkUnique$lambda$8(prefix$delegate), unique, uniqueContainer, reportRulesetSpecificErrors);
        }
        if (MapUnitCache.Companion.getUnitMovementUniques().contains((Object)unique.getType())) {
            boolean bl;
            block10: {
                Iterable $this$any$iv = unique.getConditionals();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Unique it = (Unique)element$iv;
                        boolean bl2 = false;
                        if (!(it.getType() != UniqueType.ConditionalOurUnit || !Constants.INSTANCE.getAll().contains(it.getParams().get(0)))) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) {
                rulesetErrors.add(UniqueValidator.checkUnique$lambda$8(prefix$delegate) + " contains a conditional on a unit movement unique. Due to performance considerations, this unique is cached on the unit, and the conditional may not always limit the unique correctly.", RulesetErrorSeverity.OK, uniqueContainer, unique);
            }
        }
        if (reportRulesetSpecificErrors) {
            this.addDeprecationAnnotationErrors(unique, UniqueValidator.checkUnique$lambda$8(prefix$delegate), rulesetErrors, uniqueContainer);
        }
        return rulesetErrors;
    }

    @NotNull
    public final Set<UniqueType> getResourceUniques() {
        return this.resourceUniques;
    }

    @NotNull
    public final Set<UniqueType> getResourceConditionals() {
        return this.resourceConditionals;
    }

    /*
     * WARNING - void declaration
     */
    private final void addConditionalErrors(Unique conditional, RulesetErrorList rulesetErrors, String prefix2, Unique unique, IHasUniques uniqueContainer, boolean reportRulesetSpecificErrors) {
        UniqueTarget it;
        boolean bl;
        boolean $i$f$none;
        Iterable $this$none$iv;
        block18: {
            if (unique.hasFlag(UniqueFlag.NoConditionals)) {
                rulesetErrors.add(prefix2 + " contains the conditional \"" + conditional.getText() + "\", but the unique does not accept conditionals!", RulesetErrorSeverity.Error, uniqueContainer, unique);
                return;
            }
            if (conditional.getType() == null) {
                void $this$filterTo$iv$iv;
                String text2 = prefix2 + " contains the conditional \"" + conditional.getText() + "\", which is of an unknown type!";
                UniqueType[] $this$filter$iv = UniqueType.values();
                boolean $i$f$filter = false;
                UniqueType[] uniqueTypeArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it2 = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl2 = false;
                    boolean bl3 = TextSimilarityKt.getRelativeTextDistance(it2.getPlaceholderText(), conditional.getPlaceholderText()) <= RulesetCache.INSTANCE.getUniqueMisspellingThreshold();
                    if (!bl3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List similarConditionals = (List)destination$iv$iv;
                if (!((Collection)similarConditionals).isEmpty()) {
                    text2 = text2 + " May be a misspelling of \"" + CollectionsKt.joinToString$default(similarConditionals, "\", or \"", null, null, 0, null, addConditionalErrors.1.INSTANCE, 30, null) + '\"';
                }
                rulesetErrors.add(text2, RulesetErrorSeverity.Warning, uniqueContainer, unique);
                return;
            }
            $this$none$iv = conditional.getType().getTargetTypes();
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (UniqueTarget)((Object)element$iv);
                    boolean bl4 = false;
                    if (!(it.getModifierType() != UniqueTarget.ModifierType.None)) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        if (bl) {
            rulesetErrors.add(prefix2 + " contains the conditional \"" + conditional.getText() + "\", which is a Unique type not allowed as conditional or trigger.", RulesetErrorSeverity.Warning, uniqueContainer, unique);
        }
        if (conditional.getType().getTargetTypes().contains((Object)UniqueTarget.UnitActionModifier)) {
            boolean bl5;
            block19: {
                UniqueType uniqueType = unique.getType();
                Intrinsics.checkNotNull((Object)uniqueType);
                $this$none$iv = uniqueType.getTargetTypes();
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl5 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (UniqueTarget)((Object)element$iv);
                        boolean bl6 = false;
                        if (!UniqueTarget.UnitAction.canAcceptUniqueTarget(it)) continue;
                        bl5 = false;
                        break block19;
                    }
                    bl5 = true;
                }
            }
            if (bl5) {
                rulesetErrors.add(prefix2 + " contains the conditional \"" + conditional.getText() + "\", which as a UnitActionModifier is only allowed on UnitAction uniques.", RulesetErrorSeverity.Warning, uniqueContainer, unique);
            }
        }
        if (CollectionsKt.contains((Iterable)this.resourceUniques, unique.getType()) && this.resourceConditionals.contains((Object)conditional.getType())) {
            boolean bl7;
            TileResource tileResource = this.ruleset.getTileResources().get(CollectionsKt.last(conditional.getParams()));
            if (tileResource != null) {
                TileResource it3 = tileResource;
                boolean bl8 = false;
                bl7 = IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it3, UniqueType.CityResource, null, 2, null);
            } else {
                bl7 = false;
            }
            if (bl7) {
                rulesetErrors.add(prefix2 + " contains the conditional \"" + conditional.getText() + "\", which references a citywide resource. This is not a valid conditional for a resource uniques, as it causes a recursive evaluation loop.", RulesetErrorSeverity.Error, uniqueContainer, unique);
            }
        }
        List<UniqueComplianceError> conditionalComplianceErrors = this.getComplianceErrors(conditional);
        for (UniqueComplianceError complianceError : conditionalComplianceErrors) {
            if (!reportRulesetSpecificErrors && complianceError.getErrorSeverity() == UniqueType.UniqueParameterErrorSeverity.RulesetSpecific) continue;
            rulesetErrors.add(prefix2 + " contains conditional \"" + conditional.getText() + "\". This contains the parameter " + complianceError.getParameterName() + " which does not fit parameter type " + CollectionsKt.joinToString$default(complianceError.getAcceptableParameterTypes(), " or ", null, null, 0, null, addConditionalErrors.5.INSTANCE, 30, null) + " !", complianceError.getErrorSeverity().getRulesetErrorSeverity(), uniqueContainer, unique);
        }
        this.addDeprecationAnnotationErrors(conditional, prefix2 + " contains conditional \"" + conditional.getText() + "\" which", rulesetErrors, uniqueContainer);
    }

    private final void addDeprecationAnnotationErrors(Unique unique, String prefix2, RulesetErrorList rulesetErrors, IHasUniques uniqueContainer) {
        Deprecated deprecationAnnotation = unique.getDeprecationAnnotation();
        if (deprecationAnnotation != null) {
            String replacementUniqueText = unique.getReplacementText(this.ruleset);
            String deprecationText = prefix2 + " is deprecated " + deprecationAnnotation.message() + ',' + (!Intrinsics.areEqual(deprecationAnnotation.replaceWith().expression(), "") ? " replace with \"" + replacementUniqueText + '\"' : "");
            RulesetErrorSeverity severity = deprecationAnnotation.level() == DeprecationLevel.WARNING ? RulesetErrorSeverity.WarningOptionsOnly : RulesetErrorSeverity.Warning;
            rulesetErrors.add(deprecationText, severity, uniqueContainer, unique);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<UniqueComplianceError> getComplianceErrors(Unique unique) {
        if (unique.getType() == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList errorList = new ArrayList();
        Iterator<String> iterator2 = unique.getParams().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            Object v1;
            boolean bl;
            List errorTypesForAcceptableParameters;
            List<UniqueParameterType> acceptableParamTypes;
            String param;
            block12: {
                Iterator $this$mapTo$iv$iv;
                int index = n++;
                param = iterator2.next();
                if (unique.getType().getParameterTypeMap().size() != unique.getParams().size()) {
                    throw new Exception("Unique " + unique.getText() + " has " + unique.getParams().size() + " parameters, but its type " + (Object)((Object)unique.getType()) + " only " + unique.getType().getParameterTypeMap().size() + " parameters?!");
                }
                Intrinsics.checkNotNullExpressionValue(unique.getType().getParameterTypeMap().get(index), "unique.type.parameterTypeMap[index]");
                Iterable $this$map$iv = acceptableParamTypes;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator3 = $this$mapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    void it;
                    Object item$iv$iv = iterator3.next();
                    UniqueParameterType uniqueParameterType = (UniqueParameterType)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this.getParamTypeErrorSeverityCached((UniqueParameterType)it, param));
                }
                errorTypesForAcceptableParameters = (List)destination$iv$iv;
                Iterable $this$any$iv = errorTypesForAcceptableParameters;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    $this$mapTo$iv$iv = $this$any$iv.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        Object element$iv = $this$mapTo$iv$iv.next();
                        UniqueType.UniqueParameterErrorSeverity it = (UniqueType.UniqueParameterErrorSeverity)((Object)element$iv);
                        boolean bl3 = false;
                        if (!(it == null)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl || errorTypesForAcceptableParameters.contains((Object)UniqueType.UniqueParameterErrorSeverity.PossibleFilteringUnique) && this.allUniqueParameters.contains(param)) continue;
            Iterable $this$minByOrNull$iv = errorTypesForAcceptableParameters;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    UniqueType.UniqueParameterErrorSeverity it = (UniqueType.UniqueParameterErrorSeverity)((Object)minElem$iv);
                    boolean bl4 = false;
                    UniqueType.UniqueParameterErrorSeverity uniqueParameterErrorSeverity = it;
                    Intrinsics.checkNotNull((Object)uniqueParameterErrorSeverity);
                    int minValue$iv = uniqueParameterErrorSeverity.ordinal();
                    do {
                        Object e$iv = iterator$iv.next();
                        UniqueType.UniqueParameterErrorSeverity it2 = (UniqueType.UniqueParameterErrorSeverity)((Object)e$iv);
                        $i$a$-minByOrNull-UniqueValidator$getComplianceErrors$leastSevereWarning$1 = false;
                        UniqueType.UniqueParameterErrorSeverity uniqueParameterErrorSeverity2 = it2;
                        Intrinsics.checkNotNull((Object)uniqueParameterErrorSeverity2);
                        int v$iv = uniqueParameterErrorSeverity2.ordinal();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v1);
            UniqueType.UniqueParameterErrorSeverity leastSevereWarning = v1;
            ((Collection)errorList).add(new UniqueComplianceError(param, acceptableParamTypes, leastSevereWarning));
        }
        return errorList;
    }

    private final UniqueType.UniqueParameterErrorSeverity getParamTypeErrorSeverityCached(UniqueParameterType uniqueParameterType, String param) {
        if (!this.paramTypeErrorSeverityCache.containsKey((Object)uniqueParameterType)) {
            ((Map)this.paramTypeErrorSeverityCache).put(uniqueParameterType, new HashMap());
        }
        HashMap<String, UniqueType.UniqueParameterErrorSeverity> hashMap = this.paramTypeErrorSeverityCache.get((Object)uniqueParameterType);
        Intrinsics.checkNotNull(hashMap);
        HashMap<String, UniqueType.UniqueParameterErrorSeverity> uniqueParamCache = hashMap;
        if (uniqueParamCache.containsKey(param)) {
            return uniqueParamCache.get(param);
        }
        UniqueType.UniqueParameterErrorSeverity severity = uniqueParameterType.getErrorSeverity(param, this.ruleset);
        ((Map)uniqueParamCache).put(param, severity);
        return severity;
    }

    private final RulesetErrorList checkUntypedUnique(Unique unique, boolean tryFixUnknownUniques, IHasUniques uniqueContainer, String prefix2) {
        RulesetErrorList fixes;
        char it;
        char element$iv;
        int n;
        CharSequence $this$count$iv = unique.getText();
        boolean $i$f$count = false;
        int count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            if (!(it == '<')) continue;
            ++count$iv;
        }
        $this$count$iv = unique.getText();
        int n2 = count$iv;
        $i$f$count = false;
        count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            if (!(it == '>')) continue;
            ++count$iv;
        }
        int n3 = count$iv;
        if (n2 != n3) {
            return RulesetErrorList.Companion.of(prefix2 + " contains mismatched conditional braces!", RulesetErrorSeverity.Warning, this.ruleset, uniqueContainer, unique);
        }
        if (this.isFilteringUniqueAllowed(unique)) {
            return new RulesetErrorList(null, 1, null);
        }
        if (tryFixUnknownUniques && !((Collection)(fixes = this.tryFixUnknownUnique(unique, uniqueContainer, prefix2))).isEmpty()) {
            return fixes;
        }
        return RulesetErrorList.Companion.of(prefix2 + " not found in Unciv's unique types, and is not used as a filtering unique.", unique.getParams().isEmpty() ? RulesetErrorSeverity.OK : RulesetErrorSeverity.Warning, this.ruleset, uniqueContainer, unique);
    }

    private final boolean isFilteringUniqueAllowed(Unique unique) {
        if (!((Collection)unique.getConditionals()).isEmpty() || !((Collection)unique.getParams()).isEmpty()) {
            return false;
        }
        return this.allUniqueParameters.contains(unique.getText());
    }

    /*
     * WARNING - void declaration
     */
    private final RulesetErrorList tryFixUnknownUnique(Unique unique, IHasUniques uniqueContainer, String prefix2) {
        RulesetErrorList rulesetErrorList;
        void $this$filterTo$iv$iv;
        UniqueType it;
        void $this$filterTo$iv$iv2;
        UniqueType[] $this$filter$iv = UniqueType.values();
        boolean $i$f$filter = false;
        UniqueType[] uniqueTypeArray = $this$filter$iv;
        Iterable<void> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = element$iv$iv;
            boolean bl = false;
            boolean bl2 = TextSimilarityKt.getRelativeTextDistance(it.getPlaceholderText(), unique.getPlaceholderText()) <= RulesetCache.INSTANCE.getUniqueMisspellingThreshold();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List similarUniques = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = similarUniques;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (UniqueType)((Object)element$iv$iv);
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getPlaceholderText(), unique.getPlaceholderText())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List equalUniques = (List)destination$iv$iv2;
        if (!((Collection)equalUniques).isEmpty()) {
            rulesetErrorList = RulesetErrorList.Companion.of(prefix2 + " looks like it should be fine, but for some reason isn't recognized.", RulesetErrorSeverity.OK, this.ruleset, uniqueContainer, unique);
        } else if (!((Collection)similarUniques).isEmpty()) {
            String text2 = prefix2 + " looks like it may be a misspelling of:\n" + StringsKt.prependIndent(CollectionsKt.joinToString$default(similarUniques, "\n", null, null, 0, null, new Function1<UniqueType, CharSequence>(unique){
                final /* synthetic */ Unique $unique;
                {
                    this.$unique = $unique;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull UniqueType uniqueType) {
                    Intrinsics.checkNotNullParameter((Object)((Object)uniqueType), "uniqueType");
                    String text2 = '\"' + uniqueType.getText();
                    if (!((Collection)this.$unique.getConditionals()).isEmpty()) {
                        text2 = text2 + ' ' + CollectionsKt.joinToString$default(this.$unique.getConditionals(), " ", null, null, 0, null, tryFixUnknownUnique.text.1.INSTANCE, 30, null);
                    }
                    text2 = text2 + '\"';
                    if (uniqueType.getDeprecationAnnotation() != null) {
                        text2 = text2 + " (Deprecated)";
                    }
                    return text2;
                }
            }, 30, null), "\t");
            rulesetErrorList = RulesetErrorList.Companion.of(text2, RulesetErrorSeverity.OK, this.ruleset, uniqueContainer, unique);
        } else {
            rulesetErrorList = new RulesetErrorList(null, 1, null);
        }
        return rulesetErrorList;
    }

    private static final String checkUnique$lambda$8(Lazy<String> $prefix$delegate) {
        Lazy<String> lazy = $prefix$delegate;
        return lazy.getValue();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/models/ruleset/validation/UniqueValidator$Companion;", "", "()V", "getUniqueContainerPrefix", "", "uniqueContainer", "Lcom/unciv/models/ruleset/unique/IHasUniques;", "getUniqueContainerPrefix$core", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getUniqueContainerPrefix$core(@Nullable IHasUniques uniqueContainer) {
            return (uniqueContainer instanceof IRulesetObject ? ((IRulesetObject)uniqueContainer).getOriginRuleset() + ": " : "") + (uniqueContainer == null ? "The" : '(' + uniqueContainer.getUniqueTarget().name() + ") " + uniqueContainer.getName() + "'s") + " unique ";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

