/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.translations;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.models.SpyAction;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Event;
import com.unciv.models.ruleset.GlobalUniques;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.Quest;
import com.unciv.models.ruleset.RuinReward;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.Specialist;
import com.unciv.models.ruleset.Speed;
import com.unciv.models.ruleset.Tutorial;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.CityStateType;
import com.unciv.models.ruleset.nation.Difficulty;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.TechColumn;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueFlag;
import com.unciv.models.ruleset.unique.UniqueParameterType;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.ruleset.unit.UnitType;
import com.unciv.models.translations.TranslationEntry;
import com.unciv.models.translations.TranslationFileReader;
import com.unciv.models.translations.TranslationFileWriter;
import com.unciv.models.translations.Translations;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import java.io.File;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e`\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0002J\"\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\u00130\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0006\u0010\u0018\u001a\u00020\u000eJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J8\u0010!\u001a\u00020\u001a2\"\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000e`\u000f2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0006\u0010#\u001a\u00020\u0004J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010%\u001a\u00020\u001a*\u0012\u0012\u0004\u0012\u00020\u00040&j\b\u0012\u0004\u0012\u00020\u0004`'2\u0006\u0010(\u001a\u00020\u0004H\u0002J \u0010)\u001a\u00020\u001a*\u00060*j\u0002`+2\u0006\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004H\u0002J\f\u0010.\u001a\u00020\u0004*\u00020/H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/unciv/models/translations/TranslationFileWriter;", "", "()V", "fastlanePath", "", "fullDescriptionFile", "fullDescriptionKey", "languageFileLocation", "shortDescriptionFile", "shortDescriptionKey", "specialNewLineCode", "templateFileLocation", "generateTranslationFiles", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "translations", "Lcom/unciv/models/translations/Translations;", "modFolder", "Lcom/badlogic/gdx/files/FileHandle;", "baseTranslations", "getFileHandle", "kotlin.jvm.PlatformType", "fileLocation", "getGeneratedStringsSize", "updateFastlaneChangelog", "", "writeFastlaneFiles", "fileName", "translationEntry", "Lcom/unciv/models/translations/TranslationEntry;", "endWithNewline", "", "writeLanguagePercentages", "percentages", "writeNewTranslationFiles", "writeTranslatedFastlaneFiles", "addNumberedParameter", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "name", "appendTranslation", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "key", "value", "getTranslatable", "Lcom/unciv/models/ruleset/unique/UniqueType;", "GenerateStringsFromJSONs", "core"})
@SourceDebugExtension(value={"SMAP\nTranslationFileWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationFileWriter.kt\ncom/unciv/models/translations/TranslationFileWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,591:1\n1549#2:592\n1620#2,3:593\n819#2:596\n847#2,2:597\n819#2:599\n847#2,2:600\n1774#2,4:603\n603#3:602\n37#4,2:607\n*S KotlinDebug\n*F\n+ 1 TranslationFileWriter.kt\ncom/unciv/models/translations/TranslationFileWriter\n*L\n123#1:592\n123#1:593,3\n224#1:596\n224#1:597,2\n225#1:599\n225#1:600,2\n269#1:603,4\n259#1:602\n280#1:607,2\n*E\n"})
public final class TranslationFileWriter {
    @NotNull
    public static final TranslationFileWriter INSTANCE = new TranslationFileWriter();
    @NotNull
    private static final String specialNewLineCode = "# This is an empty line ";
    @NotNull
    public static final String templateFileLocation = "jsons/translations/template.properties";
    @NotNull
    private static final String languageFileLocation = "jsons/translations/%s.properties";
    @NotNull
    private static final String shortDescriptionKey = "Fastlane_short_description";
    @NotNull
    private static final String shortDescriptionFile = "short_description.txt";
    @NotNull
    private static final String fullDescriptionKey = "Fastlane_full_description";
    @NotNull
    private static final String fullDescriptionFile = "full_description.txt";
    @NotNull
    private static final String fastlanePath = "../../fastlane/metadata/android/";

    private TranslationFileWriter() {
    }

    @NotNull
    public final String writeNewTranslationFiles() {
        try {
            Translations translations = new Translations();
            translations.readAllLanguagesTranslation();
            String fastlaneOutput = "";
            if (INSTANCE.getClass().getPackage().getSpecificationVersion() == null) {
                HashMap percentages = TranslationFileWriter.generateTranslationFiles$default(this, translations, null, null, 6, null);
                TranslationFileWriter.writeLanguagePercentages$default(this, percentages, null, 2, null);
                fastlaneOutput = '\n' + this.writeTranslatedFastlaneFiles(translations);
            }
            for (Map.Entry entry : ((Map)translations.getModsWithTranslations$core()).entrySet()) {
                String modName = (String)entry.getKey();
                Translations modTranslations = (Translations)entry.getValue();
                FileHandle modFolder = Gdx.files.local("mods").child(modName);
                HashMap<String, Integer> modPercentages = this.generateTranslationFiles(modTranslations, modFolder, translations);
                this.writeLanguagePercentages(modPercentages, modFolder);
            }
            return TranslationsKt.tr$default("Translation files are generated successfully.", false, 1, null) + fastlaneOutput;
        }
        catch (Throwable ex) {
            Log.INSTANCE.error("Failed to generate translation files", ex);
            String string = ex.getLocalizedMessage();
            if (string == null) {
                String string2 = ex.getClass().getSimpleName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "ex.javaClass.simpleName");
            }
            return string;
        }
    }

    private final FileHandle getFileHandle(FileHandle modFolder, String fileLocation) {
        FileHandle fileHandle = modFolder;
        return fileHandle != null ? fileHandle.child(fileLocation) : Gdx.files.local(fileLocation);
    }

    /*
     * WARNING - void declaration
     */
    private final HashMap<String, Integer> generateTranslationFiles(Translations translations, FileHandle modFolder, Translations baseTranslations) {
        Object object;
        CharSequence it;
        String string;
        LinkedHashMap fileNameToGeneratedStrings = new LinkedHashMap();
        List linesToTranslate = new ArrayList();
        if (modFolder == null) {
            int n;
            FileHandle templateFile = this.getFileHandle(null, templateFileLocation);
            if (templateFile.exists()) {
                Reader reader = templateFile.reader(TranslationFileReader.INSTANCE.getCharset());
                Intrinsics.checkNotNullExpressionValue(reader, "templateFile.reader(TranslationFileReader.charset)");
                linesToTranslate.addAll((Collection)TextStreamsKt.readLines(reader));
            }
            ((Collection)linesToTranslate).add("\n\n#################### Lines from Unique Types #######################\n");
            UniqueType[] uniqueTypeArray = UniqueType.values();
            int n2 = uniqueTypeArray.length;
            for (n = 0; n < n2; ++n) {
                UniqueType uniqueType = uniqueTypeArray[n];
                Deprecated deprecationAnnotation = uniqueType.getDeprecationAnnotation();
                if (deprecationAnnotation != null || uniqueType.getFlags().contains((Object)UniqueFlag.HiddenToUsers)) continue;
                ((Collection)linesToTranslate).add(this.getTranslatable(uniqueType) + " = ");
            }
            UniqueParameterType[] uniqueParameterTypeArray = UniqueParameterType.values();
            int n3 = uniqueParameterTypeArray.length;
            for (n = 0; n < n3; ++n) {
                void $this$mapTo$iv$iv;
                Iterator $this$map$iv;
                UniqueParameterType uniqueParameterType = uniqueParameterTypeArray[n];
                Set<String> strings = uniqueParameterType.getTranslationWriterStringsForOutput();
                if (strings.isEmpty()) continue;
                ((Collection)linesToTranslate).add("\n######### " + uniqueParameterType.getDisplayName() + " ###########\n");
                Iterable iterable = strings;
                List list2 = linesToTranslate;
                boolean $i$f$map = false;
                void var14_61 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (String[] item$iv$iv : $this$mapTo$iv$iv) {
                    string = (String)item$iv$iv;
                    Object object2 = destination$iv$iv;
                    boolean bl2 = false;
                    object2.add((String)it + " = ");
                }
                list2.addAll((List)destination$iv$iv);
            }
            UniqueTarget[] uniqueTargetArray = UniqueTarget.values();
            int n4 = uniqueTargetArray.length;
            for (n = 0; n < n4; ++n) {
                UniqueTarget uniqueTarget = uniqueTargetArray[n];
                ((Collection)linesToTranslate).add((Object)((Object)uniqueTarget) + " = ");
            }
            ((Collection)linesToTranslate).add("\n\n#################### Lines from spy actions #######################\n");
            SpyAction[] spyActionArray = SpyAction.values();
            int n5 = spyActionArray.length;
            for (n = 0; n < n5; ++n) {
                SpyAction spyAction = spyActionArray[n];
                ((Collection)linesToTranslate).add(spyAction.getDisplayString() + " = ");
            }
            ((Collection)linesToTranslate).add("\n\n#################### Lines from diplomatic modifiers #######################\n");
            DiplomaticModifiers[] diplomaticModifiersArray = DiplomaticModifiers.values();
            int n6 = diplomaticModifiersArray.length;
            for (n = 0; n < n6; ++n) {
                DiplomaticModifiers diplomaticModifiers = diplomaticModifiersArray[n];
                ((Collection)linesToTranslate).add(diplomaticModifiers.getText() + " = ");
            }
            ((Collection)linesToTranslate).add("\n\n#################### Lines from key bindings #######################\n");
            KeyboardBinding.Category[] categoryArray = KeyboardBinding.Category.values();
            int n7 = categoryArray.length;
            for (n = 0; n < n7; ++n) {
                KeyboardBinding.Category category = categoryArray[n];
                ((Collection)linesToTranslate).add(category.getLabel() + " = ");
            }
            KeyboardBinding[] keyboardBindingArray = KeyboardBinding.values();
            int n8 = keyboardBindingArray.length;
            for (n = 0; n < n8; ++n) {
                KeyboardBinding keyboardBinding = keyboardBindingArray[n];
                ((Collection)linesToTranslate).add(keyboardBinding.getLabel() + " = ");
            }
            for (BaseRuleset baseRuleset : BaseRuleset.values()) {
                FileHandle fileHandle = Gdx.files.local("jsons/" + baseRuleset.getFullName());
                Intrinsics.checkNotNullExpressionValue(fileHandle, "files.local(\"jsons/${baseRuleset.fullName}\")");
                GenerateStringsFromJSONs generatedStringsFromBaseRuleset = new GenerateStringsFromJSONs(fileHandle, null, 2, null);
                for (Map.Entry entry : ((Map)generatedStringsFromBaseRuleset).entrySet()) {
                    ((Map)fileNameToGeneratedStrings).put((String)entry.getKey() + " from " + baseRuleset.getFullName(), entry.getValue());
                }
            }
            FileHandle fileHandle = Gdx.files.local("jsons");
            Intrinsics.checkNotNullExpressionValue(fileHandle, "files.local(\"jsons\")");
            GenerateStringsFromJSONs generateStringsFromJSONs = new GenerateStringsFromJSONs(fileHandle, generateTranslationFiles.tutorialStrings.1.INSTANCE);
            object = fileNameToGeneratedStrings;
            String string2 = "Tutorials";
            Collection<Set<String>> collection = generateStringsFromJSONs.values();
            Intrinsics.checkNotNullExpressionValue(collection, "tutorialStrings.values");
            Object t = CollectionsKt.first((Iterable)collection);
            Intrinsics.checkNotNullExpressionValue(t, "tutorialStrings.values.first()");
            Object t2 = t;
            object.put(string2, t2);
        } else {
            FileHandle fileHandle = modFolder.child("jsons");
            Intrinsics.checkNotNullExpressionValue(fileHandle, "modFolder.child(\"jsons\")");
            fileNameToGeneratedStrings.putAll(new GenerateStringsFromJSONs(fileHandle, null, 2, null));
        }
        for (Map.Entry entry : ((Map)fileNameToGeneratedStrings).entrySet()) {
            String key = (String)entry.getKey();
            Set set2 = (Set)entry.getValue();
            if (set2.isEmpty()) continue;
            ((Collection)linesToTranslate).add("\n#################### Lines from " + key + " ####################\n");
            linesToTranslate.addAll(set2);
        }
        fileNameToGeneratedStrings.clear();
        int countOfTranslatableLines = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        object = translations.getLanguages().iterator();
        boolean bl = false;
        while (object.hasNext()) {
            Object line22;
            void var9_34;
            void var10_52 = var9_34++;
            String language = (String)object.next();
            int translationsOfThisLanguage = 0;
            StringBuilder stringBuilder = new StringBuilder();
            HashSet<String> existingTranslationKeys = new HashSet<String>();
            for (Object line22 : linesToTranslate) {
                String string3;
                TranslationEntry existingTranslation;
                String hashMapKey;
                String string4;
                String string5;
                String[] item$iv$iv;
                if (!StringsKt.contains$default((CharSequence)line22, " = ", false, 2, null)) {
                    if (StringsKt.startsWith$default((String)line22, specialNewLineCode, false, 2, null)) {
                        Intrinsics.checkNotNullExpressionValue(stringBuilder.append('\n'), "append('\\n')");
                        continue;
                    }
                    StringBuilder stringBuilder2 = stringBuilder.append((String)line22);
                    Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(value)");
                    Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append('\\n')");
                    continue;
                }
                item$iv$iv = new String[]{" = "};
                String translationKey = StringsKt.replace$default((String)StringsKt.split$default((CharSequence)line22, item$iv$iv, false, 0, 6, null).get(0), "\\n", "\n", false, 4, null);
                if (Intrinsics.areEqual(translationKey, "<with a garrison> <for [mapUnitFilter] units> <above [amount] HP> <below [amount] HP> <vs cities> <vs [mapUnitFilter] units> <when fighting in [tileFilter] tiles> <when attacking> <when defending> <if this city has at least [amount] specialists> <when at war> <when not at war> <while the empire is happy> <during a Golden Age> <during the [era]> <starting from the [era]> <before the [era]> <with [techOrPolicy]> <without [techOrPolicy]>")) {
                    string5 = "<with a garrison> <for [mapUnitFilter] units> <above [amount] HP> <below [amount] HP> <vs cities> <vs [mapUnitFilter] units> <when fighting in [tileFilter] tiles> <when attacking> <when defending> <if this city has at least [amount] specialists> <when at war> <when not at war> <while the empire is happy> <during a Golden Age> <during the [era]> <starting from the [era]> <before the [era]> <with [techOrPolicy]> <without [techOrPolicy]>";
                } else {
                    it = translationKey;
                    Regex bl2 = TranslationsKt.getPointyBraceRegex();
                    string4 = "";
                    it = bl2.replace(it, string4);
                    bl2 = TranslationsKt.getSquareBraceRegex();
                    string4 = "[]";
                    string5 = bl2.replace(it, string4);
                }
                if (existingTranslationKeys.contains(hashMapKey = string5)) continue;
                existingTranslationKeys.add(hashMapKey);
                if (var10_52 == false) {
                    ++countOfTranslatableLines;
                }
                if ((existingTranslation = (TranslationEntry)translations.get((Object)hashMapKey)) != null && ((Map)existingTranslation).containsKey(language)) {
                    ++translationsOfThisLanguage;
                    Object object3 = existingTranslation.get((Object)language);
                    Intrinsics.checkNotNull(object3);
                    string3 = (String)object3;
                } else {
                    HashMap hashMap2 = baseTranslations;
                    if (hashMap2 != null && (hashMap2 = (TranslationEntry)((Translations)hashMap2).get((Object)hashMapKey)) != null ? ((TranslationEntry)hashMap2).containsKey((Object)language) : false) continue;
                    StringBuilder stringBuilder3 = stringBuilder.append(" # Requires translation!");
                    Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(value)");
                    Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append('\\n')");
                    string3 = "";
                }
                string4 = string3;
                Intrinsics.checkNotNullExpressionValue(string4, "if (existingTranslation \u2026     \"\"\n                }");
                String translationValue = string4;
                if (StringsKt.contains$default((CharSequence)translationValue, '[', false, 2, null)) {
                    void $this$filterNotTo$iv$iv;
                    void $this$filterNotTo$iv$iv2;
                    List<String> paramsOfKey = TranslationsKt.getPlaceholderParameters(translationKey);
                    List<String> paramsOfValue = TranslationsKt.getPlaceholderParameters(translationValue);
                    Iterable $this$filterNot$iv = paramsOfKey;
                    boolean $i$f$filterNot = false;
                    Iterable iterable = $this$filterNot$iv;
                    Iterable destination$iv$iv = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
                        String it2 = (String)element$iv$iv;
                        boolean bl3 = false;
                        if (paramsOfValue.contains(it2)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List paramsOfKeyNotInValue = (List)destination$iv$iv;
                    Iterable $this$filterNot$iv2 = paramsOfValue;
                    boolean $i$f$filterNot2 = false;
                    destination$iv$iv = $this$filterNot$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterNotTo2 = false;
                    for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                        String it3 = (String)element$iv$iv;
                        boolean bl4 = false;
                        if (paramsOfKey.contains(it3)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List paramsOfValueNotInKey = (List)destination$iv$iv2;
                    if (paramsOfKeyNotInValue.size() == 1 && paramsOfValueNotInKey.size() == 1) {
                        translationValue = StringsKt.replace$default(translationValue, '[' + (String)CollectionsKt.first(paramsOfValueNotInKey) + ']', '[' + (String)CollectionsKt.first(paramsOfKeyNotInValue) + ']', false, 4, null);
                    }
                }
                this.appendTranslation(stringBuilder, translationKey, translationValue);
            }
            line22 = translationsOfThisLanguage;
            ((Map)hashMap).put(language, line22);
            line22 = languageFileLocation;
            Object object4 = new Object[]{language};
            String string6 = String.format((String)line22, Arrays.copyOf(object4, ((Object[])object4).length));
            Intrinsics.checkNotNullExpressionValue(string6, "format(this, *args)");
            FileHandle fileWriter = this.getFileHandle(modFolder, string6);
            String string7 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string7, "stringBuilder.toString()");
            object4 = string7;
            Regex regex = new Regex("\n{4,}");
            string = "\n\n\n";
            String finalFileText = regex.replace((CharSequence)object4, string);
            fileWriter.writeString(finalFileText, false, TranslationFileReader.INSTANCE.getCharset());
        }
        for (Map.Entry entry : ((Map)hashMap).entrySet()) {
            entry.setValue(countOfTranslatableLines <= 0 ? 100 : ((Number)entry.getValue()).intValue() * 100 / countOfTranslatableLines);
        }
        return hashMap;
    }

    static /* synthetic */ HashMap generateTranslationFiles$default(TranslationFileWriter translationFileWriter, Translations translations, FileHandle fileHandle, Translations translations2, int n, Object object) {
        if ((n & 2) != 0) {
            fileHandle = null;
        }
        if ((n & 4) != 0) {
            translations2 = null;
        }
        return translationFileWriter.generateTranslationFiles(translations, fileHandle, translations2);
    }

    private final void appendTranslation(StringBuilder $this$appendTranslation, String key, String value) {
        StringBuilder stringBuilder = $this$appendTranslation.append(StringsKt.replace$default(key, "\n", "\\n", false, 4, null) + " = " + StringsKt.replace$default(value, "\n", "\\n", false, 4, null));
        Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder.append('\n'), "append('\\n')");
    }

    /*
     * WARNING - void declaration
     */
    private final void writeLanguagePercentages(HashMap<String, Integer> percentages, FileHandle modFolder) {
        void $this$sortedBy$iv;
        Sequence sequence = MapsKt.asSequence((Map)percentages);
        boolean $i$f$sortedBy = false;
        String output2 = SequencesKt.joinToString$default(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)((String)it.getKey())));
            }
        }), "\n", null, "\n", 0, null, writeLanguagePercentages.output.2.INSTANCE, 26, null);
        this.getFileHandle(modFolder, "jsons/translations/completionPercentages.properties").writeString(output2, false);
    }

    static /* synthetic */ void writeLanguagePercentages$default(TranslationFileWriter translationFileWriter, HashMap hashMap, FileHandle fileHandle, int n, Object object) {
        if ((n & 2) != 0) {
            fileHandle = null;
        }
        translationFileWriter.writeLanguagePercentages(hashMap, fileHandle);
    }

    /*
     * WARNING - void declaration
     */
    public final int getGeneratedStringsSize() {
        FileHandle fileHandle = Gdx.files.local("jsons/Civ V - Vanilla");
        Intrinsics.checkNotNullExpressionValue(fileHandle, "files.local(\"jsons/Civ V - Vanilla\")");
        Collection<Set<String>> collection = new GenerateStringsFromJSONs(fileHandle, null, 2, null).values();
        Intrinsics.checkNotNullExpressionValue(collection, "GenerateStringsFromJSONs\u2026Civ V - Vanilla\")).values");
        Iterable iterable = collection;
        int n = 0;
        for (Object t : iterable) {
            int n2;
            void it;
            Set set2 = (Set)t;
            int n3 = n;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            Iterable $this$count$iv = (Iterable)it;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    String line = (String)element$iv;
                    boolean bl2 = false;
                    if (!(!StringsKt.startsWith$default(line, specialNewLineCode, false, 2, null)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int n4 = n2;
            n = n3 + n4;
        }
        return n;
    }

    private final String getTranslatable(UniqueType $this$getTranslatable) {
        ArrayList<String> newPlaceholders = new ArrayList<String>();
        for (String placeholderText : TranslationsKt.getPlaceholderParameters($this$getTranslatable.getText())) {
            this.addNumberedParameter(newPlaceholders, placeholderText);
        }
        Collection $this$toTypedArray$iv = newPlaceholders;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        return TranslationsKt.fillPlaceholders($this$getTranslatable.getText(), Arrays.copyOf(stringArray, stringArray.length));
    }

    private final void addNumberedParameter(ArrayList<String> $this$addNumberedParameter, String name2) {
        if (!$this$addNumberedParameter.contains(name2)) {
            ((Collection)$this$addNumberedParameter).add(name2);
            return;
        }
        int i = 2;
        while ($this$addNumberedParameter.contains(name2 + i)) {
            ++i;
        }
        ((Collection)$this$addNumberedParameter).add(name2 + i);
    }

    private final String writeTranslatedFastlaneFiles(Translations translations) {
        try {
            this.writeFastlaneFiles(shortDescriptionFile, (TranslationEntry)translations.get((Object)shortDescriptionKey), false);
            this.writeFastlaneFiles(fullDescriptionFile, (TranslationEntry)translations.get((Object)fullDescriptionKey), true);
            this.updateFastlaneChangelog();
            return TranslationsKt.tr$default("Fastlane files are generated successfully.", false, 1, null);
        }
        catch (Throwable ex) {
            Log.INSTANCE.error("Failed to generate fastlane files", ex);
            String string = ex.getLocalizedMessage();
            if (string == null) {
                String string2 = ex.getClass().getSimpleName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "ex.javaClass.simpleName");
            }
            return string;
        }
    }

    private final void writeFastlaneFiles(String fileName, TranslationEntry translationEntry, boolean endWithNewline) {
        if (translationEntry == null) {
            return;
        }
        for (Map.Entry entry : ((Map)translationEntry).entrySet()) {
            String language = (String)entry.getKey();
            String translated = (String)entry.getValue();
            String fileContent = endWithNewline && !StringsKt.endsWith$default((CharSequence)translated, '\n', false, 2, null) ? translated + '\n' : (!endWithNewline && StringsKt.endsWith$default((CharSequence)translated, '\n', false, 2, null) ? StringsKt.removeSuffix(translated, (CharSequence)"\n") : translated);
            GameSettings.LocaleCode localeCode = GameSettings.LocaleCode.valueOf(StringsKt.replace$default(language, "_", "", false, 4, null));
            StringBuilder stringBuilder = new StringBuilder().append(fastlanePath);
            String string = localeCode.getTrueLanguage();
            if (string == null) {
                string = localeCode.getLanguage();
            }
            String path = stringBuilder.append(string).toString();
            new File(path).mkdirs();
            FilesKt.writeText$default(new File(path + File.separator + fileName), fileContent, null, 2, null);
        }
    }

    private final void updateFastlaneChangelog() {
        MatchResult latestVersionRegexGroup;
        String changelogFile = FilesKt.readText$default(new File("../../changelog.md"), null, 1, null);
        MatchResult matchResult = latestVersionRegexGroup = Regex.find$default(new Regex("## \\S*([^#]*)"), changelogFile, 0, 2, null);
        Intrinsics.checkNotNull(matchResult);
        MatchGroup matchGroup = matchResult.getGroups().get(1);
        Intrinsics.checkNotNull(matchGroup);
        String versionChangelog = ((Object)StringsKt.trim((CharSequence)matchGroup.getValue())).toString();
        String buildConfigFile = FilesKt.readText$default(new File("../../buildSrc/src/main/kotlin/BuildConfig.kt"), null, 1, null);
        MatchResult matchResult2 = Regex.find$default(new Regex("appCodeNumber = (\\d*)"), buildConfigFile, 0, 2, null);
        Intrinsics.checkNotNull(matchResult2);
        MatchGroup matchGroup2 = matchResult2.getGroups().get(1);
        Intrinsics.checkNotNull(matchGroup2);
        String versionNumber = matchGroup2.getValue();
        String fileName = "../../fastlane/metadata/android//en-US/changelogs/" + versionNumber + ".txt";
        FilesKt.writeText$default(new File(fileName), versionChangelog, null, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 /2*\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001j\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0003`\u0004:\u0001/B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u0002J\u0016\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+J\u0018\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030.0-*\u0006\u0012\u0002\b\u00030.R\u001f\u0010\f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00060\u00060\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u00060"}, d2={"Lcom/unciv/models/translations/TranslationFileWriter$GenerateStringsFromJSONs;", "Ljava/util/LinkedHashMap;", "", "", "Lkotlin/collections/LinkedHashMap;", "jsonsFolder", "Lcom/badlogic/gdx/files/FileHandle;", "fileFilter", "Lkotlin/Function1;", "Ljava/io/File;", "", "(Lcom/badlogic/gdx/files/FileHandle;Lkotlin/jvm/functions/Function1;)V", "listOfJSONFiles", "", "kotlin.jvm.PlatformType", "getListOfJSONFiles", "()Ljava/util/List;", "resultStrings", "getResultStrings", "()Ljava/util/Set;", "setResultStrings", "(Ljava/util/Set;)V", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "startMillis", "", "getStartMillis", "()J", "uniqueIndexOfNewLine", "", "getUniqueIndexOfNewLine", "()I", "setUniqueIndexOfNewLine", "(I)V", "serializeElement", "", "element", "", "submitString", "string", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "allSupers", "Lkotlin/sequences/Sequence;", "Ljava/lang/Class;", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nTranslationFileWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationFileWriter.kt\ncom/unciv/models/translations/TranslationFileWriter$GenerateStringsFromJSONs\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,591:1\n6442#2:592\n1#3:593\n1295#4,2:594\n2624#5,3:596\n2624#5,3:599\n37#6,2:602\n*S KotlinDebug\n*F\n+ 1 TranslationFileWriter.kt\ncom/unciv/models/translations/TranslationFileWriter$GenerateStringsFromJSONs\n*L\n308#1:592\n345#1:594,2\n369#1:596,3\n381#1:599,3\n384#1:602,2\n*E\n"})
    private static final class GenerateStringsFromJSONs
    extends LinkedHashMap<String, Set<String>> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Ruleset ruleset;
        private final long startMillis;
        private int uniqueIndexOfNewLine;
        @NotNull
        private final List<FileHandle> listOfJSONFiles;
        public Set<String> resultStrings;
        @NotNull
        private static final Set<String> untranslatableFieldSet;
        @NotNull
        private static final Set<String> translatableEnumsSet;
        @NotNull
        private static final Set<UniqueParameterType> translatableUniqueParameterTypes;
        @NotNull
        private static final Set<String> fieldsToProcessParameters;

        public GenerateStringsFromJSONs(@NotNull FileHandle jsonsFolder, @NotNull Function1<? super File, Boolean> fileFilter) {
            String string;
            Intrinsics.checkNotNullParameter(jsonsFolder, "jsonsFolder");
            Intrinsics.checkNotNullParameter(fileFilter, "fileFilter");
            this.ruleset = RulesetCache.INSTANCE.getVanillaRuleset();
            this.startMillis = System.currentTimeMillis();
            FileHandle[] fileHandleArray = jsonsFolder.list(arg_0 -> GenerateStringsFromJSONs.listOfJSONFiles$lambda$0(fileFilter, arg_0));
            Intrinsics.checkNotNullExpressionValue(fileHandleArray, "jsonsFolder\n            .list(fileFilter)");
            Object[] $this$sortedBy$iv = fileHandleArray;
            boolean $i$f$sortedBy = false;
            this.listOfJSONFiles = ArraysKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    FileHandle it = (FileHandle)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.name());
                    it = (FileHandle)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.name()));
                }
            });
            for (FileHandle jsonFile : this.listOfJSONFiles) {
                Class javaClass;
                String filename = jsonFile.nameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue(filename, "filename");
                if (GenerateStringsFromJSONs.Companion.getJavaClassByName(filename) == null) continue;
                Json json = UncivJsonKt.json();
                String string2 = jsonFile.path();
                Intrinsics.checkNotNullExpressionValue(string2, "jsonFile.path()");
                Object array = UncivJsonKt.fromJsonFile(json, javaClass, string2);
                this.setResultStrings(new LinkedHashSet());
                ((Map)this).put(filename, this.getResultStrings());
                if (!(array instanceof Object[])) continue;
                Object[] objectArray = (Object[])array;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object element;
                    Object object = element = objectArray[i];
                    Intrinsics.checkNotNull(object);
                    this.serializeElement(object);
                    int n2 = this.uniqueIndexOfNewLine;
                    this.uniqueIndexOfNewLine = n2 + 1;
                    this.getResultStrings().add("# This is an empty line  " + n2);
                }
            }
            if (!Intrinsics.areEqual(jsonsFolder.name(), "jsons")) {
                string = jsonsFolder.name();
            } else {
                CharSequence charSequence;
                CharSequence charSequence2 = jsonsFolder.parent().name();
                if (charSequence2.length() == 0) {
                    boolean bl = false;
                    charSequence = "Tutorials";
                } else {
                    charSequence = charSequence2;
                }
                string = (String)charSequence;
            }
            String displayName = string;
            Object[] objectArray = new Object[]{System.currentTimeMillis() - this.startMillis, displayName};
            LogKt.debug("Translation writer took %sms for %s", objectArray);
        }

        public /* synthetic */ GenerateStringsFromJSONs(FileHandle fileHandle, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                function1 = 1.INSTANCE;
            }
            this(fileHandle, function1);
        }

        @NotNull
        public final Ruleset getRuleset() {
            return this.ruleset;
        }

        public final long getStartMillis() {
            return this.startMillis;
        }

        public final int getUniqueIndexOfNewLine() {
            return this.uniqueIndexOfNewLine;
        }

        public final void setUniqueIndexOfNewLine(int n) {
            this.uniqueIndexOfNewLine = n;
        }

        @NotNull
        public final List<FileHandle> getListOfJSONFiles() {
            return this.listOfJSONFiles;
        }

        @NotNull
        public final Set<String> getResultStrings() {
            Set<String> set2 = this.resultStrings;
            if (set2 != null) {
                return set2;
            }
            Intrinsics.throwUninitializedPropertyAccessException("resultStrings");
            return null;
        }

        public final void setResultStrings(@NotNull Set<String> set2) {
            Intrinsics.checkNotNullParameter(set2, "<set-?>");
            this.resultStrings = set2;
        }

        public final void submitString(@NotNull String string) {
            Sequence matches;
            Intrinsics.checkNotNullParameter(string, "string");
            if (((CharSequence)string).length() == 0) {
                return;
            }
            if (StringsKt.contains$default((CharSequence)string, '{', false, 2, null) && SequencesKt.any(matches = Regex.findAll$default(TranslationsKt.getCurlyBraceRegex(), string, 0, 2, null))) {
                Sequence $this$forEach$iv = matches;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    MatchResult it = (MatchResult)element$iv;
                    boolean bl = false;
                    MatchGroup matchGroup = it.getGroups().get(1);
                    Intrinsics.checkNotNull(matchGroup);
                    this.submitString(matchGroup.getValue());
                }
                return;
            }
            this.getResultStrings().add(string + " = ");
        }

        public final void submitString(@NotNull String string, @NotNull Unique unique) {
            Intrinsics.checkNotNullParameter(string, "string");
            Intrinsics.checkNotNullParameter(unique, "unique");
            if (unique.isHiddenToUsers()) {
                return;
            }
            String stringToTranslate = TranslationsKt.removeConditionals(string);
            for (Unique conditional : unique.getConditionals()) {
                this.submitString(conditional.getText(), conditional);
            }
            if (unique.getParams().isEmpty()) {
                this.submitString(stringToTranslate);
                return;
            }
            if (unique.getType() != null) {
                Iterator<Object> iterator2 = unique.getType().getParameterTypeMap().iterator();
                int n = 0;
                while (iterator2.hasNext()) {
                    boolean bl;
                    int index;
                    block12: {
                        index = n++;
                        List typeList = (List)iterator2.next();
                        Iterable $this$none$iv = typeList;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                UniqueParameterType it = (UniqueParameterType)((Object)element$iv);
                                boolean bl2 = false;
                                if (!translatableUniqueParameterTypes.contains((Object)it)) continue;
                                bl = false;
                                break block12;
                            }
                            bl = true;
                        }
                    }
                    if (bl) continue;
                    this.getResultStrings().add(unique.getParams().get(index) + " = ");
                }
                this.getResultStrings().add(INSTANCE.getTranslatable(unique.getType()) + " = ");
                return;
            }
            ArrayList parameterNames = new ArrayList();
            for (String parameter : unique.getParams()) {
                boolean bl;
                block13: {
                    String parameterName = UniqueParameterType.Companion.guessTypeForTranslationWriter(parameter, this.ruleset).getParameterName();
                    INSTANCE.addNumberedParameter(parameterNames, parameterName);
                    Iterable $this$none$iv = translatableUniqueParameterTypes;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            UniqueParameterType it = (UniqueParameterType)((Object)element$iv);
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(it.getParameterName(), parameterName)) continue;
                            bl = false;
                            break block13;
                        }
                        bl = true;
                    }
                }
                if (bl) continue;
                this.getResultStrings().add(parameter + " = ");
            }
            Collection $this$toTypedArray$iv = parameterNames;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            this.getResultStrings().add(TranslationsKt.fillPlaceholders(stringToTranslate, Arrays.copyOf(stringArray, stringArray.length)) + " = ");
        }

        @NotNull
        public final Sequence<Class<?>> allSupers(@NotNull Class<?> $this$allSupers) {
            Intrinsics.checkNotNullParameter($this$allSupers, "<this>");
            return SequencesKt.sequence(new Function2<SequenceScope<? super Class<?>>, Continuation<? super Unit>, Object>($this$allSupers, this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Class<?> $this_allSupers;
                final /* synthetic */ GenerateStringsFromJSONs this$0;
                {
                    this.$this_allSupers = $receiver;
                    this.this$0 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            if (Intrinsics.areEqual(this.$this_allSupers, Object.class)) {
                                return Unit.INSTANCE;
                            }
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yield(this.$this_allSupers, this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl18
                        }
                        case 1: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl18:
                            // 2 sources

                            if (this.$this_allSupers.getSuperclass() != null) {
                                var3_4 = this.$this_allSupers.getSuperclass();
                                Intrinsics.checkNotNullExpressionValue(var3_4, "superclass");
                                this.L$0 = null;
                                this.label = 2;
                                v1 = $this$sequence.yieldAll(this.this$0.allSupers(var3_4), (Continuation<Unit>)this);
                                if (v1 == var4_2) {
                                    return var4_2;
                                }
                            }
                            ** GOTO lbl30
                        }
                        case 2: {
                            ResultKt.throwOnFailure($result);
                            v1 = $result;
lbl30:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<SequenceScope<? super Class<?>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)((Object)function2);
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super Class<?>> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        public final void serializeElement(@NotNull Object element) {
            Intrinsics.checkNotNullParameter(element, "element");
            if (element instanceof String) {
                this.submitString((String)element);
                return;
            }
            Field[] fieldArray = element.getClass().getFields();
            Intrinsics.checkNotNullExpressionValue(fieldArray, "element.javaClass.fields");
            Sequence<Object> allFields2 = SequencesKt.plus(ArraysKt.asSequence((Object[])fieldArray), SequencesKt.flatMap(this.allSupers(element.getClass()), serializeElement.allFields.1.INSTANCE));
            Sequence<Object> relevantFields2 = SequencesKt.distinct(SequencesKt.filter(allFields2, serializeElement.relevantFields.1.INSTANCE));
            Iterator<Object> iterator2 = relevantFields2.iterator();
            while (iterator2.hasNext()) {
                Field field2 = (Field)iterator2.next();
                field2.setAccessible(true);
                Object fieldValue = field2.get(element);
                Class<?> clazz = element.getClass();
                Intrinsics.checkNotNullExpressionValue(field2, "field");
                if (!GenerateStringsFromJSONs.Companion.isFieldTranslatable(clazz, field2, fieldValue) || element instanceof Tutorial && Intrinsics.areEqual(field2.getName(), "name") && ((Tutorial)element).getUniques().contains(UniqueType.HiddenFromCivilopedia.getPlaceholderText())) continue;
                if (fieldsToProcessParameters.contains(field2.getName()) && fieldValue instanceof AbstractCollection) {
                    for (Object item : (AbstractCollection)fieldValue) {
                        if (item instanceof String) {
                            this.submitString((String)item, new Unique((String)item, null, null, 6, null));
                            continue;
                        }
                        Object e = item;
                        Intrinsics.checkNotNull(e);
                        this.serializeElement(e);
                    }
                    continue;
                }
                if (fieldValue instanceof AbstractCollection) {
                    for (Object item : (AbstractCollection)fieldValue) {
                        if (item instanceof String) {
                            this.submitString((String)item);
                            continue;
                        }
                        Object e = item;
                        Intrinsics.checkNotNull(e);
                        this.serializeElement(e);
                    }
                    continue;
                }
                if (fieldValue instanceof List) {
                    for (Object item : (List)fieldValue) {
                        if (item instanceof String) {
                            this.submitString((String)item);
                            continue;
                        }
                        Object e = item;
                        Intrinsics.checkNotNull(e);
                        this.serializeElement(e);
                    }
                    continue;
                }
                if (element instanceof Promotion && Intrinsics.areEqual(field2.getName(), "name")) {
                    this.submitString(fieldValue.toString(), new Unique(fieldValue.toString(), null, null, 6, null));
                    continue;
                }
                this.submitString(fieldValue.toString());
            }
        }

        private static final boolean listOfJSONFiles$lambda$0(Function1 $tmp0, File p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        static {
            Object[] objectArray = new String[]{"aiFreeTechs", "aiFreeUnits", "attackSound", "building", "cannotBeBuiltWith", "cultureBuildings", "excludedDifficulties", "improvement", "improvingTech", "obsoleteTech", "occursOn", "prerequisites", "promotions", "providesFreeBuilding", "replaces", "requiredBuilding", "requiredBuildingInAllCities", "requiredNearbyImprovedResources", "requiredResource", "requiredTech", "requires", "revealedBy", "startBias", "techRequired", "terrainsCanBeBuiltOn", "terrainsCanBeFoundOn", "turnsInto", "uniqueTo", "upgradesTo", "link", "icon", "extraImage", "color", "RuinReward.uniques", "TerrainType.name", "CityStateType.friendBonusUniques", "CityStateType.allyBonusUniques", "Era.citySound", "keyShortcut", "Event.name"};
            untranslatableFieldSet = SetsKt.setOf(objectArray);
            translatableEnumsSet = SetsKt.setOf("BeliefType");
            objectArray = new UniqueParameterType[]{UniqueParameterType.Unknown, UniqueParameterType.Comment};
            translatableUniqueParameterTypes = SetsKt.setOf(objectArray);
            objectArray = new String[]{"uniques", "promotions", "milestones", "triggeredUniques", "conditions"};
            fieldsToProcessParameters = SetsKt.setOf(objectArray);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002J&\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0002J\u0014\u0010\u0013\u001a\u00020\u000e2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/unciv/models/translations/TranslationFileWriter$GenerateStringsFromJSONs$Companion;", "", "()V", "fieldsToProcessParameters", "", "", "translatableEnumsSet", "translatableUniqueParameterTypes", "Lcom/unciv/models/ruleset/unique/UniqueParameterType;", "untranslatableFieldSet", "getJavaClassByName", "Ljava/lang/Class;", "name", "isFieldTranslatable", "", "clazz", "field", "Ljava/lang/reflect/Field;", "fieldValue", "isFieldTypeRelevant", "type", "core"})
        @SourceDebugExtension(value={"SMAP\nTranslationFileWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranslationFileWriter.kt\ncom/unciv/models/translations/TranslationFileWriter$GenerateStringsFromJSONs$Companion\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,591:1\n26#2:592\n26#2:593\n26#2:594\n26#2:595\n26#2:596\n26#2:597\n26#2:598\n26#2:599\n26#2:600\n26#2:601\n26#2:602\n26#2:603\n26#2:604\n26#2:605\n26#2:606\n26#2:607\n26#2:608\n26#2:609\n26#2:610\n26#2:611\n26#2:612\n26#2:613\n*S KotlinDebug\n*F\n+ 1 TranslationFileWriter.kt\ncom/unciv/models/translations/TranslationFileWriter$GenerateStringsFromJSONs$Companion\n*L\n508#1:592\n509#1:593\n510#1:594\n511#1:595\n512#1:596\n513#1:597\n515#1:598\n516#1:599\n517#1:600\n518#1:601\n519#1:602\n520#1:603\n521#1:604\n522#1:605\n523#1:606\n524#1:607\n525#1:608\n526#1:609\n527#1:610\n528#1:611\n529#1:612\n530#1:613\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            private final boolean isFieldTypeRelevant(Class<?> type2) {
                return Intrinsics.areEqual(type2, String.class) || Intrinsics.areEqual(type2, ArrayList.class) || Intrinsics.areEqual(type2, List.class) || Intrinsics.areEqual(type2, HashSet.class) || type2.isEnum();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean isFieldTranslatable(Class<?> clazz, Field field2, Object fieldValue) {
                if (fieldValue == null) return false;
                if (Intrinsics.areEqual(fieldValue, "")) return false;
                if (field2.getType().isEnum()) {
                    if (!translatableEnumsSet.contains(field2.getType().getSimpleName())) return false;
                }
                if (untranslatableFieldSet.contains(field2.getName())) return false;
                Set set2 = untranslatableFieldSet;
                StringBuilder stringBuilder = new StringBuilder();
                Class<?> clazz2 = clazz.getComponentType();
                if (clazz2 == null || (clazz2 = clazz2.getSimpleName()) == null) {
                    clazz2 = clazz.getSimpleName();
                }
                if (set2.contains(stringBuilder.append((String)((Object)clazz2)).append('.').append(field2.getName()).toString())) return false;
                return true;
            }

            private final Class<Object> getJavaClassByName(String name2) {
                Class<?> clazz;
                switch (name2) {
                    case "Beliefs": {
                        boolean $i$f$emptyArray = false;
                        clazz = new Belief[0].getClass();
                        break;
                    }
                    case "Buildings": {
                        boolean $i$f$emptyArray = false;
                        clazz = new Building[0].getClass();
                        break;
                    }
                    case "CityStateTypes": {
                        boolean $i$f$emptyArray = false;
                        clazz = new CityStateType[0].getClass();
                        break;
                    }
                    case "Difficulties": {
                        boolean $i$f$emptyArray = false;
                        clazz = new Difficulty[0].getClass();
                        break;
                    }
                    case "Eras": {
                        boolean $i$f$emptyArray = false;
                        clazz = new Era[0].getClass();
                        break;
                    }
                    case "Events": {
                        boolean $i$f$emptyArray = false;
                        clazz = new Event[0].getClass();
                        break;
                    }
                    case "GlobalUniques": {
                        clazz = new GlobalUniques().getClass();
                        break;
                    }
                    case "Nations": {
                        boolean $i$f$emptyArray = false;
                        clazz = new Nation[0].getClass();
                        break;
                    }
                    case "Policies": {
                        boolean $i$f$emptyArray = false;
                        clazz = new PolicyBranch[0].getClass();
                        break;
                    }
                    case "Quests": {
                        boolean $i$f$emptyArray = false;
                        clazz = new Quest[0].getClass();
                        break;
                    }
                    case "Religions": {
                        boolean $i$f$emptyArray = false;
                        clazz = new String[0].getClass();
                        break;
                    }
                    case "Ruins": {
                        boolean $i$f$emptyArray = false;
                        clazz = new RuinReward[0].getClass();
                        break;
                    }
                    case "Specialists": {
                        boolean $i$f$emptyArray = false;
                        clazz = new Specialist[0].getClass();
                        break;
                    }
                    case "Speeds": {
                        boolean $i$f$emptyArray = false;
                        clazz = new Speed[0].getClass();
                        break;
                    }
                    case "Techs": {
                        boolean $i$f$emptyArray = false;
                        clazz = new TechColumn[0].getClass();
                        break;
                    }
                    case "Terrains": {
                        boolean $i$f$emptyArray = false;
                        clazz = new Terrain[0].getClass();
                        break;
                    }
                    case "TileImprovements": {
                        boolean $i$f$emptyArray = false;
                        clazz = new TileImprovement[0].getClass();
                        break;
                    }
                    case "TileResources": {
                        boolean $i$f$emptyArray = false;
                        clazz = new TileResource[0].getClass();
                        break;
                    }
                    case "Tutorials": {
                        boolean $i$f$emptyArray = false;
                        clazz = new Tutorial[0].getClass();
                        break;
                    }
                    case "UnitPromotions": {
                        boolean $i$f$emptyArray = false;
                        clazz = new Promotion[0].getClass();
                        break;
                    }
                    case "Units": {
                        boolean $i$f$emptyArray = false;
                        clazz = new BaseUnit[0].getClass();
                        break;
                    }
                    case "UnitTypes": {
                        boolean $i$f$emptyArray = false;
                        clazz = new UnitType[0].getClass();
                        break;
                    }
                    case "VictoryTypes": {
                        boolean $i$f$emptyArray = false;
                        clazz = new Victory[0].getClass();
                        break;
                    }
                    default: {
                        clazz = null;
                    }
                }
                return clazz;
            }

            public static final /* synthetic */ boolean access$isFieldTypeRelevant(Companion $this, Class type2) {
                return $this.isFieldTypeRelevant(type2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

