/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.translations;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.translations.TranslationEntry;
import com.unciv.models.translations.TranslationFileReader;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 /2\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0004:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0005J4\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00022\"\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002`\bH\u0002J6\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00022\u001c\b\u0002\u0010\u001e\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001fj\n\u0012\u0004\u0012\u00020\u0002\u0018\u0001` J\u000e\u0010!\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0002J\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0012j\b\u0012\u0004\u0012\u00020\u0002`\u0013J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020$H\u0002J\u000e\u0010%\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0002J4\u0010&\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00022\u001c\b\u0002\u0010\u001e\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001fj\n\u0012\u0004\u0012\u00020\u0002\u0018\u0001` J\u0006\u0010'\u001a\u00020\u0019J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u0002J\u0006\u0010*\u001a\u00020\u0019J\u000e\u0010+\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u0002J\u000e\u0010,\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020\u0002J\u0006\u0010-\u001a\u00020\u0019J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0002R6\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0000`\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR6\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e`\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR*\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0012j\b\u0012\u0004\u0012\u00020\u0002`\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u00060"}, d2={"Lcom/unciv/models/translations/Translations;", "Ljava/util/LinkedHashMap;", "", "Lcom/unciv/models/translations/TranslationEntry;", "Lkotlin/collections/LinkedHashMap;", "()V", "modsWithTranslations", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getModsWithTranslations$core", "()Ljava/util/HashMap;", "setModsWithTranslations$core", "(Ljava/util/HashMap;)V", "percentCompleteOfLanguages", "", "getPercentCompleteOfLanguages", "setPercentCompleteOfLanguages", "translationActiveMods", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getTranslationActiveMods", "()Ljava/util/LinkedHashSet;", "setTranslationActiveMods", "(Ljava/util/LinkedHashSet;)V", "createTranslations", "", "language", "languageTranslations", "get", "text", "activeMods", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getConditionalOrder", "getLanguages", "getLanguagesWithTranslationFile", "", "getSpaceEquivalent", "getText", "loadPercentageCompleteOfLanguages", "placeConditionalsAfterUnique", "", "readAllLanguagesTranslation", "shouldCapitalize", "triggerNotificationEffectBeforeCause", "tryReadTranslationForCurrentLanguage", "tryReadTranslationForLanguage", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nTranslations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Translations.kt\ncom/unciv/models/translations/Translations\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,510:1\n1#2:511\n1#2:522\n1603#3,9:512\n1855#3:521\n1856#3:523\n1612#3:524\n766#3:529\n857#3,2:530\n11335#4:525\n11670#4,3:526\n*S KotlinDebug\n*F\n+ 1 Translations.kt\ncom/unciv/models/translations/Translations\n*L\n100#1:522\n100#1:512,9\n100#1:521\n100#1:523\n100#1:524\n166#1:529\n166#1:530,2\n155#1:525\n155#1:526,3\n*E\n"})
public final class Translations
extends LinkedHashMap<String, TranslationEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private HashMap<String, Integer> percentCompleteOfLanguages;
    @NotNull
    private HashMap<String, Translations> modsWithTranslations;
    @NotNull
    private LinkedHashSet<String> translationActiveMods;
    @NotNull
    public static final String englishConditionalOrderingString = "<with a garrison> <for [mapUnitFilter] units> <above [amount] HP> <below [amount] HP> <vs cities> <vs [mapUnitFilter] units> <when fighting in [tileFilter] tiles> <when attacking> <when defending> <if this city has at least [amount] specialists> <when at war> <when not at war> <while the empire is happy> <during a Golden Age> <during the [era]> <starting from the [era]> <before the [era]> <with [techOrPolicy]> <without [techOrPolicy]>";
    @NotNull
    public static final String conditionalUniqueOrderString = "ConditionalsPlacement";
    @NotNull
    public static final String shouldCapitalizeString = "StartWithCapitalLetter";
    @NotNull
    public static final String effectBeforeCause = "EffectBeforeCause";

    /*
     * WARNING - void declaration
     */
    public Translations() {
        void $this$percentCompleteOfLanguages_u24lambda_u240;
        HashMap hashMap;
        HashMap hashMap2 = hashMap = new HashMap();
        Translations translations = this;
        boolean bl = false;
        $this$percentCompleteOfLanguages_u24lambda_u240.put("English", 100);
        translations.percentCompleteOfLanguages = hashMap;
        this.modsWithTranslations = new HashMap();
        this.translationActiveMods = new LinkedHashSet();
    }

    @NotNull
    public final HashMap<String, Integer> getPercentCompleteOfLanguages() {
        return this.percentCompleteOfLanguages;
    }

    public final void setPercentCompleteOfLanguages(@NotNull HashMap<String, Integer> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.percentCompleteOfLanguages = hashMap;
    }

    @NotNull
    public final HashMap<String, Translations> getModsWithTranslations$core() {
        return this.modsWithTranslations;
    }

    public final void setModsWithTranslations$core(@NotNull HashMap<String, Translations> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, "<set-?>");
        this.modsWithTranslations = hashMap;
    }

    @NotNull
    public final LinkedHashSet<String> getTranslationActiveMods() {
        return this.translationActiveMods;
    }

    public final void setTranslationActiveMods(@NotNull LinkedHashSet<String> linkedHashSet) {
        Intrinsics.checkNotNullParameter(linkedHashSet, "<set-?>");
        this.translationActiveMods = linkedHashSet;
    }

    @Nullable
    public final TranslationEntry get(@NotNull String text2, @NotNull String language, @Nullable HashSet<String> activeMods) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(language, "language");
        if (activeMods != null) {
            for (String activeMod : activeMods) {
                Translations modTranslations;
                TranslationEntry translationEntry;
                if (this.modsWithTranslations.get(activeMod) == null) continue;
                TranslationEntry translationEntry2 = translationEntry = (TranslationEntry)modTranslations.get((Object)text2);
                if ((translationEntry2 != null ? (String)translationEntry2.get((Object)language) : null) == null) continue;
                return translationEntry;
            }
        }
        return (TranslationEntry)this.get((Object)text2);
    }

    public static /* synthetic */ TranslationEntry get$default(Translations translations, String string, String string2, HashSet hashSet, int n, Object object) {
        if ((n & 4) != 0) {
            hashSet = null;
        }
        return translations.get(string, string2, hashSet);
    }

    @NotNull
    public final String getText(@NotNull String text2, @NotNull String language, @Nullable HashSet<String> activeMods) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(language, "language");
        TranslationEntry translationEntry = this.get(text2, language, activeMods);
        String string = translationEntry != null ? (String)translationEntry.get((Object)language) : null;
        if (string == null) {
            string = text2;
        }
        return string;
    }

    public static /* synthetic */ String getText$default(Translations translations, String string, String string2, HashSet hashSet, int n, Object object) {
        if ((n & 4) != 0) {
            hashSet = null;
        }
        return translations.getText(string, string2, hashSet);
    }

    @NotNull
    public final LinkedHashSet<String> getLanguages() {
        LinkedHashSet<String> linkedHashSet;
        LinkedHashSet<String> $this$getLanguages_u24lambda_u241 = linkedHashSet = new LinkedHashSet<String>();
        boolean bl = false;
        for (TranslationEntry entry : this.values()) {
            for (String languageName : entry.keySet()) {
                $this$getLanguages_u24lambda_u241.add(languageName);
            }
        }
        return linkedHashSet;
    }

    /*
     * WARNING - void declaration
     */
    private final void tryReadTranslationForLanguage(String language) {
        void $this$mapNotNullTo$iv$iv;
        long translationStart = System.currentTimeMillis();
        String translationFileName = "jsons/translations/" + language + ".properties";
        if (!Gdx.files.internal(translationFileName).exists()) {
            return;
        }
        HashMap languageTranslations = null;
        try {
            FileHandle fileHandle = Gdx.files.internal(translationFileName);
            Intrinsics.checkNotNullExpressionValue(fileHandle, "files.internal(translationFileName)");
            languageTranslations = TranslationFileReader.INSTANCE.read(fileHandle);
        }
        catch (Exception ex) {
            Log.INSTANCE.error("Exception reading translations for " + language, ex);
            return;
        }
        Collection<Ruleset> collection = RulesetCache.INSTANCE.values();
        Intrinsics.checkNotNullExpressionValue(collection, "RulesetCache.values");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FileHandle it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Ruleset it = (Ruleset)element$iv$iv;
            boolean bl2 = false;
            if (it.getFolderLocation() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        for (FileHandle modFolder : (List)destination$iv$iv) {
            FileHandle modTranslationFile = modFolder.child(translationFileName);
            if (!modTranslationFile.exists()) continue;
            Translations translationsForMod = this.modsWithTranslations.get(modFolder.name());
            if (translationsForMod == null) {
                translationsForMod = new Translations();
                destination$iv$iv = this.modsWithTranslations;
                String string = modFolder.name();
                Intrinsics.checkNotNullExpressionValue(string, "modFolder.name()");
                destination$iv$iv.put(string, translationsForMod);
            }
            try {
                Intrinsics.checkNotNullExpressionValue(modTranslationFile, "modTranslationFile");
                translationsForMod.createTranslations(language, (HashMap<String, String>)TranslationFileReader.INSTANCE.read(modTranslationFile));
            }
            catch (Exception ex) {
                Log.INSTANCE.error("Exception reading translations for " + modFolder.name() + ' ' + language, ex);
            }
        }
        this.createTranslations(language, languageTranslations);
        Object[] objectArray = new Object[]{language, System.currentTimeMillis() - translationStart};
        LogKt.debug("Loading translation file for %s - %sms", objectArray);
    }

    private final void createTranslations(String language, HashMap<String, String> languageTranslations) {
        for (Map.Entry translation : ((Map)languageTranslations).entrySet()) {
            String hashKey = StringsKt.contains$default((CharSequence)translation.getKey(), '[', false, 2, null) && !StringsKt.contains$default((CharSequence)translation.getKey(), '<', false, 2, null) ? TranslationsKt.getPlaceholderText((String)translation.getKey()) : (String)translation.getKey();
            TranslationEntry entry = (TranslationEntry)this.get((Object)hashKey);
            if (entry == null) {
                entry = new TranslationEntry((String)translation.getKey());
                ((Map)this).put(hashKey, entry);
            }
            ((Map)entry).put(language, translation.getValue());
        }
    }

    public final void tryReadTranslationForCurrentLanguage() {
        this.tryReadTranslationForLanguage(UncivGame.Companion.getCurrent().getSettings().getLanguage());
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getLanguagesWithTranslationFile() {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        HashSet<String> languages = new HashSet<String>();
        try {
            FileHandle[] fileHandleArray = Gdx.files.internal("jsons/translations").list();
            Intrinsics.checkNotNullExpressionValue(fileHandleArray, "files.internal(\"jsons/translations\").list()");
            for (FileHandle file : fileHandleArray) {
                languages.add(file.nameWithoutExtension());
            }
        }
        catch (Exception ex) {
            Log.INSTANCE.error("Failed to add languages", ex);
        }
        Locale[] localeArray = Locale.getAvailableLocales();
        Intrinsics.checkNotNullExpressionValue(localeArray, "getAvailableLocales()");
        Object[] ex = localeArray;
        HashSet<String> hashSet = languages;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Locale locale = (Locale)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getDisplayName(Locale.ENGLISH));
        }
        hashSet.addAll((List)destination$iv$iv);
        languages.add("Simplified_Chinese");
        languages.add("Traditional_Chinese");
        languages.remove("template");
        languages.remove("completionPercentages");
        languages.remove("Thai");
        Iterable $this$filter$iv = languages;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!Gdx.files.internal("jsons/translations/" + it + ".properties").exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void readAllLanguagesTranslation() {
        long translationStart = System.currentTimeMillis();
        for (String language : this.getLanguagesWithTranslationFile()) {
            this.tryReadTranslationForLanguage(language);
        }
        Object[] objectArray = new Object[]{System.currentTimeMillis() - translationStart};
        LogKt.debug("Loading translation files - %sms", objectArray);
    }

    public final void loadPercentageCompleteOfLanguages() {
        long startTime = System.currentTimeMillis();
        this.percentCompleteOfLanguages = TranslationFileReader.INSTANCE.readLanguagePercentages();
        Object[] objectArray = new Object[]{System.currentTimeMillis() - startTime};
        LogKt.debug("Loading percent complete of languages - %sms", objectArray);
    }

    @NotNull
    public final String getConditionalOrder(@NotNull String language) {
        Intrinsics.checkNotNullParameter(language, "language");
        return this.getText(englishConditionalOrderingString, language, null);
    }

    public final boolean placeConditionalsAfterUnique(@NotNull String language) {
        Intrinsics.checkNotNullParameter(language, "language");
        TranslationEntry translationEntry = this.get(conditionalUniqueOrderString, language, null);
        return !Intrinsics.areEqual(translationEntry != null ? (String)translationEntry.get((Object)language) : null, "before");
    }

    @NotNull
    public final String getSpaceEquivalent(@NotNull String language) {
        Intrinsics.checkNotNullParameter(language, "language");
        String translation = this.getText("\" \"", language, null);
        String string = translation.substring(1, translation.length() - 1);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    public final boolean shouldCapitalize(@NotNull String language) {
        Intrinsics.checkNotNullParameter(language, "language");
        Object object = this.get(shouldCapitalizeString, language, null);
        return object != null && (object = (String)((TranslationEntry)object).get((Object)language)) != null ? Boolean.parseBoolean((String)object) : true;
    }

    public final boolean triggerNotificationEffectBeforeCause(@NotNull String language) {
        Intrinsics.checkNotNullParameter(language, "language");
        Object object = this.get(effectBeforeCause, language, null);
        return object != null && (object = (String)((TranslationEntry)object).get((Object)language)) != null ? Boolean.parseBoolean((String)object) : true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/unciv/models/translations/Translations$Companion;", "", "()V", "conditionalUniqueOrderString", "", "effectBeforeCause", "englishConditionalOrderingString", "shouldCapitalizeString", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

