/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.unciv.GUI;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.input.KeyboardBindings;
import com.unciv.ui.components.widgets.ColorMarkupLabel;
import com.unciv.ui.screens.basescreen.BaseScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 4*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003456B]\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n\u0012\u0012\b\u0002\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J4\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00072\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J4\u0010%\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u0007H\u0002J\u0018\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u0007H\u0002J\u0010\u0010,\u001a\u00020\u001e2\b\b\u0002\u0010-\u001a\u00020\fJ\u0010\u0010.\u001a\u00020\u001e2\b\b\u0002\u0010-\u001a\u00020\fJ\u0010\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u0018H\u0002J2\u00101\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u0007H\u0016J\u0014\u00103\u001a\u00020\n*\u00020\u00022\u0006\u0010)\u001a\u00020\u0007H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/unciv/ui/components/UncivTooltip;", "T", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lcom/badlogic/gdx/scenes/scene2d/InputListener;", "target", "content", "targetAlign", "", "tipAlign", "offset", "Lcom/badlogic/gdx/math/Vector2;", "animate", "", "forceContentSize", "contentRefresher", "Lkotlin/Function0;", "(Lcom/badlogic/gdx/scenes/scene2d/Actor;Lcom/badlogic/gdx/scenes/scene2d/Actor;IILcom/badlogic/gdx/math/Vector2;ZLcom/badlogic/gdx/math/Vector2;Lkotlin/jvm/functions/Function0;)V", "container", "Lcom/badlogic/gdx/scenes/scene2d/ui/Container;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "contentHeight", "", "contentWidth", "<set-?>", "Lcom/unciv/ui/components/UncivTooltip$TipState;", "state", "getState", "()Lcom/unciv/ui/components/UncivTooltip$TipState;", "touchDownSeen", "enter", "", "event", "Lcom/badlogic/gdx/scenes/scene2d/InputEvent;", "x", "y", "pointer", "fromActor", "exit", "toActor", "getOriginX", "width", "align", "getOriginY", "height", "hide", "immediate", "show", "startShowAction", "endState", "touchDown", "button", "getEdgePoint", "Companion", "ShowAction", "TipState", "core"})
public final class UncivTooltip<T extends Actor>
extends InputListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Actor target;
    @NotNull
    private final T content;
    private final int targetAlign;
    private final int tipAlign;
    @NotNull
    private final Vector2 offset;
    private final boolean animate;
    @Nullable
    private final Function0<Vector2> contentRefresher;
    @NotNull
    private final Container<T> container;
    @NotNull
    private TipState state;
    private boolean touchDownSeen;
    private float contentWidth;
    private float contentHeight;
    private static final float tipAnimationDuration = 0.2f;

    public UncivTooltip(@NotNull Actor target, @NotNull T content2, int targetAlign, int tipAlign, @NotNull Vector2 offset, boolean animate, @Nullable Vector2 forceContentSize, @Nullable Function0<? extends Vector2> contentRefresher2) {
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(content2, "content");
        Intrinsics.checkNotNullParameter(offset, "offset");
        this.target = target;
        this.content = content2;
        this.targetAlign = targetAlign;
        this.tipAlign = tipAlign;
        this.offset = offset;
        this.animate = animate;
        this.contentRefresher = contentRefresher2;
        this.container = new Container<T>(this.content);
        this.state = TipState.Hidden;
        ((Actor)this.content).setTouchable(Touchable.disabled);
        this.container.pack();
        Vector2 vector2 = forceContentSize;
        this.contentWidth = vector2 != null ? vector2.x : ((Actor)this.content).getWidth();
        Vector2 vector22 = forceContentSize;
        this.contentHeight = vector22 != null ? vector22.y : ((Actor)this.content).getHeight();
    }

    public /* synthetic */ UncivTooltip(Actor actor, Actor actor2, int n, int n2, Vector2 vector2, boolean bl, Vector2 vector22, Function0 function0, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n = 18;
        }
        if ((n3 & 8) != 0) {
            n2 = 18;
        }
        if ((n3 & 0x10) != 0) {
            Vector2 vector23 = Vector2.Zero;
            Intrinsics.checkNotNullExpressionValue(vector23, "Zero");
            vector2 = vector23;
        }
        if ((n3 & 0x20) != 0) {
            bl = true;
        }
        if ((n3 & 0x40) != 0) {
            vector22 = null;
        }
        if ((n3 & 0x80) != 0) {
            function0 = null;
        }
        this(actor, actor2, n, n2, vector2, bl, vector22, function0);
    }

    @NotNull
    public final TipState getState() {
        return this.state;
    }

    public final void show(boolean immediate) {
        boolean useAnimation;
        if (this.target.getStage() == null) {
            return;
        }
        boolean bl = useAnimation = this.animate && !immediate;
        if (this.state == TipState.Shown || this.state == TipState.Showing && useAnimation || !this.target.hasParent()) {
            return;
        }
        if (this.state == TipState.Showing || this.state == TipState.Hiding) {
            this.container.clearActions();
            this.state = TipState.Hidden;
            this.container.remove();
        }
        if (this.contentRefresher != null) {
            Vector2 forceContentSize = this.contentRefresher.invoke();
            this.container.pack();
            Vector2 vector2 = forceContentSize;
            this.contentWidth = vector2 != null ? vector2.x : ((Actor)this.content).getWidth();
            Vector2 vector22 = forceContentSize;
            this.contentHeight = vector22 != null ? vector22.y : ((Actor)this.content).getHeight();
        }
        Vector2 pos = this.target.localToStageCoordinates(this.getEdgePoint(this.target, this.targetAlign)).add(this.offset);
        Container<T> $this$show_u24lambda_u240 = this.container;
        boolean bl2 = false;
        float originX = this.getOriginX(this.contentWidth, this.tipAlign);
        float originY = this.getOriginY(this.contentHeight, this.tipAlign);
        $this$show_u24lambda_u240.setOrigin(originX, originY);
        $this$show_u24lambda_u240.setPosition(pos.x - originX, pos.y - originY);
        if (useAnimation) {
            $this$show_u24lambda_u240.setTransform(true);
            $this$show_u24lambda_u240.getColor().a = 0.1f;
            $this$show_u24lambda_u240.setScale(0.1f);
        } else {
            $this$show_u24lambda_u240.setTransform(false);
            $this$show_u24lambda_u240.getColor().a = 1.0f;
            $this$show_u24lambda_u240.setScale(1.0f);
        }
        this.target.getStage().addActor(this.container);
        if (useAnimation) {
            this.startShowAction(TipState.Shown);
        } else {
            this.state = TipState.Shown;
        }
    }

    public static /* synthetic */ void show$default(UncivTooltip uncivTooltip, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        uncivTooltip.show(bl);
    }

    public final void hide(boolean immediate) {
        boolean useAnimation;
        boolean bl = useAnimation = this.animate && !immediate;
        if (this.state == TipState.Hidden || this.state == TipState.Hiding && useAnimation) {
            return;
        }
        if (this.state == TipState.Showing || this.state == TipState.Hiding) {
            this.container.clearActions();
            this.state = TipState.Shown;
        }
        if (useAnimation) {
            this.startShowAction(TipState.Hidden);
        } else {
            this.container.remove();
            this.state = TipState.Hidden;
        }
    }

    public static /* synthetic */ void hide$default(UncivTooltip uncivTooltip, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        uncivTooltip.hide(bl);
    }

    private final float getOriginX(float width, int align2) {
        return (align2 & 8) != 0 ? 0.0f : ((align2 & 0x10) != 0 ? width : width / (float)2);
    }

    private final float getOriginY(float height, int align2) {
        return (align2 & 4) != 0 ? 0.0f : ((align2 & 2) != 0 ? height : height / (float)2);
    }

    private final Vector2 getEdgePoint(Actor $this$getEdgePoint, int align2) {
        return new Vector2(this.getOriginX($this$getEdgePoint.getWidth(), align2), this.getOriginY($this$getEdgePoint.getHeight(), align2));
    }

    private final void startShowAction(TipState endState) {
        this.container.clearActions();
        this.container.addAction(new ShowAction(endState));
    }

    @Override
    public void enter(@Nullable InputEvent event, float x, float y, int pointer, @Nullable Actor fromActor) {
        if (fromActor != null && fromActor.isDescendantOf(this.target)) {
            return;
        }
        UncivTooltip.show$default(this, false, 1, null);
    }

    @Override
    public void exit(@Nullable InputEvent event, float x, float y, int pointer, @Nullable Actor toActor) {
        if (!this.touchDownSeen && toActor != null && toActor.isDescendantOf(this.target)) {
            return;
        }
        this.touchDownSeen = false;
        UncivTooltip.hide$default(this, false, 1, null);
    }

    @Override
    public boolean touchDown(@Nullable InputEvent event, float x, float y, int pointer, int button) {
        this.touchDownSeen = true;
        this.container.toFront();
        return super.touchDown(event, x, y, pointer, button);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0004J\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\n\u001a\u00020\u0004J\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\n\u001a\u00020\u0004JV\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00122\u0010\b\u0002\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/unciv/ui/components/UncivTooltip$Companion;", "", "()V", "tipAnimationDuration", "", "addTooltip", "", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "key", "Lcom/unciv/ui/components/input/KeyCharAndCode;", "size", "binding", "Lcom/unciv/ui/components/input/KeyboardBinding;", "char", "", "text", "", "always", "", "targetAlign", "", "tipAlign", "hideIcons", "dynamicTextProvider", "Lkotlin/Function0;", "core"})
    @SourceDebugExtension(value={"SMAP\nUncivTooltip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncivTooltip.kt\ncom/unciv/ui/components/UncivTooltip$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,342:1\n800#2,11:343\n1083#3,2:354\n1099#3,3:356\n*S KotlinDebug\n*F\n+ 1 UncivTooltip.kt\ncom/unciv/ui/components/UncivTooltip$Companion\n*L\n239#1:343,11\n255#1:354,2\n264#1:356,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void addTooltip(@NotNull Actor $this$addTooltip, @NotNull String text2, float size2, boolean always, int targetAlign, int tipAlign, boolean hideIcons, @Nullable Function0<String> dynamicTextProvider) {
            Container<Actor> container;
            boolean bl;
            NinePatchDrawable background;
            Label label2;
            Color labelColor;
            block4: {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter($this$addTooltip, "<this>");
                Intrinsics.checkNotNullParameter(text2, "text");
                DelayedRemovalArray<EventListener> delayedRemovalArray = $this$addTooltip.getListeners();
                Intrinsics.checkNotNullExpressionValue(delayedRemovalArray, "listeners");
                Iterable $this$filterIsInstance$iv = delayedRemovalArray;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof UncivTooltip)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (UncivTooltip tip : (List)destination$iv$iv) {
                    tip.hide(true);
                    $this$addTooltip.removeListener(tip);
                }
                if (!always && !GUI.INSTANCE.getKeyboardAvailable() || ((CharSequence)text2).length() == 0) {
                    return;
                }
                labelColor = BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor();
                label2 = hideIcons ? Scene2dExtensionsKt.toLabel$default(text2, labelColor, 38, 0, true, 4, null) : (Label)new ColorMarkupLabel(text2, labelColor, null, 38, 4, null);
                label2.setAlignment(1);
                background = BaseScreen.Companion.getSkinStrings().getUiBackground("General/Tooltip", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleShape(), Color.LIGHT_GRAY);
                CharSequence $this$any$iv = ",;gjpqy";
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)text2, it, false, 2, null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            float skewPadDescenders = bl ? 0.0f : 2.5f;
            float horizontalPad = text2.length() > 1 ? 10.0f : 6.0f;
            background.setPadding(4.0f + skewPadDescenders, horizontalPad, 8.0f - skewPadDescenders, horizontalPad);
            Container<Actor> $this$addTooltip_u24lambda_u241 = container = new Container<Actor>((Actor)label2);
            boolean bl3 = false;
            $this$addTooltip_u24lambda_u241.setBackground(background);
            $this$addTooltip_u24lambda_u241.setTransform(true);
            Container<Actor> labelWithBackground = container;
            Function0 contentRefresher2 = dynamicTextProvider == null ? null : (Function0)new Function0<Vector2>(dynamicTextProvider, hideIcons, label2, labelColor, labelWithBackground, size2){
                final /* synthetic */ Function0<String> $dynamicTextProvider;
                final /* synthetic */ boolean $hideIcons;
                final /* synthetic */ Label $label;
                final /* synthetic */ Color $labelColor;
                final /* synthetic */ Container<Label> $labelWithBackground;
                final /* synthetic */ float $size;
                {
                    this.$dynamicTextProvider = $dynamicTextProvider;
                    this.$hideIcons = $hideIcons;
                    this.$label = $label;
                    this.$labelColor = $labelColor;
                    this.$labelWithBackground = $labelWithBackground;
                    this.$size = $size;
                    super(0);
                }

                @NotNull
                public final Vector2 invoke() {
                    String newText = this.$dynamicTextProvider.invoke();
                    if (this.$hideIcons) {
                        this.$label.setText(TranslationsKt.tr$default(newText, false, 1, null));
                    } else {
                        Color color = Color.WHITE;
                        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
                        this.$label.setText(ColorMarkupLabel.Companion.prepareText(newText, this.$labelColor, color));
                    }
                    return com.unciv.ui.components.UncivTooltip$Companion.access$addTooltip$scaleContainerAndGetSize(this.$labelWithBackground, this.$size, newText);
                }
            };
            Vector2 vector2 = com.unciv.ui.components.UncivTooltip$Companion.addTooltip$scaleContainerAndGetSize(labelWithBackground, size2, text2);
            Vector2 vector22 = new Vector2(-com.unciv.ui.components.UncivTooltip$Companion.addTooltip$getMultiRowSize(size2, text2) / (float)4, size2 / (float)4);
            $this$addTooltip.addListener(new UncivTooltip($this$addTooltip, labelWithBackground, targetAlign, tipAlign, vector22, false, vector2, contentRefresher2, 32, null));
        }

        public static /* synthetic */ void addTooltip$default(Companion companion, Actor actor, String string, float f, boolean bl, int n, int n2, boolean bl2, Function0 function0, int n3, Object object) {
            if ((n3 & 2) != 0) {
                f = 26.0f;
            }
            if ((n3 & 4) != 0) {
                bl = false;
            }
            if ((n3 & 8) != 0) {
                n = 18;
            }
            if ((n3 & 0x10) != 0) {
                n2 = 2;
            }
            if ((n3 & 0x20) != 0) {
                bl2 = false;
            }
            if ((n3 & 0x40) != 0) {
                function0 = null;
            }
            companion.addTooltip(actor, string, f, bl, n, n2, bl2, function0);
        }

        public final void addTooltip(@NotNull Actor $this$addTooltip, char c, float size2) {
            Intrinsics.checkNotNullParameter($this$addTooltip, "<this>");
            com.unciv.ui.components.UncivTooltip$Companion.addTooltip$default(this, $this$addTooltip, String.valueOf(StringsKt.contains$default((CharSequence)"Ii", c, false, 2, null) ? (char)'i' : (char)Character.toUpperCase(c)), size2, false, 0, 0, false, null, 124, null);
        }

        public static /* synthetic */ void addTooltip$default(Companion companion, Actor actor, char c, float f, int n, Object object) {
            if ((n & 2) != 0) {
                f = 26.0f;
            }
            companion.addTooltip(actor, c, f);
        }

        public final void addTooltip(@NotNull Actor $this$addTooltip, @NotNull KeyCharAndCode key, float size2) {
            Intrinsics.checkNotNullParameter($this$addTooltip, "<this>");
            Intrinsics.checkNotNullParameter(key, "key");
            if (!Intrinsics.areEqual(key, KeyCharAndCode.Companion.getUNKNOWN())) {
                com.unciv.ui.components.UncivTooltip$Companion.addTooltip$default(this, $this$addTooltip, TranslationsKt.tr$default(key.toString(), false, 1, null), size2, false, 0, 0, false, null, 124, null);
            }
        }

        public static /* synthetic */ void addTooltip$default(Companion companion, Actor actor, KeyCharAndCode keyCharAndCode, float f, int n, Object object) {
            if ((n & 2) != 0) {
                f = 26.0f;
            }
            companion.addTooltip(actor, keyCharAndCode, f);
        }

        public final void addTooltip(@NotNull Actor $this$addTooltip, @NotNull KeyboardBinding binding, float size2) {
            Intrinsics.checkNotNullParameter($this$addTooltip, "<this>");
            Intrinsics.checkNotNullParameter((Object)binding, "binding");
            com.unciv.ui.components.UncivTooltip$Companion.addTooltip$default(this, $this$addTooltip, com.unciv.ui.components.UncivTooltip$Companion.addTooltip$getText(binding), size2, false, 0, 0, false, new Function0<String>(binding){
                final /* synthetic */ KeyboardBinding $binding;
                {
                    this.$binding = $binding;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return com.unciv.ui.components.UncivTooltip$Companion.access$addTooltip$getText(this.$binding);
                }
            }, 60, null);
        }

        public static /* synthetic */ void addTooltip$default(Companion companion, Actor actor, KeyboardBinding keyboardBinding, float f, int n, Object object) {
            if ((n & 2) != 0) {
                f = 26.0f;
            }
            companion.addTooltip(actor, keyboardBinding, f);
        }

        /*
         * WARNING - void declaration
         */
        private static final float addTooltip$getMultiRowSize(float $size, String text2) {
            void $this$count$iv;
            CharSequence charSequence = text2;
            int n = 1;
            float f = $size;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            int n2 = count$iv;
            return f * (float)(n + n2);
        }

        private static final Vector2 addTooltip$scaleContainerAndGetSize(Container<Label> labelWithBackground, float $size, String text2) {
            float multiRowSize = com.unciv.ui.components.UncivTooltip$Companion.addTooltip$getMultiRowSize($size, text2);
            Container<Label> $this$addTooltip_u24scaleContainerAndGetSize_u24lambda_u243 = labelWithBackground;
            boolean bl = false;
            $this$addTooltip_u24scaleContainerAndGetSize_u24lambda_u243.pack();
            $this$addTooltip_u24scaleContainerAndGetSize_u24lambda_u243.setScale(1.0f);
            float ratio = $this$addTooltip_u24scaleContainerAndGetSize_u24lambda_u243.getWidth() / $this$addTooltip_u24scaleContainerAndGetSize_u24lambda_u243.getHeight();
            $this$addTooltip_u24scaleContainerAndGetSize_u24lambda_u243.setScale(multiRowSize / $this$addTooltip_u24scaleContainerAndGetSize_u24lambda_u243.getHeight());
            float widthHeightRatio = ratio;
            return new Vector2(multiRowSize * widthHeightRatio, multiRowSize);
        }

        private static final String addTooltip$getText(KeyboardBinding $binding) {
            return TranslationsKt.tr$default(KeyboardBindings.Companion.get($binding).toString(), false, 1, null);
        }

        public static final /* synthetic */ Vector2 access$addTooltip$scaleContainerAndGetSize(Container labelWithBackground, float $size, String text2) {
            return com.unciv.ui.components.UncivTooltip$Companion.addTooltip$scaleContainerAndGetSize(labelWithBackground, $size, text2);
        }

        public static final /* synthetic */ String access$addTooltip$getText(KeyboardBinding $binding) {
            return com.unciv.ui.components.UncivTooltip$Companion.addTooltip$getText($binding);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0007H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/components/UncivTooltip$ShowAction;", "Lcom/badlogic/gdx/scenes/scene2d/actions/TemporalAction;", "endState", "Lcom/unciv/ui/components/UncivTooltip$TipState;", "(Lcom/unciv/ui/components/UncivTooltip;Lcom/unciv/ui/components/UncivTooltip$TipState;)V", "transitionState", "valueAdd", "", "valueMul", "end", "", "update", "percent", "core"})
    private final class ShowAction
    extends TemporalAction {
        @NotNull
        private final TipState endState;
        @NotNull
        private final TipState transitionState;
        private final float valueAdd;
        private final float valueMul;

        public ShowAction(TipState endState) {
            Intrinsics.checkNotNullParameter((Object)endState, "endState");
            super(0.2f, Interpolation.fade);
            this.endState = endState;
            if (this.endState == TipState.Shown) {
                this.transitionState = TipState.Showing;
                this.valueAdd = 0.1f;
                this.valueMul = 0.9f;
            } else {
                this.transitionState = TipState.Hiding;
                this.valueAdd = 1.0f;
                this.valueMul = -0.9f;
            }
            UncivTooltip.this.state = this.transitionState;
        }

        @Override
        protected void update(float percent) {
            float value;
            if (!this.target.hasParent()) {
                UncivTooltip.this.hide(true);
                this.finish();
            }
            this.target.getColor().a = value = percent * this.valueMul + this.valueAdd;
            this.target.setScale(value);
        }

        @Override
        protected void end() {
            if (UncivTooltip.this.getState() == this.transitionState) {
                UncivTooltip.this.state = this.endState;
            }
            if (this.endState == TipState.Hidden) {
                this.target.remove();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/components/UncivTooltip$TipState;", "", "(Ljava/lang/String;I)V", "Hidden", "Showing", "Shown", "Hiding", "core"})
    public static final class TipState
    extends Enum<TipState> {
        public static final /* enum */ TipState Hidden = new TipState();
        public static final /* enum */ TipState Showing = new TipState();
        public static final /* enum */ TipState Shown = new TipState();
        public static final /* enum */ TipState Hiding = new TipState();
        private static final /* synthetic */ TipState[] $VALUES;

        public static TipState[] values() {
            return (TipState[])$VALUES.clone();
        }

        public static TipState valueOf(String value) {
            return Enum.valueOf(TipState.class, value);
        }

        static {
            $VALUES = tipStateArray = new TipState[]{TipState.Hidden, TipState.Showing, TipState.Shown, TipState.Hiding};
        }
    }
}

