/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.input;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.unciv.models.UncivSound;
import com.unciv.ui.components.input.ActivationActionMap;
import com.unciv.ui.components.input.ActivationListener;
import com.unciv.ui.components.input.ActivationTypes;
import com.unciv.ui.components.input.ActorKeyShortcutDispatcher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J4\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00102\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u00140\u0019j\u0002`\u001aJ\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/unciv/ui/components/input/ActorAttachments;", "", "actor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "(Lcom/badlogic/gdx/scenes/scene2d/Actor;)V", "activationActions", "Lcom/unciv/ui/components/input/ActivationActionMap;", "activationListener", "Lcom/unciv/ui/components/input/ActivationListener;", "getActor", "()Lcom/badlogic/gdx/scenes/scene2d/Actor;", "keyShortcuts", "Lcom/unciv/ui/components/input/ActorKeyShortcutDispatcher;", "getKeyShortcuts", "()Lcom/unciv/ui/components/input/ActorKeyShortcutDispatcher;", "activate", "", "type", "Lcom/unciv/ui/components/input/ActivationTypes;", "addActivationAction", "", "sound", "Lcom/unciv/models/UncivSound;", "noEquivalence", "action", "Lkotlin/Function0;", "Lcom/unciv/ui/components/input/ActivationAction;", "clearActivationActions", "Companion", "core"})
public final class ActorAttachments {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private ActivationActionMap activationActions;
    @Nullable
    private ActivationListener activationListener;
    @NotNull
    private final ActorKeyShortcutDispatcher keyShortcuts;

    private ActorAttachments(Actor actor) {
        this.keyShortcuts = new ActorKeyShortcutDispatcher(actor);
    }

    @NotNull
    public final Actor getActor() {
        return this.keyShortcuts.getActor();
    }

    @NotNull
    public final ActorKeyShortcutDispatcher getKeyShortcuts() {
        return this.keyShortcuts;
    }

    public final boolean activate(@NotNull ActivationTypes type2) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        if (this.activationActions == null) {
            return false;
        }
        Actor actor = this.getActor();
        Disableable disableable = actor instanceof Disableable ? (Disableable)((Object)actor) : null;
        boolean bl = disableable != null ? disableable.isDisabled() : false;
        if (bl) {
            return false;
        }
        ActivationActionMap activationActionMap = this.activationActions;
        if (activationActionMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("activationActions");
            activationActionMap = null;
        }
        return activationActionMap.activate(type2);
    }

    public final void addActivationAction(@NotNull ActivationTypes type2, @NotNull UncivSound sound, boolean noEquivalence, @NotNull Function0<Unit> action2) {
        ActivationActionMap activationActionMap;
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(sound, "sound");
        Intrinsics.checkNotNullParameter(action2, "action");
        if (this.activationActions == null) {
            this.activationActions = new ActivationActionMap();
        } else if (this.activationListener != null) {
            DelayedRemovalArray<EventListener> delayedRemovalArray = this.getActor().getListeners();
            Intrinsics.checkNotNullExpressionValue(delayedRemovalArray, "actor.listeners");
            if (!CollectionsKt.contains((Iterable)delayedRemovalArray, this.activationListener)) {
                this.getActor().addListener(this.activationListener);
                ActivationActionMap activationActionMap2 = this.activationActions;
                if (activationActionMap2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("activationActions");
                    activationActionMap2 = null;
                }
                activationActionMap2.clearGestures();
            }
        }
        if ((activationActionMap = this.activationActions) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("activationActions");
            activationActionMap = null;
        }
        activationActionMap.add(type2, sound, noEquivalence, action2);
        if (!type2.isGesture$core() || this.activationListener != null) {
            return;
        }
        this.activationListener = new ActivationListener();
        this.getActor().addListener(this.activationListener);
    }

    public static /* synthetic */ void addActivationAction$default(ActorAttachments actorAttachments, ActivationTypes activationTypes, UncivSound uncivSound, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            uncivSound = UncivSound.Companion.getClick();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        actorAttachments.addActivationAction(activationTypes, uncivSound, bl, function0);
    }

    public final void clearActivationActions(@NotNull ActivationTypes type2, boolean noEquivalence) {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)type2, "type");
                if (this.activationActions == null) {
                    return;
                }
                ActivationActionMap activationActionMap = this.activationActions;
                if (activationActionMap == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("activationActions");
                    activationActionMap = null;
                }
                activationActionMap.clear(type2, noEquivalence);
                if (this.activationListener == null) break block6;
                ActivationActionMap activationActionMap2 = this.activationActions;
                if (activationActionMap2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("activationActions");
                    activationActionMap2 = null;
                }
                if (!activationActionMap2.isNotEmpty()) break block7;
            }
            return;
        }
        this.getActor().removeListener(this.activationListener);
        this.activationListener = null;
    }

    public static /* synthetic */ void clearActivationActions$default(ActorAttachments actorAttachments, ActivationTypes activationTypes, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        actorAttachments.clearActivationActions(activationTypes, bl);
    }

    public /* synthetic */ ActorAttachments(Actor actor, DefaultConstructorMarker $constructor_marker) {
        this(actor);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/components/input/ActorAttachments$Companion;", "", "()V", "get", "Lcom/unciv/ui/components/input/ActorAttachments;", "actor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getOrNull", "core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ActorAttachments getOrNull(@NotNull Actor actor) {
            Intrinsics.checkNotNullParameter(actor, "actor");
            return (ActorAttachments)actor.getUserObject();
        }

        @NotNull
        public final ActorAttachments get(@NotNull Actor actor) {
            Intrinsics.checkNotNullParameter(actor, "actor");
            if (actor.getUserObject() == null) {
                actor.setUserObject(new ActorAttachments(actor, null));
            }
            ActorAttachments actorAttachments = this.getOrNull(actor);
            Intrinsics.checkNotNull(actorAttachments);
            return actorAttachments;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

