/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.utils.SnapshotArray;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActorAttachments;
import com.unciv.ui.components.input.ActorKeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.input.KeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyShortcutDispatcherVeto;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001BR\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00121\u0010\u0007\u001a-\u0012)\u0012'\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r\u0018\u00010\tj\u0004\u0018\u0001`\u000e0\b\u00a2\u0006\u0002\u0010\u000fJ9\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132'\u0010\u0014\u001a#\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\tj\u0002`\u000eH\u0002J\u001a\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\u0007\u001a-\u0012)\u0012'\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r\u0018\u00010\tj\u0004\u0018\u0001`\u000e0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/unciv/ui/components/input/KeyShortcutListener;", "Lcom/badlogic/gdx/scenes/scene2d/InputListener;", "actors", "Lkotlin/sequences/Sequence;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "additionalShortcuts", "Lcom/unciv/ui/components/input/KeyShortcutDispatcher;", "dispatcherVetoerCreator", "Lkotlin/Function0;", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "associatedActor", "Lcom/unciv/ui/components/input/KeyShortcutDispatcherVeto$DispatcherVetoResult;", "Lcom/unciv/ui/components/input/DispatcherVetoer;", "(Lkotlin/sequences/Sequence;Lcom/unciv/ui/components/input/KeyShortcutDispatcher;Lkotlin/jvm/functions/Function0;)V", "activate", "", "key", "Lcom/unciv/ui/components/input/KeyCharAndCode;", "dispatcherVetoer", "keyDown", "event", "Lcom/badlogic/gdx/scenes/scene2d/InputEvent;", "keycode", "", "core"})
public final class KeyShortcutListener
extends InputListener {
    @NotNull
    private final Sequence<Actor> actors;
    @Nullable
    private final KeyShortcutDispatcher additionalShortcuts;
    @NotNull
    private final Function0<Function1<Actor, KeyShortcutDispatcherVeto.DispatcherVetoResult>> dispatcherVetoerCreator;

    public KeyShortcutListener(@NotNull Sequence<? extends Actor> actors, @Nullable KeyShortcutDispatcher additionalShortcuts, @NotNull Function0<? extends Function1<? super Actor, ? extends KeyShortcutDispatcherVeto.DispatcherVetoResult>> dispatcherVetoerCreator) {
        Intrinsics.checkNotNullParameter(actors, "actors");
        Intrinsics.checkNotNullParameter(dispatcherVetoerCreator, "dispatcherVetoerCreator");
        this.actors = actors;
        this.additionalShortcuts = additionalShortcuts;
        this.dispatcherVetoerCreator = dispatcherVetoerCreator;
    }

    public /* synthetic */ KeyShortcutListener(Sequence sequence, KeyShortcutDispatcher keyShortcutDispatcher, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            keyShortcutDispatcher = null;
        }
        this(sequence, keyShortcutDispatcher, function0);
    }

    @Override
    public boolean keyDown(@Nullable InputEvent event, int keycode) {
        Function1<Actor, KeyShortcutDispatcherVeto.DispatcherVetoResult> dispatcherVetoer;
        KeyCharAndCode key;
        KeyCharAndCode keyCharAndCode;
        if (event == null) {
            keyCharAndCode = KeyCharAndCode.Companion.getUNKNOWN();
        } else {
            Input input2 = Gdx.input;
            Intrinsics.checkNotNullExpressionValue(input2, "input");
            keyCharAndCode = key = Scene2dExtensionsKt.isControlKeyPressed(input2) ? KeyCharAndCode.Companion.ctrlFromCode(event.getKeyCode()) : new KeyCharAndCode(event.getKeyCode());
        }
        if (Intrinsics.areEqual(key, KeyCharAndCode.Companion.getUNKNOWN())) {
            return false;
        }
        Function1<Actor, KeyShortcutDispatcherVeto.DispatcherVetoResult> function1 = this.dispatcherVetoerCreator.invoke();
        if (function1 == null) {
            function1 = KeyShortcutDispatcherVeto.INSTANCE.getDefaultDispatcherVetoer$core();
        }
        if (this.activate(key, dispatcherVetoer = function1)) {
            return true;
        }
        if (Intrinsics.areEqual(key, KeyCharAndCode.Companion.getNUMPAD_ENTER()) && this.activate(KeyCharAndCode.Companion.getRETURN(), dispatcherVetoer) || Intrinsics.areEqual(key, KeyCharAndCode.Companion.getRETURN()) && this.activate(KeyCharAndCode.Companion.getNUMPAD_ENTER(), dispatcherVetoer)) {
            return true;
        }
        return Intrinsics.areEqual(key, KeyCharAndCode.Companion.getESC()) && this.activate(KeyCharAndCode.Companion.getBACK(), dispatcherVetoer) || Intrinsics.areEqual(key, KeyCharAndCode.Companion.getBACK()) && this.activate(KeyCharAndCode.Companion.getESC(), dispatcherVetoer);
    }

    private final boolean activate(KeyCharAndCode key, Function1<? super Actor, ? extends KeyShortcutDispatcherVeto.DispatcherVetoResult> dispatcherVetoer) {
        KeyShortcutDispatcher.Resolver shortcutResolver = new KeyShortcutDispatcher.Resolver(key);
        ArrayDeque pendingActors = new ArrayDeque(SequencesKt.toList(this.actors));
        if (this.additionalShortcuts != null && dispatcherVetoer.invoke(null) == KeyShortcutDispatcherVeto.DispatcherVetoResult.Accept) {
            shortcutResolver.updateFor(this.additionalShortcuts);
        }
        while ((Actor)pendingActors.removeFirstOrNull() != null) {
            Actor actor;
            ActorAttachments actorAttachments = ActorAttachments.Companion.getOrNull(actor);
            ActorKeyShortcutDispatcher shortcuts = actorAttachments != null ? actorAttachments.getKeyShortcuts() : null;
            KeyShortcutDispatcherVeto.DispatcherVetoResult vetoResult = dispatcherVetoer.invoke(actor);
            if (shortcuts != null && vetoResult == KeyShortcutDispatcherVeto.DispatcherVetoResult.Accept) {
                shortcutResolver.updateFor(shortcuts);
            }
            if (!(actor instanceof Group) || vetoResult == KeyShortcutDispatcherVeto.DispatcherVetoResult.SkipWithChildren) continue;
            Collection collection = pendingActors;
            SnapshotArray<Actor> snapshotArray = ((Group)actor).getChildren();
            Intrinsics.checkNotNullExpressionValue(snapshotArray, "actor.children");
            CollectionsKt.addAll(collection, (Iterable)snapshotArray);
        }
        for (Function0<Unit> action2 : shortcutResolver.getTriggeredActions()) {
            action2.invoke();
        }
        return !((Collection)shortcutResolver.getTriggeredActions()).isEmpty();
    }
}

